
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `band_payment_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `band_payment_history` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `band_id` int(10) NOT NULL,
  `paid_amount` double NOT NULL,
  `date` date NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `update_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `band_payment_history` WRITE;
/*!40000 ALTER TABLE `band_payment_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `band_payment_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `cash_register_id` int(11) NOT NULL,
  `u_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `balance` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_transactions` WRITE;
/*!40000 ALTER TABLE `bank_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `branch` varchar(255) NOT NULL,
  `account_no` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_users` WRITE;
/*!40000 ALTER TABLE `bank_users` DISABLE KEYS */;
INSERT INTO `bank_users` VALUES (1,9,'Islami Bank','Dhaka','43000',NULL,'2021-10-26 02:21:32','2021-10-26 02:21:32'),(2,9,'ABC Bank','Shyamoli','45126',NULL,'2021-11-23 16:48:58','2021-11-23 16:48:58'),(3,9,'FIRST SEQURITY ISLAMI BANK','BANASREE','011512200014228',NULL,'2022-02-21 00:25:39','2022-02-21 00:25:39'),(4,9,'FIRST SEQURITY ISLAMI BANK','BANASREE','011512200014228','2022-02-21 00:27:39','2022-02-21 00:27:29','2022-02-21 00:27:39'),(5,9,'bkash','personal','01713082778',NULL,'2022-02-23 07:34:33','2022-02-23 07:34:33'),(6,1,'ISLAMI BANK BANGLADESH LIMITED','MKM','20502670202229807',NULL,'2022-04-05 06:39:31','2022-04-05 06:39:31'),(7,1,'ISLAMI BANK BANGLADESH LIMITED','MKM','20502670100207307',NULL,'2022-04-05 06:43:50','2022-04-05 06:43:50'),(8,9,'Rezwan','personal','019275735',NULL,'2023-03-23 03:18:02','2023-03-23 03:18:29');
/*!40000 ALTER TABLE `bank_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `banking_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banking_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `banking_categories` WRITE;
/*!40000 ALTER TABLE `banking_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `banking_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `paper_width` double(8,2) DEFAULT NULL,
  `paper_height` double(8,2) DEFAULT NULL,
  `top_margin` double(8,2) DEFAULT NULL,
  `left_margin` double(8,2) DEFAULT NULL,
  `row_distance` double(8,2) DEFAULT NULL,
  `col_distance` double(8,2) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.75,1.00,8.50,11.00,0.50,0.50,0.00,0.16,2,0,0,20,NULL,'2017-12-18 11:13:44','2017-12-18 11:13:44'),(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.62,1.00,8.50,11.00,0.50,0.22,0.00,0.14,3,0,0,30,NULL,'2017-12-18 11:04:39','2017-12-18 11:10:40'),(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.00,1.25,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,32,NULL,'2017-12-18 10:55:40','2017-12-18 10:55:40'),(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.00,1.00,8.50,11.00,0.50,0.25,0.00,0.00,4,0,0,40,NULL,'2017-12-18 10:58:40','2017-12-18 10:58:40'),(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.50,1.00,8.50,11.00,0.50,0.50,0.00,0.00,5,0,0,50,NULL,'2017-12-18 10:51:10','2017-12-18 10:51:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.25,1.00,1.25,0.00,0.12,0.00,0.12,0.00,1,0,1,NULL,NULL,'2017-12-18 10:51:10','2017-12-18 10:51:10'),(7,'custom',NULL,2.00,0.50,3.00,1.50,0.00,0.00,0.20,0.00,5,0,0,50,1,'2018-12-17 11:25:57','2018-12-17 11:25:57'),(8,'4G Fashion House',NULL,1.00,0.80,5.00,0.00,0.00,0.00,0.00,0.00,5,1,1,28,9,'2019-05-08 08:35:23','2023-03-23 03:33:34');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` enum('booked','completed','cancelled') NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `paid_amount` double NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,9,'Yellow Basket',NULL,0,36,'2022-01-15 17:40:22','2021-12-04 16:26:47','2022-01-15 17:40:22'),(2,9,'WINNER','KIDS',0,36,NULL,'2022-01-15 17:40:50','2022-01-15 17:40:50'),(3,9,'BAJAJ',NULL,0,36,NULL,'2022-02-21 00:05:03','2022-02-21 00:05:03'),(4,9,'AHK',NULL,0,36,NULL,'2022-02-21 00:05:19','2022-02-21 00:05:19'),(5,9,'CRLF',NULL,0,36,NULL,'2022-02-21 00:05:29','2022-02-21 00:05:29'),(6,9,'Black',NULL,0,36,NULL,'2022-02-22 05:04:58','2022-02-22 05:04:58'),(7,9,'Badsha','Badsha',0,36,NULL,'2022-02-23 05:14:26','2022-02-23 05:14:26'),(8,9,'Al-Hera Pusti','Al-Hera Treading',0,36,NULL,'2022-02-24 03:59:52','2022-02-24 03:59:52'),(9,9,'Desh Bandhu','Hazi Kasem Agro Food',0,36,NULL,'2022-02-24 04:00:56','2022-02-24 04:00:56'),(10,9,'pakija',NULL,0,36,NULL,'2022-03-31 03:08:43','2022-03-31 03:08:43'),(11,9,'walton',NULL,0,36,NULL,'2022-04-12 04:51:10','2022-04-12 04:51:10'),(12,9,'ACI',NULL,0,36,NULL,'2022-04-13 06:55:13','2022-04-13 06:55:13'),(13,9,'চায়না',NULL,0,36,NULL,'2022-06-06 14:20:50','2022-06-06 14:20:50'),(14,9,'চায়না',NULL,0,36,NULL,'2022-06-06 14:50:29','2022-06-06 14:50:29'),(15,9,'LG',NULL,0,36,NULL,'2022-06-29 11:08:10','2022-06-29 11:08:10'),(16,9,'TOPS GALLARY',NULL,0,36,NULL,'2022-06-30 05:52:51','2022-06-30 05:52:51'),(17,9,'Hermizon',NULL,0,36,NULL,'2022-08-30 10:24:38','2022-08-30 10:24:38'),(18,9,'Fresh',NULL,0,36,NULL,'2022-08-30 10:29:13','2022-08-30 10:29:13'),(19,9,'sopno',NULL,0,36,NULL,'2023-03-13 06:08:17','2023-03-13 06:08:17'),(20,9,'missing brand','siamosjid',0,36,NULL,'2023-03-15 17:01:37','2023-03-15 17:01:37'),(21,9,'no 1','siamosjid',0,36,NULL,'2023-03-16 03:59:23','2023-03-16 03:59:23'),(22,9,'my brand',NULL,0,36,NULL,'2023-03-23 03:11:35','2023-03-23 03:11:35'),(23,9,'icon',NULL,0,36,NULL,'2023-03-23 14:35:22','2023-03-23 14:35:22'),(24,9,'roton',NULL,0,36,NULL,'2023-03-29 03:08:12','2023-03-29 03:08:12'),(25,9,'chaiwala',NULL,0,36,NULL,'2023-03-30 03:14:39','2023-03-30 03:14:39');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(256) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(20,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `woocommerce_api_settings` text DEFAULT NULL,
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'Sis Demo',134,'2020-01-01',NULL,'vat',NULL,NULL,NULL,0.00,1,'Asia/Dhaka',1,'fifo',0.00,'includes','/JfB0QXAvFEZBoj3sRHSGi7v0v7mdZ0NrjCCX1xPq.jpeg','AS',1,'add_expiry','stop_selling',1,1,0,NULL,1.000,365,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,1,NULL,1,1,1,1,NULL,1,1,'before','[\"modifiers\",\"transfer_balance\",\"receive_balance\",\"warranty\"]','d-m-Y','12','{\"purchase\":\"PO\",\"purchase_return\":\"PR\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}','purple-light',NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin-restaurant\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-01-04 07:15:19','2023-06-25 22:53:07'),(2,'Awesome Pharmacy',2,'2018-04-10','3412569900','VAT',NULL,NULL,NULL,25.00,4,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AP',1,'add_manufacturing','stop_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,4,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2018-04-10 12:12:40','2018-04-10 14:21:38'),(3,'Ultimate Electronics',2,'2018-04-10','12548555003','GST',NULL,NULL,NULL,25.00,5,'America/Chicago',1,'fifo',NULL,'includes',NULL,'AE',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,0,5,0,0,0,1,'cmsn_agnt',1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-04-10 14:46:15','2018-12-23 16:10:52'),(4,'Awesome Services',134,NULL,'3412569900','GST',NULL,NULL,NULL,0.00,6,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,'AS',0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,0,1,0,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"purchase_return\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}',NULL,NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin-restaurant\",\"mail_password\":\"123456\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2018-04-10 16:20:42','2018-12-22 12:59:33'),(8,'sis2019',134,'2019-04-08',NULL,NULL,NULL,NULL,NULL,25.00,35,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2019-04-08 11:20:34','2019-04-08 11:20:34'),(9,'Soft IT Security',134,'2019-04-22',NULL,NULL,NULL,NULL,NULL,100.00,36,'Asia/Dhaka',1,'fifo',NULL,'includes','/2bw3eA8bG2tG7y8r5iC1rozZvH3vC1tZ3GzycYGd.jpeg',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,365,60,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,1,1,1,1,1,1,35,1,1,1,1,NULL,1,0,'before','[\"modifiers\",\"account\",\"transfer_balance\",\"receive_balance\",\"warranty\"]','m/d/Y','12','{\"purchase\":\"PO\",\"purchase_return\":\"PR\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\"}','purple-light',NULL,'{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null}',1,'2019-04-22 20:06:41','2023-07-19 03:29:12'),(11,'Chowdhury Computer',134,'2021-06-08',NULL,NULL,NULL,NULL,NULL,25.00,43,'Asia/Dhaka',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,1,1,1,1,1,0,NULL,0,0,0,1,NULL,1,0,'before',NULL,'m/d/Y','24','{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,1,'2021-10-27 00:35:53','2021-10-27 00:35:53');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,NULL,'JAMUNA KIOSK','JAMUNA RAILWAY BRIDGE PROJECT','Bangladesh','Dhaka','Dhaka','1212',7,1,1,'browser',NULL,'01711538073','01747040023',NULL,'https://koreanebazar.com',NULL,NULL,NULL,NULL,NULL,'2018-01-04 07:15:20','2021-01-30 06:24:53'),(8,8,'BL0001','sis2019','wwww','bangladesh','dhaka','dhaka','1200',1,1,1,'browser',NULL,'01983772354','','','',NULL,NULL,NULL,NULL,NULL,'2019-04-08 11:20:36','2019-04-08 11:20:36'),(9,9,'BL0001','4G Fashion House','Comilla','Bangladesh','Dhaka','Comilla','8030',10,6,1,'browser',NULL,'01719131305',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2019-04-22 20:06:41','2023-03-16 03:31:52'),(11,11,'BL0001','Chowdhury Computer','Rangunia','Bangladesh','Chittagong','Chittagong','4360',9,8,1,'browser',NULL,'01887985705','01750933584','','',NULL,NULL,NULL,NULL,NULL,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(12,9,'Shekertek','Future Business Vision',NULL,'Bangladesh','Dhaka','Dhaka','1207',6,6,1,'browser',NULL,'01611255545',NULL,'Jakirfbv@gmail.com',NULL,NULL,NULL,NULL,NULL,NULL,'2021-11-20 21:25:58','2021-11-20 21:25:58'),(13,9,'BL0002','4G FASHION HOUSE','Alfat Ali Super Market','BANGLADESH','BRAHMANBARIA','ASHUGANJ','3402',6,6,1,'browser',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-01-15 17:24:01','2022-01-15 17:26:12');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT 0.00,
  `pay_method` enum('cash','card','cheque','bank_transfer','custom_pay_1','custom_pay_2','custom_pay_3','other') DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` enum('initial','sell','transfer','refund') NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `is_due` int(4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1866 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,300.00,'cash','credit','sell',2,NULL,'2021-05-27 16:05:18','2021-05-27 16:05:18'),(2,1,0.00,'cash','credit','sell',2,NULL,'2021-05-27 16:05:18','2021-05-27 16:05:18'),(3,1,0.00,'cash','credit','sell',3,NULL,'2021-05-27 16:10:23','2021-05-27 16:10:23'),(4,1,0.00,'cash','credit','sell',3,NULL,'2021-05-27 16:10:23','2021-05-27 16:10:23'),(5,1,0.00,'cash','credit','sell',4,NULL,'2021-05-27 16:11:12','2021-05-27 16:11:12'),(6,1,0.00,'cash','credit','sell',4,NULL,'2021-05-27 16:11:12','2021-05-27 16:11:12'),(7,6,0.00,'cash','credit','initial',NULL,NULL,'2021-05-28 13:30:51','2021-05-28 13:30:51'),(8,6,17900.00,'cash','credit','sell',6,NULL,'2021-05-28 13:32:23','2021-05-28 13:32:23'),(9,6,0.00,'cash','credit','sell',6,NULL,'2021-05-28 13:32:23','2021-05-28 13:32:23'),(10,6,28000.00,'cash','credit','sell',10,NULL,'2021-05-28 14:07:31','2021-05-28 14:07:31'),(11,6,0.00,'cash','credit','sell',10,NULL,'2021-05-28 14:07:31','2021-05-28 14:07:31'),(12,6,18000.00,'cash','credit','sell',11,NULL,'2021-05-28 14:17:15','2021-05-28 14:17:15'),(13,6,0.00,'cash','credit','sell',11,NULL,'2021-05-28 14:17:15','2021-05-28 14:17:15'),(14,7,41000.00,'cash','credit','initial',NULL,NULL,'2021-05-29 16:01:31','2021-05-29 16:01:31'),(15,7,28000.00,'cash','credit','sell',13,NULL,'2021-05-29 16:21:19','2021-05-29 16:21:19'),(16,7,0.00,'cash','credit','sell',13,NULL,'2021-05-29 16:21:19','2021-05-29 16:21:19'),(17,7,0.00,'cash','credit','sell',14,NULL,'2021-05-29 19:28:31','2021-05-29 19:28:31'),(18,7,0.00,'cash','credit','sell',14,NULL,'2021-05-29 19:28:31','2021-05-29 19:28:31'),(19,7,0.00,'cash','credit','sell',15,NULL,'2021-05-29 19:29:01','2021-05-29 19:29:01'),(20,7,0.00,'cash','credit','sell',15,NULL,'2021-05-29 19:29:01','2021-05-29 19:29:01'),(23,7,0.00,'cash','credit','sell',28,NULL,'2021-06-01 21:46:42','2021-06-01 21:46:42'),(24,7,0.00,'cash','credit','sell',28,NULL,'2021-06-01 21:46:42','2021-06-01 21:46:42'),(25,7,0.00,'cash','credit','sell',30,NULL,'2021-06-01 21:54:29','2021-06-01 21:54:29'),(26,7,0.00,'cash','credit','sell',30,NULL,'2021-06-01 21:54:29','2021-06-01 21:54:29'),(27,7,46000.00,'cash','credit','sell',31,NULL,'2021-06-02 15:50:44','2021-06-02 15:50:44'),(28,7,0.00,'cash','credit','sell',31,NULL,'2021-06-02 15:50:44','2021-06-02 15:50:44'),(29,7,115000.00,'cash','credit','sell',35,NULL,'2021-06-03 15:36:56','2021-06-03 15:36:56'),(30,7,0.00,'cash','credit','sell',35,NULL,'2021-06-03 15:36:56','2021-06-03 15:36:56'),(31,7,23000.00,'cash','credit','sell',37,NULL,'2021-06-03 15:51:08','2021-06-03 15:51:08'),(32,7,0.00,'cash','credit','sell',37,NULL,'2021-06-03 15:51:08','2021-06-03 15:51:08'),(33,7,66750.00,'cash','credit','sell',41,NULL,'2021-06-05 16:07:23','2021-06-05 16:07:23'),(34,7,0.00,'cash','credit','sell',41,NULL,'2021-06-05 16:07:23','2021-06-05 16:07:23'),(35,7,222500.00,'cash','credit','sell',43,NULL,'2021-06-05 16:09:52','2021-06-05 16:09:52'),(36,7,0.00,'cash','credit','sell',43,NULL,'2021-06-05 16:09:52','2021-06-05 16:09:52'),(37,7,133500.00,'cash','credit','sell',44,NULL,'2021-06-05 16:10:06','2021-06-05 16:10:06'),(38,7,0.00,'cash','credit','sell',44,NULL,'2021-06-05 16:10:06','2021-06-05 16:10:06'),(39,7,44500.00,'cash','credit','sell',45,NULL,'2021-06-05 16:10:21','2021-06-05 16:10:21'),(40,7,0.00,'cash','credit','sell',45,NULL,'2021-06-05 16:10:21','2021-06-05 16:10:21'),(41,7,20000.00,'cash','credit','sell',47,NULL,'2021-06-05 16:16:01','2021-06-05 16:16:01'),(42,7,0.00,'cash','credit','sell',47,NULL,'2021-06-05 16:16:01','2021-06-05 16:16:01'),(44,7,4500.00,'cash','credit','sell',47,1,'2021-06-05 16:26:51','2021-06-05 16:26:51'),(45,7,22750.00,'cash','credit','sell',49,NULL,'2021-06-05 16:30:12','2021-06-05 16:30:12'),(46,7,0.00,'cash','credit','sell',49,NULL,'2021-06-05 16:30:12','2021-06-05 16:30:12'),(47,8,50000.00,'cash','credit','initial',NULL,NULL,'2021-06-05 16:33:02','2021-06-05 16:33:02'),(48,8,22250.00,'cash','credit','sell',50,NULL,'2021-06-05 16:33:24','2021-06-05 16:33:24'),(49,8,0.00,'cash','credit','sell',50,NULL,'2021-06-05 16:33:24','2021-06-05 16:33:24'),(50,8,10000.00,'cash','credit','sell',51,NULL,'2021-06-05 16:34:38','2021-06-05 16:34:38'),(51,8,0.00,'cash','credit','sell',51,NULL,'2021-06-05 16:34:38','2021-06-05 16:34:38'),(52,8,15000.00,'cash','credit','sell',47,1,'2021-06-05 16:35:23','2021-06-05 16:35:23'),(53,8,25000.00,'cash','credit','sell',55,NULL,'2021-06-05 17:10:52','2021-06-05 17:10:52'),(54,8,0.00,'cash','credit','sell',55,NULL,'2021-06-05 17:10:52','2021-06-05 17:10:52'),(55,9,0.00,'cash','credit','initial',NULL,NULL,'2021-06-27 16:38:37','2021-06-27 16:38:37'),(56,10,-239522.00,'cash','credit','initial',NULL,NULL,'2021-08-14 21:30:48','2021-08-14 21:30:48'),(57,10,2300.00,'cash','credit','sell',579,NULL,'2021-08-14 21:32:52','2021-08-14 21:32:52'),(58,10,0.00,'cash','credit','sell',579,NULL,'2021-08-14 21:32:52','2021-08-14 21:32:52'),(59,10,0.00,'cash','credit','sell',580,NULL,'2021-08-14 21:41:23','2021-08-14 21:41:23'),(60,10,0.00,'cash','credit','sell',580,NULL,'2021-08-14 21:41:23','2021-08-14 21:41:23'),(61,10,0.00,'cash','credit','sell',581,NULL,'2021-08-14 21:49:15','2021-08-14 21:49:15'),(62,10,0.00,'cash','credit','sell',581,NULL,'2021-08-14 21:49:15','2021-08-14 21:49:15'),(63,10,2130.00,'cash','credit','sell',583,NULL,'2021-08-14 21:54:47','2021-08-14 21:54:47'),(64,10,0.00,'cash','credit','sell',583,NULL,'2021-08-14 21:54:47','2021-08-14 21:54:47'),(65,10,479.00,'cash','credit','sell',584,NULL,'2021-08-14 21:55:03','2021-08-14 21:55:03'),(66,10,0.00,'cash','credit','sell',584,NULL,'2021-08-14 21:55:03','2021-08-14 21:55:03'),(67,11,-233699.00,'cash','credit','initial',NULL,NULL,'2021-08-14 22:06:05','2021-08-14 22:06:05'),(68,12,1000.00,'cash','credit','initial',NULL,NULL,'2021-08-22 15:13:23','2021-08-22 15:13:23'),(69,13,-233699.00,'cash','credit','initial',NULL,NULL,'2021-08-24 22:07:29','2021-08-24 22:07:29'),(70,14,-233699.00,'cash','credit','initial',NULL,NULL,'2021-08-24 22:08:17','2021-08-24 22:08:17'),(71,13,1750.00,'cash','credit','sell',596,NULL,'2021-08-24 22:08:54','2021-08-24 22:08:54'),(72,13,0.00,'cash','credit','sell',596,NULL,'2021-08-24 22:08:54','2021-08-24 22:08:54'),(73,13,5500.00,'cash','credit','sell',597,1,'2021-08-24 22:25:57','2021-08-24 22:25:57'),(75,15,-221679.00,'cash','credit','initial',NULL,NULL,'2021-08-28 18:56:07','2021-08-28 18:56:07'),(76,15,7380.00,'cash','credit','sell',605,NULL,'2021-08-28 18:57:53','2021-08-28 18:57:53'),(77,15,0.00,'cash','credit','sell',605,NULL,'2021-08-28 18:57:53','2021-08-28 18:57:53'),(78,15,0.00,'cash','credit','sell',606,NULL,'2021-08-28 18:59:45','2021-08-28 18:59:45'),(79,15,0.00,'cash','credit','sell',606,NULL,'2021-08-28 18:59:45','2021-08-28 18:59:45'),(80,16,1000.00,'cash','credit','initial',NULL,NULL,'2021-08-28 19:20:16','2021-08-28 19:20:16'),(81,16,48280.00,'cash','credit','sell',609,NULL,'2021-08-28 19:26:24','2021-08-28 19:26:24'),(82,16,0.00,'cash','credit','sell',609,NULL,'2021-08-28 19:26:24','2021-08-28 19:26:24'),(83,16,47480.00,'cash','credit','sell',610,NULL,'2021-08-28 19:29:36','2021-08-28 19:29:36'),(84,16,0.00,'cash','credit','sell',610,NULL,'2021-08-28 19:29:36','2021-08-28 19:29:36'),(85,16,0.00,'cash','credit','sell',611,NULL,'2021-08-28 19:40:03','2021-08-28 19:40:03'),(86,16,0.00,'cash','credit','sell',611,NULL,'2021-08-28 19:40:03','2021-08-28 19:40:03'),(87,16,0.00,'cash','credit','sell',612,NULL,'2021-08-28 19:43:03','2021-08-28 19:43:03'),(88,16,0.00,'cash','credit','sell',612,NULL,'2021-08-28 19:43:03','2021-08-28 19:43:03'),(89,17,0.00,'cash','credit','initial',NULL,NULL,'2021-08-28 21:34:46','2021-08-28 21:34:46'),(90,17,25950.00,'cash','credit','sell',613,NULL,'2021-08-28 21:40:53','2021-08-28 21:40:53'),(91,17,0.00,'cash','credit','sell',613,NULL,'2021-08-28 21:40:53','2021-08-28 21:40:53'),(92,17,0.00,'cash','credit','sell',614,NULL,'2021-08-28 21:41:39','2021-08-28 21:41:39'),(93,17,0.00,'cash','credit','sell',614,NULL,'2021-08-28 21:41:39','2021-08-28 21:41:39'),(94,17,1500.00,'cash','credit','sell',615,NULL,'2021-08-28 21:42:16','2021-08-28 21:42:16'),(95,17,0.00,'cash','credit','sell',615,NULL,'2021-08-28 21:42:16','2021-08-28 21:42:16'),(96,17,4000.00,'cash','credit','sell',144,1,'2021-08-28 21:43:14','2021-08-28 21:43:14'),(97,17,3500.00,'cash','credit','sell',400,1,'2021-08-28 21:43:58','2021-08-28 21:43:58'),(98,17,5000.00,'cash','credit','sell',367,1,'2021-08-28 21:44:16','2021-08-28 21:44:16'),(100,17,40990.00,'cash','credit','sell',616,NULL,'2021-08-28 21:48:23','2021-08-28 21:48:23'),(101,17,0.00,'cash','credit','sell',616,NULL,'2021-08-28 21:48:23','2021-08-28 21:48:23'),(102,17,0.00,'cash','credit','sell',617,NULL,'2021-08-28 21:49:34','2021-08-28 21:49:34'),(103,17,0.00,'cash','credit','sell',617,NULL,'2021-08-28 21:49:34','2021-08-28 21:49:34'),(104,17,2160.00,'cash','credit','sell',618,NULL,'2021-08-28 21:50:13','2021-08-28 21:50:13'),(105,17,0.00,'cash','credit','sell',618,NULL,'2021-08-28 21:50:13','2021-08-28 21:50:13'),(106,17,8500.00,'cash','credit','sell',383,1,'2021-08-28 21:54:18','2021-08-28 21:54:18'),(107,17,500.00,'cash','credit','sell',442,1,'2021-08-28 21:54:43','2021-08-28 21:54:43'),(108,17,2310.00,'cash','credit','sell',620,NULL,'2021-08-28 22:18:43','2021-08-28 22:18:43'),(109,17,0.00,'cash','credit','sell',620,NULL,'2021-08-28 22:18:43','2021-08-28 22:18:43'),(110,17,4220.00,'cash','credit','sell',622,NULL,'2021-08-28 23:06:47','2021-08-28 23:06:47'),(111,17,0.00,'cash','credit','sell',622,NULL,'2021-08-28 23:06:47','2021-08-28 23:06:47'),(112,17,4000.00,'cash','credit','sell',623,NULL,'2021-08-28 23:07:10','2021-08-28 23:07:10'),(113,17,0.00,'cash','credit','sell',623,NULL,'2021-08-28 23:07:10','2021-08-28 23:07:10'),(114,17,2270.00,'cash','credit','sell',624,NULL,'2021-08-28 23:18:28','2021-08-28 23:18:28'),(115,17,0.00,'cash','credit','sell',624,NULL,'2021-08-28 23:18:28','2021-08-28 23:18:28'),(116,17,8550.02,'cash','credit','sell',626,NULL,'2021-08-28 23:45:05','2021-08-28 23:45:05'),(117,17,0.00,'cash','credit','sell',626,NULL,'2021-08-28 23:45:05','2021-08-28 23:45:05'),(118,17,1080.00,'cash','credit','sell',606,1,'2021-08-28 23:45:30','2021-08-28 23:45:30'),(119,17,1000.00,'cash','credit','sell',118,1,'2021-08-28 23:46:46','2021-08-28 23:46:46'),(120,17,2000.00,'cash','credit','sell',372,1,'2021-08-28 23:48:06','2021-08-28 23:48:06'),(121,17,2000.00,'cash','credit','sell',361,1,'2021-08-28 23:51:00','2021-08-28 23:51:00'),(122,17,12110.00,'cash','credit','sell',627,NULL,'2021-08-28 23:54:30','2021-08-28 23:54:30'),(123,17,0.00,'cash','credit','sell',627,NULL,'2021-08-28 23:54:30','2021-08-28 23:54:30'),(124,17,3575.00,'cash','credit','sell',629,NULL,'2021-08-29 15:30:48','2021-08-29 15:30:48'),(125,17,0.00,'cash','credit','sell',629,NULL,'2021-08-29 15:30:48','2021-08-29 15:30:48'),(126,17,0.00,'cash','credit','sell',630,NULL,'2021-08-29 15:31:45','2021-08-29 15:31:45'),(127,17,0.00,'cash','credit','sell',630,NULL,'2021-08-29 15:31:45','2021-08-29 15:31:45'),(128,17,3850.00,'cash','credit','sell',631,NULL,'2021-08-29 15:33:14','2021-08-29 15:33:14'),(129,17,0.00,'cash','credit','sell',631,NULL,'2021-08-29 15:33:14','2021-08-29 15:33:14'),(130,17,1000.00,'cash','credit','sell',57,1,'2021-08-29 15:33:34','2021-08-29 15:33:34'),(131,17,100.00,'cash','credit','sell',442,1,'2021-08-29 15:34:04','2021-08-29 15:34:04'),(132,17,500.00,'cash','credit','sell',611,1,'2021-08-29 15:35:35','2021-08-29 15:35:35'),(133,17,260.00,'cash','credit','sell',286,1,'2021-08-29 15:35:53','2021-08-29 15:35:53'),(134,17,3430.02,'cash','credit','sell',632,NULL,'2021-08-29 15:42:14','2021-08-29 15:42:14'),(135,17,0.00,'cash','credit','sell',632,NULL,'2021-08-29 15:42:14','2021-08-29 15:42:14'),(136,17,0.00,'cash','credit','sell',633,NULL,'2021-08-29 15:45:47','2021-08-29 15:45:47'),(137,17,0.00,'cash','credit','sell',633,NULL,'2021-08-29 15:45:47','2021-08-29 15:45:47'),(138,17,27176.00,'cash','credit','sell',634,NULL,'2021-08-29 15:49:53','2021-08-29 15:49:53'),(139,17,0.00,'cash','credit','sell',634,NULL,'2021-08-29 15:49:53','2021-08-29 15:49:53'),(140,17,3670.00,'cash','credit','sell',440,1,'2021-08-29 15:50:13','2021-08-29 15:50:13'),(141,17,270.00,'cash','credit','sell',630,1,'2021-08-29 15:50:13','2021-08-29 15:50:13'),(142,17,2535.00,'cash','credit','sell',633,1,'2021-08-29 15:50:13','2021-08-29 15:50:13'),(143,17,7000.00,'cash','credit','sell',385,1,'2021-08-29 15:50:45','2021-08-29 15:50:45'),(144,17,450.00,'cash','credit','sell',635,NULL,'2021-08-29 15:52:36','2021-08-29 15:52:36'),(145,17,0.00,'cash','credit','sell',635,NULL,'2021-08-29 15:52:36','2021-08-29 15:52:36'),(146,17,86962.04,'cash','credit','sell',637,NULL,'2021-08-29 16:08:16','2021-08-29 16:08:16'),(147,17,0.00,'cash','credit','sell',637,NULL,'2021-08-29 16:08:16','2021-08-29 16:08:16'),(148,17,850.00,'cash','credit','sell',638,NULL,'2021-08-29 16:09:21','2021-08-29 16:09:21'),(149,17,0.00,'cash','credit','sell',638,NULL,'2021-08-29 16:09:21','2021-08-29 16:09:21'),(150,17,4900.00,'cash','credit','sell',411,1,'2021-08-29 16:14:26','2021-08-29 16:14:26'),(151,17,10000.00,'cash','credit','sell',145,1,'2021-08-29 16:14:57','2021-08-29 16:14:57'),(152,17,1000.00,'cash','credit','sell',397,1,'2021-08-29 16:15:11','2021-08-29 16:15:11'),(153,17,9555.00,'cash','credit','sell',639,NULL,'2021-08-29 20:43:58','2021-08-29 20:43:58'),(154,17,0.00,'cash','credit','sell',639,NULL,'2021-08-29 20:43:58','2021-08-29 20:43:58'),(155,17,5500.00,'cash','credit','sell',640,NULL,'2021-08-29 20:47:14','2021-08-29 20:47:14'),(156,17,0.00,'cash','credit','sell',640,NULL,'2021-08-29 20:47:14','2021-08-29 20:47:14'),(157,17,1700.00,'cash','credit','sell',641,NULL,'2021-08-29 20:47:59','2021-08-29 20:47:59'),(158,17,0.00,'cash','credit','sell',641,NULL,'2021-08-29 20:47:59','2021-08-29 20:47:59'),(159,17,10000.00,'cash','credit','sell',371,1,'2021-08-29 20:48:35','2021-08-29 20:48:35'),(160,17,800.00,'cash','credit','sell',379,1,'2021-08-29 20:48:55','2021-08-29 20:48:55'),(161,17,41750.00,'cash','credit','sell',642,NULL,'2021-08-29 20:49:43','2021-08-29 20:49:43'),(162,17,0.00,'cash','credit','sell',642,NULL,'2021-08-29 20:49:43','2021-08-29 20:49:43'),(163,17,4500.00,'cash','credit','sell',643,NULL,'2021-08-29 20:51:13','2021-08-29 20:51:13'),(164,17,0.00,'cash','credit','sell',643,NULL,'2021-08-29 20:51:13','2021-08-29 20:51:13'),(165,17,1000.00,'cash','credit','sell',644,NULL,'2021-08-29 20:52:17','2021-08-29 20:52:17'),(166,17,0.00,'cash','credit','sell',644,NULL,'2021-08-29 20:52:17','2021-08-29 20:52:17'),(167,17,0.00,'cash','credit','sell',645,NULL,'2021-08-29 20:53:07','2021-08-29 20:53:07'),(168,17,0.00,'cash','credit','sell',645,NULL,'2021-08-29 20:53:07','2021-08-29 20:53:07'),(169,17,10840.00,'cash','credit','sell',646,NULL,'2021-08-29 20:57:47','2021-08-29 20:57:47'),(170,17,0.00,'cash','credit','sell',646,NULL,'2021-08-29 20:57:47','2021-08-29 20:57:47'),(171,17,0.00,'cash','credit','sell',647,NULL,'2021-08-29 20:58:49','2021-08-29 20:58:49'),(172,17,0.00,'cash','credit','sell',647,NULL,'2021-08-29 20:58:49','2021-08-29 20:58:49'),(173,17,5500.00,'cash','credit','sell',55,1,'2021-08-29 20:59:36','2021-08-29 20:59:36'),(174,17,300.00,'cash','credit','sell',442,1,'2021-08-29 21:04:06','2021-08-29 21:04:06'),(175,17,14866.00,'cash','credit','sell',648,NULL,'2021-08-29 22:15:50','2021-08-29 22:15:50'),(176,17,0.00,'cash','credit','sell',648,NULL,'2021-08-29 22:15:50','2021-08-29 22:15:50'),(177,17,7000.00,'cash','credit','sell',98,1,'2021-08-29 22:16:16','2021-08-29 22:16:16'),(178,17,2000.00,'cash','credit','sell',26,1,'2021-08-29 22:16:32','2021-08-29 22:16:32'),(179,17,250.00,'cash','credit','sell',442,1,'2021-08-29 22:16:47','2021-08-29 22:16:47'),(180,17,3000.00,'cash','credit','sell',389,1,'2021-08-29 22:17:58','2021-08-29 22:17:58'),(181,17,5000.00,'cash','credit','sell',146,1,'2021-08-29 22:18:18','2021-08-29 22:18:18'),(182,17,7410.00,'cash','credit','sell',649,NULL,'2021-08-29 22:25:48','2021-08-29 22:25:48'),(183,17,0.00,'cash','credit','sell',649,NULL,'2021-08-29 22:25:48','2021-08-29 22:25:48'),(184,17,17000.00,'cash','credit','sell',650,NULL,'2021-08-29 22:26:56','2021-08-29 22:26:56'),(185,17,0.00,'cash','credit','sell',650,NULL,'2021-08-29 22:26:56','2021-08-29 22:26:56'),(186,17,7960.00,'cash','credit','sell',651,NULL,'2021-08-29 22:34:53','2021-08-29 22:34:53'),(187,17,0.00,'cash','credit','sell',651,NULL,'2021-08-29 22:34:53','2021-08-29 22:34:53'),(188,17,0.00,'cash','credit','sell',652,NULL,'2021-08-29 22:42:42','2021-08-29 22:42:42'),(189,17,0.00,'cash','credit','sell',652,NULL,'2021-08-29 22:42:42','2021-08-29 22:42:42'),(190,17,15820.00,'cash','credit','sell',654,NULL,'2021-08-29 22:55:16','2021-08-29 22:55:16'),(191,17,0.00,'cash','credit','sell',654,NULL,'2021-08-29 22:55:16','2021-08-29 22:55:16'),(192,17,67615.00,'cash','credit','sell',655,NULL,'2021-08-29 22:59:45','2021-08-29 22:59:45'),(193,17,0.00,'cash','credit','sell',655,NULL,'2021-08-29 22:59:45','2021-08-29 22:59:45'),(194,17,5220.00,'cash','credit','sell',656,NULL,'2021-08-29 23:01:00','2021-08-29 23:01:00'),(195,17,0.00,'cash','credit','sell',656,NULL,'2021-08-29 23:01:00','2021-08-29 23:01:00'),(196,17,15000.00,'cash','credit','sell',657,NULL,'2021-08-29 23:01:53','2021-08-29 23:01:53'),(197,17,0.00,'cash','credit','sell',657,NULL,'2021-08-29 23:01:53','2021-08-29 23:01:53'),(198,17,2990.00,'cash','credit','sell',658,NULL,'2021-08-29 23:12:22','2021-08-29 23:12:22'),(199,17,0.00,'cash','credit','sell',658,NULL,'2021-08-29 23:12:22','2021-08-29 23:12:22'),(200,17,0.00,'cash','credit','sell',659,NULL,'2021-08-29 23:12:55','2021-08-29 23:12:55'),(201,17,0.00,'cash','credit','sell',659,NULL,'2021-08-29 23:12:55','2021-08-29 23:12:55'),(202,17,754.00,'cash','credit','sell',660,NULL,'2021-08-29 23:15:16','2021-08-29 23:15:16'),(203,17,0.00,'cash','credit','sell',660,NULL,'2021-08-29 23:15:16','2021-08-29 23:15:16'),(204,17,10610.00,'cash','credit','sell',661,NULL,'2021-08-29 23:21:32','2021-08-29 23:21:32'),(205,17,0.00,'cash','credit','sell',661,NULL,'2021-08-29 23:21:32','2021-08-29 23:21:32'),(206,17,1080.00,'cash','credit','sell',652,1,'2021-08-29 23:22:32','2021-08-29 23:22:32'),(207,17,400.00,'cash','credit','sell',371,1,'2021-08-29 23:22:53','2021-08-29 23:22:53'),(208,17,1000.00,'cash','credit','sell',142,1,'2021-08-29 23:24:12','2021-08-29 23:24:12'),(209,17,380.00,'cash','credit','sell',120,1,'2021-08-29 23:24:52','2021-08-29 23:24:52'),(210,17,4000.00,'cash','credit','sell',398,1,'2021-08-29 23:25:36','2021-08-29 23:25:36'),(211,17,5000.00,'cash','credit','sell',403,1,'2021-08-29 23:25:59','2021-08-29 23:25:59'),(212,17,2000.00,'cash','credit','sell',86,1,'2021-08-29 23:26:13','2021-08-29 23:26:13'),(213,17,13000.00,'cash','credit','sell',406,1,'2021-08-29 23:26:37','2021-08-29 23:26:37'),(214,17,2600.00,'cash','credit','sell',158,1,'2021-08-29 23:27:40','2021-08-29 23:27:40'),(215,17,1600.00,'cash','credit','sell',158,1,'2021-08-29 23:27:47','2021-08-29 23:27:47'),(216,17,2600.00,'cash','credit','sell',100,1,'2021-08-29 23:28:07','2021-08-29 23:28:07'),(217,17,1000.00,'cash','credit','sell',365,1,'2021-08-29 23:28:33','2021-08-29 23:28:33'),(218,17,19274.00,'cash','credit','sell',662,NULL,'2021-08-30 00:30:10','2021-08-30 00:30:10'),(219,17,0.00,'cash','credit','sell',662,NULL,'2021-08-30 00:30:10','2021-08-30 00:30:10'),(220,17,220.00,'cash','credit','sell',663,NULL,'2021-08-30 00:30:57','2021-08-30 00:30:57'),(221,17,0.00,'cash','credit','sell',663,NULL,'2021-08-30 00:30:57','2021-08-30 00:30:57'),(222,17,45859.00,'cash','credit','sell',664,NULL,'2021-08-30 00:32:15','2021-08-30 00:32:15'),(223,17,0.00,'cash','credit','sell',664,NULL,'2021-08-30 00:32:15','2021-08-30 00:32:15'),(224,17,2000.00,'cash','credit','sell',434,1,'2021-08-30 00:32:49','2021-08-30 00:32:49'),(225,17,2000.00,'cash','credit','sell',402,1,'2021-08-30 00:33:04','2021-08-30 00:33:04'),(226,17,0.00,'cash','credit','sell',667,NULL,'2021-08-31 20:24:17','2021-08-31 20:24:17'),(227,17,0.00,'cash','credit','sell',667,NULL,'2021-08-31 20:24:17','2021-08-31 20:24:17'),(228,17,42654.04,'cash','credit','sell',668,NULL,'2021-08-31 20:32:25','2021-08-31 20:32:25'),(229,17,0.00,'cash','credit','sell',668,NULL,'2021-08-31 20:32:25','2021-08-31 20:32:25'),(230,17,12000.00,'cash','credit','sell',399,1,'2021-08-31 20:32:49','2021-08-31 20:32:49'),(231,17,22000.00,'cash','credit','sell',669,NULL,'2021-08-31 20:33:26','2021-08-31 20:33:26'),(232,17,0.00,'cash','credit','sell',669,NULL,'2021-08-31 20:33:26','2021-08-31 20:33:26'),(233,17,3149.00,'cash','credit','sell',670,NULL,'2021-08-31 20:34:32','2021-08-31 20:34:32'),(234,17,0.00,'cash','credit','sell',670,NULL,'2021-08-31 20:34:32','2021-08-31 20:34:32'),(235,17,6000.00,'cash','credit','sell',671,NULL,'2021-08-31 20:35:14','2021-08-31 20:35:14'),(236,17,0.00,'cash','credit','sell',671,NULL,'2021-08-31 20:35:14','2021-08-31 20:35:14'),(237,17,3300.00,'cash','credit','sell',392,1,'2021-08-31 20:35:36','2021-08-31 20:35:36'),(238,17,28300.00,'cash','credit','sell',93,1,'2021-08-31 20:35:53','2021-08-31 20:35:53'),(239,17,1400.00,'cash','credit','sell',442,1,'2021-08-31 20:36:17','2021-08-31 20:36:17'),(240,17,17820.00,'cash','credit','sell',672,NULL,'2021-08-31 20:43:11','2021-08-31 20:43:11'),(241,17,0.00,'cash','credit','sell',672,NULL,'2021-08-31 20:43:11','2021-08-31 20:43:11'),(242,17,8990.00,'cash','credit','sell',673,NULL,'2021-08-31 20:45:22','2021-08-31 20:45:22'),(243,17,0.00,'cash','credit','sell',673,NULL,'2021-08-31 20:45:22','2021-08-31 20:45:22'),(244,17,4530.00,'cash','credit','sell',674,NULL,'2021-08-31 20:46:23','2021-08-31 20:46:23'),(245,17,0.00,'cash','credit','sell',674,NULL,'2021-08-31 20:46:23','2021-08-31 20:46:23'),(246,17,8200.00,'cash','credit','sell',676,NULL,'2021-08-31 20:55:49','2021-08-31 20:55:49'),(247,17,0.00,'cash','credit','sell',676,NULL,'2021-08-31 20:55:49','2021-08-31 20:55:49'),(248,17,9805.00,'cash','credit','sell',677,NULL,'2021-08-31 20:59:07','2021-08-31 20:59:07'),(249,17,0.00,'cash','credit','sell',677,NULL,'2021-08-31 20:59:07','2021-08-31 20:59:07'),(250,17,1000.00,'cash','credit','sell',678,NULL,'2021-08-31 20:59:34','2021-08-31 20:59:34'),(251,17,0.00,'cash','credit','sell',678,NULL,'2021-08-31 20:59:34','2021-08-31 20:59:34'),(252,17,12000.00,'cash','credit','sell',108,1,'2021-08-31 21:00:04','2021-08-31 21:00:04'),(253,17,500.00,'cash','credit','sell',11,1,'2021-08-31 21:00:25','2021-08-31 21:00:25'),(254,17,1000.00,'cash','credit','sell',57,1,'2021-08-31 21:00:40','2021-08-31 21:00:40'),(255,17,250.00,'cash','credit','sell',431,1,'2021-08-31 21:00:59','2021-08-31 21:00:59'),(256,17,450.00,'cash','credit','sell',667,1,'2021-08-31 21:01:12','2021-08-31 21:01:12'),(257,17,1000.00,'cash','credit','sell',365,1,'2021-08-31 21:01:27','2021-08-31 21:01:27'),(258,17,1000.00,'cash','credit','sell',99,1,'2021-08-31 21:01:40','2021-08-31 21:01:40'),(259,17,1880.00,'cash','credit','sell',578,1,'2021-08-31 21:01:57','2021-08-31 21:01:57'),(260,17,20.00,'cash','credit','sell',442,1,'2021-08-31 21:02:34','2021-08-31 21:02:34'),(262,17,9000.00,'cash','credit','sell',415,1,'2021-08-31 21:03:43','2021-08-31 21:03:43'),(263,17,100.00,'cash','credit','sell',442,1,'2021-08-31 21:04:06','2021-08-31 21:04:06'),(264,17,0.00,'cash','credit','sell',679,NULL,'2021-08-31 21:04:57','2021-08-31 21:04:57'),(265,17,0.00,'cash','credit','sell',679,NULL,'2021-08-31 21:04:57','2021-08-31 21:04:57'),(266,17,7901.00,'cash','credit','sell',680,NULL,'2021-08-31 21:06:15','2021-08-31 21:06:15'),(267,17,0.00,'cash','credit','sell',680,NULL,'2021-08-31 21:06:15','2021-08-31 21:06:15'),(268,17,0.00,'cash','credit','sell',681,NULL,'2021-08-31 21:06:46','2021-08-31 21:06:46'),(269,17,0.00,'cash','credit','sell',681,NULL,'2021-08-31 21:06:46','2021-08-31 21:06:46'),(270,17,10720.00,'cash','credit','sell',682,NULL,'2021-08-31 21:07:54','2021-08-31 21:07:54'),(271,17,0.00,'cash','credit','sell',682,NULL,'2021-08-31 21:07:54','2021-08-31 21:07:54'),(272,17,9750.00,'cash','credit','sell',683,NULL,'2021-08-31 21:11:43','2021-08-31 21:11:43'),(273,17,0.00,'cash','credit','sell',683,NULL,'2021-08-31 21:11:43','2021-08-31 21:11:43'),(274,17,4800.00,'cash','credit','sell',684,NULL,'2021-08-31 21:12:48','2021-08-31 21:12:48'),(275,17,0.00,'cash','credit','sell',684,NULL,'2021-08-31 21:12:48','2021-08-31 21:12:48'),(276,17,4600.00,'cash','credit','sell',685,NULL,'2021-08-31 21:13:46','2021-08-31 21:13:46'),(277,17,0.00,'cash','credit','sell',685,NULL,'2021-08-31 21:13:46','2021-08-31 21:13:46'),(278,17,10000.00,'cash','credit','sell',374,1,'2021-08-31 21:14:25','2021-08-31 21:14:25'),(279,17,6500.00,'cash','credit','sell',409,1,'2021-08-31 21:15:03','2021-08-31 21:15:03'),(280,17,3000.00,'cash','credit','sell',98,1,'2021-08-31 21:15:34','2021-08-31 21:15:34'),(281,17,7400.00,'cash','credit','sell',686,NULL,'2021-08-31 21:19:11','2021-08-31 21:19:11'),(282,17,0.00,'cash','credit','sell',686,NULL,'2021-08-31 21:19:11','2021-08-31 21:19:11'),(283,17,15000.00,'cash','credit','sell',687,NULL,'2021-08-31 21:19:52','2021-08-31 21:19:52'),(284,17,0.00,'cash','credit','sell',687,NULL,'2021-08-31 21:19:52','2021-08-31 21:19:52'),(285,17,33000.00,'cash','credit','sell',688,NULL,'2021-08-31 21:20:10','2021-08-31 21:20:10'),(286,17,0.00,'cash','credit','sell',688,NULL,'2021-08-31 21:20:10','2021-08-31 21:20:10'),(287,17,2860.00,'cash','credit','sell',689,NULL,'2021-08-31 21:21:35','2021-08-31 21:21:35'),(288,17,0.00,'cash','credit','sell',689,NULL,'2021-08-31 21:21:35','2021-08-31 21:21:35'),(289,17,0.00,'cash','credit','sell',690,NULL,'2021-08-31 21:22:47','2021-08-31 21:22:47'),(290,17,0.00,'cash','credit','sell',690,NULL,'2021-08-31 21:22:47','2021-08-31 21:22:47'),(291,17,5500.00,'cash','credit','sell',691,NULL,'2021-08-31 21:24:32','2021-08-31 21:24:32'),(292,17,0.00,'cash','credit','sell',691,NULL,'2021-08-31 21:24:32','2021-08-31 21:24:32'),(293,17,26045.00,'cash','credit','sell',692,NULL,'2021-08-31 21:25:39','2021-08-31 21:25:39'),(294,17,0.00,'cash','credit','sell',692,NULL,'2021-08-31 21:25:39','2021-08-31 21:25:39'),(295,17,0.00,'cash','credit','sell',693,NULL,'2021-08-31 21:26:10','2021-08-31 21:26:10'),(296,17,0.00,'cash','credit','sell',693,NULL,'2021-08-31 21:26:10','2021-08-31 21:26:10'),(297,17,0.00,'cash','credit','sell',694,NULL,'2021-08-31 21:26:54','2021-08-31 21:26:54'),(298,17,0.00,'cash','credit','sell',694,NULL,'2021-08-31 21:26:54','2021-08-31 21:26:54'),(299,17,3000.00,'cash','credit','sell',84,1,'2021-08-31 21:27:24','2021-08-31 21:27:24'),(300,17,1225.00,'cash','credit','sell',690,1,'2021-08-31 21:27:39','2021-08-31 21:27:39'),(301,17,125.00,'cash','credit','sell',693,1,'2021-08-31 21:27:39','2021-08-31 21:27:39'),(302,17,600.00,'cash','credit','sell',442,1,'2021-08-31 21:28:02','2021-08-31 21:28:02'),(303,17,0.00,'cash','credit','sell',695,NULL,'2021-08-31 21:28:42','2021-08-31 21:28:42'),(304,17,0.00,'cash','credit','sell',695,NULL,'2021-08-31 21:28:42','2021-08-31 21:28:42'),(305,17,4680.00,'cash','credit','sell',696,NULL,'2021-08-31 21:29:46','2021-08-31 21:29:46'),(306,17,0.00,'cash','credit','sell',696,NULL,'2021-08-31 21:29:46','2021-08-31 21:29:46'),(307,17,19400.00,'cash','credit','sell',698,NULL,'2021-08-31 21:43:16','2021-08-31 21:43:16'),(308,17,0.00,'cash','credit','sell',698,NULL,'2021-08-31 21:43:16','2021-08-31 21:43:16'),(309,17,4900.00,'cash','credit','sell',699,NULL,'2021-08-31 21:43:59','2021-08-31 21:43:59'),(310,17,0.00,'cash','credit','sell',699,NULL,'2021-08-31 21:43:59','2021-08-31 21:43:59'),(311,17,3600.00,'cash','credit','sell',700,NULL,'2021-08-31 21:45:17','2021-08-31 21:45:17'),(312,17,0.00,'cash','credit','sell',700,NULL,'2021-08-31 21:45:17','2021-08-31 21:45:17'),(313,17,4000.00,'cash','credit','sell',433,1,'2021-08-31 21:45:58','2021-08-31 21:45:58'),(314,17,1000.00,'cash','credit','sell',323,1,'2021-08-31 21:46:25','2021-08-31 21:46:25'),(315,17,99000.00,'cash','credit','sell',656,1,'2021-08-31 21:46:25','2021-08-31 21:46:25'),(316,17,4000.00,'cash','credit','sell',413,1,'2021-08-31 21:46:54','2021-08-31 21:46:54'),(317,17,6000.00,'cash','credit','sell',425,1,'2021-08-31 21:47:09','2021-08-31 21:47:09'),(318,17,500.00,'cash','credit','sell',442,1,'2021-08-31 21:47:47','2021-08-31 21:47:47'),(319,17,500.00,'cash','credit','sell',436,1,'2021-08-31 21:48:06','2021-08-31 21:48:06'),(320,17,2700.00,'cash','credit','sell',393,1,'2021-08-31 21:48:36','2021-08-31 21:48:36'),(321,17,1000.00,'cash','credit','sell',102,1,'2021-08-31 21:49:07','2021-08-31 21:49:07'),(322,17,300.00,'cash','credit','sell',442,1,'2021-08-31 21:49:27','2021-08-31 21:49:27'),(323,17,10650.00,'cash','credit','sell',701,NULL,'2021-08-31 21:51:08','2021-08-31 21:51:08'),(324,17,0.00,'cash','credit','sell',701,NULL,'2021-08-31 21:51:08','2021-08-31 21:51:08'),(325,17,500.00,'cash','credit','sell',702,NULL,'2021-08-31 21:51:32','2021-08-31 21:51:32'),(326,17,0.00,'cash','credit','sell',702,NULL,'2021-08-31 21:51:32','2021-08-31 21:51:32'),(327,17,24220.01,'cash','credit','sell',705,NULL,'2021-09-01 14:28:56','2021-09-01 14:28:56'),(328,17,0.00,'cash','credit','sell',705,NULL,'2021-09-01 14:28:56','2021-09-01 14:28:56'),(329,17,0.00,'cash','credit','sell',706,NULL,'2021-09-01 14:29:45','2021-09-01 14:29:45'),(330,17,0.00,'cash','credit','sell',706,NULL,'2021-09-01 14:29:45','2021-09-01 14:29:45'),(331,17,20.00,'cash','credit','sell',707,NULL,'2021-09-01 14:30:11','2021-09-01 14:30:11'),(332,17,0.00,'cash','credit','sell',707,NULL,'2021-09-01 14:30:11','2021-09-01 14:30:11'),(333,17,800.00,'cash','credit','sell',432,1,'2021-09-01 14:31:48','2021-09-01 14:31:48'),(334,17,5000.00,'cash','credit','sell',419,1,'2021-09-01 14:32:05','2021-09-01 14:32:05'),(335,17,3000.00,'cash','credit','sell',669,1,'2021-09-01 14:32:49','2021-09-01 14:32:49'),(336,17,6640.00,'cash','credit','sell',709,NULL,'2021-09-01 14:39:24','2021-09-01 14:39:24'),(337,17,0.00,'cash','credit','sell',709,NULL,'2021-09-01 14:39:24','2021-09-01 14:39:24'),(338,17,8640.00,'cash','credit','sell',710,NULL,'2021-09-01 14:42:04','2021-09-01 14:42:04'),(339,17,0.00,'cash','credit','sell',710,NULL,'2021-09-01 14:42:04','2021-09-01 14:42:04'),(340,17,5000.00,'cash','credit','sell',143,1,'2021-09-01 14:44:22','2021-09-01 14:44:22'),(341,17,10000.00,'cash','credit','sell',420,1,'2021-09-01 14:44:34','2021-09-01 14:44:34'),(342,17,100.00,'cash','credit','sell',442,1,'2021-09-01 14:44:47','2021-09-01 14:44:47'),(343,17,7000.00,'cash','credit','sell',429,1,'2021-09-01 14:45:06','2021-09-01 14:45:06'),(344,17,100.00,'cash','credit','sell',296,1,'2021-09-01 14:47:53','2021-09-01 14:47:53'),(345,17,1800.00,'cash','credit','sell',659,1,'2021-09-01 14:47:53','2021-09-01 14:47:53'),(346,17,44690.00,'cash','credit','sell',712,NULL,'2021-09-01 15:03:25','2021-09-01 15:03:25'),(347,17,0.00,'cash','credit','sell',712,NULL,'2021-09-01 15:03:25','2021-09-01 15:03:25'),(348,17,97200.01,'cash','credit','sell',713,NULL,'2021-09-01 15:06:20','2021-09-01 15:06:20'),(349,17,0.00,'cash','credit','sell',713,NULL,'2021-09-01 15:06:20','2021-09-01 15:06:20'),(350,17,16240.00,'cash','credit','sell',714,NULL,'2021-09-01 15:13:42','2021-09-01 15:13:42'),(351,17,0.00,'cash','credit','sell',714,NULL,'2021-09-01 15:13:42','2021-09-01 15:13:42'),(352,17,3460.01,'cash','credit','sell',715,NULL,'2021-09-01 15:14:03','2021-09-01 15:14:03'),(353,17,0.00,'cash','credit','sell',715,NULL,'2021-09-01 15:14:03','2021-09-01 15:14:03'),(354,17,4000.00,'cash','credit','sell',62,1,'2021-09-01 15:14:52','2021-09-01 15:14:52'),(355,17,2000.00,'cash','credit','sell',69,1,'2021-09-01 15:15:38','2021-09-01 15:15:38'),(356,17,9000.00,'cash','credit','sell',404,1,'2021-09-01 15:15:46','2021-09-01 15:15:46'),(357,17,42350.00,'cash','credit','sell',718,NULL,'2021-09-01 15:30:23','2021-09-01 15:30:23'),(358,17,0.00,'cash','credit','sell',718,NULL,'2021-09-01 15:30:23','2021-09-01 15:30:23'),(359,17,1500.00,'cash','credit','sell',719,NULL,'2021-09-01 15:32:10','2021-09-01 15:32:10'),(360,17,0.00,'cash','credit','sell',719,NULL,'2021-09-01 15:32:10','2021-09-01 15:32:10'),(361,17,3300.00,'cash','credit','sell',720,NULL,'2021-09-01 15:34:03','2021-09-01 15:34:03'),(362,17,0.00,'cash','credit','sell',720,NULL,'2021-09-01 15:34:03','2021-09-01 15:34:03'),(363,17,100.00,'cash','credit','sell',58,1,'2021-09-01 15:34:26','2021-09-01 15:34:26'),(364,17,10000.00,'cash','credit','sell',131,1,'2021-09-01 15:34:56','2021-09-01 15:34:56'),(365,17,6840.00,'cash','credit','sell',721,NULL,'2021-09-01 15:42:16','2021-09-01 15:42:16'),(366,17,0.00,'cash','credit','sell',721,NULL,'2021-09-01 15:42:16','2021-09-01 15:42:16'),(367,17,3000.00,'cash','credit','sell',722,NULL,'2021-09-01 15:43:54','2021-09-01 15:43:54'),(368,17,0.00,'cash','credit','sell',722,NULL,'2021-09-01 15:43:54','2021-09-01 15:43:54'),(369,17,13770.00,'cash','credit','sell',724,NULL,'2021-09-01 16:00:20','2021-09-01 16:00:20'),(370,17,0.00,'cash','credit','sell',724,NULL,'2021-09-01 16:00:20','2021-09-01 16:00:20'),(371,17,100.00,'cash','credit','sell',725,NULL,'2021-09-01 16:01:11','2021-09-01 16:01:11'),(372,17,0.00,'cash','credit','sell',725,NULL,'2021-09-01 16:01:11','2021-09-01 16:01:11'),(373,17,1000.00,'cash','credit','sell',99,1,'2021-09-01 16:01:32','2021-09-01 16:01:32'),(374,17,500.00,'cash','credit','sell',142,1,'2021-09-01 16:01:44','2021-09-01 16:01:44'),(375,17,300.00,'cash','credit','sell',702,1,'2021-09-01 16:01:58','2021-09-01 16:01:58'),(376,17,1080.00,'cash','credit','sell',647,1,'2021-09-01 16:02:11','2021-09-01 16:02:11'),(377,17,11000.00,'cash','credit','sell',140,1,'2021-09-01 16:02:29','2021-09-01 16:02:29'),(378,17,10000.00,'cash','credit','sell',421,1,'2021-09-01 16:04:22','2021-09-01 16:04:22'),(379,17,27920.00,'cash','credit','sell',726,NULL,'2021-09-01 16:05:50','2021-09-01 16:05:50'),(380,17,0.00,'cash','credit','sell',726,NULL,'2021-09-01 16:05:50','2021-09-01 16:05:50'),(381,17,0.00,'cash','credit','sell',727,NULL,'2021-09-01 16:06:57','2021-09-01 16:06:57'),(382,17,0.00,'cash','credit','sell',727,NULL,'2021-09-01 16:06:57','2021-09-01 16:06:57'),(383,17,20000.00,'cash','credit','sell',728,NULL,'2021-09-01 16:08:21','2021-09-01 16:08:21'),(384,17,0.00,'cash','credit','sell',728,NULL,'2021-09-01 16:08:21','2021-09-01 16:08:21'),(385,17,0.00,'cash','credit','sell',729,NULL,'2021-09-01 16:08:48','2021-09-01 16:08:48'),(386,17,0.00,'cash','credit','sell',729,NULL,'2021-09-01 16:08:48','2021-09-01 16:08:48'),(387,17,13660.00,'cash','credit','sell',730,NULL,'2021-09-01 16:12:01','2021-09-01 16:12:01'),(388,17,0.00,'cash','credit','sell',730,NULL,'2021-09-01 16:12:01','2021-09-01 16:12:01'),(389,17,0.00,'cash','credit','sell',731,NULL,'2021-09-01 16:12:40','2021-09-01 16:12:40'),(390,17,0.00,'cash','credit','sell',731,NULL,'2021-09-01 16:12:40','2021-09-01 16:12:40'),(391,17,4050.00,'cash','credit','sell',732,NULL,'2021-09-01 16:13:41','2021-09-01 16:13:41'),(392,17,0.00,'cash','credit','sell',732,NULL,'2021-09-01 16:13:41','2021-09-01 16:13:41'),(393,17,177.00,'cash','credit','sell',733,NULL,'2021-09-01 16:18:59','2021-09-01 16:18:59'),(394,17,0.00,'cash','credit','sell',733,NULL,'2021-09-01 16:18:59','2021-09-01 16:18:59'),(395,17,71950.00,'cash','credit','sell',734,NULL,'2021-09-01 16:22:15','2021-09-01 16:22:15'),(396,17,0.00,'cash','credit','sell',734,NULL,'2021-09-01 16:22:15','2021-09-01 16:22:15'),(397,17,100.00,'cash','credit','sell',735,NULL,'2021-09-01 16:22:46','2021-09-01 16:22:46'),(398,17,0.00,'cash','credit','sell',735,NULL,'2021-09-01 16:22:46','2021-09-01 16:22:46'),(399,17,43300.00,'cash','credit','sell',736,NULL,'2021-09-01 16:23:30','2021-09-01 16:23:30'),(400,17,0.00,'cash','credit','sell',736,NULL,'2021-09-01 16:23:30','2021-09-01 16:23:30'),(401,17,26500.00,'cash','credit','sell',737,NULL,'2021-09-01 16:24:30','2021-09-01 16:24:30'),(402,17,0.00,'cash','credit','sell',737,NULL,'2021-09-01 16:24:30','2021-09-01 16:24:30'),(403,17,6040.00,'cash','credit','sell',738,NULL,'2021-09-01 16:26:22','2021-09-01 16:26:22'),(404,17,0.00,'cash','credit','sell',738,NULL,'2021-09-01 16:26:22','2021-09-01 16:26:22'),(405,17,6816.00,'cash','credit','sell',739,NULL,'2021-09-01 16:27:39','2021-09-01 16:27:39'),(406,17,0.00,'cash','credit','sell',739,NULL,'2021-09-01 16:27:39','2021-09-01 16:27:39'),(407,17,6380.00,'cash','credit','sell',740,NULL,'2021-09-01 16:28:22','2021-09-01 16:28:22'),(408,17,0.00,'cash','credit','sell',740,NULL,'2021-09-01 16:28:22','2021-09-01 16:28:22'),(409,17,0.00,'cash','credit','sell',741,NULL,'2021-09-01 16:28:42','2021-09-01 16:28:42'),(410,17,0.00,'cash','credit','sell',741,NULL,'2021-09-01 16:28:42','2021-09-01 16:28:42'),(411,17,2000.00,'cash','credit','sell',725,1,'2021-09-01 16:29:07','2021-09-01 16:29:07'),(412,17,5000.00,'cash','credit','sell',363,1,'2021-09-01 16:29:24','2021-09-01 16:29:24'),(413,17,5000.00,'cash','credit','sell',376,1,'2021-09-01 16:29:41','2021-09-01 16:29:41'),(414,17,500.00,'cash','credit','sell',17,1,'2021-09-01 16:29:55','2021-09-01 16:29:55'),(415,17,7000.00,'cash','credit','sell',143,1,'2021-09-01 16:30:16','2021-09-01 16:30:16'),(417,17,40000.00,'cash','credit','sell',728,1,'2021-09-01 16:43:50','2021-09-01 16:43:50'),(418,17,100.00,'cash','credit','sell',442,1,'2021-09-01 16:44:05','2021-09-01 16:44:05'),(419,17,3000.00,'cash','credit','sell',746,NULL,'2021-09-01 16:46:48','2021-09-01 16:46:48'),(420,17,0.00,'cash','credit','sell',746,NULL,'2021-09-01 16:46:48','2021-09-01 16:46:48'),(421,17,6934.04,'cash','credit','sell',747,NULL,'2021-09-01 16:51:26','2021-09-01 16:51:26'),(422,17,0.00,'cash','credit','sell',747,NULL,'2021-09-01 16:51:26','2021-09-01 16:51:26'),(423,17,0.00,'cash','credit','sell',748,NULL,'2021-09-01 16:53:02','2021-09-01 16:53:02'),(424,17,0.00,'cash','credit','sell',748,NULL,'2021-09-01 16:53:02','2021-09-01 16:53:02'),(425,17,970.00,'cash','credit','sell',749,NULL,'2021-09-01 16:53:45','2021-09-01 16:53:45'),(426,17,0.00,'cash','credit','sell',749,NULL,'2021-09-01 16:53:45','2021-09-01 16:53:45'),(427,17,34290.00,'cash','credit','sell',750,NULL,'2021-09-01 16:55:02','2021-09-01 16:55:02'),(428,17,0.00,'cash','credit','sell',750,NULL,'2021-09-01 16:55:02','2021-09-01 16:55:02'),(429,17,94205.00,'cash','credit','sell',751,NULL,'2021-09-01 16:56:06','2021-09-01 16:56:06'),(430,17,0.00,'cash','credit','sell',751,NULL,'2021-09-01 16:56:06','2021-09-01 16:56:06'),(431,17,23500.00,'cash','credit','sell',752,NULL,'2021-09-01 16:56:50','2021-09-01 16:56:50'),(432,17,0.00,'cash','credit','sell',752,NULL,'2021-09-01 16:56:50','2021-09-01 16:56:50'),(433,17,5000.00,'cash','credit','sell',387,1,'2021-09-01 16:57:10','2021-09-01 16:57:10'),(434,17,8000.00,'cash','credit','sell',408,1,'2021-09-01 16:57:25','2021-09-01 16:57:25'),(435,17,2800.00,'cash','credit','sell',382,1,'2021-09-01 16:57:41','2021-09-01 16:57:41'),(436,17,27190.01,'cash','credit','sell',753,NULL,'2021-09-01 17:04:46','2021-09-01 17:04:46'),(437,17,0.00,'cash','credit','sell',753,NULL,'2021-09-01 17:04:46','2021-09-01 17:04:46'),(438,17,8283.00,'cash','credit','sell',756,NULL,'2021-09-01 17:08:47','2021-09-01 17:08:47'),(439,17,0.00,'cash','credit','sell',756,NULL,'2021-09-01 17:08:47','2021-09-01 17:08:47'),(440,17,2100.00,'cash','credit','sell',4,1,'2021-09-01 17:09:14','2021-09-01 17:09:14'),(441,17,900.00,'cash','credit','sell',442,1,'2021-09-01 17:09:36','2021-09-01 17:09:36'),(442,17,0.00,'cash','credit','sell',757,NULL,'2021-09-01 17:09:58','2021-09-01 17:09:58'),(443,17,0.00,'cash','credit','sell',757,NULL,'2021-09-01 17:09:58','2021-09-01 17:09:58'),(444,17,0.00,'cash','credit','sell',758,NULL,'2021-09-01 17:10:55','2021-09-01 17:10:55'),(445,17,0.00,'cash','credit','sell',758,NULL,'2021-09-01 17:10:55','2021-09-01 17:10:55'),(446,17,3250.00,'cash','credit','sell',759,NULL,'2021-09-01 17:11:39','2021-09-01 17:11:39'),(447,17,0.00,'cash','credit','sell',759,NULL,'2021-09-01 17:11:39','2021-09-01 17:11:39'),(448,17,0.00,'cash','credit','sell',760,NULL,'2021-09-01 17:12:14','2021-09-01 17:12:14'),(449,17,0.00,'cash','credit','sell',760,NULL,'2021-09-01 17:12:14','2021-09-01 17:12:14'),(450,17,46470.00,'cash','credit','sell',761,NULL,'2021-09-01 17:17:28','2021-09-01 17:17:28'),(451,17,0.00,'cash','credit','sell',761,NULL,'2021-09-01 17:17:28','2021-09-01 17:17:28'),(452,17,0.00,'cash','credit','sell',762,NULL,'2021-09-01 17:18:26','2021-09-01 17:18:26'),(453,17,0.00,'cash','credit','sell',762,NULL,'2021-09-01 17:18:26','2021-09-01 17:18:26'),(454,17,46.00,'cash','credit','sell',763,NULL,'2021-09-01 17:19:04','2021-09-01 17:19:04'),(455,17,0.00,'cash','credit','sell',763,NULL,'2021-09-01 17:19:04','2021-09-01 17:19:04'),(456,17,8880.00,'cash','credit','sell',764,NULL,'2021-09-01 17:20:09','2021-09-01 17:20:09'),(457,17,0.00,'cash','credit','sell',764,NULL,'2021-09-01 17:20:09','2021-09-01 17:20:09'),(458,17,150.00,'cash','credit','sell',394,1,'2021-09-01 17:20:37','2021-09-01 17:20:37'),(459,17,2000.00,'cash','credit','sell',153,1,'2021-09-01 17:20:51','2021-09-01 17:20:51'),(460,17,3000.00,'cash','credit','sell',372,1,'2021-09-01 17:21:04','2021-09-01 17:21:04'),(461,17,8000.00,'cash','credit','sell',418,1,'2021-09-01 17:21:34','2021-09-01 17:21:34'),(462,17,5000.00,'cash','credit','sell',403,1,'2021-09-01 17:22:22','2021-09-01 17:22:22'),(463,17,4300.00,'cash','credit','sell',136,1,'2021-09-01 17:22:42','2021-09-01 17:22:42'),(464,17,15470.00,'cash','credit','sell',765,NULL,'2021-09-01 18:18:23','2021-09-01 18:18:23'),(465,17,0.00,'cash','credit','sell',765,NULL,'2021-09-01 18:18:23','2021-09-01 18:18:23'),(466,17,8600.00,'cash','credit','sell',766,NULL,'2021-09-01 18:22:21','2021-09-01 18:22:21'),(467,17,0.00,'cash','credit','sell',766,NULL,'2021-09-01 18:22:21','2021-09-01 18:22:21'),(468,17,650.00,'cash','credit','sell',377,1,'2021-09-01 18:22:41','2021-09-01 18:22:41'),(469,17,250.00,'cash','credit','sell',395,1,'2021-09-01 18:22:52','2021-09-01 18:22:52'),(470,17,30.00,'cash','credit','sell',442,1,'2021-09-01 18:23:08','2021-09-01 18:23:08'),(471,17,120.00,'cash','credit','sell',706,1,'2021-09-01 18:23:40','2021-09-01 18:23:40'),(472,17,805.00,'cash','credit','sell',727,1,'2021-09-01 18:23:40','2021-09-01 18:23:40'),(473,17,1000.00,'cash','credit','sell',115,1,'2021-09-01 18:24:35','2021-09-01 18:24:35'),(474,17,2740.00,'cash','credit','sell',767,NULL,'2021-09-01 18:26:50','2021-09-01 18:26:50'),(475,17,0.00,'cash','credit','sell',767,NULL,'2021-09-01 18:26:50','2021-09-01 18:26:50'),(476,17,53195.00,'cash','credit','sell',768,NULL,'2021-09-01 18:28:33','2021-09-01 18:28:33'),(477,17,0.00,'cash','credit','sell',768,NULL,'2021-09-01 18:28:33','2021-09-01 18:28:33'),(478,17,0.00,'cash','credit','sell',769,NULL,'2021-09-01 18:29:15','2021-09-01 18:29:15'),(479,17,0.00,'cash','credit','sell',769,NULL,'2021-09-01 18:29:15','2021-09-01 18:29:15'),(480,17,0.00,'cash','credit','sell',770,NULL,'2021-09-01 18:32:13','2021-09-01 18:32:13'),(481,17,0.00,'cash','credit','sell',770,NULL,'2021-09-01 18:32:13','2021-09-01 18:32:13'),(482,17,568.00,'cash','credit','sell',771,NULL,'2021-09-01 18:32:56','2021-09-01 18:32:56'),(483,17,0.00,'cash','credit','sell',771,NULL,'2021-09-01 18:32:56','2021-09-01 18:32:56'),(484,17,21140.20,'cash','credit','sell',772,NULL,'2021-09-01 18:41:41','2021-09-01 18:41:41'),(485,17,0.00,'cash','credit','sell',772,NULL,'2021-09-01 18:41:41','2021-09-01 18:41:41'),(486,17,0.00,'cash','credit','sell',773,NULL,'2021-09-01 18:42:15','2021-09-01 18:42:15'),(487,17,0.00,'cash','credit','sell',773,NULL,'2021-09-01 18:42:15','2021-09-01 18:42:15'),(488,17,1580.00,'cash','credit','sell',774,NULL,'2021-09-01 18:43:20','2021-09-01 18:43:20'),(489,17,0.00,'cash','credit','sell',774,NULL,'2021-09-01 18:43:20','2021-09-01 18:43:20'),(490,17,600.00,'cash','credit','sell',776,NULL,'2021-09-01 18:46:15','2021-09-01 18:46:15'),(491,17,0.00,'cash','credit','sell',776,NULL,'2021-09-01 18:46:15','2021-09-01 18:46:15'),(492,17,19244.97,'cash','credit','sell',778,NULL,'2021-09-01 18:53:50','2021-09-01 18:53:50'),(493,17,0.00,'cash','credit','sell',778,NULL,'2021-09-01 18:53:50','2021-09-01 18:53:50'),(494,17,11000.00,'cash','credit','sell',779,NULL,'2021-09-01 18:54:34','2021-09-01 18:54:34'),(495,17,0.00,'cash','credit','sell',779,NULL,'2021-09-01 18:54:34','2021-09-01 18:54:34'),(496,17,0.00,'cash','credit','sell',780,NULL,'2021-09-01 18:58:18','2021-09-01 18:58:18'),(497,17,0.00,'cash','credit','sell',780,NULL,'2021-09-01 18:58:18','2021-09-01 18:58:18'),(498,17,5000.00,'cash','credit','sell',101,1,'2021-09-01 18:58:40','2021-09-01 18:58:40'),(499,17,1500.00,'cash','credit','sell',31,1,'2021-09-01 18:59:02','2021-09-01 18:59:02'),(500,17,500.00,'cash','credit','sell',62,1,'2021-09-01 18:59:18','2021-09-01 18:59:18'),(501,17,420.00,'cash','credit','sell',727,1,'2021-09-01 18:59:42','2021-09-01 18:59:42'),(502,17,1310.00,'cash','credit','sell',729,1,'2021-09-01 18:59:42','2021-09-01 18:59:42'),(503,17,275.00,'cash','credit','sell',731,1,'2021-09-01 18:59:42','2021-09-01 18:59:42'),(504,17,1640.00,'cash','credit','sell',748,1,'2021-09-01 18:59:42','2021-09-01 18:59:42'),(505,17,925.00,'cash','credit','sell',770,1,'2021-09-01 18:59:42','2021-09-01 18:59:42'),(506,17,1395.00,'cash','credit','sell',780,1,'2021-09-01 18:59:42','2021-09-01 18:59:42'),(507,17,14940.00,'cash','credit','sell',782,NULL,'2021-09-01 19:10:41','2021-09-01 19:10:41'),(508,17,0.00,'cash','credit','sell',782,NULL,'2021-09-01 19:10:41','2021-09-01 19:10:41'),(509,17,19095.00,'cash','credit','sell',783,NULL,'2021-09-01 19:13:08','2021-09-01 19:13:08'),(510,17,0.00,'cash','credit','sell',783,NULL,'2021-09-01 19:13:08','2021-09-01 19:13:08'),(511,17,44740.00,'cash','credit','sell',785,NULL,'2021-09-01 19:24:54','2021-09-01 19:24:54'),(512,17,0.00,'cash','credit','sell',785,NULL,'2021-09-01 19:24:54','2021-09-01 19:24:54'),(513,17,280.00,'cash','credit','sell',702,1,'2021-09-01 19:25:18','2021-09-01 19:25:18'),(514,17,1000.00,'cash','credit','sell',699,1,'2021-09-01 19:25:44','2021-09-01 19:25:44'),(515,17,2700.00,'cash','credit','sell',365,1,'2021-09-01 19:26:49','2021-09-01 19:26:49'),(516,17,500.00,'cash','credit','sell',99,1,'2021-09-01 19:27:24','2021-09-01 19:27:24'),(517,17,1000.00,'cash','credit','sell',142,1,'2021-09-01 19:27:42','2021-09-01 19:27:42'),(518,17,14000.00,'cash','credit','sell',417,1,'2021-09-01 19:28:01','2021-09-01 19:28:01'),(519,17,11000.00,'cash','credit','sell',410,1,'2021-09-01 19:28:45','2021-09-01 19:28:45'),(520,17,5000.00,'cash','credit','sell',430,1,'2021-09-01 19:29:46','2021-09-01 19:29:46'),(521,17,1000.00,'cash','credit','sell',762,1,'2021-09-01 19:30:06','2021-09-01 19:30:06'),(522,17,500.00,'cash','credit','sell',4,1,'2021-09-01 19:30:26','2021-09-01 19:30:26'),(523,17,0.00,'cash','credit','sell',786,NULL,'2021-09-01 19:31:22','2021-09-01 19:31:22'),(524,17,0.00,'cash','credit','sell',786,NULL,'2021-09-01 19:31:22','2021-09-01 19:31:22'),(525,17,40000.00,'cash','credit','sell',787,NULL,'2021-09-01 19:44:07','2021-09-01 19:44:07'),(526,17,0.00,'cash','credit','sell',787,NULL,'2021-09-01 19:44:07','2021-09-01 19:44:07'),(527,17,16960.00,'cash','credit','sell',788,NULL,'2021-09-01 19:53:22','2021-09-01 19:53:22'),(528,17,0.00,'cash','credit','sell',788,NULL,'2021-09-01 19:53:22','2021-09-01 19:53:22'),(529,17,1260.06,'cash','credit','sell',789,NULL,'2021-09-01 19:55:33','2021-09-01 19:55:33'),(530,17,0.00,'cash','credit','sell',789,NULL,'2021-09-01 19:55:33','2021-09-01 19:55:33'),(531,17,0.00,'cash','credit','sell',790,NULL,'2021-09-01 19:56:38','2021-09-01 19:56:38'),(532,17,0.00,'cash','credit','sell',790,NULL,'2021-09-01 19:56:38','2021-09-01 19:56:38'),(533,17,0.00,'cash','credit','sell',791,NULL,'2021-09-01 20:10:38','2021-09-01 20:10:38'),(534,17,0.00,'cash','credit','sell',791,NULL,'2021-09-01 20:10:38','2021-09-01 20:10:38'),(535,17,4174.00,'cash','credit','sell',792,NULL,'2021-09-01 20:13:05','2021-09-01 20:13:05'),(536,17,0.00,'cash','credit','sell',792,NULL,'2021-09-01 20:13:05','2021-09-01 20:13:05'),(537,17,1100.00,'cash','credit','sell',695,1,'2021-09-01 20:13:30','2021-09-01 20:13:30'),(538,17,8920.00,'cash','credit','sell',96,1,'2021-09-01 20:14:03','2021-09-01 20:14:03'),(539,17,2090.00,'cash','credit','sell',11,1,'2021-09-01 20:14:35','2021-09-01 20:14:35'),(540,17,76410.00,'cash','credit','sell',793,NULL,'2021-09-01 20:49:44','2021-09-01 20:49:44'),(541,17,0.00,'cash','credit','sell',793,NULL,'2021-09-01 20:49:44','2021-09-01 20:49:44'),(542,17,31909.67,'cash','credit','sell',794,NULL,'2021-09-01 20:54:14','2021-09-01 20:54:14'),(543,17,0.00,'cash','credit','sell',794,NULL,'2021-09-01 20:54:14','2021-09-01 20:54:14'),(544,17,2110.00,'cash','credit','sell',795,NULL,'2021-09-01 20:54:38','2021-09-01 20:54:38'),(545,17,0.00,'cash','credit','sell',795,NULL,'2021-09-01 20:54:38','2021-09-01 20:54:38'),(546,17,0.00,'cash','credit','sell',796,NULL,'2021-09-01 20:55:01','2021-09-01 20:55:01'),(547,17,0.00,'cash','credit','sell',796,NULL,'2021-09-01 20:55:01','2021-09-01 20:55:01'),(548,17,1000.00,'cash','credit','sell',414,1,'2021-09-01 20:55:26','2021-09-01 20:55:26'),(549,17,2400.00,'cash','credit','sell',780,1,'2021-09-01 20:55:44','2021-09-01 20:55:44'),(550,17,3500.00,'cash','credit','sell',62,1,'2021-09-01 20:56:03','2021-09-01 20:56:03'),(551,17,3000.00,'cash','credit','sell',44,1,'2021-09-01 20:56:21','2021-09-01 20:56:21'),(552,17,1000.00,'cash','credit','sell',398,1,'2021-09-01 20:56:36','2021-09-01 20:56:36'),(553,17,1080.00,'cash','credit','sell',760,1,'2021-09-01 20:57:09','2021-09-01 20:57:09'),(554,17,5333.33,'cash','credit','sell',797,NULL,'2021-09-01 21:01:55','2021-09-01 21:01:55'),(555,17,0.00,'cash','credit','sell',797,NULL,'2021-09-01 21:01:55','2021-09-01 21:01:55'),(556,17,1160.00,'cash','credit','sell',802,NULL,'2021-09-02 15:39:37','2021-09-02 15:39:37'),(557,17,0.00,'cash','credit','sell',802,NULL,'2021-09-02 15:39:37','2021-09-02 15:39:37'),(558,17,2100.00,'cash','credit','sell',805,NULL,'2021-09-02 16:10:46','2021-09-02 16:10:46'),(559,17,0.00,'cash','credit','sell',805,NULL,'2021-09-02 16:10:46','2021-09-02 16:10:46'),(560,17,45267.00,'cash','credit','sell',808,NULL,'2021-09-04 14:41:52','2021-09-04 14:41:52'),(561,17,0.00,'cash','credit','sell',808,NULL,'2021-09-04 14:41:52','2021-09-04 14:41:52'),(562,17,7500.00,'cash','credit','sell',811,NULL,'2021-09-04 14:46:29','2021-09-04 14:46:29'),(563,17,0.00,'cash','credit','sell',811,NULL,'2021-09-04 14:46:29','2021-09-04 14:46:29'),(564,17,100.00,'cash','credit','sell',774,1,'2021-09-04 14:46:50','2021-09-04 14:46:50'),(565,17,2500.00,'cash','credit','sell',737,1,'2021-09-04 14:47:21','2021-09-04 14:47:21'),(566,17,13000.00,'cash','credit','sell',744,1,'2021-09-04 14:47:37','2021-09-04 14:47:37'),(567,17,1000.00,'cash','credit','sell',752,1,'2021-09-04 14:47:58','2021-09-04 14:47:58'),(568,17,77730.40,'cash','credit','sell',812,NULL,'2021-09-04 14:53:55','2021-09-04 14:53:55'),(569,17,0.00,'cash','credit','sell',812,NULL,'2021-09-04 14:53:55','2021-09-04 14:53:55'),(570,17,2000.00,'cash','credit','sell',813,NULL,'2021-09-04 14:54:19','2021-09-04 14:54:19'),(571,17,0.00,'cash','credit','sell',813,NULL,'2021-09-04 14:54:19','2021-09-04 14:54:19'),(572,17,630.00,'cash','credit','sell',814,NULL,'2021-09-04 14:54:30','2021-09-04 14:54:30'),(573,17,0.00,'cash','credit','sell',814,NULL,'2021-09-04 14:54:30','2021-09-04 14:54:30'),(574,17,0.00,'cash','credit','sell',815,NULL,'2021-09-04 14:54:51','2021-09-04 14:54:51'),(575,17,0.00,'cash','credit','sell',815,NULL,'2021-09-04 14:54:51','2021-09-04 14:54:51'),(576,17,4000.00,'cash','credit','sell',816,NULL,'2021-09-04 14:55:26','2021-09-04 14:55:26'),(577,17,0.00,'cash','credit','sell',816,NULL,'2021-09-04 14:55:26','2021-09-04 14:55:26'),(578,17,3000.00,'cash','credit','sell',83,1,'2021-09-04 14:56:08','2021-09-04 14:56:08'),(579,17,1000.00,'cash','credit','sell',153,1,'2021-09-04 14:56:25','2021-09-04 14:56:25'),(580,17,0.00,'cash','credit','sell',817,NULL,'2021-09-04 14:57:58','2021-09-04 14:57:58'),(581,17,0.00,'cash','credit','sell',817,NULL,'2021-09-04 14:57:58','2021-09-04 14:57:58'),(582,17,0.00,'cash','credit','sell',818,NULL,'2021-09-04 14:58:34','2021-09-04 14:58:34'),(583,17,0.00,'cash','credit','sell',818,NULL,'2021-09-04 14:58:34','2021-09-04 14:58:34'),(584,17,18790.00,'cash','credit','sell',819,NULL,'2021-09-04 15:00:54','2021-09-04 15:00:54'),(585,17,0.00,'cash','credit','sell',819,NULL,'2021-09-04 15:00:54','2021-09-04 15:00:54'),(586,17,6144.02,'cash','credit','sell',820,NULL,'2021-09-04 15:02:05','2021-09-04 15:02:05'),(587,17,0.00,'cash','credit','sell',820,NULL,'2021-09-04 15:02:05','2021-09-04 15:02:05'),(588,17,5000.00,'cash','credit','sell',366,1,'2021-09-04 15:04:29','2021-09-04 15:04:29'),(589,17,430.00,'cash','credit','sell',52,1,'2021-09-04 15:04:44','2021-09-04 15:04:44'),(590,17,1000.00,'cash','credit','sell',57,1,'2021-09-04 15:04:57','2021-09-04 15:04:57'),(591,17,4000.00,'cash','credit','sell',141,1,'2021-09-04 15:05:40','2021-09-04 15:05:40'),(592,17,4500.00,'cash','credit','sell',367,1,'2021-09-04 15:05:54','2021-09-04 15:05:54'),(593,17,500.00,'cash','credit','sell',442,1,'2021-09-04 15:06:06','2021-09-04 15:06:06'),(594,17,850.00,'cash','credit','sell',442,1,'2021-09-04 15:06:14','2021-09-04 15:06:14'),(595,17,3000.00,'cash','credit','sell',424,1,'2021-09-04 15:06:40','2021-09-04 15:06:40'),(596,17,3480.00,'cash','credit','sell',67,1,'2021-09-04 15:06:54','2021-09-04 15:06:54'),(597,17,4700.00,'cash','credit','sell',144,1,'2021-09-04 15:07:25','2021-09-04 15:07:25'),(598,17,10000.00,'cash','credit','sell',427,1,'2021-09-04 15:08:06','2021-09-04 15:08:06'),(599,17,2170.00,'cash','credit','sell',780,1,'2021-09-04 15:08:22','2021-09-04 15:08:22'),(600,17,1930.00,'cash','credit','sell',786,1,'2021-09-04 15:08:22','2021-09-04 15:08:22'),(601,17,3880.00,'cash','credit','sell',815,1,'2021-09-04 15:08:22','2021-09-04 15:08:22'),(602,17,3070.00,'cash','credit','sell',817,1,'2021-09-04 15:08:22','2021-09-04 15:08:22'),(603,17,4100.00,'cash','credit','sell',211,1,'2021-09-04 15:08:57','2021-09-04 15:08:57'),(604,17,33550.00,'cash','credit','sell',581,1,'2021-09-04 15:08:57','2021-09-04 15:08:57'),(605,17,2400.00,'cash','credit','sell',779,1,'2021-09-04 15:09:14','2021-09-04 15:09:14'),(606,17,49.00,'cash','credit','sell',821,NULL,'2021-09-04 15:10:23','2021-09-04 15:10:23'),(607,17,0.00,'cash','credit','sell',821,NULL,'2021-09-04 15:10:23','2021-09-04 15:10:23'),(608,17,3680.00,'cash','credit','sell',822,NULL,'2021-09-05 14:17:54','2021-09-05 14:17:54'),(609,17,0.00,'cash','credit','sell',822,NULL,'2021-09-05 14:17:54','2021-09-05 14:17:54'),(610,17,2980.00,'cash','credit','sell',823,NULL,'2021-09-05 14:19:05','2021-09-05 14:19:05'),(611,17,0.00,'cash','credit','sell',823,NULL,'2021-09-05 14:19:05','2021-09-05 14:19:05'),(612,17,16560.00,'cash','credit','sell',824,NULL,'2021-09-05 14:20:45','2021-09-05 14:20:45'),(613,17,0.00,'cash','credit','sell',824,NULL,'2021-09-05 14:20:45','2021-09-05 14:20:45'),(614,17,5000.00,'cash','credit','sell',825,NULL,'2021-09-05 14:21:23','2021-09-05 14:21:23'),(615,17,0.00,'cash','credit','sell',825,NULL,'2021-09-05 14:21:23','2021-09-05 14:21:23'),(616,17,3000.00,'cash','credit','sell',389,1,'2021-09-05 14:22:04','2021-09-05 14:22:04'),(617,17,1500.00,'cash','credit','sell',138,1,'2021-09-05 14:22:24','2021-09-05 14:22:24'),(618,17,20.00,'cash','credit','sell',826,NULL,'2021-09-05 14:25:11','2021-09-05 14:25:11'),(619,17,0.00,'cash','credit','sell',826,NULL,'2021-09-05 14:25:11','2021-09-05 14:25:11'),(620,18,100.00,'cash','credit','initial',NULL,NULL,'2021-09-06 21:15:21','2021-09-06 21:15:21'),(621,19,1000.00,'cash','credit','initial',NULL,NULL,'2021-09-08 13:50:31','2021-09-08 13:50:31'),(622,19,25609.50,'cash','credit','sell',829,NULL,'2021-09-08 13:58:46','2021-09-08 13:58:46'),(623,19,0.00,'cash','credit','sell',829,NULL,'2021-09-08 13:58:46','2021-09-08 13:58:46'),(624,19,3500.00,'cash','credit','sell',400,1,'2021-09-08 14:00:23','2021-09-08 14:00:23'),(625,19,9950.00,'cash','credit','sell',830,NULL,'2021-09-08 19:50:40','2021-09-08 19:50:40'),(626,19,0.00,'cash','credit','sell',830,NULL,'2021-09-08 19:50:40','2021-09-08 19:50:40'),(627,19,10000.00,'cash','credit','sell',831,NULL,'2021-09-08 19:51:43','2021-09-08 19:51:43'),(628,19,0.00,'cash','credit','sell',831,NULL,'2021-09-08 19:51:43','2021-09-08 19:51:43'),(629,19,340.00,'cash','credit','sell',58,1,'2021-09-08 19:55:28','2021-09-08 19:55:28'),(630,19,3000.00,'cash','credit','sell',650,1,'2021-09-08 19:55:48','2021-09-08 19:55:48'),(631,19,1000.00,'cash','credit','sell',86,1,'2021-09-08 19:59:27','2021-09-08 19:59:27'),(632,19,500.00,'cash','credit','sell',4,1,'2021-09-08 19:59:55','2021-09-08 19:59:55'),(633,19,1000.00,'cash','credit','sell',699,1,'2021-09-08 20:00:11','2021-09-08 20:00:11'),(634,19,700.00,'cash','credit','sell',85,1,'2021-09-08 20:00:50','2021-09-08 20:00:50'),(635,19,430.00,'cash','credit','sell',10,1,'2021-09-08 20:01:22','2021-09-08 20:01:22'),(636,19,250.00,'cash','credit','sell',52,1,'2021-09-08 20:02:26','2021-09-08 20:02:26'),(637,19,9650.00,'cash','credit','sell',832,NULL,'2021-09-08 20:35:46','2021-09-08 20:35:46'),(638,19,0.00,'cash','credit','sell',832,NULL,'2021-09-08 20:35:46','2021-09-08 20:35:46'),(639,19,8540.95,'cash','credit','sell',833,NULL,'2021-09-08 20:37:26','2021-09-08 20:37:26'),(640,19,0.00,'cash','credit','sell',833,NULL,'2021-09-08 20:37:26','2021-09-08 20:37:26'),(641,19,0.00,'cash','credit','sell',834,NULL,'2021-09-08 20:38:00','2021-09-08 20:38:00'),(642,19,0.00,'cash','credit','sell',834,NULL,'2021-09-08 20:38:00','2021-09-08 20:38:00'),(643,19,3000.00,'cash','credit','sell',77,1,'2021-09-08 20:38:22','2021-09-08 20:38:22'),(644,19,5000.00,'cash','credit','sell',131,1,'2021-09-08 20:38:35','2021-09-08 20:38:35'),(645,19,1300.00,'cash','debit','refund',832,NULL,'2021-09-08 20:42:17','2021-09-08 20:42:17'),(646,19,2600.00,'cash','credit','sell',835,NULL,'2021-09-08 20:44:01','2021-09-08 20:44:01'),(647,19,0.00,'cash','credit','sell',835,NULL,'2021-09-08 20:44:01','2021-09-08 20:44:01'),(648,19,20093.00,'cash','credit','sell',836,NULL,'2021-09-08 20:49:58','2021-09-08 20:49:58'),(649,19,0.00,'cash','credit','sell',836,NULL,'2021-09-08 20:49:58','2021-09-08 20:49:58'),(650,19,3000.00,'cash','credit','sell',837,NULL,'2021-09-08 20:50:32','2021-09-08 20:50:32'),(651,19,0.00,'cash','credit','sell',837,NULL,'2021-09-08 20:50:32','2021-09-08 20:50:32'),(652,19,13000.00,'cash','credit','sell',838,NULL,'2021-09-08 20:51:11','2021-09-08 20:51:11'),(653,19,0.00,'cash','credit','sell',838,NULL,'2021-09-08 20:51:11','2021-09-08 20:51:11'),(654,19,0.00,'cash','credit','sell',839,NULL,'2021-09-08 20:54:33','2021-09-08 20:54:33'),(655,19,0.00,'cash','credit','sell',839,NULL,'2021-09-08 20:54:33','2021-09-08 20:54:33'),(656,19,2900.00,'cash','credit','sell',840,NULL,'2021-09-08 20:55:53','2021-09-08 20:55:53'),(657,19,0.00,'cash','credit','sell',840,NULL,'2021-09-08 20:55:53','2021-09-08 20:55:53'),(658,19,51000.00,'cash','credit','sell',841,NULL,'2021-09-08 20:56:47','2021-09-08 20:56:47'),(659,19,0.00,'cash','credit','sell',841,NULL,'2021-09-08 20:56:47','2021-09-08 20:56:47'),(660,19,18530.00,'cash','credit','sell',842,NULL,'2021-09-08 20:59:01','2021-09-08 20:59:01'),(661,19,0.00,'cash','credit','sell',842,NULL,'2021-09-08 20:59:01','2021-09-08 20:59:01'),(662,19,925.00,'cash','credit','sell',843,NULL,'2021-09-08 21:00:03','2021-09-08 21:00:03'),(663,19,0.00,'cash','credit','sell',843,NULL,'2021-09-08 21:00:03','2021-09-08 21:00:03'),(664,19,150.00,'cash','credit','sell',844,NULL,'2021-09-08 21:00:21','2021-09-08 21:00:21'),(665,19,0.00,'cash','credit','sell',844,NULL,'2021-09-08 21:00:21','2021-09-08 21:00:21'),(666,19,6243.00,'cash','credit','sell',845,NULL,'2021-09-08 21:02:09','2021-09-08 21:02:09'),(667,19,0.00,'cash','credit','sell',845,NULL,'2021-09-08 21:02:09','2021-09-08 21:02:09'),(668,19,0.00,'cash','credit','sell',846,NULL,'2021-09-08 21:03:28','2021-09-08 21:03:28'),(669,19,0.00,'cash','credit','sell',846,NULL,'2021-09-08 21:03:28','2021-09-08 21:03:28'),(670,19,1070.00,'cash','credit','sell',839,1,'2021-09-08 21:03:46','2021-09-08 21:03:46'),(671,19,1000.00,'cash','credit','sell',791,1,'2021-09-08 21:04:17','2021-09-08 21:04:17'),(672,19,250.00,'cash','credit','sell',442,1,'2021-09-08 21:05:00','2021-09-08 21:05:00'),(673,19,4700.00,'cash','credit','sell',371,1,'2021-09-08 21:05:13','2021-09-08 21:05:13'),(674,19,1700.00,'cash','credit','sell',641,1,'2021-09-08 21:05:13','2021-09-08 21:05:13'),(675,19,2500.00,'cash','credit','sell',645,1,'2021-09-08 21:05:13','2021-09-08 21:05:13'),(676,19,6573.01,'cash','credit','sell',849,NULL,'2021-09-08 21:24:17','2021-09-08 21:24:17'),(677,19,0.00,'cash','credit','sell',849,NULL,'2021-09-08 21:24:17','2021-09-08 21:24:17'),(678,19,3772.00,'cash','credit','sell',850,NULL,'2021-09-08 21:25:36','2021-09-08 21:25:36'),(679,19,0.00,'cash','credit','sell',850,NULL,'2021-09-08 21:25:36','2021-09-08 21:25:36'),(680,19,20.00,'cash','credit','sell',851,NULL,'2021-09-08 21:26:25','2021-09-08 21:26:25'),(681,19,0.00,'cash','credit','sell',851,NULL,'2021-09-08 21:26:25','2021-09-08 21:26:25'),(682,20,500.00,'cash','credit','initial',NULL,NULL,'2021-09-09 15:07:44','2021-09-09 15:07:44'),(683,20,16160.00,'cash','credit','sell',860,NULL,'2021-09-09 15:11:33','2021-09-09 15:11:33'),(684,20,0.00,'cash','credit','sell',860,NULL,'2021-09-09 15:11:33','2021-09-09 15:11:33'),(685,20,4360.02,'cash','credit','sell',861,NULL,'2021-09-09 15:12:33','2021-09-09 15:12:33'),(686,20,0.00,'cash','credit','sell',861,NULL,'2021-09-09 15:12:33','2021-09-09 15:12:33'),(687,20,6000.00,'cash','credit','sell',426,1,'2021-09-09 15:12:53','2021-09-09 15:12:53'),(688,20,4000.00,'cash','credit','sell',66,1,'2021-09-09 15:13:09','2021-09-09 15:13:09'),(689,20,400.00,'cash','credit','sell',74,1,'2021-09-09 15:13:28','2021-09-09 15:13:28'),(690,20,15000.00,'cash','credit','sell',107,1,'2021-09-09 15:13:43','2021-09-09 15:13:43'),(691,20,4000.00,'cash','credit','sell',387,1,'2021-09-09 15:13:59','2021-09-09 15:13:59'),(692,20,1000.00,'cash','credit','sell',16,1,'2021-09-09 15:14:25','2021-09-09 15:14:25'),(700,21,0.00,'cash','credit','initial',NULL,NULL,'2021-09-09 17:12:16','2021-09-09 17:12:16'),(701,22,500.00,'cash','credit','initial',NULL,NULL,'2021-09-09 17:13:59','2021-09-09 17:13:59'),(707,23,-3000.00,'cash','credit','initial',NULL,NULL,'2021-09-09 18:59:52','2021-09-09 18:59:52'),(715,24,-15753.00,'cash','credit','initial',NULL,NULL,'2021-09-10 14:13:44','2021-09-10 14:13:44'),(716,24,16660.00,'cash','credit','sell',876,NULL,'2021-09-10 14:17:26','2021-09-10 14:17:26'),(717,24,0.00,'cash','credit','sell',876,NULL,'2021-09-10 14:17:26','2021-09-10 14:17:26'),(718,24,610.00,'cash','credit','sell',877,NULL,'2021-09-10 14:19:14','2021-09-10 14:19:14'),(719,24,0.00,'cash','credit','sell',877,NULL,'2021-09-10 14:19:14','2021-09-10 14:19:14'),(720,24,2000.00,'cash','credit','sell',878,NULL,'2021-09-10 14:20:21','2021-09-10 14:20:21'),(721,24,0.00,'cash','credit','sell',878,NULL,'2021-09-10 14:20:21','2021-09-10 14:20:21'),(722,24,0.00,'cash','credit','sell',879,NULL,'2021-09-10 14:21:59','2021-09-10 14:21:59'),(723,24,0.00,'cash','credit','sell',879,NULL,'2021-09-10 14:21:59','2021-09-10 14:21:59'),(724,24,10865.00,'cash','credit','sell',880,NULL,'2021-09-10 14:22:45','2021-09-10 14:22:45'),(725,24,0.00,'cash','credit','sell',880,NULL,'2021-09-10 14:22:45','2021-09-10 14:22:45'),(726,24,1080.00,'cash','credit','sell',818,1,'2021-09-10 14:23:09','2021-09-10 14:23:09'),(727,24,2000.00,'cash','credit','sell',779,1,'2021-09-10 14:23:30','2021-09-10 14:23:30'),(728,24,1000.00,'cash','credit','sell',103,1,'2021-09-10 14:23:43','2021-09-10 14:23:43'),(729,24,3000.00,'cash','credit','sell',437,1,'2021-09-10 14:23:53','2021-09-10 14:23:53'),(730,24,1000.00,'cash','credit','sell',142,1,'2021-09-10 14:24:12','2021-09-10 14:24:12'),(731,24,1770.00,'cash','credit','sell',679,1,'2021-09-10 14:24:30','2021-09-10 14:24:30'),(732,24,500.00,'cash','credit','sell',796,1,'2021-09-10 14:24:47','2021-09-10 14:24:47'),(733,24,2000.00,'cash','credit','sell',153,1,'2021-09-10 14:25:07','2021-09-10 14:25:07'),(734,24,630.00,'cash','credit','sell',52,1,'2021-09-10 14:30:40','2021-09-10 14:30:40'),(735,24,2000.00,'cash','credit','sell',671,1,'2021-09-10 14:30:55','2021-09-10 14:30:55'),(736,24,40000.00,'cash','credit','sell',881,NULL,'2021-09-10 14:33:57','2021-09-10 14:33:57'),(737,24,0.00,'cash','credit','sell',881,NULL,'2021-09-10 14:33:57','2021-09-10 14:33:57'),(738,24,27000.00,'cash','credit','sell',882,NULL,'2021-09-10 14:34:10','2021-09-10 14:34:10'),(739,24,0.00,'cash','credit','sell',882,NULL,'2021-09-10 14:34:10','2021-09-10 14:34:10'),(740,24,2497.00,'cash','credit','sell',883,NULL,'2021-09-10 14:34:44','2021-09-10 14:34:44'),(741,24,0.00,'cash','credit','sell',883,NULL,'2021-09-10 14:34:44','2021-09-10 14:34:44'),(742,24,2000.00,'cash','credit','sell',884,NULL,'2021-09-10 14:35:10','2021-09-10 14:35:10'),(743,24,0.00,'cash','credit','sell',884,NULL,'2021-09-10 14:35:10','2021-09-10 14:35:10'),(744,24,5380.00,'cash','credit','sell',885,NULL,'2021-09-10 14:36:33','2021-09-10 14:36:33'),(745,24,0.00,'cash','credit','sell',885,NULL,'2021-09-10 14:36:33','2021-09-10 14:36:33'),(746,25,56475.00,'cash','credit','initial',NULL,NULL,'2021-09-11 14:54:54','2021-09-11 14:54:54'),(747,25,5200.00,'cash','credit','sell',890,NULL,'2021-09-11 15:02:11','2021-09-11 15:02:11'),(748,25,0.00,'cash','credit','sell',890,NULL,'2021-09-11 15:02:11','2021-09-11 15:02:11'),(749,25,17000.00,'cash','credit','sell',891,NULL,'2021-09-11 15:06:11','2021-09-11 15:06:11'),(750,25,0.00,'cash','credit','sell',891,NULL,'2021-09-11 15:06:11','2021-09-11 15:06:11'),(751,25,8000.00,'cash','credit','sell',893,NULL,'2021-09-11 15:52:16','2021-09-11 15:52:16'),(752,25,0.00,'cash','credit','sell',893,NULL,'2021-09-11 15:52:16','2021-09-11 15:52:16'),(753,25,17000.00,'cash','credit','sell',894,NULL,'2021-09-11 15:56:58','2021-09-11 15:56:58'),(754,25,0.00,'cash','credit','sell',894,NULL,'2021-09-11 15:56:58','2021-09-11 15:56:58'),(755,25,40470.00,'cash','credit','sell',895,NULL,'2021-09-11 16:04:54','2021-09-11 16:04:54'),(756,25,0.00,'cash','credit','sell',895,NULL,'2021-09-11 16:04:54','2021-09-11 16:04:54'),(757,25,1500.00,'cash','credit','sell',101,1,'2021-09-11 16:05:57','2021-09-11 16:05:57'),(758,25,270.00,'cash','debit','refund',890,NULL,'2021-09-11 16:21:47','2021-09-11 16:21:47'),(759,26,132080.00,'cash','credit','initial',NULL,NULL,'2021-09-12 14:08:56','2021-09-12 14:08:56'),(760,26,6045.00,'cash','credit','sell',901,NULL,'2021-09-12 14:12:08','2021-09-12 14:12:08'),(761,26,0.00,'cash','credit','sell',901,NULL,'2021-09-12 14:12:08','2021-09-12 14:12:08'),(762,26,1265.00,'cash','credit','sell',902,NULL,'2021-09-12 14:13:37','2021-09-12 14:13:37'),(763,26,0.00,'cash','credit','sell',902,NULL,'2021-09-12 14:13:37','2021-09-12 14:13:37'),(764,26,1000.00,'cash','credit','sell',903,NULL,'2021-09-12 14:14:03','2021-09-12 14:14:03'),(765,26,0.00,'cash','credit','sell',903,NULL,'2021-09-12 14:14:03','2021-09-12 14:14:03'),(766,26,15000.00,'cash','credit','sell',904,NULL,'2021-09-12 14:14:36','2021-09-12 14:14:36'),(767,26,0.00,'cash','credit','sell',904,NULL,'2021-09-12 14:14:36','2021-09-12 14:14:36'),(768,26,6750.00,'cash','credit','sell',905,NULL,'2021-09-12 14:17:03','2021-09-12 14:17:03'),(769,26,0.00,'cash','credit','sell',905,NULL,'2021-09-12 14:17:03','2021-09-12 14:17:03'),(770,26,4034.00,'cash','credit','sell',906,NULL,'2021-09-12 14:25:45','2021-09-12 14:25:45'),(771,26,0.00,'cash','credit','sell',906,NULL,'2021-09-12 14:25:45','2021-09-12 14:25:45'),(772,26,2562.00,'cash','credit','sell',907,NULL,'2021-09-12 14:27:47','2021-09-12 14:27:47'),(773,26,0.00,'cash','credit','sell',907,NULL,'2021-09-12 14:27:47','2021-09-12 14:27:47'),(774,26,8000.00,'cash','credit','sell',427,1,'2021-09-12 14:28:07','2021-09-12 14:28:07'),(775,26,3798.08,'cash','credit','sell',908,NULL,'2021-09-12 14:33:32','2021-09-12 14:33:32'),(776,26,0.00,'cash','credit','sell',908,NULL,'2021-09-12 14:33:32','2021-09-12 14:33:32'),(777,26,0.00,'cash','credit','sell',909,NULL,'2021-09-12 14:34:00','2021-09-12 14:34:00'),(778,26,0.00,'cash','credit','sell',909,NULL,'2021-09-12 14:34:00','2021-09-12 14:34:00'),(779,26,2000.00,'cash','credit','sell',910,NULL,'2021-09-12 14:36:07','2021-09-12 14:36:07'),(780,26,0.00,'cash','credit','sell',910,NULL,'2021-09-12 14:36:07','2021-09-12 14:36:07'),(781,26,6390.02,'cash','credit','sell',911,NULL,'2021-09-12 14:37:23','2021-09-12 14:37:23'),(782,26,0.00,'cash','credit','sell',911,NULL,'2021-09-12 14:37:23','2021-09-12 14:37:23'),(783,27,168885.00,'cash','credit','initial',NULL,NULL,'2021-09-14 14:16:42','2021-09-14 14:16:42'),(784,27,10840.00,'cash','credit','sell',915,NULL,'2021-09-14 14:19:26','2021-09-14 14:19:26'),(785,27,0.00,'cash','credit','sell',915,NULL,'2021-09-14 14:19:26','2021-09-14 14:19:26'),(786,27,1700.00,'cash','credit','sell',916,NULL,'2021-09-14 14:19:47','2021-09-14 14:19:47'),(787,27,0.00,'cash','credit','sell',916,NULL,'2021-09-14 14:19:47','2021-09-14 14:19:47'),(788,27,0.00,'cash','credit','sell',917,NULL,'2021-09-14 14:20:30','2021-09-14 14:20:30'),(789,27,0.00,'cash','credit','sell',917,NULL,'2021-09-14 14:20:30','2021-09-14 14:20:30'),(790,27,1000.00,'cash','credit','sell',749,1,'2021-09-14 14:20:50','2021-09-14 14:20:50'),(791,27,250.00,'cash','credit','sell',694,1,'2021-09-14 14:21:26','2021-09-14 14:21:26'),(792,27,1700.00,'cash','credit','sell',879,1,'2021-09-14 14:21:46','2021-09-14 14:21:46'),(793,27,5000.00,'cash','credit','sell',420,1,'2021-09-14 14:22:02','2021-09-14 14:22:02'),(794,27,300.00,'cash','credit','sell',611,1,'2021-09-14 14:22:23','2021-09-14 14:22:23'),(795,27,420.00,'cash','credit','sell',617,1,'2021-09-14 14:22:23','2021-09-14 14:22:23'),(796,27,280.00,'cash','credit','sell',837,1,'2021-09-14 14:22:23','2021-09-14 14:22:23'),(797,27,200.00,'cash','credit','sell',796,1,'2021-09-14 14:22:34','2021-09-14 14:22:34'),(798,27,700.00,'cash','credit','sell',85,1,'2021-09-14 14:24:18','2021-09-14 14:24:18'),(799,27,500.00,'cash','credit','sell',99,1,'2021-09-14 14:24:34','2021-09-14 14:24:34'),(800,27,1000.00,'cash','credit','sell',699,1,'2021-09-14 14:24:49','2021-09-14 14:24:49'),(801,27,500.00,'cash','credit','sell',4,1,'2021-09-14 14:25:03','2021-09-14 14:25:03'),(802,27,3000.00,'cash','credit','sell',372,1,'2021-09-14 14:25:17','2021-09-14 14:25:17'),(803,27,5000.00,'cash','credit','sell',430,1,'2021-09-14 14:25:36','2021-09-14 14:25:36'),(804,27,10000.00,'cash','credit','sell',363,1,'2021-09-14 14:25:44','2021-09-14 14:25:44'),(805,27,37650.00,'cash','credit','sell',918,NULL,'2021-09-14 14:27:53','2021-09-14 14:27:53'),(806,27,0.00,'cash','credit','sell',918,NULL,'2021-09-14 14:27:53','2021-09-14 14:27:53'),(807,27,37000.00,'cash','credit','sell',920,NULL,'2021-09-14 14:54:16','2021-09-14 14:54:16'),(808,27,0.00,'cash','credit','sell',920,NULL,'2021-09-14 14:54:16','2021-09-14 14:54:16'),(811,27,20000.00,'cash','credit','sell',922,NULL,'2021-09-14 15:01:59','2021-09-14 15:01:59'),(812,27,0.00,'cash','credit','sell',922,NULL,'2021-09-14 15:01:59','2021-09-14 15:01:59'),(813,27,3050.00,'cash','credit','sell',923,NULL,'2021-09-14 15:05:28','2021-09-14 15:05:28'),(814,27,0.00,'cash','credit','sell',923,NULL,'2021-09-14 15:05:28','2021-09-14 15:05:28'),(815,27,4450.00,'cash','credit','sell',924,NULL,'2021-09-14 15:06:33','2021-09-14 15:06:33'),(816,27,0.00,'cash','credit','sell',924,NULL,'2021-09-14 15:06:33','2021-09-14 15:06:33'),(817,27,6700.00,'cash','credit','sell',925,NULL,'2021-09-14 15:08:01','2021-09-14 15:08:01'),(818,27,0.00,'cash','credit','sell',925,NULL,'2021-09-14 15:08:01','2021-09-14 15:08:01'),(819,27,500.00,'cash','credit','sell',116,1,'2021-09-14 15:08:31','2021-09-14 15:08:31'),(822,27,1300.00,'cash','credit','sell',63,1,'2021-09-14 15:10:55','2021-09-14 15:10:55'),(823,27,500.00,'cash','credit','sell',15,1,'2021-09-14 15:11:06','2021-09-14 15:11:06'),(824,27,9938.01,'cash','credit','sell',926,NULL,'2021-09-14 15:14:51','2021-09-14 15:14:51'),(825,27,0.00,'cash','credit','sell',926,NULL,'2021-09-14 15:14:51','2021-09-14 15:14:51'),(826,27,50700.00,'cash','credit','sell',927,NULL,'2021-09-14 15:15:53','2021-09-14 15:15:53'),(827,27,0.00,'cash','credit','sell',927,NULL,'2021-09-14 15:15:53','2021-09-14 15:15:53'),(828,27,0.00,'cash','credit','sell',928,NULL,'2021-09-14 15:17:04','2021-09-14 15:17:04'),(829,27,0.00,'cash','credit','sell',928,NULL,'2021-09-14 15:17:04','2021-09-14 15:17:04'),(830,27,5000.00,'cash','credit','sell',373,1,'2021-09-14 15:33:08','2021-09-14 15:33:08'),(831,28,343353.00,'cash','credit','initial',NULL,NULL,'2021-09-15 14:23:17','2021-09-15 14:23:17'),(832,28,2000.00,'cash','credit','sell',742,1,'2021-09-15 14:23:30','2021-09-15 14:23:30'),(833,28,12000.00,'cash','credit','sell',374,1,'2021-09-15 14:24:31','2021-09-15 14:24:31'),(834,28,9500.00,'cash','credit','sell',405,1,'2021-09-15 14:24:44','2021-09-15 14:24:44'),(835,28,6500.00,'cash','credit','sell',936,NULL,'2021-09-15 14:27:26','2021-09-15 14:27:26'),(836,28,0.00,'cash','credit','sell',936,NULL,'2021-09-15 14:27:26','2021-09-15 14:27:26'),(837,28,16150.00,'cash','credit','sell',937,NULL,'2021-09-15 14:29:55','2021-09-15 14:29:55'),(838,28,0.00,'cash','credit','sell',937,NULL,'2021-09-15 14:29:55','2021-09-15 14:29:55'),(839,28,27560.00,'cash','credit','sell',938,NULL,'2021-09-15 14:30:25','2021-09-15 14:30:25'),(840,28,0.00,'cash','credit','sell',938,NULL,'2021-09-15 14:30:25','2021-09-15 14:30:25'),(841,28,0.00,'cash','credit','sell',939,NULL,'2021-09-15 14:31:00','2021-09-15 14:31:00'),(842,28,0.00,'cash','credit','sell',939,NULL,'2021-09-15 14:31:00','2021-09-15 14:31:00'),(843,29,279148.00,'cash','credit','initial',NULL,NULL,'2021-09-17 14:25:06','2021-09-17 14:25:06'),(844,29,15160.00,'cash','credit','sell',950,NULL,'2021-09-17 14:28:41','2021-09-17 14:28:41'),(845,29,0.00,'cash','credit','sell',950,NULL,'2021-09-17 14:28:41','2021-09-17 14:28:41'),(846,29,31600.00,'cash','credit','sell',951,NULL,'2021-09-17 14:29:05','2021-09-17 14:29:05'),(847,29,0.00,'cash','credit','sell',951,NULL,'2021-09-17 14:29:05','2021-09-17 14:29:05'),(848,29,48800.00,'cash','credit','sell',952,NULL,'2021-09-17 14:29:38','2021-09-17 14:29:38'),(849,29,0.00,'cash','credit','sell',952,NULL,'2021-09-17 14:29:38','2021-09-17 14:29:38'),(850,29,0.00,'cash','credit','sell',953,NULL,'2021-09-17 14:30:21','2021-09-17 14:30:21'),(851,29,0.00,'cash','credit','sell',953,NULL,'2021-09-17 14:30:21','2021-09-17 14:30:21'),(852,29,178.00,'cash','credit','sell',954,NULL,'2021-09-17 14:30:55','2021-09-17 14:30:55'),(853,29,0.00,'cash','credit','sell',954,NULL,'2021-09-17 14:30:55','2021-09-17 14:30:55'),(854,29,1800.00,'cash','credit','sell',878,1,'2021-09-17 14:31:17','2021-09-17 14:31:17'),(855,29,9000.00,'cash','credit','sell',391,1,'2021-09-17 14:31:39','2021-09-17 14:31:39'),(856,29,7500.00,'cash','credit','sell',388,1,'2021-09-17 14:39:57','2021-09-17 14:39:57'),(857,29,500.00,'cash','credit','sell',722,1,'2021-09-17 14:40:44','2021-09-17 14:40:44'),(858,29,300.00,'cash','credit','sell',409,1,'2021-09-17 14:41:06','2021-09-17 14:41:06'),(859,29,25515.00,'cash','credit','sell',955,NULL,'2021-09-17 15:09:22','2021-09-17 15:09:22'),(860,29,0.00,'cash','credit','sell',955,NULL,'2021-09-17 15:09:22','2021-09-17 15:09:22'),(861,29,4600.00,'cash','credit','sell',956,NULL,'2021-09-17 15:12:12','2021-09-17 15:12:12'),(862,29,0.00,'cash','credit','sell',956,NULL,'2021-09-17 15:12:12','2021-09-17 15:12:12'),(863,29,49840.00,'cash','credit','sell',957,NULL,'2021-09-17 15:20:02','2021-09-17 15:20:02'),(864,29,0.00,'cash','credit','sell',957,NULL,'2021-09-17 15:20:02','2021-09-17 15:20:02'),(865,29,0.00,'cash','credit','sell',958,NULL,'2021-09-17 15:20:51','2021-09-17 15:20:51'),(866,29,0.00,'cash','credit','sell',958,NULL,'2021-09-17 15:20:51','2021-09-17 15:20:51'),(867,29,1000.00,'cash','credit','sell',364,1,'2021-09-17 15:21:29','2021-09-17 15:21:29'),(869,29,500.00,'cash','credit','sell',142,1,'2021-09-17 15:25:30','2021-09-17 15:25:30'),(870,29,1000.00,'cash','credit','sell',99,1,'2021-09-17 15:25:48','2021-09-17 15:25:48'),(871,29,380.00,'cash','credit','sell',796,1,'2021-09-17 15:26:06','2021-09-17 15:26:06'),(872,29,2700.00,'cash','debit','refund',957,NULL,'2021-09-17 15:42:35','2021-09-17 15:42:35'),(875,29,11000.00,'cash','credit','sell',423,1,'2021-09-18 14:22:28','2021-09-18 14:22:28'),(876,29,5680.00,'cash','credit','sell',964,NULL,'2021-09-18 14:31:55','2021-09-18 14:31:55'),(877,29,0.00,'cash','credit','sell',964,NULL,'2021-09-18 14:31:55','2021-09-18 14:31:55'),(878,29,8540.00,'cash','credit','sell',965,NULL,'2021-09-18 14:39:10','2021-09-18 14:39:10'),(879,29,0.00,'cash','credit','sell',965,NULL,'2021-09-18 14:39:10','2021-09-18 14:39:10'),(880,29,18450.00,'cash','credit','sell',966,NULL,'2021-09-18 14:42:15','2021-09-18 14:42:15'),(881,29,0.00,'cash','credit','sell',966,NULL,'2021-09-18 14:42:15','2021-09-18 14:42:15'),(882,29,6410.04,'cash','credit','sell',967,NULL,'2021-09-18 14:43:06','2021-09-18 14:43:06'),(883,29,0.00,'cash','credit','sell',967,NULL,'2021-09-18 14:43:06','2021-09-18 14:43:06'),(886,29,1000.00,'cash','credit','sell',893,1,'2021-09-18 14:49:03','2021-09-18 14:49:03'),(887,29,500.00,'cash','credit','sell',76,1,'2021-09-18 14:49:29','2021-09-18 14:49:29'),(888,29,1000.00,'cash','credit','sell',24,1,'2021-09-18 14:49:43','2021-09-18 14:49:43'),(889,29,4000.00,'cash','credit','sell',413,1,'2021-09-18 14:50:00','2021-09-18 14:50:00'),(890,29,98.00,'cash','credit','sell',969,NULL,'2021-09-18 14:52:44','2021-09-18 14:52:44'),(891,29,0.00,'cash','credit','sell',969,NULL,'2021-09-18 14:52:44','2021-09-18 14:52:44'),(892,30,118040.00,'cash','credit','initial',NULL,NULL,'2021-09-19 15:39:05','2021-09-19 15:39:05'),(893,30,23180.00,'cash','credit','sell',975,NULL,'2021-09-19 15:54:39','2021-09-19 15:54:39'),(894,30,0.00,'cash','credit','sell',975,NULL,'2021-09-19 15:54:39','2021-09-19 15:54:39'),(895,30,4000.00,'cash','credit','sell',419,1,'2021-09-19 15:55:08','2021-09-19 15:55:08'),(896,30,6000.00,'cash','credit','sell',398,1,'2021-09-19 15:55:19','2021-09-19 15:55:19'),(897,30,15000.00,'cash','credit','sell',977,NULL,'2021-09-19 16:04:02','2021-09-19 16:04:02'),(898,30,0.00,'cash','credit','sell',977,NULL,'2021-09-19 16:04:02','2021-09-19 16:04:02'),(899,30,0.00,'cash','credit','sell',978,NULL,'2021-09-19 16:06:32','2021-09-19 16:06:32'),(900,30,0.00,'cash','credit','sell',978,NULL,'2021-09-19 16:06:32','2021-09-19 16:06:32'),(901,30,12560.00,'cash','credit','sell',979,NULL,'2021-09-19 16:09:38','2021-09-19 16:09:38'),(902,30,0.00,'cash','credit','sell',979,NULL,'2021-09-19 16:09:38','2021-09-19 16:09:38'),(903,30,1880.00,'cash','credit','sell',980,NULL,'2021-09-19 16:10:00','2021-09-19 16:10:00'),(904,30,0.00,'cash','credit','sell',980,NULL,'2021-09-19 16:10:00','2021-09-19 16:10:00'),(905,30,470.10,'cash','credit','sell',981,NULL,'2021-09-19 16:10:51','2021-09-19 16:10:51'),(906,30,0.00,'cash','credit','sell',981,NULL,'2021-09-19 16:10:51','2021-09-19 16:10:51'),(907,30,45000.00,'cash','credit','sell',982,NULL,'2021-09-19 16:11:29','2021-09-19 16:11:29'),(908,30,0.00,'cash','credit','sell',982,NULL,'2021-09-19 16:11:29','2021-09-19 16:11:29'),(909,31,223950.00,'cash','credit','initial',NULL,NULL,'2021-09-20 16:02:47','2021-09-20 16:02:47'),(910,31,7290.00,'cash','credit','sell',986,NULL,'2021-09-20 16:05:15','2021-09-20 16:05:15'),(911,31,0.00,'cash','credit','sell',986,NULL,'2021-09-20 16:05:15','2021-09-20 16:05:15'),(912,31,200.00,'cash','credit','sell',987,NULL,'2021-09-20 16:07:25','2021-09-20 16:07:25'),(913,31,0.00,'cash','credit','sell',987,NULL,'2021-09-20 16:07:25','2021-09-20 16:07:25'),(914,31,5800.00,'cash','credit','sell',988,NULL,'2021-09-20 16:08:24','2021-09-20 16:08:24'),(915,31,0.00,'cash','credit','sell',988,NULL,'2021-09-20 16:08:24','2021-09-20 16:08:24'),(916,31,200.10,'cash','credit','sell',989,NULL,'2021-09-20 16:09:26','2021-09-20 16:09:26'),(917,31,0.00,'cash','credit','sell',989,NULL,'2021-09-20 16:09:26','2021-09-20 16:09:26'),(918,31,0.00,'cash','credit','sell',990,NULL,'2021-09-20 16:09:53','2021-09-20 16:09:53'),(919,31,0.00,'cash','credit','sell',990,NULL,'2021-09-20 16:09:53','2021-09-20 16:09:53'),(920,31,0.00,'cash','credit','sell',991,NULL,'2021-09-20 16:10:17','2021-09-20 16:10:17'),(921,31,0.00,'cash','credit','sell',991,NULL,'2021-09-20 16:10:17','2021-09-20 16:10:17'),(922,31,0.00,'cash','credit','sell',992,NULL,'2021-09-20 16:10:52','2021-09-20 16:10:52'),(923,31,0.00,'cash','credit','sell',992,NULL,'2021-09-20 16:10:52','2021-09-20 16:10:52'),(924,31,3210.00,'cash','credit','sell',993,NULL,'2021-09-20 16:11:27','2021-09-20 16:11:27'),(925,31,0.00,'cash','credit','sell',993,NULL,'2021-09-20 16:11:27','2021-09-20 16:11:27'),(926,31,482.00,'cash','credit','sell',994,NULL,'2021-09-20 16:11:40','2021-09-20 16:11:40'),(927,31,0.00,'cash','credit','sell',994,NULL,'2021-09-20 16:11:40','2021-09-20 16:11:40'),(928,32,180092.00,'cash','credit','initial',NULL,NULL,'2021-09-21 15:38:24','2021-09-21 15:38:24'),(929,32,500.00,'cash','credit','sell',1004,1,'2021-09-21 15:38:41','2021-09-21 15:38:41'),(930,32,1060.00,'cash','credit','sell',991,1,'2021-09-21 15:38:53','2021-09-21 15:38:53'),(931,32,7000.00,'cash','credit','sell',385,1,'2021-09-21 15:39:05','2021-09-21 15:39:05'),(932,32,7810.00,'cash','credit','sell',1006,NULL,'2021-09-21 15:49:24','2021-09-21 15:49:24'),(933,32,0.00,'cash','credit','sell',1006,NULL,'2021-09-21 15:49:24','2021-09-21 15:49:24'),(934,32,780.00,'cash','credit','sell',1007,NULL,'2021-09-21 15:56:20','2021-09-21 15:56:20'),(935,32,0.00,'cash','credit','sell',1007,NULL,'2021-09-21 15:56:20','2021-09-21 15:56:20'),(936,32,8605.00,'cash','credit','sell',1008,NULL,'2021-09-21 15:58:18','2021-09-21 15:58:18'),(937,32,0.00,'cash','credit','sell',1008,NULL,'2021-09-21 15:58:18','2021-09-21 15:58:18'),(938,32,39500.00,'cash','credit','sell',1009,NULL,'2021-09-21 15:58:54','2021-09-21 15:58:54'),(939,32,0.00,'cash','credit','sell',1009,NULL,'2021-09-21 15:58:54','2021-09-21 15:58:54'),(940,32,10000.00,'cash','credit','sell',1010,NULL,'2021-09-21 16:00:48','2021-09-21 16:00:48'),(941,32,0.00,'cash','credit','sell',1010,NULL,'2021-09-21 16:00:48','2021-09-21 16:00:48'),(942,32,4280.02,'cash','credit','sell',1011,NULL,'2021-09-21 16:01:27','2021-09-21 16:01:27'),(943,32,0.00,'cash','credit','sell',1011,NULL,'2021-09-21 16:01:27','2021-09-21 16:01:27'),(944,33,228049.00,'cash','credit','initial',NULL,NULL,'2021-09-22 14:45:50','2021-09-22 14:45:50'),(945,33,7355.00,'cash','credit','sell',1020,NULL,'2021-09-22 16:07:15','2021-09-22 16:07:15'),(946,33,0.00,'cash','credit','sell',1020,NULL,'2021-09-22 16:07:15','2021-09-22 16:07:15'),(947,33,3510.00,'cash','credit','sell',1021,NULL,'2021-09-22 16:08:30','2021-09-22 16:08:30'),(948,33,0.00,'cash','credit','sell',1021,NULL,'2021-09-22 16:08:30','2021-09-22 16:08:30'),(949,33,2000.00,'cash','credit','sell',1022,NULL,'2021-09-22 16:09:07','2021-09-22 16:09:07'),(950,33,0.00,'cash','credit','sell',1022,NULL,'2021-09-22 16:09:07','2021-09-22 16:09:07'),(951,33,350.00,'cash','credit','sell',74,1,'2021-09-22 16:09:37','2021-09-22 16:09:37'),(952,33,2500.00,'cash','credit','sell',101,1,'2021-09-22 16:09:54','2021-09-22 16:09:54'),(953,33,3000.00,'cash','credit','sell',387,1,'2021-09-22 16:10:19','2021-09-22 16:10:19'),(954,33,1500.00,'cash','credit','sell',891,1,'2021-09-22 16:10:40','2021-09-22 16:10:40'),(955,33,8000.00,'cash','credit','sell',418,1,'2021-09-22 16:10:56','2021-09-22 16:10:56'),(956,33,400.00,'cash','credit','sell',1023,1,'2021-09-22 16:11:59','2021-09-22 16:11:59'),(957,33,13000.00,'cash','credit','sell',1024,NULL,'2021-09-22 16:12:55','2021-09-22 16:12:55'),(958,33,0.00,'cash','credit','sell',1024,NULL,'2021-09-22 16:12:55','2021-09-22 16:12:55'),(959,34,254419.00,'cash','credit','initial',NULL,NULL,'2021-09-28 15:09:12','2021-09-28 15:09:12'),(960,34,22190.00,'cash','credit','sell',1029,NULL,'2021-09-28 15:28:25','2021-09-28 15:28:25'),(961,34,0.00,'cash','credit','sell',1029,NULL,'2021-09-28 15:28:25','2021-09-28 15:28:25'),(962,34,33872.00,'cash','credit','sell',1030,NULL,'2021-09-28 15:29:43','2021-09-28 15:29:43'),(963,34,0.00,'cash','credit','sell',1030,NULL,'2021-09-28 15:29:43','2021-09-28 15:29:43'),(964,34,20660.00,'cash','credit','sell',1031,NULL,'2021-09-28 15:31:00','2021-09-28 15:31:00'),(965,34,0.00,'cash','credit','sell',1031,NULL,'2021-09-28 15:31:00','2021-09-28 15:31:00'),(966,34,6000.00,'cash','credit','sell',422,1,'2021-09-28 15:32:50','2021-09-28 15:32:50'),(967,34,4300.00,'cash','credit','sell',75,1,'2021-09-28 15:33:00','2021-09-28 15:33:00'),(968,34,500.00,'cash','credit','sell',615,1,'2021-09-28 15:33:00','2021-09-28 15:33:00'),(969,34,6260.00,'cash','credit','sell',1033,NULL,'2021-09-28 15:46:27','2021-09-28 15:46:27'),(970,34,0.00,'cash','credit','sell',1033,NULL,'2021-09-28 15:46:27','2021-09-28 15:46:27'),(971,34,1460.00,'cash','credit','sell',101,1,'2021-09-28 15:46:54','2021-09-28 15:46:54'),(972,34,300.00,'cash','credit','sell',116,1,'2021-09-28 15:47:09','2021-09-28 15:47:09'),(973,34,5000.00,'cash','credit','sell',226,1,'2021-09-28 15:47:25','2021-09-28 15:47:25'),(974,34,3000.00,'cash','credit','sell',987,1,'2021-09-28 15:47:38','2021-09-28 15:47:38'),(975,34,1000.00,'cash','credit','sell',99,1,'2021-09-28 15:47:52','2021-09-28 15:47:52'),(976,34,1080.00,'cash','credit','sell',978,1,'2021-09-28 15:48:05','2021-09-28 15:48:05'),(977,34,37334.00,'cash','credit','sell',1036,NULL,'2021-09-28 16:13:45','2021-09-28 16:13:45'),(978,34,0.00,'cash','credit','sell',1036,NULL,'2021-09-28 16:13:45','2021-09-28 16:13:45'),(979,34,0.00,'cash','credit','sell',1037,NULL,'2021-09-28 16:14:32','2021-09-28 16:14:32'),(980,34,0.00,'cash','credit','sell',1037,NULL,'2021-09-28 16:14:32','2021-09-28 16:14:32'),(981,34,3670.00,'cash','credit','sell',1038,NULL,'2021-09-28 16:15:17','2021-09-28 16:15:17'),(982,34,0.00,'cash','credit','sell',1038,NULL,'2021-09-28 16:15:17','2021-09-28 16:15:17'),(983,34,1070.00,'cash','credit','sell',958,1,'2021-09-28 16:15:44','2021-09-28 16:15:44'),(984,34,10.00,'cash','credit','sell',1039,1,'2021-09-28 16:16:18','2021-09-28 16:16:18'),(985,34,2000.00,'cash','credit','sell',153,1,'2021-09-28 16:16:38','2021-09-28 16:16:38'),(986,34,10.00,'cash','credit','sell',1042,NULL,'2021-09-28 16:22:50','2021-09-28 16:22:50'),(987,34,0.00,'cash','credit','sell',1042,NULL,'2021-09-28 16:22:50','2021-09-28 16:22:50'),(988,34,6950.00,'cash','credit','sell',1043,NULL,'2021-09-28 16:29:36','2021-09-28 16:29:36'),(989,34,0.00,'cash','credit','sell',1043,NULL,'2021-09-28 16:29:36','2021-09-28 16:29:36'),(992,34,61350.00,'cash','credit','sell',1045,NULL,'2021-09-28 16:34:07','2021-09-28 16:34:07'),(993,34,0.00,'cash','credit','sell',1045,NULL,'2021-09-28 16:34:07','2021-09-28 16:34:07'),(994,34,26250.00,'cash','credit','sell',1046,NULL,'2021-09-28 16:34:56','2021-09-28 16:34:56'),(995,34,0.00,'cash','credit','sell',1046,NULL,'2021-09-28 16:34:56','2021-09-28 16:34:56'),(996,34,2470.00,'cash','credit','sell',1047,NULL,'2021-09-28 16:38:55','2021-09-28 16:38:55'),(997,34,0.00,'cash','credit','sell',1047,NULL,'2021-09-28 16:38:55','2021-09-28 16:38:55'),(998,34,1080.00,'cash','credit','sell',1050,NULL,'2021-09-28 16:45:38','2021-09-28 16:45:38'),(999,34,0.00,'cash','credit','sell',1050,NULL,'2021-09-28 16:45:38','2021-09-28 16:45:38'),(1000,34,425.00,'cash','credit','sell',1052,NULL,'2021-09-28 16:53:10','2021-09-28 16:53:10'),(1001,34,0.00,'cash','credit','sell',1052,NULL,'2021-09-28 16:53:10','2021-09-28 16:53:10'),(1002,34,13910.00,'cash','credit','sell',1053,NULL,'2021-09-28 17:00:22','2021-09-28 17:00:22'),(1003,34,0.00,'cash','credit','sell',1053,NULL,'2021-09-28 17:00:22','2021-09-28 17:00:22'),(1004,34,12000.00,'cash','credit','sell',1054,NULL,'2021-09-28 17:11:09','2021-09-28 17:11:09'),(1005,34,0.00,'cash','credit','sell',1054,NULL,'2021-09-28 17:11:09','2021-09-28 17:11:09'),(1006,34,0.00,'cash','credit','sell',1055,NULL,'2021-09-28 17:12:07','2021-09-28 17:12:07'),(1007,34,0.00,'cash','credit','sell',1055,NULL,'2021-09-28 17:12:07','2021-09-28 17:12:07'),(1008,34,800.00,'cash','credit','sell',1056,NULL,'2021-09-28 17:12:54','2021-09-28 17:12:54'),(1009,34,0.00,'cash','credit','sell',1056,NULL,'2021-09-28 17:12:54','2021-09-28 17:12:54'),(1010,34,1000.00,'cash','credit','sell',362,1,'2021-09-28 17:13:37','2021-09-28 17:13:37'),(1011,34,1000.00,'cash','credit','sell',762,1,'2021-09-28 17:13:59','2021-09-28 17:13:59'),(1012,34,6000.00,'cash','credit','sell',425,1,'2021-09-28 17:14:13','2021-09-28 17:14:13'),(1013,34,6000.00,'cash','credit','sell',429,1,'2021-09-28 17:14:57','2021-09-28 17:14:57'),(1014,34,11960.00,'cash','credit','sell',743,1,'2021-09-28 17:15:18','2021-09-28 17:15:18'),(1015,34,28700.00,'cash','credit','sell',1058,NULL,'2021-09-28 17:17:44','2021-09-28 17:17:44'),(1016,34,0.00,'cash','credit','sell',1058,NULL,'2021-09-28 17:17:44','2021-09-28 17:17:44'),(1017,34,0.00,'cash','credit','sell',1059,NULL,'2021-09-28 17:18:06','2021-09-28 17:18:06'),(1018,34,0.00,'cash','credit','sell',1059,NULL,'2021-09-28 17:18:06','2021-09-28 17:18:06'),(1019,34,0.00,'cash','credit','sell',1060,NULL,'2021-09-28 17:18:36','2021-09-28 17:18:36'),(1020,34,0.00,'cash','credit','sell',1060,NULL,'2021-09-28 17:18:36','2021-09-28 17:18:36'),(1021,34,24993.00,'cash','credit','sell',1061,NULL,'2021-09-28 17:20:48','2021-09-28 17:20:48'),(1022,34,0.00,'cash','credit','sell',1061,NULL,'2021-09-28 17:20:48','2021-09-28 17:20:48'),(1023,35,261075.00,'cash','credit','initial',NULL,NULL,'2021-09-29 13:08:07','2021-09-29 13:08:07'),(1024,35,26410.00,'cash','credit','sell',1066,NULL,'2021-09-29 13:12:33','2021-09-29 13:12:33'),(1025,35,0.00,'cash','credit','sell',1066,NULL,'2021-09-29 13:12:33','2021-09-29 13:12:33'),(1026,35,0.00,'cash','credit','sell',1067,NULL,'2021-09-29 13:13:17','2021-09-29 13:13:17'),(1027,35,0.00,'cash','credit','sell',1067,NULL,'2021-09-29 13:13:17','2021-09-29 13:13:17'),(1028,35,100.00,'cash','credit','sell',1068,NULL,'2021-09-29 13:13:46','2021-09-29 13:13:46'),(1029,35,0.00,'cash','credit','sell',1068,NULL,'2021-09-29 13:13:46','2021-09-29 13:13:46'),(1030,35,28000.00,'cash','credit','sell',1069,NULL,'2021-09-29 13:14:02','2021-09-29 13:14:02'),(1031,35,0.00,'cash','credit','sell',1069,NULL,'2021-09-29 13:14:02','2021-09-29 13:14:02'),(1032,35,1000.00,'cash','credit','sell',115,1,'2021-09-29 13:14:23','2021-09-29 13:14:23'),(1033,35,1000.00,'cash','credit','sell',699,1,'2021-09-29 13:14:37','2021-09-29 13:14:37'),(1034,35,50.00,'cash','credit','sell',289,1,'2021-09-29 13:14:49','2021-09-29 13:14:49'),(1035,35,1000.00,'cash','credit','sell',142,1,'2021-09-29 13:15:02','2021-09-29 13:15:02'),(1036,35,100.00,'cash','credit','sell',442,1,'2021-09-29 13:15:21','2021-09-29 13:15:21'),(1037,35,1700.00,'cash','credit','sell',966,1,'2021-09-29 13:15:33','2021-09-29 13:15:33'),(1038,35,46877.00,'cash','credit','sell',1070,NULL,'2021-09-29 13:17:16','2021-09-29 13:17:16'),(1039,35,0.00,'cash','credit','sell',1070,NULL,'2021-09-29 13:17:16','2021-09-29 13:17:16'),(1040,35,27950.00,'cash','credit','sell',1075,NULL,'2021-09-29 13:24:59','2021-09-29 13:24:59'),(1041,35,0.00,'cash','credit','sell',1075,NULL,'2021-09-29 13:24:59','2021-09-29 13:24:59'),(1042,35,1450.00,'cash','credit','sell',1076,NULL,'2021-09-29 13:25:21','2021-09-29 13:25:21'),(1043,35,0.00,'cash','credit','sell',1076,NULL,'2021-09-29 13:25:21','2021-09-29 13:25:21'),(1044,35,0.00,'cash','credit','sell',1077,NULL,'2021-09-29 13:26:11','2021-09-29 13:26:11'),(1045,35,0.00,'cash','credit','sell',1077,NULL,'2021-09-29 13:26:11','2021-09-29 13:26:11'),(1046,35,0.00,'cash','credit','sell',1078,NULL,'2021-09-29 13:26:38','2021-09-29 13:26:38'),(1047,35,0.00,'cash','credit','sell',1078,NULL,'2021-09-29 13:26:38','2021-09-29 13:26:38'),(1048,35,3400.00,'cash','credit','sell',378,1,'2021-09-29 13:27:02','2021-09-29 13:27:02'),(1049,35,5000.00,'cash','credit','sell',416,1,'2021-09-29 13:27:14','2021-09-29 13:27:14'),(1050,35,1300.00,'cash','credit','sell',644,1,'2021-09-29 13:27:37','2021-09-29 13:27:37'),(1051,35,1300.00,'cash','credit','sell',813,1,'2021-09-29 13:27:37','2021-09-29 13:27:37'),(1052,35,9000.00,'cash','credit','sell',428,1,'2021-09-29 13:28:01','2021-09-29 13:28:01'),(1053,35,8400.00,'cash','credit','sell',412,1,'2021-09-29 13:28:29','2021-09-29 13:28:29'),(1054,35,400.00,'cash','credit','sell',384,1,'2021-09-29 13:28:47','2021-09-29 13:28:47'),(1055,35,3220.00,'cash','credit','sell',1079,NULL,'2021-09-29 13:29:25','2021-09-29 13:29:25'),(1056,35,0.00,'cash','credit','sell',1079,NULL,'2021-09-29 13:29:25','2021-09-29 13:29:25'),(1057,35,4000.00,'cash','credit','sell',1055,1,'2021-09-29 13:29:49','2021-09-29 13:29:49'),(1058,35,9550.00,'cash','credit','sell',1083,NULL,'2021-09-29 14:22:39','2021-09-29 14:22:39'),(1059,35,0.00,'cash','credit','sell',1083,NULL,'2021-09-29 14:22:39','2021-09-29 14:22:39'),(1060,35,5500.00,'cash','credit','sell',1084,NULL,'2021-09-29 14:27:24','2021-09-29 14:27:24'),(1061,35,0.00,'cash','credit','sell',1084,NULL,'2021-09-29 14:27:24','2021-09-29 14:27:24'),(1062,35,25700.00,'cash','credit','sell',1085,NULL,'2021-09-29 14:28:13','2021-09-29 14:28:13'),(1063,35,0.00,'cash','credit','sell',1085,NULL,'2021-09-29 14:28:13','2021-09-29 14:28:13'),(1064,35,41000.00,'cash','credit','sell',1086,NULL,'2021-09-29 14:30:45','2021-09-29 14:30:45'),(1065,35,0.00,'cash','credit','sell',1086,NULL,'2021-09-29 14:30:45','2021-09-29 14:30:45'),(1066,35,13370.00,'cash','credit','sell',1087,NULL,'2021-09-29 14:31:52','2021-09-29 14:31:52'),(1067,35,0.00,'cash','credit','sell',1087,NULL,'2021-09-29 14:31:52','2021-09-29 14:31:52'),(1068,35,5650.00,'cash','credit','sell',1088,NULL,'2021-09-29 14:32:47','2021-09-29 14:32:47'),(1069,35,0.00,'cash','credit','sell',1088,NULL,'2021-09-29 14:32:47','2021-09-29 14:32:47'),(1070,35,32815.02,'cash','credit','sell',1089,NULL,'2021-09-29 14:41:34','2021-09-29 14:41:34'),(1071,35,0.00,'cash','credit','sell',1089,NULL,'2021-09-29 14:41:34','2021-09-29 14:41:34'),(1072,35,4000.00,'cash','credit','sell',1090,NULL,'2021-09-29 14:41:50','2021-09-29 14:41:50'),(1073,35,0.00,'cash','credit','sell',1090,NULL,'2021-09-29 14:41:50','2021-09-29 14:41:50'),(1074,35,8000.00,'cash','credit','sell',1014,1,'2021-09-29 14:45:45','2021-09-29 14:45:45'),(1075,36,559402.00,'cash','credit','initial',NULL,NULL,'2021-09-30 15:53:23','2021-09-30 15:53:23'),(1076,36,16391.00,'cash','credit','sell',1094,NULL,'2021-09-30 15:56:57','2021-09-30 15:56:57'),(1077,36,0.00,'cash','credit','sell',1094,NULL,'2021-09-30 15:56:57','2021-09-30 15:56:57'),(1078,36,2450.00,'cash','credit','sell',1095,NULL,'2021-09-30 15:58:09','2021-09-30 15:58:09'),(1079,36,0.00,'cash','credit','sell',1095,NULL,'2021-09-30 15:58:09','2021-09-30 15:58:09'),(1080,36,1200.00,'cash','credit','sell',1096,NULL,'2021-09-30 15:58:47','2021-09-30 15:58:47'),(1081,36,0.00,'cash','credit','sell',1096,NULL,'2021-09-30 15:58:47','2021-09-30 15:58:47'),(1082,36,0.00,'cash','credit','sell',1097,NULL,'2021-09-30 15:59:30','2021-09-30 15:59:30'),(1083,36,0.00,'cash','credit','sell',1097,NULL,'2021-09-30 15:59:30','2021-09-30 15:59:30'),(1084,36,0.00,'cash','credit','sell',1098,NULL,'2021-09-30 15:59:50','2021-09-30 15:59:50'),(1085,36,0.00,'cash','credit','sell',1098,NULL,'2021-09-30 15:59:50','2021-09-30 15:59:50'),(1086,36,20500.00,'cash','credit','sell',1086,1,'2021-09-30 16:00:07','2021-09-30 16:00:07'),(1092,37,591269.00,'cash','credit','initial',NULL,NULL,'2021-10-01 23:10:17','2021-10-01 23:10:17'),(1093,37,12030.00,'cash','credit','sell',1104,NULL,'2021-10-02 14:26:17','2021-10-02 14:26:17'),(1094,37,0.00,'cash','credit','sell',1104,NULL,'2021-10-02 14:26:17','2021-10-02 14:26:17'),(1095,37,800.00,'cash','credit','sell',1084,1,'2021-10-02 14:26:47','2021-10-02 14:26:47'),(1096,37,200.00,'cash','credit','sell',1095,1,'2021-10-02 14:27:13','2021-10-02 14:27:13'),(1097,37,1080.00,'cash','credit','sell',1097,1,'2021-10-02 14:27:33','2021-10-02 14:27:33'),(1098,37,2000.00,'cash','credit','sell',153,1,'2021-10-02 14:27:47','2021-10-02 14:27:47'),(1099,37,2000.00,'cash','credit','sell',987,1,'2021-10-02 14:28:10','2021-10-02 14:28:10'),(1100,37,4000.00,'cash','credit','sell',838,1,'2021-10-02 14:28:24','2021-10-02 14:28:24'),(1101,37,2500.00,'cash','credit','sell',737,1,'2021-10-02 14:28:37','2021-10-02 14:28:37'),(1102,37,200.00,'cash','credit','sell',1105,NULL,'2021-10-02 14:29:07','2021-10-02 14:29:07'),(1103,37,0.00,'cash','credit','sell',1105,NULL,'2021-10-02 14:29:07','2021-10-02 14:29:07'),(1104,37,0.00,'cash','credit','sell',1106,NULL,'2021-10-02 14:29:33','2021-10-02 14:29:33'),(1105,37,0.00,'cash','credit','sell',1106,NULL,'2021-10-02 14:29:33','2021-10-02 14:29:33'),(1106,37,3249.00,'cash','credit','sell',1108,NULL,'2021-10-02 14:31:27','2021-10-02 14:31:27'),(1107,37,0.00,'cash','credit','sell',1108,NULL,'2021-10-02 14:31:27','2021-10-02 14:31:27'),(1108,37,16000.00,'cash','credit','sell',1109,NULL,'2021-10-02 14:31:58','2021-10-02 14:31:58'),(1109,37,0.00,'cash','credit','sell',1109,NULL,'2021-10-02 14:31:58','2021-10-02 14:31:58'),(1110,38,102538.00,'cash','credit','initial',NULL,NULL,'2021-10-02 14:36:39','2021-10-02 14:36:39'),(1113,38,18630.00,'cash','credit','sell',1112,NULL,'2021-10-03 13:13:56','2021-10-03 13:13:56'),(1114,38,0.00,'cash','credit','sell',1112,NULL,'2021-10-03 13:13:56','2021-10-03 13:13:56'),(1115,38,0.00,'cash','credit','sell',1113,NULL,'2021-10-03 13:14:32','2021-10-03 13:14:32'),(1116,38,0.00,'cash','credit','sell',1113,NULL,'2021-10-03 13:14:32','2021-10-03 13:14:32'),(1117,38,1800.00,'cash','credit','sell',1114,NULL,'2021-10-03 13:15:16','2021-10-03 13:15:16'),(1118,38,0.00,'cash','credit','sell',1114,NULL,'2021-10-03 13:15:16','2021-10-03 13:15:16'),(1119,38,26835.00,'cash','credit','sell',1115,NULL,'2021-10-03 13:16:19','2021-10-03 13:16:19'),(1120,38,0.00,'cash','credit','sell',1115,NULL,'2021-10-03 13:16:19','2021-10-03 13:16:19'),(1121,38,1000.00,'cash','credit','sell',893,1,'2021-10-03 13:16:45','2021-10-03 13:16:45'),(1122,38,3700.00,'cash','credit','sell',366,1,'2021-10-03 13:17:05','2021-10-03 13:17:05'),(1123,38,4000.00,'cash','credit','sell',98,1,'2021-10-03 13:17:25','2021-10-03 13:17:25'),(1124,38,1100.00,'cash','credit','sell',1116,NULL,'2021-10-03 13:17:39','2021-10-03 13:17:39'),(1125,38,0.00,'cash','credit','sell',1116,NULL,'2021-10-03 13:17:39','2021-10-03 13:17:39'),(1126,38,10420.00,'cash','credit','sell',1119,NULL,'2021-10-03 16:35:16','2021-10-03 16:35:16'),(1127,38,0.00,'cash','credit','sell',1119,NULL,'2021-10-03 16:35:16','2021-10-03 16:35:16'),(1128,38,29501.00,'cash','credit','sell',1120,NULL,'2021-10-03 16:36:36','2021-10-03 16:36:36'),(1129,38,0.00,'cash','credit','sell',1120,NULL,'2021-10-03 16:36:36','2021-10-03 16:36:36'),(1130,38,42000.00,'cash','credit','sell',1121,NULL,'2021-10-03 16:37:37','2021-10-03 16:37:37'),(1131,38,0.00,'cash','credit','sell',1121,NULL,'2021-10-03 16:37:37','2021-10-03 16:37:37'),(1132,38,0.00,'cash','credit','sell',1122,NULL,'2021-10-03 16:41:24','2021-10-03 16:41:24'),(1133,38,0.00,'cash','credit','sell',1122,NULL,'2021-10-03 16:41:24','2021-10-03 16:41:24'),(1134,38,0.00,'cash','credit','sell',1123,NULL,'2021-10-03 16:42:20','2021-10-03 16:42:20'),(1135,38,0.00,'cash','credit','sell',1123,NULL,'2021-10-03 16:42:20','2021-10-03 16:42:20'),(1136,38,12000.00,'cash','credit','sell',1124,NULL,'2021-10-03 16:42:59','2021-10-03 16:42:59'),(1137,38,0.00,'cash','credit','sell',1124,NULL,'2021-10-03 16:42:59','2021-10-03 16:42:59'),(1138,38,1100.00,'cash','credit','sell',378,1,'2021-10-03 16:46:03','2021-10-03 16:46:03'),(1139,38,2250.00,'cash','credit','sell',370,1,'2021-10-03 16:46:13','2021-10-03 16:46:13'),(1140,38,500.00,'cash','credit','sell',1096,1,'2021-10-03 16:46:26','2021-10-03 16:46:26'),(1141,38,5000.00,'cash','credit','sell',1115,1,'2021-10-03 16:47:01','2021-10-03 16:47:01'),(1142,39,208995.00,'cash','credit','initial',NULL,NULL,'2021-10-04 14:35:18','2021-10-04 14:35:18'),(1143,39,16960.00,'cash','credit','sell',1128,NULL,'2021-10-04 14:38:49','2021-10-04 14:38:49'),(1144,39,0.00,'cash','credit','sell',1128,NULL,'2021-10-04 14:38:49','2021-10-04 14:38:49'),(1145,39,11240.00,'cash','credit','sell',1129,NULL,'2021-10-04 14:40:06','2021-10-04 14:40:06'),(1146,39,0.00,'cash','credit','sell',1129,NULL,'2021-10-04 14:40:06','2021-10-04 14:40:06'),(1147,39,21500.00,'cash','credit','sell',1130,NULL,'2021-10-04 14:40:36','2021-10-04 14:40:36'),(1148,39,0.00,'cash','credit','sell',1130,NULL,'2021-10-04 14:40:36','2021-10-04 14:40:36'),(1149,39,64800.00,'cash','credit','sell',1131,NULL,'2021-10-04 14:41:33','2021-10-04 14:41:33'),(1150,39,0.00,'cash','credit','sell',1131,NULL,'2021-10-04 14:41:33','2021-10-04 14:41:33'),(1151,39,1000.00,'cash','credit','sell',699,1,'2021-10-04 14:41:51','2021-10-04 14:41:51'),(1152,39,1000.00,'cash','credit','sell',142,1,'2021-10-04 14:42:00','2021-10-04 14:42:00'),(1153,39,200.00,'cash','credit','sell',65,1,'2021-10-04 14:42:15','2021-10-04 14:42:15'),(1154,39,2600.00,'cash','credit','sell',1113,1,'2021-10-04 14:42:32','2021-10-04 14:42:32'),(1155,39,1000.00,'cash','credit','sell',837,1,'2021-10-04 14:42:56','2021-10-04 14:42:56'),(1156,39,2000.00,'cash','credit','sell',77,1,'2021-10-04 14:43:15','2021-10-04 14:43:15'),(1157,39,26000.00,'cash','credit','sell',846,1,'2021-10-04 14:43:25','2021-10-04 14:43:25'),(1158,39,900.00,'cash','credit','sell',442,1,'2021-10-04 14:43:53','2021-10-04 14:43:53'),(1163,40,342495.00,'cash','credit','initial',NULL,NULL,'2021-10-05 16:41:20','2021-10-05 16:41:20'),(1164,40,6260.00,'cash','credit','sell',1136,NULL,'2021-10-05 16:47:21','2021-10-05 16:47:21'),(1165,40,0.00,'cash','credit','sell',1136,NULL,'2021-10-05 16:47:21','2021-10-05 16:47:21'),(1166,40,800.00,'cash','credit','sell',1137,NULL,'2021-10-05 16:48:20','2021-10-05 16:48:20'),(1167,40,0.00,'cash','credit','sell',1137,NULL,'2021-10-05 16:48:20','2021-10-05 16:48:20'),(1168,40,15800.00,'cash','credit','sell',1138,NULL,'2021-10-05 16:48:59','2021-10-05 16:48:59'),(1169,40,0.00,'cash','credit','sell',1138,NULL,'2021-10-05 16:48:59','2021-10-05 16:48:59'),(1170,40,18300.00,'cash','credit','sell',1139,NULL,'2021-10-05 16:49:34','2021-10-05 16:49:34'),(1171,40,0.00,'cash','credit','sell',1139,NULL,'2021-10-05 16:49:34','2021-10-05 16:49:34'),(1172,40,1000.00,'cash','credit','sell',1140,NULL,'2021-10-05 16:50:14','2021-10-05 16:50:14'),(1173,40,0.00,'cash','credit','sell',1140,NULL,'2021-10-05 16:50:14','2021-10-05 16:50:14'),(1174,40,1500.00,'cash','credit','sell',1141,NULL,'2021-10-05 16:50:44','2021-10-05 16:50:44'),(1175,40,0.00,'cash','credit','sell',1141,NULL,'2021-10-05 16:50:44','2021-10-05 16:50:44'),(1176,40,17150.00,'cash','credit','sell',1142,NULL,'2021-10-05 16:52:28','2021-10-05 16:52:28'),(1177,40,0.00,'cash','credit','sell',1142,NULL,'2021-10-05 16:52:28','2021-10-05 16:52:28'),(1178,40,0.00,'cash','credit','sell',1143,NULL,'2021-10-05 16:52:48','2021-10-05 16:52:48'),(1179,40,0.00,'cash','credit','sell',1143,NULL,'2021-10-05 16:52:48','2021-10-05 16:52:48'),(1180,40,1050.00,'cash','credit','sell',1059,1,'2021-10-05 16:53:28','2021-10-05 16:53:28'),(1181,40,8000.00,'cash','credit','sell',376,1,'2021-10-05 16:53:46','2021-10-05 16:53:46'),(1182,40,5000.00,'cash','credit','sell',894,1,'2021-10-05 16:54:01','2021-10-05 16:54:01'),(1183,40,500.00,'cash','credit','sell',57,1,'2021-10-05 16:54:14','2021-10-05 16:54:14'),(1184,40,450.00,'cash','credit','sell',442,1,'2021-10-05 16:54:30','2021-10-05 16:54:30'),(1185,40,1800.00,'cash','credit','sell',909,1,'2021-10-05 16:55:51','2021-10-05 16:55:51'),(1186,40,300.00,'cash','credit','sell',939,1,'2021-10-05 16:55:51','2021-10-05 16:55:51'),(1187,40,925.00,'cash','credit','sell',953,1,'2021-10-05 16:55:51','2021-10-05 16:55:51'),(1188,40,350.00,'cash','credit','sell',990,1,'2021-10-05 16:55:51','2021-10-05 16:55:51'),(1189,40,250.00,'cash','credit','sell',1078,1,'2021-10-05 16:55:51','2021-10-05 16:55:51'),(1190,40,4140.00,'cash','credit','sell',1122,1,'2021-10-05 16:55:51','2021-10-05 16:55:51'),(1191,41,409555.00,'cash','credit','initial',NULL,NULL,'2021-10-05 17:08:36','2021-10-05 17:08:36'),(1193,41,8690.00,'cash','credit','sell',1151,NULL,'2021-10-06 14:33:25','2021-10-06 14:33:25'),(1194,41,0.00,'cash','credit','sell',1151,NULL,'2021-10-06 14:33:25','2021-10-06 14:33:25'),(1195,41,4600.00,'cash','credit','sell',1152,NULL,'2021-10-06 14:34:12','2021-10-06 14:34:12'),(1196,41,0.00,'cash','credit','sell',1152,NULL,'2021-10-06 14:34:12','2021-10-06 14:34:12'),(1197,41,0.00,'cash','credit','sell',1153,NULL,'2021-10-06 14:35:08','2021-10-06 14:35:08'),(1198,41,0.00,'cash','credit','sell',1153,NULL,'2021-10-06 14:35:08','2021-10-06 14:35:08'),(1199,41,0.00,'cash','credit','sell',1154,NULL,'2021-10-06 14:35:28','2021-10-06 14:35:28'),(1200,41,0.00,'cash','credit','sell',1154,NULL,'2021-10-06 14:35:28','2021-10-06 14:35:28'),(1201,41,4103.00,'cash','credit','sell',1155,NULL,'2021-10-06 14:36:29','2021-10-06 14:36:29'),(1202,41,0.00,'cash','credit','sell',1155,NULL,'2021-10-06 14:36:29','2021-10-06 14:36:29'),(1203,41,3100.00,'cash','credit','sell',719,1,'2021-10-06 14:36:56','2021-10-06 14:36:56'),(1204,41,200.00,'cash','credit','sell',384,1,'2021-10-06 14:37:22','2021-10-06 14:37:22'),(1205,41,320.08,'cash','credit','sell',791,1,'2021-10-06 14:37:42','2021-10-06 14:37:42'),(1206,41,879.92,'cash','credit','sell',1143,1,'2021-10-06 14:37:42','2021-10-06 14:37:42'),(1207,41,100.00,'cash','credit','sell',209,1,'2021-10-06 14:38:00','2021-10-06 14:38:00'),(1208,41,950.00,'cash','credit','sell',1106,1,'2021-10-06 14:38:00','2021-10-06 14:38:00'),(1209,41,540.00,'cash','credit','sell',52,1,'2021-10-06 14:38:19','2021-10-06 14:38:19'),(1210,41,1750.00,'cash','credit','sell',834,1,'2021-10-06 14:38:33','2021-10-06 14:38:33'),(1211,41,1050.00,'cash','credit','sell',1156,NULL,'2021-10-06 14:43:25','2021-10-06 14:43:25'),(1212,41,0.00,'cash','credit','sell',1156,NULL,'2021-10-06 14:43:25','2021-10-06 14:43:25'),(1213,41,150.00,'cash','credit','sell',1160,NULL,'2021-10-06 20:17:30','2021-10-06 20:17:30'),(1214,41,0.00,'cash','credit','sell',1160,NULL,'2021-10-06 20:17:30','2021-10-06 20:17:30'),(1215,41,30000.00,'cash','credit','sell',1161,NULL,'2021-10-06 20:18:02','2021-10-06 20:18:02'),(1216,41,0.00,'cash','credit','sell',1161,NULL,'2021-10-06 20:18:02','2021-10-06 20:18:02'),(1217,41,15090.00,'cash','credit','sell',1168,NULL,'2021-10-07 16:14:50','2021-10-07 16:14:50'),(1218,41,0.00,'cash','credit','sell',1168,NULL,'2021-10-07 16:14:50','2021-10-07 16:14:50'),(1219,41,8740.00,'cash','credit','sell',1170,NULL,'2021-10-07 16:17:14','2021-10-07 16:17:14'),(1220,41,0.00,'cash','credit','sell',1170,NULL,'2021-10-07 16:17:14','2021-10-07 16:17:14'),(1221,41,0.00,'cash','credit','sell',1171,NULL,'2021-10-07 16:17:38','2021-10-07 16:17:38'),(1222,41,0.00,'cash','credit','sell',1171,NULL,'2021-10-07 16:17:38','2021-10-07 16:17:38'),(1223,41,11345.00,'cash','credit','sell',1172,NULL,'2021-10-07 16:27:35','2021-10-07 16:27:35'),(1224,41,0.00,'cash','credit','sell',1172,NULL,'2021-10-07 16:27:35','2021-10-07 16:27:35'),(1225,41,0.00,'cash','credit','sell',1173,NULL,'2021-10-07 16:28:13','2021-10-07 16:28:13'),(1226,41,0.00,'cash','credit','sell',1173,NULL,'2021-10-07 16:28:13','2021-10-07 16:28:13'),(1227,41,28500.00,'cash','credit','sell',1174,NULL,'2021-10-07 16:28:32','2021-10-07 16:28:32'),(1228,41,0.00,'cash','credit','sell',1174,NULL,'2021-10-07 16:28:32','2021-10-07 16:28:32'),(1229,41,0.00,'cash','credit','sell',1175,NULL,'2021-10-07 16:29:01','2021-10-07 16:29:01'),(1230,41,0.00,'cash','credit','sell',1175,NULL,'2021-10-07 16:29:01','2021-10-07 16:29:01'),(1231,41,0.00,'cash','credit','sell',1176,NULL,'2021-10-07 16:29:24','2021-10-07 16:29:24'),(1232,41,0.00,'cash','credit','sell',1176,NULL,'2021-10-07 16:29:24','2021-10-07 16:29:24'),(1233,41,8400.02,'cash','credit','sell',1177,NULL,'2021-10-07 16:30:43','2021-10-07 16:30:43'),(1234,41,0.00,'cash','credit','sell',1177,NULL,'2021-10-07 16:30:43','2021-10-07 16:30:43'),(1235,41,120.00,'cash','credit','sell',1177,NULL,'2021-10-07 17:43:56','2021-10-07 17:43:56'),(1236,42,373138.00,'cash','credit','initial',NULL,NULL,'2021-10-07 21:33:13','2021-10-07 21:33:13'),(1237,42,13392.00,'cash','credit','sell',1180,NULL,'2021-10-08 16:03:31','2021-10-08 16:03:31'),(1238,42,0.00,'cash','credit','sell',1180,NULL,'2021-10-08 16:03:31','2021-10-08 16:03:31'),(1239,42,4700.00,'cash','credit','sell',1181,NULL,'2021-10-08 16:04:25','2021-10-08 16:04:25'),(1240,42,0.00,'cash','credit','sell',1181,NULL,'2021-10-08 16:04:25','2021-10-08 16:04:25'),(1241,42,0.00,'cash','credit','sell',1182,NULL,'2021-10-08 16:05:32','2021-10-08 16:05:32'),(1242,42,0.00,'cash','credit','sell',1182,NULL,'2021-10-08 16:05:32','2021-10-08 16:05:32'),(1243,42,2300.00,'cash','credit','sell',1183,NULL,'2021-10-08 16:05:48','2021-10-08 16:05:48'),(1244,42,0.00,'cash','credit','sell',1183,NULL,'2021-10-08 16:05:48','2021-10-08 16:05:48'),(1245,42,41810.00,'cash','credit','sell',1184,NULL,'2021-10-08 16:08:36','2021-10-08 16:08:36'),(1246,42,0.00,'cash','credit','sell',1184,NULL,'2021-10-08 16:08:36','2021-10-08 16:08:36'),(1247,42,4750.00,'cash','credit','sell',1185,NULL,'2021-10-08 16:09:24','2021-10-08 16:09:24'),(1248,42,0.00,'cash','credit','sell',1185,NULL,'2021-10-08 16:09:24','2021-10-08 16:09:24'),(1249,42,4200.00,'cash','credit','sell',1186,NULL,'2021-10-08 16:10:07','2021-10-08 16:10:07'),(1250,42,0.00,'cash','credit','sell',1186,NULL,'2021-10-08 16:10:07','2021-10-08 16:10:07'),(1251,42,555.00,'cash','credit','sell',1187,NULL,'2021-10-08 16:10:54','2021-10-08 16:10:54'),(1252,42,0.00,'cash','credit','sell',1187,NULL,'2021-10-08 16:10:54','2021-10-08 16:10:54'),(1253,42,300.00,'cash','credit','sell',663,1,'2021-10-08 16:11:30','2021-10-08 16:11:30'),(1254,42,200.00,'cash','credit','sell',773,1,'2021-10-08 16:11:30','2021-10-08 16:11:30'),(1255,42,300.00,'cash','credit','sell',1140,1,'2021-10-08 16:11:48','2021-10-08 16:11:48'),(1256,42,1000.00,'cash','credit','sell',68,1,'2021-10-08 16:12:06','2021-10-08 16:12:06'),(1257,42,2000.00,'cash','credit','sell',838,1,'2021-10-08 16:12:22','2021-10-08 16:12:22'),(1258,42,1000.00,'cash','credit','sell',99,1,'2021-10-08 16:12:32','2021-10-08 16:12:32'),(1259,42,28.00,'cash','credit','sell',1188,NULL,'2021-10-08 16:14:26','2021-10-08 16:14:26'),(1260,42,0.00,'cash','credit','sell',1188,NULL,'2021-10-08 16:14:26','2021-10-08 16:14:26'),(1261,42,1500.00,'cash','credit','sell',4,1,'2021-10-08 16:25:04','2021-10-08 16:25:04'),(1262,42,120.00,'cash','credit','sell',1067,1,'2021-10-08 16:27:22','2021-10-08 16:27:22'),(1263,42,500.00,'cash','credit','sell',436,1,'2021-10-08 16:27:50','2021-10-08 16:27:50'),(1264,42,150.00,'cash','credit','sell',1191,NULL,'2021-10-08 16:28:39','2021-10-08 16:28:39'),(1265,42,0.00,'cash','credit','sell',1191,NULL,'2021-10-08 16:28:39','2021-10-08 16:28:39'),(1266,43,377008.00,'cash','credit','initial',NULL,NULL,'2021-10-08 16:34:46','2021-10-08 16:34:46'),(1277,43,45.00,'cash','credit','sell',1198,NULL,'2021-10-09 19:31:37','2021-10-09 19:31:37'),(1278,43,0.00,'cash','credit','sell',1198,NULL,'2021-10-09 19:31:37','2021-10-09 19:31:37'),(1279,43,4000.00,'cash','credit','sell',1199,NULL,'2021-10-09 19:33:28','2021-10-09 19:33:28'),(1280,43,0.00,'cash','credit','sell',1199,NULL,'2021-10-09 19:33:28','2021-10-09 19:33:28'),(1284,43,15580.00,'cash','credit','sell',1201,NULL,'2021-10-09 19:56:42','2021-10-09 19:56:42'),(1285,43,0.00,'cash','credit','sell',1201,NULL,'2021-10-09 19:56:42','2021-10-09 19:56:42'),(1286,43,50.00,'cash','credit','sell',1203,NULL,'2021-10-09 20:03:54','2021-10-09 20:03:54'),(1287,43,0.00,'cash','credit','sell',1203,NULL,'2021-10-09 20:03:54','2021-10-09 20:03:54'),(1288,43,4754.29,'cash','credit','sell',1204,NULL,'2021-10-09 20:28:04','2021-10-09 20:28:04'),(1289,43,0.00,'cash','credit','sell',1204,NULL,'2021-10-09 20:28:04','2021-10-09 20:28:04'),(1290,43,25.71,'cash','credit','sell',1205,NULL,'2021-10-09 20:28:33','2021-10-09 20:28:33'),(1291,43,0.00,'cash','credit','sell',1205,NULL,'2021-10-09 20:28:33','2021-10-09 20:28:33'),(1292,43,6736.00,'cash','credit','sell',1206,NULL,'2021-10-09 20:29:49','2021-10-09 20:29:49'),(1293,43,0.00,'cash','credit','sell',1206,NULL,'2021-10-09 20:29:49','2021-10-09 20:29:49'),(1294,43,1250.00,'cash','credit','sell',1207,NULL,'2021-10-09 20:30:31','2021-10-09 20:30:31'),(1295,43,0.00,'cash','credit','sell',1207,NULL,'2021-10-09 20:30:31','2021-10-09 20:30:31'),(1296,43,2500.00,'cash','credit','sell',1208,NULL,'2021-10-09 20:31:30','2021-10-09 20:31:30'),(1297,43,0.00,'cash','credit','sell',1208,NULL,'2021-10-09 20:31:30','2021-10-09 20:31:30'),(1300,43,320.00,'cash','credit','sell',1210,NULL,'2021-10-09 20:34:09','2021-10-09 20:34:09'),(1301,43,0.00,'cash','credit','sell',1210,NULL,'2021-10-09 20:34:09','2021-10-09 20:34:09'),(1304,43,50.00,'cash','credit','sell',442,1,'2021-10-09 20:42:29','2021-10-09 20:42:29'),(1305,43,1500.00,'cash','credit','sell',891,1,'2021-10-09 20:42:43','2021-10-09 20:42:43'),(1306,43,0.00,'cash','credit','sell',1214,NULL,'2021-10-09 20:47:52','2021-10-09 20:47:52'),(1307,43,0.00,'cash','credit','sell',1214,NULL,'2021-10-09 20:47:52','2021-10-09 20:47:52'),(1308,43,200.00,'cash','credit','sell',1215,NULL,'2021-10-09 20:48:10','2021-10-09 20:48:10'),(1309,43,0.00,'cash','credit','sell',1215,NULL,'2021-10-09 20:48:10','2021-10-09 20:48:10'),(1310,44,403529.00,'cash','credit','initial',NULL,NULL,'2021-10-09 23:04:06','2021-10-09 23:04:06'),(1311,44,5205.00,'cash','credit','sell',1216,NULL,'2021-10-10 13:26:39','2021-10-10 13:26:39'),(1312,44,0.00,'cash','credit','sell',1216,NULL,'2021-10-10 13:26:39','2021-10-10 13:26:39'),(1313,44,28500.00,'cash','credit','sell',1217,NULL,'2021-10-10 13:26:53','2021-10-10 13:26:53'),(1314,44,0.00,'cash','credit','sell',1217,NULL,'2021-10-10 13:26:53','2021-10-10 13:26:53'),(1315,44,0.00,'cash','credit','sell',1218,NULL,'2021-10-10 13:27:33','2021-10-10 13:27:33'),(1316,44,0.00,'cash','credit','sell',1218,NULL,'2021-10-10 13:27:33','2021-10-10 13:27:33'),(1317,44,21700.00,'cash','credit','sell',1219,NULL,'2021-10-10 13:31:59','2021-10-10 13:31:59'),(1318,44,0.00,'cash','credit','sell',1219,NULL,'2021-10-10 13:31:59','2021-10-10 13:31:59'),(1319,44,500.00,'cash','credit','sell',1220,NULL,'2021-10-10 13:36:27','2021-10-10 13:36:27'),(1320,44,0.00,'cash','credit','sell',1220,NULL,'2021-10-10 13:36:27','2021-10-10 13:36:27'),(1321,44,4820.00,'cash','credit','sell',1221,NULL,'2021-10-10 13:36:53','2021-10-10 13:36:53'),(1322,44,0.00,'cash','credit','sell',1221,NULL,'2021-10-10 13:36:53','2021-10-10 13:36:53'),(1323,44,1165.00,'cash','credit','sell',1222,NULL,'2021-10-10 13:37:32','2021-10-10 13:37:32'),(1324,44,0.00,'cash','credit','sell',1222,NULL,'2021-10-10 13:37:32','2021-10-10 13:37:32'),(1325,44,8000.30,'cash','credit','sell',1225,NULL,'2021-10-10 14:03:24','2021-10-10 14:03:24'),(1326,44,0.00,'cash','credit','sell',1225,NULL,'2021-10-10 14:03:24','2021-10-10 14:03:24'),(1327,44,4000.00,'cash','credit','sell',146,1,'2021-10-10 14:03:45','2021-10-10 14:03:45'),(1328,44,1000.00,'cash','credit','sell',442,1,'2021-10-10 14:03:57','2021-10-10 14:03:57'),(1329,44,1000.00,'cash','credit','sell',1046,1,'2021-10-10 14:04:06','2021-10-10 14:04:06'),(1330,44,150.00,'cash','credit','sell',442,1,'2021-10-10 14:04:19','2021-10-10 14:04:19'),(1343,45,465828.30,'cash','credit','initial',NULL,NULL,'2021-10-11 14:06:04','2021-10-11 14:06:04'),(1344,45,22790.00,'cash','credit','sell',1233,NULL,'2021-10-11 14:11:29','2021-10-11 14:11:29'),(1345,45,0.00,'cash','credit','sell',1233,NULL,'2021-10-11 14:11:29','2021-10-11 14:11:29'),(1346,45,2000.00,'cash','credit','sell',1234,NULL,'2021-10-11 14:12:07','2021-10-11 14:12:07'),(1347,45,0.00,'cash','credit','sell',1234,NULL,'2021-10-11 14:12:07','2021-10-11 14:12:07'),(1348,45,1700.00,'cash','credit','sell',1235,NULL,'2021-10-11 14:12:44','2021-10-11 14:12:44'),(1349,45,0.00,'cash','credit','sell',1235,NULL,'2021-10-11 14:12:44','2021-10-11 14:12:44'),(1350,45,5000.00,'cash','credit','sell',831,1,'2021-10-11 14:13:07','2021-10-11 14:13:07'),(1351,45,4000.00,'cash','credit','sell',1173,1,'2021-10-11 14:13:24','2021-10-11 14:13:24'),(1352,45,5000.00,'cash','credit','sell',904,1,'2021-10-11 14:13:37','2021-10-11 14:13:37'),(1353,45,5000.00,'cash','credit','sell',415,1,'2021-10-11 14:13:57','2021-10-11 14:13:57'),(1354,45,5000.00,'cash','credit','sell',420,1,'2021-10-11 14:14:09','2021-10-11 14:14:09'),(1355,45,1000.00,'cash','credit','sell',142,1,'2021-10-11 14:14:29','2021-10-11 14:14:29'),(1356,45,1000.00,'cash','credit','sell',699,1,'2021-10-11 14:14:46','2021-10-11 14:14:46'),(1357,45,1000.00,'cash','credit','sell',312,1,'2021-10-11 14:15:01','2021-10-11 14:15:01'),(1358,45,80.00,'cash','credit','sell',1060,1,'2021-10-11 14:15:01','2021-10-11 14:15:01'),(1359,45,500.00,'cash','credit','sell',917,1,'2021-10-11 14:15:17','2021-10-11 14:15:17'),(1360,45,20.00,'cash','credit','sell',442,1,'2021-10-11 14:16:09','2021-10-11 14:16:09'),(1361,45,1500.00,'cash','credit','sell',671,1,'2021-10-11 14:16:34','2021-10-11 14:16:34'),(1362,45,3980.00,'cash','credit','sell',1236,NULL,'2021-10-11 14:17:21','2021-10-11 14:17:21'),(1363,45,0.00,'cash','credit','sell',1236,NULL,'2021-10-11 14:17:21','2021-10-11 14:17:21'),(1364,45,900.00,'cash','credit','sell',1239,NULL,'2021-10-11 14:37:52','2021-10-11 14:37:52'),(1365,45,0.00,'cash','credit','sell',1239,NULL,'2021-10-11 14:37:52','2021-10-11 14:37:52'),(1366,45,1000.00,'cash','credit','sell',831,1,'2021-10-11 14:39:24','2021-10-11 14:39:24'),(1368,46,510848.30,'cash','credit','initial',NULL,NULL,'2021-10-12 13:06:26','2021-10-12 13:06:26'),(1369,46,10080.00,'cash','credit','sell',1244,NULL,'2021-10-12 14:17:18','2021-10-12 14:17:18'),(1370,46,0.00,'cash','credit','sell',1244,NULL,'2021-10-12 14:17:18','2021-10-12 14:17:18'),(1371,46,1500.00,'cash','credit','sell',1245,NULL,'2021-10-12 14:17:54','2021-10-12 14:17:54'),(1372,46,0.00,'cash','credit','sell',1245,NULL,'2021-10-12 14:17:54','2021-10-12 14:17:54'),(1373,46,12500.00,'cash','credit','sell',1246,NULL,'2021-10-12 14:18:38','2021-10-12 14:18:38'),(1374,46,0.00,'cash','credit','sell',1246,NULL,'2021-10-12 14:18:38','2021-10-12 14:18:38'),(1375,46,87500.00,'cash','credit','sell',1247,NULL,'2021-10-12 14:19:14','2021-10-12 14:19:14'),(1376,46,0.00,'cash','credit','sell',1247,NULL,'2021-10-12 14:19:14','2021-10-12 14:19:14'),(1377,46,25000.00,'cash','credit','sell',1248,NULL,'2021-10-12 14:20:36','2021-10-12 14:20:36'),(1378,46,0.00,'cash','credit','sell',1248,NULL,'2021-10-12 14:20:36','2021-10-12 14:20:36'),(1379,46,0.00,'cash','credit','sell',1249,NULL,'2021-10-12 14:21:14','2021-10-12 14:21:14'),(1380,46,0.00,'cash','credit','sell',1249,NULL,'2021-10-12 14:21:14','2021-10-12 14:21:14'),(1381,46,5000.00,'cash','credit','sell',1014,1,'2021-10-12 14:25:58','2021-10-12 14:25:58'),(1382,46,4900.00,'cash','credit','sell',66,1,'2021-10-12 14:26:11','2021-10-12 14:26:11'),(1383,46,1000.00,'cash','credit','sell',1056,1,'2021-10-12 14:26:27','2021-10-12 14:26:27'),(1384,46,1800.00,'cash','credit','sell',1250,NULL,'2021-10-12 14:27:19','2021-10-12 14:27:19'),(1385,46,0.00,'cash','credit','sell',1250,NULL,'2021-10-12 14:27:19','2021-10-12 14:27:19'),(1386,46,248.00,'cash','credit','sell',1251,NULL,'2021-10-12 14:28:07','2021-10-12 14:28:07'),(1387,46,0.00,'cash','credit','sell',1251,NULL,'2021-10-12 14:28:07','2021-10-12 14:28:07'),(1388,46,1000.00,'cash','credit','sell',16,1,'2021-10-12 14:28:29','2021-10-12 14:28:29'),(1389,47,604257.00,'cash','credit','initial',NULL,NULL,'2021-10-13 15:37:50','2021-10-13 15:37:50'),(1390,47,20640.00,'cash','credit','sell',1261,NULL,'2021-10-13 15:42:52','2021-10-13 15:42:52'),(1391,47,0.00,'cash','credit','sell',1261,NULL,'2021-10-13 15:42:52','2021-10-13 15:42:52'),(1392,47,4650.00,'cash','credit','sell',1262,NULL,'2021-10-13 15:46:06','2021-10-13 15:46:06'),(1393,47,0.00,'cash','credit','sell',1262,NULL,'2021-10-13 15:46:06','2021-10-13 15:46:06'),(1394,47,5000.00,'cash','credit','sell',1263,NULL,'2021-10-13 15:53:33','2021-10-13 15:53:33'),(1395,47,0.00,'cash','credit','sell',1263,NULL,'2021-10-13 15:53:33','2021-10-13 15:53:33'),(1396,47,8790.00,'cash','credit','sell',1264,NULL,'2021-10-13 15:54:46','2021-10-13 15:54:46'),(1397,47,0.00,'cash','credit','sell',1264,NULL,'2021-10-13 15:54:46','2021-10-13 15:54:46'),(1398,47,0.00,'cash','credit','sell',1265,NULL,'2021-10-13 15:55:18','2021-10-13 15:55:18'),(1399,47,0.00,'cash','credit','sell',1265,NULL,'2021-10-13 15:55:18','2021-10-13 15:55:18'),(1400,47,0.00,'cash','credit','sell',1266,NULL,'2021-10-13 15:56:15','2021-10-13 15:56:15'),(1401,47,0.00,'cash','credit','sell',1266,NULL,'2021-10-13 15:56:15','2021-10-13 15:56:15'),(1402,47,1100.00,'cash','credit','sell',1267,NULL,'2021-10-13 15:56:30','2021-10-13 15:56:30'),(1403,47,0.00,'cash','credit','sell',1267,NULL,'2021-10-13 15:56:30','2021-10-13 15:56:30'),(1404,47,20990.00,'cash','credit','sell',1268,NULL,'2021-10-13 15:56:59','2021-10-13 15:56:59'),(1405,47,0.00,'cash','credit','sell',1268,NULL,'2021-10-13 15:56:59','2021-10-13 15:56:59'),(1406,48,518287.00,'cash','credit','initial',NULL,NULL,'2021-10-13 21:55:22','2021-10-13 21:55:22'),(1409,48,11415.00,'cash','credit','sell',1275,NULL,'2021-10-14 13:34:06','2021-10-14 13:34:06'),(1410,48,0.00,'cash','credit','sell',1275,NULL,'2021-10-14 13:34:06','2021-10-14 13:34:06'),(1411,48,25400.00,'cash','credit','sell',1276,NULL,'2021-10-14 13:34:47','2021-10-14 13:34:47'),(1412,48,0.00,'cash','credit','sell',1276,NULL,'2021-10-14 13:34:47','2021-10-14 13:34:47'),(1413,48,0.00,'cash','credit','sell',1277,NULL,'2021-10-14 13:35:16','2021-10-14 13:35:16'),(1414,48,0.00,'cash','credit','sell',1277,NULL,'2021-10-14 13:35:16','2021-10-14 13:35:16'),(1415,48,30000.00,'cash','credit','sell',1114,1,'2021-10-14 13:35:37','2021-10-14 13:35:37'),(1416,48,1220.00,'cash','credit','sell',1266,1,'2021-10-14 13:35:53','2021-10-14 13:35:53'),(1417,48,6310.00,'cash','credit','sell',1278,NULL,'2021-10-14 13:37:30','2021-10-14 13:37:30'),(1418,48,0.00,'cash','credit','sell',1278,NULL,'2021-10-14 13:37:30','2021-10-14 13:37:30'),(1419,48,8989.93,'cash','credit','sell',1279,NULL,'2021-10-14 13:40:38','2021-10-14 13:40:38'),(1420,48,0.00,'cash','credit','sell',1279,NULL,'2021-10-14 13:40:38','2021-10-14 13:40:38'),(1421,48,5500.00,'cash','credit','sell',1281,NULL,'2021-10-14 13:42:05','2021-10-14 13:42:05'),(1422,48,0.00,'cash','credit','sell',1281,NULL,'2021-10-14 13:42:05','2021-10-14 13:42:05'),(1423,48,2400.00,'cash','credit','sell',779,1,'2021-10-14 13:42:28','2021-10-14 13:42:28'),(1424,48,1250.00,'cash','credit','sell',1282,NULL,'2021-10-14 13:44:12','2021-10-14 13:44:12'),(1425,48,0.00,'cash','credit','sell',1282,NULL,'2021-10-14 13:44:12','2021-10-14 13:44:12'),(1426,48,900.00,'cash','credit','sell',1287,NULL,'2021-10-14 14:07:12','2021-10-14 14:07:12'),(1427,48,0.00,'cash','credit','sell',1287,NULL,'2021-10-14 14:07:12','2021-10-14 14:07:12'),(1433,48,0.00,'cash','credit','sell',1292,NULL,'2021-10-15 00:14:34','2021-10-15 00:14:34'),(1434,48,0.00,'cash','credit','sell',1292,NULL,'2021-10-15 00:14:34','2021-10-15 00:14:34'),(1435,48,950.00,'cash','credit','sell',1294,NULL,'2021-10-15 23:18:14','2021-10-15 23:18:14'),(1436,48,0.00,'cash','credit','sell',1294,NULL,'2021-10-15 23:18:14','2021-10-15 23:18:14'),(1437,49,605046.00,'cash','credit','initial',NULL,NULL,'2021-10-16 21:25:59','2021-10-16 21:25:59'),(1438,49,9490.00,'cash','credit','sell',1296,NULL,'2021-10-16 21:29:05','2021-10-16 21:29:05'),(1439,49,0.00,'cash','credit','sell',1296,NULL,'2021-10-16 21:29:05','2021-10-16 21:29:05'),(1440,49,700.00,'cash','credit','sell',1220,1,'2021-10-16 21:29:36','2021-10-16 21:29:36'),(1441,49,500.00,'cash','credit','sell',893,1,'2021-10-16 21:29:52','2021-10-16 21:29:52'),(1442,49,5000.00,'cash','credit','sell',419,1,'2021-10-16 21:30:02','2021-10-16 21:30:02'),(1443,49,29800.00,'cash','credit','sell',1297,NULL,'2021-10-16 21:31:22','2021-10-16 21:31:22'),(1444,49,0.00,'cash','credit','sell',1297,NULL,'2021-10-16 21:31:22','2021-10-16 21:31:22'),(1445,49,40400.02,'cash','credit','sell',1298,NULL,'2021-10-16 21:32:51','2021-10-16 21:32:51'),(1446,49,0.00,'cash','credit','sell',1298,NULL,'2021-10-16 21:32:51','2021-10-16 21:32:51'),(1447,49,0.00,'cash','credit','sell',1299,NULL,'2021-10-16 21:33:20','2021-10-16 21:33:20'),(1448,49,0.00,'cash','credit','sell',1299,NULL,'2021-10-16 21:33:20','2021-10-16 21:33:20'),(1449,49,10000.00,'cash','credit','sell',1300,NULL,'2021-10-16 21:33:56','2021-10-16 21:33:56'),(1450,49,0.00,'cash','credit','sell',1300,NULL,'2021-10-16 21:33:56','2021-10-16 21:33:56'),(1451,49,10000.00,'cash','credit','sell',1301,NULL,'2021-10-16 21:34:41','2021-10-16 21:34:41'),(1452,49,0.00,'cash','credit','sell',1301,NULL,'2021-10-16 21:34:41','2021-10-16 21:34:41'),(1453,49,200.00,'cash','credit','sell',779,1,'2021-10-16 21:35:03','2021-10-16 21:35:03'),(1454,49,150.00,'cash','credit','sell',442,1,'2021-10-16 21:35:19','2021-10-16 21:35:19'),(1455,49,11500.00,'cash','credit','sell',1268,1,'2021-10-16 21:35:33','2021-10-16 21:35:33'),(1456,49,15750.00,'cash','credit','sell',1302,NULL,'2021-10-16 21:43:18','2021-10-16 21:43:18'),(1457,49,0.00,'cash','credit','sell',1302,NULL,'2021-10-16 21:43:18','2021-10-16 21:43:18'),(1458,49,2900.00,'cash','credit','sell',1303,NULL,'2021-10-16 21:43:54','2021-10-16 21:43:54'),(1459,49,0.00,'cash','credit','sell',1303,NULL,'2021-10-16 21:43:54','2021-10-16 21:43:54'),(1460,49,240.00,'cash','credit','sell',34,1,'2021-10-16 21:44:09','2021-10-16 21:44:09'),(1461,49,200.00,'cash','credit','sell',884,1,'2021-10-16 21:44:09','2021-10-16 21:44:09'),(1462,49,500.00,'cash','credit','sell',1245,1,'2021-10-16 21:44:09','2021-10-16 21:44:09'),(1463,49,15000.00,'cash','credit','sell',1123,1,'2021-10-16 21:44:27','2021-10-16 21:44:27'),(1464,49,5000.00,'cash','credit','sell',416,1,'2021-10-16 21:44:35','2021-10-16 21:44:35'),(1465,49,3500.00,'cash','credit','sell',426,1,'2021-10-16 21:44:52','2021-10-16 21:44:52'),(1466,49,3040.00,'cash','credit','sell',743,1,'2021-10-16 21:45:05','2021-10-16 21:45:05'),(1467,49,400.00,'cash','credit','sell',779,1,'2021-10-16 21:45:21','2021-10-16 21:45:21'),(1468,49,29900.00,'cash','credit','sell',1304,NULL,'2021-10-16 21:46:01','2021-10-16 21:46:01'),(1469,49,0.00,'cash','credit','sell',1304,NULL,'2021-10-16 21:46:01','2021-10-16 21:46:01'),(1470,49,20700.00,'cash','credit','sell',1305,NULL,'2021-10-16 21:46:37','2021-10-16 21:46:37'),(1471,49,0.00,'cash','credit','sell',1305,NULL,'2021-10-16 21:46:37','2021-10-16 21:46:37'),(1472,49,0.00,'cash','credit','sell',1306,NULL,'2021-10-16 21:46:54','2021-10-16 21:46:54'),(1473,49,0.00,'cash','credit','sell',1306,NULL,'2021-10-16 21:46:54','2021-10-16 21:46:54'),(1474,49,0.00,'cash','credit','sell',1307,NULL,'2021-10-16 21:50:10','2021-10-16 21:50:10'),(1475,49,0.00,'cash','credit','sell',1307,NULL,'2021-10-16 21:50:10','2021-10-16 21:50:10'),(1476,49,17030.00,'cash','credit','sell',1308,NULL,'2021-10-16 21:50:32','2021-10-16 21:50:32'),(1477,49,0.00,'cash','credit','sell',1308,NULL,'2021-10-16 21:50:32','2021-10-16 21:50:32'),(1478,49,4198.01,'cash','credit','sell',1309,NULL,'2021-10-16 21:51:35','2021-10-16 21:51:35'),(1479,49,0.00,'cash','credit','sell',1309,NULL,'2021-10-16 21:51:35','2021-10-16 21:51:35'),(1480,49,12035.02,'cash','credit','sell',1310,NULL,'2021-10-16 21:54:28','2021-10-16 21:54:28'),(1481,49,0.00,'cash','credit','sell',1310,NULL,'2021-10-16 21:54:28','2021-10-16 21:54:28'),(1482,49,59220.00,'cash','credit','sell',1311,NULL,'2021-10-16 21:56:17','2021-10-16 21:56:17'),(1483,49,0.00,'cash','credit','sell',1311,NULL,'2021-10-16 21:56:17','2021-10-16 21:56:17'),(1484,49,3000.00,'cash','credit','sell',1312,NULL,'2021-10-16 21:57:02','2021-10-16 21:57:02'),(1485,49,0.00,'cash','credit','sell',1312,NULL,'2021-10-16 21:57:02','2021-10-16 21:57:02'),(1486,49,250.00,'cash','credit','sell',1313,NULL,'2021-10-16 21:57:46','2021-10-16 21:57:46'),(1487,49,0.00,'cash','credit','sell',1313,NULL,'2021-10-16 21:57:46','2021-10-16 21:57:46'),(1488,50,729604.00,'cash','credit','initial',NULL,NULL,'2021-10-17 13:58:06','2021-10-17 13:58:06'),(1489,50,33496.00,'cash','credit','sell',1320,NULL,'2021-10-17 14:01:47','2021-10-17 14:01:47'),(1490,50,0.00,'cash','credit','sell',1320,NULL,'2021-10-17 14:01:47','2021-10-17 14:01:47'),(1491,50,0.00,'cash','credit','sell',1321,NULL,'2021-10-17 14:02:33','2021-10-17 14:02:33'),(1492,50,0.00,'cash','credit','sell',1321,NULL,'2021-10-17 14:02:33','2021-10-17 14:02:33'),(1493,50,1250.00,'cash','credit','sell',362,1,'2021-10-17 14:03:26','2021-10-17 14:03:26'),(1494,50,310.00,'cash','credit','sell',155,1,'2021-10-17 14:03:38','2021-10-17 14:03:38'),(1495,50,10000.00,'cash','credit','sell',132,1,'2021-10-17 14:03:55','2021-10-17 14:03:55'),(1496,51,768065.00,'cash','credit','initial',NULL,NULL,'2021-10-18 21:04:44','2021-10-18 21:04:44'),(1497,51,3480.00,'cash','credit','sell',1328,NULL,'2021-10-18 21:09:30','2021-10-18 21:09:30'),(1498,51,0.00,'cash','credit','sell',1328,NULL,'2021-10-18 21:09:30','2021-10-18 21:09:30'),(1499,51,15630.00,'cash','credit','sell',1329,NULL,'2021-10-18 21:12:09','2021-10-18 21:12:09'),(1500,51,0.00,'cash','credit','sell',1329,NULL,'2021-10-18 21:12:09','2021-10-18 21:12:09'),(1501,51,40300.00,'cash','credit','sell',1330,NULL,'2021-10-18 21:12:33','2021-10-18 21:12:33'),(1502,51,0.00,'cash','credit','sell',1330,NULL,'2021-10-18 21:12:33','2021-10-18 21:12:33'),(1503,51,49000.00,'cash','credit','sell',1331,NULL,'2021-10-18 21:13:18','2021-10-18 21:13:18'),(1504,51,0.00,'cash','credit','sell',1331,NULL,'2021-10-18 21:13:18','2021-10-18 21:13:18'),(1505,51,17481.00,'cash','credit','sell',1332,NULL,'2021-10-18 21:17:59','2021-10-18 21:17:59'),(1506,51,0.00,'cash','credit','sell',1332,NULL,'2021-10-18 21:17:59','2021-10-18 21:17:59'),(1507,51,1500.00,'cash','credit','sell',1333,NULL,'2021-10-18 21:18:59','2021-10-18 21:18:59'),(1508,51,0.00,'cash','credit','sell',1333,NULL,'2021-10-18 21:18:59','2021-10-18 21:18:59'),(1509,51,1500.00,'cash','credit','sell',1312,1,'2021-10-18 21:19:28','2021-10-18 21:19:28'),(1510,51,4000.00,'cash','credit','sell',413,1,'2021-10-18 21:19:42','2021-10-18 21:19:42'),(1511,51,1200.00,'cash','credit','sell',128,1,'2021-10-18 21:19:56','2021-10-18 21:19:56'),(1512,51,17550.20,'cash','credit','sell',966,1,'2021-10-18 21:20:10','2021-10-18 21:20:10'),(1513,51,500.00,'cash','credit','sell',997,1,'2021-10-18 21:20:10','2021-10-18 21:20:10'),(1514,51,400.00,'cash','credit','sell',1332,NULL,'2021-10-18 21:25:23','2021-10-18 21:25:23'),(1515,51,3400.00,'cash','debit','refund',1329,NULL,'2021-10-18 21:26:35','2021-10-18 21:26:35'),(1516,52,860089.00,'cash','credit','initial',NULL,NULL,'2021-10-20 19:04:32','2021-10-20 19:04:32'),(1517,52,17602.00,'cash','credit','sell',1336,NULL,'2021-10-20 19:07:20','2021-10-20 19:07:20'),(1518,52,0.00,'cash','credit','sell',1336,NULL,'2021-10-20 19:07:20','2021-10-20 19:07:20'),(1519,52,0.00,'cash','credit','sell',1337,NULL,'2021-10-20 19:07:48','2021-10-20 19:07:48'),(1520,52,0.00,'cash','credit','sell',1337,NULL,'2021-10-20 19:07:48','2021-10-20 19:07:48'),(1521,52,0.00,'cash','credit','sell',1338,NULL,'2021-10-20 19:08:26','2021-10-20 19:08:26'),(1522,52,0.00,'cash','credit','sell',1338,NULL,'2021-10-20 19:08:26','2021-10-20 19:08:26'),(1523,52,10000.00,'cash','credit','sell',1339,NULL,'2021-10-20 19:09:12','2021-10-20 19:09:12'),(1524,52,0.00,'cash','credit','sell',1339,NULL,'2021-10-20 19:09:12','2021-10-20 19:09:12'),(1525,52,31200.00,'cash','credit','sell',1342,NULL,'2021-10-20 19:19:08','2021-10-20 19:19:08'),(1526,52,0.00,'cash','credit','sell',1342,NULL,'2021-10-20 19:19:08','2021-10-20 19:19:08'),(1527,52,1100.00,'cash','credit','sell',1343,NULL,'2021-10-20 19:19:57','2021-10-20 19:19:57'),(1528,52,0.00,'cash','credit','sell',1343,NULL,'2021-10-20 19:19:57','2021-10-20 19:19:57'),(1529,52,7000.00,'cash','credit','sell',1301,1,'2021-10-20 19:20:16','2021-10-20 19:20:16'),(1530,52,5000.00,'cash','credit','sell',1304,1,'2021-10-20 19:20:32','2021-10-20 19:20:32'),(1531,52,43900.00,'cash','credit','sell',1249,1,'2021-10-20 19:20:44','2021-10-20 19:20:44'),(1532,52,300.00,'cash','credit','sell',1344,NULL,'2021-10-20 19:21:25','2021-10-20 19:21:25'),(1533,52,0.00,'cash','credit','sell',1344,NULL,'2021-10-20 19:21:25','2021-10-20 19:21:25'),(1534,52,0.00,'cash','credit','sell',1345,NULL,'2021-10-20 19:21:45','2021-10-20 19:21:45'),(1535,52,0.00,'cash','credit','sell',1345,NULL,'2021-10-20 19:21:45','2021-10-20 19:21:45'),(1536,52,9730.00,'cash','credit','sell',1346,NULL,'2021-10-20 19:23:36','2021-10-20 19:23:36'),(1537,52,0.00,'cash','credit','sell',1346,NULL,'2021-10-20 19:23:36','2021-10-20 19:23:36'),(1538,52,12500.00,'cash','credit','sell',1010,1,'2021-10-20 19:23:53','2021-10-20 19:23:53'),(1539,52,20.00,'cash','credit','sell',1350,NULL,'2021-10-20 19:26:56','2021-10-20 19:26:56'),(1540,52,0.00,'cash','credit','sell',1350,NULL,'2021-10-20 19:26:56','2021-10-20 19:26:56'),(1541,53,946502.00,'cash','credit','initial',NULL,NULL,'2021-10-21 14:36:46','2021-10-21 14:36:46'),(1542,53,15335.00,'cash','credit','sell',1354,NULL,'2021-10-21 14:38:53','2021-10-21 14:38:53'),(1543,53,0.00,'cash','credit','sell',1354,NULL,'2021-10-21 14:38:53','2021-10-21 14:38:53'),(1544,53,1030.00,'cash','credit','sell',1355,NULL,'2021-10-21 14:39:36','2021-10-21 14:39:36'),(1545,53,0.00,'cash','credit','sell',1355,NULL,'2021-10-21 14:39:36','2021-10-21 14:39:36'),(1546,53,100.00,'cash','credit','sell',1356,NULL,'2021-10-21 14:40:01','2021-10-21 14:40:01'),(1547,53,0.00,'cash','credit','sell',1356,NULL,'2021-10-21 14:40:01','2021-10-21 14:40:01'),(1548,53,1250.00,'cash','credit','sell',1337,1,'2021-10-21 14:40:32','2021-10-21 14:40:32'),(1549,53,1250.00,'cash','credit','sell',1357,NULL,'2021-10-21 14:41:14','2021-10-21 14:41:14'),(1550,53,0.00,'cash','credit','sell',1357,NULL,'2021-10-21 14:41:14','2021-10-21 14:41:14'),(1551,54,965417.00,'cash','credit','initial',NULL,NULL,'2021-10-22 14:49:04','2021-10-22 14:49:04'),(1552,54,9570.00,'cash','credit','sell',1360,NULL,'2021-10-22 14:52:00','2021-10-22 14:52:00'),(1553,54,0.00,'cash','credit','sell',1360,NULL,'2021-10-22 14:52:00','2021-10-22 14:52:00'),(1554,54,0.00,'cash','credit','sell',1361,NULL,'2021-10-22 14:52:32','2021-10-22 14:52:32'),(1555,54,0.00,'cash','credit','sell',1361,NULL,'2021-10-22 14:52:32','2021-10-22 14:52:32'),(1556,54,10000.00,'cash','credit','sell',1362,NULL,'2021-10-22 14:53:09','2021-10-22 14:53:09'),(1557,54,0.00,'cash','credit','sell',1362,NULL,'2021-10-22 14:53:09','2021-10-22 14:53:09'),(1558,54,22000.00,'cash','credit','sell',1363,NULL,'2021-10-22 14:53:48','2021-10-22 14:53:48'),(1559,54,0.00,'cash','credit','sell',1363,NULL,'2021-10-22 14:53:48','2021-10-22 14:53:48'),(1560,54,350.00,'cash','credit','sell',1345,1,'2021-10-22 14:54:07','2021-10-22 14:54:07'),(1561,54,1000.00,'cash','credit','sell',699,1,'2021-10-22 14:54:18','2021-10-22 14:54:18'),(1562,54,1800.00,'cash','credit','sell',987,1,'2021-10-22 14:54:46','2021-10-22 14:54:46'),(1563,54,250.00,'cash','credit','sell',1218,1,'2021-10-22 14:54:46','2021-10-22 14:54:46'),(1564,54,200.00,'cash','credit','sell',442,1,'2021-10-22 14:55:07','2021-10-22 14:55:07'),(1565,54,50.00,'cash','credit','sell',1179,1,'2021-10-22 14:55:25','2021-10-22 14:55:25'),(1566,54,8640.00,'cash','credit','sell',1366,NULL,'2021-10-22 15:12:06','2021-10-22 15:12:06'),(1567,54,0.00,'cash','credit','sell',1366,NULL,'2021-10-22 15:12:06','2021-10-22 15:12:06'),(1568,54,425.00,'cash','credit','sell',1367,NULL,'2021-10-22 15:13:52','2021-10-22 15:13:52'),(1569,54,0.00,'cash','credit','sell',1367,NULL,'2021-10-22 15:13:52','2021-10-22 15:13:52'),(1570,55,965925.00,'cash','credit','initial',NULL,NULL,'2021-10-23 20:01:20','2021-10-23 20:01:20'),(1571,55,11193.00,'cash','credit','sell',1373,NULL,'2021-10-23 20:04:06','2021-10-23 20:04:06'),(1572,55,0.00,'cash','credit','sell',1373,NULL,'2021-10-23 20:04:06','2021-10-23 20:04:06'),(1573,55,23500.00,'cash','credit','sell',1374,NULL,'2021-10-23 20:04:47','2021-10-23 20:04:47'),(1574,55,0.00,'cash','credit','sell',1374,NULL,'2021-10-23 20:04:47','2021-10-23 20:04:47'),(1575,56,995959.00,'cash','credit','initial',NULL,NULL,'2021-10-23 20:23:15','2021-10-23 20:23:15'),(1578,57,995959.00,'cash','credit','initial',NULL,NULL,'2021-10-24 13:37:10','2021-10-24 13:37:10'),(1579,57,0.00,'cash','credit','sell',1383,NULL,'2021-10-24 13:51:31','2021-10-24 13:51:31'),(1580,57,0.00,'cash','credit','sell',1383,NULL,'2021-10-24 13:51:31','2021-10-24 13:51:31'),(1581,57,14320.00,'cash','credit','sell',1384,NULL,'2021-10-24 13:55:25','2021-10-24 13:55:25'),(1582,57,0.00,'cash','credit','sell',1384,NULL,'2021-10-24 13:55:25','2021-10-24 13:55:25'),(1583,57,4500.00,'cash','credit','sell',1385,NULL,'2021-10-24 13:56:24','2021-10-24 13:56:24'),(1584,57,0.00,'cash','credit','sell',1385,NULL,'2021-10-24 13:56:24','2021-10-24 13:56:24'),(1585,57,7370.00,'cash','credit','sell',1386,NULL,'2021-10-24 13:57:18','2021-10-24 13:57:18'),(1586,57,0.00,'cash','credit','sell',1386,NULL,'2021-10-24 13:57:18','2021-10-24 13:57:18'),(1587,57,450.00,'cash','credit','sell',1388,NULL,'2021-10-24 14:01:57','2021-10-24 14:01:57'),(1588,57,0.00,'cash','credit','sell',1388,NULL,'2021-10-24 14:01:57','2021-10-24 14:01:57'),(1589,58,996920.00,'cash','credit','initial',NULL,NULL,'2021-10-25 19:33:55','2021-10-25 19:33:55'),(1590,58,16358.00,'cash','credit','sell',1390,NULL,'2021-10-25 19:38:29','2021-10-25 19:38:29'),(1591,58,0.00,'cash','credit','sell',1390,NULL,'2021-10-25 19:38:29','2021-10-25 19:38:29'),(1592,58,0.00,'cash','credit','sell',1391,NULL,'2021-10-25 19:39:20','2021-10-25 19:39:20'),(1593,58,0.00,'cash','credit','sell',1391,NULL,'2021-10-25 19:39:20','2021-10-25 19:39:20'),(1594,58,400.00,'cash','credit','sell',1392,NULL,'2021-10-25 19:39:51','2021-10-25 19:39:51'),(1595,58,0.00,'cash','credit','sell',1392,NULL,'2021-10-25 19:39:51','2021-10-25 19:39:51'),(1596,58,0.00,'cash','credit','sell',1393,NULL,'2021-10-25 19:40:57','2021-10-25 19:40:57'),(1597,58,0.00,'cash','credit','sell',1393,NULL,'2021-10-25 19:40:57','2021-10-25 19:40:57'),(1598,58,0.00,'cash','credit','sell',1395,NULL,'2021-10-25 19:43:27','2021-10-25 19:43:27'),(1599,58,0.00,'cash','credit','sell',1395,NULL,'2021-10-25 19:43:27','2021-10-25 19:43:27'),(1600,58,1000.00,'cash','credit','sell',142,1,'2021-10-25 19:43:48','2021-10-25 19:43:48'),(1601,58,1000.00,'cash','credit','sell',153,1,'2021-10-25 19:44:02','2021-10-25 19:44:02'),(1602,58,4100.00,'cash','credit','sell',1303,1,'2021-10-25 19:44:16','2021-10-25 19:44:16'),(1603,58,1300.00,'cash','credit','sell',1398,NULL,'2021-10-25 19:46:16','2021-10-25 19:46:16'),(1604,58,0.00,'cash','credit','sell',1398,NULL,'2021-10-25 19:46:16','2021-10-25 19:46:16'),(1605,59,1017594.00,'cash','credit','initial',NULL,NULL,'2021-10-26 00:50:03','2021-10-26 00:50:03'),(1606,59,30.00,'cash','credit','sell',1399,NULL,'2021-10-26 00:50:42','2021-10-26 00:50:42'),(1607,59,0.00,'cash','credit','sell',1399,NULL,'2021-10-26 00:50:42','2021-10-26 00:50:42'),(1608,59,58.00,'cash','credit','sell',1403,NULL,'2021-10-28 17:54:20','2021-10-28 17:54:20'),(1609,59,0.00,'cash','credit','sell',1403,NULL,'2021-10-28 17:54:20','2021-10-28 17:54:20'),(1610,59,4120.00,'cash','credit','sell',1404,NULL,'2021-10-28 18:33:26','2021-10-28 18:33:26'),(1611,59,0.00,'cash','credit','sell',1404,NULL,'2021-10-28 18:33:26','2021-10-28 18:33:26'),(1612,59,2100.00,'cash','credit','sell',1405,NULL,'2021-10-28 18:53:21','2021-10-28 18:53:21'),(1613,59,0.00,'cash','credit','sell',1405,NULL,'2021-10-28 18:53:21','2021-10-28 18:53:21'),(1614,59,0.00,'cash','credit','sell',1411,NULL,'2021-11-20 21:39:35','2021-11-20 21:39:35'),(1615,59,0.00,'cash','credit','sell',1411,NULL,'2021-11-20 21:39:35','2021-11-20 21:39:35'),(1616,59,0.00,'cash','credit','sell',1415,NULL,'2021-11-23 16:28:10','2021-11-23 16:28:10'),(1617,59,0.00,'cash','credit','sell',1415,NULL,'2021-11-23 16:28:10','2021-11-23 16:28:10'),(1619,59,0.00,'cash','credit','sell',1419,NULL,'2021-11-23 16:45:04','2021-11-23 16:45:04'),(1620,59,0.00,'cash','credit','sell',1419,NULL,'2021-11-23 16:45:04','2021-11-23 16:45:04'),(1621,59,0.00,'cash','credit','sell',1420,NULL,'2021-11-23 16:46:06','2021-11-23 16:46:06'),(1622,59,0.00,'cash','credit','sell',1420,NULL,'2021-11-23 16:46:06','2021-11-23 16:46:06'),(1623,59,0.00,'cash','credit','sell',1421,NULL,'2021-11-23 16:51:04','2021-11-23 16:51:04'),(1624,59,0.00,'cash','credit','sell',1421,NULL,'2021-11-23 16:51:04','2021-11-23 16:51:04'),(1625,59,210.00,'cheque','credit','sell',1415,1,'2021-11-23 16:53:26','2021-11-23 16:53:26'),(1626,59,2490.00,'cheque','credit','sell',1419,1,'2021-11-23 16:53:26','2021-11-23 16:53:26'),(1627,59,200.00,'cash','credit','sell',1415,1,'2021-11-23 16:57:02','2021-11-23 16:57:02'),(1628,59,2000.00,'cheque','credit','sell',1421,1,'2021-11-23 16:58:03','2021-11-23 16:58:03'),(1629,59,0.00,'cash','credit','sell',1422,NULL,'2021-11-23 16:58:45','2021-11-23 16:58:45'),(1630,59,0.00,'cash','credit','sell',1422,NULL,'2021-11-23 16:58:45','2021-11-23 16:58:45'),(1631,59,0.00,'cash','credit','sell',1423,NULL,'2021-11-23 16:59:09','2021-11-23 16:59:09'),(1632,59,0.00,'cash','credit','sell',1423,NULL,'2021-11-23 16:59:09','2021-11-23 16:59:09'),(1633,59,0.00,'cash','credit','sell',1424,NULL,'2021-11-23 17:00:06','2021-11-23 17:00:06'),(1634,59,0.00,'cash','credit','sell',1424,NULL,'2021-11-23 17:00:06','2021-11-23 17:00:06'),(1635,59,1000.00,'cheque','credit','sell',1421,1,'2021-11-23 17:00:45','2021-11-23 17:00:45'),(1636,59,250.00,'cheque','credit','sell',1422,1,'2021-11-23 17:00:45','2021-11-23 17:00:45'),(1637,59,6000.00,'cash','credit','sell',1428,NULL,'2021-12-11 10:08:09','2021-12-11 10:08:09'),(1638,59,0.00,'cash','credit','sell',1428,NULL,'2021-12-11 10:08:09','2021-12-11 10:08:09'),(1639,59,500.00,'cash','credit','sell',1234,1,'2021-12-14 09:06:02','2021-12-14 09:06:02'),(1640,59,7000.00,'cash','credit','sell',1429,NULL,'2021-12-14 09:10:15','2021-12-14 09:10:15'),(1641,59,0.00,'cash','credit','sell',1429,NULL,'2021-12-14 09:10:15','2021-12-14 09:10:15'),(1642,59,1500.00,'cash','credit','sell',1429,1,'2021-12-14 09:11:29','2021-12-14 09:11:29'),(1643,60,2000.00,'cash','credit','initial',NULL,NULL,'2021-12-14 09:13:21','2021-12-14 09:13:21'),(1644,60,9500.00,'cash','credit','sell',1430,NULL,'2021-12-14 09:13:43','2021-12-14 09:13:43'),(1645,60,0.00,'cash','credit','sell',1430,NULL,'2021-12-14 09:13:43','2021-12-14 09:13:43'),(1646,60,8000.00,'cash','credit','sell',1431,NULL,'2021-12-14 09:18:35','2021-12-14 09:18:35'),(1647,60,0.00,'cash','credit','sell',1431,NULL,'2021-12-14 09:18:35','2021-12-14 09:18:35'),(1648,60,16000.00,'cash','credit','sell',1432,NULL,'2021-12-14 09:23:17','2021-12-14 09:23:17'),(1649,60,0.00,'cash','credit','sell',1432,NULL,'2021-12-14 09:23:17','2021-12-14 09:23:17'),(1650,60,55000.00,'cash','credit','sell',1434,NULL,'2021-12-14 09:31:24','2021-12-14 09:31:24'),(1651,60,0.00,'cash','credit','sell',1434,NULL,'2021-12-14 09:31:24','2021-12-14 09:31:24'),(1652,60,1000.00,'cash','credit','sell',1437,NULL,'2021-12-28 05:48:52','2021-12-28 05:48:52'),(1653,60,0.00,'cash','credit','sell',1437,NULL,'2021-12-28 05:48:52','2021-12-28 05:48:52'),(1654,60,290.00,'cash','credit','sell',1438,NULL,'2021-12-28 05:52:25','2021-12-28 05:52:25'),(1655,60,0.00,'cash','credit','sell',1438,NULL,'2021-12-28 05:52:25','2021-12-28 05:52:25'),(1656,60,30.00,'card','credit','sell',1439,NULL,'2022-01-04 05:12:11','2022-01-04 05:12:11'),(1657,60,0.00,'cash','credit','sell',1439,NULL,'2022-01-04 05:12:11','2022-01-04 05:12:11'),(1658,60,60.00,'cash','credit','sell',1440,NULL,'2022-01-04 05:13:05','2022-01-04 05:13:05'),(1659,60,0.00,'cash','credit','sell',1440,NULL,'2022-01-04 05:13:05','2022-01-04 05:13:05'),(1660,60,575.00,'cash','credit','sell',1442,NULL,'2022-01-11 08:31:09','2022-01-11 08:31:09'),(1661,60,0.00,'cash','credit','sell',1442,NULL,'2022-01-11 08:31:09','2022-01-11 08:31:09'),(1662,60,100.00,'cash','credit','sell',1443,NULL,'2022-01-11 08:32:00','2022-01-11 08:32:00'),(1663,60,0.00,'cash','credit','sell',1443,NULL,'2022-01-11 08:32:00','2022-01-11 08:32:00'),(1664,61,77875.00,'cash','credit','initial',NULL,NULL,'2022-01-20 09:31:55','2022-01-20 09:31:55'),(1665,61,1370.00,'cash','credit','sell',1454,NULL,'2022-01-20 09:33:24','2022-01-20 09:33:24'),(1666,61,0.00,'cash','credit','sell',1454,NULL,'2022-01-20 09:33:24','2022-01-20 09:33:24'),(1667,62,79245.00,'cash','credit','initial',NULL,NULL,'2022-01-22 03:26:02','2022-01-22 03:26:02'),(1668,62,1900.00,'cash','credit','sell',1461,NULL,'2022-02-12 05:56:45','2022-02-12 05:56:45'),(1669,62,0.00,'cash','credit','sell',1461,NULL,'2022-02-12 05:56:45','2022-02-12 05:56:45'),(1670,62,4000.00,'cash','credit','sell',1467,NULL,'2022-02-20 08:20:54','2022-02-20 08:20:54'),(1671,62,0.00,'cash','credit','sell',1467,NULL,'2022-02-20 08:20:54','2022-02-20 08:20:54'),(1672,62,1100.00,'cash','credit','sell',1468,NULL,'2022-02-20 08:24:24','2022-02-20 08:24:24'),(1673,62,0.00,'cash','credit','sell',1468,NULL,'2022-02-20 08:24:24','2022-02-20 08:24:24'),(1674,62,300.00,'cash','credit','sell',1469,NULL,'2022-02-20 08:29:58','2022-02-20 08:29:58'),(1675,62,0.00,'cash','credit','sell',1469,NULL,'2022-02-20 08:29:58','2022-02-20 08:29:58'),(1676,62,0.00,'cash','credit','sell',1470,NULL,'2022-02-20 08:30:41','2022-02-20 08:30:41'),(1677,62,0.00,'cash','credit','sell',1470,NULL,'2022-02-20 08:30:41','2022-02-20 08:30:41'),(1678,62,50.00,'cash','credit','sell',122,1,'2022-02-20 08:33:49','2022-02-20 08:33:49'),(1679,62,3000.00,'cash','credit','sell',122,1,'2022-02-20 08:34:06','2022-02-20 08:34:06'),(1680,62,150.00,'cash','credit','sell',122,1,'2022-02-20 08:34:21','2022-02-20 08:34:21'),(1681,62,50.00,'cash','credit','sell',122,1,'2022-02-20 08:34:43','2022-02-20 08:34:43'),(1682,62,0.00,'cash','credit','sell',1471,NULL,'2022-02-20 08:35:43','2022-02-20 08:35:43'),(1683,62,0.00,'cash','credit','sell',1471,NULL,'2022-02-20 08:35:43','2022-02-20 08:35:43'),(1684,62,2000.00,'cash','credit','sell',1471,1,'2022-02-20 08:36:39','2022-02-20 08:36:39'),(1685,62,100.00,'cash','credit','sell',1471,1,'2022-02-20 08:38:58','2022-02-20 08:38:58'),(1686,62,320.00,'cash','credit','sell',1477,NULL,'2022-02-21 05:00:42','2022-02-21 05:00:42'),(1687,62,0.00,'cash','credit','sell',1477,NULL,'2022-02-21 05:00:42','2022-02-21 05:00:42'),(1688,62,500.00,'cash','credit','sell',1482,NULL,'2022-02-23 14:35:04','2022-02-23 14:35:04'),(1689,62,500.00,'bank_transfer','credit','sell',1482,NULL,'2022-02-23 14:35:04','2022-02-23 14:35:04'),(1690,62,0.00,'cash','credit','sell',1482,NULL,'2022-02-23 14:35:04','2022-02-23 14:35:04'),(1691,62,3610.00,'cash','credit','sell',1486,NULL,'2022-03-01 04:58:07','2022-03-01 04:58:07'),(1692,62,0.00,'cash','credit','sell',1486,NULL,'2022-03-01 04:58:07','2022-03-01 04:58:07'),(1693,62,52010.00,'cash','credit','sell',1488,NULL,'2022-03-01 08:40:22','2022-03-01 08:40:22'),(1694,62,0.00,'cash','credit','sell',1488,NULL,'2022-03-01 08:40:22','2022-03-01 08:40:22'),(1695,62,100.00,'cash','credit','sell',1356,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1696,62,150.00,'cash','credit','sell',1420,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1697,62,520.00,'cash','credit','sell',1423,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1698,62,15000.00,'cash','credit','sell',1434,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1699,62,15.00,'cash','credit','sell',1443,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1700,62,580.00,'cash','credit','sell',1448,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1701,62,68.00,'cash','credit','sell',1453,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1702,62,404.00,'cash','credit','sell',1482,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1703,62,10000.00,'cash','credit','sell',1484,1,'2022-03-03 09:05:11','2022-03-03 09:05:11'),(1704,63,0.00,'cash','credit','initial',NULL,NULL,'2022-03-27 06:34:44','2022-03-27 06:34:44'),(1705,63,1180.00,'cash','credit','sell',1490,NULL,'2022-03-27 06:34:58','2022-03-27 06:34:58'),(1706,63,0.00,'cash','credit','sell',1490,NULL,'2022-03-27 06:34:58','2022-03-27 06:34:58'),(1707,64,0.00,'cash','credit','initial',NULL,NULL,'2022-03-31 03:18:12','2022-03-31 03:18:12'),(1708,64,1500.00,'cash','credit','sell',1493,NULL,'2022-03-31 03:21:15','2022-03-31 03:21:15'),(1709,64,-96.00,'cash','credit','sell',1493,NULL,'2022-03-31 03:21:15','2022-03-31 03:21:15'),(1710,64,0.00,'cash','credit','sell',1495,NULL,'2022-04-12 04:36:01','2022-04-12 04:36:01'),(1711,64,0.00,'cash','credit','sell',1495,NULL,'2022-04-12 04:36:01','2022-04-12 04:36:01'),(1712,64,10.00,'cash','credit','sell',1498,NULL,'2022-04-12 04:45:40','2022-04-12 04:45:40'),(1713,64,0.00,'cash','credit','sell',1498,NULL,'2022-04-12 04:45:40','2022-04-12 04:45:40'),(1714,64,8.00,'cash','credit','sell',1498,1,'2022-04-12 04:47:32','2022-04-12 04:47:32'),(1715,64,2.00,'cash','credit','sell',1498,1,'2022-04-12 04:47:52','2022-04-12 04:47:52'),(1716,64,20.00,'cash','credit','sell',1505,NULL,'2022-04-16 04:21:40','2022-04-16 04:21:40'),(1717,64,0.00,'cash','credit','sell',1505,NULL,'2022-04-16 04:21:40','2022-04-16 04:21:40'),(1718,64,100.00,'cash','credit','sell',1510,NULL,'2022-04-23 03:52:31','2022-04-23 03:52:31'),(1719,64,160.00,'cheque','credit','sell',1510,NULL,'2022-04-23 03:52:31','2022-04-23 03:52:31'),(1720,64,90.00,'card','credit','sell',1510,NULL,'2022-04-23 03:52:31','2022-04-23 03:52:31'),(1721,64,0.00,'cash','credit','sell',1510,NULL,'2022-04-23 03:52:31','2022-04-23 03:52:31'),(1722,64,1280.00,'cash','credit','sell',1513,NULL,'2022-05-31 12:48:35','2022-05-31 12:48:35'),(1723,64,0.00,'cash','credit','sell',1513,NULL,'2022-05-31 12:48:35','2022-05-31 12:48:35'),(1724,64,7.00,'cash','credit','sell',1514,NULL,'2022-06-05 12:11:41','2022-06-05 12:11:41'),(1725,64,0.00,'cash','credit','sell',1514,NULL,'2022-06-05 12:11:41','2022-06-05 12:11:41'),(1726,64,0.99,'cash','credit','sell',1516,NULL,'2022-06-06 01:34:55','2022-06-06 01:34:55'),(1727,64,0.00,'cash','credit','sell',1516,NULL,'2022-06-06 01:34:55','2022-06-06 01:34:55'),(1728,64,1.00,'cash','credit','sell',1517,NULL,'2022-06-06 02:00:19','2022-06-06 02:00:19'),(1729,64,0.00,'cash','credit','sell',1517,NULL,'2022-06-06 02:00:19','2022-06-06 02:00:19'),(1730,64,30.00,'cash','credit','sell',1518,NULL,'2022-06-06 02:04:39','2022-06-06 02:04:39'),(1731,64,0.00,'cash','credit','sell',1518,NULL,'2022-06-06 02:04:39','2022-06-06 02:04:39'),(1734,64,1500.00,'cash','credit','sell',1521,NULL,'2022-06-06 03:36:53','2022-06-06 03:36:53'),(1735,64,0.00,'cash','credit','sell',1521,NULL,'2022-06-06 03:36:53','2022-06-06 03:36:53'),(1736,64,2240.00,'cash','credit','sell',1523,NULL,'2022-06-06 14:27:24','2022-06-06 14:27:24'),(1737,64,0.00,'cash','credit','sell',1523,NULL,'2022-06-06 14:27:24','2022-06-06 14:27:24'),(1738,64,50.00,'cash','credit','sell',1524,NULL,'2022-06-16 04:34:03','2022-06-16 04:34:03'),(1739,64,0.00,'cash','credit','sell',1524,NULL,'2022-06-16 04:34:03','2022-06-16 04:34:03'),(1740,64,4181.00,'cash','credit','sell',1526,NULL,'2022-06-19 06:08:59','2022-06-19 06:08:59'),(1741,64,0.00,'cash','credit','sell',1526,NULL,'2022-06-19 06:08:59','2022-06-19 06:08:59'),(1742,64,2460.00,'cash','credit','sell',1529,NULL,'2022-06-24 07:17:14','2022-06-24 07:17:14'),(1743,64,0.00,'cash','credit','sell',1529,NULL,'2022-06-24 07:17:14','2022-06-24 07:17:14'),(1744,64,5000.00,'cash','credit','sell',1530,NULL,'2022-06-24 07:29:34','2022-06-24 07:29:34'),(1745,64,-80.00,'cash','credit','sell',1530,NULL,'2022-06-24 07:29:34','2022-06-24 07:29:34'),(1746,64,8750.00,'cash','credit','sell',1531,NULL,'2022-06-28 11:44:04','2022-06-28 11:44:04'),(1747,64,0.00,'cash','credit','sell',1531,NULL,'2022-06-28 11:44:04','2022-06-28 11:44:04'),(1748,64,1370.00,'cash','credit','sell',1532,NULL,'2022-06-29 10:11:40','2022-06-29 10:11:40'),(1749,64,0.00,'cash','credit','sell',1532,NULL,'2022-06-29 10:11:40','2022-06-29 10:11:40'),(1750,64,2000.00,'cash','credit','sell',1533,NULL,'2022-07-18 13:48:49','2022-07-18 13:48:49'),(1751,64,0.00,'cash','credit','sell',1533,NULL,'2022-07-18 13:48:49','2022-07-18 13:48:49'),(1752,64,100.00,'cash','credit','sell',1535,NULL,'2022-08-07 04:57:40','2022-08-07 04:57:40'),(1753,64,0.00,'cash','credit','sell',1535,NULL,'2022-08-07 04:57:40','2022-08-07 04:57:40'),(1754,64,50.00,'cash','credit','sell',1536,NULL,'2022-08-07 04:58:40','2022-08-07 04:58:40'),(1755,64,0.00,'cash','credit','sell',1536,NULL,'2022-08-07 04:58:40','2022-08-07 04:58:40'),(1756,64,20.00,'cash','credit','sell',1537,NULL,'2022-08-07 04:59:50','2022-08-07 04:59:50'),(1757,64,0.00,'cash','credit','sell',1537,NULL,'2022-08-07 04:59:50','2022-08-07 04:59:50'),(1758,64,50.00,'cash','credit','sell',1535,1,'2022-08-07 05:00:14','2022-08-07 05:00:14'),(1759,64,50.00,'cash','credit','sell',1537,1,'2022-08-07 05:00:14','2022-08-07 05:00:14'),(1760,64,117.00,'card','credit','sell',1540,NULL,'2022-08-07 12:30:58','2022-08-07 12:30:58'),(1761,64,0.00,'cash','credit','sell',1540,NULL,'2022-08-07 12:30:58','2022-08-07 12:30:58'),(1762,1,150.00,'cash','credit','sell',1541,NULL,'2022-08-17 05:14:17','2022-08-17 05:14:17'),(1763,1,0.00,'cash','credit','sell',1541,NULL,'2022-08-17 05:14:17','2022-08-17 05:14:17'),(1764,64,3542.00,'cash','credit','sell',1548,NULL,'2022-09-17 02:37:16','2022-09-17 02:37:16'),(1765,64,0.00,'cash','credit','sell',1548,NULL,'2022-09-17 02:37:16','2022-09-17 02:37:16'),(1766,64,1200.00,'cash','credit','sell',1550,NULL,'2022-09-17 04:46:56','2022-09-17 04:46:56'),(1767,64,-19.00,'cash','credit','sell',1550,NULL,'2022-09-17 04:46:56','2022-09-17 04:46:56'),(1768,64,0.00,'cash','credit','sell',1550,NULL,'2022-09-17 04:46:56','2022-09-17 04:46:56'),(1769,64,1.00,'cash','credit','sell',1554,NULL,'2022-11-21 17:00:55','2022-11-21 17:00:55'),(1770,64,0.00,'cash','credit','sell',1554,NULL,'2022-11-21 17:00:55','2022-11-21 17:00:55'),(1771,64,1800.00,'cash','credit','sell',1555,NULL,'2022-11-21 17:02:25','2022-11-21 17:02:25'),(1772,64,0.00,'cash','credit','sell',1555,NULL,'2022-11-21 17:02:25','2022-11-21 17:02:25'),(1773,64,100.00,'cash','debit','refund',1555,NULL,'2022-11-21 17:06:59','2022-11-21 17:06:59'),(1774,64,500.00,'cash','credit','sell',1555,NULL,'2022-11-21 17:08:48','2022-11-21 17:08:48'),(1775,64,61.00,'cash','credit','sell',1556,NULL,'2022-11-21 17:23:30','2022-11-21 17:23:30'),(1776,64,0.00,'cash','credit','sell',1556,NULL,'2022-11-21 17:23:30','2022-11-21 17:23:30'),(1777,65,35478.99,'cash','credit','initial',NULL,NULL,'2022-11-22 03:48:13','2022-11-22 03:48:13'),(1778,65,9051.00,'cash','credit','sell',1558,NULL,'2022-12-19 10:56:55','2022-12-19 10:56:55'),(1779,65,0.00,'cash','credit','sell',1558,NULL,'2022-12-19 10:56:55','2022-12-19 10:56:55'),(1780,65,950.00,'cash','credit','sell',1561,NULL,'2022-12-26 10:18:55','2022-12-26 10:18:55'),(1781,65,0.00,'cash','credit','sell',1561,NULL,'2022-12-26 10:18:55','2022-12-26 10:18:55'),(1782,66,0.00,'cash','credit','initial',NULL,NULL,'2022-12-27 03:51:15','2022-12-27 03:51:15'),(1783,65,1.00,'cash','credit','sell',1564,NULL,'2022-12-27 03:54:55','2022-12-27 03:54:55'),(1784,65,0.00,'cash','credit','sell',1564,NULL,'2022-12-27 03:54:55','2022-12-27 03:54:55'),(1785,65,50.00,'cash','credit','sell',1565,NULL,'2022-12-27 04:18:42','2022-12-27 04:18:42'),(1786,65,0.00,'cash','credit','sell',1565,NULL,'2022-12-27 04:18:42','2022-12-27 04:18:42'),(1787,65,3800.00,'cash','credit','sell',1566,NULL,'2022-12-27 04:39:23','2022-12-27 04:39:23'),(1788,65,0.00,'cash','credit','sell',1566,NULL,'2022-12-27 04:39:23','2022-12-27 04:39:23'),(1789,65,950.00,'cash','credit','sell',1568,NULL,'2022-12-27 05:11:47','2022-12-27 05:11:47'),(1790,65,0.00,'cash','credit','sell',1568,NULL,'2022-12-27 05:11:47','2022-12-27 05:11:47'),(1791,67,0.00,'cash','credit','initial',NULL,NULL,'2022-12-27 05:42:23','2022-12-27 05:42:23'),(1792,65,950.00,'cash','credit','sell',1569,NULL,'2022-12-27 05:43:00','2022-12-27 05:43:00'),(1793,65,0.00,'cash','credit','sell',1569,NULL,'2022-12-27 05:43:00','2022-12-27 05:43:00'),(1794,65,950.00,'cash','credit','sell',1570,NULL,'2022-12-27 05:47:03','2022-12-27 05:47:03'),(1795,65,0.00,'cash','credit','sell',1570,NULL,'2022-12-27 05:47:03','2022-12-27 05:47:03'),(1796,65,950.00,'cash','credit','sell',1571,NULL,'2022-12-28 03:43:24','2022-12-28 03:43:24'),(1797,65,0.00,'cash','credit','sell',1571,NULL,'2022-12-28 03:43:24','2022-12-28 03:43:24'),(1798,65,950.00,'cash','credit','sell',1572,NULL,'2022-12-28 03:44:26','2022-12-28 03:44:26'),(1799,65,0.00,'cash','credit','sell',1572,NULL,'2022-12-28 03:44:26','2022-12-28 03:44:26'),(1800,65,2850.00,'cash','credit','sell',1575,NULL,'2023-01-01 03:22:29','2023-01-01 03:22:29'),(1801,65,0.00,'cash','credit','sell',1575,NULL,'2023-01-01 03:22:29','2023-01-01 03:22:29'),(1802,65,1.00,'cash','credit','sell',1579,NULL,'2023-01-09 04:08:17','2023-01-09 04:08:17'),(1803,65,0.00,'cash','credit','sell',1579,NULL,'2023-01-09 04:08:17','2023-01-09 04:08:17'),(1804,65,1.00,'cash','credit','sell',1580,NULL,'2023-01-09 04:09:33','2023-01-09 04:09:33'),(1805,65,0.00,'cash','credit','sell',1580,NULL,'2023-01-09 04:09:33','2023-01-09 04:09:33'),(1806,65,2750.00,'cash','credit','sell',1578,NULL,'2023-01-09 04:16:23','2023-01-09 04:16:23'),(1807,65,0.00,'cash','credit','sell',1578,NULL,'2023-01-09 04:16:23','2023-01-09 04:16:23'),(1808,65,2750.00,'cash','credit','sell',1567,NULL,'2023-01-09 04:18:02','2023-01-09 04:18:02'),(1809,65,0.00,'cash','credit','sell',1567,NULL,'2023-01-09 04:18:02','2023-01-09 04:18:02'),(1810,65,2750.00,'cash','credit','sell',1581,NULL,'2023-01-09 04:40:42','2023-01-09 04:40:42'),(1811,65,0.00,'cash','credit','sell',1581,NULL,'2023-01-09 04:40:42','2023-01-09 04:40:42'),(1812,65,1.00,'cash','credit','sell',1582,NULL,'2023-01-09 04:48:01','2023-01-09 04:48:01'),(1813,65,0.00,'cash','credit','sell',1582,NULL,'2023-01-09 04:48:01','2023-01-09 04:48:01'),(1814,65,1.00,'cash','credit','sell',1583,NULL,'2023-01-09 04:48:59','2023-01-09 04:48:59'),(1815,65,0.00,'cash','credit','sell',1583,NULL,'2023-01-09 04:48:59','2023-01-09 04:48:59'),(1816,66,1.00,'cash','credit','sell',1584,NULL,'2023-01-09 06:43:24','2023-01-09 06:43:24'),(1817,66,0.00,'cash','credit','sell',1584,NULL,'2023-01-09 06:43:24','2023-01-09 06:43:24'),(1818,66,1180.00,'cash','credit','sell',1585,NULL,'2023-01-09 06:43:38','2023-01-09 06:43:38'),(1819,66,0.00,'cash','credit','sell',1585,NULL,'2023-01-09 06:43:38','2023-01-09 06:43:38'),(1820,66,150.00,'cash','credit','sell',1586,NULL,'2023-01-09 06:43:54','2023-01-09 06:43:54'),(1821,66,0.00,'cash','credit','sell',1586,NULL,'2023-01-09 06:43:54','2023-01-09 06:43:54'),(1822,65,10.00,'cash','credit','sell',1590,NULL,'2023-01-11 16:49:43','2023-01-11 16:49:43'),(1823,65,-9.00,'cash','credit','sell',1590,NULL,'2023-01-11 16:49:43','2023-01-11 16:49:43'),(1824,65,1.00,'cash','credit','sell',1595,NULL,'2023-01-18 14:47:22','2023-01-18 14:47:22'),(1825,65,0.00,'cash','credit','sell',1595,NULL,'2023-01-18 14:47:22','2023-01-18 14:47:22'),(1826,65,5.00,'cash','credit','sell',1598,NULL,'2023-03-13 10:29:17','2023-03-13 10:29:17'),(1827,65,0.00,'cash','credit','sell',1598,NULL,'2023-03-13 10:29:17','2023-03-13 10:29:17'),(1828,65,20.00,'cash','credit','sell',1604,1,'2023-03-14 04:25:51','2023-03-14 04:25:51'),(1829,65,50.00,'cash','credit','sell',1609,NULL,'2023-03-14 05:13:58','2023-03-14 05:13:58'),(1830,65,0.00,'cash','credit','sell',1609,NULL,'2023-03-14 05:13:58','2023-03-14 05:13:58'),(1831,65,500.00,'cash','credit','sell',1613,NULL,'2023-03-15 13:16:13','2023-03-15 13:16:13'),(1832,65,0.00,'cash','credit','sell',1613,NULL,'2023-03-15 13:16:13','2023-03-15 13:16:13'),(1833,65,2000.00,'cash','credit','sell',1619,NULL,'2023-03-16 05:34:45','2023-03-16 05:34:45'),(1834,65,0.00,'cash','credit','sell',1619,NULL,'2023-03-16 05:34:45','2023-03-16 05:34:45'),(1835,65,1000.00,'cash','credit','sell',1620,NULL,'2023-03-16 11:27:47','2023-03-16 11:27:47'),(1836,65,0.00,'cash','credit','sell',1620,NULL,'2023-03-16 11:27:47','2023-03-16 11:27:47'),(1837,65,6000.00,'cash','credit','sell',1622,NULL,'2023-03-23 03:22:39','2023-03-23 03:22:39'),(1838,65,0.00,'cash','credit','sell',1622,NULL,'2023-03-23 03:22:39','2023-03-23 03:22:39'),(1839,65,1250.00,'cash','credit','sell',1623,NULL,'2023-03-23 03:29:11','2023-03-23 03:29:11'),(1840,65,0.00,'cash','credit','sell',1623,NULL,'2023-03-23 03:29:11','2023-03-23 03:29:11'),(1841,65,6000.00,'cash','credit','sell',1628,NULL,'2023-03-23 14:41:48','2023-03-23 14:41:48'),(1842,65,0.00,'cash','credit','sell',1628,NULL,'2023-03-23 14:41:48','2023-03-23 14:41:48'),(1843,65,30000.00,'cash','credit','sell',1629,NULL,'2023-03-26 07:44:18','2023-03-26 07:44:18'),(1844,65,0.00,'cash','credit','sell',1629,NULL,'2023-03-26 07:44:18','2023-03-26 07:44:18'),(1845,65,33843.00,'cash','credit','sell',1630,NULL,'2023-03-28 16:45:14','2023-03-28 16:45:14'),(1846,65,0.00,'cash','credit','sell',1630,NULL,'2023-03-28 16:45:14','2023-03-28 16:45:14'),(1847,65,700.00,'cash','credit','sell',1631,NULL,'2023-03-28 16:45:55','2023-03-28 16:45:55'),(1848,65,0.00,'cash','credit','sell',1631,NULL,'2023-03-28 16:45:55','2023-03-28 16:45:55'),(1849,65,3000.00,'cash','credit','sell',1633,NULL,'2023-03-29 03:15:45','2023-03-29 03:15:45'),(1850,65,0.00,'cash','credit','sell',1633,NULL,'2023-03-29 03:15:45','2023-03-29 03:15:45'),(1851,65,1800.00,'cash','credit','sell',1634,NULL,'2023-03-29 04:51:40','2023-03-29 04:51:40'),(1852,65,0.00,'cash','credit','sell',1634,NULL,'2023-03-29 04:51:40','2023-03-29 04:51:40'),(1853,65,3100.00,'cash','credit','sell',1636,NULL,'2023-03-30 03:28:37','2023-03-30 03:28:37'),(1854,65,0.00,'cash','credit','sell',1636,NULL,'2023-03-30 03:28:37','2023-03-30 03:28:37'),(1855,65,60.00,'cash','credit','sell',1640,NULL,'2023-06-01 09:37:29','2023-06-01 09:37:29'),(1856,65,0.00,'cash','credit','sell',1640,NULL,'2023-06-01 09:37:29','2023-06-01 09:37:29'),(1857,65,50.00,'cash','credit','sell',1641,NULL,'2023-06-01 09:38:26','2023-06-01 09:38:26'),(1858,65,0.00,'cash','credit','sell',1641,NULL,'2023-06-01 09:38:26','2023-06-01 09:38:26'),(1859,65,50.00,'cash','credit','sell',1642,NULL,'2023-06-01 09:40:22','2023-06-01 09:40:22'),(1860,65,0.00,'cash','credit','sell',1642,NULL,'2023-06-01 09:40:22','2023-06-01 09:40:22'),(1864,65,1181.00,'cash','credit','sell',1645,NULL,'2023-06-16 09:07:25','2023-06-16 09:07:25'),(1865,65,0.00,'cash','credit','sell',1645,NULL,'2023-06-16 09:07:25','2023-06-16 09:07:25');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(20,2) NOT NULL DEFAULT 0.00,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,'open',NULL,0.00,0,0,NULL,'2021-01-29 19:10:00','2021-01-29 19:10:00'),(6,9,36,'close','2021-05-29 12:01:01',41000.00,0,0,NULL,'2021-05-28 13:30:51','2021-05-29 16:01:01'),(7,9,36,'close','2021-06-05 12:32:37',50000.00,0,0,NULL,'2021-05-29 16:01:31','2021-06-05 16:32:37'),(8,9,36,'close','2021-06-10 20:06:51',0.00,0,0,NULL,'2021-06-05 16:33:02','2021-06-11 00:06:51'),(9,9,36,'close','2021-08-14 17:30:25',-239522.00,0,0,NULL,'2021-06-27 16:38:37','2021-08-14 21:30:25'),(10,9,36,'close','2021-08-14 18:05:30',-233699.00,0,0,NULL,'2021-08-14 21:30:48','2021-08-14 22:05:30'),(11,9,36,'close','2021-08-14 18:07:05',-233699.00,0,0,NULL,'2021-08-14 22:06:05','2021-08-14 22:07:05'),(12,9,36,'close','2021-08-24 18:07:16',-233699.00,0,0,NULL,'2021-08-22 15:13:23','2021-08-24 22:07:16'),(13,9,36,'close','2021-08-24 18:36:09',-221679.00,0,0,NULL,'2021-08-24 22:07:29','2021-08-24 22:36:09'),(14,9,36,'close','2021-08-24 18:36:09',-221679.00,0,0,NULL,'2021-08-24 22:08:17','2021-08-24 22:36:09'),(15,9,36,'close','2021-08-28 15:19:29',1000.00,0,0,NULL,'2021-08-28 18:56:07','2021-08-28 19:19:29'),(16,9,36,'close','2021-08-28 15:46:08',0.00,0,0,NULL,'2021-08-28 19:20:16','2021-08-28 19:46:08'),(17,9,36,'close','2021-09-05 10:25:41',-56000.00,0,0,NULL,'2021-08-28 21:34:46','2021-09-05 14:25:41'),(18,9,36,'close','2021-09-08 09:49:50',100.00,0,0,NULL,'2021-09-06 21:15:21','2021-09-08 13:49:50'),(19,9,36,'close','2021-09-09 11:07:01',500.00,0,0,NULL,'2021-09-08 13:50:30','2021-09-09 15:07:01'),(20,9,36,'close','2021-09-09 13:04:11',-15753.00,0,0,NULL,'2021-09-09 15:07:44','2021-09-09 17:04:11'),(21,9,36,'close','2021-09-09 13:13:41',0.00,0,0,NULL,'2021-09-09 17:12:16','2021-09-09 17:13:41'),(22,9,36,'close','2021-09-09 14:47:25',-3000.00,0,0,NULL,'2021-09-09 17:13:59','2021-09-09 18:47:25'),(23,9,36,'close','2021-09-10 10:09:16',-15753.00,0,0,NULL,'2021-09-09 18:59:52','2021-09-10 14:09:16'),(24,9,36,'close','2021-09-10 10:52:47',56475.00,0,0,NULL,'2021-09-10 14:13:44','2021-09-10 14:52:47'),(25,9,36,'close','2021-09-12 09:34:45',132080.00,0,0,NULL,'2021-09-11 14:54:54','2021-09-12 13:34:45'),(26,9,36,'close','2021-09-14 10:16:31',168885.00,0,0,NULL,'2021-09-12 14:08:56','2021-09-14 14:16:31'),(27,9,36,'close','2021-09-15 09:59:53',343353.00,0,0,NULL,'2021-09-14 14:16:41','2021-09-15 13:59:53'),(28,9,36,'close','2021-09-17 09:28:59',279148.00,0,0,NULL,'2021-09-15 14:23:17','2021-09-17 13:28:59'),(29,9,36,'close','2021-09-18 11:05:59',118040.00,0,0,NULL,'2021-09-17 14:25:06','2021-09-18 15:05:59'),(30,9,36,'close','2021-09-20 12:02:29',223950.00,0,0,NULL,'2021-09-19 15:39:05','2021-09-20 16:02:29'),(31,9,36,'close','2021-09-21 11:23:29',180092.00,0,0,NULL,'2021-09-20 16:02:47','2021-09-21 15:23:29'),(32,9,36,'close','2021-09-22 10:45:38',228049.00,0,0,NULL,'2021-09-21 15:38:24','2021-09-22 14:45:38'),(33,9,36,'close','2021-09-28 11:07:56',254419.00,0,0,NULL,'2021-09-22 14:45:50','2021-09-28 15:07:56'),(34,9,36,'close','2021-09-28 18:13:49',261075.00,0,0,NULL,'2021-09-28 15:09:12','2021-09-28 22:13:49'),(35,9,36,'close','2021-09-30 11:53:10',559402.00,0,0,NULL,'2021-09-29 13:08:07','2021-09-30 15:53:10'),(36,9,36,'close','2021-09-30 20:05:30',591269.00,0,0,NULL,'2021-09-30 15:53:23','2021-10-01 00:05:30'),(37,9,36,'close','2021-10-02 10:35:27',102538.00,0,0,NULL,'2021-10-01 23:10:17','2021-10-02 14:35:27'),(38,9,36,'close','2021-10-03 19:15:09',208995.00,0,0,NULL,'2021-10-02 14:36:39','2021-10-03 23:15:09'),(39,9,36,'close','2021-10-05 12:40:25',342495.00,0,0,NULL,'2021-10-04 14:35:18','2021-10-05 16:40:25'),(40,9,36,'close','2021-10-05 13:03:06',409555.00,0,0,NULL,'2021-10-05 16:41:20','2021-10-05 17:03:06'),(41,9,36,'close','2021-10-07 13:46:28',373138.00,0,0,NULL,'2021-10-05 17:08:36','2021-10-07 17:46:28'),(42,9,36,'close','2021-10-08 12:34:37',377008.00,0,0,NULL,'2021-10-07 21:33:13','2021-10-08 16:34:37'),(43,9,36,'close','2021-10-09 19:03:48',403529.00,0,0,NULL,'2021-10-08 16:34:46','2021-10-09 23:03:48'),(44,9,36,'close','2021-10-11 10:05:55',465828.30,0,0,NULL,'2021-10-09 23:04:06','2021-10-11 14:05:55'),(45,9,36,'close','2021-10-12 09:05:57',510848.30,0,0,NULL,'2021-10-11 14:06:04','2021-10-12 13:05:57'),(46,9,36,'close','2021-10-13 11:37:33',604257.00,0,0,NULL,'2021-10-12 13:06:26','2021-10-13 15:37:33'),(47,9,36,'close','2021-10-13 12:05:44',518287.00,0,0,NULL,'2021-10-13 15:37:50','2021-10-13 16:05:44'),(48,9,36,'close','2021-10-15 19:19:20',605046.00,0,0,NULL,'2021-10-13 21:55:22','2021-10-15 23:19:20'),(49,9,36,'close','2021-10-16 18:04:13',729604.00,0,0,NULL,'2021-10-16 21:25:59','2021-10-16 22:04:13'),(50,9,36,'close','2021-10-18 17:04:32',768065.00,0,0,NULL,'2021-10-17 13:58:06','2021-10-18 21:04:32'),(51,9,36,'close','2021-10-18 17:29:23',860089.00,0,0,NULL,'2021-10-18 21:04:44','2021-10-18 21:29:23'),(52,9,36,'close','2021-10-20 15:27:36',946502.00,0,0,NULL,'2021-10-20 19:04:32','2021-10-20 19:27:36'),(53,9,36,'close','2021-10-21 10:42:12',965417.00,0,0,NULL,'2021-10-21 14:36:46','2021-10-21 14:42:12'),(54,9,36,'close','2021-10-22 11:19:19',965925.00,0,0,NULL,'2021-10-22 14:49:04','2021-10-22 15:19:19'),(55,9,36,'close','2021-10-23 16:07:34',995959.00,0,0,NULL,'2021-10-23 20:01:20','2021-10-23 20:07:34'),(56,9,36,'close','2021-10-23 16:30:49',995959.00,0,0,NULL,'2021-10-23 20:23:15','2021-10-23 20:30:49'),(57,9,36,'close','2021-10-24 10:02:21',996920.00,0,0,NULL,'2021-10-24 13:37:10','2021-10-24 14:02:21'),(58,9,36,'close','2021-10-25 15:47:24',1017594.00,0,0,NULL,'2021-10-25 19:33:55','2021-10-25 19:47:24'),(59,9,36,'close','2021-12-14 17:13:03',995102.00,0,5,NULL,'2021-10-26 00:50:03','2021-12-14 09:13:03'),(60,9,36,'close','2022-01-20 17:30:36',77875.00,1,0,NULL,'2021-12-14 09:13:21','2022-01-20 09:30:36'),(61,9,36,'close','2022-01-20 17:33:48',79245.00,0,0,NULL,'2022-01-20 09:31:55','2022-01-20 09:33:48'),(62,9,36,'close','2022-03-27 14:33:20',105137.00,0,0,NULL,'2022-01-22 03:26:02','2022-03-27 06:33:20'),(63,9,36,'close','2022-03-27 14:35:09',1180.00,0,0,NULL,'2022-03-27 06:34:44','2022-03-27 06:35:09'),(64,9,36,'close','2022-11-22 01:24:51',35478.99,2,1,NULL,'2022-03-31 03:18:12','2022-11-21 17:24:51'),(65,9,36,'open',NULL,0.00,0,0,NULL,'2022-11-22 03:48:13','2022-11-22 03:48:13'),(66,9,39,'open',NULL,0.00,0,0,NULL,'2022-12-27 03:51:15','2022-12-27 03:51:15'),(67,9,38,'open',NULL,0.00,0,0,NULL,'2022-12-27 05:42:23','2022-12-27 05:42:23');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_cat_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (23,'Walton',1,'Walton',0,1,NULL,NULL,'2021-05-28 00:41:32','2021-05-28 00:41:32'),(24,'Marcel',1,'Marcel',0,1,NULL,NULL,'2021-05-28 00:41:43','2021-05-28 00:41:43'),(25,'All Electronic Product',1,'All Electronic Product',0,1,NULL,NULL,'2021-05-28 00:42:02','2021-05-28 00:42:02'),(26,'All Gas Product',1,'All Gas Product',0,1,NULL,NULL,'2021-05-28 00:42:21','2021-05-28 00:42:21'),(27,'All Mobile',1,'All Mobile',0,1,NULL,NULL,'2021-05-28 00:42:45','2021-05-28 00:42:45'),(28,'Old product',1,'Old product',0,1,NULL,NULL,'2021-05-28 00:43:00','2021-05-28 00:43:00'),(29,'pieces',9,'pieces',0,36,NULL,'2021-05-28 01:57:47','2021-05-28 01:50:53','2021-05-28 01:57:47'),(35,'Marcel',9,NULL,0,36,NULL,'2022-01-15 17:42:36','2021-05-28 02:08:00','2022-01-15 17:42:36'),(36,'Walton',9,NULL,0,36,NULL,'2022-01-15 17:42:42','2021-05-28 02:08:00','2022-01-15 17:42:42'),(37,'All Mobile',9,NULL,0,36,NULL,'2022-01-11 08:17:53','2021-05-28 02:08:01','2022-01-11 08:17:53'),(38,'All Gas Product',9,NULL,0,36,NULL,'2022-01-11 08:17:48','2021-05-28 02:08:01','2022-01-11 08:17:48'),(39,'Country Meat',9,NULL,0,36,NULL,NULL,'2021-05-28 02:08:01','2022-01-04 05:06:07'),(40,'Marcel Led Television',9,'marcelledtv',35,36,NULL,NULL,'2021-05-28 13:21:16','2021-05-28 13:21:16'),(41,'Walton Refrigaretor',9,NULL,36,36,NULL,NULL,'2021-05-28 20:04:52','2021-09-09 16:53:38'),(42,'Walton Led Television',9,'Walton Led Television',36,36,NULL,NULL,'2021-05-28 20:05:19','2021-09-09 16:53:38'),(43,'Walton 600SD',9,'Walton 600SD',36,36,NULL,NULL,'2021-05-28 20:09:35','2021-09-09 16:53:38'),(44,'Walton 1000SD',9,'walton1000sd',36,36,NULL,NULL,'2021-05-28 20:20:30','2021-09-09 16:53:38'),(45,'Walton 2000SD',9,'Walton 2000SD',36,36,NULL,NULL,'2021-05-28 20:20:52','2021-09-09 16:53:38'),(46,'Walton Combain Switch',9,'Walton Combain Switch',36,36,NULL,NULL,'2021-05-28 20:21:19','2021-09-09 16:53:38'),(47,'Walton Rice Cooker',9,'Walton Rice Cooker',36,36,NULL,NULL,'2021-05-28 20:21:46','2021-09-09 16:53:38'),(48,'Walton Blender',9,'Walton Blender',36,36,NULL,NULL,'2021-05-28 20:22:06','2021-09-09 16:53:38'),(49,'Walton Elecrtic Kettle',9,'Walton Elecrtic Kettle',36,36,NULL,NULL,'2021-05-28 20:22:41','2021-09-09 16:53:38'),(50,'Walton Iron machine',9,'Walton Iron machine',36,36,NULL,NULL,'2021-05-28 20:23:00','2021-09-09 16:53:38'),(51,'Mobile Sim',9,'Walton Genaretor',37,36,NULL,NULL,'2021-05-28 20:23:15','2021-09-09 16:55:24'),(52,'Walton Oven',9,'Walton Oven',36,36,NULL,NULL,'2021-05-28 20:23:39','2021-09-09 16:53:38'),(53,'Walton led Bulb',9,'Walton led Bulb',36,36,NULL,NULL,'2021-05-28 20:23:59','2021-09-09 16:53:38'),(54,'Walton Room Heater',9,'Walton Room Heater',36,36,NULL,NULL,'2021-05-28 20:24:34','2021-09-09 16:53:38'),(55,'Walton Digital Scal',9,'Walton Digital Scal',36,36,NULL,NULL,'2021-05-28 20:25:10','2021-09-09 16:53:38'),(56,'Walton Water Purifier',9,'Walton Water Purifier',36,36,NULL,NULL,'2021-05-28 20:25:38','2021-09-09 16:53:38'),(57,'Walton Frypan',9,'Walton Frypan',36,36,NULL,NULL,'2021-05-28 20:26:07','2021-09-09 16:53:38'),(58,'Walton',9,NULL,0,36,NULL,'2021-05-28 20:29:26','2021-05-28 20:26:16','2021-05-28 20:29:26'),(59,'Walton Air Conditioner',9,'Walton ac',35,36,NULL,NULL,'2021-05-28 20:26:43','2021-05-28 20:26:43'),(60,'Walton Induction Cooker',9,'Walton Induction Cooker',36,36,NULL,NULL,'2021-05-28 20:27:03','2021-09-09 16:53:38'),(61,'Walton Singel Stove',9,'Walton Singel Stove',36,36,NULL,NULL,'2021-05-28 20:27:23','2021-09-09 16:53:38'),(62,'Walton Double Stove',9,'Walton Double Stove',36,36,NULL,NULL,'2021-05-28 20:27:41','2021-09-09 16:53:38'),(63,'Walton 56\" ceiling Fan',9,'Walton 56\" ceiling Fan',36,36,NULL,NULL,'2021-05-28 20:27:59','2021-09-09 16:53:38'),(64,'Walton Charger Fan',9,'Walton Charger Fan',36,36,NULL,NULL,'2021-05-28 20:28:14','2021-09-09 16:53:38'),(65,'Walton Fan Reguletor',9,'Walton Fan Reguletor',36,36,NULL,NULL,'2021-05-28 20:28:32','2021-09-09 16:53:38'),(66,'Walton Washing Machine',9,'Walton Washing Machine',36,36,NULL,NULL,'2021-05-28 20:28:55','2021-09-09 16:53:38'),(67,'Walton To',9,NULL,0,36,NULL,'2021-05-28 20:29:12','2021-05-28 20:29:03','2021-05-28 20:29:12'),(68,'Walton Touch Light',9,'Walton Touch Light',36,36,NULL,NULL,'2021-05-28 20:29:48','2021-09-09 16:53:38'),(69,'Walo',9,NULL,0,36,NULL,'2021-05-28 20:29:58','2021-05-28 20:29:54','2021-05-28 20:29:58'),(70,'Walton Ta',9,NULL,0,36,NULL,'2021-05-28 20:30:12','2021-05-28 20:30:08','2021-05-28 20:30:12'),(71,'Walton Table Light',9,'Walton Table Light',36,36,NULL,NULL,'2021-05-28 20:30:35','2021-09-09 16:53:38'),(72,'Walton Led Tube',9,'Walton Led Tube',36,36,NULL,NULL,'2021-05-28 20:30:50','2021-09-09 16:53:38'),(73,'Walton Wall Movie Fan',9,'Walton Wall Movie Fan',36,36,NULL,NULL,'2021-05-28 20:31:18','2021-09-09 16:53:38'),(74,'Walton Pedastal Fan',9,'Walton Pedastal Fan',36,36,NULL,NULL,'2021-05-28 20:32:04','2021-09-09 16:53:38'),(75,'Walton Pressur Cooker',9,'Walton Pressur Cooker',36,36,NULL,NULL,'2021-05-28 20:32:23','2021-09-09 16:53:38'),(76,'Walton Ruti maker',9,'Walton Ruti maker',36,36,NULL,NULL,'2021-05-28 20:32:43','2021-09-09 16:53:38'),(77,'Walton Gang Switch Socket',9,'Walton Gang Switch Socket',36,36,NULL,NULL,'2021-05-28 20:33:02','2021-09-09 16:53:38'),(78,'Walton Phone',9,'Walton Mobile',36,36,NULL,NULL,'2021-05-28 20:33:17','2021-09-09 16:53:38'),(79,'Walton Mosar Batt',9,'Walton Mosar Batt',36,36,NULL,NULL,'2021-05-28 20:33:43','2021-09-09 16:53:38'),(80,'Walton Hotpot',9,'Walton Hotpot',36,36,NULL,NULL,'2021-05-28 20:34:01','2021-09-09 16:53:38'),(81,'Walton Table Fan',9,'Walton Table Fan',36,36,NULL,NULL,'2021-05-28 20:34:21','2021-09-09 16:53:38'),(82,'Walton Mouse',9,'Walton Mouse',36,36,NULL,NULL,'2021-05-28 20:34:37','2021-09-09 16:53:38'),(83,'Walton Keyboad',9,'Walton Keyboad',36,36,NULL,NULL,'2021-05-28 20:34:56','2021-09-09 16:53:38'),(84,'Walton Router',9,'Walton Router',36,36,NULL,NULL,'2021-05-28 20:35:16','2021-09-09 16:53:38'),(85,'Walton Memory Pen Drive',9,'Walton Memory',36,36,NULL,NULL,'2021-05-28 20:35:59','2021-09-09 16:53:38'),(86,'Walton All Electric Product',9,'Walton All Electric ProductWalton All Electric Product',36,36,NULL,NULL,'2021-05-28 20:36:22','2021-09-09 16:53:38'),(87,'Walton Gyser',9,'Walton Gyser',36,36,NULL,NULL,'2021-05-28 20:36:59','2021-09-09 16:53:38'),(88,'Walton Jali Fan',9,'Walton Jali Fan',36,36,NULL,NULL,'2021-05-28 20:37:26','2021-09-09 16:53:38'),(89,'Walton Air Cooler',9,'Walton Air Cooler',36,36,NULL,NULL,'2021-05-28 20:39:45','2021-09-09 16:53:38'),(90,'Walton Adjust Fan',9,'Walton Adjust Fan',36,36,NULL,NULL,'2021-05-28 20:39:55','2021-09-09 16:53:38'),(91,'Marcel Refrigaretor',9,'Marcel Refrigaretor',35,36,NULL,NULL,'2021-05-28 20:41:31','2021-05-28 20:41:31'),(92,'Walton Air Conditioner',9,'Walton Air Conditioner',36,36,NULL,NULL,'2021-05-28 20:48:38','2021-09-09 16:53:38'),(93,'Marcel 600Sd',9,'Marcel 600Sd',35,36,NULL,NULL,'2021-05-28 20:49:31','2021-05-28 20:49:31'),(94,'Marcel 1000SD',9,'Marcel 1000SD',35,36,NULL,NULL,'2021-05-28 20:49:55','2021-05-28 20:50:06'),(95,'Marcel 2000SD',9,'Marcel 2000SD',35,36,NULL,NULL,'2021-05-28 20:50:28','2021-05-28 20:50:28'),(96,'Marcel Rice Cooker',9,'Marcel Rice Cooker',35,36,NULL,NULL,'2021-05-28 20:50:46','2021-05-28 20:50:46'),(97,'Marcel Blender',9,'Marcel Blender',35,36,NULL,NULL,'2021-05-28 20:51:12','2021-05-28 20:51:12'),(98,'Marcel kettle',9,'Marcel kettle',35,36,NULL,NULL,'2021-05-28 20:53:04','2021-05-28 20:53:04'),(99,'Marcel Iron Mahcine',9,'Marcel Iron Mahcine',35,36,NULL,NULL,'2021-05-28 20:53:23','2021-05-28 20:53:23'),(100,'Marcel Room Heater',9,'Marcel Room Heater',35,36,NULL,NULL,'2021-05-28 20:53:43','2021-05-28 20:53:43'),(101,'Marcel Oven',9,'Marcel Oven',35,36,NULL,NULL,'2021-05-28 20:54:59','2021-05-28 20:54:59'),(102,'Marcel Water Purifier',9,'Marcel Water Purifier',35,36,NULL,NULL,'2021-05-28 20:55:20','2021-05-28 20:55:20'),(103,'Marcel Induction Cooker',9,'Marcel Induction Cooker',35,36,NULL,NULL,'2021-05-28 20:55:55','2021-05-28 20:55:55'),(104,'Marcel Air Conditioner',9,'Marcel Air Condition',35,36,NULL,NULL,'2021-05-28 20:56:14','2021-05-28 20:56:14'),(105,'Marcel Pressur Cooker',9,'Marcel Pressur Cooker',35,36,NULL,NULL,'2021-05-28 20:56:32','2021-05-28 20:56:32'),(106,'Marcel Single Stove',9,'Marcel Single Stove',35,36,NULL,NULL,'2021-05-28 20:56:54','2021-05-28 20:56:54'),(107,'Marcel Double Stove',9,'Marcel Double Stove',35,36,NULL,NULL,'2021-05-28 20:57:41','2021-05-28 20:57:41'),(108,'Marcel Charger Fan',9,'Marcel Charger Fan',35,36,NULL,NULL,'2021-05-28 20:58:08','2021-05-28 20:58:08'),(109,'Marcel 56\" Celeing Fan',9,'Marcel 56\" Celeing Fan',35,36,NULL,NULL,'2021-05-28 20:58:31','2021-05-28 20:58:31'),(110,'Marcel Touch Light',9,'Marcel Touch Light',35,36,NULL,NULL,'2021-05-28 20:58:52','2021-05-28 20:58:52'),(111,'Marcel Table Light',9,'Marcel Table Light',35,36,NULL,NULL,'2021-05-28 20:59:07','2021-05-28 20:59:07'),(112,'Marcel Washing Machine',9,'Marcel Washing Machine',35,36,NULL,NULL,'2021-05-28 20:59:45','2021-05-28 20:59:45'),(113,'Marcel Air Cooler',9,'Marcel Air Cooler',35,36,NULL,NULL,'2021-05-28 21:00:25','2021-05-28 21:00:25'),(114,'Marcel Led Light',9,'Marcel Led Light',35,36,NULL,NULL,'2021-05-28 21:00:44','2021-05-28 21:00:44'),(115,'Marcel Wall Movieng Fan',9,'Marcel Wall Movieng Fan',35,36,NULL,NULL,'2021-05-28 21:01:08','2021-05-28 21:01:08'),(116,'Marcel Mosar Batt',9,'Marcel Mosar Batt',35,36,NULL,NULL,'2021-05-28 21:01:28','2021-05-28 21:01:28'),(117,'Marcel Frypan',9,'Marcel Frypan',35,36,NULL,NULL,'2021-05-28 21:01:44','2021-05-28 21:01:44'),(118,'Bashundhara 12 kg Vora Gas',9,'Bashundhara 12 kg Vora Gas',38,36,NULL,NULL,'2021-05-29 16:23:21','2021-09-09 16:57:56'),(119,'Omera & others 12kg Vora Gas Silinder',9,'Omera & others 12kg Vora Gas Silinder',38,36,NULL,NULL,'2021-05-29 16:23:39','2021-09-09 16:57:56'),(120,'Bashundhara 30 Kg Vora Gas Silinder',9,'Bashundhara 30 Kg Vora Gas Silinder',38,36,NULL,NULL,'2021-05-29 16:23:55','2021-09-09 16:57:56'),(121,'Omera 35 kg Vora Gas',9,'Omera 35 kg Vora Gas',38,36,NULL,NULL,'2021-05-29 16:24:20','2021-09-09 16:57:56'),(122,'Total 12 Kg  Gas Silinder',9,'Total 12 Kg Silinder',38,36,NULL,NULL,'2021-05-29 16:24:54','2021-09-09 16:57:56'),(123,'Total 30/35/45 Gas kg Silinder',9,'Total 30/35/45 kg Silinder',38,36,NULL,NULL,'2021-05-29 16:25:21','2021-09-09 16:57:56'),(124,'All Doubel  Gas Stove',9,'Doubel Stove',38,36,NULL,NULL,'2021-05-29 16:25:46','2021-09-09 16:57:56'),(125,'All Single Gas Stove',9,'All Single Stove',38,36,NULL,NULL,'2021-05-29 16:26:09','2021-09-09 16:57:56'),(126,'Normal Singel & Dobule Gas Stove',9,'Normal Singel Stove',38,36,NULL,NULL,'2021-05-29 16:26:53','2021-09-09 16:57:56'),(127,'Gas Reguletor',9,'Gas Reguletor',38,36,NULL,NULL,'2021-05-29 16:27:14','2021-09-09 16:57:56'),(128,'Pressur Gas Reguletor',9,'Pressur Gas Reguletor',38,36,NULL,NULL,'2021-05-29 16:28:55','2021-09-09 16:57:56'),(129,'GAs Hospipe',9,'Hospipe',38,36,NULL,NULL,'2021-05-29 16:29:20','2021-09-09 16:57:56'),(130,'Gas Clip',9,'Gas Clip',38,36,NULL,NULL,'2021-05-29 17:08:27','2021-09-09 16:57:56'),(131,'Gas Chular Magnet',9,'Chular Magnet',38,36,NULL,NULL,'2021-05-29 17:09:02','2021-09-09 16:57:56'),(132,'Gas Chular Tupi/primium',9,'Chular Tupi/primium',38,36,NULL,NULL,'2021-05-29 17:09:28','2021-09-09 16:57:56'),(133,'Gas Chular Burner',9,'Chular Burner',38,36,NULL,NULL,'2021-05-29 17:09:43','2021-09-09 16:57:56'),(134,'Gas Chular Jhik',9,'Chular Jhik',38,36,NULL,NULL,'2021-05-29 17:09:56','2021-09-09 16:57:56'),(135,'Gas Chular Jhik',9,'Chular Jhik',38,36,NULL,NULL,'2021-05-29 17:10:21','2021-09-09 16:57:56'),(136,'Gas Chular Nob Chabi',9,'Chular Nob Chabi',38,36,NULL,NULL,'2021-05-29 17:10:37','2021-09-09 16:57:56'),(137,'Gas Chular Net',9,'Chular Net',38,36,NULL,NULL,'2021-05-29 17:11:00','2021-09-09 16:57:56'),(138,'Gas Chular Plet Pati',9,'Chular Plet Pati',38,36,NULL,NULL,'2021-05-29 17:11:17','2021-09-09 16:57:56'),(139,'Gas Chular All Product',9,'Chular All Product',38,36,NULL,NULL,'2021-05-29 17:11:37','2021-09-09 16:57:56'),(140,'Country Beef',9,'Other Brand Refrigaretor',39,36,NULL,NULL,'2021-05-29 19:41:13','2022-01-04 05:07:06'),(141,'Country Chicken',9,'Others Brand LED CRT tv',39,36,NULL,NULL,'2021-05-29 20:11:26','2022-01-04 05:07:06'),(142,'Country Mutton',9,'625/1000 VA Stabillaza',39,36,NULL,NULL,'2021-05-29 20:11:58','2022-01-04 05:07:06'),(143,'Country Broiler',9,'1250 VA Satabillaza',39,36,NULL,NULL,'2021-05-29 20:12:17','2022-01-04 05:07:06'),(144,'AE All Combain Switch',9,'All Combain Switch',39,36,NULL,NULL,'2021-05-29 20:12:41','2022-01-04 05:07:06'),(145,'AE Rice Cooker',9,'Rice Cooker',39,36,NULL,NULL,'2021-05-29 20:12:57','2022-01-04 05:07:06'),(146,'AE Blender',9,'Blender',39,36,NULL,NULL,'2021-05-29 20:13:14','2022-01-04 05:07:06'),(147,'AE All Electric Kettle',9,'All Electric Kettle',39,36,NULL,NULL,'2021-05-29 20:13:36','2022-01-04 05:07:06'),(148,'AE All Iron Machine',9,'All Iron Machine',39,36,NULL,NULL,'2021-05-29 20:13:56','2022-01-04 05:07:06'),(149,'AE All Led Light',9,'All Led Light',39,36,NULL,NULL,'2021-05-29 20:14:21','2022-01-04 05:07:06'),(150,'AE Room Heater',9,'Room Heater',39,36,NULL,NULL,'2021-05-29 20:14:44','2022-01-04 05:07:06'),(151,'AE All Digital Palla',9,'All Digital Palla',39,36,NULL,NULL,'2021-05-29 20:15:12','2022-01-04 05:07:06'),(152,'AE All Water Purifier',9,'All Water Purifier',39,36,NULL,NULL,'2021-05-29 20:15:33','2022-01-04 05:07:06'),(153,'AE All Pressur Cooker',9,'All Pressur Cooker',39,36,NULL,NULL,'2021-05-29 20:15:50','2022-01-04 05:07:06'),(154,'AE All Frypan',9,'All Frypan',39,36,NULL,NULL,'2021-05-29 20:16:03','2022-01-04 05:07:06'),(155,'AE All Hotpot',9,'All Hotpot',39,36,NULL,NULL,'2021-05-29 20:16:18','2022-01-04 05:07:06'),(156,'AE All Tv Remot',9,'All Tv Remot',39,36,NULL,NULL,'2021-05-29 20:16:50','2022-01-04 05:07:06'),(157,'AE All jack tv & Light',9,'jack',39,36,NULL,NULL,'2021-05-29 20:17:15','2022-01-04 05:07:06'),(158,'AE Fridge Trolly',9,'Fridge Trolly',39,36,NULL,NULL,'2021-05-29 20:17:39','2022-01-04 05:07:06'),(159,'AE 56\" Cileing Fan',9,'56\" Cileing Fan',39,36,NULL,NULL,'2021-05-29 20:18:18','2022-01-04 05:07:06'),(160,'AE 48\" Cileing Fan',9,'48\" Cileing Fan',39,36,NULL,NULL,'2021-05-29 20:18:33','2022-01-04 05:07:06'),(161,'AE 36\" Cilieng Fan',9,'36\" Cilieng Fan',39,36,NULL,NULL,'2021-05-29 20:18:54','2022-01-04 05:07:06'),(162,'AE 24\"Cileing Fan',9,'24 Cileing Fan',39,36,NULL,NULL,'2021-05-29 20:19:22','2022-01-04 05:07:06'),(163,'AE Ac Jali Fan',9,'Ac Jali Fan',39,36,NULL,NULL,'2021-05-29 20:19:41','2022-01-04 05:07:06'),(164,'AE Dc Jali Fan',9,'Dc Jali Fan',39,36,NULL,NULL,'2021-05-29 20:19:59','2022-01-04 05:07:06'),(165,'AE Ac Table Fan',9,'Ac Table Fan',39,36,NULL,NULL,'2021-05-29 20:20:18','2022-01-04 05:07:06'),(166,'AE Dc Table Fan',9,'Dc Table Fan',39,36,NULL,NULL,'2021-05-29 20:20:42','2022-01-04 05:07:06'),(167,'AE Ac Stand Fan',9,'Ac Stand Fan',39,36,NULL,NULL,'2021-05-29 20:20:57','2022-01-04 05:07:06'),(168,'AE Dc Stand Fan',9,'Dc Stand Fan',39,36,NULL,NULL,'2021-05-29 20:21:09','2022-01-04 05:07:06'),(169,'AE Charger Fan',9,'Charger Fan',39,36,NULL,NULL,'2021-05-29 20:21:27','2022-01-04 05:07:06'),(170,'AE Wall Moveing Fan',9,'Wall Movieng Fan',39,36,NULL,NULL,'2021-05-29 20:22:14','2022-01-04 05:07:06'),(171,'AE All Fan Reguletor',9,'All Fan Reguletor',39,36,NULL,NULL,'2021-05-29 20:22:36','2022-01-04 05:07:06'),(172,'AE All Fan Capasitor',9,'All Fan Capasitor',39,36,NULL,NULL,'2021-05-29 20:22:52','2022-01-04 05:07:06'),(173,'AE Solar Tube',9,'Solar Tube',39,36,NULL,NULL,'2021-05-29 20:23:19','2022-01-04 05:07:06'),(174,'AE Table LIght',9,'Table LIght',39,36,NULL,NULL,'2021-05-29 20:23:34','2022-01-04 05:07:06'),(175,'AE Touch Light',9,'Touch Light',39,36,NULL,NULL,'2021-05-29 20:23:57','2022-01-04 05:07:06'),(176,'AE 6V Bettery',9,'6V Bettery',39,36,NULL,NULL,'2021-05-29 20:24:40','2022-01-04 05:07:06'),(177,'AE All Malti Plag',9,'All Malti Plag',39,36,NULL,NULL,'2021-05-29 20:25:44','2022-01-04 05:07:06'),(178,'AE All Calculetor',9,'All Calculetor',39,36,NULL,NULL,'2021-05-29 20:26:28','2022-01-04 05:07:06'),(179,'AE Adjust Fan',9,'Adjust Fan',39,36,NULL,NULL,'2021-05-29 20:26:42','2022-01-04 05:07:06'),(180,'AE Water Heater',9,'Water Heater',39,36,NULL,NULL,'2021-05-29 20:27:00','2022-01-04 05:07:06'),(181,'AE Mosar Batt',9,'Mosar Batt',39,36,NULL,NULL,'2021-05-29 20:27:21','2022-01-04 05:07:06'),(182,'AE Normal Bulb',9,'Normal Bulb',39,36,NULL,NULL,'2021-05-29 20:27:37','2022-01-04 05:07:06'),(183,'AE Main Switch',9,'Main Switch',39,36,NULL,NULL,'2021-05-29 20:27:54','2022-01-04 05:07:06'),(184,'AE Solar Panel',9,'Solar Panel',39,36,NULL,NULL,'2021-05-29 20:28:13','2022-01-04 05:07:06'),(185,'AE Solar Bettary',9,'Solar Bettary',39,36,NULL,NULL,'2021-05-29 20:28:32','2022-01-04 05:07:06'),(186,'AE Solar Charge Controlar',9,'Solar Charge Controlar',39,36,NULL,NULL,'2021-05-29 20:28:50','2022-01-04 05:07:06'),(187,'AE Solar Panel Stackcar',9,'Solar Panel Stackcar',39,36,NULL,NULL,'2021-05-29 20:29:08','2022-01-04 05:07:06'),(188,'AE Arthin Road',9,'Arthin Road',39,36,NULL,NULL,'2021-05-29 20:30:33','2022-01-04 05:07:06'),(189,'AE Calling Bell',9,'Calling Bell',39,36,NULL,NULL,'2021-05-29 20:31:02','2022-01-04 05:07:06'),(190,'AE All Gang Switch',9,'All Gang Switch',39,36,NULL,NULL,'2021-05-29 20:31:25','2022-01-04 05:07:06'),(191,'AE Gyser',9,'Gyser',39,36,NULL,NULL,'2021-05-29 20:31:40','2022-01-04 05:07:06'),(192,'AE All Electric Product',9,'All Electric Product',39,36,NULL,NULL,'2021-05-29 20:32:02','2022-01-04 05:07:06'),(193,'AE Ac Dc Kebol',9,'Ac Dc Kebol',39,36,NULL,NULL,'2021-05-29 20:32:19','2022-01-04 05:07:06'),(194,'AE Jamkill kit',9,'Jamkill kit',39,36,NULL,NULL,'2021-05-29 20:32:42','2022-01-04 05:07:06'),(195,'AE Filter Kol',9,'Filter Kol',39,36,NULL,NULL,'2021-05-29 20:32:58','2022-01-04 05:07:06'),(196,'AE Sub Mitter',9,'Sub Mitter',39,36,NULL,NULL,'2021-05-29 20:33:33','2022-01-04 05:07:06'),(197,'AE Akash DTH',9,'Akash DTH',39,36,NULL,NULL,'2021-05-29 20:33:49','2022-01-04 05:07:06'),(198,'AE CC Cemara Product',9,'CC Cemara Product',39,36,NULL,NULL,'2021-05-29 20:34:13','2022-01-04 05:07:06'),(199,'AE All Trimmer & Shaver',9,'All Trimmer & Shaver',39,36,NULL,NULL,'2021-05-29 20:34:42','2022-01-04 05:07:06'),(200,'AE Purit Stand',9,'0581',39,36,NULL,NULL,'2021-05-29 20:35:29','2022-01-04 05:07:06'),(201,'AE TEST1',9,'China Mobile',39,36,NULL,NULL,'2021-05-29 20:36:21','2022-01-04 05:07:06'),(202,'AE',9,'Nokia Mobile',39,36,NULL,NULL,'2021-05-29 20:36:33','2022-01-04 05:07:06'),(203,'Mobile Charger',9,'Mobile Charger',37,36,NULL,NULL,'2021-05-29 20:37:00','2021-09-09 16:55:24'),(204,'Mobile Bettery',9,'Mobile Bettery',37,36,NULL,NULL,'2021-05-29 20:37:53','2021-09-09 16:55:24'),(205,'Mobile Memory',9,'Mobile Memory',37,36,NULL,NULL,'2021-05-29 20:38:11','2021-09-09 16:55:24'),(206,'Mobile Touch Light Charger',9,'Touch Light Charger',37,36,NULL,NULL,'2021-05-29 20:38:32','2021-09-09 16:55:24'),(207,'Mobile GP Felxiload',9,'GP Felxiload',37,36,NULL,NULL,'2021-05-29 20:38:54','2021-09-09 16:55:24'),(208,'Mobile Bl I Top-up',9,'Bl I Top-up',37,36,NULL,NULL,'2021-05-29 20:39:18','2021-09-09 16:55:24'),(209,'AE IPS',9,'ips',39,36,NULL,NULL,'2021-06-05 20:00:36','2022-01-04 05:07:06'),(210,'Gas Hotel Chula',9,'hotelchula',38,36,NULL,NULL,'2021-06-05 20:03:23','2021-09-09 16:57:56'),(211,'Walton Genaretor',9,'Walton Genaretor',36,36,NULL,NULL,'2021-06-05 20:10:08','2021-09-09 16:53:38'),(212,'Chaina  Mobile',9,'Chaina  Mobile',37,36,NULL,NULL,'2021-06-08 23:19:47','2021-09-09 16:55:24'),(213,'Nokia Mobile',9,'nokia',37,36,NULL,NULL,'2021-06-14 14:43:32','2021-09-09 16:55:24'),(214,'Walton Malti Plag',9,'Walton Malti Plag',36,36,NULL,NULL,'2021-06-20 16:59:49','2021-09-09 16:53:38'),(215,'AE Purit Mesh',9,'mesh',39,36,NULL,NULL,'2021-08-07 14:44:43','2022-01-04 05:07:06'),(216,'test',9,NULL,0,36,NULL,'2022-01-15 17:42:50','2021-09-05 14:52:02','2022-01-15 17:42:50'),(217,'test sub 1 edited',9,NULL,216,36,NULL,NULL,'2021-09-05 14:53:25','2021-09-05 15:01:53'),(218,'test sub 2 edit',9,NULL,216,36,NULL,NULL,'2021-09-05 14:53:41','2021-09-05 15:01:53'),(219,'Walton Speaker',9,'speaker',36,36,NULL,NULL,'2021-10-13 15:31:38','2021-10-13 15:31:38'),(220,'WALTON TRIMMER',9,'TRIMMER',36,36,NULL,NULL,'2021-10-15 16:17:22','2021-10-15 16:17:22'),(221,'Burka',9,'BK45647r83',0,36,NULL,NULL,'2021-12-04 16:26:17','2021-12-04 16:26:17'),(222,'Food',9,NULL,0,36,NULL,NULL,'2021-12-14 09:07:48','2023-03-30 03:22:38'),(223,'TICKET',9,'dubai',0,36,NULL,'2022-01-15 17:42:46','2021-12-14 09:27:48','2022-01-15 17:42:46'),(224,'Nuts',9,NULL,0,36,NULL,'2022-01-15 17:42:54','2022-01-11 08:18:12','2022-01-15 17:42:54'),(225,'GENTS ITEM',9,NULL,0,36,NULL,NULL,'2022-01-14 14:12:13','2022-01-14 14:12:13'),(226,'KIDS ZONE',9,'KDS',35,36,NULL,NULL,'2022-01-15 17:39:02','2022-01-15 17:39:02'),(227,'KIDS ZONE',9,'KDS',0,36,NULL,NULL,'2022-01-15 17:42:25','2022-01-15 17:42:25'),(228,'Panjabi',9,NULL,0,36,NULL,NULL,'2022-02-12 04:54:21','2022-02-12 04:54:21'),(229,'PLUG',9,NULL,0,36,NULL,NULL,'2022-02-21 00:05:44','2022-02-21 00:05:44'),(230,'CABLE',9,NULL,0,36,NULL,NULL,'2022-02-21 00:05:52','2022-02-21 00:05:52'),(231,'TYER',9,NULL,0,36,NULL,NULL,'2022-02-21 00:06:01','2022-02-21 00:06:01'),(232,'BREAKSHOO',9,NULL,0,36,NULL,NULL,'2022-02-21 00:06:11','2022-02-21 00:06:11'),(233,'Miniket',9,'Badsa Miniket',0,36,NULL,NULL,'2022-02-24 03:38:54','2022-02-24 03:38:54'),(234,'Miniket',9,'Al-Hera Pusti',0,36,NULL,NULL,'2022-02-24 03:39:24','2022-02-24 03:39:24'),(235,'Katari Nazir',9,'Al-Hera Pusti',0,36,NULL,NULL,'2022-02-24 03:40:19','2022-02-24 03:40:19'),(236,'Katari Nazir',9,'Badsa',0,36,NULL,NULL,'2022-02-24 03:41:11','2022-02-24 03:41:11'),(237,'Sugondi Katari Vog',9,'Badsa',0,36,NULL,NULL,'2022-02-24 03:41:42','2022-02-24 03:41:42'),(238,'Basmoti',9,'Desh Bando',0,36,NULL,NULL,'2022-02-24 03:42:25','2022-02-24 03:42:25'),(239,'Zirashail',9,'BanglarMukh',0,36,NULL,NULL,'2022-02-24 03:42:58','2022-02-24 03:42:58'),(240,'Pusti Atas',9,'Al-Hera Pusti',0,36,NULL,NULL,'2022-02-24 03:43:34','2022-02-24 03:43:34'),(241,'Soft Drink',9,NULL,0,36,NULL,NULL,'2022-04-13 06:54:44','2022-04-13 06:54:44'),(242,'গেন্জি চায়না',9,NULL,0,36,NULL,'2022-06-06 14:20:08','2022-06-06 14:19:43','2022-06-06 14:20:08'),(243,'গেন্জি',9,NULL,0,36,NULL,NULL,'2022-06-06 14:20:29','2022-06-06 14:20:29'),(244,'প্যান্ট',9,NULL,0,36,NULL,NULL,'2022-06-06 14:49:53','2022-06-06 14:49:53'),(245,'Shoes',9,NULL,0,36,NULL,NULL,'2022-08-30 10:24:38','2022-08-30 10:24:38'),(246,'Flat',9,NULL,245,36,NULL,NULL,'2022-08-30 10:24:38','2022-08-30 10:24:38'),(247,'rice',9,NULL,0,36,NULL,NULL,'2022-08-30 10:29:13','2022-08-30 10:29:13'),(248,'new cat',9,NULL,0,36,NULL,NULL,'2023-03-13 06:07:47','2023-03-13 06:07:47'),(249,'khai khai',9,'1234 kha',0,36,NULL,NULL,'2023-03-15 17:02:56','2023-03-15 17:02:56'),(250,'no 1',9,'1234',231,36,NULL,NULL,'2023-03-16 04:00:31','2023-03-16 04:00:31'),(251,'mango juice',9,NULL,0,36,NULL,NULL,'2023-03-23 03:10:47','2023-03-23 03:10:47'),(252,'hobby',9,NULL,0,36,NULL,NULL,'2023-03-23 14:34:46','2023-03-23 14:34:46'),(253,'roton',9,NULL,0,36,NULL,NULL,'2023-03-29 03:08:27','2023-03-29 03:08:27'),(254,'food',9,NULL,222,36,NULL,NULL,'2023-03-30 03:17:24','2023-03-30 03:19:39');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `commision_agent_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `commision_agent_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `variations_id` int(11) NOT NULL,
  `agent_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_quantity` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `commision_agent_stock` WRITE;
/*!40000 ALTER TABLE `commision_agent_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `commision_agent_stock` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('supplier','customer','both') NOT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `customer_type` varchar(15) NOT NULL,
  `balance` double NOT NULL DEFAULT 0,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `landmark` varchar(191) DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(20,2) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `selling_price_groups_id` int(11) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2120 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer','Own','Walk-In Customer','',0,NULL,'CO1085',NULL,'Dhaka','Gulshan Avenue','Bangladesh',' Gulshan-2','01711538073',NULL,NULL,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2018-01-04 01:45:20','2020-12-28 05:39:00'),(43,9,'customer',NULL,'Walk-In Customer','',0,NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,36,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2019-04-22 20:06:41','2019-04-22 20:06:41'),(1459,1,'supplier','CW PARK','B&F FOODS LTD.','general',0,NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'01711538073',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-30 06:04:02','2021-01-30 06:04:02'),(1460,1,'supplier','K-MARKET','MR. KIM','general',0,NULL,'CO0002',NULL,NULL,NULL,NULL,NULL,'01911930036',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-01-31 20:31:22','2021-01-31 20:31:22'),(1461,1,'customer',NULL,'jewel babu','general',0,NULL,'CO0003',NULL,NULL,NULL,NULL,NULL,'01700000005',NULL,NULL,NULL,NULL,NULL,1,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-27 16:09:12','2021-05-27 16:09:12'),(1462,9,'supplier','Walton Frz tv','Walton Hi-Tech Ind Ltd','general',0,NULL,'01791083415',NULL,NULL,NULL,NULL,NULL,'01712811913',NULL,NULL,NULL,'days',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-05-28 13:27:36','2021-05-28 13:27:36'),(1463,9,'customer',NULL,'Robin Sarder','general',1100,NULL,'01791083416',NULL,'Bhedarganj','Shariatpur','bangladesh','Bhedarganj','01791083415',NULL,'01791083415',NULL,NULL,NULL,36,0,NULL,'East Zone',NULL,NULL,NULL,0,'2021-06-25 20:43:00','2021-05-28 13:51:12','2021-06-25 20:43:00'),(1464,9,'customer',NULL,'Mamun','general',0,NULL,'01726269966',NULL,'Shariatpur','Bhedarganj','Bangladesh','Choygaw','01726269966',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,'2021-06-25 20:42:47','2021-05-28 14:09:14','2021-06-25 20:42:47'),(1466,9,'customer',NULL,'Raijib','general',0,NULL,'017910834156d',NULL,'Bhedarganj','Shariatpur','bangladesh','Bhedarganj','01791083415',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,'2021-06-25 20:42:55','2021-06-05 16:15:34','2021-06-25 20:42:55'),(1467,9,'customer',NULL,'Awlad','general',25000,NULL,'01711008617',NULL,'Bhedarganj','Shariatpur','Bangladesh','Dis office','01711008617',NULL,NULL,NULL,'months',NULL,36,0,NULL,'East Zone',NULL,NULL,NULL,0,NULL,'2021-06-25 20:47:59','2021-10-26 23:43:03'),(1468,9,'customer',NULL,'Si Faruk','general',0,'admin@alampos.com','CO0007',NULL,'Bhedarganj','Bhedorgonj','7/1/19(2)','Thana stap','01716591772',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:04:42','2021-07-25 22:39:35'),(1469,9,'customer',NULL,'Babyr Ma','general',0,NULL,'CO0008',NULL,'Bhedarganj','Bhedarganj','(16) 24/02/2019','Bhedarganj','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:06:41','2021-06-30 15:43:40'),(1470,9,'customer',NULL,'Samol Babu','general',0,NULL,'CO0009',NULL,'bhedarganj bazar','Bhedarganj','(23) 13/5/20',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:08:07','2021-06-30 15:44:39'),(1471,9,'customer',NULL,'Razzak','general',0,NULL,'CO0010',NULL,'Goidda madarash Teacher','Bhedarganj','27)   26/03/19',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:09:28','2021-06-30 15:46:08'),(1472,9,'customer',NULL,'Motaleb Mallik','general',0,NULL,'CO0011',NULL,'Charpayatoli','Sakhipur','(31) 4/4/19','Bhedarganj','01728369843',NULL,'01764319746',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:40:15','2021-06-30 15:46:47'),(1473,9,'customer',NULL,'Abdul Mannan Howlader (250)','general',0,NULL,'CO0012',NULL,'Bhedarganj','Shariatpur','(33) 12/4/19','Sabek Mayeor','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:41:23','2021-06-30 16:22:12'),(1474,9,'customer',NULL,'Ajimullah Bepary','general',0,NULL,'CO0013',NULL,'Bhedarganj','bhd','Bd','Fan babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 21:42:48','2021-06-25 21:42:48'),(1475,9,'customer',NULL,'Farhad Kazi','general',0,NULL,'CO0014',NULL,NULL,NULL,'(46) 08/05/19',NULL,'01922220680',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:18:27','2021-06-30 16:24:04'),(1476,9,'customer',NULL,'Delowar Mridha','general',0,NULL,'CO0015',NULL,'Putia','Bhedarganj','(50)','Dokan Stap, putia','01323020880',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:20:32','2021-10-09 20:33:35'),(1477,9,'customer',NULL,'Dulal Doctor','general',0,NULL,'CO0016',NULL,'Bazar',NULL,'(57) 27/5/19','Bhedarganj','01713533975',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:21:55','2021-06-30 16:25:24'),(1478,9,'customer',NULL,'Samsu Bepary','general',0,NULL,'CO0017',NULL,NULL,'Shariatpur','(61) 3/6/19','Hoque tredas, burirhat','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:23:09','2021-07-26 21:25:54'),(1479,9,'customer',NULL,'Nuru Talukder','general',0,NULL,'CO0018',NULL,'Pom','Bhedarganj','(73) 27/6/19','Bonnar Baba','01771447792',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:24:53','2021-06-30 16:26:32'),(1480,9,'customer',NULL,'Md Sujon Sarder','general',0,NULL,'CO0019',NULL,'Bhedarganj','Shariatpur','(83) 22/7/19','Purosova 2no word','01712775987',NULL,'01703038188',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:26:30','2021-06-30 16:27:28'),(1481,9,'customer',NULL,'Arju Dhali','general',0,NULL,'CO0020',NULL,'Mohishar','Bhedarganj','(87) 2/8/19','3no word, Mohisar','01784529896',NULL,'01954913358',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:27:38','2021-07-26 21:28:06'),(1482,9,'customer',NULL,'Mamun','general',0,NULL,'CO0021',NULL,NULL,NULL,'89','Dokan Stap','01726269966',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:28:16','2021-10-12 14:28:40'),(1483,9,'customer',NULL,'Malek Sarder','general',0,NULL,'CO0022',NULL,'Sattopur','Bhedarganj','(96) 10/8/19','Fol Rafiq Marfat','01706503725',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:33:52','2021-06-30 16:29:12'),(1484,9,'customer',NULL,'Urmi Dolon Munsi','general',0,NULL,'CO0023',NULL,'Sajonpur','Bhedarganj','(103) 22/8/19','Sajonpur','01763442957',NULL,'01731138099',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:35:08','2021-07-25 23:14:32'),(1485,9,'customer',NULL,'Selim Gain','general',0,NULL,'CO0024',NULL,'bazar',NULL,'(107) 6/9/19','hotel','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:35:59','2021-06-30 16:30:16'),(1486,9,'customer',NULL,'Raj Ibrahim','general',0,NULL,'CO0025',NULL,'Ferangi kandi',NULL,'(107) 29/12/20',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:36:52','2021-06-30 16:30:46'),(1487,9,'customer',NULL,'Khalek','general',0,NULL,'CO0026',NULL,NULL,NULL,'(109) 15/9/19',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:37:31','2021-06-30 16:31:11'),(1488,9,'customer',NULL,'Delowar Munsi','general',0,NULL,'CO0027',NULL,NULL,NULL,'(113) 23/9/19',NULL,'01932409676',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:38:14','2021-06-30 16:31:36'),(1489,9,'customer',NULL,'Parvin Akter','general',0,NULL,'CO0028',NULL,'DM KHALI','Sakhipur','(116) 30/9/19',NULL,'01715620591',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:39:37','2021-06-30 16:32:35'),(1490,9,'customer',NULL,'Hannan Munsi','general',0,NULL,'CO0029',NULL,'125','Bhedarganj','(125) 5/11/19','Paschimputia','01937801028',NULL,'01739891085',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:41:44','2021-06-30 16:33:01'),(1491,9,'customer',NULL,'Milon Farnichar','general',0,NULL,'CO0030',NULL,NULL,NULL,'(138) 29/12/19',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-25 22:53:14','2021-06-30 16:34:06'),(1492,9,'customer',NULL,'Harun Sangbadik','general',0,NULL,'CO0031',NULL,'Mirjapur','Bhedarganj','(146) 31/1/20',NULL,'01726696922',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:42:56','2021-06-30 16:35:45'),(1493,9,'customer',NULL,'Rajon Enterprice','general',0,NULL,'CO0032',NULL,'Bazar',NULL,'(157) 14/3/20',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:44:28','2021-06-30 16:38:00'),(1494,9,'customer',NULL,'Sohag Dewan','general',0,NULL,'CO0033',NULL,'Bhedarganj',NULL,'(160) 23/3/20','Pourosova','01952754471',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:52:14','2021-06-30 16:38:39'),(1495,9,'customer',NULL,'Shuvo','general',0,NULL,'CO0034',NULL,'bosser varatia',NULL,'(164) 4/5/20',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:53:30','2021-06-30 16:39:24'),(1496,9,'customer',NULL,'Sahid Dewan','general',0,NULL,'CO0035',NULL,'Bhedarganj',NULL,'(165) 13/05/20','Sattar Maker Marfot, bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:54:24','2021-07-26 21:40:34'),(1497,9,'customer',NULL,'Robin Sarder','general',0,NULL,'CO0036',NULL,'Dingamanik','Naria','(167)','Dokan Stap','01791083415',NULL,NULL,NULL,'months',NULL,36,0,1,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:56:00','2021-09-04 16:15:17'),(1498,9,'customer',NULL,'Boba Maker','general',0,NULL,'CO0037',NULL,NULL,NULL,'(174) 15/6/20',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 15:57:11','2021-06-30 16:44:09'),(1499,9,'customer',NULL,'Samim Talukder','general',0,NULL,'CO0038',NULL,'Bhedarganj','Shariatpur','(174) 15/6/20','Putia Talukder Bari','01784418171',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:02:30','2021-06-30 16:43:38'),(1500,9,'customer',NULL,'Kawsar Mithai','general',0,NULL,'CO0039',NULL,'Bazar',NULL,'(178) 26/6/20 (410)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:03:10','2021-07-25 19:28:27'),(1501,9,'customer',NULL,'Sumaya Munsi','general',0,NULL,'CO0040',NULL,NULL,NULL,'(179) 5/7/20','sottopur','01797181075',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:03:46','2021-06-30 16:45:10'),(1502,9,'customer',NULL,'Motaleb Master','general',0,NULL,'CO0041',NULL,'Bhedarganj',NULL,'(179) 3/8/20','4 no word Morol barir satha','01747603299',NULL,'01793478705',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:04:44','2021-06-30 16:46:03'),(1503,9,'customer',NULL,'Abul Hossain Khan','general',0,NULL,'CO0042',NULL,'Bhedarganj',NULL,'(182) 13/7/20','Putia 3 no word','01636108882',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:05:39','2021-06-30 16:46:46'),(1504,9,'customer',NULL,'Dulal Sarder','general',0,NULL,'CO0043',NULL,'Bhedarganj',NULL,'(183) 16/7/20','5 no word purosova','01620359859',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:06:29','2021-06-30 16:47:18'),(1505,9,'customer',NULL,'Goni Talukder','general',0,NULL,'CO0044',NULL,'Bazar',NULL,'(192)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:07:15','2021-06-30 16:48:57'),(1506,9,'customer',NULL,'Jahangir Alam','general',0,NULL,'CO0045',NULL,'Gulmaij','Naria','(197) 3/8/20','Faruk Vai Marfot,gulmaij','01707175875',NULL,'01993313220',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:08:55','2021-07-26 21:53:48'),(1507,9,'customer',NULL,'Rubel Maik','general',0,NULL,'CO0046',NULL,'Bazar',NULL,'(197) 3/8/20',NULL,'01736046651',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:09:25','2021-06-30 16:50:35'),(1508,9,'customer',NULL,'Nasir Talukder','general',0,NULL,'CO0047',NULL,'Bhedarganj',NULL,'(198) 5/8/20','9 no word','01770650857',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:10:26','2021-06-30 16:51:02'),(1509,9,'customer',NULL,'Masum Reza','general',0,NULL,'CO0048',NULL,'Bhedarganj',NULL,'(205) 23/8/20','4 no word purosova','01716822488',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:11:31','2021-06-30 16:51:39'),(1510,9,'customer',NULL,'Mijan Topader','general',0,NULL,'CO0049',NULL,'Bhedarganj','Shariatpur','(210) 11/9/20','7 no word Porosova','01707700524',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:12:46','2021-06-30 16:52:18'),(1511,9,'customer',NULL,'Moli Shikder','general',0,NULL,'CO0050',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:13:30','2021-06-26 16:13:30'),(1512,9,'customer',NULL,'Sahid Mridha','general',0,NULL,'CO0051',NULL,'Bhedarganj',NULL,'(222) 24/10/20','Billal Tablig marfot','01732470423',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:14:33','2021-06-30 16:53:19'),(1513,9,'customer',NULL,'Mahfujur Rahman mridha','general',0,NULL,'CO0052',NULL,'putia','Bhedarganj','shariatprur','Delowar mridha marfot, putia','01952028472',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:17:06','2021-07-26 20:57:17'),(1514,9,'customer',NULL,'Poltu Molla','general',0,NULL,'CO0053',NULL,NULL,'Bhedarganj','shariatprur','arji pom Sajonpur','01790123710',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:18:37','2021-07-25 23:46:20'),(1515,9,'customer',NULL,'Shukur Mogor','general',0,NULL,'CO0054',NULL,NULL,NULL,'(227) 13/11/20',NULL,'01300264311',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:19:09','2021-06-30 16:53:57'),(1516,9,'customer',NULL,'Chinu Begum (220)','general',0,NULL,'CO0055',NULL,'BHEDARGONJ',NULL,'25/12/15','Mannan bepary wife','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:19:43','2021-07-24 23:46:33'),(1517,9,'customer',NULL,'Sumon Chandra Das','general',0,NULL,'CO0056',NULL,'Burirhat','Shariatpur',NULL,'Sabek stap','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:20:41','2021-06-26 16:20:41'),(1518,9,'customer',NULL,'Sohel Sarder','general',0,NULL,'CO0057',NULL,NULL,NULL,'(234) 3/12/20','bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:22:55','2021-06-30 16:54:42'),(1519,9,'customer',NULL,'Mannan Soyal','general',0,NULL,'CO0058',NULL,'Bhedarganj','Shariatpur',NULL,'Sajonpur','01732742652',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:31:20','2021-06-26 16:31:20'),(1520,9,'customer',NULL,'Ali Ajam Faridi','general',0,NULL,'CO0059',NULL,NULL,NULL,'(239 new) (391 old) (472)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:32:10','2021-07-25 21:01:54'),(1521,9,'customer',NULL,'Moslem Sarder','general',0,NULL,'CO0060',NULL,NULL,NULL,'(240) 2/1/21','Koral toli kalu majhi madrash','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:33:02','2021-06-30 16:56:23'),(1522,9,'customer',NULL,'Master Wahab','general',0,NULL,'CO0061',NULL,NULL,NULL,'(242) 11/1/21','chula babod','01762997632',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:33:44','2021-06-30 16:56:49'),(1523,9,'customer',NULL,'Sahidul Talukder','general',0,NULL,'CO0062',NULL,NULL,NULL,'(244) 20/1/21','Moti buar nati','01746299455',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:34:32','2021-06-30 16:57:11'),(1524,9,'customer',NULL,'Chunnu Holader','general',0,NULL,'CO0063',NULL,NULL,NULL,'(250)','kachamal bebsai','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:36:44','2021-06-30 17:02:01'),(1525,9,'customer',NULL,'Reject Product','general',0,NULL,'CO0064',NULL,NULL,NULL,NULL,'dokan','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:37:37','2021-06-26 16:37:37'),(1526,9,'customer',NULL,'Polash Sarder','general',0,NULL,'CO0065',NULL,'Bhedarganj','Shariatpur','(254) 10/2/21','Sajonpur bridger Satha','01969311245',NULL,'01768158992',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:38:33','2021-06-30 17:02:50'),(1527,9,'customer',NULL,'Sajib Chowdhory','general',0,NULL,'CO0066',NULL,'Mohishar 3 no word','Bhedarganj','shariatprur','Robin Chowdhory marfot','01785010093',NULL,'01312904328',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:39:37','2021-06-26 16:39:37'),(1528,9,'customer',NULL,'Sumon Munsi','general',0,NULL,'CO0067',NULL,'Bhedarganj','Shariatpur','(255) 15/2/21','koral toli 9 no word','01305547150',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:40:30','2021-06-30 17:02:31'),(1529,9,'customer',NULL,'Nahid','general',0,NULL,'CO0068',NULL,'Bhedarganj',NULL,'(257) 20/2/21','Madina Trddass, bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:41:09','2021-07-26 22:02:34'),(1530,9,'customer',NULL,'Sahalom Sarder','general',0,NULL,'CO0069',NULL,NULL,NULL,'1','Robin kaka','14',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:43:27','2021-07-24 22:59:04'),(1531,9,'customer',NULL,'Dulal Chokder','general',0,NULL,'CO0070',NULL,NULL,NULL,'(259) 3/3/21',NULL,'nul',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:43:52','2021-06-30 17:04:05'),(1532,9,'customer',NULL,'Haji Abul Kasem Howlader','general',0,NULL,'CO0071',NULL,'damudda','Shariatpur','(262) 7/3/21','sidda boro howlader bari','01715309190',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:44:59','2021-06-30 17:04:39'),(1533,9,'customer',NULL,'Moshiur Rahman','general',0,NULL,'CO0072',NULL,NULL,NULL,'(262) 07/3/21','Modhumoti bank','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:45:48','2021-06-30 17:07:59'),(1534,9,'customer',NULL,'Mamun Italy Plaza','general',0,NULL,'CO0073',NULL,NULL,NULL,'(262) 7/3/21','bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:46:26','2021-06-30 17:08:25'),(1535,9,'customer',NULL,'kabir Vuia','general',0,NULL,'CO0074',NULL,NULL,NULL,'(263) 9/3/21','pom','01722280256',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:47:23','2021-06-30 17:09:06'),(1536,9,'customer',NULL,'Sahu Rari(190)','general',0,NULL,'CO0075',NULL,NULL,NULL,'(264) 10/3/21','Pourosova','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:49:04','2021-06-30 17:09:32'),(1537,9,'customer',NULL,'Alamgir','general',0,NULL,'CO0076',NULL,'9 no word',NULL,'(265) 13/3/21','Char koraltoli , Midha kandi','01786496380',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 16:51:06','2021-06-30 17:10:59'),(1538,9,'customer',NULL,'Modhu Ghosh','general',0,NULL,'CO0077',NULL,'Bazar',NULL,'(266) 20/3/21',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:24:57','2021-06-30 17:11:49'),(1539,9,'customer',NULL,'Ratan Dash','general',0,NULL,'CO0078',NULL,NULL,NULL,'(266) 16/3/21',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:25:17','2021-06-30 17:11:24'),(1540,9,'customer',NULL,'Bacchu peda','general',0,NULL,'CO0079',NULL,'bazar',NULL,'(266) 20/3/21','fol bebsoai','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:25:36','2021-06-30 17:12:18'),(1541,9,'customer',NULL,'Manju Apa','general',0,NULL,'CO0080',NULL,NULL,NULL,NULL,'Ramvodropur','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:26:04','2021-06-26 20:26:04'),(1542,9,'customer',NULL,'Rashid','general',0,NULL,'CO0081',NULL,'naria','Shariatpur',NULL,'dingamanik','01706242190',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:26:38','2021-06-26 20:26:38'),(1543,9,'customer',NULL,'Mijanur Rahman','general',0,NULL,'CO0082',NULL,NULL,'Bhedarganj','shariatprur','4 no wrod Ramvodropur','01720545580',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:27:23','2021-07-26 22:07:26'),(1544,9,'customer',NULL,'Raj Kuamar','general',0,NULL,'CO0083',NULL,'Bhedarganj','Shariatpur',NULL,'2 no word Pourosova','01770382033',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:28:03','2021-06-26 20:28:03'),(1545,9,'customer',NULL,'Raj Kumar','general',0,NULL,'CO0084',NULL,'Bhedarganj','Shariatpur',NULL,'2 no word Pourosova','01770382033',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:29:20','2021-06-26 20:29:20'),(1546,9,'customer',NULL,'Samsu molla','general',0,NULL,'CO0085',NULL,'Bhedarganj','Shariatpur',NULL,'4 no word Ikor kandi','01727869280',NULL,'01739667299',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:30:28','2021-06-26 20:30:28'),(1547,9,'customer',NULL,'Sumon Majhi','general',0,NULL,'CO0086',NULL,NULL,NULL,NULL,NULL,'0176207143',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:30:55','2021-06-26 20:30:55'),(1548,9,'customer',NULL,'hamid Fakir','general',0,NULL,'CO0087',NULL,'Bhedarganj','Shariatpur',NULL,'9 now Word Singjala Madrashsar Satha','01778732493',NULL,'01707761794',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:32:01','2021-06-26 20:32:01'),(1549,9,'customer',NULL,'Anowar Hossain','general',0,NULL,'CO0088',NULL,'Mohishar','Shariatpur',NULL,'3 no word','01717353549',NULL,'01998848760',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:32:42','2021-06-26 20:33:21'),(1550,9,'customer',NULL,'Faijur Rahman','general',0,NULL,'CO0089',NULL,NULL,NULL,'6/4/21 (272)','Farid Vai marfot,Charpayatoli molla kandi','01938510201',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:34:28','2021-07-26 22:22:21'),(1551,9,'customer',NULL,'Ajad Entrerprice','general',0,NULL,'CO0090',NULL,NULL,NULL,NULL,'bazar','nul',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:35:01','2021-06-26 20:35:01'),(1552,9,'customer',NULL,'Kalachan Fakir','general',0,NULL,'CO0091',NULL,'Bhedarganj','Shariatpur','6/4/21 (272)','bazar, Pichoner goli senetari dokan','01752912914',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:36:34','2021-07-27 17:08:13'),(1553,9,'customer',NULL,'Nasir KHan','general',0,NULL,'CO0092',NULL,NULL,NULL,NULL,'Pancha palli','01744266820',NULL,'01811225338',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:37:22','2021-06-26 20:37:22'),(1554,9,'customer',NULL,'Md Shakil Mallik','general',0,NULL,'CO0093',NULL,'Charpayatoli','Sakhipur','8/4/21 (273)','Belayet Hossain Sarder Kandi,Charpayatoli','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:38:09','2021-07-27 17:12:51'),(1555,9,'customer',NULL,'Md Faruk Shikder','general',0,NULL,'CO0094',NULL,'Bhedarganj','Shariatpur',NULL,'1 no word Paschim Putia','01984496204',NULL,'01700893048',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:45:53','2021-06-26 20:45:53'),(1556,9,'customer',NULL,'Parvej','general',0,NULL,'CO0095',NULL,NULL,NULL,'11/4/21 (275)','Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:46:28','2021-07-27 17:15:48'),(1557,9,'customer',NULL,'Hosne Ara Rubi','general',0,NULL,'CO0096',NULL,'Bhedarganj','Shariatpur','11/4/21 (275)','8 no word Koraltoli','01746211807',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:47:42','2021-07-27 17:13:45'),(1558,9,'customer',NULL,'Badal MOlla','general',0,NULL,'CO0097',NULL,NULL,NULL,'13/4/21 (276)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:50:56','2021-07-27 17:29:40'),(1559,9,'customer',NULL,'Humayun Khan','general',0,NULL,'CO0098',NULL,NULL,NULL,'13/4/21 (276)','bosser friend','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:51:34','2021-07-27 17:28:50'),(1560,9,'customer',NULL,'Mohon Dalal','general',0,NULL,'CO0099',NULL,NULL,NULL,'14/4/21 (277)','shopno lifestyle','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:52:20','2021-07-27 17:18:58'),(1561,9,'customer',NULL,'champa Apa','general',0,NULL,'CO0100',NULL,NULL,NULL,NULL,'7 no word Porosova','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:52:59','2021-06-26 20:52:59'),(1562,9,'customer',NULL,'Sohel vai (Raidar Mama)','general',0,NULL,'CO0101',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:53:34','2021-06-26 20:53:34'),(1563,9,'customer',NULL,'Samsul Hoque Dewan','general',0,NULL,'CO0102',NULL,'Bhedarganj','Shariatpur',NULL,'koral toli 9 no word','0177235561',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:54:22','2021-06-26 20:54:22'),(1564,9,'customer',NULL,'Sahnaj Begum','general',0,NULL,'CO0103',NULL,'Damgaria',NULL,'18/4/21 (280)','Shami ripon bepary, damgaria','01726343055',NULL,'01726510044',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:55:24','2021-07-27 17:31:53'),(1565,9,'customer',NULL,'Masum Molla','general',0,NULL,'CO0104',NULL,NULL,NULL,'21/4/21 (281)','bazar','01772798564',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:56:22','2021-07-27 17:37:42'),(1566,9,'customer',NULL,'Ruhul Khalu','general',0,NULL,'CO0105',NULL,NULL,NULL,'21/4/21 (281)','Badal Radio','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:57:29','2021-07-27 17:38:12'),(1567,9,'customer',NULL,'Joynal Kaka','general',0,NULL,'CO0106',NULL,NULL,NULL,'21/6/21(306)','8 no purosova','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:58:56','2021-07-27 22:46:16'),(1568,9,'customer',NULL,'Dulal Bepary','general',0,NULL,'CO0107',NULL,'Bhedarganj','Shariatpur','27/4/21 (284)','2 no word Pourosova','01723243715',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 20:59:41','2021-07-27 17:39:18'),(1569,9,'customer',NULL,'Yusuf shikder','general',0,NULL,'CO0108',NULL,'Bhedarganj','Shariatpur',NULL,'4 no word Ikor kandi','01939852807',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:00:39','2021-06-26 21:00:39'),(1570,9,'customer',NULL,'Ratna Begum','general',0,NULL,'CO0109',NULL,'Bhedarganj',NULL,NULL,'1 no word Paschim Putia','01746910554',NULL,'01755460465',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:01:40','2021-06-26 21:01:40'),(1571,9,'customer',NULL,'Najrul Islam Khan','general',0,NULL,'CO0110',NULL,'damudda','Shariatpur','28/4/21 (285)','2 no word Sidda','01784545876',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:02:34','2021-07-27 17:40:02'),(1572,9,'customer',NULL,'Farhad','general',0,NULL,'CO0111',NULL,NULL,NULL,'30/4/21 (286)','pom','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:03:09','2021-07-27 17:50:00'),(1573,9,'customer',NULL,'Sajib Rari','general',0,NULL,'CO0112',NULL,NULL,NULL,'3/5/21 (287)','Rari Kandi, Charpayatoli','01984612013',NULL,'0308307831',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:04:51','2021-07-27 17:46:51'),(1574,9,'customer',NULL,'Siddik Vai','general',0,NULL,'CO0113',NULL,NULL,NULL,'9/5/21(289)','ikorkandi','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:06:00','2021-07-27 17:53:07'),(1575,9,'customer',NULL,'Bokul Khan','general',0,NULL,'CO0114',NULL,NULL,NULL,'10/5/21 (290)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:13:42','2021-07-27 17:53:54'),(1576,9,'customer',NULL,'Md Ujjal Khondoker','general',0,NULL,'CO0115',NULL,'charpayatoli Beleayet Hossqain Sarder kandi',NULL,NULL,NULL,'017868159476',NULL,'01626948303',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:15:03','2021-06-26 21:15:03'),(1577,9,'customer',NULL,'Jalil Kaka','general',0,NULL,'CO0116',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:16:08','2021-06-26 21:16:08'),(1578,9,'customer',NULL,'Mokbul Vai','general',0,NULL,'CO0117',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:16:39','2021-06-26 21:16:39'),(1579,9,'customer',NULL,'Kalachan boyati','general',0,NULL,'CO0118',NULL,NULL,NULL,NULL,'Naraynpur 6 no word','01715070640',NULL,'0982168410',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:17:20','2021-06-26 21:17:20'),(1580,9,'customer',NULL,'Alamgir Howlader','general',0,NULL,'CO0119',NULL,NULL,NULL,NULL,'sidda boro howlader bari','01716029340',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:18:29','2021-06-26 21:18:29'),(1581,9,'customer',NULL,'Babul Molla','general',0,NULL,'CO0120',NULL,NULL,NULL,'13/5/21(292)','Ikorkandi','01712396481',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:18:58','2021-07-27 17:54:59'),(1582,9,'customer',NULL,'Abdul Goni','general',0,NULL,'CO0121',NULL,NULL,NULL,'16/5/21 (293)','kasem sweet meet bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:19:47','2021-07-27 17:55:28'),(1583,9,'customer',NULL,'Ajimullah Bepary','general',0,NULL,'CO0122',NULL,NULL,NULL,NULL,'stand fan babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:20:14','2021-06-26 21:20:14'),(1584,9,'customer',NULL,'Alam Molla','general',0,NULL,'CO0123',NULL,'Moibile babod',NULL,'16/5/21(293)','Chaygaw','01713820075',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:20:43','2021-07-27 17:56:57'),(1585,9,'customer',NULL,'Thai Saiful','general',0,NULL,'CO0124',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:21:01','2021-06-26 21:21:01'),(1586,9,'customer',NULL,'Fatema Chasma','general',0,NULL,'CO0125',NULL,NULL,NULL,'17/5/21(293)','Pichoner goli  dokan bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:21:44','2021-07-27 17:56:06'),(1587,9,'customer',NULL,'Ibrahim Boli','general',0,NULL,'CO0126',NULL,NULL,NULL,NULL,NULL,'01716580390',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:30:27','2021-06-26 21:30:27'),(1588,9,'customer',NULL,'Kalachan Sarder','general',0,NULL,'CO0127',NULL,NULL,NULL,'20/5/21(294)','Purosova office','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:30:59','2021-07-27 17:58:03'),(1589,9,'customer',NULL,'Jakia Apa','general',0,NULL,'CO0128',NULL,NULL,NULL,NULL,'Fan babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:31:20','2021-06-26 21:31:20'),(1590,9,'customer',NULL,'Kabir bepary','general',0,NULL,'CO0129',NULL,NULL,NULL,'22/5/21(295)','Mirzapur','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:31:58','2021-07-27 17:57:35'),(1591,9,'customer',NULL,'Panu Debnath','general',0,NULL,'CO0130',NULL,NULL,NULL,'23/5/21 (295)','bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:32:39','2021-07-27 17:58:36'),(1592,9,'customer',NULL,'Sahalom','general',0,NULL,'CO0131',NULL,'Putia','Bhedarganj','23/5/21 (295)','3 no word putia','01753112269',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:33:42','2021-07-27 17:59:04'),(1593,9,'customer',NULL,'Shakila Apa','general',0,NULL,'CO0132',NULL,NULL,NULL,'24/5/21 (296)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:35:12','2021-07-27 17:59:41'),(1594,9,'customer',NULL,'Mamun Sarder','general',0,NULL,'CO0133',NULL,NULL,NULL,'24/5/21(296)','6 no word Kaichkuri','01747061457',NULL,'01317518644',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:36:01','2021-07-27 18:00:22'),(1595,9,'customer',NULL,'Ibrahim Madber','general',0,NULL,'CO0134',NULL,'Nodir oipar',NULL,NULL,'9 no word charkoraltoli','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:37:06','2021-06-26 21:37:06'),(1596,9,'customer',NULL,'Ismail Khan','general',0,NULL,'CO0135',NULL,'sajonpur','Bhedarganj','shariatprur','arji pom 7 no word, Sajonpur','01733701345',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:38:19','2021-07-25 23:47:04'),(1597,9,'customer',NULL,'Sujon Howlader','general',0,NULL,'CO0136',NULL,NULL,NULL,'25/5/21(297)','Master libary pichone new store','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:51:03','2021-07-27 18:03:16'),(1598,9,'customer',NULL,'Goidda madrasha Masjid','general',0,NULL,'CO0137',NULL,NULL,NULL,'25/5/21(297)','goidda','01712820048',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:51:36','2021-07-27 18:03:47'),(1599,9,'customer',NULL,'Faruk Talukder','general',0,NULL,'CO0138',NULL,'Bhedarganj','Shariatpur','29/5/21(297)','2 no word Pourosova','01718598632',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:52:30','2021-07-27 18:06:23'),(1600,9,'customer',NULL,'Ahsan cha dokan','general',0,NULL,'CO0139',NULL,NULL,NULL,NULL,'bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:52:56','2021-06-26 21:52:56'),(1601,9,'customer',NULL,'Md Jasim bepary','general',0,NULL,'CO0140',NULL,NULL,'Shariatpur','1/6/21 (299)','Pom babul khaner dighir uttar pase, Sajonpur','01321753545',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:53:49','2021-07-27 22:33:51'),(1602,9,'customer',NULL,'Joynal Khan','general',0,NULL,'CO0141',NULL,'1/6/21 (299)',NULL,'(173) 13/6/20','5 no word Surjomoni','01873953424',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:54:52','2021-07-27 22:34:59'),(1603,9,'customer',NULL,'Md Joy Kahed','general',0,NULL,'CO0142',NULL,'damudda','Shariatpur',NULL,'sidda','01704711079',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:55:24','2021-06-26 21:55:24'),(1604,9,'customer',NULL,'Ali akber Khan','general',0,NULL,'CO0143',NULL,NULL,NULL,'1/6/21 (299)','5 no word Surjomoni','01833662395',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:56:05','2021-07-27 22:35:26'),(1605,9,'customer',NULL,'Md Iddis Dhali','general',0,NULL,'CO0144',NULL,'Bhedarganj','Shariatpur','1/6/21 (300)','8 no word islampur','01740876655',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:57:12','2021-07-27 22:37:06'),(1606,9,'customer',NULL,'Momin Ali Howlader','general',0,NULL,'CO0145',NULL,'Bhedarganj','Shariatpur','2/6/21 (300)','8 no word islampur','01754679247',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:57:51','2021-07-27 22:37:36'),(1607,9,'customer',NULL,'Rasel Dewan','general',0,NULL,'CO0146',NULL,'Nodir oipar','Bhedarganj','5/6/21(301)','5 no word Surjomoni','01313912558',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:58:44','2021-07-27 22:38:00'),(1608,9,'customer',NULL,'Mone Rekho (Sulayman Howlader)','general',0,NULL,'CO0147',NULL,'5 no word purosova',NULL,'4/6/21(301)','Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 21:59:33','2021-07-27 22:38:29'),(1609,9,'customer',NULL,'Sahid Sarder','general',0,NULL,'CO0148',NULL,'Bhedarganj','Shariatpur','6/6/21(301)','4 no word Ramvodropur','01710405945',NULL,'01751853879',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:00:19','2021-07-27 22:38:53'),(1610,9,'customer',NULL,'Mustafizur Rahman','general',0,NULL,'CO0149',NULL,'Bhedarganj','Shariatpur','7/6/21 (302)','S I bhedarganj Thana','01791191445',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:01:04','2021-07-27 22:39:17'),(1611,9,'customer',NULL,'Billal Akon','general',0,NULL,'CO0150',NULL,'DM KHALI','Sakhipur','8/6/21 (302)','Munsi kandi','01763850825','0178843206','01314827568',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:02:16','2021-07-27 22:39:46'),(1612,9,'customer',NULL,'Md Majid shikder','general',0,NULL,'CO0151',NULL,'Bhedarganj','Shariatpur','10/6/21(302)','8 no word Monua','01725114948',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:03:41','2021-07-27 22:40:42'),(1613,9,'customer',NULL,'Ismail Gazi','general',0,NULL,'CO0152',NULL,NULL,NULL,'10/6/21 (303)','Kartikpur','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:04:50','2021-07-27 22:41:24'),(1614,9,'customer',NULL,'Monowar Mridha','general',0,NULL,'CO0153',NULL,NULL,NULL,NULL,'blender babod','01749001274',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:05:29','2021-06-26 22:05:29'),(1615,9,'customer',NULL,'Md Rajon howlader','general',0,NULL,'CO0154',NULL,NULL,NULL,NULL,'Bazar kachamal bebosai','01789518559',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:06:14','2021-06-26 22:06:14'),(1616,9,'customer',NULL,'Jalil Akon','general',0,NULL,'CO0155',NULL,NULL,NULL,'12/6/21 (303)','charpayatoli 9 no word Rari kandi','01780033628',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:07:03','2021-07-27 22:41:59'),(1617,9,'customer',NULL,'Milon Howlader','general',0,NULL,'CO0156',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:07:32','2021-06-26 22:07:32'),(1618,9,'customer',NULL,'Eva Madam','general',0,NULL,'CO0157',NULL,'Bhedarganj','Shariatpur',NULL,'6 no word pourosova','01778785362',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:09:39','2021-06-26 22:09:39'),(1619,9,'customer',NULL,'Mayer Achol','general',0,NULL,'CO0158',NULL,'bazar',NULL,'13/6/21 (304)','5 no word purosova','01731552090',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:10:22','2021-07-27 22:43:13'),(1620,9,'customer',NULL,'Nasim Apa','general',0,NULL,'CO0159',NULL,NULL,NULL,NULL,'Putia','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:10:55','2021-06-26 22:10:55'),(1621,9,'customer',NULL,'Hafijur Rhaman','general',0,NULL,'CO0160',NULL,NULL,NULL,'14/6/21 (304)','boss er basar imam','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:12:13','2021-07-27 22:43:47'),(1622,9,'customer',NULL,'Akhi Akter','general',0,NULL,'CO0161',NULL,NULL,NULL,NULL,'Kanchon para','01734852904',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:12:58','2021-06-26 22:12:58'),(1623,9,'customer',NULL,'Mujahid','general',0,NULL,'CO0162',NULL,'Bazar',NULL,'17/6/21 (305)','rfl dokan','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:13:31','2021-07-27 22:45:12'),(1624,9,'customer',NULL,'Kamal Store','general',0,NULL,'CO0163',NULL,NULL,NULL,'15/6/21 (305)','bazar','01700560736',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:14:05','2021-07-27 22:44:21'),(1625,9,'customer',NULL,'Sajal Shikder','general',0,NULL,'CO0164',NULL,'National Bank',NULL,'17/6/21 (305)','Kartikpur','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:14:41','2021-07-27 22:44:46'),(1626,9,'customer',NULL,'Samsul Hoque Talukder','general',0,NULL,'CO0165',NULL,NULL,NULL,NULL,'Kanchon para','01771226187',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:15:16','2021-06-26 22:15:16'),(1627,9,'customer',NULL,'Babul khan','general',0,NULL,'CO0166',NULL,NULL,NULL,'17/6/21 (306)','Pom','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:15:45','2021-07-27 22:45:46'),(1628,9,'customer',NULL,'Shopon Akon','general',0,NULL,'CO0167',NULL,NULL,NULL,NULL,'Nazimpur','01712347225',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-26 22:16:18','2021-06-26 22:16:18'),(1629,9,'customer',NULL,'bhedargong thana','general',0,NULL,'CO0168',NULL,'bhedargonj',NULL,NULL,'THANA','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:05:53','2021-06-29 15:05:53'),(1630,9,'customer',NULL,'AL AMIN  DALAL','general',0,'admin@alampos.com','CO0169',NULL,'Bhedorgonj','Shariatpur','(58) 5/6/14','MOHISKANDI','01745331699',NULL,'0174731421',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:10:58','2021-06-30 22:46:23'),(1631,9,'customer',NULL,'ZIA KAZI','general',0,NULL,'CO0170',NULL,'Bhedarganj','Shariatpur','(67) 1/7/14','PUTIA','01781732600',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:12:54','2021-06-30 22:47:33'),(1632,9,'customer',NULL,'MOKBUL MOLLAH','general',0,'admin@alampos.com','CO0171',NULL,'Bhedarganj','dhaka','(75) 4/8/14','MIRZAPUR','01751198958',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:18:15','2021-06-30 22:48:03'),(1633,9,'customer',NULL,'Monir shikder','general',0,'admin@alampos.com','CO0172',NULL,'Bhedorgonj','Shariatpur','(82) 3/9/14','PUTIA,OZHA BARI','NO',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:21:13','2021-06-30 22:49:41'),(1634,9,'customer',NULL,'FOZLU SHORNOKAR','general',0,'admin@alampos.com','CO0173',NULL,'BHEDARJONG','Shariatpur','(84) 12-9-14','BHEDARGONG BAZAR','NO',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:23:52','2021-06-30 22:50:17'),(1635,9,'customer',NULL,'SATTAR SHEKH','general',0,'admin@alampos.com','CO0174',NULL,'Bhedarganj','Shariatpur','(91) 4/10/14','SAJONPUR MOKKA SWEETS','01724586750',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:30:49','2021-07-25 23:12:51'),(1636,9,'customer',NULL,'MALEK MEMBER','general',0,'admin@alampos.com','CO0175',NULL,'BHEDARJONG','Shariatpur','(93) 5/10/14','Sajonpur','NO',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:34:43','2021-07-25 23:13:06'),(1637,9,'customer',NULL,'SUMON SORDAR','general',0,'admin@alampos.com','CO0176',NULL,'BHEDARJONG','Shariatpur','Bangladesh','BAZAR','NO',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:41:50','2021-06-29 15:41:50'),(1638,9,'customer',NULL,'MOKBUL DOPTORI','general',0,'admin@alampos.com','CO0177',NULL,'BHEDARGONJ','Shariatpur','(53) 11/5/14','bazar','01716323610',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:43:25','2021-06-30 22:43:53'),(1639,9,'customer',NULL,'NBL MANAGER (57)','general',0,'admin@alampos.com','CO0178',NULL,'BHEDARJONG','Shariatpur','13/6/14','NBL BANK','NO',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:46:15','2021-06-30 22:45:40'),(1640,9,'customer',NULL,'BHEDARGONJ THANA(57)','general',0,'admin@alampos.com','CO0179',NULL,'BHEDARJONG','Shariatpur','Bangladesh','Bhedarganj THANA','01716591772',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:48:35','2021-06-29 15:48:35'),(1641,9,'customer',NULL,'JAMAI JAKIR(62)','general',0,'admin@alampos.com','CO0180',NULL,'BHEDARJONG','Shariatpur','29/5/14','BAZAR ELECTRIC MAKER','01916048439',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 15:52:59','2021-06-30 22:47:00'),(1642,9,'customer',NULL,'ROBIN PRINTER(93)','general',0,'admin@alampos.com','CO0181',NULL,'BHEDARJONG','Shariatpur','5/1/14','BHEDARGONJ BAZAR','01716591772',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:01:54','2021-06-30 22:52:28'),(1643,9,'customer',NULL,'SAMSUL HAQUE RARI(94)','general',0,NULL,'01715620282',NULL,'BHEDARGONJ','Shariatpur','6/10/14','FERANGI KANDI','01715620282',NULL,'01715620282',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:09:07','2021-06-30 22:53:02'),(1644,9,'customer',NULL,'ABUL HoWLADAR(94)','general',0,NULL,'CO0183',NULL,'BHEDARGONJ','Shariatpur','11/10/14','Bhedarganj BAZAR','NO',NULL,'NO',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:10:33','2021-06-30 22:53:50'),(1645,9,'customer',NULL,'ALI AKKAS(97)','general',0,NULL,'CO0184',NULL,'BHEDARGONJ','Shariatpur','29/10/14','5 no word BHEDAEJONG','01723339179',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:14:06','2021-06-30 22:54:25'),(1646,9,'customer',NULL,'SALAM','general',0,NULL,'CO0185',NULL,'BHEDARGONJ','Shariatpur','(105) 29/11/14','UNKNOWN','01717606036',NULL,'01717606036',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:15:57','2021-06-30 22:57:05'),(1647,9,'customer',NULL,'BIMOL SORNOKAR','general',0,NULL,'CO0186',NULL,'BHEDARGONJ','Shariatpur','(107) 9/12/14','Bhedarganj BAZAR','NILL',NULL,'NILL',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:17:23','2021-06-30 22:57:26'),(1648,9,'customer',NULL,'DELWAR UPOJILA','general',0,NULL,'CO0187',NULL,'BHEDARGONJ','Shariatpur','(108) 14/12/14','BHEDARGONJ UPOJILA','NILL',NULL,'NILL',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:19:05','2021-06-30 22:57:51'),(1649,9,'customer',NULL,'SELIM (109)','general',0,NULL,'CO0188',NULL,'SHAKHIPUR','Shariatpur','14/12/14','SAKHIPUR','01715194277',NULL,'01715194277',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:22:54','2021-06-30 22:58:11'),(1650,9,'customer',NULL,'Jahangir Dhali','general',0,NULL,'CO0189',NULL,'BHEDARGONJ','Shariatpur','(111) 24/12/14','PAPRAIL  WALTON','01715590545',NULL,'01715590545',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:25:11','2021-06-30 22:59:12'),(1651,9,'customer',NULL,'JOYNAL ABEDIN(115)','general',0,NULL,'CO0190',NULL,'BHEDARGONJ','Shariatpur','(115) 6/1/15','MISTIR DOKAN','01727070321',NULL,'01727070321',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:29:15','2021-06-30 22:59:42'),(1652,9,'customer',NULL,'OALIULLAH KHAN(135)','general',0,NULL,'CO0191',NULL,'BHEDARGONJ','Shariatpur','(135) 25/3/15','bazar','NILL',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:36:29','2021-06-30 23:02:16'),(1653,9,'customer',NULL,'KAJOL ER AMMU','general',0,NULL,'CO0192',NULL,'BHEDARGONJ','Shariatpur','(135) 29/3/15','NILL','NILL',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:38:38','2021-06-30 23:02:43'),(1654,9,'customer',NULL,'ASIF KHAN','general',0,NULL,'CO0193',NULL,'BHEDARGONJ',NULL,'(136) 4/4/15',NULL,'01778112731',NULL,'000',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:39:24','2021-06-30 23:03:08'),(1655,9,'customer',NULL,'JAHANGIR','general',0,NULL,'CO0194',NULL,NULL,'bazar fol bebsai','(137) 9/4/15',NULL,'NILL',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:42:23','2021-06-30 23:03:56'),(1656,9,'customer',NULL,'SULAIMAN','general',0,NULL,'CO0195',NULL,'BHEDARGONJ','Shariatpur','(138) 12/4/15','MOKKA SWEETS','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:53:13','2021-06-30 23:04:53'),(1657,9,'customer',NULL,'NAYEM  MASTER','general',0,NULL,'CO0196',NULL,'BHEDARGONJ','Shariatpur','(138) 13/4/15',NULL,'000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:54:47','2021-06-30 23:05:30'),(1658,9,'customer',NULL,'SUJON MEKAR','general',0,NULL,'CO0197',NULL,'BHEDARGONJ','Shariatpur','(139) 18/4/15','BAZAR','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:55:56','2021-06-30 23:05:57'),(1659,9,'customer',NULL,'SUJON KOMOLA BUAr chele','general',0,NULL,'CO0198',NULL,'BHEDARGONJ','Shariatpur','(140) 21/4/15','NILL','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 16:57:42','2021-06-30 23:06:31'),(1660,9,'customer',NULL,'IBRAHIM DOKAN','general',0,NULL,'CO0199',NULL,'BHEDARGONJ','Shariatpur','(143) 26/4/15',NULL,'000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:02:29','2021-06-30 23:07:05'),(1661,9,'customer',NULL,'IKBAL MOLLIK','general',0,NULL,'CO0200',NULL,'BHEDARGONJ','Shariatpur','Bangladesh','NIL','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:03:16','2021-06-29 17:03:16'),(1662,9,'customer',NULL,'FATEMA','general',0,NULL,'CO0201',NULL,'BHEDARGONJ','S','(150) 27/5/15',NULL,'000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:05:37','2021-06-30 23:08:51'),(1663,9,'customer',NULL,'LUTFOR VUIYA','general',0,NULL,'CO0202',NULL,'BHEDARGONJ','S','(150) 25/5/15',NULL,'01716251282',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:07:02','2021-06-30 23:09:13'),(1664,9,'customer',NULL,'HASINA BEGUM','general',0,NULL,'CO0203',NULL,'BHEDARGONJ','S','(152) 3/6/15','ALI AHMED HUSBAND','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:09:33','2021-06-30 23:09:40'),(1665,9,'customer',NULL,'SEKANDER HAWLADAR','general',0,NULL,'CO0204',NULL,'BHEDARGONJ','S','(156) 18/6/15','NILL','00',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:10:57','2021-06-30 23:10:20'),(1666,9,'customer',NULL,'Yeasin Khan','general',0,NULL,'CO0205',NULL,'BHEDARGONJ','S','(156) 18/6/15',NULL,'01727794840',NULL,'01727794840',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:11:54','2021-06-30 23:11:33'),(1667,9,'customer',NULL,'RAJON CHONDRO DAS (159)','general',0,NULL,'CO0206',NULL,'BHEDARGONJ','S','(159) 28/6/15','SUMON VHI MARFOT','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:13:50','2021-06-30 23:12:13'),(1668,9,'customer',NULL,'ASIF(159)','general',0,NULL,'CO0207',NULL,'BHEDARGONJ','Shariatpur','29/6/15','IBRAHIM MARFOT','00',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:14:59','2021-06-30 23:13:08'),(1669,9,'customer',NULL,'SAMSU RONG MISTRI','general',0,NULL,'CO0208',NULL,'BHEDARGONJ','Shariatpur','(160) 30/6/15',NULL,'000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:16:41','2021-06-30 23:13:45'),(1670,9,'customer',NULL,'RAJON HAWLADAR','general',0,NULL,'CO0209',NULL,'BHEDARGONJ','bazar','(164) 12/7/15',NULL,'00',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:17:26','2021-06-30 23:14:29'),(1671,9,'customer',NULL,'KALU SORDAR','general',0,NULL,'CO0210',NULL,'BHEDARGONJ','Shariatpur','(165) 15/7/15',NULL,'01724897265',NULL,'01724897265',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:18:56','2021-06-30 23:14:56'),(1672,9,'customer',NULL,'ARIF  HAWLADAR','general',0,NULL,'CO0211',NULL,'BHEDARGONJ','Shariatpur','(165) 17/7/15',NULL,'000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:20:12','2021-06-30 23:15:26'),(1673,9,'customer',NULL,'HASAN HAWLADAR','general',0,NULL,'CO0212',NULL,'BHEDARGONJ','Shariatpur','(167) 23/7/15','Sajonpur','01796506457',NULL,'01819188334',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:22:03','2021-07-25 23:13:21'),(1674,9,'customer',NULL,'SHUVO HONDAR MISTRI','general',0,NULL,'CO0213',NULL,'BHEDARGONJ','Shariatpur','(168) 25/7/15','NILL','0000',NULL,'000',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:23:44','2021-06-30 23:16:32'),(1675,9,'customer',NULL,'BILLAL HAWLADAR','general',0,NULL,'CO0214',NULL,'BHEDARGONJ','S','(172)( 8/8/15','BACCHU HOTEL','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:25:20','2021-06-30 23:16:58'),(1676,9,'customer',NULL,'SHAHJAHAN BEPARI','general',0,NULL,'CO0215',NULL,'BHEDARGONJ','Shariatpur','(175) 13/8/15',NULL,'01780127518',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:26:33','2021-06-30 23:17:41'),(1677,9,'customer',NULL,'KHALEd DALAL','general',0,NULL,'CO0216',NULL,'BHEDARGONJ','Shariatpur','(177) 23/8/15','MAKER','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:29:01','2021-06-30 23:18:28'),(1678,9,'customer',NULL,'ABUL BASHAR KAZI','general',0,NULL,'CO0217',NULL,'BHEDARGONJ','Shariatpur','(186) 7/9/15','Gulmaij','000',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 17:29:45','2021-07-24 23:38:07'),(1679,9,'customer',NULL,'Amit Sumon','general',0,NULL,'CO0218',NULL,NULL,NULL,'14/9-15 (188)','Fan babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:12:12','2021-07-24 23:39:08'),(1680,9,'customer',NULL,'Van Jalal','general',0,NULL,'CO0219',NULL,NULL,NULL,'12-9-15 (188)','Fan babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:12:37','2021-07-24 23:39:36'),(1681,9,'customer',NULL,'Jakir Paik','general',0,NULL,'CO0220',NULL,NULL,NULL,'22-9-15 (193)','Bazar laber','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:15:51','2021-07-24 23:41:04'),(1682,9,'customer',NULL,'Loskor Motors','general',0,NULL,'CO0221',NULL,'sokhipur',NULL,'22-9-15 (193)','sakhipur','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:16:15','2021-07-24 23:40:39'),(1683,9,'customer',NULL,'Mafijul Hoque (196)','general',0,NULL,'CO0222',NULL,NULL,NULL,'24-9-15','Nuru nan marfot','01852802302',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:18:48','2021-07-24 23:42:10'),(1684,9,'customer',NULL,'Babul Komisoner','general',0,NULL,'CO0223',NULL,NULL,NULL,NULL,'7 no word Porosova','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:19:22','2021-06-29 22:19:22'),(1685,9,'customer',NULL,'Engr Shikder','general',0,NULL,'CO0224',NULL,NULL,NULL,'14/11/15 (210)','Kartikpur','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:20:19','2021-07-24 23:43:20'),(1686,9,'customer',NULL,'Arif Reza','general',0,NULL,'CO0225',NULL,NULL,NULL,'14/11/15 (210)','master libary','01724282847',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:22:02','2021-07-24 23:42:49'),(1687,9,'customer',NULL,'Jahangir Howlader','general',0,NULL,'CO0226',NULL,'BHEDARGONJ','Shariatpur','26/11/15 (212)','singjala','01710323592',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:23:07','2021-07-24 23:45:16'),(1688,9,'customer',NULL,'Najrul Islam benai','general',0,NULL,'CO0227',NULL,'BHEDARGONJ','Shariatpur','1/12/15 (213)','Bazar mach bebosai','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:24:06','2021-07-24 23:45:44'),(1689,9,'customer',NULL,'Din islam','general',0,NULL,'CO0228',NULL,'SHARIATPUR',NULL,'Bangladesh','5 no word BHEDAEJONG','01950863307',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:25:01','2021-06-29 22:25:01'),(1690,9,'customer',NULL,'Monir','general',0,NULL,'CO0229',NULL,'BHEDARGONJ','Shariatpur','31/12/15 (224)','Chokder somiler lok','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:27:04','2021-07-24 23:47:06'),(1691,9,'customer',NULL,'Halim Bepary','general',0,NULL,'CO0230',NULL,NULL,NULL,'12/1/16 (229)','chular set babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:27:42','2021-07-24 23:47:38'),(1692,9,'customer',NULL,'Alam chan Ukil (','general',0,NULL,'CO0231',NULL,'BHEDARGONJ','Shariatpur','278','Pourosova office','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:28:31','2021-07-28 22:34:21'),(1693,9,'customer',NULL,'Modhu Ghosh','general',0,NULL,'CO0232',NULL,NULL,NULL,'1/2/16 (236)','BAZAR','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:29:07','2021-07-24 23:51:51'),(1694,9,'customer',NULL,'Abul Madber','general',0,NULL,'CO0233',NULL,'total : 27400',NULL,'19/2/16 (241)','null','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:29:58','2021-07-28 22:43:18'),(1695,9,'customer',NULL,'Hena apa','general',0,NULL,'CO0234',NULL,'BHEDARGONJ','Shariatpur','Bangladesh','Ikorkandi','01930119887',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:31:04','2021-06-29 22:31:04'),(1696,9,'customer',NULL,'Masum','general',0,NULL,'CO0235',NULL,'naria','Shariatpur','12/4/16 (247)','dinara','01710130750',NULL,'01728106252',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:31:56','2021-07-24 23:56:49'),(1697,9,'customer',NULL,'Sujon Mondol','general',0,NULL,'CO0236',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:32:19','2021-06-29 22:32:19'),(1698,9,'customer',NULL,'Sheikh Sahalom','general',0,NULL,'CO0237',NULL,NULL,NULL,'24/3/16 (251)','Chaygaw','01710399426',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:33:43','2021-07-24 23:57:25'),(1699,9,'customer',NULL,'Sujon cha','general',0,NULL,'CO0238',NULL,NULL,NULL,'27/3/16 (253)','bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:34:21','2021-07-24 23:58:02'),(1700,9,'customer',NULL,'Jalil Iqbal','general',0,NULL,'CO0239',NULL,NULL,NULL,'3/4/16 (254)','Mallik er honda driver','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:35:05','2021-07-24 23:58:28'),(1701,9,'customer',NULL,'Abu Kalam','general',0,NULL,'CO0240',NULL,'Sumon vai marfot',NULL,NULL,'Choygaw','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:36:02','2021-06-29 22:36:02'),(1702,9,'customer',NULL,'Dr Suvash','general',0,NULL,'CO0241',NULL,NULL,NULL,'18/4/16 (256)','SUMON VHI MARFOT','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:38:51','2021-07-25 14:14:36'),(1703,9,'customer',NULL,'Md Samim','general',0,NULL,'CO0242',NULL,NULL,NULL,'18/4/16 (260)','SAKHIPUR','01740945286',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:39:22','2021-07-25 14:15:16'),(1704,9,'customer',NULL,'Naju Munsi','general',0,NULL,'CO0243',NULL,NULL,NULL,'20/4/16 (261)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:40:24','2021-07-25 14:15:49'),(1705,9,'customer',NULL,'Masud Chokider','general',0,NULL,'CO0244',NULL,'BHEDARGONJ',NULL,'22/4/16 (262)','Choygaw madrashar uttar pase','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:41:14','2021-07-25 14:17:41'),(1706,9,'customer',NULL,'Mohila Madrasah','general',0,NULL,'CO0245',NULL,NULL,NULL,'23/4/16 (263)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:42:01','2021-07-25 14:18:01'),(1707,9,'customer',NULL,'Mijan','general',0,NULL,'CO0246',NULL,NULL,NULL,'25/4/16 (264)','bazar Kapor potti','01938956275',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:43:20','2021-07-25 14:18:44'),(1708,9,'customer',NULL,'Masud Khan','general',0,NULL,'CO0247',NULL,'damudda','Shariatpur','11/5/16 (271)','Moddho sidda','01739890132',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:44:13','2021-07-25 14:19:24'),(1709,9,'customer',NULL,'Ujjal Khan','general',0,NULL,'CO0248',NULL,NULL,NULL,NULL,'Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:44:55','2021-06-29 22:44:55'),(1710,9,'customer',NULL,'Mokhles Baurchi','general',0,NULL,'CO0249',NULL,NULL,NULL,'20/5/16 (275)','Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:45:29','2021-07-25 14:19:48'),(1711,9,'customer',NULL,'Billal Hossain','general',0,NULL,'CO0250',NULL,NULL,NULL,'24/1/16 ( 277)','Ujjal er bon jamai','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:45:57','2021-07-25 14:44:38'),(1712,9,'customer',NULL,'Billal Molla','general',0,NULL,'CO0251',NULL,NULL,NULL,'6/6/16 (286)','Monua fan babod','01929801354',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:47:19','2021-07-25 14:53:53'),(1713,9,'customer',NULL,'Arif Vuia','general',0,NULL,'CO0252',NULL,NULL,NULL,'19/6/16 (290)','pom fan babod','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:48:08','2021-07-25 14:54:22'),(1714,9,'customer',NULL,'Maksuda','general',0,NULL,'CO0253',NULL,NULL,NULL,'21/6/16 (291)','bhedarganj Hospital','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:48:34','2021-07-25 14:54:49'),(1715,9,'customer',NULL,'Nitai Dash','general',0,NULL,'CO0254',NULL,NULL,NULL,'22/6/16/ (292)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:48:55','2021-07-25 14:55:18'),(1716,9,'customer',NULL,'Shukkur Howlader','general',0,NULL,'CO0255',NULL,NULL,NULL,NULL,'dibena','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:49:38','2021-06-29 22:49:38'),(1717,9,'customer',NULL,'Selim molla','general',0,NULL,'CO0256',NULL,NULL,NULL,'6/7/16 (298)','dibena','017147800827',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:50:04','2021-07-25 14:56:32'),(1718,9,'customer',NULL,'Noyon Sharif sarder','general',0,NULL,'CO0257',NULL,NULL,NULL,'17/4/17 (306)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:50:51','2021-07-25 14:57:28'),(1719,9,'customer',NULL,'Bokul Honda maker','general',0,NULL,'CO0258',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:51:20','2021-06-29 22:51:20'),(1720,9,'customer',NULL,'Babul Howlader','general',0,NULL,'CO0259',NULL,NULL,NULL,'11/8/16 (310)','master libary','01828680328',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:53:21','2021-07-25 14:57:57'),(1721,9,'customer',NULL,'Dulal Medical','general',0,NULL,'CO0260',NULL,NULL,NULL,NULL,'bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:54:02','2021-06-29 22:54:02'),(1722,9,'customer',NULL,'Imaran','general',0,NULL,'CO0261',NULL,NULL,NULL,NULL,'Bazar Mobile maker','01753828444',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:54:34','2021-06-29 22:54:34'),(1723,9,'customer',NULL,'Rehana','general',0,NULL,'CO0262',NULL,NULL,NULL,'20/8/16 (314)','MIthai kawsar marfot','nill',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:55:10','2021-07-25 14:59:48'),(1724,9,'customer',NULL,'Ujjal Bepary','general',0,NULL,'CO0263',NULL,NULL,NULL,'21/8/16 (314)','damgaria, chaygaw','01770251576',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:55:57','2021-07-26 20:55:01'),(1725,9,'customer',NULL,'Md Sahin bepary','general',0,NULL,'CO0264',NULL,NULL,NULL,'29/8/16 (316)','Sanjid Sari bitan Bazar','01738875826',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:56:46','2021-07-25 15:00:56'),(1726,9,'customer',NULL,'Milon Dalal','general',0,NULL,'CO0265',NULL,NULL,NULL,'29/8/16 (316)','mara gese','01714839208',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:57:20','2021-07-25 15:01:25'),(1727,9,'customer',NULL,'Anowar Hossain Sarder','general',0,NULL,'CO0266',NULL,NULL,NULL,'6/11/16 (318)','Ramvodropur','01777040304',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:58:09','2021-07-25 15:01:54'),(1728,9,'customer',NULL,'Golam Mostofa','general',0,NULL,'CO0267',NULL,'BHEDARGONJ',NULL,'11/9/16(321)','Kanchon para','01729705052',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 22:59:01','2021-07-25 15:02:21'),(1729,9,'customer',NULL,'Humayun Kabir','general',0,NULL,'CO0268',NULL,'dibena',NULL,'11/9/16 (321)','Dakkhin Mohishar','01768436545',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:00:06','2021-07-25 15:02:47'),(1730,9,'customer',NULL,'Majeda','general',0,NULL,'CO0269',NULL,NULL,NULL,'11/9/16 (322)','Bhedarganj THANA stap','01712125926',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:00:42','2021-07-25 15:03:31'),(1731,9,'customer',NULL,'Kalu Mithai','general',0,NULL,'CO0270',NULL,NULL,NULL,NULL,'dibena','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:01:20','2021-06-29 23:01:20'),(1732,9,'customer',NULL,'Rafiqul Islam Majhi','general',0,NULL,'CO0271',NULL,NULL,NULL,'14/9/16 (324)','Kartikpur','01717114559',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:01:49','2021-07-25 15:04:01'),(1733,9,'customer',NULL,'Jalil Bepary','general',0,NULL,'CO0272',NULL,NULL,NULL,'17/9/16(326)','Bazar kachamal bebosai','ull',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:02:16','2021-07-25 15:16:57'),(1734,9,'customer',NULL,'Din islam (337)','general',0,NULL,'CO0273',NULL,NULL,NULL,'21/10/16 (337)','Italy plazza bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:03:20','2021-07-25 15:28:36'),(1735,9,'customer',NULL,'Faruk Farmesi','general',0,NULL,'CO0274',NULL,NULL,NULL,'6/11/16 (343)','Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:04:01','2021-07-25 16:52:28'),(1736,9,'customer',NULL,'Sumon Howlader','general',0,NULL,'CO0275',NULL,NULL,NULL,'23/11/16 (345)','singjala','01987376544',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:04:34','2021-07-25 16:53:11'),(1737,9,'customer',NULL,'BRDB Najmul','general',0,NULL,'CO0276',NULL,NULL,NULL,'25/12/16 (351)',NULL,'0',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:05:09','2021-07-25 16:53:59'),(1738,9,'customer',NULL,'Sahin Khan','general',0,NULL,'CO0277',NULL,NULL,NULL,'12/3/17 (368)','Abul Madber marfot','01721454129',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:06:57','2021-07-25 16:56:26'),(1739,9,'customer',NULL,'Ratan Howlader','general',0,NULL,'CO0278',NULL,NULL,NULL,'26/3/17 (372)','Joyanal kakar chele','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:07:31','2021-07-25 16:56:57'),(1740,9,'customer',NULL,'Md Hanif Sarder','general',0,NULL,'CO0279',NULL,NULL,NULL,'6/4/17 (375)','Pom','nnn',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:08:02','2021-07-25 16:57:32'),(1741,9,'customer',NULL,'Delowar Majhi','general',0,NULL,'CO0280',NULL,NULL,NULL,'29/4/17 (384)','Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:08:48','2021-07-25 16:58:06'),(1742,9,'customer',NULL,'Romel','general',0,NULL,'CO0281',NULL,NULL,NULL,NULL,NULL,'017111',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:09:19','2021-06-29 23:09:19'),(1743,9,'customer',NULL,'Romel','general',0,NULL,'CO0282',NULL,NULL,NULL,'35/17/ (385)','Harun rarir bagina','01711131551',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:09:48','2021-07-25 16:58:49'),(1744,9,'customer',NULL,'Sonchoy','general',0,NULL,'CO0283',NULL,NULL,NULL,'6/5/17 (387)','SUMON VHI MARFOT','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:10:17','2021-07-25 16:59:30'),(1745,9,'customer',NULL,'Nuru chokder','general',0,NULL,'CO0284',NULL,NULL,NULL,'1/2/20 (389)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:10:52','2021-07-25 17:00:13'),(1746,9,'customer',NULL,'Kabita bepary','general',0,NULL,'CO0285',NULL,NULL,NULL,NULL,NULL,'dfdf',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:12:13','2021-06-29 23:12:13'),(1747,9,'customer',NULL,'Sohel Sarder','general',0,NULL,'CO0286',NULL,NULL,NULL,'26/5/17 (397)','BAZAR','66',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-29 23:12:37','2021-07-25 17:03:50'),(1748,9,'customer',NULL,'Kamal','general',0,NULL,'CO0287',NULL,NULL,NULL,'(144) 25/1/20',NULL,'01834932348',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 16:35:14','2021-06-30 16:35:14'),(1749,9,'customer',NULL,'Nurul Hoque','general',0,NULL,'CO0288',NULL,'Surjo dighol',NULL,'(151) 24/2/21','9 no word','01726058374',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 16:36:40','2021-06-30 16:37:13'),(1750,9,'customer',NULL,'Selim Vuia','general',0,NULL,'CO0289',NULL,NULL,NULL,'171) 15/6/20',NULL,'01754734814',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 16:42:04','2021-06-30 16:42:04'),(1751,9,'customer',NULL,'Jalil Shikder','general',0,NULL,'CO0290',NULL,NULL,NULL,'(246) 25/1/21',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 17:01:39','2021-06-30 17:01:39'),(1752,9,'customer',NULL,'Sumon Sarder','general',0,NULL,'CO0291',NULL,NULL,NULL,'(53) 11/5/14','Bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 22:44:43','2021-06-30 22:44:43'),(1753,9,'customer',NULL,'Ismail Sarder','general',0,NULL,'CO0292',NULL,NULL,NULL,'(97) 19/10/14',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 22:55:26','2021-06-30 22:55:26'),(1754,9,'customer',NULL,'Aviram Dash','general',0,NULL,'CO0293',NULL,NULL,NULL,'101 (16/11/14)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 22:56:29','2021-06-30 22:56:29'),(1755,9,'customer',NULL,'Vangari Sumon','general',0,NULL,'CO0294',NULL,NULL,NULL,'(125) 22/2/15',NULL,'nn',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 23:00:38','2021-06-30 23:00:38'),(1756,9,'customer',NULL,'Delowar Rari','general',0,NULL,'CO0295',NULL,NULL,NULL,'(132) 27/3/15',NULL,'00',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 23:01:36','2021-06-30 23:01:36'),(1757,9,'customer',NULL,'Iqbal Mallik','general',0,NULL,'CO0296',NULL,NULL,NULL,'(146) 10/5/15','Bazar dbena','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-06-30 23:08:22','2021-06-30 23:08:22'),(1758,9,'customer',NULL,'Safi Madber','general',0,NULL,'CO0297',NULL,NULL,NULL,'22/1/16 (234)','bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-24 23:51:11','2021-07-24 23:51:11'),(1759,9,'customer',NULL,'Imran Mobile maker','general',0,NULL,'CO0298',NULL,NULL,NULL,'15/8/16 (312)',NULL,'01753828444',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 14:58:58','2021-07-25 14:58:58'),(1760,9,'customer',NULL,'Iqbal','general',0,NULL,'CO0299',NULL,'Upojel dokan',NULL,'17/2/17 (361)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 16:55:39','2021-07-25 16:55:39'),(1761,9,'customer',NULL,'Alauddin Uno Office','general',0,NULL,'CO0300',NULL,NULL,NULL,'4/6/17 (403)',NULL,'n0',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 17:35:02','2021-07-25 17:35:02'),(1762,9,'customer',NULL,'Rakib Howlader','general',0,NULL,'CO0301',NULL,NULL,NULL,'9/6/17 (405)',NULL,'01715512227',NULL,'01716879660',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 17:35:48','2021-07-25 17:35:48'),(1763,9,'customer',NULL,'Sumon Vangari','general',0,NULL,'CO0302',NULL,NULL,NULL,'19/6/17(409)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 17:36:36','2021-07-25 17:36:36'),(1764,9,'customer',NULL,'Najim','general',0,NULL,'CO0303',NULL,NULL,NULL,'24/6/17 (412)','Roji apar driver','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:29:38','2021-07-25 19:29:38'),(1765,9,'customer',NULL,'Nipa','general',0,NULL,'CO0304',NULL,NULL,NULL,'4/7/17 (416)','2 no word','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:30:47','2021-07-25 19:30:47'),(1766,9,'customer',NULL,'Md Alam','general',0,NULL,'CO0305',NULL,NULL,NULL,'8/7/17 (416)','Papriail','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:32:30','2021-07-25 19:32:30'),(1767,9,'customer',NULL,'Chan Mia','general',0,NULL,'CO0306',NULL,NULL,NULL,'20/7/17 (419)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:33:51','2021-07-25 19:33:51'),(1768,9,'customer',NULL,'Master Libery','general',0,NULL,'CO0307',NULL,NULL,NULL,'23/7/17 (420)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:34:48','2021-07-25 19:34:48'),(1769,9,'customer',NULL,'Thana Saiful','general',0,NULL,'CO0308',NULL,NULL,NULL,'18/8/17 (424)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:37:22','2021-07-25 19:37:22'),(1770,9,'customer',NULL,'Fajlul Hoque Soyal','general',0,NULL,'CO0309',NULL,'Dibena',NULL,'27/8/17 (428)',NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:38:25','2021-07-25 19:38:25'),(1771,9,'customer',NULL,'Julhas Soyal','general',0,NULL,'CO0310',NULL,'Gulmaij',NULL,'30/8/17 (430)',NULL,'01878102714',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 19:39:36','2021-07-25 19:39:36'),(1772,9,'customer',NULL,'Masud Howlader','general',0,NULL,'CO0311',NULL,'Bazar torkari arot',NULL,'3/7/17 )434)',NULL,'01717606037',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 20:57:21','2021-07-25 20:57:21'),(1773,9,'customer',NULL,'Babul Fakir','general',0,NULL,'CO0312',NULL,NULL,NULL,'3/10/17 (443)','Honda maker','01732889167',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 20:58:19','2021-07-25 20:58:19'),(1774,9,'customer',NULL,'Nupur','general',0,NULL,'CO0313',NULL,NULL,'Fol babucci fufu','18/11/17 (456)',NULL,'01740173922',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 20:59:26','2021-07-25 20:59:26'),(1775,9,'customer',NULL,'Selim Master','general',0,NULL,'CO0314',NULL,NULL,NULL,'4/1/18 (466)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:00:29','2021-07-25 21:00:29'),(1776,9,'customer',NULL,'Inu Topader','general',0,NULL,'CO0315',NULL,NULL,NULL,'4/1/18 (467)','Sajonpur','01861979190',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:01:12','2021-07-25 21:01:12'),(1777,9,'customer',NULL,'Robin Soyal','general',0,NULL,'CO0316',NULL,NULL,NULL,'26/1/18 (474)','Mohisar 2 No word','01777542670',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:03:11','2021-07-25 21:03:11'),(1778,9,'customer',NULL,'Ripon Workshop','general',0,NULL,'CO0317',NULL,NULL,NULL,'1/2/18 (475)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:04:12','2021-07-25 21:04:12'),(1779,9,'customer',NULL,'Nevy Sahin','general',0,NULL,'CO0318',NULL,NULL,NULL,'4/2/18 (476)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:04:51','2021-07-25 21:04:51'),(1780,9,'customer',NULL,'Khorsed','general',0,NULL,'CO0319',NULL,'bazar',NULL,'4/3/18 (487)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:05:53','2021-07-25 21:05:53'),(1781,9,'customer',NULL,'Sentu Bepary','general',0,NULL,'CO0320',NULL,NULL,NULL,'7/3/18 (488)','MOnua','01799883460',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:06:27','2021-07-25 21:06:27'),(1782,9,'customer',NULL,'Roji Apa','general',0,NULL,'CO0321',NULL,NULL,NULL,'31/3/18 (499)','nokia set','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:07:30','2021-07-25 21:07:30'),(1783,9,'customer',NULL,'Razzak','general',0,NULL,'CO0322',NULL,NULL,NULL,'1/4/18 (500)','bacchul hotel kormocari','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:08:25','2021-07-25 21:08:25'),(1784,9,'customer',NULL,'Anowar','general',0,NULL,'CO0323',NULL,NULL,NULL,'9/4/18 (503)','Bazar mudi dokan','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:09:32','2021-07-25 21:09:32'),(1785,9,'customer',NULL,'Arif Howlader','general',0,NULL,'CO0324',NULL,NULL,NULL,'10/4/18 (503)','Sajonpur','01912077197',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:10:16','2021-07-25 21:10:16'),(1786,9,'customer',NULL,'Md Ali','general',0,NULL,'CO0325',NULL,NULL,NULL,'13/4/18 (504)','bazar cha dokan','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:10:50','2021-07-25 21:10:50'),(1787,9,'customer',NULL,'Akkas cha dokan','general',0,NULL,'CO0326',NULL,NULL,NULL,'16/4/18 (505)','bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:11:59','2021-07-25 21:11:59'),(1788,9,'customer',NULL,'Sumon','general',0,NULL,'CO0327',NULL,NULL,NULL,'10/5/18 (512)','Bazar kachamal bebosai','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:12:42','2021-07-25 21:12:42'),(1789,9,'customer',NULL,'Hosen Morol','general',0,NULL,'CO0328',NULL,NULL,NULL,'26/5/18 (520)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:13:32','2021-07-25 21:13:32'),(1790,9,'customer',NULL,'Akkas','general',0,NULL,'CO0329',NULL,NULL,NULL,'10/6/18 (525)','goni talukder manager','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:14:14','2021-07-25 21:14:14'),(1791,9,'customer',NULL,'Jakir Amin','general',0,NULL,'CO0330',NULL,NULL,NULL,'11/6/18 (526)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:14:41','2021-07-25 21:14:41'),(1792,9,'customer',NULL,'Sumon Soyal','general',0,NULL,'CO0331',NULL,NULL,NULL,'12/6/18 (526)','Ramvodropur','01705008990',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:15:16','2021-07-25 21:15:16'),(1793,9,'customer',NULL,'Hafij','general',0,NULL,'CO0332',NULL,NULL,NULL,'15/6/18 (528)','bazar kola potti','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:16:09','2021-07-25 21:16:09'),(1794,9,'customer',NULL,'Sayem Khan','general',0,NULL,'CO0333',NULL,NULL,NULL,'15/6/18 (528) (478)','null','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:16:52','2021-07-28 22:40:28'),(1795,9,'customer',NULL,'Altaf Madber','general',0,NULL,'CO0334',NULL,NULL,NULL,'15/6/18 (528)','FERANGI KANDI','01728558377',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:17:32','2021-07-25 21:17:32'),(1796,9,'customer',NULL,'Al amin','general',0,NULL,'CO0335',NULL,NULL,NULL,'26/6/18 (531)','2 no word','0193801466',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:18:29','2021-07-25 21:18:29'),(1797,9,'customer',NULL,'Hossain Sarder','general',0,NULL,'CO0336',NULL,NULL,NULL,'27/6/18 (532)','Choygaw','01718799100',NULL,'01911555325',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:19:30','2021-07-25 21:19:30'),(1798,9,'customer',NULL,'Najmul','general',0,NULL,'CO0337',NULL,NULL,NULL,'10/7/18 (535)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:20:09','2021-07-25 21:20:09'),(1799,9,'customer',NULL,'Rakib Electric maker','general',0,NULL,'CO0338',NULL,NULL,NULL,'12/7/18 (536)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:20:46','2021-07-25 21:20:46'),(1800,9,'customer',NULL,'Payel Shikder','general',0,NULL,'CO0339',NULL,NULL,NULL,'14/7/18 (537)',NULL,'01904384219',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:23:50','2021-07-25 21:23:50'),(1801,9,'customer',NULL,'Moju Studio','general',0,NULL,'CO0340',NULL,NULL,NULL,'19/7/18(540)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:24:35','2021-07-25 21:24:35'),(1802,9,'customer',NULL,'Miraj Moti buar natin','general',0,NULL,'CO0341',NULL,NULL,NULL,'9/8/18 (548)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:25:45','2021-07-25 21:25:45'),(1803,9,'customer',NULL,'Chan mia Sarder','general',0,NULL,'CO0342',NULL,NULL,NULL,'11/8/18 (550)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:26:39','2021-07-25 21:26:39'),(1804,9,'customer',NULL,'Shikder Alamgir','general',0,NULL,'CO0343',NULL,NULL,NULL,'13/8/18(552)','Ramvodropur','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:27:20','2021-07-25 21:27:20'),(1805,9,'customer',NULL,'Jane Alam Shikder','general',0,NULL,'CO0344',NULL,NULL,NULL,'15/8/18 (554)','7 no word','01750562048',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:56:11','2021-07-25 21:56:11'),(1806,9,'customer',NULL,'Jubayer','general',0,NULL,'CO0345',NULL,NULL,NULL,'16/8/18 (554)','BAZAR DBBL','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:57:06','2021-07-25 21:57:06'),(1807,9,'customer',NULL,'Moyanl Howlader','general',0,NULL,'CO0346',NULL,NULL,NULL,'15/8/18 (554)','8 no purosova','01740741785',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:57:46','2021-07-25 21:57:46'),(1808,9,'customer',NULL,'Delowar Majhi','general',0,NULL,'CO0347',NULL,NULL,NULL,'20/8/18 (558)','Bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:58:42','2021-07-25 21:58:42'),(1809,9,'customer',NULL,'Alamgir Howlader','general',0,NULL,'CO0348',NULL,NULL,NULL,'19/8/18 (557)','singjala','01944745963',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 21:59:34','2021-07-25 21:59:34'),(1810,9,'customer',NULL,'Rahmat Ullah','general',0,NULL,'CO0349',NULL,NULL,NULL,'22/8/18 (561)','Kartikpur','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:00:19','2021-07-25 22:00:19'),(1811,9,'customer',NULL,'Jahir Bepary','general',0,NULL,'CO0350',NULL,NULL,NULL,'22/8/18 (562)',NULL,'01723221429',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:01:09','2021-07-25 22:01:09'),(1812,9,'customer',NULL,'Tanvir Mal','general',0,NULL,'CO0351',NULL,NULL,NULL,'25/8/18 (564)','Chaygaw','0196817886',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:01:49','2021-07-25 22:01:49'),(1813,9,'customer',NULL,'Roni','general',0,NULL,'CO0352',NULL,NULL,NULL,'22/9/18 (572)','Bazar','01729933457',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:05:48','2021-07-25 22:05:48'),(1814,9,'customer',NULL,'Hanif Malker','general',0,NULL,'CO0353',NULL,NULL,NULL,'10/10/18(578)','Ramvodropur','01766183398',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:06:45','2021-07-25 22:06:45'),(1815,9,'customer',NULL,'Abdul Ajij Fakir','general',0,NULL,'CO0354',NULL,NULL,NULL,'14/11/18 (590)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:09:03','2021-07-25 22:09:03'),(1816,9,'customer',NULL,'Akhi Howlader','general',0,NULL,'CO0355',NULL,NULL,NULL,'10/11/18 (589)',NULL,'01751358160',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:09:45','2021-07-25 22:09:45'),(1817,9,'customer',NULL,'Abu Taleb','general',0,NULL,'CO0356',NULL,NULL,NULL,'11/12/18(598)','nokia set','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:11:53','2021-07-25 22:11:53'),(1818,9,'customer',NULL,'Jamal Hossain','general',0,NULL,'CO0357',NULL,NULL,NULL,'18/12/18 (602)','darul aman','01937270984',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:12:25','2021-07-25 22:12:25'),(1819,9,'customer',NULL,'Rubi Howlader','general',0,NULL,'CO0358',NULL,NULL,NULL,'19/12/18 (603)',NULL,'01746211807',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:14:42','2021-07-25 22:14:42'),(1820,9,'customer',NULL,'najma','general',0,NULL,'CO0359',NULL,NULL,NULL,'23/12/18 (605)','purbo matha rice mil','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:15:33','2021-07-25 22:15:33'),(1821,9,'customer',NULL,'Awlad','general',0,NULL,'CO0360',NULL,NULL,NULL,'5/1/19 (607)','Dis office','01711008617',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-25 22:18:01','2021-07-25 22:18:01'),(1822,9,'customer',NULL,'ABdur Rab Madber','general',0,NULL,'CO0361',NULL,NULL,NULL,'12/4/21 (275)',NULL,'n',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 17:18:19','2021-07-27 17:18:19'),(1823,9,'customer',NULL,'Ali Akber Sarder','general',0,NULL,'CO0362',NULL,NULL,NULL,'19/4/21','bazar','01611304995',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 17:34:55','2021-07-27 17:34:55'),(1824,9,'customer',NULL,'Nasir Dewan','general',0,NULL,'CO0363',NULL,NULL,NULL,'4/5/21 (288)','BAZAR','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 17:51:03','2021-07-27 17:51:03'),(1825,9,'customer',NULL,'Kakoli (RAfiq majhi)','general',0,NULL,'CO0364',NULL,NULL,NULL,'5/5/21 (288)','BAZAR','01722525288',NULL,'01719881282',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 17:52:25','2021-07-27 17:52:25'),(1826,9,'customer',NULL,'Sohag Mirjapur','general',0,NULL,'CO0365',NULL,NULL,NULL,NULL,'Bosser project er satha basa','01932019723',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 22:47:30','2021-07-27 22:47:30'),(1827,9,'customer',NULL,'Mehedi Ajad Enterprice','general',0,NULL,'CO0366',NULL,NULL,NULL,'23/6/21 (307)','Bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 22:49:13','2021-07-27 22:49:13'),(1828,9,'customer',NULL,'Dulal Howlader','general',0,NULL,'CO0367',NULL,NULL,NULL,'23/6/21 (308)','7 no word paschim monua','01741805130',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 22:53:38','2021-07-27 22:53:38'),(1829,9,'customer',NULL,'Mostofa Howlader','general',0,NULL,'CO0368',NULL,NULL,NULL,'24/6/21 (308)','4 no word mohisar','01748595523',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 22:54:35','2021-07-27 22:54:35'),(1830,9,'customer',NULL,'Kaji Jafor','general',0,NULL,'CO0369',NULL,NULL,NULL,'24/6/21 (308)','bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:16:15','2021-07-27 23:16:15'),(1831,9,'customer',NULL,'Rasel Dewan','general',0,NULL,'CO0370',NULL,NULL,NULL,'25/6/21 (309)','charpayatoli. eruo banglar satha','01786685425',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:17:08','2021-07-27 23:17:08'),(1832,9,'customer',NULL,'Harun Chowdhory','general',0,NULL,'CO0371',NULL,NULL,NULL,'25/6/21 (309)','mohisar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:17:45','2021-07-27 23:17:45'),(1833,9,'customer',NULL,'Chunu Bala','general',0,NULL,'CO0372',NULL,'bala kandi',NULL,'25/6/21 (309)','char mohis kandi, arsi nagar','01734420424',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:18:36','2021-07-27 23:18:36'),(1834,9,'customer',NULL,'Farhad Madber','general',0,NULL,'CO0373',NULL,NULL,NULL,'25/6/21 (309)','4 no word Ikorkandi','01626399908',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:20:03','2021-07-27 23:20:03'),(1835,9,'customer',NULL,'Monir Jamaddar','general',0,NULL,'CO0374',NULL,NULL,NULL,'27/6/21(310)','Sajonpur','01778359085',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:21:55','2021-07-27 23:21:55'),(1836,9,'customer',NULL,'Mohiuddin Majhi','general',0,NULL,'CO0375',NULL,NULL,NULL,'26/6/21(310)','pom 9no word','01919865948',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:22:36','2021-07-28 16:46:58'),(1837,9,'customer',NULL,'Bepary','general',0,NULL,'CO0376',NULL,NULL,NULL,NULL,'null','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:23:04','2021-07-27 23:23:04'),(1838,9,'customer',NULL,'Abu Bokkor Howlader','general',0,NULL,'CO0377',NULL,NULL,NULL,NULL,'Pourosova 2 no word','01732992303',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:23:52','2021-07-27 23:23:52'),(1839,9,'customer',NULL,'Antu khan','general',0,NULL,'CO0378',NULL,NULL,NULL,NULL,'Bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:24:19','2021-07-27 23:24:19'),(1840,9,'customer',NULL,'Farida Apa','general',0,NULL,'CO0379',NULL,NULL,NULL,NULL,'sottopur','01770734475',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:24:57','2021-07-27 23:24:57'),(1841,9,'customer',NULL,'Jannat','general',0,NULL,'CO0380',NULL,NULL,NULL,'6/7/21(313)','mohisar','01782820763',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:25:31','2021-07-27 23:25:31'),(1842,9,'customer',NULL,'Ratan Ghos','general',0,NULL,'CO0381',NULL,NULL,NULL,NULL,'Sajonpur','01998609827',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:25:57','2021-07-27 23:25:57'),(1843,9,'customer',NULL,'Ali Akber Sarder','general',0,NULL,'CO0382',NULL,NULL,NULL,'7/7/21(313)','Chaygaw','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:26:30','2021-07-27 23:26:30'),(1844,9,'customer',NULL,'Harun Madber','general',0,NULL,'CO0383',NULL,NULL,NULL,'87/21 (314)','Ikorkandi nodir par','01747061454',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:27:13','2021-07-27 23:27:13'),(1845,9,'customer',NULL,'Jahangir Howlader','general',0,NULL,'CO0384',NULL,NULL,NULL,'9/7/21 (314)','Mohisar 3 No word','01738098119',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:27:54','2021-07-27 23:27:54'),(1846,9,'customer',NULL,'Selim Van Chalok','general',0,NULL,'CO0385',NULL,NULL,NULL,'9/7/21 (314)','Sajonpur','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:28:26','2021-07-27 23:28:26'),(1847,9,'customer',NULL,'Ropa Akter','general',0,NULL,'CO0386',NULL,'sami Rubel Madber',NULL,'11/7/21(315)','Lakarta ,sajonpur','01967908919',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:29:41','2021-07-27 23:29:41'),(1848,9,'customer',NULL,'Monir Van','general',0,NULL,'CO0387',NULL,NULL,NULL,NULL,'van','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:29:59','2021-07-27 23:29:59'),(1849,9,'customer',NULL,'Sahin Molla','general',0,NULL,'CO0388',NULL,NULL,NULL,'11/7/21 (315)','mohisar','01703428760',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:30:36','2021-07-27 23:30:36'),(1850,9,'customer',NULL,'Sahidul Islam Sarder','general',0,NULL,'CO0389',NULL,NULL,NULL,'11/7/21 (315)','1 no word Mohisar','01722091134',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:31:32','2021-07-27 23:31:32'),(1851,9,'customer',NULL,'Rafiqul Islam','general',0,NULL,'CO0390',NULL,NULL,NULL,'12/7/21 (316)','dinara','01722720221',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:32:07','2021-07-27 23:32:07'),(1852,9,'customer',NULL,'Halim Howlader','general',0,NULL,'CO0391',NULL,NULL,NULL,'12/7/21 (316)','Singjala 9 no word','01969335978',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:33:05','2021-07-27 23:33:05'),(1853,9,'customer',NULL,'Ibrahim Boli','general',0,NULL,'CO0392',NULL,NULL,NULL,'13/7/21 (317)','7 no word arji pom','01771959220',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:33:51','2021-07-27 23:33:51'),(1854,9,'customer',NULL,'Sujon Rari','general',0,NULL,'CO0393',NULL,NULL,NULL,'13/7/21 (317)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:34:23','2021-07-27 23:34:23'),(1855,9,'customer',NULL,'Nasir Khan','general',0,NULL,'CO0394',NULL,'SHARIATPUR',NULL,'Bangladesh','pom','01748456788',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:35:15','2021-09-04 16:38:01'),(1856,9,'customer',NULL,'Anowar Mudi','general',0,NULL,'CO0395',NULL,NULL,NULL,'13/7/21(317)','bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:35:44','2021-07-27 23:35:44'),(1857,9,'customer',NULL,'Hannan Glass','general',0,NULL,'CO0396',NULL,NULL,NULL,'13/7/21 (317)','bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:36:32','2021-07-27 23:36:32'),(1858,9,'customer',NULL,'Siraj Soyal','general',0,NULL,'CO0397',NULL,NULL,NULL,'14/7/21 (318)','mogor 9 no word','01796445488',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:39:34','2021-07-27 23:39:34'),(1859,9,'customer',NULL,'Kamal Soyal','general',0,NULL,'CO0398',NULL,NULL,NULL,'14/7/21 (318)','Sajonpur','01765321892',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:40:41','2021-07-27 23:40:41'),(1860,9,'customer',NULL,'Amena Begum','general',0,NULL,'CO0399',NULL,'tower er satah sarder bari',NULL,'14/7/21 (318)','Ramvodropur','01797536977',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:41:30','2021-07-27 23:41:30'),(1861,9,'customer',NULL,'Md Kamal Akon','general',0,NULL,'CO0400',NULL,NULL,NULL,'14/7/21 (318)','Sidda 5 no word','01754419908',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:42:12','2021-07-27 23:42:12'),(1862,9,'customer',NULL,'Md Saymon akond','general',0,NULL,'CO0401',NULL,'bangla bazar',NULL,'14/7/21 (319)','Chaygaw 1 no word','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:43:08','2021-07-27 23:43:08'),(1863,9,'customer',NULL,'Din Islam','general',0,NULL,'CO0402',NULL,NULL,NULL,'14/7/21(319)','bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:43:56','2021-07-27 23:43:56'),(1864,9,'customer',NULL,'MD Nannu Gazi','general',0,NULL,'CO0403',NULL,NULL,NULL,'15/7/21(319)','Singjala 9 no word','01959970972',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:46:28','2021-07-27 23:46:28'),(1865,9,'customer',NULL,'Akterujjaman gazi','general',0,NULL,'CO0404',NULL,NULL,NULL,NULL,'charpayatoli molla kandi','15/7/21 (319)',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:47:44','2021-07-27 23:47:44'),(1866,9,'customer',NULL,'Mansura','general',0,NULL,'CO0405',NULL,NULL,NULL,'15/7/21 (320)','Sidda 7 no word','01776443235',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:48:53','2021-07-27 23:48:53'),(1867,9,'customer',NULL,'Md Rashid Howlader','general',0,NULL,'CO0406',NULL,NULL,NULL,'15/7/21 (320)','3 no word MOhisar','01710410412',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:53:39','2021-07-27 23:53:39'),(1868,9,'customer',NULL,'Latif Madber','general',0,NULL,'CO0407',NULL,NULL,NULL,'15/7/21 (321)','Sidda 6 no word','01741555690',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-27 23:59:44','2021-07-27 23:59:44'),(1869,9,'customer',NULL,'Sadia','general',0,NULL,'CO0408',NULL,NULL,NULL,'15/7/21 (321)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:00:20','2021-07-28 00:00:20'),(1870,9,'customer',NULL,'Imran Majhi','general',0,NULL,'CO0409',NULL,NULL,NULL,'16/7/21 (321)','1 no word Chotromuria','01782609845',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:01:09','2021-07-28 00:01:09'),(1871,9,'customer',NULL,'Akter Bepary','general',0,NULL,'CO0410',NULL,'ABu taleb marfot',NULL,'16/7/21 (321)','char koraltoli 9no word','01905279395',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:02:18','2021-07-28 00:02:18'),(1872,9,'customer',NULL,'Ruma Begum','general',0,NULL,'CO0411',NULL,'pita: kadir bepary',NULL,'16/7/21 (321)','gulmaij 7 no word','01726961205',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:03:13','2021-07-28 00:03:13'),(1873,9,'customer',NULL,'Yeasin Madber','general',0,NULL,'CO0412',NULL,NULL,NULL,'16/7/21 (322)','Putijuri no word','01914833983',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:04:17','2021-07-28 00:04:17'),(1874,9,'customer',NULL,'Milon Sarder','general',0,NULL,'CO0413',NULL,NULL,NULL,'16/7/21 (322)','Chaygaw chokder bari','01757136551',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:05:53','2021-07-28 00:05:53'),(1875,9,'customer',NULL,'Rostom Sheikh','general',0,NULL,'CO0414',NULL,'madrasar satha',NULL,'17/7/21 (322)','2 no word moddho chaygay','01972263826',NULL,'01786470692',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:07:00','2021-07-28 00:07:00'),(1876,9,'customer',NULL,'Md Babul Majhi','general',0,NULL,'CO0415',NULL,NULL,NULL,'18/7/21(322)','Chaygaw 1 no word','01930117565',NULL,'01957837685',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:07:52','2021-07-28 00:07:52'),(1877,9,'customer',NULL,'Ali Sarker','general',0,NULL,'CO0416',NULL,'Auto chalok monir marfot',NULL,'18/7/21 (323)','Char koraltoli , Midha kandi','01300408871',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:15:15','2021-07-28 00:15:15'),(1878,9,'customer',NULL,'Saddam Bepary','general',0,NULL,'CO0417',NULL,NULL,NULL,'18/7/21 (323)','charkumaria howlader kandi','01742757191',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:16:21','2021-07-28 00:16:21'),(1879,9,'customer',NULL,'Sabuj Howlader','general',0,NULL,'CO0418',NULL,NULL,NULL,'19/7/21 (324)','8 no purosova, bazar','01718066019',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:17:10','2021-07-28 00:17:10'),(1880,9,'customer',NULL,'Md Chan mia SArder','general',0,NULL,'CO0419',NULL,NULL,NULL,'19/7/21 (324)','lakarta 4 no word haji bari','01945828652',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:17:58','2021-07-28 00:17:58'),(1881,9,'customer',NULL,'Md Nure Alam Fakir','general',0,NULL,'CO0420',NULL,NULL,NULL,'19/7/21 (324)','6 no word Damudda','01796335128',NULL,'01712629399',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:18:54','2021-07-28 00:18:54'),(1882,9,'customer',NULL,'Md IQbal Shikder','general',0,NULL,'CO0421',NULL,NULL,NULL,'19/7/21 (325)','lakarta 4 no word','01718968819',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:19:48','2021-07-28 00:19:48'),(1883,9,'customer',NULL,'Md Harun Sarder','general',0,NULL,'CO0422',NULL,NULL,NULL,'19/7/21 (325)','9 no word mirjapur','01764471405',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:20:46','2021-07-28 00:20:46'),(1884,9,'customer',NULL,'Monir Chokider','general',0,NULL,'CO0423',NULL,'Rakib maker marfot',NULL,'19/7/21 (325)','Putia 6 no word','01319838466',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:21:41','2021-07-28 00:21:41'),(1885,9,'customer',NULL,'Mujior Sheikh','general',0,NULL,'CO0424',NULL,'rajib bajar marfot',NULL,'20/7/21 (325)','Mohisar 2 No word','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:23:14','2021-07-28 00:23:14'),(1886,9,'customer',NULL,'Md Iddis khan','general',0,NULL,'CO0425',NULL,NULL,NULL,'20/7/21 (326)','pom','01904845145',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:24:10','2021-07-28 00:24:10'),(1887,9,'customer',NULL,'Renu Begum','general',0,NULL,'CO0426',NULL,'master bazar er satha',NULL,'20/7/21 (326)','Chaygaw','01720419345',NULL,'01670215940',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:26:30','2021-07-28 00:26:30'),(1888,9,'customer',NULL,'Sahalom Howlader','general',0,NULL,'CO0427',NULL,'pita dudu mia',NULL,'20/7/21 (326)','Char chanda malek kandi','01924931524',NULL,'01778785273',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:27:31','2021-07-28 00:27:31'),(1889,9,'customer',NULL,'Imran Mir malot','general',0,NULL,'CO0428',NULL,NULL,NULL,'20/7/21 (327)','Vatita, ramvodropur','01793486920',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:28:32','2021-07-28 00:28:32'),(1890,9,'customer',NULL,'Jakir Fakir','general',0,NULL,'CO0429',NULL,NULL,NULL,'20/7/21 (327)','Chotro Muria','01908254799',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:29:18','2021-07-28 00:29:18'),(1891,9,'customer',NULL,'MD Saiful Sarder','general',0,NULL,'CO0430',NULL,NULL,NULL,'20/7/21 (327)','Damgaria 6 no word','01402023390',NULL,'01998612475',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:30:15','2021-07-28 00:30:15'),(1892,9,'customer',NULL,'Md Delowar Khan','general',0,NULL,'CO0431',NULL,NULL,NULL,'20/7/21 (327)','charpayatoli rari kandi','01766172943',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:31:02','2021-07-28 00:31:02'),(1893,9,'customer',NULL,'Uttam Sornoker','general',0,NULL,'CO0432',NULL,NULL,NULL,'20/7/21 (328)','bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:32:10','2021-07-28 00:32:10'),(1894,9,'customer',NULL,'Sahjalal','general',0,NULL,'CO0433',NULL,NULL,NULL,'20/7/21 (328)','Sajonpur','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:32:46','2021-07-28 00:32:46'),(1895,9,'customer',NULL,'Khalek Pajori','general',0,NULL,'CO0434',NULL,NULL,NULL,'22/7/21 (328)','Koraltoli surjomoni bridger satha','01876315789',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:33:55','2021-07-28 00:33:55'),(1896,9,'customer',NULL,'Kulsum begum','general',0,NULL,'CO0435',NULL,'sami rajjak chowdhory',NULL,'22/7/21 (328)','Mohisar 3 No word','01724371741',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:34:44','2021-07-28 00:34:44'),(1897,9,'customer',NULL,'Nur Hossain Molla','general',0,NULL,'CO0436',NULL,'Fajlu howlader marfot',NULL,'23/7/21 (329)','Charpayatoli,','01761797370',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:38:19','2021-07-28 00:38:19'),(1898,9,'customer',NULL,'Goni Khan','general',0,NULL,'CO0437',NULL,NULL,NULL,NULL,'Bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:41:21','2021-07-28 00:41:21'),(1899,9,'customer',NULL,'Dipu Talukder','general',0,NULL,'CO0438',NULL,'Howlader kandi',NULL,'25/7/21 (329)','uttar char kumaria','01743406444',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:42:20','2021-07-28 00:42:20'),(1900,9,'customer',NULL,'Md Dalim','general',0,NULL,'CO0439',NULL,NULL,NULL,'25/7/21 (330)','8 no word','01765766138',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:43:08','2021-07-28 00:43:08'),(1901,9,'customer',NULL,'Md Dalim','general',0,NULL,'CO0440',NULL,NULL,NULL,NULL,'8 no word','01765766138',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:46:43','2021-07-28 00:46:43'),(1902,9,'customer',NULL,'Alam Enterprice','general',445,NULL,'CO0441',NULL,NULL,NULL,'22/7/21 (330)',NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:47:10','2021-10-05 16:56:01'),(1903,9,'customer',NULL,'Samsuddin','general',0,NULL,'CO0442',NULL,NULL,NULL,NULL,NULL,'no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 00:47:44','2021-07-28 00:47:44'),(1904,9,'customer',NULL,'Dokan Kom Mal','general',0,NULL,'CO0443',NULL,NULL,NULL,NULL,'dokan mal kom','01712811913',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 19:34:50','2021-10-11 14:16:01'),(1905,9,'customer',NULL,'Joni Foridi','general',0,NULL,'CO0444',NULL,NULL,NULL,NULL,'Sajonpur','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 20:04:45','2021-07-28 20:04:45'),(1906,9,'customer',NULL,'Rose Apa','general',0,NULL,'CO0445',NULL,NULL,NULL,NULL,'bosser bon','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 20:05:40','2021-07-28 20:05:40'),(1907,9,'customer',NULL,'National Biddut Bitan','general',0,NULL,'CO0446',NULL,NULL,NULL,NULL,'dokan','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 20:06:14','2021-07-28 20:06:14'),(1908,9,'customer',NULL,'Khokon Akon','general',0,NULL,'CO0447',NULL,NULL,NULL,NULL,'mara gese','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 20:07:05','2021-07-28 20:07:05'),(1909,9,'customer',NULL,'Alam chan Ukil','general',0,NULL,'CO0448',NULL,NULL,NULL,'18/1/16 (233)','Pourosova','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-07-28 22:34:50','2021-07-28 22:34:50'),(1910,9,'supplier','Electronics','July stock','general',0,NULL,'5444',NULL,'Dhaka','Bhedorgonj','Bangladesh','Bhedarganj','555',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-03 14:42:22','2021-08-03 14:42:22'),(1911,9,'supplier','Electronics','Najmul Electrick & Senatary','general',0,NULL,'CO0450',NULL,NULL,NULL,NULL,'Bhedarganj','01771383686',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14 14:20:38','2021-08-14 14:20:38'),(1912,9,'supplier','Walton','M/S Bismillah Electronics','general',0,NULL,'CO0451',NULL,NULL,NULL,NULL,'bazar','0173578767',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14 14:29:54','2021-08-14 14:29:54'),(1913,9,'supplier','Electronics','Sahpla Solar','general',0,NULL,'CO0452',NULL,NULL,NULL,NULL,'Damudda','01713950075',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14 14:36:50','2021-08-14 14:36:50'),(1914,9,'supplier','Marcel','Walton Hi-Tech Ind Ltd','general',0,NULL,'CO0453',NULL,NULL,NULL,NULL,'Chandra,Kalikoir,Gazipur','01686691415',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14 14:44:28','2021-08-14 14:44:28'),(1915,9,'customer',NULL,'Doctor Babul Mama','general',0,NULL,'CO0454',NULL,NULL,NULL,NULL,'bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14 15:59:00','2021-08-14 15:59:00'),(1916,9,'customer',NULL,'Akter Dalal','general',0,NULL,'CO0455',NULL,NULL,NULL,NULL,'BAZAR','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-14 16:10:52','2021-08-14 16:10:52'),(1917,9,'supplier','Mega','SEP Digital Technology','general',0,NULL,'CO0456',NULL,NULL,NULL,NULL,'Chandra super market,Shariatpur','01958604041',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-16 13:50:33','2021-08-16 13:50:33'),(1918,9,'supplier','Kiam','M/S Mahmuda Electronics','general',0,NULL,'CO0457',NULL,NULL,NULL,NULL,'Jajira','01789482151','01982645403','0172948707',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-18 13:18:18','2021-08-18 13:18:18'),(1919,9,'supplier','Chular parts','Ashif Sanitary','general',0,'admin@alampos.com','CO0458',NULL,'Dhaka',NULL,'Bangladesh','North south road','01715455654',NULL,'01914742264',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20 15:39:16','2021-08-20 15:39:16'),(1920,9,'supplier','Dhaka','Arkay Electronics','general',0,NULL,'CO0459',NULL,NULL,NULL,NULL,'Dhaka','01716230572',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-20 15:47:29','2021-08-20 15:47:29'),(1921,9,'supplier','Active','Usha Telecom','general',0,NULL,'CO0460',NULL,NULL,NULL,NULL,'shariatpur','01712131092',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-23 16:27:31','2021-08-23 16:27:31'),(1922,9,'customer','f','Sahalom Kobiraj','general',0,'gfggfwa@gfdf','CO0461',NULL,NULL,NULL,NULL,'fdf','df','fd',NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24 22:24:27','2021-08-24 22:24:27'),(1923,9,'customer','f','Sahalom Kobiraj','general',0,'gfggfwa@gfdf','CO0462',NULL,NULL,NULL,NULL,'fdf','df','fd',NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24 22:24:41','2021-08-24 22:24:41'),(1924,9,'customer',NULL,'Sahalom Kobiraj','general',0,NULL,'CO0463',NULL,NULL,NULL,NULL,NULL,'null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-24 22:25:25','2021-08-24 22:25:25'),(1925,9,'customer',NULL,'NBl Jakir','general',0,NULL,'CO0464',NULL,NULL,NULL,NULL,'National bank','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28 18:59:13','2021-08-28 18:59:13'),(1926,9,'customer',NULL,'Bacchu Howlader','general',0,NULL,'CO0465',NULL,NULL,NULL,NULL,'bazar hotel','n',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28 19:34:00','2021-08-28 19:34:00'),(1927,9,'customer',NULL,'Didar Chokider','general',0,NULL,'CO0466',NULL,NULL,NULL,NULL,'BAZAR','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-28 19:40:50','2021-08-28 19:40:50'),(1928,9,'supplier','d','Tv Remot Kamal','general',0,NULL,'CO0467',NULL,NULL,NULL,NULL,'Kartikpur','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 15:21:47','2021-08-29 15:21:47'),(1929,9,'supplier','bashundhara','Bashundhara GAs','general',0,NULL,'CO0468',NULL,NULL,NULL,NULL,'Bhedarganj','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 15:53:19','2021-08-29 15:53:19'),(1930,9,'customer',NULL,'Kobul Majhi','general',0,NULL,'CO0469',NULL,NULL,NULL,NULL,'d','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 16:09:01','2021-08-29 16:09:01'),(1931,9,'customer',NULL,'Kalipodo','general',0,NULL,'CO0470',NULL,NULL,NULL,NULL,'Niyamat Shikder Bulding','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 20:52:01','2021-08-29 20:52:01'),(1932,9,'customer',NULL,'Jasim Howlader','general',0,NULL,'CO0471',NULL,NULL,NULL,NULL,'char','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 22:26:31','2021-08-29 22:26:31'),(1933,9,'customer',NULL,'Doctor Mijan','general',0,NULL,'CO0472',NULL,NULL,NULL,NULL,'Upjela sastho compelex','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 22:42:21','2021-08-29 22:42:21'),(1934,9,'supplier','Omera','Omera Gas Company','general',0,'admin@alampos.com','CO0473',NULL,'Dhaka','Bhedorgonj','Bangladesh',NULL,'0',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-29 22:44:25','2021-08-29 22:44:25'),(1935,9,'customer',NULL,'Dokan Emon','general',0,NULL,'CO0474',NULL,NULL,NULL,NULL,'stap','01767969106',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30 00:30:35','2021-10-10 19:44:58'),(1936,9,'supplier','dfd','Coustomer','general',0,NULL,'CO0475',NULL,NULL,NULL,NULL,'df','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-30 00:35:46','2021-08-30 00:35:46'),(1937,9,'customer',NULL,'Jakir Gain','general',0,NULL,'CO0476',NULL,NULL,NULL,NULL,'BAZAR','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 20:24:07','2021-08-31 20:24:07'),(1938,9,'customer',NULL,'Rajon Chokider','general',0,NULL,'CO0477',NULL,NULL,NULL,NULL,'d','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 20:33:10','2021-08-31 20:33:10'),(1939,9,'customer',NULL,'Nur Islam','general',0,NULL,'CO0478',NULL,NULL,NULL,NULL,'Mach bazar','0',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 20:34:56','2021-09-21 16:10:16'),(1940,9,'customer',NULL,'Saiful dim','general',0,NULL,'CO0479',NULL,NULL,NULL,NULL,'BAZAR','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 21:04:35','2021-08-31 21:04:35'),(1941,9,'customer',NULL,'Halim Molla','general',0,NULL,'CO0480',NULL,NULL,NULL,NULL,'Pom 9 no word','01734745480',NULL,'01771634480',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 21:19:35','2021-09-21 16:11:00'),(1942,9,'customer',NULL,'Ria Moni','general',0,NULL,'CO0481',NULL,NULL,NULL,NULL,'d','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 21:26:30','2021-08-31 21:26:30'),(1943,9,'customer',NULL,'Riad Talukder','general',0,NULL,'CO0482',NULL,NULL,NULL,NULL,'BAZAR','m',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 21:28:31','2021-08-31 21:28:31'),(1944,9,'customer',NULL,'Hafez Delowar','general',0,NULL,'CO0483',NULL,NULL,NULL,NULL,'BAZAR','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-08-31 21:43:40','2021-08-31 21:43:40'),(1945,9,'customer',NULL,'Borhan','general',0,NULL,'CO0484',NULL,NULL,NULL,NULL,'charpayatoli 8 no word','01765476315',NULL,'01314923725',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 15:30:45','2021-09-21 16:18:37'),(1946,9,'customer',NULL,'Sahalom Dhali','general',0,NULL,'CO0485',NULL,NULL,NULL,NULL,'Pom 9 no word','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 15:32:43','2021-09-21 16:37:06'),(1947,9,'customer',NULL,'Ayesha','general',0,NULL,'CO0486',NULL,NULL,NULL,NULL,'monua','01313817284','d',NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 15:43:03','2021-09-21 16:36:36'),(1948,9,'customer',NULL,'Ataur Bepary','general',0,NULL,'CO0487',NULL,NULL,NULL,NULL,'b','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:00:48','2021-09-01 16:00:48'),(1949,9,'customer',NULL,'Billal Shikder','general',0,NULL,'CO0488',NULL,NULL,NULL,NULL,'f','n',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:07:17','2021-09-01 16:07:17'),(1950,9,'customer',NULL,'Sultan Khan','general',0,NULL,'CO0489',NULL,NULL,NULL,NULL,'Bhedarganj purosova 5 no word','01741489854',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:23:58','2021-09-21 16:38:27'),(1951,9,'customer',NULL,'Sahidul','general',0,NULL,'CO0490',NULL,NULL,NULL,NULL,'pom 9no word','01945790395',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:39:34','2021-09-01 16:39:34'),(1952,9,'customer',NULL,'Milon Soyal','general',0,NULL,'CO0491',NULL,NULL,NULL,NULL,'n','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:41:28','2021-09-01 16:42:01'),(1953,9,'customer',NULL,'Iddis Howlader','general',0,NULL,'CO0492',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:42:18','2021-09-01 16:42:18'),(1954,9,'customer',NULL,'Nasima Begum','general',0,NULL,'CO0493',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:53:19','2021-09-01 16:53:19'),(1955,9,'customer',NULL,'Malek Bepary','general',0,NULL,'CO0494',NULL,NULL,NULL,'24/8/21','d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 16:56:32','2021-09-01 16:56:32'),(1956,9,'customer',NULL,'Safi Dewan','general',0,NULL,'CO0495',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 17:11:56','2021-09-01 17:11:56'),(1957,9,'customer',NULL,'Akterujjaman','general',0,NULL,'CO0496',NULL,NULL,NULL,NULL,'charpayatoli molla kandi','01760474071',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 17:18:03','2021-09-21 16:39:34'),(1958,9,'customer',NULL,'Abul Hossain Khan','general',0,NULL,'CO0497',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 18:42:49','2021-09-01 18:42:49'),(1959,9,'supplier','d','Akash DTH','general',0,NULL,'CO0498',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 18:44:21','2021-09-01 18:44:21'),(1960,9,'customer',NULL,'Jan Sharif','general',0,NULL,'CO0499',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 18:45:38','2021-09-01 18:45:38'),(1961,9,'customer',NULL,'Farhad Molla','general',0,NULL,'CO0500',NULL,NULL,NULL,'29/8/21','Bhedarganj','01735029160',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 19:43:11','2021-09-21 16:29:11'),(1962,9,'customer',NULL,'Roman Sarder Boss','general',0,NULL,'CO0501',NULL,'Dhaka','Bhedorgonj','Bangladesh','Bazar','01713578767',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 19:54:28','2021-09-01 19:54:28'),(1963,9,'customer',NULL,'Faruq','general',0,NULL,'CO0502',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-01 19:57:06','2021-09-01 19:57:06'),(1964,9,'supplier','gp','Grameenphone','general',0,NULL,'CO0503',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04 14:45:37','2021-09-04 14:45:37'),(1965,9,'customer',NULL,'Gisa Uddin','general',0,NULL,'CO0504',NULL,NULL,NULL,'3/9/21','d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-04 14:58:24','2021-09-04 14:58:24'),(1966,9,'customer',NULL,'Lal Mia','general',0,NULL,'CO0505',NULL,NULL,NULL,'4/9/21','Monua','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05 14:18:35','2021-09-05 14:18:35'),(1967,9,'customer',NULL,'Mujhahid Majhi','general',0,NULL,'CO0506',NULL,NULL,NULL,'4/9/21','Ba oi kandi, narayanpur 7 no word','01713519140',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-05 14:21:06','2021-09-21 16:31:18'),(1968,9,'supplier','Stove','Alam Enterprice','general',0,NULL,'CO0507',NULL,NULL,NULL,NULL,'Bazar','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 13:54:51','2021-09-08 13:54:51'),(1969,9,'customer',NULL,'Sunil Das','general',0,NULL,'CO0508',NULL,NULL,NULL,NULL,'Chaygaw  banglabazar 1 no word','01723707557',NULL,'01989627374',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 19:51:16','2021-09-21 16:32:36'),(1970,9,'customer',NULL,'Polas','general',0,NULL,'CO0509',NULL,NULL,NULL,NULL,'b','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 20:37:47','2021-09-08 20:37:47'),(1971,9,'customer',NULL,'Liton Shikder','general',0,NULL,'CO0510',NULL,NULL,NULL,NULL,'Ba oi kandi, narayanpur 7 no word','01910166950',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 20:50:53','2021-09-21 16:33:24'),(1972,9,'customer',NULL,'Nuruddin','general',0,NULL,'CO0511',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 20:54:06','2021-09-08 20:54:06'),(1973,9,'customer',NULL,'Mawlana Obaydur Rahman','general',0,NULL,'CO0512',NULL,NULL,NULL,NULL,'4 no word Ikorkandi','01715969958',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 20:56:29','2021-09-21 16:40:53'),(1974,9,'customer',NULL,'Al Amin','general',0,NULL,'CO0513',NULL,NULL,NULL,NULL,'Bhedarganj bazar kaporpotti','01305392616',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 21:03:07','2021-09-21 16:34:36'),(1975,9,'supplier','bl','Banglalink','general',0,NULL,'CO0514',NULL,NULL,NULL,NULL,'df','mn',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-08 21:38:38','2021-09-08 21:38:38'),(1976,9,'supplier','RFL','MS SOHEL & BROTHERS','general',0,NULL,'CO0515',NULL,'SAKHIPUR',NULL,NULL,'MOLLAR HAT','01728312054',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09 14:39:07','2021-09-09 14:39:07'),(1977,9,'customer',NULL,'TEST','general',0,NULL,'CO0516',NULL,NULL,NULL,NULL,'F','D',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09 15:31:47','2021-09-09 15:31:47'),(1978,9,'customer',NULL,'sarowarkhan','general',0,'graphicment8@gmail.com','CO0517',NULL,'Dhaka','Dhaka','Bangladesh',NULL,'01759941474',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09 17:15:08','2021-09-09 17:15:08'),(1979,9,'customer',NULL,'test 2','general',0,NULL,'CO0518',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-09 19:02:28','2021-09-09 19:02:28'),(1980,9,'supplier','MEP','MS Rijvi Electrick','general',0,NULL,'CO0519',NULL,NULL,NULL,NULL,'Bhedarganj','01732252156',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10 14:12:29','2021-09-10 14:12:29'),(1981,9,'customer',NULL,'Karim','general',0,NULL,'CO0520',NULL,NULL,NULL,NULL,'Upojela','nu',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10 14:19:42','2021-09-10 14:19:42'),(1982,9,'customer',NULL,'Jahangir Howlader','general',0,NULL,'CO0521',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10 14:20:38','2021-09-10 14:20:38'),(1983,9,'customer',NULL,'MS Bismillah Electronics','general',0,NULL,'CO0522',NULL,NULL,NULL,NULL,'Walton Showroom','0173578767',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-10 14:22:34','2021-09-10 14:22:34'),(1984,9,'customer',NULL,'Md Alal Bepary','general',0,NULL,'CO0523',NULL,NULL,NULL,NULL,'putia 3no word','01629989255',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11 15:04:49','2021-09-11 16:23:17'),(1985,9,'customer',NULL,'Md Ibrahim Sarder','general',0,NULL,'CO0524',NULL,NULL,NULL,NULL,'koraltoli 8 no word','01319615716',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11 15:10:17','2021-09-11 16:23:55'),(1986,9,'customer',NULL,'Md Ujjal Mahmud Molla','general',0,NULL,'CO0525',NULL,NULL,NULL,NULL,'charpayatoli ali hossain sarder kandi','01996583720',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11 15:55:26','2021-09-11 16:24:41'),(1987,9,'supplier','Stove','Nikko Chula','general',0,NULL,'CO0526',NULL,NULL,NULL,NULL,'Dhaka','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11 17:26:33','2021-09-11 17:26:33'),(1988,9,'supplier','Light','Super Star Enargy Bulb','general',0,NULL,'CO0527',NULL,NULL,NULL,NULL,'Naria','no',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-11 17:28:47','2021-09-11 17:28:47'),(1989,9,'customer',NULL,'Alamgir Molla','general',0,NULL,'CO0528',NULL,NULL,NULL,NULL,'lakarta 4 no word','01933132131',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-12 14:14:22','2021-09-21 16:44:34'),(1990,9,'customer',NULL,'Dulal Gain','general',0,NULL,'CO0529',NULL,NULL,NULL,'12/9/21','Bazar','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-14 14:20:16','2021-09-14 14:20:16'),(1991,9,'supplier','Electronics','New Badal Treding','general',0,NULL,'CO0530',NULL,NULL,NULL,NULL,'Nowabpur,Dhaka','01717942881',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17 13:37:42','2021-09-17 13:37:42'),(1992,9,'supplier','Walton','Shariatpur Walton Service Point','general',0,NULL,'CO0531',NULL,NULL,NULL,NULL,'shariatpur','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17 14:20:19','2021-09-17 14:20:19'),(1993,9,'customer',NULL,'Cha Dokan Pichoner goli','general',0,NULL,'CO0532',NULL,NULL,NULL,NULL,'Bazar','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-17 15:20:29','2021-09-17 15:20:29'),(1994,9,'customer',NULL,'Sahina','general',0,NULL,'CO0533',NULL,NULL,NULL,NULL,'charpaytoli hazi kandi','01306026961',NULL,'00971563021306',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-18 14:39:44','2021-09-21 16:45:17'),(1995,9,'customer',NULL,'Billal SArder','general',0,NULL,'CO0534',NULL,NULL,NULL,'18/9/21','Ramvodropur Cocola madrasr satha','01737825484',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-19 16:00:22','2021-09-21 16:45:51'),(1996,9,'customer',NULL,'Abdus Sattar','general',0,NULL,'CO0535',NULL,NULL,NULL,'d','d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21 15:36:38','2021-09-21 15:36:38'),(1997,9,'customer',NULL,'Sorosoti','general',0,NULL,'CO0536',NULL,NULL,NULL,NULL,'Candankor 3 no word burirhat','01741552164',NULL,'01964841142',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21 16:00:20','2021-10-18 21:46:23'),(1998,9,'customer',NULL,'Anowarul Hoque Howlader','general',0,NULL,'CO0537',NULL,NULL,NULL,NULL,'Naraynpur 6 no word','01715908183',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-21 16:17:53','2021-09-21 16:17:53'),(1999,9,'supplier','Stove','Abdullah Gas Stove','general',0,NULL,'CO0538',NULL,NULL,NULL,NULL,'Madaripur','01710413679',NULL,'01810925941',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22 14:24:29','2021-09-22 14:24:29'),(2000,9,'supplier','walton','Walton Plaza','general',0,NULL,'CO0539',NULL,NULL,NULL,NULL,'Damudda','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22 14:30:07','2021-09-22 14:30:07'),(2001,9,'customer',NULL,'Others due','general',0,NULL,'CO0540',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22 16:11:50','2021-09-22 16:11:50'),(2002,9,'customer',NULL,'Saiful Molla','general',0,NULL,'CO0541',NULL,NULL,NULL,NULL,'DM khali bazar','01744386144',NULL,'01876027618',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-22 16:12:27','2021-10-18 21:45:51'),(2003,9,'customer',NULL,'Sawkot Hossain talukder','general',0,NULL,'CO0542',NULL,NULL,NULL,NULL,'Putia 2 no word','01714667034',NULL,'0171792911',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28 15:30:10','2021-10-18 21:45:11'),(2004,9,'customer',NULL,'Gias uddin','general',0,NULL,'CO0543',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28 16:14:12','2021-09-28 16:14:12'),(2005,9,'customer',NULL,'Akash Howlader','general',0,NULL,'CO0544',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28 16:34:26','2021-09-28 16:34:26'),(2006,9,'customer',NULL,'Rasel Dhali','general',0,NULL,'CO0545',NULL,NULL,NULL,NULL,'f','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28 17:11:45','2021-09-28 17:11:45'),(2007,9,'customer',NULL,'Al Amin Master','general',0,NULL,'CO0546',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-28 17:12:29','2021-09-28 17:12:29'),(2008,9,'customer',NULL,'Jinjira','general',0,NULL,'CO0547',NULL,NULL,NULL,NULL,'BAZAR','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29 13:12:55','2021-09-29 13:12:55'),(2009,9,'customer',NULL,'Sultan Madber','general',0,NULL,'CO0548',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29 14:23:25','2021-09-29 14:23:25'),(2010,9,'customer',NULL,'Masudur Rahman','general',0,NULL,'CO0549',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-29 14:28:32','2021-09-29 14:28:32'),(2011,9,'customer',NULL,'Jamal Sarder','general',0,NULL,'CO0550',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30 15:57:45','2021-09-30 15:57:45'),(2012,9,'customer',NULL,'Siddik','general',0,NULL,'CO0551',NULL,NULL,NULL,NULL,'f','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-09-30 15:58:27','2021-09-30 15:58:27'),(2013,9,'customer',NULL,'Kamal Hossain Madber','general',0,NULL,'CO0552',NULL,NULL,NULL,NULL,'Ikorkandi 4 no word','01770381710',NULL,'01974576868',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-02 14:31:43','2021-10-18 21:44:12'),(2014,9,'customer',NULL,'Shakil Madber','general',0,NULL,'CO0553',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03 13:14:16','2021-10-03 13:14:16'),(2015,9,'customer',NULL,'Naim Doptori','general',0,NULL,'CO0554',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03 13:14:58','2021-10-03 13:14:58'),(2016,9,'customer',NULL,'Hasan Sarder','general',0,NULL,'CO0555',NULL,NULL,NULL,NULL,'df','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03 13:15:33','2021-10-03 13:15:33'),(2017,9,'customer',NULL,'Paplu Sarder','general',0,NULL,'CO0556',NULL,NULL,NULL,NULL,'Mohisar 3 No word','01786339108',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03 16:36:54','2021-10-18 21:43:18'),(2018,9,'customer',NULL,'Nur Mohammad Dhali','general',0,NULL,'CO0557',NULL,NULL,NULL,NULL,'BAZAR','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03 16:41:48','2021-10-18 21:42:46'),(2019,9,'customer',NULL,'Sawon Dhali','general',0,NULL,'CO0558',NULL,NULL,NULL,NULL,'Singjala 9 no word','01819391168',NULL,'01991889063',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-03 16:42:37','2021-10-18 21:42:25'),(2020,9,'customer',NULL,'Latif Dhali','general',0,NULL,'CO0559',NULL,NULL,NULL,NULL,'charpayatoli 8 no word','01645799643',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-04 14:40:22','2021-10-18 21:41:55'),(2021,9,'customer',NULL,'Shopon Fakir','general',0,NULL,'CO0560',NULL,NULL,NULL,NULL,'Chaygaw, delowar munsi marfot','01405926761',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05 16:48:39','2021-10-18 21:41:20'),(2022,9,'customer',NULL,'Abul Bepary','general',0,NULL,'CO0561',NULL,NULL,NULL,NULL,'charchanda haji kalu kandi','01936881941',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05 16:49:18','2021-10-18 21:40:37'),(2023,9,'customer',NULL,'Razzak Akon','general',0,NULL,'CO0562',NULL,NULL,NULL,NULL,'f','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05 16:49:55','2021-10-05 16:49:55'),(2024,9,'customer',NULL,'Pilot','general',0,NULL,'CO0563',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05 16:50:31','2021-10-05 16:50:31'),(2025,9,'supplier','Purit','Purite Company','general',0,NULL,'CO0564',NULL,NULL,NULL,NULL,'f','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-05 16:59:54','2021-10-05 16:59:54'),(2026,9,'supplier','SYMPHONY','MRIDHA TELECOM','general',0,NULL,'CO0565',NULL,NULL,NULL,NULL,'GHORISHAR BAZAR','01712049966',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06 14:06:07','2021-10-06 14:06:07'),(2027,9,'supplier','BRB','BRB CABLE INDUSTRIES LTD','general',0,NULL,'CO0566',NULL,NULL,NULL,NULL,'shariatpur','0',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-06 14:16:00','2021-10-06 14:16:00'),(2028,9,'customer',NULL,'Rasel Khan','general',0,NULL,'CO0567',NULL,NULL,NULL,NULL,'pom sajonpur','0175500010',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07 16:27:56','2021-10-18 21:39:49'),(2029,9,'customer',NULL,'Old Coustomer Due','general',0,NULL,'CO0568',NULL,NULL,NULL,NULL,'null','null',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-07 23:13:19','2021-10-07 23:13:19'),(2030,9,'customer',NULL,'Md Ali Tara Howlader (nurun nahar)','general',0,NULL,'CO0569',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-08 16:04:57','2021-10-08 16:04:57'),(2031,9,'customer',NULL,'nipu khan','general',0,NULL,'CO0570',NULL,NULL,NULL,NULL,NULL,'01719131305',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09 17:16:09','2021-10-09 17:16:09'),(2032,9,'customer',NULL,'Md Nure Alam Roman','general',0,NULL,'01713578767',NULL,'Dhaka','Bhedorgonj','Bangladesh','boss','01713578767',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09 19:33:03','2021-10-09 19:33:03'),(2033,9,'customer',NULL,'Md Sohel','general',0,NULL,'CO0572',NULL,NULL,NULL,NULL,'2 no word Pourosova','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-09 19:34:01','2021-10-18 21:38:54'),(2034,9,'customer',NULL,'M/S Jannat Tredas','general',0,NULL,'CO0573',NULL,NULL,NULL,NULL,'Ramvodropur','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10 13:29:18','2021-10-18 21:35:14'),(2035,9,'customer',NULL,'Nur jahan','general',0,NULL,'CO0574',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10 13:36:13','2021-10-10 13:36:13'),(2036,9,'customer',NULL,'Alam Electronics','general',0,NULL,'CO0575',NULL,NULL,NULL,NULL,'Dokan','01712811913',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10 21:29:33','2021-10-10 21:29:33'),(2037,9,'customer',NULL,'Delowar Mridha','general',0,NULL,'CO0576',NULL,NULL,NULL,NULL,'dokan','01951890107',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-10 21:34:29','2021-10-10 21:34:29'),(2038,9,'customer',NULL,'Abdul Jalil','general',0,NULL,'CO0577',NULL,NULL,NULL,NULL,'boss er project manager','01792795461',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11 14:11:50','2021-10-18 21:38:27'),(2039,9,'customer',NULL,'Golam Mawla','general',0,NULL,'CO0578',NULL,NULL,NULL,NULL,'df','01915527108',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11 14:12:29','2021-10-18 21:37:46'),(2040,9,'supplier','walton','Bismillah electronics-2','general',0,NULL,'CO0579',NULL,'Dhaka','Bhedorgonj','Bangladesh',NULL,'01713578767',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-11 14:35:53','2021-10-11 14:35:53'),(2041,9,'supplier','Shariatpur','Bismillah Electronics (Shariatpur)','general',0,NULL,'CO0580',NULL,NULL,NULL,NULL,'Shariatpur Sadar','01711303483',NULL,'01977303483',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12 13:39:21','2021-10-12 13:39:21'),(2042,9,'supplier','Walton','Molla Motors & Electronics','general',0,NULL,'CO0581',NULL,NULL,NULL,NULL,'SAKHIPUR','01712017900',NULL,'01713592403',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12 13:46:18','2021-10-12 13:46:18'),(2043,9,'customer',NULL,'Rased Vuia','general',0,NULL,'CO0582',NULL,NULL,NULL,NULL,'MIRZAPUR','01937068298',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12 14:18:18','2021-10-18 21:37:22'),(2044,9,'customer',NULL,'Ali Ajger Khan','general',0,NULL,'CO0583',NULL,NULL,NULL,NULL,'charpayatoli haji kandi','01714697586',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12 14:19:35','2021-10-18 21:36:58'),(2045,9,'customer',NULL,'Abedur Rahman Shikder','general',0,NULL,'CO0584',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-12 14:20:58','2021-10-12 14:20:58'),(2046,9,'supplier','Electronics','Sristy Auto Electrick Works','general',0,NULL,'CO0585',NULL,NULL,NULL,NULL,'Bhedarganj BAZAR','01712870388',NULL,'01310928844',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13 14:55:59','2021-10-13 14:55:59'),(2047,9,'supplier','Walton','Walton Digi-Tech Computer','general',0,NULL,'CO0586',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13 15:32:57','2021-10-13 15:32:57'),(2048,9,'customer',NULL,'Nirob','general',0,NULL,'CO0587',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13 15:56:00','2021-10-13 15:56:00'),(2049,9,'customer',NULL,'Jalil Bepary','general',0,NULL,'CO0588',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13 15:56:44','2021-10-13 15:56:44'),(2050,9,'supplier','gas','Pilot Store','general',0,NULL,'CO0589',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-13 16:04:33','2021-10-13 16:04:33'),(2051,9,'customer',NULL,'Motaleb Soyal','general',0,NULL,'CO0590',NULL,NULL,NULL,NULL,'charpayatoli sarker kandi, Rafiq sarker er barir satha','01794164146',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14 13:34:24','2021-10-18 21:36:12'),(2052,9,'supplier','walton','Walton Corporation Ltd','general',0,NULL,'CO0591',NULL,NULL,NULL,NULL,'d','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-14 22:32:47','2021-10-14 22:32:47'),(2053,9,'customer',NULL,'Monir Molla','general',0,NULL,'CO0592',NULL,NULL,NULL,NULL,'Mohisar 2 No word, akkas molla marfot','01716232428',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16 21:33:42','2021-10-18 21:33:41'),(2054,9,'customer',NULL,'Mokbul Sarder','general',0,NULL,'CO0593',NULL,NULL,NULL,NULL,'Paprail 9no word','01944576847',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16 21:34:15','2021-10-18 21:32:04'),(2055,9,'customer',NULL,'Faruq Medical','general',0,NULL,'CO0594',NULL,NULL,NULL,NULL,'BAZAR','fd',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16 21:43:40','2021-10-16 21:43:40'),(2056,9,'customer',NULL,'Md Ali Howlader','general',0,NULL,'CO0595',NULL,NULL,NULL,NULL,'fdf','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16 21:45:42','2021-10-16 21:45:42'),(2057,9,'customer',NULL,'Humayun Dalal','general',0,NULL,'CO0596',NULL,NULL,NULL,NULL,'Mohis kandi','01727034058',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16 21:46:19','2021-10-18 21:34:23'),(2058,9,'customer',NULL,'Sabuj Akber Plaza','general',0,NULL,'CO0597',NULL,NULL,NULL,NULL,'fd','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-16 21:56:37','2021-10-16 21:56:37'),(2059,9,'customer',NULL,'Nasima apa','general',0,NULL,'CO0598',NULL,NULL,NULL,NULL,'f','d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17 14:02:17','2021-10-17 14:02:17'),(2060,9,'supplier','df','Rupali Hardware','general',0,NULL,'CO0599',NULL,NULL,NULL,NULL,'df','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-17 14:16:22','2021-10-17 14:16:22'),(2061,9,'customer',NULL,'Sahana Begum','general',0,NULL,'CO0600',NULL,NULL,NULL,NULL,'f','f',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-18 21:18:17','2021-10-18 21:18:17'),(2062,9,'customer',NULL,'Rasel Molla','general',0,NULL,'CO0601',NULL,NULL,NULL,NULL,NULL,'f',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20 19:08:05','2021-10-20 19:08:05'),(2063,9,'supplier','df','Others Electronics','general',0,NULL,'CO0602',NULL,NULL,NULL,NULL,NULL,'d',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20 19:13:34','2021-10-20 19:13:34'),(2064,9,'supplier','df','Pacific Company','general',0,NULL,'CO0603',NULL,NULL,NULL,NULL,'Dhaka','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20 19:16:18','2021-10-20 19:16:18'),(2065,9,'customer',NULL,'Majid Vai','general',0,NULL,'CO0604',NULL,NULL,NULL,NULL,'fd','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-20 19:19:31','2021-10-20 19:19:31'),(2066,9,'customer',NULL,'Dilip Das','general',0,NULL,'CO0605',NULL,NULL,NULL,NULL,'fd','f',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-22 14:52:49','2021-10-22 14:52:49'),(2067,9,'customer',NULL,'Mohsin Alam','general',0,NULL,'CO0606',NULL,NULL,NULL,NULL,'fd','df',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23 20:04:31','2021-10-23 20:04:31'),(2068,9,'customer',NULL,'Roman vai','general',0,NULL,'CO0607',NULL,NULL,NULL,NULL,NULL,'01713578767',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-23 20:28:46','2021-10-23 20:28:46'),(2069,9,'supplier','Stove','Janata Filter & Iron Ind.','general',0,NULL,'CO0608',NULL,NULL,NULL,NULL,'Dhaka','01726093632',NULL,'01710908468',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-24 13:40:16','2021-10-24 13:40:16'),(2071,11,'customer',NULL,'Walk-In Customer','',0,NULL,'CO0001',NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,NULL,43,1,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(2072,9,'supplier','Future Business Vision','Jakir Hossain','general',0,'Jakirfbv@gmail.com','CO0609',NULL,'Dhaka',NULL,'Bangladesh',NULL,'01611255545',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20 20:54:58','2021-11-20 20:54:58'),(2073,9,'customer',NULL,'Lab Aid Ltd','general',0,'Jakirfbv@gmail.com','0161','0125','Dhaka',NULL,'Bangladesh',NULL,'012',NULL,NULL,NULL,'months',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20 21:22:14','2021-11-20 21:22:14'),(2074,9,'customer',NULL,'Squair Hospital Ltd','general',0,NULL,'02',NULL,NULL,NULL,NULL,NULL,'01658',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20 21:22:47','2021-11-20 21:22:47'),(2075,9,'supplier','Usd','US Country','general',0,NULL,'CO0612',NULL,NULL,NULL,NULL,NULL,'0152',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-20 21:24:00','2021-11-20 21:24:00'),(2076,9,'supplier','abc','abc','general',0,NULL,'CO0613',NULL,NULL,NULL,NULL,NULL,'4554645',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23 16:26:08','2021-11-23 16:26:08'),(2077,9,'customer',NULL,'nipu','general',0,NULL,'CO0614',NULL,NULL,NULL,NULL,NULL,'0145645545',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23 16:27:11','2021-11-23 16:27:11'),(2078,9,'customer',NULL,'sarowar','general',0,NULL,'CO0615',NULL,NULL,NULL,NULL,NULL,'445545',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-11-23 16:49:55','2021-11-23 16:49:55'),(2079,9,'supplier','Garments','Mayer Doya Burka House','reseller',0,NULL,'44',NULL,NULL,NULL,NULL,NULL,'364764785',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-04 16:31:34','2021-12-04 16:31:34'),(2080,9,'customer',NULL,'sarowar Khan','general',0,NULL,'CO0617',NULL,NULL,NULL,NULL,NULL,'01715665545',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-11 10:07:35','2021-12-11 10:07:35'),(2081,9,'customer',NULL,'Enamul Vai','general',0,NULL,'CO0618',NULL,NULL,NULL,NULL,NULL,'23456789',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14 09:09:24','2021-12-14 09:09:24'),(2082,9,'customer',NULL,'najrul','general',0,NULL,'CO0619',NULL,NULL,NULL,NULL,NULL,'0000088756789',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2021-12-14 09:22:18','2021-12-14 09:22:18'),(2083,9,'supplier','XYZ','Mr. Marof','general',0,NULL,'CO0620',NULL,NULL,NULL,NULL,NULL,'01712842729',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-11 08:25:51','2022-01-11 08:25:51'),(2084,9,'supplier','Winner','Winner','general',0,NULL,'CO0621',NULL,NULL,NULL,NULL,NULL,'01723629667',NULL,NULL,7,'days',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-13 15:41:56','2022-01-13 15:41:56'),(2085,9,'supplier','CHAITY FASHION','CHAITY','general',0,NULL,'CO0622',NULL,NULL,NULL,NULL,NULL,'01919974962',NULL,NULL,10000,'months',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-01-15 17:54:18','2022-01-15 17:54:18'),(2086,9,'customer',NULL,'Sobuj ( Aarong Plus)','general',0,NULL,'192',NULL,NULL,NULL,NULL,NULL,'01715164383',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-12 05:28:28','2022-02-12 05:28:28'),(2087,9,'supplier','Yasin','Yangun1','general',0,'test1@yahoo.com','1','1','yangun','yangun city','Manyanmer',NULL,'01712005379',NULL,'01713380034',NULL,'months',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-16 08:50:28','2022-02-16 08:50:28'),(2088,9,'customer',NULL,'southeast','general',0,NULL,'CO0625',NULL,NULL,NULL,NULL,NULL,'45678',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20 08:35:14','2022-02-20 08:35:14'),(2089,9,'supplier','Plotter','Plotter Technology','general',0,NULL,'CO0626',NULL,NULL,NULL,NULL,NULL,'67890',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20 10:27:17','2022-02-20 10:27:17'),(2090,9,'supplier','MODINA AUTO','MR. RAHAD','general',0,'m.rahman@aamra.com.bd','01713082779',NULL,'JOSSEOR','Choose your State or Province below:','Bangladesh',NULL,'01713082779',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-20 23:58:12','2022-02-20 23:58:12'),(2091,9,'supplier','AL-SALAUDDIN INTERNATIONAL','MR. SALAUDDIN','general',0,'shisir1118@yahoo.com','01713082778',NULL,'Dhaka','Choose your State or Province below:','Bangladesh',NULL,'01713082778',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21 00:00:06','2022-02-21 00:00:06'),(2092,9,'customer',NULL,'MOON AUTO HOUSE','general',0,'m.rahman@aamra.com.bd','01713082772',NULL,'BHOLA SADAR','Choose your State or Province below:','Bangladesh',NULL,'+8801713082772',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21 00:01:38','2022-02-21 00:01:38'),(2093,9,'customer',NULL,'JOHIR AUTO','general',0,NULL,'01713082771',NULL,'BHOLA SADAR',NULL,NULL,NULL,'01713082771',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-21 00:03:17','2022-02-21 00:03:17'),(2094,9,'supplier','Al-Hera Treading','Md Jahid','general',0,NULL,'01711946398',NULL,'Nowgaon','Nowgaon','Bangladesh',NULL,'017119468398',NULL,NULL,NULL,'months',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-02-23 05:25:25','2022-02-23 05:25:25'),(2095,9,'supplier','abcde','abcde','general',0,NULL,'CO0632',NULL,NULL,NULL,NULL,NULL,'3456789',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31 03:13:56','2022-03-31 03:13:56'),(2096,9,'customer',NULL,'anuwar','general',0,NULL,'CO0633',NULL,NULL,NULL,NULL,NULL,'12348778',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-03-31 03:22:36','2022-03-31 03:22:36'),(2097,9,'supplier','abo bakkor','abo bakkor','general',0,NULL,'CO0634',NULL,NULL,NULL,NULL,NULL,'789',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12 04:34:06','2022-04-12 04:34:06'),(2098,9,'supplier','arif','arif hossain','general',0,NULL,'CO0635',NULL,NULL,NULL,NULL,NULL,'015425',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-12 04:55:09','2022-04-12 04:55:09'),(2099,9,'customer',NULL,'Arif Hossain','general',0,NULL,'CO0636',NULL,NULL,NULL,NULL,NULL,'015425',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-04-23 03:43:20','2022-04-23 03:43:20'),(2100,9,'supplier','MBT','MBT','general',0,NULL,'CO0637',NULL,NULL,NULL,NULL,NULL,'01914582818',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06 02:09:21','2022-06-06 02:09:21'),(2101,9,'supplier','Kids','Mohammed','general',0,NULL,'1234',NULL,NULL,NULL,NULL,NULL,'01953536',NULL,NULL,NULL,'months',NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06 05:44:12','2022-06-06 05:44:12'),(2102,9,'supplier','প্যান্ট','মেসার্স আলিফ এন্টারপ্রাইজ-১/২','general',0,NULL,'CO0639',NULL,NULL,NULL,NULL,NULL,'0191543',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-06 14:52:11','2022-06-06 14:52:11'),(2103,9,'customer',NULL,'zobaidur','general',0,'julfikar422@gmail.com','CO0640','1','bangladesh',NULL,NULL,NULL,'01721635708',NULL,NULL,NULL,'days',2.00,36,0,1,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22 15:18:12','2022-06-22 15:18:12'),(2104,9,'customer',NULL,'zulfikar','general',0,'dhakabangladesh@gimail.com','CO0641','2','bangladesh',NULL,NULL,NULL,'01723202316',NULL,NULL,1,'days',3.00,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2022-06-22 15:19:57','2022-06-22 15:19:57'),(2105,9,'customer',NULL,'shorab','reseller',0,NULL,'123',NULL,NULL,NULL,NULL,NULL,'01721635708',NULL,NULL,NULL,'months',2.00,36,0,1,NULL,NULL,NULL,NULL,0,NULL,'2022-07-26 13:27:50','2022-07-26 13:27:50'),(2106,9,'supplier','sopno','md rezwan','general',0,NULL,'CO0643',NULL,NULL,NULL,'bangladesh',NULL,'01738835669',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-13 06:34:53','2023-03-13 06:34:53'),(2107,9,'supplier','fruit','i am ok','general',0,NULL,'001122','0022','সাভার,','ঢাকা -১৩৪৯','বাংলাদেশ','শিমুলতলা, (জামগড়া ফ্যান্টাসী কিংডমের থেকে ২০০ গজ পশ্চিমে)  আশুলিয়া,','01846682546',NULL,'01754143555',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14 04:56:46','2023-03-14 04:56:46'),(2108,9,'customer',NULL,'i am done','general',0,NULL,'003344',NULL,'Kishoregonj','ঢাকা -১৩৪৯','বাংলাদেশ','Al- Amin Super Market 2nd Floor, College Road, Beanibazar,','01727191151',NULL,'01754143555',NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-14 04:59:29','2023-03-14 04:59:29'),(2109,9,'customer',NULL,'COLOR','general',0,NULL,'001',NULL,'সাভার,','ঢাকা -১৩৪৯','বাংলাদেশ','শিমুলতলা, (জামগড়া ফ্যান্টাসী কিংডমের থেকে ২০০ গজ পশ্চিমে)  আশুলিয়া,','01700-800653',NULL,NULL,NULL,NULL,1000000.00,36,0,NULL,NULL,NULL,NULL,NULL,5,NULL,'2023-03-14 05:10:06','2023-03-14 05:10:06'),(2110,9,'supplier','baki khai','korim','general',0,NULL,'CO0647',NULL,NULL,NULL,NULL,NULL,'01798563856',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15 17:09:12','2023-03-15 17:09:12'),(2111,9,'customer',NULL,'rohim','general',0,NULL,'CO0648',NULL,NULL,NULL,NULL,NULL,'01745862583',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-15 17:10:12','2023-03-15 17:10:12'),(2112,9,'customer',NULL,'korim','general',0,NULL,'125','1256',NULL,NULL,NULL,NULL,'01745862583',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,5,NULL,'2023-03-16 03:00:25','2023-03-16 03:00:25'),(2113,9,'customer',NULL,'korim','general',0,NULL,'CO0650','1256',NULL,NULL,NULL,NULL,'01745862583',NULL,NULL,NULL,NULL,NULL,36,0,3,NULL,NULL,NULL,NULL,5,NULL,'2023-03-16 03:29:12','2023-03-16 03:29:12'),(2114,9,'customer',NULL,'rohim','general',0,NULL,'CO0651',NULL,NULL,NULL,NULL,NULL,'01745862583',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-16 03:41:06','2023-03-16 03:41:06'),(2115,9,'supplier','my','alom','general',0,NULL,'CO0652',NULL,NULL,NULL,NULL,NULL,'097652456',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-23 04:14:00','2023-03-23 04:14:00'),(2116,9,'supplier','ma electronics','MD REZWAN','general',0,NULL,'CO0653',NULL,NULL,NULL,NULL,NULL,'01317804633',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29 03:05:03','2023-03-29 03:05:03'),(2117,9,'customer',NULL,'roton','general',0,NULL,'CO0654',NULL,NULL,NULL,NULL,NULL,'01317804655',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-29 03:06:08','2023-03-29 03:06:08'),(2118,9,'supplier','ma electronics','rohomot','general',0,NULL,'CO0655',NULL,NULL,NULL,NULL,NULL,'01317804633',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-03-30 03:13:39','2023-03-30 03:13:39'),(2119,9,'supplier','Shine international','shine','general',0,NULL,'CO0656',NULL,NULL,NULL,NULL,NULL,'01850249235',NULL,NULL,NULL,NULL,NULL,36,0,NULL,NULL,NULL,NULL,NULL,0,NULL,'2023-06-01 09:07:41','2023-06-01 09:07:41');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHC','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MX','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NG','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
INSERT INTO `customer_groups` VALUES (1,9,'green',0.00,36,'2021-09-04 16:12:17','2021-09-04 16:12:17'),(2,9,'Adams green',1.00,36,'2022-02-16 08:53:35','2022-02-16 08:53:35'),(3,9,'white',5.00,36,'2023-03-16 03:17:16','2023-03-16 03:17:16');
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `customer_id` varchar(10) NOT NULL,
  `product_id` int(10) NOT NULL,
  `discount_type` varchar(20) NOT NULL,
  `discount_amount` int(10) NOT NULL,
  `unit_price` double NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount` WRITE;
/*!40000 ALTER TABLE `discount` DISABLE KEYS */;
INSERT INTO `discount` VALUES (1,'43',1662,'percentage',200,-2460,NULL,'2022-01-15 20:07:21','2022-01-15 20:07:21');
/*!40000 ALTER TABLE `discount` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dish_raw_item_relation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dish_raw_item_relation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dish_id` int(11) NOT NULL,
  `raw_item_id` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dish_raw_item_relation` WRITE;
/*!40000 ALTER TABLE `dish_raw_item_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `dish_raw_item_relation` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES (1,'Office Expenses',1,NULL,NULL,'2020-10-06 18:43:55','2020-10-06 18:43:55'),(2,'Store Expense',9,'store',NULL,'2021-05-28 14:22:29','2021-10-03 13:40:27'),(3,'Buisness Expenses',9,'expense b',NULL,'2021-08-14 21:57:17','2021-08-14 21:57:17'),(4,'PRODUCT PURCHASE',9,'DUE',NULL,'2022-01-15 18:18:28','2022-01-15 18:18:28'),(5,'PRODUCT PURCHASE',9,'DUE',NULL,'2022-01-15 18:18:28','2022-01-15 18:18:28'),(6,'Laber Bill',9,NULL,NULL,'2022-04-16 04:17:30','2022-04-16 04:17:30');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hrm_attendence`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrm_attendence` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `e_id` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hrm_attendence` WRITE;
/*!40000 ALTER TABLE `hrm_attendence` DISABLE KEYS */;
/*!40000 ALTER TABLE `hrm_attendence` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hrm_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrm_employees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `image` varchar(255) NOT NULL,
  `father_name` varchar(255) NOT NULL,
  `dob` date DEFAULT NULL,
  `gender` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `p_address` varchar(255) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `department` varchar(255) NOT NULL,
  `designation` varchar(255) NOT NULL,
  `doj` date NOT NULL,
  `exit_date` date DEFAULT NULL,
  `status` varchar(255) NOT NULL,
  `salary` double NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hrm_employees` WRITE;
/*!40000 ALTER TABLE `hrm_employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `hrm_employees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hrm_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hrm_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `amount` double NOT NULL,
  `e_id` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hrm_transactions` WRITE;
/*!40000 ALTER TABLE `hrm_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `hrm_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `installments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `installments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `contact_id` int(4) DEFAULT NULL,
  `amount` decimal(20,2) NOT NULL,
  `payable_date` date NOT NULL,
  `status` int(11) NOT NULL,
  `sms_send` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `installments` WRITE;
/*!40000 ALTER TABLE `installments` DISABLE KEYS */;
INSERT INTO `installments` VALUES (1,11,1464,500.00,'2021-05-30',1,NULL,NULL,NULL),(2,11,1464,5000.00,'2021-06-04',0,NULL,NULL,NULL),(3,11,1464,500.00,'2021-07-30',0,NULL,NULL,NULL),(4,11,1464,2000.00,'2021-05-31',0,NULL,NULL,NULL),(5,30,1463,10000.00,'2021-06-01',1,NULL,NULL,NULL),(6,30,1463,13030.00,'2021-07-01',0,NULL,NULL,NULL),(7,47,1466,5000.00,'2021-06-10',1,NULL,NULL,NULL),(8,47,1466,19500.00,'2021-06-30',0,NULL,NULL,NULL),(9,818,1965,500.00,'2021-09-09',1,NULL,NULL,NULL),(10,818,1965,500.00,'2021-09-09',1,NULL,NULL,NULL),(11,779,1855,1000.00,'2021-10-10',0,NULL,NULL,NULL),(12,779,1855,1000.00,'2021-10-05',0,1,NULL,NULL),(13,787,1961,5000.00,'2021-10-05',0,NULL,NULL,NULL),(14,787,1961,500.00,'2021-09-25',1,NULL,NULL,NULL),(15,846,1974,6000.00,'2021-09-15',1,NULL,NULL,NULL),(16,841,1973,5000.00,'2021-09-30',1,NULL,NULL,NULL),(17,841,1973,10000.00,'2021-10-15',0,NULL,NULL,NULL),(18,841,1973,5000.00,'2021-09-30',1,NULL,NULL,NULL),(19,841,1973,5000.00,'2021-09-30',1,NULL,NULL,NULL),(20,841,1973,10000.00,'2021-10-15',0,NULL,NULL,NULL),(21,846,1974,16000.00,'2021-09-30',1,NULL,NULL,NULL),(22,846,1974,5000.00,'2021-09-15',1,NULL,NULL,NULL),(23,846,1974,6000.00,'2021-09-30',1,NULL,NULL,NULL),(24,846,1974,10000.00,'2021-10-15',0,NULL,NULL,NULL),(25,846,1974,10000.00,'2021-10-30',0,NULL,NULL,NULL),(26,846,1974,5000.00,'2021-10-10',1,NULL,NULL,NULL),(27,878,1981,500.00,'2021-09-15',1,NULL,NULL,NULL),(28,878,1981,1000.00,'2021-10-15',0,NULL,NULL,NULL),(29,879,1982,1700.00,'2021-10-15',0,NULL,NULL,NULL),(30,903,1889,2800.00,'2021-09-15',1,NULL,NULL,NULL),(31,910,1504,500.00,'2021-09-20',1,NULL,NULL,NULL),(32,910,1504,1000.00,'2021-09-30',1,NULL,NULL,NULL),(33,910,1504,1000.00,'2021-09-18',1,NULL,NULL,NULL),(34,910,1504,500.00,'2021-09-30',1,NULL,NULL,NULL),(35,846,1974,6000.00,'2021-09-30',1,NULL,NULL,NULL),(36,846,1974,6000.00,'2021-09-30',1,NULL,NULL,NULL),(37,1096,2012,250.00,'2021-10-15',0,NULL,NULL,NULL),(38,1096,2012,250.00,'2021-10-25',0,NULL,NULL,NULL),(39,1096,2012,250.00,'2021-10-01',1,NULL,NULL,NULL),(40,1096,2012,250.00,'2021-10-13',0,NULL,NULL,NULL),(41,1103,2012,1000.00,'2021-10-03',0,NULL,NULL,NULL),(42,1103,2012,180.00,'2021-10-21',0,NULL,NULL,NULL),(43,1130,2020,5000.00,'2021-10-15',0,NULL,NULL,NULL),(44,1130,2020,2000.00,'2021-10-30',0,NULL,NULL,NULL),(45,1130,2020,3000.00,'2021-11-10',0,NULL,NULL,NULL),(46,1121,2017,5000.00,'2021-10-10',1,NULL,NULL,NULL),(47,1121,2017,4000.00,'2021-10-08',1,NULL,NULL,NULL),(48,758,1497,500.00,'2021-10-12',1,1,NULL,NULL),(49,758,1497,500.00,'2021-10-15',1,NULL,NULL,NULL),(50,758,1497,500.00,'2021-10-11',1,1,NULL,NULL),(51,1232,1476,13700.00,'2021-10-15',0,1,NULL,NULL),(52,1031,2003,9700.00,'2021-10-25',1,NULL,NULL,NULL),(53,1031,2003,9700.00,'2021-10-25',0,NULL,NULL,NULL);
/*!40000 ALTER TABLE `installments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `design` varchar(256) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,1,'classic',NULL,NULL,NULL,NULL,'2018-04-04 03:35:32','2018-04-04 03:35:32'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,2,'classic',NULL,NULL,NULL,NULL,'2018-04-10 12:12:40','2018-04-10 12:12:40'),(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,3,'classic',NULL,NULL,NULL,NULL,'2018-04-10 14:46:16','2018-04-10 14:46:16'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,4,'classic',NULL,NULL,NULL,NULL,'2018-04-10 16:20:43','2018-04-10 16:20:43'),(5,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,5,'classic',NULL,NULL,NULL,NULL,'2018-07-13 20:42:11','2018-07-13 20:42:11'),(6,'4G FASHION HOUSE',NULL,'Invoice No.','Quotation No.','Invoice','M/s Chatkhil Rice Agency','Mohammadpur, Krishi Market, Dhaka',NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Total Due','Total Paid',1,NULL,NULL,'Date',1,0,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal','HSN','mUy0AJP6DyxvL04IsK0SCzgGGMBTzJ9yLlfP6REF.png',1,1,1,0,1,1,1,1,1,0,0,0,0,0,1,1,'Customer','#000000','<p style=\"text-align:center\">come back again thank you</p>',NULL,0,9,'classic','Credit Note','Ref. No.','Credit Amount',NULL,'2019-05-12 20:22:52','2022-04-20 05:01:32'),(8,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total','Total Due','Total Paid',0,NULL,NULL,'Date',1,0,1,1,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer','#000000','',NULL,1,11,'classic',NULL,NULL,NULL,NULL,'2021-10-27 00:35:53','2021-10-27 00:35:53');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (2,2,'Default','blank','AP',1,1327,4,1,'2018-04-10 12:12:40','2019-05-12 20:23:11'),(3,3,'Default','blank','AE',1,5,4,1,'2018-04-10 14:46:16','2018-04-10 15:54:16'),(4,4,'Default','blank','',1,8,4,1,'2018-04-10 16:20:43','2018-04-10 17:08:49'),(5,5,'Default','blank','',1,4,4,1,'2018-07-13 15:12:11','2018-07-13 06:16:36'),(7,1,'kmarket.com.bd','blank',NULL,0,1898,4,1,'2020-10-06 18:50:31','2022-08-17 05:14:17'),(9,11,'Default','blank','',1,0,4,1,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(10,9,'4G FASHION HOUSE','year',NULL,0,79,4,1,'2022-01-15 17:27:03','2023-06-16 09:07:25'),(11,9,'New Sales','blank','2023-03-13',5,0,5,0,'2023-03-13 12:23:08','2023-03-13 12:23:08'),(12,9,'Rezwan','year',NULL,1,0,5,0,'2023-03-16 03:33:05','2023-03-16 03:33:05'),(13,9,'Rezwan','blank',NULL,0,0,4,0,'2023-03-23 03:32:21','2023-03-23 03:32:21');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_dish_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_dish_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `dish_category_name` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_dish_category` WRITE;
/*!40000 ALTER TABLE `kitchen_dish_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `kitchen_dish_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_dish_list`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_dish_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `dis_name` varchar(255) NOT NULL,
  `dish_category_id` int(11) NOT NULL,
  `dish_type` varchar(255) NOT NULL,
  `dish_price` int(11) NOT NULL,
  `dish_availability` varchar(255) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_dish_list` WRITE;
/*!40000 ALTER TABLE `kitchen_dish_list` DISABLE KEYS */;
/*!40000 ALTER TABLE `kitchen_dish_list` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_raw_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_raw_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `raw_item_name` varchar(255) NOT NULL,
  `quantity` double NOT NULL,
  `raw_item_unit` int(10) NOT NULL,
  `raw_item_used_unit` int(10) NOT NULL,
  `raw_item_unit_price` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_raw_items` WRITE;
/*!40000 ALTER TABLE `kitchen_raw_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `kitchen_raw_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `kitchen_used_raw_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `kitchen_used_raw_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `dish_id` int(11) NOT NULL,
  `raw_item_id` int(11) NOT NULL,
  `used_quantity` int(11) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `kitchen_used_raw_items` WRITE;
/*!40000 ALTER TABLE `kitchen_used_raw_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `kitchen_used_raw_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_05_30_111350_create_installments_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,1,'App\\User'),(1,3,'App\\User'),(1,9,'App\\User'),(1,10,'App\\User'),(1,23,'App\\User'),(1,26,'App\\User'),(1,27,'App\\User'),(1,28,'App\\User'),(1,29,'App\\User'),(1,45,'App\\User'),(2,2,'App\\User'),(2,46,'App\\User'),(3,4,'App\\User'),(5,5,'App\\User'),(7,6,'App\\User'),(9,7,'App\\User'),(11,8,'App\\User'),(13,20,'App\\User'),(13,32,'App\\User'),(14,31,'App\\User'),(14,33,'App\\User'),(14,34,'App\\User'),(18,22,'App\\User'),(22,35,'App\\User'),(24,36,'App\\User'),(24,47,'App\\User'),(25,37,'App\\User'),(25,41,'App\\User'),(26,38,'App\\User'),(26,40,'App\\User'),(28,42,'App\\User'),(29,43,'App\\User'),(29,47,'App\\User'),(30,48,'App\\User'),(33,43,'App\\User'),(36,45,'App\\User'),(37,44,'App\\User'),(37,46,'App\\User'),(38,39,'App\\User'),(46,48,'App\\User');
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (9,11,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {paid_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}','Thank you from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(10,11,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {paid_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {paid_amount}. {business_name}','Payment Received, from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(11,11,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}','Payment Reminder, from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(12,11,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}','Booking Confirmed - {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(13,11,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {invoice_number}. Kindly process the products as soon as possible. {business_name}','New Order, from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(14,11,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {invoice_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {invoice_number}.\n                    Kindly note it down. {business_name}','Payment Paid, from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(15,11,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {invoice_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {invoice_number}. Thank you for processing it. {business_name}','Items received, from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53'),(16,11,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {invoice_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {invoice_number} . Please process it as soon as possible.{business_name}','Items Pending, from {business_name}',0,0,'2021-10-27 00:35:53','2021-10-27 00:35:53');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(20,4) NOT NULL,
  `custom_permissions` longtext NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) DEFAULT NULL,
  `custom_link_text` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES (1,'Starter - Free','Give it a test drive...',1,2,1000,0,0,0,0,800,'months',1,10,0.0000,'',1,0,1,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:10:49'),(2,'Regular','For Small Shops',2,4,1000,0,0,0,0,800,'months',1,10,500.0000,'',1,1,1,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:12:30'),(3,'Unlimited','For Large Business',0,0,0,0,0,0,0,0,'months',1,10,1000.0000,'',1,1,1,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:13:50'),(4,'Business','For Small & Growing Shops...',10,10,15000,0,0,0,0,1000,'months',1,10,2000.0000,'',1,5,0,0,0,0,NULL,NULL,NULL,'2018-12-10 02:00:06','2018-08-02 00:16:14');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
INSERT INTO `password_resets` VALUES ('leepooh@kmarket.com.bd','$2y$10$ynNT7O3txi7W/IU./znSXOdQooOobGrjgMHIxJhr5KjFYthMGqrCK','2020-10-15 20:43:08');
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2018-12-10 02:00:04',NULL),(2,'direct_sell.access','web','2018-12-10 02:00:04',NULL),(3,'product.opening_stock','web','2018-12-10 02:00:05','2018-12-10 02:00:05'),(4,'crud_all_bookings','web','2018-12-10 02:00:05','2018-12-10 02:00:05'),(5,'crud_own_bookings','web','2018-12-10 02:00:05','2018-12-10 02:00:05'),(6,'access_default_selling_price','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(7,'purchase.payments','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(8,'sell.payments','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(9,'edit_product_price_from_sale_screen','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(10,'edit_product_discount_from_sale_screen','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(11,'roles.view','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(12,'roles.create','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(13,'roles.update','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(14,'roles.delete','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(15,'woocommerce.syc_categories','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(16,'woocommerce.sync_products','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(17,'woocommerce.sync_orders','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(18,'woocommerce.map_tax_rates','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(19,'woocommerce.access_woocommerce_api_settings','web','2018-12-10 02:00:06','2018-12-10 02:00:06'),(20,'user.view','web','2018-12-10 02:00:06',NULL),(21,'user.create','web','2018-12-10 02:00:06',NULL),(22,'user.update','web','2018-12-10 02:00:06',NULL),(23,'user.delete','web','2018-12-10 02:00:06',NULL),(24,'supplier.view','web','2018-12-10 02:00:06',NULL),(25,'supplier.create','web','2018-12-10 02:00:06',NULL),(26,'supplier.update','web','2018-12-10 02:00:06',NULL),(27,'supplier.delete','web','2018-12-10 02:00:06',NULL),(28,'customer.view','web','2018-12-10 02:00:06',NULL),(29,'customer.create','web','2018-12-10 02:00:06',NULL),(30,'customer.update','web','2018-12-10 02:00:06',NULL),(31,'customer.delete','web','2018-12-10 02:00:06',NULL),(32,'product.view','web','2018-12-10 02:00:06',NULL),(33,'product.create','web','2018-12-10 02:00:06',NULL),(34,'product.update','web','2018-12-10 02:00:06',NULL),(35,'product.delete','web','2018-12-10 02:00:06',NULL),(36,'purchase.view','web','2018-12-10 02:00:06',NULL),(37,'purchase.create','web','2018-12-10 02:00:06',NULL),(38,'purchase.update','web','2018-12-10 02:00:06',NULL),(39,'purchase.delete','web','2018-12-10 02:00:06',NULL),(40,'sell.view','web','2018-12-10 02:00:06',NULL),(41,'sell.create','web','2018-12-10 02:00:06',NULL),(42,'sell.update','web','2018-12-10 02:00:06',NULL),(43,'sell.delete','web','2018-12-10 02:00:06',NULL),(44,'purchase_n_sell_report.view','web','2018-12-10 02:00:06',NULL),(45,'contacts_report.view','web','2018-12-10 02:00:06',NULL),(46,'stock_report.view','web','2018-12-10 02:00:06',NULL),(47,'tax_report.view','web','2018-12-10 02:00:06',NULL),(48,'trending_product_report.view','web','2018-12-10 02:00:06',NULL),(49,'register_report.view','web','2018-12-10 02:00:06',NULL),(50,'sales_representative.view','web','2018-12-10 02:00:06',NULL),(51,'expense_report.view','web','2018-12-10 02:00:06',NULL),(52,'business_settings.access','web','2018-12-10 02:00:06',NULL),(53,'barcode_settings.access','web','2018-12-10 02:00:06',NULL),(54,'invoice_settings.access','web','2018-12-10 02:00:06',NULL),(55,'brand.view','web','2018-12-10 02:00:06',NULL),(56,'brand.create','web','2018-12-10 02:00:06',NULL),(57,'brand.update','web','2018-12-10 02:00:06',NULL),(58,'brand.delete','web','2018-12-10 02:00:06',NULL),(59,'tax_rate.view','web','2018-12-10 02:00:06',NULL),(60,'tax_rate.create','web','2018-12-10 02:00:06',NULL),(61,'tax_rate.update','web','2018-12-10 02:00:06',NULL),(62,'tax_rate.delete','web','2018-12-10 02:00:06',NULL),(63,'unit.view','web','2018-12-10 02:00:06',NULL),(64,'unit.create','web','2018-12-10 02:00:06',NULL),(65,'unit.update','web','2018-12-10 02:00:06',NULL),(66,'unit.delete','web','2018-12-10 02:00:06',NULL),(67,'category.view','web','2018-12-10 02:00:06',NULL),(68,'category.create','web','2018-12-10 02:00:06',NULL),(69,'category.update','web','2018-12-10 02:00:06',NULL),(70,'category.delete','web','2018-12-10 02:00:06',NULL),(71,'expense.access','web','2018-12-10 02:00:06',NULL),(72,'access_all_locations','web','2018-12-10 02:00:06',NULL),(73,'dashboard.data','web','2018-12-10 02:00:06',NULL),(74,'location.1','web','2018-12-10 02:00:06',NULL),(75,'location.2','web','2018-12-10 02:00:06',NULL),(76,'location.3','web','2018-12-10 02:00:06',NULL),(77,'location.4','web','2018-12-10 02:00:07',NULL),(78,'location.5','web','2018-12-10 02:00:07',NULL),(79,'location.6','web','2018-12-17 08:17:40','2018-12-17 08:17:40'),(81,'report-supplier.view','web',NULL,NULL),(82,'tbbank.view','web',NULL,NULL),(83,'tbbank.create','web',NULL,NULL),(84,'tbbank.update','web',NULL,NULL),(85,'tbbank.delete','web',NULL,NULL),(86,'tbpersonal.view','web',NULL,NULL),(87,'tbpersonal.create','web',NULL,NULL),(88,'tbpersonal.update','web',NULL,NULL),(89,'tbpersonal.delete','web',NULL,NULL),(90,'rbbank.view','web',NULL,NULL),(91,'rbbank.create','web',NULL,NULL),(92,'rbbank.update','web',NULL,NULL),(93,'rbbank.delete','web',NULL,NULL),(94,'rbpersonal.view','web',NULL,NULL),(95,'rbpersonal.create','web',NULL,NULL),(96,'rbpersonal.update','web',NULL,NULL),(97,'rbpersonal.delete','web',NULL,NULL),(98,'ibuser.view','web',NULL,NULL),(99,'ibuser.create','web',NULL,NULL),(100,'ibuser.update','web',NULL,NULL),(101,'ibuser.delete','web',NULL,NULL),(102,'ibtransaction.view','web',NULL,NULL),(103,'ibtransaction.create','web',NULL,NULL),(104,'ibtransaction.update','web',NULL,NULL),(105,'ibtransaction.delete','web',NULL,NULL),(106,'ibcategory.view','web',NULL,NULL),(107,'ibcategory.create','web',NULL,NULL),(108,'ibcategory.update','web',NULL,NULL),(109,'ibcategory.delete','web',NULL,NULL),(110,'ikritem.view','web',NULL,NULL),(111,'ikritem.create','web',NULL,NULL),(112,'ikritem.update','web',NULL,NULL),(113,'ikritem.delete','web',NULL,NULL),(114,'ikdcategory.view','web',NULL,NULL),(115,'ikdcategory.create','web',NULL,NULL),(116,'ikdcategory.update','web',NULL,NULL),(117,'ikdcategory.delete','web',NULL,NULL),(118,'ikdlist.view','web',NULL,NULL),(119,'ikdlist.create','web',NULL,NULL),(120,'ikdlist.update','web',NULL,NULL),(121,'ikdlist.delete','web',NULL,NULL),(122,'location.7','web','2019-02-11 11:34:36','2019-02-11 11:34:36'),(123,'hrm_employyes.view','web',NULL,NULL),(124,'hrm_employyes.create','web',NULL,NULL),(125,'hrm_employyes.update','web',NULL,NULL),(126,'hrm_employyes.delete','web',NULL,NULL),(127,'hrm_transaction.view','web',NULL,NULL),(128,'hrm_transaction.create','web',NULL,NULL),(129,'hrm_transaction.update','web',NULL,NULL),(130,'hrm_transaction.delete','web',NULL,NULL),(131,'hrm_attendence.view','web',NULL,NULL),(132,'hrm_attendence.create','web',NULL,NULL),(133,'hrm_attendence.update','web',NULL,NULL),(134,'hrm_attendence.delete','web',NULL,NULL),(135,'warranty_supplier.view','web',NULL,NULL),(136,'warranty_supplier.create','web',NULL,NULL),(137,'warranty_supplier.update','web',NULL,NULL),(138,'warranty_supplier.delete','web',NULL,NULL),(139,'warranty_customer.view','web',NULL,NULL),(140,'warranty_customer.create','web',NULL,NULL),(141,'warranty_customer.update','web',NULL,NULL),(142,'warranty_customer.delete','web',NULL,NULL),(143,'location.8','web','2019-04-08 11:20:36','2019-04-08 11:20:36'),(144,'warranty_check.view','web',NULL,NULL),(145,'warranty_check.create','web',NULL,NULL),(146,'location.9','web','2019-04-22 20:06:41','2019-04-22 20:06:41'),(152,'supplier_report.view','web',NULL,NULL),(153,'selling_price_group.3','web','2020-01-01 19:12:34','2020-01-01 19:12:34'),(154,'location.10','web','2020-01-01 19:17:22','2020-01-01 19:17:22'),(155,'selling_price_group.1','web','2020-03-07 19:12:34','2020-03-07 19:12:34'),(156,'selling_price_group.2','web','2020-10-31 03:31:40','2020-10-31 03:31:40'),(157,'supplier_wise.detail_stock','web',NULL,NULL),(158,'supplier_wise.sell_summery','web',NULL,NULL),(159,'supplier_wise.stock','web',NULL,NULL),(160,'supplier_wise.sale','web',NULL,NULL),(161,'sale.replace','web',NULL,NULL),(162,'location.11','web','2021-10-27 00:35:53','2021-10-27 00:35:53'),(163,'location.12','web','2021-11-20 21:25:58','2021-11-20 21:25:58'),(164,'location.13','web','2022-01-15 17:24:01','2022-01-15 17:24:01'),(165,'selling_price_group.4','web','2022-12-27 09:43:48','2022-12-27 09:43:48'),(166,'selling_price_group.5','web','2023-01-01 03:28:23','2023-01-01 03:28:23');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `physical_stock_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `physical_stock_histories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `physical_qty` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `current_stock` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `physical_stock_histories` WRITE;
/*!40000 ALTER TABLE `physical_stock_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `physical_stock_histories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(256) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `file` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_images` WRITE;
/*!40000 ALTER TABLE `product_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES (1,9,9,922,NULL,NULL,NULL,'2021-05-28 13:22:29','2021-05-28 13:22:29'),(2,9,9,841,NULL,NULL,NULL,'2021-05-30 19:14:28','2021-05-30 19:14:28'),(3,9,9,1367,NULL,NULL,NULL,'2021-05-30 19:14:57','2021-06-01 21:54:03'),(4,9,9,1368,NULL,NULL,NULL,'2021-05-30 19:14:58','2021-05-30 19:14:58'),(5,9,9,1346,NULL,NULL,NULL,'2021-06-05 16:02:05','2021-06-05 16:02:05'),(6,9,9,1089,NULL,NULL,NULL,'2021-06-05 16:02:25','2021-06-05 16:02:25'),(7,9,9,1687,NULL,NULL,NULL,'2022-03-31 03:10:24','2022-03-31 03:10:24'),(8,9,12,1687,NULL,NULL,NULL,'2022-03-31 03:10:24','2022-03-31 03:10:24'),(9,9,13,1687,NULL,NULL,NULL,'2022-03-31 03:10:24','2022-03-31 03:10:24'),(10,9,9,1688,NULL,NULL,NULL,'2022-04-12 04:32:21','2022-04-23 03:49:37'),(11,9,12,1688,NULL,NULL,NULL,'2022-04-12 04:32:21','2022-04-23 03:49:37'),(12,9,13,1688,NULL,NULL,NULL,'2022-04-12 04:32:21','2022-04-23 03:49:37'),(13,9,9,1689,NULL,NULL,NULL,'2022-04-12 04:38:09','2022-04-12 04:44:46'),(14,9,12,1689,NULL,NULL,NULL,'2022-04-12 04:38:09','2022-04-12 04:44:46'),(15,9,13,1689,NULL,NULL,NULL,'2022-04-12 04:38:09','2022-04-12 04:44:46'),(16,9,9,1690,NULL,NULL,NULL,'2022-04-12 04:52:25','2022-04-12 04:52:25'),(17,9,12,1690,NULL,NULL,NULL,'2022-04-12 04:52:25','2022-04-12 04:52:25'),(18,9,13,1690,NULL,NULL,NULL,'2022-04-12 04:52:25','2022-04-12 04:52:25'),(19,9,9,1691,NULL,NULL,NULL,'2022-04-13 06:58:18','2022-04-13 06:58:18'),(20,9,12,1691,NULL,NULL,NULL,'2022-04-13 06:58:18','2022-04-13 06:58:18'),(21,9,13,1691,NULL,NULL,NULL,'2022-04-13 06:58:18','2022-04-13 06:58:18'),(22,9,9,1692,NULL,NULL,NULL,'2022-04-20 05:11:01','2022-04-20 05:11:01'),(23,9,12,1692,NULL,NULL,NULL,'2022-04-20 05:11:01','2022-04-20 05:11:01'),(24,9,13,1692,NULL,NULL,NULL,'2022-04-20 05:11:01','2022-04-20 05:11:01'),(25,9,9,428,NULL,NULL,NULL,'2022-04-23 03:45:05','2022-04-23 03:45:05'),(26,9,12,428,NULL,NULL,NULL,'2022-04-23 03:45:05','2022-04-23 03:45:05'),(27,9,13,428,NULL,NULL,NULL,'2022-04-23 03:45:05','2022-04-23 03:45:05'),(28,9,9,1693,NULL,NULL,NULL,'2022-05-31 12:45:19','2022-05-31 12:45:19'),(29,9,12,1693,NULL,NULL,NULL,'2022-05-31 12:45:19','2022-05-31 12:45:19'),(30,9,13,1693,NULL,NULL,NULL,'2022-05-31 12:45:19','2022-05-31 12:45:19'),(31,9,9,1694,NULL,NULL,NULL,'2022-06-06 02:08:25','2022-06-06 02:08:25'),(32,9,12,1694,NULL,NULL,NULL,'2022-06-06 02:08:25','2022-06-06 02:08:25'),(33,9,13,1694,NULL,NULL,NULL,'2022-06-06 02:08:25','2022-06-06 02:08:25'),(34,9,9,1695,NULL,NULL,NULL,'2022-06-06 14:22:18','2022-06-06 14:22:18'),(35,9,12,1695,NULL,NULL,NULL,'2022-06-06 14:22:18','2022-06-06 14:22:18'),(36,9,13,1695,NULL,NULL,NULL,'2022-06-06 14:22:18','2022-06-06 14:22:18'),(37,9,9,1696,NULL,NULL,NULL,'2022-06-19 05:38:12','2022-06-19 05:38:12'),(38,9,12,1696,NULL,NULL,NULL,'2022-06-19 05:38:12','2022-06-19 05:38:12'),(39,9,13,1696,NULL,NULL,NULL,'2022-06-19 05:38:12','2022-06-19 05:38:12'),(40,9,9,1697,NULL,NULL,NULL,'2022-06-28 10:40:15','2022-06-28 10:40:15'),(41,9,12,1697,NULL,NULL,NULL,'2022-06-28 10:40:15','2022-06-28 10:40:15'),(42,9,13,1697,NULL,NULL,NULL,'2022-06-28 10:40:15','2022-06-28 10:40:15'),(43,9,9,1705,NULL,NULL,NULL,'2023-03-13 06:15:59','2023-03-13 06:15:59'),(44,9,12,1705,NULL,NULL,NULL,'2023-03-13 06:15:59','2023-03-13 06:15:59'),(45,9,13,1705,NULL,NULL,NULL,'2023-03-13 06:15:59','2023-03-13 06:15:59'),(46,9,9,1706,NULL,NULL,NULL,'2023-03-13 06:26:36','2023-03-13 06:26:36'),(47,9,12,1706,NULL,NULL,NULL,'2023-03-13 06:26:36','2023-03-13 06:26:36'),(48,9,13,1706,NULL,NULL,NULL,'2023-03-13 06:26:36','2023-03-13 06:26:36'),(49,9,9,1707,NULL,NULL,NULL,'2023-03-13 12:00:18','2023-03-13 12:00:18'),(50,9,12,1707,NULL,NULL,NULL,'2023-03-13 12:00:18','2023-03-13 12:00:18'),(51,9,13,1707,NULL,NULL,NULL,'2023-03-13 12:00:18','2023-03-13 12:00:18'),(52,9,9,1708,NULL,NULL,NULL,'2023-03-14 03:43:11','2023-03-14 03:43:11'),(53,9,12,1708,NULL,NULL,NULL,'2023-03-14 03:43:11','2023-03-14 03:43:11'),(54,9,13,1708,NULL,NULL,NULL,'2023-03-14 03:43:11','2023-03-14 03:43:11'),(55,9,9,1709,NULL,NULL,NULL,'2023-03-14 04:07:40','2023-03-14 04:07:40'),(56,9,12,1709,NULL,NULL,NULL,'2023-03-14 04:07:40','2023-03-14 04:07:40'),(57,9,13,1709,NULL,NULL,NULL,'2023-03-14 04:07:40','2023-03-14 04:07:40'),(58,9,9,1711,NULL,NULL,NULL,'2023-03-14 13:07:05','2023-03-14 13:07:05'),(59,9,12,1711,NULL,NULL,NULL,'2023-03-14 13:07:05','2023-03-14 13:07:05'),(60,9,13,1711,NULL,NULL,NULL,'2023-03-14 13:07:05','2023-03-14 13:07:05'),(61,9,9,1712,NULL,NULL,NULL,'2023-03-15 17:05:15','2023-03-15 17:05:15'),(62,9,12,1712,NULL,NULL,NULL,'2023-03-15 17:05:15','2023-03-15 17:05:15'),(63,9,13,1712,NULL,NULL,NULL,'2023-03-15 17:05:15','2023-03-15 17:05:15'),(64,9,9,1714,NULL,NULL,NULL,'2023-03-16 04:02:18','2023-03-16 04:02:18'),(65,9,12,1714,NULL,NULL,NULL,'2023-03-16 04:02:18','2023-03-16 04:02:18'),(66,9,13,1714,NULL,NULL,NULL,'2023-03-16 04:02:18','2023-03-16 04:02:18'),(67,9,9,1715,NULL,NULL,NULL,'2023-03-16 05:31:28','2023-03-16 05:31:28'),(68,9,12,1715,NULL,NULL,NULL,'2023-03-16 05:31:28','2023-03-16 05:31:28'),(69,9,13,1715,NULL,NULL,NULL,'2023-03-16 05:31:28','2023-03-16 05:31:28'),(70,9,9,1716,NULL,NULL,NULL,'2023-03-23 03:14:25','2023-03-23 03:14:25'),(71,9,12,1716,NULL,NULL,NULL,'2023-03-23 03:14:25','2023-03-23 03:14:25'),(72,9,13,1716,NULL,NULL,NULL,'2023-03-23 03:14:25','2023-03-23 03:14:25'),(73,9,9,1717,NULL,NULL,NULL,'2023-03-23 04:12:21','2023-03-23 04:12:21'),(74,9,12,1717,NULL,NULL,NULL,'2023-03-23 04:12:21','2023-03-23 04:12:21'),(75,9,13,1717,NULL,NULL,NULL,'2023-03-23 04:12:21','2023-03-23 04:12:21'),(76,9,9,1718,NULL,NULL,NULL,'2023-03-23 14:38:18','2023-03-23 14:38:18'),(77,9,12,1718,NULL,NULL,NULL,'2023-03-23 14:38:18','2023-03-23 14:38:18'),(78,9,13,1718,NULL,NULL,NULL,'2023-03-23 14:38:18','2023-03-23 14:38:18'),(79,9,9,1719,NULL,NULL,NULL,'2023-03-29 03:10:35','2023-03-29 03:10:35'),(80,9,12,1719,NULL,NULL,NULL,'2023-03-29 03:10:35','2023-03-29 03:10:35'),(81,9,13,1719,NULL,NULL,NULL,'2023-03-29 03:10:35','2023-03-29 03:10:35'),(82,9,9,1720,NULL,NULL,NULL,'2023-03-30 03:24:04','2023-03-30 03:24:04'),(83,9,12,1720,NULL,NULL,NULL,'2023-03-30 03:24:04','2023-03-30 03:24:04'),(84,9,13,1720,NULL,NULL,NULL,'2023-03-30 03:24:04','2023-03-30 03:24:04'),(85,9,9,1721,NULL,NULL,NULL,'2023-06-01 09:04:18','2023-06-01 09:04:18'),(86,9,12,1721,NULL,NULL,NULL,'2023-06-01 09:04:18','2023-06-01 09:04:18'),(87,9,13,1721,NULL,NULL,NULL,'2023-06-01 09:04:18','2023-06-01 09:04:18'),(88,9,9,1724,NULL,NULL,NULL,'2023-06-22 03:57:05','2023-06-22 03:57:05'),(89,9,12,1724,NULL,NULL,NULL,'2023-06-22 03:57:05','2023-06-22 03:57:05'),(90,9,13,1724,NULL,NULL,NULL,'2023-06-22 03:57:05','2023-06-22 03:57:05'),(91,9,9,1725,NULL,NULL,NULL,'2023-07-18 06:22:24','2023-07-18 06:22:24'),(92,9,12,1725,NULL,NULL,NULL,'2023-07-18 06:22:24','2023-07-18 06:22:24'),(93,9,13,1725,NULL,NULL,NULL,'2023-07-18 06:22:24','2023-07-18 06:22:24'),(94,9,9,1726,NULL,NULL,NULL,'2023-07-19 03:27:05','2023-07-19 03:27:05'),(95,9,12,1726,NULL,NULL,NULL,'2023-07-19 03:27:05','2023-07-19 03:27:05'),(96,9,13,1726,NULL,NULL,NULL,'2023-07-19 03:27:05','2023-07-19 03:27:05');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1729 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2021-05-27 16:02:57','2021-05-27 16:02:57'),(2,NULL,'DUMMY',2,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(3,NULL,'DUMMY',3,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(4,NULL,'DUMMY',4,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(5,NULL,'DUMMY',5,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(6,NULL,'DUMMY',6,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(7,NULL,'DUMMY',7,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(8,NULL,'DUMMY',8,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(9,NULL,'DUMMY',9,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(10,NULL,'DUMMY',10,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(11,NULL,'DUMMY',11,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(12,NULL,'DUMMY',12,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(13,NULL,'DUMMY',13,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(14,NULL,'DUMMY',14,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(15,NULL,'DUMMY',15,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(16,NULL,'DUMMY',16,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(17,NULL,'DUMMY',17,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(18,NULL,'DUMMY',18,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(19,NULL,'DUMMY',19,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(20,NULL,'DUMMY',20,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(21,NULL,'DUMMY',21,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(22,NULL,'DUMMY',22,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(23,NULL,'DUMMY',23,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(24,NULL,'DUMMY',24,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(25,NULL,'DUMMY',25,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(26,NULL,'DUMMY',26,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(27,NULL,'DUMMY',27,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(28,NULL,'DUMMY',28,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(29,NULL,'DUMMY',29,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(30,NULL,'DUMMY',30,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(31,NULL,'DUMMY',31,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(32,NULL,'DUMMY',32,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(33,NULL,'DUMMY',33,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(34,NULL,'DUMMY',34,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(35,NULL,'DUMMY',35,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(36,NULL,'DUMMY',36,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(37,NULL,'DUMMY',37,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(38,NULL,'DUMMY',38,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(39,NULL,'DUMMY',39,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(40,NULL,'DUMMY',40,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(41,NULL,'DUMMY',41,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(42,NULL,'DUMMY',42,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(43,NULL,'DUMMY',43,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(44,NULL,'DUMMY',44,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(45,NULL,'DUMMY',45,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(46,NULL,'DUMMY',46,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(47,NULL,'DUMMY',47,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(48,NULL,'DUMMY',48,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(49,NULL,'DUMMY',49,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(50,NULL,'DUMMY',50,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(51,NULL,'DUMMY',51,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(52,NULL,'DUMMY',52,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(53,NULL,'DUMMY',53,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(54,NULL,'DUMMY',54,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(55,NULL,'DUMMY',55,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(56,NULL,'DUMMY',56,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(57,NULL,'DUMMY',57,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(58,NULL,'DUMMY',58,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(59,NULL,'DUMMY',59,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(60,NULL,'DUMMY',60,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(61,NULL,'DUMMY',61,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(62,NULL,'DUMMY',62,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(63,NULL,'DUMMY',63,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(64,NULL,'DUMMY',64,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(65,NULL,'DUMMY',65,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(66,NULL,'DUMMY',66,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(67,NULL,'DUMMY',67,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(68,NULL,'DUMMY',68,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(69,NULL,'DUMMY',69,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(70,NULL,'DUMMY',70,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(71,NULL,'DUMMY',71,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(72,NULL,'DUMMY',72,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(73,NULL,'DUMMY',73,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(74,NULL,'DUMMY',74,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(75,NULL,'DUMMY',75,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(76,NULL,'DUMMY',76,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(77,NULL,'DUMMY',77,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(78,NULL,'DUMMY',78,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(79,NULL,'DUMMY',79,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(80,NULL,'DUMMY',80,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(81,NULL,'DUMMY',81,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(82,NULL,'DUMMY',82,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(83,NULL,'DUMMY',83,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(84,NULL,'DUMMY',84,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(85,NULL,'DUMMY',85,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(86,NULL,'DUMMY',86,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(87,NULL,'DUMMY',87,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(88,NULL,'DUMMY',88,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(89,NULL,'DUMMY',89,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(90,NULL,'DUMMY',90,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(91,NULL,'DUMMY',91,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(92,NULL,'DUMMY',92,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(93,NULL,'DUMMY',93,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(94,NULL,'DUMMY',94,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(95,NULL,'DUMMY',95,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(96,NULL,'DUMMY',96,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(97,NULL,'DUMMY',97,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(98,NULL,'DUMMY',98,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(99,NULL,'DUMMY',99,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(100,NULL,'DUMMY',100,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(101,NULL,'DUMMY',101,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(102,NULL,'DUMMY',102,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(103,NULL,'DUMMY',103,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(104,NULL,'DUMMY',104,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(105,NULL,'DUMMY',105,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(106,NULL,'DUMMY',106,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(107,NULL,'DUMMY',107,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(108,NULL,'DUMMY',108,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(109,NULL,'DUMMY',109,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(110,NULL,'DUMMY',110,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(111,NULL,'DUMMY',111,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(112,NULL,'DUMMY',112,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(113,NULL,'DUMMY',113,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(114,NULL,'DUMMY',114,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(115,NULL,'DUMMY',115,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(116,NULL,'DUMMY',116,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(117,NULL,'DUMMY',117,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(118,NULL,'DUMMY',118,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(119,NULL,'DUMMY',119,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(120,NULL,'DUMMY',120,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(121,NULL,'DUMMY',121,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(122,NULL,'DUMMY',122,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(123,NULL,'DUMMY',123,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(124,NULL,'DUMMY',124,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(125,NULL,'DUMMY',125,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(126,NULL,'DUMMY',126,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(127,NULL,'DUMMY',127,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(128,NULL,'DUMMY',128,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(129,NULL,'DUMMY',129,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(130,NULL,'DUMMY',130,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(131,NULL,'DUMMY',131,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(132,NULL,'DUMMY',132,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(133,NULL,'DUMMY',133,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(134,NULL,'DUMMY',134,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(135,NULL,'DUMMY',135,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(136,NULL,'DUMMY',136,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(137,NULL,'DUMMY',137,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(138,NULL,'DUMMY',138,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(139,NULL,'DUMMY',139,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(140,NULL,'DUMMY',140,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(141,NULL,'DUMMY',141,1,'2021-05-28 02:08:04','2021-05-28 02:08:04'),(142,NULL,'DUMMY',142,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(143,NULL,'DUMMY',143,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(144,NULL,'DUMMY',144,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(145,NULL,'DUMMY',145,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(146,NULL,'DUMMY',146,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(147,NULL,'DUMMY',147,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(148,NULL,'DUMMY',148,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(149,NULL,'DUMMY',149,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(150,NULL,'DUMMY',150,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(151,NULL,'DUMMY',151,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(152,NULL,'DUMMY',152,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(153,NULL,'DUMMY',153,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(154,NULL,'DUMMY',154,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(155,NULL,'DUMMY',155,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(156,NULL,'DUMMY',156,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(157,NULL,'DUMMY',157,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(158,NULL,'DUMMY',158,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(159,NULL,'DUMMY',159,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(160,NULL,'DUMMY',160,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(161,NULL,'DUMMY',161,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(162,NULL,'DUMMY',162,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(163,NULL,'DUMMY',163,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(164,NULL,'DUMMY',164,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(165,NULL,'DUMMY',165,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(166,NULL,'DUMMY',166,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(167,NULL,'DUMMY',167,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(168,NULL,'DUMMY',168,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(169,NULL,'DUMMY',169,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(170,NULL,'DUMMY',170,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(171,NULL,'DUMMY',171,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(172,NULL,'DUMMY',172,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(173,NULL,'DUMMY',173,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(174,NULL,'DUMMY',174,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(175,NULL,'DUMMY',175,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(176,NULL,'DUMMY',176,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(177,NULL,'DUMMY',177,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(178,NULL,'DUMMY',178,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(179,NULL,'DUMMY',179,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(180,NULL,'DUMMY',180,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(181,NULL,'DUMMY',181,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(182,NULL,'DUMMY',182,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(183,NULL,'DUMMY',183,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(184,NULL,'DUMMY',184,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(185,NULL,'DUMMY',185,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(186,NULL,'DUMMY',186,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(187,NULL,'DUMMY',187,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(188,NULL,'DUMMY',188,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(189,NULL,'DUMMY',189,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(190,NULL,'DUMMY',190,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(191,NULL,'DUMMY',191,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(192,NULL,'DUMMY',192,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(193,NULL,'DUMMY',193,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(194,NULL,'DUMMY',194,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(195,NULL,'DUMMY',195,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(196,NULL,'DUMMY',196,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(197,NULL,'DUMMY',197,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(198,NULL,'DUMMY',198,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(199,NULL,'DUMMY',199,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(200,NULL,'DUMMY',200,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(201,NULL,'DUMMY',201,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(202,NULL,'DUMMY',202,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(203,NULL,'DUMMY',203,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(204,NULL,'DUMMY',204,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(205,NULL,'DUMMY',205,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(206,NULL,'DUMMY',206,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(207,NULL,'DUMMY',207,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(208,NULL,'DUMMY',208,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(209,NULL,'DUMMY',209,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(210,NULL,'DUMMY',210,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(211,NULL,'DUMMY',211,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(212,NULL,'DUMMY',212,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(213,NULL,'DUMMY',213,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(214,NULL,'DUMMY',214,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(215,NULL,'DUMMY',215,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(216,NULL,'DUMMY',216,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(217,NULL,'DUMMY',217,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(218,NULL,'DUMMY',218,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(219,NULL,'DUMMY',219,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(220,NULL,'DUMMY',220,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(221,NULL,'DUMMY',221,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(222,NULL,'DUMMY',222,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(223,NULL,'DUMMY',223,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(224,NULL,'DUMMY',224,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(225,NULL,'DUMMY',225,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(226,NULL,'DUMMY',226,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(227,NULL,'DUMMY',227,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(228,NULL,'DUMMY',228,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(229,NULL,'DUMMY',229,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(230,NULL,'DUMMY',230,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(231,NULL,'DUMMY',231,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(232,NULL,'DUMMY',232,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(233,NULL,'DUMMY',233,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(234,NULL,'DUMMY',234,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(235,NULL,'DUMMY',235,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(236,NULL,'DUMMY',236,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(237,NULL,'DUMMY',237,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(238,NULL,'DUMMY',238,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(239,NULL,'DUMMY',239,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(240,NULL,'DUMMY',240,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(241,NULL,'DUMMY',241,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(242,NULL,'DUMMY',242,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(243,NULL,'DUMMY',243,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(244,NULL,'DUMMY',244,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(245,NULL,'DUMMY',245,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(246,NULL,'DUMMY',246,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(247,NULL,'DUMMY',247,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(248,NULL,'DUMMY',248,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(249,NULL,'DUMMY',249,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(250,NULL,'DUMMY',250,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(251,NULL,'DUMMY',251,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(252,NULL,'DUMMY',252,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(253,NULL,'DUMMY',253,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(254,NULL,'DUMMY',254,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(255,NULL,'DUMMY',255,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(256,NULL,'DUMMY',256,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(257,NULL,'DUMMY',257,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(258,NULL,'DUMMY',258,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(259,NULL,'DUMMY',259,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(260,NULL,'DUMMY',260,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(261,NULL,'DUMMY',261,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(262,NULL,'DUMMY',262,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(263,NULL,'DUMMY',263,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(264,NULL,'DUMMY',264,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(265,NULL,'DUMMY',265,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(266,NULL,'DUMMY',266,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(267,NULL,'DUMMY',267,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(268,NULL,'DUMMY',268,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(269,NULL,'DUMMY',269,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(270,NULL,'DUMMY',270,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(271,NULL,'DUMMY',271,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(272,NULL,'DUMMY',272,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(273,NULL,'DUMMY',273,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(274,NULL,'DUMMY',274,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(275,NULL,'DUMMY',275,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(276,NULL,'DUMMY',276,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(277,NULL,'DUMMY',277,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(278,NULL,'DUMMY',278,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(279,NULL,'DUMMY',279,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(280,NULL,'DUMMY',280,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(281,NULL,'DUMMY',281,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(282,NULL,'DUMMY',282,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(283,NULL,'DUMMY',283,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(284,NULL,'DUMMY',284,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(285,NULL,'DUMMY',285,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(286,NULL,'DUMMY',286,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(287,NULL,'DUMMY',287,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(288,NULL,'DUMMY',288,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(289,NULL,'DUMMY',289,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(290,NULL,'DUMMY',290,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(291,NULL,'DUMMY',291,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(292,NULL,'DUMMY',292,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(293,NULL,'DUMMY',293,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(294,NULL,'DUMMY',294,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(295,NULL,'DUMMY',295,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(296,NULL,'DUMMY',296,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(297,NULL,'DUMMY',297,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(298,NULL,'DUMMY',298,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(299,NULL,'DUMMY',299,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(300,NULL,'DUMMY',300,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(301,NULL,'DUMMY',301,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(302,NULL,'DUMMY',302,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(303,NULL,'DUMMY',303,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(304,NULL,'DUMMY',304,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(305,NULL,'DUMMY',305,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(306,NULL,'DUMMY',306,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(307,NULL,'DUMMY',307,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(308,NULL,'DUMMY',308,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(309,NULL,'DUMMY',309,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(310,NULL,'DUMMY',310,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(311,NULL,'DUMMY',311,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(312,NULL,'DUMMY',312,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(313,NULL,'DUMMY',313,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(314,NULL,'DUMMY',314,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(315,NULL,'DUMMY',315,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(316,NULL,'DUMMY',316,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(317,NULL,'DUMMY',317,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(318,NULL,'DUMMY',318,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(319,NULL,'DUMMY',319,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(320,NULL,'DUMMY',320,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(321,NULL,'DUMMY',321,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(322,NULL,'DUMMY',322,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(323,NULL,'DUMMY',323,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(324,NULL,'DUMMY',324,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(325,NULL,'DUMMY',325,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(326,NULL,'DUMMY',326,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(327,NULL,'DUMMY',327,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(328,NULL,'DUMMY',328,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(329,NULL,'DUMMY',329,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(330,NULL,'DUMMY',330,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(331,NULL,'DUMMY',331,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(332,NULL,'DUMMY',332,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(333,NULL,'DUMMY',333,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(334,NULL,'DUMMY',334,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(335,NULL,'DUMMY',335,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(336,NULL,'DUMMY',336,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(337,NULL,'DUMMY',337,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(338,NULL,'DUMMY',338,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(339,NULL,'DUMMY',339,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(340,NULL,'DUMMY',340,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(341,NULL,'DUMMY',341,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(342,NULL,'DUMMY',342,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(343,NULL,'DUMMY',343,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(344,NULL,'DUMMY',344,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(345,NULL,'DUMMY',345,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(346,NULL,'DUMMY',346,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(347,NULL,'DUMMY',347,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(348,NULL,'DUMMY',348,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(349,NULL,'DUMMY',349,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(350,NULL,'DUMMY',350,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(351,NULL,'DUMMY',351,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(352,NULL,'DUMMY',352,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(353,NULL,'DUMMY',353,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(354,NULL,'DUMMY',354,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(355,NULL,'DUMMY',355,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(356,NULL,'DUMMY',356,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(357,NULL,'DUMMY',357,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(358,NULL,'DUMMY',358,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(359,NULL,'DUMMY',359,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(360,NULL,'DUMMY',360,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(361,NULL,'DUMMY',361,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(362,NULL,'DUMMY',362,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(363,NULL,'DUMMY',363,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(364,NULL,'DUMMY',364,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(365,NULL,'DUMMY',365,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(366,NULL,'DUMMY',366,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(367,NULL,'DUMMY',367,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(368,NULL,'DUMMY',368,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(369,NULL,'DUMMY',369,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(370,NULL,'DUMMY',370,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(371,NULL,'DUMMY',371,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(372,NULL,'DUMMY',372,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(373,NULL,'DUMMY',373,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(374,NULL,'DUMMY',374,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(375,NULL,'DUMMY',375,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(376,NULL,'DUMMY',376,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(377,NULL,'DUMMY',377,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(378,NULL,'DUMMY',378,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(379,NULL,'DUMMY',379,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(380,NULL,'DUMMY',380,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(381,NULL,'DUMMY',381,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(382,NULL,'DUMMY',382,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(383,NULL,'DUMMY',383,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(384,NULL,'DUMMY',384,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(385,NULL,'DUMMY',385,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(386,NULL,'DUMMY',386,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(387,NULL,'DUMMY',387,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(388,NULL,'DUMMY',388,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(389,NULL,'DUMMY',389,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(390,NULL,'DUMMY',390,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(391,NULL,'DUMMY',391,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(392,NULL,'DUMMY',392,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(393,NULL,'DUMMY',393,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(394,NULL,'DUMMY',394,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(395,NULL,'DUMMY',395,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(396,NULL,'DUMMY',396,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(397,NULL,'DUMMY',397,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(398,NULL,'DUMMY',398,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(399,NULL,'DUMMY',399,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(400,NULL,'DUMMY',400,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(401,NULL,'DUMMY',401,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(402,NULL,'DUMMY',402,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(403,NULL,'DUMMY',403,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(404,NULL,'DUMMY',404,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(405,NULL,'DUMMY',405,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(406,NULL,'DUMMY',406,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(407,NULL,'DUMMY',407,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(408,NULL,'DUMMY',408,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(409,NULL,'DUMMY',409,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(410,NULL,'DUMMY',410,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(411,NULL,'DUMMY',411,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(412,NULL,'DUMMY',412,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(413,NULL,'DUMMY',413,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(414,NULL,'DUMMY',414,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(415,NULL,'DUMMY',415,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(416,NULL,'DUMMY',416,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(417,NULL,'DUMMY',417,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(418,NULL,'DUMMY',418,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(419,NULL,'DUMMY',419,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(420,NULL,'DUMMY',420,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(421,NULL,'DUMMY',421,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(422,NULL,'DUMMY',422,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(423,NULL,'DUMMY',423,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(424,NULL,'DUMMY',424,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(425,NULL,'DUMMY',425,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(426,NULL,'DUMMY',426,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(427,NULL,'DUMMY',427,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(428,NULL,'DUMMY',428,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(429,NULL,'DUMMY',429,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(430,NULL,'DUMMY',430,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(431,NULL,'DUMMY',431,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(432,NULL,'DUMMY',432,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(433,NULL,'DUMMY',433,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(434,NULL,'DUMMY',434,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(435,NULL,'DUMMY',435,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(436,NULL,'DUMMY',436,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(437,NULL,'DUMMY',437,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(438,NULL,'DUMMY',438,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(439,NULL,'DUMMY',439,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(440,NULL,'DUMMY',440,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(441,NULL,'DUMMY',441,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(442,NULL,'DUMMY',442,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(443,NULL,'DUMMY',443,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(444,NULL,'DUMMY',444,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(445,NULL,'DUMMY',445,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(446,NULL,'DUMMY',446,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(447,NULL,'DUMMY',447,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(448,NULL,'DUMMY',448,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(449,NULL,'DUMMY',449,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(450,NULL,'DUMMY',450,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(451,NULL,'DUMMY',451,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(452,NULL,'DUMMY',452,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(453,NULL,'DUMMY',453,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(454,NULL,'DUMMY',454,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(455,NULL,'DUMMY',455,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(456,NULL,'DUMMY',456,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(457,NULL,'DUMMY',457,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(458,NULL,'DUMMY',458,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(459,NULL,'DUMMY',459,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(460,NULL,'DUMMY',460,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(461,NULL,'DUMMY',461,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(462,NULL,'DUMMY',462,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(463,NULL,'DUMMY',463,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(464,NULL,'DUMMY',464,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(465,NULL,'DUMMY',465,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(466,NULL,'DUMMY',466,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(467,NULL,'DUMMY',467,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(468,NULL,'DUMMY',468,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(469,NULL,'DUMMY',469,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(470,NULL,'DUMMY',470,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(471,NULL,'DUMMY',471,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(472,NULL,'DUMMY',472,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(473,NULL,'DUMMY',473,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(474,NULL,'DUMMY',474,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(475,NULL,'DUMMY',475,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(476,NULL,'DUMMY',476,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(477,NULL,'DUMMY',477,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(478,NULL,'DUMMY',478,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(479,NULL,'DUMMY',479,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(480,NULL,'DUMMY',480,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(481,NULL,'DUMMY',481,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(482,NULL,'DUMMY',482,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(483,NULL,'DUMMY',483,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(484,NULL,'DUMMY',484,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(485,NULL,'DUMMY',485,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(486,NULL,'DUMMY',486,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(487,NULL,'DUMMY',487,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(488,NULL,'DUMMY',488,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(489,NULL,'DUMMY',489,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(490,NULL,'DUMMY',490,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(491,NULL,'DUMMY',491,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(492,NULL,'DUMMY',492,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(493,NULL,'DUMMY',493,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(494,NULL,'DUMMY',494,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(495,NULL,'DUMMY',495,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(496,NULL,'DUMMY',496,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(497,NULL,'DUMMY',497,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(498,NULL,'DUMMY',498,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(499,NULL,'DUMMY',499,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(500,NULL,'DUMMY',500,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(501,NULL,'DUMMY',501,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(502,NULL,'DUMMY',502,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(503,NULL,'DUMMY',503,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(504,NULL,'DUMMY',504,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(505,NULL,'DUMMY',505,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(506,NULL,'DUMMY',506,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(507,NULL,'DUMMY',507,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(508,NULL,'DUMMY',508,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(509,NULL,'DUMMY',509,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(510,NULL,'DUMMY',510,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(511,NULL,'DUMMY',511,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(512,NULL,'DUMMY',512,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(513,NULL,'DUMMY',513,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(514,NULL,'DUMMY',514,1,'2021-05-28 02:08:05','2021-05-28 02:08:05'),(515,NULL,'DUMMY',515,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(516,NULL,'DUMMY',516,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(517,NULL,'DUMMY',517,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(518,NULL,'DUMMY',518,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(519,NULL,'DUMMY',519,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(520,NULL,'DUMMY',520,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(521,NULL,'DUMMY',521,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(522,NULL,'DUMMY',522,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(523,NULL,'DUMMY',523,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(524,NULL,'DUMMY',524,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(525,NULL,'DUMMY',525,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(526,NULL,'DUMMY',526,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(527,NULL,'DUMMY',527,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(528,NULL,'DUMMY',528,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(529,NULL,'DUMMY',529,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(530,NULL,'DUMMY',530,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(531,NULL,'DUMMY',531,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(532,NULL,'DUMMY',532,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(533,NULL,'DUMMY',533,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(534,NULL,'DUMMY',534,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(535,NULL,'DUMMY',535,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(536,NULL,'DUMMY',536,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(537,NULL,'DUMMY',537,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(538,NULL,'DUMMY',538,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(539,NULL,'DUMMY',539,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(540,NULL,'DUMMY',540,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(541,NULL,'DUMMY',541,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(542,NULL,'DUMMY',542,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(543,NULL,'DUMMY',543,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(544,NULL,'DUMMY',544,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(545,NULL,'DUMMY',545,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(546,NULL,'DUMMY',546,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(547,NULL,'DUMMY',547,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(548,NULL,'DUMMY',548,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(549,NULL,'DUMMY',549,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(550,NULL,'DUMMY',550,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(551,NULL,'DUMMY',551,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(552,NULL,'DUMMY',552,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(553,NULL,'DUMMY',553,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(554,NULL,'DUMMY',554,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(555,NULL,'DUMMY',555,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(556,NULL,'DUMMY',556,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(557,NULL,'DUMMY',557,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(558,NULL,'DUMMY',558,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(559,NULL,'DUMMY',559,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(560,NULL,'DUMMY',560,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(561,NULL,'DUMMY',561,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(562,NULL,'DUMMY',562,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(563,NULL,'DUMMY',563,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(564,NULL,'DUMMY',564,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(565,NULL,'DUMMY',565,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(566,NULL,'DUMMY',566,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(567,NULL,'DUMMY',567,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(568,NULL,'DUMMY',568,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(569,NULL,'DUMMY',569,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(570,NULL,'DUMMY',570,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(571,NULL,'DUMMY',571,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(572,NULL,'DUMMY',572,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(573,NULL,'DUMMY',573,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(574,NULL,'DUMMY',574,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(575,NULL,'DUMMY',575,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(576,NULL,'DUMMY',576,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(577,NULL,'DUMMY',577,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(578,NULL,'DUMMY',578,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(579,NULL,'DUMMY',579,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(580,NULL,'DUMMY',580,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(581,NULL,'DUMMY',581,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(582,NULL,'DUMMY',582,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(583,NULL,'DUMMY',583,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(584,NULL,'DUMMY',584,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(585,NULL,'DUMMY',585,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(586,NULL,'DUMMY',586,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(587,NULL,'DUMMY',587,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(588,NULL,'DUMMY',588,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(589,NULL,'DUMMY',589,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(590,NULL,'DUMMY',590,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(591,NULL,'DUMMY',591,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(592,NULL,'DUMMY',592,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(593,NULL,'DUMMY',593,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(594,NULL,'DUMMY',594,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(595,NULL,'DUMMY',595,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(596,NULL,'DUMMY',596,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(597,NULL,'DUMMY',597,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(598,NULL,'DUMMY',598,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(599,NULL,'DUMMY',599,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(600,NULL,'DUMMY',600,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(601,NULL,'DUMMY',601,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(602,NULL,'DUMMY',602,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(603,NULL,'DUMMY',603,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(604,NULL,'DUMMY',604,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(605,NULL,'DUMMY',605,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(606,NULL,'DUMMY',606,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(607,NULL,'DUMMY',607,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(608,NULL,'DUMMY',608,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(609,NULL,'DUMMY',609,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(610,NULL,'DUMMY',610,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(611,NULL,'DUMMY',611,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(612,NULL,'DUMMY',612,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(613,NULL,'DUMMY',613,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(614,NULL,'DUMMY',614,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(615,NULL,'DUMMY',615,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(616,NULL,'DUMMY',616,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(617,NULL,'DUMMY',617,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(618,NULL,'DUMMY',618,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(619,NULL,'DUMMY',619,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(620,NULL,'DUMMY',620,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(621,NULL,'DUMMY',621,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(622,NULL,'DUMMY',622,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(623,NULL,'DUMMY',623,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(624,NULL,'DUMMY',624,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(625,NULL,'DUMMY',625,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(626,NULL,'DUMMY',626,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(627,NULL,'DUMMY',627,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(628,NULL,'DUMMY',628,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(629,NULL,'DUMMY',629,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(630,NULL,'DUMMY',630,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(631,NULL,'DUMMY',631,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(632,NULL,'DUMMY',632,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(633,NULL,'DUMMY',633,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(634,NULL,'DUMMY',634,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(635,NULL,'DUMMY',635,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(636,NULL,'DUMMY',636,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(637,NULL,'DUMMY',637,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(638,NULL,'DUMMY',638,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(639,NULL,'DUMMY',639,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(640,NULL,'DUMMY',640,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(641,NULL,'DUMMY',641,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(642,NULL,'DUMMY',642,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(643,NULL,'DUMMY',643,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(644,NULL,'DUMMY',644,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(645,NULL,'DUMMY',645,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(646,NULL,'DUMMY',646,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(647,NULL,'DUMMY',647,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(648,NULL,'DUMMY',648,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(649,NULL,'DUMMY',649,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(650,NULL,'DUMMY',650,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(651,NULL,'DUMMY',651,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(652,NULL,'DUMMY',652,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(653,NULL,'DUMMY',653,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(654,NULL,'DUMMY',654,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(655,NULL,'DUMMY',655,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(656,NULL,'DUMMY',656,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(657,NULL,'DUMMY',657,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(658,NULL,'DUMMY',658,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(659,NULL,'DUMMY',659,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(660,NULL,'DUMMY',660,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(661,NULL,'DUMMY',661,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(662,NULL,'DUMMY',662,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(663,NULL,'DUMMY',663,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(664,NULL,'DUMMY',664,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(665,NULL,'DUMMY',665,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(666,NULL,'DUMMY',666,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(667,NULL,'DUMMY',667,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(668,NULL,'DUMMY',668,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(669,NULL,'DUMMY',669,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(670,NULL,'DUMMY',670,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(671,NULL,'DUMMY',671,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(672,NULL,'DUMMY',672,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(673,NULL,'DUMMY',673,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(674,NULL,'DUMMY',674,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(675,NULL,'DUMMY',675,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(676,NULL,'DUMMY',676,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(677,NULL,'DUMMY',677,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(678,NULL,'DUMMY',678,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(679,NULL,'DUMMY',679,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(680,NULL,'DUMMY',680,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(681,NULL,'DUMMY',681,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(682,NULL,'DUMMY',682,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(683,NULL,'DUMMY',683,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(684,NULL,'DUMMY',684,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(685,NULL,'DUMMY',685,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(686,NULL,'DUMMY',686,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(687,NULL,'DUMMY',687,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(688,NULL,'DUMMY',688,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(689,NULL,'DUMMY',689,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(690,NULL,'DUMMY',690,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(691,NULL,'DUMMY',691,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(692,NULL,'DUMMY',692,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(693,NULL,'DUMMY',693,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(694,NULL,'DUMMY',694,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(695,NULL,'DUMMY',695,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(696,NULL,'DUMMY',696,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(697,NULL,'DUMMY',697,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(698,NULL,'DUMMY',698,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(699,NULL,'DUMMY',699,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(700,NULL,'DUMMY',700,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(701,NULL,'DUMMY',701,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(702,NULL,'DUMMY',702,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(703,NULL,'DUMMY',703,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(704,NULL,'DUMMY',704,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(705,NULL,'DUMMY',705,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(706,NULL,'DUMMY',706,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(707,NULL,'DUMMY',707,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(708,NULL,'DUMMY',708,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(709,NULL,'DUMMY',709,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(710,NULL,'DUMMY',710,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(711,NULL,'DUMMY',711,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(712,NULL,'DUMMY',712,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(713,NULL,'DUMMY',713,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(714,NULL,'DUMMY',714,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(715,NULL,'DUMMY',715,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(716,NULL,'DUMMY',716,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(717,NULL,'DUMMY',717,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(718,NULL,'DUMMY',718,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(719,NULL,'DUMMY',719,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(720,NULL,'DUMMY',720,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(721,NULL,'DUMMY',721,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(722,NULL,'DUMMY',722,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(723,NULL,'DUMMY',723,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(724,NULL,'DUMMY',724,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(725,NULL,'DUMMY',725,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(726,NULL,'DUMMY',726,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(727,NULL,'DUMMY',727,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(728,NULL,'DUMMY',728,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(729,NULL,'DUMMY',729,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(730,NULL,'DUMMY',730,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(731,NULL,'DUMMY',731,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(732,NULL,'DUMMY',732,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(733,NULL,'DUMMY',733,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(734,NULL,'DUMMY',734,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(735,NULL,'DUMMY',735,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(736,NULL,'DUMMY',736,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(737,NULL,'DUMMY',737,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(738,NULL,'DUMMY',738,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(739,NULL,'DUMMY',739,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(740,NULL,'DUMMY',740,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(741,NULL,'DUMMY',741,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(742,NULL,'DUMMY',742,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(743,NULL,'DUMMY',743,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(744,NULL,'DUMMY',744,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(745,NULL,'DUMMY',745,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(746,NULL,'DUMMY',746,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(747,NULL,'DUMMY',747,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(748,NULL,'DUMMY',748,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(749,NULL,'DUMMY',749,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(750,NULL,'DUMMY',750,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(751,NULL,'DUMMY',751,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(752,NULL,'DUMMY',752,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(753,NULL,'DUMMY',753,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(754,NULL,'DUMMY',754,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(755,NULL,'DUMMY',755,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(756,NULL,'DUMMY',756,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(757,NULL,'DUMMY',757,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(758,NULL,'DUMMY',758,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(759,NULL,'DUMMY',759,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(760,NULL,'DUMMY',760,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(761,NULL,'DUMMY',761,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(762,NULL,'DUMMY',762,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(763,NULL,'DUMMY',763,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(764,NULL,'DUMMY',764,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(765,NULL,'DUMMY',765,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(766,NULL,'DUMMY',766,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(767,NULL,'DUMMY',767,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(768,NULL,'DUMMY',768,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(769,NULL,'DUMMY',769,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(770,NULL,'DUMMY',770,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(771,NULL,'DUMMY',771,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(772,NULL,'DUMMY',772,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(773,NULL,'DUMMY',773,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(774,NULL,'DUMMY',774,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(775,NULL,'DUMMY',775,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(776,NULL,'DUMMY',776,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(777,NULL,'DUMMY',777,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(778,NULL,'DUMMY',778,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(779,NULL,'DUMMY',779,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(780,NULL,'DUMMY',780,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(781,NULL,'DUMMY',781,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(782,NULL,'DUMMY',782,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(783,NULL,'DUMMY',783,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(784,NULL,'DUMMY',784,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(785,NULL,'DUMMY',785,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(786,NULL,'DUMMY',786,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(787,NULL,'DUMMY',787,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(788,NULL,'DUMMY',788,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(789,NULL,'DUMMY',789,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(790,NULL,'DUMMY',790,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(791,NULL,'DUMMY',791,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(792,NULL,'DUMMY',792,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(793,NULL,'DUMMY',793,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(794,NULL,'DUMMY',794,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(795,NULL,'DUMMY',795,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(796,NULL,'DUMMY',796,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(797,NULL,'DUMMY',797,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(798,NULL,'DUMMY',798,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(799,NULL,'DUMMY',799,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(800,NULL,'DUMMY',800,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(801,NULL,'DUMMY',801,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(802,NULL,'DUMMY',802,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(803,NULL,'DUMMY',803,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(804,NULL,'DUMMY',804,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(805,NULL,'DUMMY',805,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(806,NULL,'DUMMY',806,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(807,NULL,'DUMMY',807,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(808,NULL,'DUMMY',808,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(809,NULL,'DUMMY',809,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(810,NULL,'DUMMY',810,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(811,NULL,'DUMMY',811,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(812,NULL,'DUMMY',812,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(813,NULL,'DUMMY',813,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(814,NULL,'DUMMY',814,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(815,NULL,'DUMMY',815,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(816,NULL,'DUMMY',816,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(817,NULL,'DUMMY',817,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(818,NULL,'DUMMY',818,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(819,NULL,'DUMMY',819,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(820,NULL,'DUMMY',820,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(821,NULL,'DUMMY',821,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(822,NULL,'DUMMY',822,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(823,NULL,'DUMMY',823,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(824,NULL,'DUMMY',824,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(825,NULL,'DUMMY',825,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(826,NULL,'DUMMY',826,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(827,NULL,'DUMMY',827,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(828,NULL,'DUMMY',828,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(829,NULL,'DUMMY',829,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(830,NULL,'DUMMY',830,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(831,NULL,'DUMMY',831,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(832,NULL,'DUMMY',832,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(833,NULL,'DUMMY',833,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(834,NULL,'DUMMY',834,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(835,NULL,'DUMMY',835,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(836,NULL,'DUMMY',836,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(837,NULL,'DUMMY',837,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(838,NULL,'DUMMY',838,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(839,NULL,'DUMMY',839,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(840,NULL,'DUMMY',840,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(841,NULL,'DUMMY',841,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(842,NULL,'DUMMY',842,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(843,NULL,'DUMMY',843,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(844,NULL,'DUMMY',844,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(845,NULL,'DUMMY',845,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(846,NULL,'DUMMY',846,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(847,NULL,'DUMMY',847,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(848,NULL,'DUMMY',848,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(849,NULL,'DUMMY',849,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(850,NULL,'DUMMY',850,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(851,NULL,'DUMMY',851,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(852,NULL,'DUMMY',852,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(853,NULL,'DUMMY',853,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(854,NULL,'DUMMY',854,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(855,NULL,'DUMMY',855,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(856,NULL,'DUMMY',856,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(857,NULL,'DUMMY',857,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(858,NULL,'DUMMY',858,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(859,NULL,'DUMMY',859,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(860,NULL,'DUMMY',860,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(861,NULL,'DUMMY',861,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(862,NULL,'DUMMY',862,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(863,NULL,'DUMMY',863,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(864,NULL,'DUMMY',864,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(865,NULL,'DUMMY',865,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(866,NULL,'DUMMY',866,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(867,NULL,'DUMMY',867,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(868,NULL,'DUMMY',868,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(869,NULL,'DUMMY',869,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(870,NULL,'DUMMY',870,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(871,NULL,'DUMMY',871,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(872,NULL,'DUMMY',872,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(873,NULL,'DUMMY',873,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(874,NULL,'DUMMY',874,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(875,NULL,'DUMMY',875,1,'2021-05-28 02:08:06','2021-05-28 02:08:06'),(876,NULL,'DUMMY',876,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(877,NULL,'DUMMY',877,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(878,NULL,'DUMMY',878,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(879,NULL,'DUMMY',879,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(880,NULL,'DUMMY',880,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(881,NULL,'DUMMY',881,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(882,NULL,'DUMMY',882,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(883,NULL,'DUMMY',883,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(884,NULL,'DUMMY',884,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(885,NULL,'DUMMY',885,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(886,NULL,'DUMMY',886,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(887,NULL,'DUMMY',887,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(888,NULL,'DUMMY',888,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(889,NULL,'DUMMY',889,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(890,NULL,'DUMMY',890,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(891,NULL,'DUMMY',891,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(892,NULL,'DUMMY',892,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(893,NULL,'DUMMY',893,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(894,NULL,'DUMMY',894,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(895,NULL,'DUMMY',895,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(896,NULL,'DUMMY',896,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(897,NULL,'DUMMY',897,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(898,NULL,'DUMMY',898,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(899,NULL,'DUMMY',899,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(900,NULL,'DUMMY',900,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(901,NULL,'DUMMY',901,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(902,NULL,'DUMMY',902,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(903,NULL,'DUMMY',903,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(904,NULL,'DUMMY',904,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(905,NULL,'DUMMY',905,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(906,NULL,'DUMMY',906,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(907,NULL,'DUMMY',907,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(908,NULL,'DUMMY',908,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(909,NULL,'DUMMY',909,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(910,NULL,'DUMMY',910,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(911,NULL,'DUMMY',911,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(912,NULL,'DUMMY',912,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(913,NULL,'DUMMY',913,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(914,NULL,'DUMMY',914,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(915,NULL,'DUMMY',915,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(916,NULL,'DUMMY',916,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(917,NULL,'DUMMY',917,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(918,NULL,'DUMMY',918,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(919,NULL,'DUMMY',919,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(920,NULL,'DUMMY',920,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(921,NULL,'DUMMY',921,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(922,NULL,'DUMMY',922,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(923,NULL,'DUMMY',923,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(924,NULL,'DUMMY',924,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(925,NULL,'DUMMY',925,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(926,NULL,'DUMMY',926,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(927,NULL,'DUMMY',927,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(928,NULL,'DUMMY',928,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(929,NULL,'DUMMY',929,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(930,NULL,'DUMMY',930,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(931,NULL,'DUMMY',931,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(932,NULL,'DUMMY',932,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(933,NULL,'DUMMY',933,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(934,NULL,'DUMMY',934,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(935,NULL,'DUMMY',935,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(936,NULL,'DUMMY',936,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(937,NULL,'DUMMY',937,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(938,NULL,'DUMMY',938,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(939,NULL,'DUMMY',939,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(940,NULL,'DUMMY',940,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(941,NULL,'DUMMY',941,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(942,NULL,'DUMMY',942,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(943,NULL,'DUMMY',943,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(944,NULL,'DUMMY',944,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(945,NULL,'DUMMY',945,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(946,NULL,'DUMMY',946,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(947,NULL,'DUMMY',947,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(948,NULL,'DUMMY',948,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(949,NULL,'DUMMY',949,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(950,NULL,'DUMMY',950,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(951,NULL,'DUMMY',951,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(952,NULL,'DUMMY',952,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(953,NULL,'DUMMY',953,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(954,NULL,'DUMMY',954,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(955,NULL,'DUMMY',955,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(956,NULL,'DUMMY',956,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(957,NULL,'DUMMY',957,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(958,NULL,'DUMMY',958,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(959,NULL,'DUMMY',959,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(960,NULL,'DUMMY',960,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(961,NULL,'DUMMY',961,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(962,NULL,'DUMMY',962,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(963,NULL,'DUMMY',963,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(964,NULL,'DUMMY',964,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(965,NULL,'DUMMY',965,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(966,NULL,'DUMMY',966,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(967,NULL,'DUMMY',967,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(968,NULL,'DUMMY',968,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(969,NULL,'DUMMY',969,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(970,NULL,'DUMMY',970,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(971,NULL,'DUMMY',971,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(972,NULL,'DUMMY',972,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(973,NULL,'DUMMY',973,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(974,NULL,'DUMMY',974,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(975,NULL,'DUMMY',975,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(976,NULL,'DUMMY',976,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(977,NULL,'DUMMY',977,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(978,NULL,'DUMMY',978,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(979,NULL,'DUMMY',979,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(980,NULL,'DUMMY',980,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(981,NULL,'DUMMY',981,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(982,NULL,'DUMMY',982,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(983,NULL,'DUMMY',983,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(984,NULL,'DUMMY',984,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(985,NULL,'DUMMY',985,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(986,NULL,'DUMMY',986,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(987,NULL,'DUMMY',987,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(988,NULL,'DUMMY',988,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(989,NULL,'DUMMY',989,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(990,NULL,'DUMMY',990,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(991,NULL,'DUMMY',991,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(992,NULL,'DUMMY',992,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(993,NULL,'DUMMY',993,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(994,NULL,'DUMMY',994,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(995,NULL,'DUMMY',995,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(996,NULL,'DUMMY',996,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(997,NULL,'DUMMY',997,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(998,NULL,'DUMMY',998,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(999,NULL,'DUMMY',999,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1000,NULL,'DUMMY',1000,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1001,NULL,'DUMMY',1001,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1002,NULL,'DUMMY',1002,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1003,NULL,'DUMMY',1003,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1004,NULL,'DUMMY',1004,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1005,NULL,'DUMMY',1005,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1006,NULL,'DUMMY',1006,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1007,NULL,'DUMMY',1007,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1008,NULL,'DUMMY',1008,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1009,NULL,'DUMMY',1009,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1010,NULL,'DUMMY',1010,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1011,NULL,'DUMMY',1011,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1012,NULL,'DUMMY',1012,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1013,NULL,'DUMMY',1013,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1014,NULL,'DUMMY',1014,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1015,NULL,'DUMMY',1015,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1016,NULL,'DUMMY',1016,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1017,NULL,'DUMMY',1017,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1018,NULL,'DUMMY',1018,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1019,NULL,'DUMMY',1019,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1020,NULL,'DUMMY',1020,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1021,NULL,'DUMMY',1021,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1022,NULL,'DUMMY',1022,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1023,NULL,'DUMMY',1023,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1024,NULL,'DUMMY',1024,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1025,NULL,'DUMMY',1025,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1026,NULL,'DUMMY',1026,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1027,NULL,'DUMMY',1027,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1028,NULL,'DUMMY',1028,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1029,NULL,'DUMMY',1029,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1030,NULL,'DUMMY',1030,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1031,NULL,'DUMMY',1031,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1032,NULL,'DUMMY',1032,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1033,NULL,'DUMMY',1033,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1034,NULL,'DUMMY',1034,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1035,NULL,'DUMMY',1035,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1036,NULL,'DUMMY',1036,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1037,NULL,'DUMMY',1037,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1038,NULL,'DUMMY',1038,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1039,NULL,'DUMMY',1039,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1040,NULL,'DUMMY',1040,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1041,NULL,'DUMMY',1041,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1042,NULL,'DUMMY',1042,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1043,NULL,'DUMMY',1043,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1044,NULL,'DUMMY',1044,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1045,NULL,'DUMMY',1045,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1046,NULL,'DUMMY',1046,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1047,NULL,'DUMMY',1047,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1048,NULL,'DUMMY',1048,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1049,NULL,'DUMMY',1049,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1050,NULL,'DUMMY',1050,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1051,NULL,'DUMMY',1051,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1052,NULL,'DUMMY',1052,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1053,NULL,'DUMMY',1053,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1054,NULL,'DUMMY',1054,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1055,NULL,'DUMMY',1055,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1056,NULL,'DUMMY',1056,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1057,NULL,'DUMMY',1057,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1058,NULL,'DUMMY',1058,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1059,NULL,'DUMMY',1059,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1060,NULL,'DUMMY',1060,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1061,NULL,'DUMMY',1061,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1062,NULL,'DUMMY',1062,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1063,NULL,'DUMMY',1063,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1064,NULL,'DUMMY',1064,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1065,NULL,'DUMMY',1065,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1066,NULL,'DUMMY',1066,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1067,NULL,'DUMMY',1067,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1068,NULL,'DUMMY',1068,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1069,NULL,'DUMMY',1069,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1070,NULL,'DUMMY',1070,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1071,NULL,'DUMMY',1071,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1072,NULL,'DUMMY',1072,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1073,NULL,'DUMMY',1073,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1074,NULL,'DUMMY',1074,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1075,NULL,'DUMMY',1075,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1076,NULL,'DUMMY',1076,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1077,NULL,'DUMMY',1077,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1078,NULL,'DUMMY',1078,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1079,NULL,'DUMMY',1079,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1080,NULL,'DUMMY',1080,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1081,NULL,'DUMMY',1081,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1082,NULL,'DUMMY',1082,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1083,NULL,'DUMMY',1083,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1084,NULL,'DUMMY',1084,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1085,NULL,'DUMMY',1085,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1086,NULL,'DUMMY',1086,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1087,NULL,'DUMMY',1087,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1088,NULL,'DUMMY',1088,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1089,NULL,'DUMMY',1089,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1090,NULL,'DUMMY',1090,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1091,NULL,'DUMMY',1091,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1092,NULL,'DUMMY',1092,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1093,NULL,'DUMMY',1093,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1094,NULL,'DUMMY',1094,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1095,NULL,'DUMMY',1095,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1096,NULL,'DUMMY',1096,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1097,NULL,'DUMMY',1097,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1098,NULL,'DUMMY',1098,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1099,NULL,'DUMMY',1099,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1100,NULL,'DUMMY',1100,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1101,NULL,'DUMMY',1101,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1102,NULL,'DUMMY',1102,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1103,NULL,'DUMMY',1103,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1104,NULL,'DUMMY',1104,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1105,NULL,'DUMMY',1105,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1106,NULL,'DUMMY',1106,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1107,NULL,'DUMMY',1107,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1108,NULL,'DUMMY',1108,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1109,NULL,'DUMMY',1109,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1110,NULL,'DUMMY',1110,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1111,NULL,'DUMMY',1111,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1112,NULL,'DUMMY',1112,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1113,NULL,'DUMMY',1113,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1114,NULL,'DUMMY',1114,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1115,NULL,'DUMMY',1115,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1116,NULL,'DUMMY',1116,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1117,NULL,'DUMMY',1117,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1118,NULL,'DUMMY',1118,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1119,NULL,'DUMMY',1119,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1120,NULL,'DUMMY',1120,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1121,NULL,'DUMMY',1121,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1122,NULL,'DUMMY',1122,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1123,NULL,'DUMMY',1123,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1124,NULL,'DUMMY',1124,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1125,NULL,'DUMMY',1125,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1126,NULL,'DUMMY',1126,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1127,NULL,'DUMMY',1127,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1128,NULL,'DUMMY',1128,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1129,NULL,'DUMMY',1129,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1130,NULL,'DUMMY',1130,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1131,NULL,'DUMMY',1131,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1132,NULL,'DUMMY',1132,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1133,NULL,'DUMMY',1133,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1134,NULL,'DUMMY',1134,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1135,NULL,'DUMMY',1135,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1136,NULL,'DUMMY',1136,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1137,NULL,'DUMMY',1137,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1138,NULL,'DUMMY',1138,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1139,NULL,'DUMMY',1139,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1140,NULL,'DUMMY',1140,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1141,NULL,'DUMMY',1141,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1142,NULL,'DUMMY',1142,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1143,NULL,'DUMMY',1143,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1144,NULL,'DUMMY',1144,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1145,NULL,'DUMMY',1145,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1146,NULL,'DUMMY',1146,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1147,NULL,'DUMMY',1147,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1148,NULL,'DUMMY',1148,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1149,NULL,'DUMMY',1149,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1150,NULL,'DUMMY',1150,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1151,NULL,'DUMMY',1151,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1152,NULL,'DUMMY',1152,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1153,NULL,'DUMMY',1153,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1154,NULL,'DUMMY',1154,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1155,NULL,'DUMMY',1155,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1156,NULL,'DUMMY',1156,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1157,NULL,'DUMMY',1157,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1158,NULL,'DUMMY',1158,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1159,NULL,'DUMMY',1159,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1160,NULL,'DUMMY',1160,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1161,NULL,'DUMMY',1161,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1162,NULL,'DUMMY',1162,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1163,NULL,'DUMMY',1163,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1164,NULL,'DUMMY',1164,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1165,NULL,'DUMMY',1165,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1166,NULL,'DUMMY',1166,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1167,NULL,'DUMMY',1167,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1168,NULL,'DUMMY',1168,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1169,NULL,'DUMMY',1169,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1170,NULL,'DUMMY',1170,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1171,NULL,'DUMMY',1171,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1172,NULL,'DUMMY',1172,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1173,NULL,'DUMMY',1173,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1174,NULL,'DUMMY',1174,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1175,NULL,'DUMMY',1175,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1176,NULL,'DUMMY',1176,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1177,NULL,'DUMMY',1177,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1178,NULL,'DUMMY',1178,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1179,NULL,'DUMMY',1179,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1180,NULL,'DUMMY',1180,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1181,NULL,'DUMMY',1181,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1182,NULL,'DUMMY',1182,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1183,NULL,'DUMMY',1183,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1184,NULL,'DUMMY',1184,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1185,NULL,'DUMMY',1185,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1186,NULL,'DUMMY',1186,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1187,NULL,'DUMMY',1187,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1188,NULL,'DUMMY',1188,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1189,NULL,'DUMMY',1189,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1190,NULL,'DUMMY',1190,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1191,NULL,'DUMMY',1191,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1192,NULL,'DUMMY',1192,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1193,NULL,'DUMMY',1193,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1194,NULL,'DUMMY',1194,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1195,NULL,'DUMMY',1195,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1196,NULL,'DUMMY',1196,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1197,NULL,'DUMMY',1197,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1198,NULL,'DUMMY',1198,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1199,NULL,'DUMMY',1199,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1200,NULL,'DUMMY',1200,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1201,NULL,'DUMMY',1201,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1202,NULL,'DUMMY',1202,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1203,NULL,'DUMMY',1203,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1204,NULL,'DUMMY',1204,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1205,NULL,'DUMMY',1205,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1206,NULL,'DUMMY',1206,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1207,NULL,'DUMMY',1207,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1208,NULL,'DUMMY',1208,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1209,NULL,'DUMMY',1209,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1210,NULL,'DUMMY',1210,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1211,NULL,'DUMMY',1211,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1212,NULL,'DUMMY',1212,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1213,NULL,'DUMMY',1213,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1214,NULL,'DUMMY',1214,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1215,NULL,'DUMMY',1215,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1216,NULL,'DUMMY',1216,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1217,NULL,'DUMMY',1217,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1218,NULL,'DUMMY',1218,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1219,NULL,'DUMMY',1219,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1220,NULL,'DUMMY',1220,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1221,NULL,'DUMMY',1221,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1222,NULL,'DUMMY',1222,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1223,NULL,'DUMMY',1223,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1224,NULL,'DUMMY',1224,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1225,NULL,'DUMMY',1225,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1226,NULL,'DUMMY',1226,1,'2021-05-28 02:08:07','2021-05-28 02:08:07'),(1227,NULL,'DUMMY',1227,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1228,NULL,'DUMMY',1228,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1229,NULL,'DUMMY',1229,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1230,NULL,'DUMMY',1230,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1231,NULL,'DUMMY',1231,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1232,NULL,'DUMMY',1232,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1233,NULL,'DUMMY',1233,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1234,NULL,'DUMMY',1234,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1235,NULL,'DUMMY',1235,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1236,NULL,'DUMMY',1236,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1237,NULL,'DUMMY',1237,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1238,NULL,'DUMMY',1238,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1239,NULL,'DUMMY',1239,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1240,NULL,'DUMMY',1240,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1241,NULL,'DUMMY',1241,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1242,NULL,'DUMMY',1242,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1243,NULL,'DUMMY',1243,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1244,NULL,'DUMMY',1244,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1245,NULL,'DUMMY',1245,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1246,NULL,'DUMMY',1246,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1247,NULL,'DUMMY',1247,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1248,NULL,'DUMMY',1248,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1249,NULL,'DUMMY',1249,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1250,NULL,'DUMMY',1250,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1251,NULL,'DUMMY',1251,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1252,NULL,'DUMMY',1252,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1253,NULL,'DUMMY',1253,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1254,NULL,'DUMMY',1254,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1255,NULL,'DUMMY',1255,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1256,NULL,'DUMMY',1256,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1257,NULL,'DUMMY',1257,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1258,NULL,'DUMMY',1258,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1259,NULL,'DUMMY',1259,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1260,NULL,'DUMMY',1260,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1261,NULL,'DUMMY',1261,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1262,NULL,'DUMMY',1262,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1263,NULL,'DUMMY',1263,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1264,NULL,'DUMMY',1264,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1265,NULL,'DUMMY',1265,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1266,NULL,'DUMMY',1266,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1267,NULL,'DUMMY',1267,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1268,NULL,'DUMMY',1268,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1269,NULL,'DUMMY',1269,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1270,NULL,'DUMMY',1270,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1271,NULL,'DUMMY',1271,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1272,NULL,'DUMMY',1272,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1273,NULL,'DUMMY',1273,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1274,NULL,'DUMMY',1274,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1275,NULL,'DUMMY',1275,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1276,NULL,'DUMMY',1276,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1277,NULL,'DUMMY',1277,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1278,NULL,'DUMMY',1278,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1279,NULL,'DUMMY',1279,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1280,NULL,'DUMMY',1280,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1281,NULL,'DUMMY',1281,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1282,NULL,'DUMMY',1282,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1283,NULL,'DUMMY',1283,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1284,NULL,'DUMMY',1284,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1285,NULL,'DUMMY',1285,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1286,NULL,'DUMMY',1286,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1287,NULL,'DUMMY',1287,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1288,NULL,'DUMMY',1288,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1289,NULL,'DUMMY',1289,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1290,NULL,'DUMMY',1290,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1291,NULL,'DUMMY',1291,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1292,NULL,'DUMMY',1292,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1293,NULL,'DUMMY',1293,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1294,NULL,'DUMMY',1294,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1295,NULL,'DUMMY',1295,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1296,NULL,'DUMMY',1296,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1297,NULL,'DUMMY',1297,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1298,NULL,'DUMMY',1298,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1299,NULL,'DUMMY',1299,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1300,NULL,'DUMMY',1300,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1301,NULL,'DUMMY',1301,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1302,NULL,'DUMMY',1302,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1303,NULL,'DUMMY',1303,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1304,NULL,'DUMMY',1304,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1305,NULL,'DUMMY',1305,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1306,NULL,'DUMMY',1306,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1307,NULL,'DUMMY',1307,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1308,NULL,'DUMMY',1308,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1309,NULL,'DUMMY',1309,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1310,NULL,'DUMMY',1310,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1311,NULL,'DUMMY',1311,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1312,NULL,'DUMMY',1312,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1313,NULL,'DUMMY',1313,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1314,NULL,'DUMMY',1314,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1315,NULL,'DUMMY',1315,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1316,NULL,'DUMMY',1316,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1317,NULL,'DUMMY',1317,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1318,NULL,'DUMMY',1318,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1319,NULL,'DUMMY',1319,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1320,NULL,'DUMMY',1320,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1321,NULL,'DUMMY',1321,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1322,NULL,'DUMMY',1322,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1323,NULL,'DUMMY',1323,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1324,NULL,'DUMMY',1324,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1325,NULL,'DUMMY',1325,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1326,NULL,'DUMMY',1326,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1327,NULL,'DUMMY',1327,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1328,NULL,'DUMMY',1328,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1329,NULL,'DUMMY',1329,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1330,NULL,'DUMMY',1330,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1331,NULL,'DUMMY',1331,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1332,NULL,'DUMMY',1332,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1333,NULL,'DUMMY',1333,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1334,NULL,'DUMMY',1334,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1335,NULL,'DUMMY',1335,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1336,NULL,'DUMMY',1336,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1337,NULL,'DUMMY',1337,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1338,NULL,'DUMMY',1338,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1339,NULL,'DUMMY',1339,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1340,NULL,'DUMMY',1340,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1341,NULL,'DUMMY',1341,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1342,NULL,'DUMMY',1342,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1343,NULL,'DUMMY',1343,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1344,NULL,'DUMMY',1344,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1345,NULL,'DUMMY',1345,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1346,NULL,'DUMMY',1346,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1347,NULL,'DUMMY',1347,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1348,NULL,'DUMMY',1348,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1349,NULL,'DUMMY',1349,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1350,NULL,'DUMMY',1350,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1351,NULL,'DUMMY',1351,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1352,NULL,'DUMMY',1352,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1353,NULL,'DUMMY',1353,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1354,NULL,'DUMMY',1354,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1355,NULL,'DUMMY',1355,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1356,NULL,'DUMMY',1356,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1357,NULL,'DUMMY',1357,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1358,NULL,'DUMMY',1358,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1359,NULL,'DUMMY',1359,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1360,NULL,'DUMMY',1360,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1361,NULL,'DUMMY',1361,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1362,NULL,'DUMMY',1362,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1363,NULL,'DUMMY',1363,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1364,NULL,'DUMMY',1364,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1365,NULL,'DUMMY',1365,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1366,NULL,'DUMMY',1366,1,'2021-05-28 02:08:08','2021-05-28 02:08:08'),(1367,NULL,'DUMMY',1367,1,'2021-05-30 19:14:57','2021-05-30 19:14:57'),(1368,NULL,'DUMMY',1368,1,'2021-05-30 19:14:58','2021-05-30 19:14:58'),(1369,NULL,'DUMMY',1367,1,'2021-06-25 20:22:04','2021-06-25 20:22:04'),(1370,NULL,'DUMMY',1368,1,'2021-06-25 20:22:43','2021-06-25 20:22:43'),(1371,NULL,'DUMMY',1369,1,'2021-06-25 20:23:35','2021-06-25 20:23:35'),(1372,NULL,'DUMMY',1370,1,'2021-06-25 20:26:01','2021-06-25 20:26:01'),(1373,NULL,'DUMMY',1371,1,'2021-06-25 20:27:05','2021-06-25 20:27:05'),(1374,NULL,'DUMMY',1372,1,'2021-06-25 20:28:09','2021-06-25 20:28:09'),(1375,NULL,'DUMMY',1373,1,'2021-06-25 20:30:10','2021-06-25 20:30:10'),(1376,NULL,'DUMMY',1374,1,'2021-06-25 20:30:52','2021-06-25 20:30:52'),(1377,NULL,'DUMMY',1375,1,'2021-06-25 20:31:55','2021-06-25 20:31:55'),(1378,NULL,'DUMMY',1376,1,'2021-06-25 20:32:28','2021-06-25 20:32:28'),(1379,NULL,'DUMMY',1377,1,'2021-06-25 20:33:46','2021-06-25 20:33:46'),(1380,NULL,'DUMMY',1378,1,'2021-06-27 16:51:24','2021-06-27 16:51:24'),(1381,NULL,'DUMMY',1379,1,'2021-08-03 14:53:57','2021-08-03 14:53:57'),(1382,NULL,'DUMMY',1380,1,'2021-08-03 14:59:10','2021-08-03 14:59:10'),(1383,NULL,'DUMMY',1381,1,'2021-08-03 15:00:57','2021-08-03 15:00:57'),(1384,NULL,'DUMMY',1382,1,'2021-08-03 15:01:55','2021-08-03 15:01:55'),(1385,NULL,'DUMMY',1383,1,'2021-08-03 15:03:22','2021-08-03 15:03:22'),(1386,NULL,'DUMMY',1384,1,'2021-08-03 15:03:41','2021-08-03 15:03:41'),(1387,NULL,'DUMMY',1385,1,'2021-08-03 15:05:07','2021-08-03 15:05:07'),(1388,NULL,'DUMMY',1386,1,'2021-08-03 15:09:11','2021-08-03 15:09:11'),(1389,NULL,'DUMMY',1387,1,'2021-08-03 15:10:58','2021-08-03 15:10:58'),(1390,NULL,'DUMMY',1388,1,'2021-08-03 15:15:19','2021-08-03 15:15:19'),(1391,NULL,'DUMMY',1389,1,'2021-08-03 15:18:22','2021-08-03 15:18:22'),(1392,NULL,'DUMMY',1390,1,'2021-08-03 17:31:59','2021-08-03 17:31:59'),(1393,NULL,'DUMMY',1391,1,'2021-08-03 17:36:09','2021-08-03 17:36:09'),(1394,NULL,'DUMMY',1392,1,'2021-08-03 17:42:29','2021-08-03 17:42:29'),(1395,NULL,'DUMMY',1393,1,'2021-08-03 20:37:13','2021-08-03 20:37:13'),(1396,NULL,'DUMMY',1394,1,'2021-08-03 20:42:16','2021-08-03 20:42:16'),(1397,NULL,'DUMMY',1395,1,'2021-08-03 20:43:43','2021-08-03 20:43:43'),(1398,NULL,'DUMMY',1396,1,'2021-08-03 20:44:16','2021-08-03 20:44:16'),(1399,NULL,'DUMMY',1397,1,'2021-08-03 20:46:53','2021-08-03 20:46:53'),(1400,NULL,'DUMMY',1398,1,'2021-08-03 20:49:59','2021-08-03 20:49:59'),(1401,NULL,'DUMMY',1399,1,'2021-08-03 21:16:01','2021-08-03 21:16:01'),(1402,NULL,'DUMMY',1400,1,'2021-08-04 13:55:57','2021-08-04 13:55:57'),(1403,NULL,'DUMMY',1401,1,'2021-08-04 13:56:46','2021-08-04 13:56:46'),(1404,NULL,'DUMMY',1402,1,'2021-08-04 14:03:28','2021-08-04 14:03:28'),(1405,NULL,'DUMMY',1403,1,'2021-08-04 14:11:16','2021-08-04 14:11:16'),(1406,NULL,'DUMMY',1404,1,'2021-08-04 14:16:37','2021-08-04 14:16:37'),(1407,NULL,'DUMMY',1405,1,'2021-08-04 14:44:03','2021-08-04 14:44:03'),(1408,NULL,'DUMMY',1406,1,'2021-08-04 15:19:44','2021-08-04 15:19:44'),(1409,NULL,'DUMMY',1407,1,'2021-08-04 15:19:47','2021-08-04 15:19:47'),(1410,NULL,'DUMMY',1408,1,'2021-08-04 15:20:42','2021-08-04 15:20:42'),(1411,NULL,'DUMMY',1409,1,'2021-08-04 15:26:28','2021-08-04 15:26:28'),(1412,NULL,'DUMMY',1410,1,'2021-08-04 16:08:01','2021-08-04 16:08:01'),(1413,NULL,'DUMMY',1411,1,'2021-08-04 16:16:34','2021-08-04 16:16:34'),(1414,NULL,'DUMMY',1412,1,'2021-08-04 16:41:43','2021-08-04 16:41:43'),(1415,NULL,'DUMMY',1413,1,'2021-08-04 16:44:52','2021-08-04 16:44:52'),(1416,NULL,'DUMMY',1414,1,'2021-08-04 16:56:02','2021-08-04 16:56:02'),(1417,NULL,'DUMMY',1415,1,'2021-08-04 17:00:41','2021-08-04 17:00:41'),(1418,NULL,'DUMMY',1416,1,'2021-08-04 17:02:43','2021-08-04 17:02:43'),(1419,NULL,'DUMMY',1417,1,'2021-08-04 19:39:44','2021-08-04 19:39:44'),(1420,NULL,'DUMMY',1418,1,'2021-08-04 19:41:53','2021-08-04 19:41:53'),(1421,NULL,'DUMMY',1419,1,'2021-08-04 19:44:18','2021-08-04 19:44:18'),(1422,NULL,'DUMMY',1420,1,'2021-08-04 19:47:05','2021-08-04 19:47:05'),(1423,NULL,'DUMMY',1421,1,'2021-08-04 20:00:16','2021-08-04 20:00:16'),(1424,NULL,'DUMMY',1422,1,'2021-08-04 21:44:34','2021-08-04 21:44:34'),(1425,NULL,'DUMMY',1423,1,'2021-08-04 21:48:40','2021-08-04 21:48:40'),(1426,NULL,'DUMMY',1424,1,'2021-08-04 21:53:08','2021-08-04 21:53:08'),(1427,NULL,'DUMMY',1425,1,'2021-08-04 21:57:32','2021-08-04 21:57:32'),(1428,NULL,'DUMMY',1426,1,'2021-08-04 21:59:07','2021-08-04 21:59:07'),(1429,NULL,'DUMMY',1427,1,'2021-08-04 21:59:58','2021-08-04 21:59:58'),(1430,NULL,'DUMMY',1428,1,'2021-08-04 22:04:20','2021-08-04 22:04:20'),(1431,NULL,'DUMMY',1429,1,'2021-08-04 22:16:29','2021-08-04 22:16:29'),(1432,NULL,'DUMMY',1430,1,'2021-08-04 22:18:13','2021-08-04 22:18:13'),(1433,NULL,'DUMMY',1431,1,'2021-08-04 22:23:01','2021-08-04 22:23:01'),(1434,NULL,'DUMMY',1432,1,'2021-08-04 22:26:44','2021-08-04 22:26:44'),(1435,NULL,'DUMMY',1433,1,'2021-08-04 22:27:23','2021-08-04 22:27:23'),(1436,NULL,'DUMMY',1434,1,'2021-08-04 22:28:17','2021-08-04 22:28:17'),(1437,NULL,'DUMMY',1435,1,'2021-08-04 22:30:27','2021-08-04 22:30:27'),(1438,NULL,'DUMMY',1436,1,'2021-08-04 22:34:01','2021-08-04 22:34:01'),(1439,NULL,'DUMMY',1437,1,'2021-08-04 22:36:20','2021-08-04 22:36:20'),(1440,NULL,'DUMMY',1438,1,'2021-08-04 22:40:31','2021-08-04 22:40:31'),(1441,NULL,'DUMMY',1439,1,'2021-08-04 22:43:48','2021-08-04 22:43:48'),(1442,NULL,'DUMMY',1440,1,'2021-08-04 22:45:36','2021-08-04 22:45:36'),(1443,NULL,'DUMMY',1441,1,'2021-08-04 23:36:14','2021-08-04 23:36:14'),(1444,NULL,'DUMMY',1442,1,'2021-08-04 23:36:49','2021-08-04 23:36:49'),(1445,NULL,'DUMMY',1443,1,'2021-08-05 13:34:26','2021-08-05 13:34:26'),(1446,NULL,'DUMMY',1444,1,'2021-08-05 13:36:07','2021-08-05 13:36:07'),(1447,NULL,'DUMMY',1445,1,'2021-08-05 14:44:11','2021-08-05 14:44:11'),(1448,NULL,'DUMMY',1446,1,'2021-08-05 16:16:40','2021-08-05 16:16:40'),(1449,NULL,'DUMMY',1447,1,'2021-08-05 16:18:58','2021-08-05 16:18:58'),(1450,NULL,'DUMMY',1448,1,'2021-08-05 16:36:28','2021-08-05 16:36:28'),(1451,NULL,'DUMMY',1449,1,'2021-08-05 16:48:27','2021-08-05 16:48:27'),(1452,NULL,'DUMMY',1450,1,'2021-08-05 16:48:53','2021-08-05 16:48:53'),(1453,NULL,'DUMMY',1451,1,'2021-08-05 16:52:27','2021-08-05 16:52:27'),(1454,NULL,'DUMMY',1452,1,'2021-08-05 16:54:50','2021-08-05 16:54:50'),(1455,NULL,'DUMMY',1453,1,'2021-08-05 17:04:25','2021-08-05 17:04:25'),(1456,NULL,'DUMMY',1454,1,'2021-08-05 20:48:15','2021-08-05 20:48:15'),(1457,NULL,'DUMMY',1455,1,'2021-08-05 20:49:47','2021-08-05 20:49:47'),(1458,NULL,'DUMMY',1456,1,'2021-08-05 20:57:05','2021-08-05 20:57:05'),(1459,NULL,'DUMMY',1457,1,'2021-08-05 20:59:53','2021-08-05 20:59:53'),(1460,NULL,'DUMMY',1458,1,'2021-08-05 21:44:19','2021-08-05 21:44:19'),(1461,NULL,'DUMMY',1459,1,'2021-08-05 21:59:24','2021-08-05 21:59:24'),(1462,NULL,'DUMMY',1460,1,'2021-08-05 22:04:09','2021-08-05 22:04:09'),(1463,NULL,'DUMMY',1461,1,'2021-08-05 22:05:42','2021-08-05 22:05:42'),(1464,NULL,'DUMMY',1462,1,'2021-08-05 22:18:51','2021-08-05 22:18:51'),(1465,NULL,'DUMMY',1463,1,'2021-08-05 22:19:22','2021-08-05 22:19:22'),(1466,NULL,'DUMMY',1464,1,'2021-08-05 22:20:06','2021-08-05 22:20:06'),(1467,NULL,'DUMMY',1465,1,'2021-08-05 22:26:24','2021-08-05 22:26:24'),(1468,NULL,'DUMMY',1466,1,'2021-08-05 22:28:45','2021-08-05 22:28:45'),(1469,NULL,'DUMMY',1467,1,'2021-08-05 23:11:53','2021-08-05 23:11:53'),(1470,NULL,'DUMMY',1468,1,'2021-08-06 14:48:43','2021-08-06 14:48:43'),(1471,NULL,'DUMMY',1469,1,'2021-08-06 14:55:05','2021-08-06 14:55:05'),(1472,NULL,'DUMMY',1470,1,'2021-08-06 14:56:32','2021-08-06 14:56:32'),(1473,NULL,'DUMMY',1471,1,'2021-08-06 15:00:38','2021-08-06 15:00:38'),(1474,NULL,'DUMMY',1472,1,'2021-08-06 15:01:02','2021-08-06 15:01:02'),(1475,NULL,'DUMMY',1473,1,'2021-08-06 15:05:54','2021-08-06 15:05:54'),(1476,NULL,'DUMMY',1474,1,'2021-08-06 15:08:08','2021-08-06 15:08:08'),(1477,NULL,'DUMMY',1475,1,'2021-08-06 15:09:45','2021-08-06 15:09:45'),(1478,NULL,'DUMMY',1476,1,'2021-08-06 15:44:05','2021-08-06 15:44:05'),(1479,NULL,'DUMMY',1477,1,'2021-08-06 15:51:55','2021-08-06 15:51:55'),(1480,NULL,'DUMMY',1478,1,'2021-08-06 15:54:39','2021-08-06 15:54:39'),(1481,NULL,'DUMMY',1479,1,'2021-08-06 15:55:54','2021-08-06 15:55:54'),(1482,NULL,'DUMMY',1480,1,'2021-08-06 15:59:50','2021-08-06 15:59:50'),(1483,NULL,'DUMMY',1481,1,'2021-08-06 16:04:01','2021-08-06 16:04:01'),(1484,NULL,'DUMMY',1482,1,'2021-08-06 16:05:08','2021-08-06 16:05:08'),(1485,NULL,'DUMMY',1483,1,'2021-08-06 16:06:30','2021-08-06 16:06:30'),(1486,NULL,'DUMMY',1484,1,'2021-08-06 16:09:35','2021-08-06 16:09:35'),(1487,NULL,'DUMMY',1485,1,'2021-08-06 16:14:39','2021-08-06 16:14:39'),(1488,NULL,'DUMMY',1486,1,'2021-08-06 16:20:04','2021-08-06 16:20:04'),(1489,NULL,'DUMMY',1487,1,'2021-08-06 16:26:15','2021-08-06 16:26:15'),(1490,NULL,'DUMMY',1488,1,'2021-08-06 16:29:09','2021-08-06 16:29:09'),(1491,NULL,'DUMMY',1489,1,'2021-08-06 16:30:12','2021-08-06 16:30:12'),(1492,NULL,'DUMMY',1490,1,'2021-08-06 16:31:48','2021-08-06 16:31:48'),(1493,NULL,'DUMMY',1491,1,'2021-08-06 16:34:43','2021-08-06 16:34:43'),(1494,NULL,'DUMMY',1492,1,'2021-08-06 16:35:50','2021-08-06 16:35:50'),(1495,NULL,'DUMMY',1493,1,'2021-08-06 16:37:43','2021-08-06 16:37:43'),(1496,NULL,'DUMMY',1494,1,'2021-08-06 16:39:21','2021-08-06 16:39:21'),(1497,NULL,'DUMMY',1495,1,'2021-08-06 16:40:28','2021-08-06 16:40:28'),(1498,NULL,'DUMMY',1496,1,'2021-08-06 16:43:34','2021-08-06 16:43:34'),(1499,NULL,'DUMMY',1497,1,'2021-08-06 16:44:27','2021-08-06 16:44:27'),(1500,NULL,'DUMMY',1498,1,'2021-08-06 16:45:33','2021-08-06 16:45:33'),(1501,NULL,'DUMMY',1499,1,'2021-08-06 16:46:41','2021-08-06 16:46:41'),(1502,NULL,'DUMMY',1500,1,'2021-08-06 16:47:52','2021-08-06 16:47:52'),(1503,NULL,'DUMMY',1501,1,'2021-08-06 16:49:26','2021-08-06 16:49:26'),(1504,NULL,'DUMMY',1502,1,'2021-08-06 16:50:56','2021-08-06 16:50:56'),(1505,NULL,'DUMMY',1503,1,'2021-08-06 19:49:30','2021-08-06 19:49:30'),(1506,NULL,'DUMMY',1504,1,'2021-08-06 19:50:37','2021-08-06 19:50:37'),(1507,NULL,'DUMMY',1505,1,'2021-08-06 19:51:07','2021-08-06 19:51:07'),(1508,NULL,'DUMMY',1506,1,'2021-08-06 20:16:09','2021-08-06 20:16:09'),(1509,NULL,'DUMMY',1507,1,'2021-08-06 20:17:20','2021-08-06 20:17:20'),(1510,NULL,'DUMMY',1508,1,'2021-08-06 20:19:14','2021-08-06 20:19:14'),(1511,NULL,'DUMMY',1509,1,'2021-08-06 20:48:01','2021-08-06 20:48:01'),(1512,NULL,'DUMMY',1510,1,'2021-08-06 21:50:24','2021-08-06 21:50:24'),(1513,NULL,'DUMMY',1511,1,'2021-08-06 21:51:46','2021-08-06 21:51:46'),(1514,NULL,'DUMMY',1512,1,'2021-08-06 21:53:22','2021-08-06 21:53:22'),(1515,NULL,'DUMMY',1513,1,'2021-08-06 21:56:31','2021-08-06 21:56:31'),(1516,NULL,'DUMMY',1514,1,'2021-08-06 21:58:19','2021-08-06 21:58:19'),(1517,NULL,'DUMMY',1515,1,'2021-08-06 21:59:52','2021-08-06 21:59:52'),(1518,NULL,'DUMMY',1516,1,'2021-08-06 22:01:55','2021-08-06 22:01:55'),(1519,NULL,'DUMMY',1517,1,'2021-08-06 22:04:44','2021-08-06 22:04:44'),(1520,NULL,'DUMMY',1518,1,'2021-08-06 22:06:25','2021-08-06 22:06:25'),(1521,NULL,'DUMMY',1519,1,'2021-08-06 22:09:48','2021-08-06 22:09:48'),(1522,NULL,'DUMMY',1520,1,'2021-08-06 22:13:15','2021-08-06 22:13:15'),(1523,NULL,'DUMMY',1521,1,'2021-08-06 22:13:43','2021-08-06 22:13:43'),(1524,NULL,'DUMMY',1522,1,'2021-08-06 22:14:30','2021-08-06 22:14:30'),(1525,NULL,'DUMMY',1523,1,'2021-08-06 22:18:42','2021-08-06 22:18:42'),(1526,NULL,'DUMMY',1524,1,'2021-08-06 22:20:29','2021-08-06 22:20:29'),(1527,NULL,'DUMMY',1525,1,'2021-08-07 14:05:52','2021-08-07 14:05:52'),(1528,NULL,'DUMMY',1526,1,'2021-08-07 14:47:38','2021-08-07 14:47:38'),(1529,NULL,'DUMMY',1527,1,'2021-08-07 14:49:53','2021-08-07 14:49:53'),(1530,NULL,'DUMMY',1528,1,'2021-08-14 14:23:05','2021-08-14 14:23:05'),(1531,NULL,'DUMMY',1529,1,'2021-08-14 14:24:37','2021-08-14 14:24:37'),(1532,NULL,'DUMMY',1530,1,'2021-08-14 14:30:23','2021-08-14 14:30:23'),(1533,NULL,'DUMMY',1531,1,'2021-08-14 14:31:40','2021-08-14 14:31:40'),(1534,NULL,'DUMMY',1532,1,'2021-08-14 14:45:16','2021-08-14 14:45:16'),(1535,NULL,'DUMMY',1533,1,'2021-08-14 14:46:28','2021-08-14 14:46:28'),(1536,NULL,'DUMMY',1534,1,'2021-08-14 14:49:21','2021-08-14 14:49:21'),(1537,NULL,'DUMMY',1535,1,'2021-08-14 14:51:00','2021-08-14 14:51:00'),(1538,NULL,'DUMMY',1536,1,'2021-08-14 14:52:08','2021-08-14 14:52:08'),(1539,NULL,'DUMMY',1537,1,'2021-08-14 14:53:19','2021-08-14 14:53:19'),(1540,NULL,'DUMMY',1538,1,'2021-08-14 14:57:44','2021-08-14 14:57:44'),(1541,NULL,'DUMMY',1539,1,'2021-08-14 14:58:14','2021-08-14 14:58:14'),(1542,NULL,'DUMMY',1540,1,'2021-08-14 15:46:07','2021-08-14 15:46:07'),(1543,NULL,'DUMMY',1541,1,'2021-08-17 22:55:45','2021-08-17 22:55:45'),(1544,NULL,'DUMMY',1542,1,'2021-08-18 13:15:34','2021-08-18 13:15:34'),(1545,NULL,'DUMMY',1543,1,'2021-08-18 13:16:07','2021-08-18 13:16:07'),(1546,NULL,'DUMMY',1544,1,'2021-08-18 13:16:35','2021-08-18 13:16:35'),(1547,NULL,'DUMMY',1545,1,'2021-08-18 13:16:58','2021-08-18 13:16:58'),(1548,NULL,'DUMMY',1546,1,'2021-08-20 15:41:48','2021-08-20 15:41:48'),(1549,NULL,'DUMMY',1547,1,'2021-08-20 15:46:31','2021-08-20 15:46:31'),(1550,NULL,'DUMMY',1548,1,'2021-08-25 16:09:43','2021-08-25 16:09:43'),(1551,NULL,'DUMMY',1549,1,'2021-08-25 16:10:40','2021-08-25 16:10:40'),(1552,NULL,'DUMMY',1550,1,'2021-08-28 14:51:44','2021-08-28 14:51:44'),(1553,NULL,'DUMMY',1551,1,'2021-08-29 15:20:28','2021-08-29 15:20:28'),(1554,NULL,'DUMMY',1552,1,'2021-08-29 15:20:49','2021-08-29 15:20:49'),(1555,NULL,'DUMMY',1553,1,'2021-08-29 15:21:11','2021-08-29 15:21:11'),(1556,NULL,'DUMMY',1554,1,'2021-08-31 20:47:50','2021-08-31 20:47:50'),(1557,NULL,'DUMMY',1555,1,'2021-08-31 20:48:20','2021-08-31 20:48:20'),(1558,NULL,'DUMMY',1556,1,'2021-09-01 18:50:48','2021-09-01 18:50:48'),(1559,NULL,'DUMMY',1557,1,'2021-09-01 18:51:10','2021-09-01 18:51:10'),(1560,NULL,'DUMMY',1558,1,'2021-09-09 14:25:50','2021-09-09 14:25:50'),(1561,NULL,'DUMMY',1559,1,'2021-09-09 14:37:14','2021-09-09 14:37:14'),(1562,NULL,'DUMMY',1560,1,'2021-09-09 14:37:43','2021-09-09 14:37:43'),(1563,NULL,'DUMMY',1561,1,'2021-09-09 14:38:10','2021-09-09 14:38:10'),(1564,NULL,'DUMMY',1562,1,'2021-09-10 14:10:23','2021-09-10 14:10:23'),(1565,NULL,'DUMMY',1563,1,'2021-09-10 14:11:45','2021-09-10 14:11:45'),(1566,NULL,'DUMMY',1564,1,'2021-09-12 14:45:47','2021-09-12 14:45:47'),(1567,NULL,'DUMMY',1565,1,'2021-09-14 14:50:33','2021-09-14 14:50:33'),(1568,NULL,'DUMMY',1566,1,'2021-09-14 14:52:52','2021-09-14 14:52:52'),(1569,NULL,'DUMMY',1567,1,'2021-09-14 15:35:27','2021-09-14 15:35:27'),(1570,NULL,'DUMMY',1568,1,'2021-09-15 14:25:49','2021-09-15 14:25:49'),(1571,NULL,'DUMMY',1569,1,'2021-09-17 14:12:46','2021-09-17 14:12:46'),(1572,NULL,'DUMMY',1570,1,'2021-09-18 13:54:26','2021-09-18 13:54:26'),(1573,NULL,'DUMMY',1571,1,'2021-09-21 15:26:23','2021-09-21 15:26:23'),(1574,NULL,'DUMMY',1572,1,'2021-09-21 15:44:29','2021-09-21 15:44:29'),(1575,NULL,'DUMMY',1573,1,'2021-09-22 14:12:30','2021-09-22 14:12:30'),(1576,NULL,'DUMMY',1574,1,'2021-09-22 14:12:55','2021-09-22 14:12:55'),(1577,NULL,'DUMMY',1575,1,'2021-09-22 14:23:42','2021-09-22 14:23:42'),(1578,NULL,'DUMMY',1576,1,'2021-09-27 21:52:13','2021-09-27 21:52:13'),(1579,NULL,'DUMMY',1577,1,'2021-09-27 21:53:09','2021-09-27 21:53:09'),(1580,NULL,'DUMMY',1578,1,'2021-09-27 21:54:07','2021-09-27 21:54:07'),(1581,NULL,'DUMMY',1579,1,'2021-09-27 21:55:24','2021-09-27 21:55:24'),(1582,NULL,'DUMMY',1580,1,'2021-09-28 17:16:55','2021-09-28 17:16:55'),(1583,NULL,'DUMMY',1581,1,'2021-09-30 21:09:35','2021-09-30 21:09:35'),(1584,NULL,'DUMMY',1582,1,'2021-10-06 14:02:58','2021-10-06 14:02:58'),(1585,NULL,'DUMMY',1583,1,'2021-10-06 14:03:22','2021-10-06 14:03:22'),(1586,NULL,'DUMMY',1584,1,'2021-10-06 14:03:46','2021-10-06 14:03:46'),(1587,NULL,'DUMMY',1585,1,'2021-10-06 14:04:37','2021-10-06 14:04:37'),(1588,NULL,'DUMMY',1586,1,'2021-10-06 14:04:57','2021-10-06 14:04:57'),(1589,NULL,'DUMMY',1587,1,'2021-10-06 14:05:18','2021-10-06 14:05:18'),(1590,NULL,'DUMMY',1588,1,'2021-10-06 14:14:20','2021-10-06 14:14:20'),(1591,NULL,'DUMMY',1589,1,'2021-10-06 20:24:00','2021-10-06 20:24:00'),(1592,NULL,'DUMMY',1590,1,'2021-10-06 20:27:41','2021-10-06 20:27:41'),(1593,NULL,'DUMMY',1591,1,'2021-10-06 20:28:14','2021-10-06 20:28:14'),(1594,NULL,'DUMMY',1592,1,'2021-10-08 16:31:29','2021-10-08 16:31:29'),(1595,NULL,'DUMMY',1593,1,'2021-10-10 13:39:32','2021-10-10 13:39:32'),(1596,NULL,'DUMMY',1594,1,'2021-10-10 13:39:51','2021-10-10 13:39:51'),(1597,NULL,'DUMMY',1595,1,'2021-10-10 13:53:48','2021-10-10 13:53:48'),(1598,NULL,'DUMMY',1596,1,'2021-10-10 13:54:17','2021-10-10 13:54:17'),(1599,NULL,'DUMMY',1597,1,'2021-10-12 13:37:05','2021-10-12 13:37:05'),(1600,NULL,'DUMMY',1598,1,'2021-10-12 13:41:30','2021-10-12 13:41:30'),(1601,NULL,'DUMMY',1599,1,'2021-10-12 13:41:59','2021-10-12 13:41:59'),(1602,NULL,'DUMMY',1600,1,'2021-10-12 13:47:00','2021-10-12 13:47:00'),(1603,NULL,'DUMMY',1601,1,'2021-10-13 14:42:41','2021-10-13 14:42:41'),(1604,NULL,'DUMMY',1602,1,'2021-10-13 15:32:09','2021-10-13 15:32:09'),(1605,NULL,'DUMMY',1603,1,'2021-10-14 14:04:41','2021-10-14 14:04:41'),(1606,NULL,'DUMMY',1604,1,'2021-10-14 14:05:04','2021-10-14 14:05:04'),(1607,NULL,'DUMMY',1605,1,'2021-10-14 22:37:18','2021-10-14 22:37:18'),(1608,NULL,'DUMMY',1606,1,'2021-10-14 22:37:54','2021-10-14 22:37:54'),(1609,NULL,'DUMMY',1607,1,'2021-10-14 22:38:39','2021-10-14 22:38:39'),(1610,NULL,'DUMMY',1608,1,'2021-10-14 22:39:26','2021-10-14 22:39:26'),(1611,NULL,'DUMMY',1609,1,'2021-10-14 22:39:54','2021-10-14 22:39:54'),(1612,NULL,'DUMMY',1610,1,'2021-10-14 22:40:41','2021-10-14 22:40:41'),(1613,NULL,'DUMMY',1611,1,'2021-10-14 22:41:10','2021-10-14 22:41:10'),(1614,NULL,'DUMMY',1612,1,'2021-10-15 16:14:27','2021-10-15 16:14:27'),(1615,NULL,'DUMMY',1613,1,'2021-10-15 16:18:37','2021-10-15 16:18:37'),(1616,NULL,'DUMMY',1614,1,'2021-10-15 22:43:37','2021-10-15 22:43:37'),(1617,NULL,'DUMMY',1615,1,'2021-10-15 22:44:37','2021-10-15 22:44:37'),(1618,NULL,'DUMMY',1616,1,'2021-10-15 22:45:16','2021-10-15 22:45:16'),(1619,NULL,'DUMMY',1617,1,'2021-10-15 23:01:30','2021-10-15 23:01:30'),(1620,NULL,'DUMMY',1618,1,'2021-10-17 14:15:18','2021-10-17 14:15:18'),(1621,NULL,'DUMMY',1619,1,'2021-10-17 14:15:45','2021-10-17 14:15:45'),(1622,NULL,'DUMMY',1620,1,'2021-10-18 17:17:36','2021-10-18 17:17:36'),(1623,NULL,'DUMMY',1621,1,'2021-10-18 17:18:43','2021-10-18 17:18:43'),(1624,NULL,'DUMMY',1622,1,'2021-10-18 17:19:37','2021-10-18 17:19:37'),(1625,NULL,'DUMMY',1623,1,'2021-10-18 17:20:31','2021-10-18 17:20:31'),(1626,NULL,'DUMMY',1624,1,'2021-10-20 19:12:26','2021-10-20 19:12:26'),(1627,NULL,'DUMMY',1625,1,'2021-10-20 19:13:07','2021-10-20 19:13:07'),(1628,NULL,'DUMMY',1626,1,'2021-10-21 14:28:04','2021-10-21 14:28:04'),(1629,NULL,'DUMMY',1627,1,'2021-10-21 14:31:50','2021-10-21 14:31:50'),(1630,NULL,'DUMMY',1628,1,'2021-10-21 14:32:30','2021-10-21 14:32:30'),(1631,NULL,'DUMMY',1629,1,'2021-10-21 14:33:07','2021-10-21 14:33:07'),(1632,NULL,'DUMMY',1630,1,'2021-10-21 14:35:14','2021-10-21 14:35:14'),(1633,NULL,'DUMMY',1631,1,'2021-10-21 14:35:36','2021-10-21 14:35:36'),(1634,NULL,'DUMMY',1632,1,'2021-10-22 14:46:02','2021-10-22 14:46:02'),(1635,NULL,'DUMMY',1633,1,'2021-10-22 15:10:28','2021-10-22 15:10:28'),(1636,NULL,'DUMMY',1634,1,'2021-10-23 15:41:54','2021-10-23 15:41:54'),(1637,NULL,'DUMMY',1635,1,'2021-10-23 15:42:30','2021-10-23 15:42:30'),(1638,NULL,'DUMMY',1636,1,'2021-10-23 15:42:53','2021-10-23 15:42:53'),(1639,NULL,'DUMMY',1637,1,'2021-10-23 15:43:11','2021-10-23 15:43:11'),(1640,NULL,'DUMMY',1638,1,'2021-10-23 19:30:26','2021-10-23 19:30:26'),(1641,NULL,'DUMMY',1639,1,'2021-10-23 19:30:49','2021-10-23 19:30:49'),(1642,NULL,'DUMMY',1640,1,'2021-10-23 19:48:27','2021-10-23 19:48:27'),(1643,NULL,'DUMMY',1641,1,'2021-10-23 19:48:50','2021-10-23 19:48:50'),(1644,NULL,'DUMMY',1642,1,'2021-10-23 19:55:38','2021-10-23 19:55:38'),(1645,NULL,'DUMMY',1643,1,'2021-10-24 13:43:29','2021-10-24 13:43:29'),(1646,NULL,'DUMMY',1644,1,'2021-10-24 15:20:48','2021-10-24 15:20:48'),(1647,NULL,'DUMMY',1645,1,'2021-10-24 15:23:43','2021-10-24 15:23:43'),(1648,NULL,'DUMMY',1646,1,'2021-10-25 19:42:10','2021-10-25 19:42:10'),(1649,NULL,'DUMMY',1647,1,'2021-11-14 03:11:27','2021-11-14 03:11:27'),(1650,NULL,'DUMMY',1648,1,'2021-11-20 16:08:09','2021-11-20 16:08:09'),(1651,NULL,'DUMMY',1649,1,'2021-11-20 20:53:48','2021-11-20 20:53:48'),(1652,NULL,'DUMMY',1650,1,'2021-11-20 21:42:24','2021-11-20 21:42:24'),(1653,NULL,'DUMMY',1651,1,'2021-11-23 16:25:19','2021-11-23 16:25:19'),(1654,NULL,'DUMMY',1652,1,'2021-11-23 16:25:48','2021-11-23 16:25:48'),(1655,NULL,'DUMMY',1653,1,'2021-12-04 16:29:39','2021-12-04 16:29:39'),(1656,NULL,'DUMMY',1654,1,'2021-12-11 10:06:51','2021-12-11 10:06:51'),(1657,NULL,'DUMMY',1655,1,'2021-12-14 09:08:46','2021-12-14 09:08:46'),(1658,NULL,'DUMMY',1656,1,'2021-12-14 09:17:05','2021-12-14 09:17:05'),(1659,NULL,'DUMMY',1657,1,'2021-12-14 09:29:48','2021-12-14 09:29:48'),(1660,NULL,'DUMMY',1658,1,'2022-01-11 08:22:03','2022-01-11 08:22:03'),(1661,NULL,'DUMMY',1659,1,'2022-01-13 15:44:46','2022-01-13 15:44:46'),(1662,NULL,'DUMMY',1660,1,'2022-01-14 08:00:39','2022-01-14 08:00:39'),(1663,13,'BLACK',1661,0,'2022-01-14 14:18:17','2022-01-15 17:47:44'),(1664,NULL,'DUMMY',1662,1,'2022-01-15 17:57:55','2022-01-15 17:57:55'),(1665,NULL,'DUMMY',1663,1,'2022-02-12 05:06:32','2022-02-12 05:06:32'),(1666,15,'White',1664,0,'2022-02-12 05:09:45','2022-02-12 05:14:30'),(1667,16,'Size',1665,0,'2022-02-12 05:18:00','2022-02-12 05:59:35'),(1668,16,'Size',1666,0,'2022-02-12 05:23:32','2022-02-12 05:59:35'),(1669,16,'Size',1667,0,'2022-02-12 05:43:39','2022-02-12 05:59:35'),(1670,16,'Size',1668,0,'2022-02-12 05:46:22','2022-02-12 05:59:35'),(1671,NULL,'DUMMY',1669,1,'2022-02-20 01:38:59','2022-02-20 01:38:59'),(1672,NULL,'DUMMY',1670,1,'2022-02-20 01:52:29','2022-02-20 01:52:29'),(1673,NULL,'DUMMY',1671,1,'2022-02-20 08:23:06','2022-02-20 08:23:06'),(1674,16,'Size',1672,0,'2022-02-20 10:32:20','2022-02-20 10:32:20'),(1675,16,'Size',1673,0,'2022-02-20 10:37:27','2022-02-20 10:37:27'),(1676,NULL,'DUMMY',1674,1,'2022-02-21 00:10:02','2022-02-21 00:10:02'),(1677,NULL,'DUMMY',1675,1,'2022-02-21 00:11:26','2022-02-21 00:11:26'),(1678,NULL,'DUMMY',1676,1,'2022-02-21 00:19:15','2022-02-21 00:19:15'),(1679,16,'Size',1677,0,'2022-02-22 05:04:58','2022-02-22 05:04:58'),(1680,NULL,'DUMMY',1678,1,'2022-02-22 05:04:58','2022-02-22 05:04:58'),(1681,NULL,'DUMMY',1679,1,'2022-02-22 06:35:30','2022-02-22 06:35:30'),(1682,NULL,'DUMMY',1680,1,'2022-02-23 05:39:23','2022-02-23 05:39:23'),(1683,NULL,'DUMMY',1681,1,'2022-02-24 04:06:20','2022-02-24 04:06:20'),(1684,NULL,'DUMMY',1682,1,'2022-02-24 04:08:08','2022-02-24 04:08:08'),(1685,NULL,'DUMMY',1683,1,'2022-02-24 04:22:29','2022-02-24 04:22:29'),(1686,NULL,'DUMMY',1684,1,'2022-02-24 04:24:36','2022-02-24 04:24:36'),(1687,NULL,'DUMMY',1685,1,'2022-02-24 04:25:29','2022-02-24 04:25:29'),(1688,NULL,'DUMMY',1686,1,'2022-02-24 04:50:40','2022-02-24 04:50:40'),(1689,NULL,'DUMMY',1687,1,'2022-03-31 03:10:24','2022-03-31 03:10:24'),(1690,NULL,'DUMMY',1688,1,'2022-04-12 04:32:21','2022-04-12 04:32:21'),(1691,NULL,'DUMMY',1689,1,'2022-04-12 04:38:09','2022-04-12 04:38:09'),(1692,NULL,'DUMMY',1690,1,'2022-04-12 04:52:25','2022-04-12 04:52:25'),(1693,NULL,'DUMMY',1691,1,'2022-04-13 06:58:18','2022-04-13 06:58:18'),(1694,NULL,'DUMMY',1692,1,'2022-04-20 05:11:01','2022-04-20 05:11:01'),(1695,NULL,'DUMMY',1693,1,'2022-05-31 12:45:19','2022-05-31 12:45:19'),(1696,NULL,'DUMMY',1694,1,'2022-06-06 02:08:25','2022-06-06 02:08:25'),(1697,NULL,'DUMMY',1695,1,'2022-06-06 14:22:18','2022-06-06 14:22:18'),(1698,15,'White',1696,0,'2022-06-19 05:38:12','2022-06-19 05:38:12'),(1699,NULL,'DUMMY',1697,1,'2022-06-28 10:40:15','2022-06-28 10:40:15'),(1700,NULL,'DUMMY',1698,1,'2022-08-30 10:24:38','2022-08-30 10:24:38'),(1701,NULL,'DUMMY',1699,1,'2022-08-30 10:26:10','2022-08-30 10:26:10'),(1702,NULL,'DUMMY',1700,1,'2022-08-30 10:27:42','2022-08-30 10:27:42'),(1703,NULL,'DUMMY',1701,1,'2022-08-30 10:29:13','2022-08-30 10:29:13'),(1704,16,'Size',1702,0,'2022-10-01 05:37:08','2022-10-01 05:37:08'),(1705,NULL,'DUMMY',1703,1,'2022-11-21 16:52:59','2022-11-21 16:52:59'),(1706,NULL,'DUMMY',1704,1,'2023-01-16 05:00:24','2023-01-16 05:00:24'),(1707,NULL,'DUMMY',1705,1,'2023-03-13 06:15:59','2023-03-13 06:15:59'),(1708,NULL,'DUMMY',1706,1,'2023-03-13 06:26:36','2023-03-13 06:26:36'),(1709,NULL,'DUMMY',1707,1,'2023-03-13 12:00:18','2023-03-13 12:00:18'),(1710,NULL,'DUMMY',1708,1,'2023-03-14 03:43:11','2023-03-14 03:43:11'),(1711,NULL,'DUMMY',1709,1,'2023-03-14 04:07:40','2023-03-14 04:07:40'),(1712,NULL,'DUMMY',1710,1,'2023-03-14 05:12:05','2023-03-14 05:12:05'),(1713,NULL,'DUMMY',1711,1,'2023-03-14 13:07:05','2023-03-14 13:07:05'),(1714,NULL,'DUMMY',1712,1,'2023-03-15 17:05:15','2023-03-15 17:05:15'),(1715,NULL,'DUMMY',1713,1,'2023-03-15 17:36:38','2023-03-15 17:36:38'),(1716,NULL,'DUMMY',1714,1,'2023-03-16 04:02:18','2023-03-16 04:02:18'),(1717,NULL,'DUMMY',1715,1,'2023-03-16 05:31:28','2023-03-16 05:31:28'),(1718,NULL,'DUMMY',1716,1,'2023-03-23 03:14:25','2023-03-23 03:14:25'),(1719,NULL,'DUMMY',1717,1,'2023-03-23 04:12:21','2023-03-23 04:12:21'),(1720,NULL,'DUMMY',1718,1,'2023-03-23 14:38:18','2023-03-23 14:38:18'),(1721,NULL,'DUMMY',1719,1,'2023-03-29 03:10:35','2023-03-29 03:10:35'),(1722,NULL,'DUMMY',1720,1,'2023-03-30 03:24:04','2023-03-30 03:24:04'),(1723,NULL,'DUMMY',1721,1,'2023-06-01 09:04:18','2023-06-01 09:04:18'),(1724,NULL,'DUMMY',1722,1,'2023-06-01 09:10:35','2023-06-01 09:10:35'),(1725,NULL,'DUMMY',1723,1,'2023-06-01 09:28:05','2023-06-01 09:28:05'),(1726,NULL,'DUMMY',1724,1,'2023-06-22 03:57:05','2023-06-22 03:57:05'),(1727,NULL,'DUMMY',1725,1,'2023-07-18 06:22:24','2023-07-18 06:22:24'),(1728,NULL,'DUMMY',1726,1,'2023-07-19 03:27:05','2023-07-19 03:27:05');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier') DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `reseller_price` double NOT NULL,
  `mrp_price` double NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` int(11) NOT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_product_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `initial_stock` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=1727 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'Test',1,'single',22,NULL,NULL,NULL,NULL,'exclusive',0,0,1,2,'AS0001','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2021-05-27 16:02:57','2021-05-27 16:02:57',NULL),(2,'Marcel MFA 2A3 RXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfa2a3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:52:20',NULL),(3,'Marcel MFB A8E',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfba8e','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:48:37',NULL),(4,'Marcel MFE B9E Crxxxx',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfeb9e','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:13:33',NULL),(7,'Marcel MFC C1E',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfcc1e','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:23:34',NULL),(17,'Marcel MFA B2X RXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfab2xRXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:51:31',NULL),(18,'Marcel MFA B4D RNXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfab4dRX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 21:21:08',NULL),(19,'Walton WD1-Dt24RL100',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'wd1dt24rl100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:15:30',NULL),(20,'Walton WE326AH',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'we326ah','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 15:50:05',NULL),(21,'Walton Stabilizar 600SD',9,'single',30,NULL,36,43,NULL,'inclusive',0,0,1,1,'stabilizar600Sd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:33:24',NULL),(22,'Walton Stabilizar 2000SD',9,'single',30,NULL,36,45,NULL,'inclusive',0,0,1,1,'stabilizar2000sd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:18:20',NULL),(23,'Walton Combaind Switch 6P Soket',9,'single',30,NULL,36,46,NULL,'inclusive',0,0,1,1,'w6pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 15:58:30',NULL),(30,'WRC- M320(3.2LT)',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcm3203.2lt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 16:37:23',NULL),(34,'WRC- D220(2.2LT)',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcd2202.2lt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:33:05',NULL),(37,'WRC- MS220-MTC',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcms220mtc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 17:05:50',NULL),(39,'WRC- M182(1.8L)',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcm1821.8l','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:54:31',NULL),(40,'WRC- M180(1.8LT)',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcm1801.8lt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 17:08:51',NULL),(41,'WRC- M181(1.8LT)',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcm1811.8lt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:54:46',NULL),(43,'WRC- CGA180',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrccga180','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:05:55',NULL),(44,'WRC- CGA280',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrccga280','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:21:56',NULL),(45,'WRC- CSS220',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'wrcss220','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 14:57:51',NULL),(46,'WB-LBO(SS3in1)',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'wblbo1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:46:09',NULL),(47,'MB-VK01-MIXER GRINDER',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbmg30','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:47:51',NULL),(48,'WBL-JYL22',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbjgyl22','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:45:41',NULL),(49,'WB-Q409(2in1)',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbq409','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:41:05',NULL),(50,'WB-AM930',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbam930','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 16:07:17',NULL),(51,'WBL-15GC40(MTC)',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbl15gc40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:15:30',NULL),(52,'WB-AM630',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbam630','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:25:14',NULL),(54,'WBL-13PC40',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbl13pc40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 21:03:27',NULL),(55,'MBL-15GC40(1.5LT)',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'mbl15gc40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:38:44',NULL),(56,'WBL-13EC25',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbl13ec25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:50:09',NULL),(57,'WB-PN20',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbpn20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:15:26',NULL),(58,'WBL-13EX25',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbl13ex25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 15:50:42',NULL),(59,'WBL-13CC25',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbl13cc25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:53:20',NULL),(60,'WBL-13X25',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wbl13cx25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 21:30:16',NULL),(61,'WK-DW155(1.5)DOUBLE LAYER',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'wkdw155','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:13:47',NULL),(62,'WK-DW171',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'wkdw171','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:24:49',NULL),(63,'WK-DW200',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'wkdw200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:48:58',NULL),(64,'WK-GLDW170',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'wkgldw170','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 21:21:34',NULL),(65,'WK-DW173',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'wkdw173','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:33:52',NULL),(67,'WK-SS1202',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'wkss1202','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:18:35',NULL),(69,'WCF-560-1400mm',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wcf5602','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 21:45:52',NULL),(70,'WCF-5604WR White',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wfc5604wrwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 21:49:02',NULL),(71,'WCF-5603WR white',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wfc5603wrwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:49:22',NULL),(72,'WCF-5603WR pink',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wcf5603wrpink','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 16:42:10',NULL),(73,'WCF-5601 WR Indigo',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wfc5601wrindigo','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 16:54:39',NULL),(74,'WCF-5601 WR White',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wfc5601wrwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 17:06:17',NULL),(75,'WCF-5601 EM/Indigo/pink',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'wfc5601em','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:58:04',NULL),(76,'W160A-RMC',9,'single',30,NULL,36,73,NULL,'inclusive',0,0,1,1,'w160armc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 17:09:58',NULL),(77,'WTF16ARMC Walton Table Fan',9,'single',30,NULL,36,81,NULL,'inclusive',0,0,1,1,'wtf16armc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 14:47:50',NULL),(78,'W170A-MS-17\"',9,'single',30,NULL,36,64,NULL,'inclusive',0,0,1,1,'w170ams17','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:06:43',NULL),(80,'W-50GW',9,'single',30,NULL,36,52,NULL,'inclusive',0,0,1,1,'w50gw','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:22:13',NULL),(81,'WWM-S80F',9,'single',30,NULL,36,66,NULL,'inclusive',0,0,1,1,'wwms80f','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:40:50',NULL),(84,'WMWO-M30AS3',9,'single',30,NULL,36,52,NULL,'inclusive',0,0,1,1,'wmwom30as3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:50:02',NULL),(85,'WG-30ESLR',9,'single',30,NULL,36,52,NULL,'inclusive',0,0,1,1,'wg30eslr','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 20:56:35',NULL),(86,'WMWO-G20XC',9,'single',30,NULL,36,52,NULL,'inclusive',0,0,1,1,'wmwog20xc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:46:49',NULL),(87,'Zoom-1200',9,'single',30,NULL,36,211,NULL,'inclusive',0,0,1,1,'zoom1200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-05 20:10:25',NULL),(88,'Smart Power Plus-1500',9,'single',30,NULL,36,211,NULL,'inclusive',0,0,1,1,'smartpower1500','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:25:42',NULL),(89,'Smart Power Plus-1500E',9,'single',30,NULL,36,211,NULL,'inclusive',0,0,1,1,'smartpower1500e','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:15:40',NULL),(90,'Excel Smart-2200',9,'single',30,NULL,36,211,NULL,'inclusive',0,0,1,1,'excelsmart2200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:31:02',NULL),(91,'WRH-PTC005',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'wrhptc005','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 21:03:47',NULL),(92,'WRH-PTC004',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'wrhptc004','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 16:55:55',NULL),(93,'WRH-PTC001',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'wrhptc001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:50:59',NULL),(94,'WRH-FH01',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'wrhfh01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:16:46',NULL),(95,'WRH-PTC009',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'wrhptc009','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 21:10:46',NULL),(96,'WRH-PTC007',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'wrhptc007','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:53:34',NULL),(97,'WEPC-YB05(5KG)',9,'single',30,NULL,36,75,NULL,'inclusive',0,0,1,1,'wepcyb05','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:50:34',NULL),(98,'WEPC-P605L',9,'single',30,NULL,36,75,NULL,'inclusive',0,0,1,1,'wepcp05l','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:15:16',NULL),(99,'WPC-M045-OVAL',9,'single',30,NULL,36,75,NULL,'inclusive',0,0,1,1,'wpcm045oval','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:09:36',NULL),(102,'WIR-SSI01',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'wirssi01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:49:10',NULL),(103,'WIR-S05',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'wirs05','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:34:14',NULL),(104,'WIR-HD01-Dry Iron',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'wirhd01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:19:02',NULL),(105,'WIR-S01',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'wirs01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:13:21',NULL),(106,'WIR-S06',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'wirs06','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 21:46:08',NULL),(124,'WVS-1000SDR80V',9,'single',30,NULL,36,44,NULL,'inclusive',0,0,1,1,'wvs1000sdr80v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 21:49:19',NULL),(125,'WVS-600SD',9,'single',30,NULL,36,43,NULL,'inclusive',0,0,1,1,'wvs600sd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:49:31',NULL),(126,'WGS-3GNS1(Mtc)',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'wgs3gns1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-20 16:43:01',NULL),(127,'WGS-GNSB1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'wfsgnsb1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:34:29',NULL),(128,'WGS-GNS2',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'wgsgns2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 14:58:21',NULL),(129,'WGS-DSB1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'wgsdsb1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:59:20',NULL),(130,'WGS-SGNS1-LPG',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgssgns1lpg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 17:11:28',NULL),(131,'WGS-SB1701S-LPG',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgssb1701slpg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 14:48:02',NULL),(132,'WGS-SC1701s-LPG',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgssc1701slpg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:07:33',NULL),(133,'WGS-AT100LPG',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgsat100lpg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-17 16:22:48',NULL),(134,'WGS-SSB1-LPG',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgsssb1lpg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:49:15',NULL),(135,'WGS-SSC1-LPG',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgsssc1lpg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-25 15:50:14',NULL),(136,'ME396AFH(39\")',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'me396afh39','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 21:10:32',NULL),(137,'MD326SR-Silver(32\")',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'md326srsilver32','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 15:32:25',NULL),(138,'MD285AH(28\")',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'md285ah28','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 16:41:47',NULL),(140,'MD1-DT24-MC100(24\")',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'md1dt24mc100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-14 16:26:18',NULL),(141,'MD1-DTRL100-SILVER(24\")',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'md1dt24rlsilver100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:04','2021-06-24 22:16:02',NULL),(151,'WBL 13PX35',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'w13PX35','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:47:29',NULL),(152,'MBL-15G35(1.5lt)',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'mbl15g351.5lt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:04:23',NULL),(153,'MBL-13PC40(1.3lt)',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'mbl13pc401.3lt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:56:56',NULL),(154,'MBL-13PX35(1.3lt)',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'mbl13px351.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:51:55',NULL),(155,'MIR-S01',9,'single',30,NULL,35,99,NULL,'inclusive',0,0,1,1,'mris01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:17:11',NULL),(156,'MIR-S02',9,'single',30,NULL,35,99,NULL,'inclusive',0,0,1,1,'mirs02','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 15:51:02',NULL),(157,'MIR-D02',9,'single',30,NULL,35,99,NULL,'inclusive',0,0,1,1,'mird02','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:53:46',NULL),(158,'MPC-MS35(3.5KG)',9,'single',30,NULL,35,105,NULL,'inclusive',0,0,1,1,'mpcmss353.5kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:50:46',NULL),(159,'MPC-MS55(5.5KG)',9,'single',30,NULL,35,105,NULL,'inclusive',0,0,1,1,'mpcmss555.5kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:35:01',NULL),(160,'MVS-600SD',9,'single',30,NULL,35,93,NULL,'inclusive',0,0,1,1,'mvs600sd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:19:33',NULL),(161,'MVS-1000SD',9,'single',30,NULL,35,94,NULL,'inclusive',0,0,1,1,'mvs1000sd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:14:07',NULL),(162,'MRL-L33',9,'single',30,NULL,35,111,NULL,'inclusive',0,0,1,1,'mrll33','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:22:46',NULL),(164,'MGS-GNS2(Glass)',9,'single',30,NULL,35,107,NULL,'inclusive',0,0,1,1,'mgsgns2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:41:28',NULL),(169,'MCF-5601 WR WHITE/OFF WHITE',9,'single',30,NULL,35,109,NULL,'inclusive',0,0,1,1,'mcf5601wrwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:52:24',NULL),(170,'MCF-5601 EM White',9,'single',30,NULL,35,109,NULL,'inclusive',0,0,1,1,'mcf5601emwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:46:25',NULL),(171,'MCF-5601 EM Indigo',9,'single',30,NULL,35,109,NULL,'inclusive',0,0,1,1,'mcf5601emindigo','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:49:44',NULL),(187,'WES3P4E-4Point Extension Socket White',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'4pointextension','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:49:41',NULL),(188,'WES2P4H-4Point Extension Socket White',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'4hsocketblack','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 17:02:00',NULL),(189,'W2PP6-6A 2Pin Plug',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'6a2pinplug','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:35:49',NULL),(190,'WDHE27-Betton Holder',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'bettenholder','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:40:18',NULL),(192,'Power Master-W6DZM95-12V',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'w6dzm9512v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:00:14',NULL),(193,'POWER MASTER-W6DZM75 12V',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'w6dzm7512v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:23:16',NULL),(196,'WB670-6V 7.0AH',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'wb6706v7.0','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 14:48:21',NULL),(197,'WB6450-6V 4.5AH',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'wb64506v4.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:08:40',NULL),(198,'WB6450C-6V 4.5ah',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'wb6450c6v4.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:22:52',NULL),(210,'SYMPHONY D-52j',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sd52i','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:05:06',NULL),(211,'SYMPHONY L 55',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'51180','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:26:57',NULL),(212,'SYMPHONY D19',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sd19','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:18:07',NULL),(213,'SYMPHONY T160',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'st160','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:33:42',NULL),(214,'SYMPHONY B12',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sb12','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:35:34',NULL),(215,'SYMPHONY L50',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sl50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:17:13',NULL),(216,'SYMPHONY T105',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'st105','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:16:17',NULL),(217,'SYMPHONY B20',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sb20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:32:32',NULL),(218,'SYMPHONY T110',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'st110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:04:50',NULL),(219,'SYMPHONY B50',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sb50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:57:29',NULL),(220,'SYMPHONY L25i',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sl25i','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:52:27',NULL),(221,'SYMPHONY L100',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sl100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:18:37',NULL),(222,'SYMPHONY L150',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sl150','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 15:52:01',NULL),(223,'SYMPHONY B17',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sb17','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:53:57',NULL),(224,'SYMPHONY B13i',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sb13i','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:51:28',NULL),(226,'SYMPHONY T85',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'st85','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:20:48',NULL),(227,'SYMPHONY BL60',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sbl60','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:44:02',NULL),(230,'8GB',9,'single',30,NULL,37,205,NULL,'inclusive',0,0,1,1,'8gb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:21:40',NULL),(233,'Active Power Charger',9,'single',30,NULL,37,203,NULL,'inclusive',0,0,1,1,'activepower\'\'','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:27:35',NULL),(234,'Active Charger',9,'single',30,NULL,37,203,NULL,'inclusive',0,0,1,1,'active;','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:26:31',NULL),(235,'Active Smart Charger',9,'single',30,NULL,37,203,NULL,'inclusive',0,0,1,1,'activesmart','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:35:43',NULL),(236,'Active Power Bettary',9,'single',30,NULL,37,204,NULL,'inclusive',0,0,1,1,'activepowerbettary','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:27:08',NULL),(237,'Active Bettary',9,'single',30,NULL,37,204,NULL,'inclusive',0,0,1,1,'activebettary','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:26:06',NULL),(239,'Touch 12V',9,'single',30,NULL,37,206,NULL,'inclusive',0,0,1,1,'touch12v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:43:57',NULL),(240,'Touch 9V',9,'single',30,NULL,37,206,NULL,'inclusive',0,0,1,1,'touch9v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:36:34',NULL),(241,'Touch 6V',9,'single',30,NULL,37,206,NULL,'inclusive',0,0,1,1,'touch6v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 14:59:13',NULL),(243,'GP Flexiload',9,'single',30,NULL,37,207,NULL,'inclusive',0,0,1,1,'gpflexiload*','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:00:57',NULL),(244,'BL Itop UP',9,'single',30,NULL,37,208,NULL,'inclusive',0,0,1,1,'blitopup///','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:59:26',NULL),(245,'Easy Load',9,'single',30,NULL,37,208,NULL,'inclusive',0,0,1,1,'esayload','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 14:48:38',NULL),(250,'Nikko Auto Single Chula NK 11',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk11','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:26:55',NULL),(252,'RFL Digital Palla 300 kg',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'300kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:25:06',NULL),(253,'Nikko Gas Reguletor',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'nikkogasregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:38:16',NULL),(254,'RFL Gas Reguletor',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'rflgasregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:28:12',NULL),(256,'Denmark Gas Reguletor',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'denmarkgasregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 20:58:20',NULL),(257,'JFI pressur Gas Reguletor',9,'single',30,NULL,38,128,NULL,'inclusive',0,0,1,1,'jfipressurgasreguletor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:34:32',NULL),(258,'King Gas  Pressur Regultor',9,'single',30,NULL,38,128,NULL,'inclusive',0,0,1,1,'kingaspressurregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:36:34',NULL),(259,'Cular Magnet Single',9,'single',30,NULL,38,131,NULL,'inclusive',0,0,1,1,'singlemagnet','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:18:28',NULL),(260,'Cular Magnet Double',9,'single',30,NULL,38,131,NULL,'inclusive',0,0,1,1,'magnetdouble','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:16:39',NULL),(261,'Hos Pipe',9,'single',30,NULL,38,129,NULL,'inclusive',0,0,1,1,'hospipe6666','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:47:38',NULL),(262,'Chular Clip',9,'single',30,NULL,38,130,NULL,'inclusive',0,0,1,1,'chularclip','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:53:24',NULL),(263,'Chular Nobo',9,'single',30,NULL,38,136,NULL,'inclusive',0,0,1,1,'nobo','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:59:54',NULL),(264,'Chular Burner',9,'single',30,NULL,38,133,NULL,'inclusive',0,0,1,1,'burner','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:51:10',NULL),(265,'Chular Net',9,'single',30,NULL,38,137,NULL,'inclusive',0,0,1,1,'net','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:58:41',NULL),(266,'Chular gas Samogri',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'samogri','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:53:58',NULL),(267,'Gas Lighter R1',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'gaslighter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:54:13',NULL),(271,'CRTV Akira 21\"',9,'single',30,NULL,39,141,NULL,'inclusive',0,0,1,1,'akira21','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-06 19:13:24',NULL),(272,'CRTV Konka 14\"',9,'single',30,NULL,39,141,NULL,'inclusive',0,0,1,1,'konka14','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-06 19:13:47',NULL),(273,'CRTV Akira 14\"',9,'single',30,NULL,39,141,NULL,'inclusive',0,0,1,1,'akira14','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-06 19:13:01',NULL),(274,'Sony 625',9,'single',30,NULL,39,142,NULL,'inclusive',0,0,1,1,'sony625','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:49:20',NULL),(275,'Sony-Hitachi 1250',9,'single',30,NULL,39,143,NULL,'inclusive',0,0,1,1,'sony1250','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 15:57:47',NULL),(277,'KIam 1.8 Rice Cooker DJB 202',9,'single',30,NULL,39,145,NULL,'inclusive',0,0,1,1,'kiam1.8','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:42:19',NULL),(279,'Kiam 2.8 Rice Cooker Joint body',9,'single',30,NULL,39,145,NULL,'inclusive',0,0,1,1,'kiam2.8joint','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:53:20',NULL),(280,'Jaipan Blender FANCY Bl  650W',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'jaipan650w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:46:42',NULL),(281,'Miyako Balender Bl 718',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'miyakobl718','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:15:20',NULL),(282,'Miyako 4677A Blender',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'miyako4677a','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:02:41',NULL),(284,'Miyako  Blender BL 2004 Ch',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'miyakobl2004','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:44:34',NULL),(286,'Miyako Blue Brid',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'miyakobluebrid','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:42:30',NULL),(289,'Miyako MK 5023',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'miyakomk5023','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 14:59:48',NULL),(291,'Miyako MK 2047 kettli',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'miyakomk2047','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:01:42',NULL),(293,'National Iron',9,'single',30,NULL,39,148,NULL,'inclusive',0,0,1,1,'nationaliron','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:23:40',NULL),(294,'Jackport Iron',9,'single',30,NULL,39,148,NULL,'inclusive',0,0,1,1,'Jackportiron','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 14:48:48',NULL),(295,'Panasonic Iron',9,'single',30,NULL,39,148,NULL,'inclusive',0,0,1,1,'panasoniciron','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:27:39',NULL),(298,'Super Star DC 5W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spdc5w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:26:09',NULL),(299,'Super StarDC 3W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spdc3w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:48:35',NULL),(300,'Super Star LED 40W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spled40w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:28:42',NULL),(301,'Super Star LED 20W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spled20w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 20:59:02',NULL),(307,'RFL Ex 30K',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'rflex30k','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:39:04',NULL),(308,'Tv Charger Jack',9,'single',30,NULL,39,157,NULL,'inclusive',0,0,1,1,'tvchargerjack','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:37:11',NULL),(309,'Tv jack',9,'single',30,NULL,39,157,NULL,'inclusive',0,0,1,1,'tvjack','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:19:47',NULL),(310,'Walton TV Remot Master',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'waltontvremotm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:17:09',NULL),(311,'LG TV Remot Master',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'lgtvremotm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:48:10',NULL),(312,'Sony TV Remot Master',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'sonytvremotm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:52:12',NULL),(313,'Dawoo TV Remot Master',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'dwootvremotm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:58:13',NULL),(314,'Walton Tv Remot Long',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'waltontvremotlong','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:52:56',NULL),(315,'Walton Tv Remot A',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'wla','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:36:11',NULL),(316,'Walton Tv Remot B',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'waltontvremotb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:41:43',NULL),(317,'25 in 1 Tv Remot Chaina',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'25in1remot','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:08:11',NULL),(318,'Walton Led Tv Remot',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'wledtv','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:05:00',NULL),(319,'Walton  Panir filter 24 Ltr',9,'single',30,NULL,36,56,NULL,'inclusive',0,0,1,1,'waltonpanirfilter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:16:44',NULL),(320,'Purite Panir Filter 23 ltr',9,'single',30,NULL,39,152,NULL,'inclusive',0,0,1,1,'puritepanir23','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:44:30',NULL),(321,'Golden Nova Panir Filter 36 ltr',9,'single',30,NULL,39,152,NULL,'inclusive',0,0,1,1,'goldennovapanir','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:49:30',NULL),(322,'Kiam Pressur Cooker  5.5',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'kiampressur5.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 15:59:12',NULL),(323,'Kiam Pressur Cooker  6.5',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'kiampressur6.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:43:13',NULL),(324,'Kiam Rote 26 cm',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiamrote26cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:53:59',NULL),(325,'Balaka 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'balaka56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:51:49',NULL),(326,'Nobab 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'nobab56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:43:32',NULL),(328,'Choa 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'choa56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:48:49',NULL),(329,'ABCG 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'abcg56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:24:48',NULL),(330,'Gazi 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'gazi56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:54:37',NULL),(331,'Jweel 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'jweel56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:00:07',NULL),(332,'GFC Sigma 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'fgcsigma56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:02:42',NULL),(333,'Super Prim 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'superprim56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:24:00',NULL),(334,'Kasmir 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'kasmir56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 15:56:06',NULL),(336,'Millat Delaix 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'millatd56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:08:51',NULL),(337,'Millat Green 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'millatg56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:26:41',NULL),(338,'CFC 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'cfc56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:48:29',NULL),(339,'City Power  56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'citypower56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:14:25',NULL),(340,'City  56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'city56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:02:57',NULL),(341,'Laboni  56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'laboni56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:35:37',NULL),(342,'Silica  56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'silica56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:37:50',NULL),(343,'Aziz  56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'aziz56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:50:30',NULL),(344,'Kasmir 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'kasmir48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:17:48',NULL),(345,'City 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'city48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:04:14',NULL),(346,'Beauty 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'beauty48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:57:44',NULL),(347,'TFC 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'tfc48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:58:43',NULL),(348,'CFC 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'cfc48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:48:06',NULL),(349,'Super Prim 36\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'superprim36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:19:42',NULL),(350,'Balaka 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'balaka36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:51:21',NULL),(351,'Beauty 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'beauty36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:56:32',NULL),(352,'ABC 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'abc36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:24:17',NULL),(353,'Grameen 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'grameen36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-08-05 23:44:22',NULL),(354,'Sakur 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'sakura36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:44:39',NULL),(355,'Chowa 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'chowa36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 21:49:39',NULL),(356,'Kasmir 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'kasmir36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:00:06',NULL),(357,'Silica 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'silica36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:43:25',NULL),(358,'City Fantasy 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'cityfantasy36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:04:26',NULL),(360,'Air Cool 18\" Steel',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'acool18steel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:37:33',NULL),(361,'Air Cool 16\"',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'acool16','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:37:12',NULL),(362,'Air Dulex 16\"',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'adulex16','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:40:06',NULL),(363,'Air Mate 16\"',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'airmate16','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:40:28',NULL),(364,'Air Mate 20\" 5 Bled',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'amate20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:40:50',NULL),(365,'Maxson DC Jali Fan',9,'single',30,NULL,39,164,NULL,'inclusive',0,0,1,1,'dcjalifan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:49:17',NULL),(366,'Funai Table Fan',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'funaitablefan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:03:32',NULL),(367,'Super Star 14\" DC Table Fan',9,'single',30,NULL,39,166,NULL,'inclusive',0,0,1,1,'superstardc14','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:24:27',NULL),(368,'Sunca 2388 Charger fan',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'suncachargerfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 14:52:51',NULL),(369,'Defender 12\"  Charger fan',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'defenderchargerfandcf12','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:30:25',NULL),(370,'GFC 24\" Stand FAN',9,'single',30,NULL,39,167,NULL,'inclusive',0,0,1,1,'gfc24stand','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:27:20',NULL),(371,'Dosha 30 cm Fri pen',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'dosha30cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:41:38',NULL),(372,'KIam Frypan Glass Lid 28 cm',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam28cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:50:23',NULL),(374,'Kiam Induction bottom 24 cm',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'induction24cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 20:59:27',NULL),(375,'Kiam Cassarol Induction Glass Lid 26 cm',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'26cmcassarol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:36:05',NULL),(376,'Sony Wall Movie Fan',9,'single',30,NULL,39,170,NULL,'inclusive',0,0,1,1,'sonywallmovie','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:38:42',NULL),(377,'Solar Tube 5W',9,'single',30,NULL,39,173,NULL,'inclusive',0,0,1,1,'solartube5w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:22:49',NULL),(378,'Super Star Solar Tube 5W',9,'single',30,NULL,39,173,NULL,'inclusive',0,0,1,1,'supersolartube5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:18:54',NULL),(379,'Super Star Solar Tube 3W',9,'single',30,NULL,39,173,NULL,'inclusive',0,0,1,1,'sptube3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:48:47',NULL),(380,'Small fan Capasitor',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'smallfancapasitor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:05:54',NULL),(381,'Icor Fan Capasitor',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'icorcapasitor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 17:02:34',NULL),(383,'Table Light 6803',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'6803','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 17:03:56',NULL),(384,'Table Light 931',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'931','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:36:57',NULL),(386,'Touch Light 9121',9,'single',30,NULL,39,175,NULL,'inclusive',0,0,1,1,'9121','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:22:01',NULL),(387,'Touch Light 1716',9,'single',30,NULL,39,175,NULL,'inclusive',0,0,1,1,'1716','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:54:26',NULL),(388,'Malti Plag Nova 550',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'550','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:54:38',NULL),(389,'Malti Plag  570',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'570','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:19:52',NULL),(390,'Malti Plag 0032',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'boss0032','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:45:05',NULL),(391,'Malti Plag Super Star 0032 3Ghat',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'superstar0032','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:49:41',NULL),(392,'Malti Plag Maxxon 1160',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maxxon1160','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:00:18',NULL),(393,'Malti Plag Maxxon 704',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maxxon704','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:43:51',NULL),(394,'Malti Plag Maxxon GY 248',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maxxon248','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:43:21',NULL),(395,'Malti Plag Victor',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'victor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:47:04',NULL),(396,'Malti Plag Maxxon 2010',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maxxon2010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:44:50',NULL),(397,'Mega Weigh scal  M05',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'m05','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:25:38',NULL),(399,'Royal 1000W Panir Hitar',9,'single',30,NULL,39,180,NULL,'inclusive',0,0,1,1,'royal1000w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:54:58',NULL),(400,'Royal 1500W',9,'single',30,NULL,39,180,NULL,'inclusive',0,0,1,1,'royal1500W','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:00:46',NULL),(401,'Royal 500w Panir Hitar',9,'single',30,NULL,39,180,NULL,'inclusive',0,0,1,1,'royal500w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:04:36',NULL),(402,'Kiam Half Stainless Steel 2200 Ml',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'half2200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:24:50',NULL),(404,'Dim Light Long',9,'single',30,NULL,39,182,NULL,'inclusive',0,0,1,1,'dimlightlong','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 15:57:00',NULL),(405,'Dim Light Gol',9,'single',30,NULL,39,182,NULL,'inclusive',0,0,1,1,'dimlightgol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:28:27',NULL),(406,'Super Star Buttom Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'supbuttom','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:10:01',NULL),(407,'Mep Celling Rose',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepcelling','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:42:23',NULL),(408,'MEP Motor Switch',9,'single',30,NULL,39,183,NULL,'inclusive',0,0,1,1,'mepmotor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:51:23',NULL),(409,'MEP Main Switch',9,'single',30,NULL,39,183,NULL,'inclusive',0,0,1,1,'mepmain','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:19:10',NULL),(410,'Mep Chanal 1\"',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'chanal1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:36:59',NULL),(411,'MEP Chanal 3/4\"',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'chanal3/4','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:39:34',NULL),(412,'Arthin Rod',9,'single',30,NULL,39,188,NULL,'inclusive',0,0,1,1,'arthinrod','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:48:34',NULL),(413,'Iskup',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'iscup','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:01:10',NULL),(414,'Kebol Clip all mm',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'clipmmmm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:49:12',NULL),(415,'Super Star Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'spswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:53:15',NULL),(416,'Mep Switch',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 17:02:52',NULL),(417,'Cona Switch',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'conaswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:32:02',NULL),(418,'Mep Socket',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:21:31',NULL),(419,'Cona Socket',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'conasocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:31:45',NULL),(420,'Super Star Fiuz',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'supfiuz','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:54:36',NULL),(421,'Mep Fiuz',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepfiuz','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:55:17',NULL),(423,'Cona Fiuz',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'conafiuz','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:31:34',NULL),(424,'Indi Cutter Cona',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'indicona','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:45:20',NULL),(425,'Super Star Indicutter',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'supindicutter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:49:52',NULL),(426,'Mep Indicutter',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepindicutter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:01:18',NULL),(427,'Mep Buttom Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepbuttom','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:44:09',NULL),(428,'Mep Testar',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'testar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:43:51',NULL),(429,'Mep Jhulonto Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepjhulonto','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:00:19',NULL),(430,'Mep Sarkit Box Single',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepboxs','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:39:58',NULL),(431,'Mep Sarkit Box Double',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepboxd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:46:42',NULL),(432,'Tcm Indicutter',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'tcmindicutter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:53:46',NULL),(433,'6/8 Plen Board',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'6/8plenboard','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:17:19',NULL),(434,'Mep 2 Hold boad',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'2hold','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:01:30',NULL),(435,'Mep 6 Hold Boad',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'6hold','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:14:00',NULL),(436,'Mep 4 Hold Boad',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'4hold','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:25:02',NULL),(437,'Mep 1 Hold Boad',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'1hold','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 15:57:41',NULL),(438,'Walton 1Gang Switch',9,'single',30,NULL,36,77,NULL,'inclusive',0,0,1,1,'walton1g','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:09:42',NULL),(439,'Walton 2Gang Switch',9,'single',30,NULL,36,77,NULL,'inclusive',0,0,1,1,'walton2g','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:12:46',NULL),(440,'Walton 3Gang Switch',9,'single',30,NULL,36,77,NULL,'inclusive',0,0,1,1,'walton3g','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:43:08',NULL),(441,'Walton 4Gang Switch',9,'single',30,NULL,36,77,NULL,'inclusive',0,0,1,1,'walton4g','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:50:31',NULL),(442,'Walton Fan Regultor',9,'single',30,NULL,36,65,NULL,'inclusive',0,0,1,1,'wfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:19:53',NULL),(443,'Walton Led Tube',9,'single',30,NULL,36,72,NULL,'inclusive',0,0,1,1,'waltontube','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:39:16',NULL),(445,'Walton Blank Plet',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'waltonblank','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 20:54:43',NULL),(446,'Super Star Souro Panel 20W',9,'single',30,NULL,39,184,NULL,'inclusive',0,0,1,1,'panal20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 19:51:07',NULL),(447,'Super Star Souro Panel 40W',9,'single',30,NULL,39,184,NULL,'inclusive',0,0,1,1,'panal40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:01:48',NULL),(448,'Super Star Souro Panel100 W',9,'single',30,NULL,39,184,NULL,'inclusive',0,0,1,1,'panal100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:06:17',NULL),(449,'Super Star DC Charge Controlar',9,'single',30,NULL,39,186,NULL,'inclusive',0,0,1,1,'supdccontrolar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 14:58:00',NULL),(451,'Gas Clip',9,'single',30,NULL,38,130,NULL,'inclusive',0,0,1,1,'gasclip','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 17:04:58',NULL),(452,'Gas Reguletor',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'gasreguletor333333','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:37:31',NULL),(453,'Auto Magnet GLASS',9,'single',30,NULL,38,131,NULL,'inclusive',0,0,1,1,'amagnet','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:49:00',NULL),(454,'Miyako Auto Double Chula Classic',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'miyakoclassicdouble','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 22:20:51',NULL),(456,'Nikko Auto Double Chula 315',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'nikko315','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:05:42',NULL),(457,'Nikko Auto Single Chula NK 16',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk16','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:21:01',NULL),(458,'RFL 102 Auto Single Chula',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'rfl102s','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 14:57:02',NULL),(459,'Miyako Auto Single Chula 132',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'miyako132','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 15:45:57',NULL),(460,'Miyako Comet Auto Single Chula',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'miyakocomet','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:02:15',NULL),(461,'Euro Gas Auto Single Chula',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'eurogas','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:40:41',NULL),(462,'Nikko Auto Single Chula NK 12',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk12','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 19:55:40',NULL),(465,'Normal Hotel Chula',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'NORMALhotel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 20:54:08',NULL),(466,'Tundul Hotel Chula BIG 45',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'tundul45','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:47:23',NULL),(467,'WCG 3JO D',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3jod','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:29:54',NULL),(468,'Walton Mobile L7',9,'single',30,NULL,36,78,NULL,'inclusive',0,0,1,1,'l7','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:48:18',NULL),(469,'Walton Mobile L22',9,'single',30,NULL,36,78,NULL,'inclusive',0,0,1,1,'l22','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:37:53',NULL),(470,'Telephone Socket',9,'single',30,NULL,36,77,NULL,'inclusive',0,0,1,1,'tsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:02:04',NULL),(471,'Walton Calling Bell Switch',9,'single',30,NULL,36,77,NULL,'inclusive',0,0,1,1,'wcallingswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 21:09:45',NULL),(472,'Walton Buttom Holder',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'wbuttom','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 17:07:01',NULL),(473,'High Cool Refrigetor RD 156',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'rd156','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:25:28',NULL),(474,'High Cool Refrigetor RD 170',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'rd170','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:29:00',NULL),(475,'Rangs Refrigetor RK 148',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'rk148','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:12:56',NULL),(476,'Super Ariston Refrigetor TDF 140G',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'140g','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-25 14:55:41',NULL),(477,'Super Ariston Refrigetor TDF 16CK',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'16ck','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 20:55:45',NULL),(478,'Super Ariston Refrigetor TDF 110Z',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'110z','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:46:00',NULL),(479,'Super Ariston Refrigetor TDF 21Ck',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'21ck','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 16:41:13',NULL),(480,'Super Ariston Refrigetor TDF 92',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'tdf92','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:07:56',NULL),(481,'Super Ariston Refrigetor TDF 24CK',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'24ck','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 19:40:41',NULL),(482,'Lavida Refrigetor 20LS',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'20ls','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:23:03',NULL),(483,'Lavida Refrigetor 21LB',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'21lb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 21:03:36',NULL),(484,'Super Ariston Refrigetor DEEP 15T',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'15t','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:55:10',NULL),(485,'Super Ariston Refrigetor DEEP 155GL',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'155gl','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:56:52',NULL),(486,'Super Ariston Refrigetor DEEP 25DD',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'25dd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:34:03',NULL),(487,'Super Ariston Refrigetor DEEP 34D',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'34d','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:18:50',NULL),(488,'Super Ariston Refrigetor DEEP 02',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'deep02','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 15:58:53',NULL),(489,'Super Ariston Refrigetor DEEP 25GB',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'25gb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:48:47',NULL),(490,'High Cool Refrigetor RD 142',9,'single',30,NULL,39,140,NULL,'inclusive',0,0,1,1,'rd142','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:13:56',NULL),(491,'Lavaida LED TV 2332',9,'single',30,NULL,39,141,NULL,'inclusive',0,0,1,1,'2332','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:25:19',NULL),(495,'Kiam Pressur Cooker  8.5',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'kiam8.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-08-06 14:41:26',NULL),(496,'Kiam Led 22 cm Karai Fri pen',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'led22cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 15:56:43',NULL),(497,'Kiam Full Stainless Steel 1700 Ml',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'full1700','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:16:24',NULL),(498,'Frige Troly',9,'single',30,NULL,39,158,NULL,'inclusive',0,0,1,1,'troly','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 15:50:53',NULL),(499,'MFC 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'mfc56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 20:55:50',NULL),(500,'City 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'city36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 22:03:07',NULL),(501,'Air Cool 20\" 3 Bled',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'aircool3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-05 20:37:58',NULL),(502,'DC Stand Fan Noha 3918',9,'single',30,NULL,39,168,NULL,'inclusive',0,0,1,1,'noha3926','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 16:37:41',NULL),(503,'National Wall Movie Fan',9,'single',30,NULL,39,170,NULL,'inclusive',0,0,1,1,'nationalwall','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:33:43',NULL),(504,'MSM Fan Reguletor',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'msm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-20 17:06:27',NULL),(505,'Sunca 6V Bettary',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'6v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:58:22',NULL),(506,'Malti Plag Boss 032',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'boss032','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 17:02:09',NULL),(507,'Super Star Charge Controlar',9,'single',30,NULL,39,186,NULL,'inclusive',0,0,1,1,'supercharge','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-14 16:26:05',NULL),(514,'TCM jhulonto Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'tcmholder','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-24 15:06:52',NULL),(515,'Mep 2Pin plag',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mep2pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:05','2021-06-17 16:21:49',NULL),(516,'6/8 Hold Boat',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'6/8hold','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:16:49',NULL),(517,'Mep 5 Hold Boat',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'5hold','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:47:28',NULL),(518,'MK Boat',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mkboat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 20:56:47',NULL),(519,'DC 1.2 40/76',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'dc1.2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:47:00',NULL),(520,'Tuin 23/76',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'tuin23/76','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:31:01',NULL),(521,'DC 70/76',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'dc70/76','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:15:36',NULL),(522,'Mitar Tar 3.20',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'mitar3.20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:41:43',NULL),(523,'32 GB',9,'single',30,NULL,37,205,NULL,'inclusive',0,0,1,1,'32gb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:12:10',NULL),(524,'JFI Gas Reguletor',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'jfigas','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:03:59',NULL),(525,'Walton Mobile GM2',9,'single',30,NULL,36,78,NULL,'inclusive',0,0,1,1,'gm2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:56:09',NULL),(526,'WALTON DT-24RL100-SILVER',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'24rl100silver','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:34:34',NULL),(528,'Walton Touch Light T80',9,'single',30,NULL,36,68,NULL,'inclusive',0,0,1,1,'t80','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:19:19',NULL),(529,'WIR-D03',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'d03','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:13:34',NULL),(530,'Walton Fry Pan F2405G 24cm',9,'single',30,NULL,36,57,NULL,'inclusive',0,0,1,1,'2405g24cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:10:57',NULL),(531,'WIR-D05',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'d05','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 14:40:52',NULL),(533,'Marcel MFA B4D GD',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfab4dgd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:18:55',NULL),(534,'MFE-B8B-GD ELL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfbb8bgdEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:09:48',NULL),(535,'MFE-C2X-GD',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfec2xgd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:40:45',NULL),(536,'MFE-C5H-GD',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfec5hgd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:22:08',NULL),(538,'MCF-5601 EM Off White',9,'single',30,NULL,35,109,NULL,'inclusive',0,0,1,1,'mcf5601emoffwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:40:59',NULL),(540,'MFC C6E GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'mfcc6egdEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:51:19',NULL),(541,'WGS-SSH2 (LPG)',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'wgsssh2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 20:56:05',NULL),(543,'200 Watt Clear',9,'single',30,NULL,39,182,NULL,'inclusive',0,0,1,1,'200watt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:07:24',NULL),(544,'100 Watt Clear',9,'single',30,NULL,39,182,NULL,'inclusive',0,0,1,1,'100watt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 19:59:23',NULL),(545,'60 Watt Clear',9,'single',30,NULL,39,182,NULL,'inclusive',0,0,1,1,'60watt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:18:27',NULL),(546,'40 Watt Clear',9,'single',30,NULL,39,182,NULL,'inclusive',0,0,1,1,'40watt','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:14:16',NULL),(547,'Nikko Auto Single Chula NK 14',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk14','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 14:58:34',NULL),(548,'back up 5w light',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'acdcbackup5w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:50:50',NULL),(549,'Super Star LED 18W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spled18w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:26:46',NULL),(550,'Super Star LED 15W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spled15w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:11:40',NULL),(551,'Super Star LED 12W',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'spled12w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:07:58',NULL),(552,'Chular Siramik',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'ciramic','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 22:01:56',NULL),(553,'Chular Tary PLET',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'tary','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 22:02:42',NULL),(554,'Chular Nojel',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'nojel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 22:00:26',NULL),(555,'Chular Albo',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'albo','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:50:34',NULL),(556,'Ball balb',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'ballbalb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:52:27',NULL),(558,'Miyako Auto Double Chula Galss',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'miyakoglasdouble','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:54:56',NULL),(559,'CT 7212 VC CALCULETOR',9,'single',30,NULL,39,178,NULL,'inclusive',0,0,1,1,'ct7212','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:16:35',NULL),(560,'Mega MG 9025 Calculetor',9,'single',30,NULL,39,178,NULL,'inclusive',0,0,1,1,'mg9025','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:42:18',NULL),(561,'SYMPHONY BL90',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'bl90','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:31:48',NULL),(562,'SYMPHONY BL 120',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'bl120','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:04:33',NULL),(563,'SYMPHONY BL100',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'bl100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:35:16',NULL),(564,'SYMPHONY D105',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'d105','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:19:45',NULL),(570,'Nokia 105 ds',9,'single',30,NULL,37,213,NULL,'inclusive',0,0,1,1,'n105ds','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:18:08',NULL),(571,'Nokia 6',9,'single',30,NULL,37,213,NULL,'inclusive',0,0,1,1,'n6','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:08:02',NULL),(572,'Mep 3pin Plag',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mep3pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:33:00',NULL),(573,'Mep Bed Switch',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepbed','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:04:39',NULL),(574,'Mep Travel Adapter',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'meptravel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:15:37',NULL),(575,'Mep 3/3 Boad',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mep33boad','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:10:10',NULL),(576,'Mep Fan Reguleto',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'mepfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:41:19',NULL),(577,'Mep Piano Indi Cutter',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'indicutter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:56:58',NULL),(578,'Air Mate 20\" jali',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'airmate20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:41:31',NULL),(579,'Souro Fan 8\"',9,'single',30,NULL,39,166,NULL,'inclusive',0,0,1,1,'souro8','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:40:45',NULL),(580,'Kiam 2.8 Rice Cooker Steel SJBS 704',9,'single',30,NULL,39,145,NULL,'inclusive',0,0,1,1,'sjbs704','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 20:57:03',NULL),(582,'Super Star Malti Plag',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'spmalti','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:50:05',NULL),(583,'Super Star Holder Hex+pech',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'superstarholder','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:50:28',NULL),(585,'Super Star 2 Gang Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp2gang','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:43:13',NULL),(586,'Super Star 3 Gang Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp3gang','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:34:40',NULL),(587,'Super Star 4 Gang Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp4gang','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 14:59:03',NULL),(588,'Super Star 2 Pin Socket',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'sp2pinsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:00:30',NULL),(589,'Super Star 3 pin Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'sp3pinsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:27:11',NULL),(590,'Super Star Dimar Fan Reguletor MK',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'spdimar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:21:19',NULL),(591,'Super Star Solar Tube 7W',9,'single',30,NULL,39,173,NULL,'inclusive',0,0,1,1,'sptube7w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:26:06',NULL),(592,'Super Star Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'spholderno','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:23:58',NULL),(595,'Fan Reguletor',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'fanreguletorips','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:05:16',NULL),(596,'Mini charger Fan',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'minicharger','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:31:22',NULL),(597,'Remot Calling Bell',9,'single',30,NULL,39,189,NULL,'inclusive',0,0,1,1,'remotcalling','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:34:02',NULL),(598,'Normal Panir Hitar',9,'single',30,NULL,39,152,NULL,'inclusive',0,0,1,1,'panirhitarn','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:35:50',NULL),(599,'Philips Iron',9,'single',30,NULL,39,148,NULL,'inclusive',0,0,1,1,'philipsiron','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:17:40',NULL),(600,'All Fan Capasitor',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'capasitor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:45:49',NULL),(602,'Miyako Blender BL 461',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl461','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:32:51',NULL),(603,'Miyako Blender bL 302',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl302','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:51:44',NULL),(604,'Table Light 7626',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7626','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:35:31',NULL),(605,'Miyako Blender Bl 303',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl303','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:20:07',NULL),(606,'Miyako blender Bl 102',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl102','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:18:51',NULL),(607,'Cen Over 16A',9,'single',30,NULL,39,183,NULL,'inclusive',0,0,1,1,'cen16a','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:47:22',NULL),(608,'All Motor Capasitor',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'motorcapasitor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:46:18',NULL),(610,'MIyako Blender Bl 750 PBB',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl750pbbb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:51:39',NULL),(611,'Filter Kol',9,'single',30,NULL,39,195,NULL,'inclusive',0,0,1,1,'filtarkol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:15:59',NULL),(612,'Miyako Blender bl 750 BLUE',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl750blue','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:49:41',NULL),(613,'Digital Palla 40K Mega',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'40kmega','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:42:18',NULL),(614,'Digital Palla 30K Mega',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'30kmega','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:57:14',NULL),(615,'Room Hitar PTC 14',9,'single',30,NULL,39,150,NULL,'inclusive',0,0,1,1,'ptc14','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:41:44',NULL),(616,'Volvo 100 amh',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'volvo100mh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:52:55',NULL),(617,'Riko 1553 Single Chula',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'rikochula','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 20:57:23',NULL),(619,'Defender 14\" Charger Fan',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'dcf14','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:07:40',NULL),(620,'Defender 16\" Charger Fan',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'dcf16','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:51:13',NULL),(621,'BRB 4.0',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'4','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:06:06',NULL),(622,'BRB 3.0',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:05:17',NULL),(623,'Jony Table Fan 9\"',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'jony','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 14:59:22',NULL),(624,'Moshar batt',9,'single',30,NULL,39,181,NULL,'inclusive',0,0,1,1,'mosarbat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:01:12',NULL),(625,'Click 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'click56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 22:16:18',NULL),(626,'Click 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'click48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 22:16:05',NULL),(627,'IQ 5 I PHONE',9,'single',30,NULL,37,203,NULL,'inclusive',0,0,1,1,'iq5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:27:13',NULL),(628,'Hexgon B22 Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'spb22','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:25:22',NULL),(629,'Hex Rose',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'sprose','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:54:07',NULL),(630,'Sp63 amp Brekar',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'sp63amopp','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:38:31',NULL),(631,'Royal Flack',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'royalflack','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 20:58:34',NULL),(632,'Normal 30 ltr gyser',9,'single',30,NULL,39,191,NULL,'inclusive',0,0,1,1,'30ltr','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:34:43',NULL),(633,'Nikko Auto Single Chula 22',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk22','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:36:57',NULL),(634,'Purite JamKill',9,'single',30,NULL,39,194,NULL,'inclusive',0,0,1,1,'jamkill','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:19:01',NULL),(635,'Super Star led 9w',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'led9w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:42:56',NULL),(636,'Super star led 7w',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'led7w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:35:37',NULL),(637,'Super Star led 5w',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'led5w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:51:59',NULL),(638,'Super Star led 3w',9,'single',30,NULL,39,149,NULL,'inclusive',0,0,1,1,'led3w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:35:58',NULL),(639,'WDT JX32-SY200',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'jx32sy200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:52:46',NULL),(642,'Vokka burner',9,'single',30,NULL,38,133,NULL,'inclusive',0,0,1,1,'vokka','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:19:08',NULL),(643,'Nokia 106',9,'single',30,NULL,37,213,NULL,'inclusive',0,0,1,1,'n106','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 14:43:57',NULL),(644,'RFL GAS REGULETOR',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'RFLGASREGULETOR','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:26:00',NULL),(645,'Super Man GAS REGULETOR',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'supermangasregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:52:07',NULL),(646,'Miyako 182 GAS REGULETOR',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'miyako182','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:16:30',NULL),(647,'CHULAR PATHOR',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'PATHOR','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 22:00:57',NULL),(648,'Mep 6 Pin Socket P562',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'MEP6PINP562','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:44:12',NULL),(649,'Kiam Pressur Cooker Prim 3.5',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'prim3.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:58:58',NULL),(650,'Kiam Pressur Cooker  5.5 Queen',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'5.5queen','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:42:37',NULL),(651,'Kiam 26 cm Korai',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'26cmkorai','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:43:09',NULL),(653,'Walton Led Tv Remot Original',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'orginal','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:47:37',NULL),(654,'Sacura Nabin',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'nabin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:08:08',NULL),(655,'Maxxon 2922 DC Table Fan',9,'single',30,NULL,39,166,NULL,'inclusive',0,0,1,1,'2922','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:54:21',NULL),(656,'Maxxon 2926 DC Table Fan',9,'single',30,NULL,39,166,NULL,'inclusive',0,0,1,1,'2926','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:45:13',NULL),(659,'Maxxon 2916 DC Table Fan',9,'single',30,NULL,39,166,NULL,'inclusive',0,0,1,1,'2916','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:36:45',NULL),(663,'Jay Kali Table Light',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'jaykalitable','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 14:59:59',NULL),(664,'YJ Table Light 6870',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'6870','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-06 19:32:30',NULL),(665,'Table Light 1043',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'1043','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:03:53',NULL),(666,'Maxxon Malti Plag 412',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'MaltiPlag412','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:21:30',NULL),(667,'Maxxon Malti Plag 512',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maxxon512','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:27:50',NULL),(668,'Maxxon Malti Plag 315',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maxxon315','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:26:24',NULL),(669,'Nova Malti Plag 512',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'nova512','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:54:17',NULL),(670,'Malti Plag 2070',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'2070','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:41:25',NULL),(671,'Malti Plag 209',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'209malti','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:18:34',NULL),(673,'Mitar Boat White',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mitarboatwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:35:14',NULL),(674,'Super Star Round Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'spround','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:47:34',NULL),(675,'Mep Round Socket',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepround','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:20:01',NULL),(676,'Sp 40am brekar',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'40ambrekar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:48:42',NULL),(677,'Mep Single Sarkit Brekar',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mepsinglebrekar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:17:22',NULL),(681,'Arabia 23/76',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'arabia','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:48:03',NULL),(685,'Vip Calling Bell(eo-pech+7621)',9,'single',30,NULL,39,189,NULL,'inclusive',0,0,1,1,'callingbell','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:21:28',NULL),(686,'Sp 1 Gang 2pin Socket',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'1gang2pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:50:37',NULL),(687,'Miyako Auto Double Chula 201',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'miyako201','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:08:31',NULL),(688,'SYMPHONY T130',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'t130','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:41:57',NULL),(689,'Kiam Auto Single Chula  1020C ss',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'1020css','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:52:39',NULL),(690,'Kiam Auto Double Chula TBR 2040B ss',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'2040bss','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:16:55',NULL),(691,'Kiam Auto Double Chula TSR 2010A ss',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'2010ass','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:50:23',NULL),(692,'Table Light 1041',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'1041','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:43:17',NULL),(693,'Air Cool 20\" Black 3Bled',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'20black','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:39:04',NULL),(694,'Air Cool 20\" blue 3Bled',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'20blue','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:39:36',NULL),(695,'GFC 24\" Pak Stand Fan',9,'single',30,NULL,39,167,NULL,'inclusive',0,0,1,1,'gfcpak','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:43:43',NULL),(696,'SYMPHONY D38i',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'d38i','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:58:03',NULL),(697,'Walton 3pin Socket',9,'single',30,NULL,36,46,NULL,'inclusive',0,0,1,1,'w3pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:08:46',NULL),(698,'Walton Fry Pan WSL 2401',9,'single',30,NULL,36,57,NULL,'inclusive',0,0,1,1,'2401','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:55:01',NULL),(699,'Kiam Gumbo Grinder Bl 200 600W',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:45:56',NULL),(700,'Mega 100 KG Digital Palla',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'100kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:37:14',NULL),(701,'MBL-13CX25(1.3lt)',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'mbl13cx25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 15:55:17',NULL),(702,'Gyser Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'gysers','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:03:03',NULL),(703,'Chular Niple',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'nipple','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:59:13',NULL),(704,'Ricco Aouto single chula 1553',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'1553','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:21:53',NULL),(705,'Miyako Auto Double Chula 202D',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'202D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:09:02',NULL),(706,'Auto Magnet Tar',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'magnettar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:49:24',NULL),(707,'Hi Trixson Malti Plag (M)',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'hitrikson2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:54:28',NULL),(708,'Xl Top Malti Plag',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'xltopmalti','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-06 19:32:51',NULL),(709,'Euro Gas Auto Single Chula Baily',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'baily','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:18:58',NULL),(711,'A+ Fan Reguletor',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'a+','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:23:57',NULL),(712,'Table Light 7677',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7677','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:37:25',NULL),(713,'Mep 36\" Ceiling Fan',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'mep36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:21:08',NULL),(714,'Auto Single Chula NIkko 13',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk13','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:49:48',NULL),(715,'Super Star Auto Double Chula 355',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'sp355','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:18:24',NULL),(716,'Nikko Auto Double Chula 328',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,0,0,'nk328','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:52:49',NULL),(717,'Walton Led Tv w32 Q19',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'q19','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:58:58',NULL),(718,'Mep 48\" Ceiling Fan',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'mep48','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:53:20',NULL),(719,'Nat',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'bat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:20:53',NULL),(720,'MFB A8E GDEL XX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A8EGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 14:44:33',NULL),(721,'MFE C2X GDEL XX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C2XGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:42:40',NULL),(722,'MFE C5H GDEL XX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C5HGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:54:17',NULL),(723,'MIR D05',9,'single',30,NULL,35,99,NULL,'inclusive',0,0,1,1,'MIRd05','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:19:41',NULL),(724,'ME4 AF39 BX120 39\" SMART',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'BX120','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:56:12',NULL),(725,'MD4-TS43-DL220(43\")-SMART',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'DL220','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:44:52',NULL),(726,'MFE-C0N-GDEL XX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C0N','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:30:35',NULL),(727,'MFE C3C GDXX LTR',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C3C','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:43:41',NULL),(728,'MFA 2A3 ELXXXX 213LTR',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'2A3ELXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:44:19',NULL),(729,'MFB B0A GDELXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B0AGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:58:30',NULL),(730,'MARCEL WALL FAN 400 mm M160A-RMC',9,'single',30,NULL,35,115,NULL,'inclusive',0,0,1,1,'WALLFANM160ARMC','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:09:37',NULL),(731,'Vigo Moshar Batt',9,'single',30,NULL,39,181,NULL,'inclusive',0,0,1,1,'vigobat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:56:44',NULL),(732,'Malti Plag 034 B',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'034b','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:46:15',NULL),(733,'Malti Plag 034 c',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'03c','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:37:26',NULL),(734,'Malti Plag 032B',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'032b','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:49:30',NULL),(735,'Malti Plag 032C',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'032c','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:03:45',NULL),(736,'Malti Plag 412b',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'412b','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:30:44',NULL),(737,'Malti Plag 0011B',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'0011b','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:22:11',NULL),(738,'7/7 Abonat Boat',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'7-Jul','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:18:52',NULL),(740,'Table Light DP 7044b',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7044b','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:29:15',NULL),(742,'Ma 6pin Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'ma6p','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:41:56',NULL),(743,'Volvo 55Amh',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'volvo55','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 20:59:42',NULL),(744,'MWM-Q80 (SILVER)',9,'single',30,NULL,35,112,NULL,'inclusive',0,0,1,1,'MWMQ80','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:36:28',NULL),(745,'Marcel Oven MMWO-M30AHY',9,'single',30,NULL,35,101,NULL,'inclusive',0,0,1,1,'MARCELOVEN','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:38:13',NULL),(746,'WIR-D07',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'d07','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:23:10',NULL),(747,'Walton Fry Pan WSL 2601',9,'single',30,NULL,36,57,NULL,'inclusive',0,0,1,1,'wsl2601','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:48:46',NULL),(749,'Bio gas single chula',9,'single',30,NULL,38,126,NULL,'inclusive',0,0,1,1,'bio','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:59:01',NULL),(750,'Auto single chula Rico 1563',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'1563','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:50:09',NULL),(751,'Sp 1 Gang Switch silver',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'1gangswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:02:42',NULL),(752,'Sp 2 Gang Switch silver',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'2gangsw','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:03:43',NULL),(753,'Sp 3 Gang Switch silver',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'3gangsw','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:21:11',NULL),(754,'Sp 4 Gang Switch silver',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'4gangsw','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:52:57',NULL),(755,'Sp 10Pin Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'10pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:43:07',NULL),(756,'Super Star Round Holder',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'roundholder','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:54:53',NULL),(757,'Super Star Dimar Silver',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'spdimarsilver','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:49:00',NULL),(758,'Hamko 130 amp',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'hamko130','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:47:39',NULL),(759,'MFC C4H GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'24HGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:43:38',NULL),(761,'Walton Sarkit Brekar',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'waltonsarkit','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:00:49',NULL),(762,'BB Table Fan ac',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'bbtablefan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:56:08',NULL),(763,'Miyako Blender 248',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl248','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:43:30',NULL),(764,'MFE B9E ELXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B9EELX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:58:48',NULL),(765,'MRL L105',9,'single',30,NULL,35,111,NULL,'inclusive',0,0,1,1,'MRLL105','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:09:49',NULL),(766,'MFA B4D GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B4DGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:26:27',NULL),(767,'MFB B5D GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B5DGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:46:49',NULL),(768,'MD1 DT24 MC110',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'MDT24MC110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 15:56:25',NULL),(769,'MD326JX 150',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'326JX150','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:01:02',NULL),(770,'MGS SGH1',9,'single',30,NULL,35,106,NULL,'inclusive',0,0,1,1,'MGSSGH1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:13:26',NULL),(771,'gfc stel bled',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'bled','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:06:32',NULL),(772,'Mbl-13EC25',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'13EC25M','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:22:32',NULL),(774,'SYMPHONY B12+',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'b12+','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:09:33',NULL),(775,'WBL-VK01-MIXER GRINDER',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'wvk01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:12:20',NULL),(776,'WGS GSHC2',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'GSHC2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:55:00',NULL),(777,'WGS SGC1',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'SGC1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:42:42',NULL),(778,'W FRY PAN CSL 2001',9,'single',30,NULL,36,57,NULL,'inclusive',0,0,1,1,'CSL2001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:15:12',NULL),(779,'W MOSAR BATT K02',9,'single',30,NULL,36,79,NULL,'inclusive',0,0,1,1,'K02','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:37:22',NULL),(780,'WEIGHT SCAL D8968',9,'single',30,NULL,36,55,NULL,'inclusive',0,0,1,1,'DS968','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:39:03',NULL),(782,'CFC 36\"',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'CFC36','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:47:45',NULL),(783,'Nikko Auto Single Chula NK 34',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'NK34','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:49:37',NULL),(784,'Super star 5pin Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'5pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:01:22',NULL),(785,'6 amp sarkit brekar',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'6amp','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:16:23',NULL),(786,'Nikko Auto Single Chula 32',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk32','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:03:08',NULL),(787,'Nikko Auto Single Chula NK 24',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk24','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:04:32',NULL),(789,'Arabia 14/76',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'arabia14/76','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 20:47:33',NULL),(790,'MRL-T50',9,'single',30,NULL,35,110,NULL,'inclusive',0,0,1,1,'MRLT50','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:53:41',NULL),(791,'MARCEL WASHING MACHINE MWM SWP60',9,'single',30,NULL,35,112,NULL,'inclusive',0,0,1,1,'SWP60','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:43:39',NULL),(792,'M24D19',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'M24D19','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:55:30',NULL),(794,'MSI-RIVERINE-24C-SMART 2 TON',9,'single',30,NULL,35,104,NULL,'inclusive',0,0,1,1,'24C2TON','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:20:32',NULL),(795,'MSN-RIVERINE-12A- 1TON',9,'single',30,NULL,35,104,NULL,'inclusive',0,0,1,1,'12A1TON','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:56:52',NULL),(796,'WMB BK01 MOSAR BATT',9,'single',30,NULL,36,79,NULL,'inclusive',0,0,1,1,'BK01','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:44:03',NULL),(797,'WRC- CSS180',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'CSS180','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:01:32',NULL),(798,'WALTON MALTI PLAG 2P4E3',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'2P4E3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:40:22',NULL),(799,'WALTON MALTI PLAG 3P4E',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'3P4E','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:44:02',NULL),(801,'Chular 3/86 teeee',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'teeeeeeeeeeeeeeee','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:50:09',NULL),(802,'Hotel Chular Magnet',9,'single',30,NULL,38,131,NULL,'inclusive',0,0,1,1,'magnehotel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-09-02 15:22:06',NULL),(803,'Chular Clamp',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'clam','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:52:57',NULL),(804,'Chular nat clam',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'chularnat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:57:42',NULL),(805,'SYMPHONY B66',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'B66','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:01:44',NULL),(806,'kiam electric kettle Stainless steel 200',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'steel200','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:14:14',NULL),(807,'Khan 56\" Celling Fan',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'khan56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 21:09:55',NULL),(808,'SYMPHONY S40',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'S40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:22:59',NULL),(809,'WALTON GYSER 35J',9,'single',30,NULL,36,87,NULL,'inclusive',0,0,1,1,'35J','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:28:51',NULL),(810,'WRC CSS18D',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'CSS18D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:23:15',NULL),(811,'WRC CSS22D',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'CSS22D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:55:32',NULL),(812,'WRC MS320',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'WMS320','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:43:20',NULL),(813,'SYMPHONY L42',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'L42','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:20:07',NULL),(814,'Purit Fiber Mesh net',9,'single',30,NULL,39,215,NULL,'inclusive',0,0,1,1,'fiber','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-08-07 14:46:20',NULL),(815,'SYMPHONY BD140',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'bd140','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:48:06',NULL),(816,'Kiam Auto Single Chula  g52',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'g52','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 20:54:57',NULL),(817,'Kiam Dosa Tawa 26cm frypan',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'dosa26cm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:50:39',NULL),(818,'WD32 SY150',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'SY150','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:02:00',NULL),(819,'Walton Air-Conditioner 18c',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'18ccccc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:37:53',NULL),(820,'Walton Air-Conditioner 18A',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'18AA','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:22:33',NULL),(821,'Walton Air-Conditioner 24C',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'24CCC','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:05:11',NULL),(822,'Walton Air-Conditioner 12A',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'12AAA','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 15:17:29',NULL),(824,'WBL-13MX35',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'13MX35','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:54:17',NULL),(825,'WBL-15PC40',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'W15PC40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:52:36',NULL),(826,'WALTON EXTENSION SOCKET 2P4H3M',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'2P4H3M','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:11:50',NULL),(827,'Walton Air-Conditioner 24B',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'24B','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:21:22',NULL),(828,'Jali fan 16\"',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'jalifan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:57:12',NULL),(829,'Walton Mobile Olivo Q38',9,'single',30,NULL,36,78,NULL,'inclusive',0,0,1,1,'Q38','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:44:45',NULL),(831,'BRB Celling Fan 56\"',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'brb56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-05 21:12:19',NULL),(832,'Mep 56 Aluminum Fan',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'mep56aluminim','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:44:45',NULL),(833,'Super Star Auto Double Chula 462',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'sp462','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:56:10',NULL),(834,'Nikko Auto Double Chula 325 Vip',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'nk325vip','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 20:54:30',NULL),(835,'Nikko Auto Double Chula 336',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'nk336','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:00:44',NULL),(836,'Nikko Auto Single Chula 30',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'nk30','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:30:17',NULL),(837,'Table Light 7682',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7682','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:54:24',NULL),(838,'Table Light 7628',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7628','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 15:58:12',NULL),(839,'Touch Light 8670 low',9,'single',30,NULL,39,175,NULL,'inclusive',0,0,1,1,'8670000low','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:02:18',NULL),(840,'MFD A4D GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A4DGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:15:11',NULL),(842,'MFB B1H GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B1HGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:07:16',NULL),(843,'MFB B5X GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B5XGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:23:28',NULL),(844,'MFE B8B CRX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B8BCRX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:29:15',NULL),(845,'MCF A4E GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A4EGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:13:19',NULL),(846,'MFC C0G GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C0GGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:55:54',NULL),(847,'Super star gas reguletor',9,'single',30,NULL,38,127,NULL,'inclusive',0,0,1,1,'spgasre333333','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:43:51',NULL),(848,'WBL 13 MC40',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'13MC40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 21:20:38',NULL),(849,'WGS SSB2',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'SSB2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:40:11',NULL),(850,'WRC CGA28D',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'CGA28D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 15:48:57',NULL),(851,'MD1-EF32-SV110',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'MSV110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 20:55:11',NULL),(852,'MD1-JX32-TS250',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'TS250M','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:51:22',NULL),(854,'SYMPHONY D72',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'D72','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 15:02:22',NULL),(855,'Normal Burner',9,'single',30,NULL,38,133,NULL,'inclusive',0,0,1,1,'normalburner','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:38:11',NULL),(856,'HAMKO 40AMP BETTARY',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'HAMKO40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:03:21',NULL),(857,'Miyako Electric Kettli MK 805 1.8',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'mk805','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:05:23',NULL),(858,'Miyako Electric Kettli MK 12',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'mk12','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:22:10',NULL),(859,'Nova Electric Kettli 1.8',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'novakettli','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 15:47:38',NULL),(860,'MIYAKO TRIMMER SAHVER PT230',9,'single',30,NULL,39,199,NULL,'inclusive',0,0,1,1,'PT230','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 22:52:01',NULL),(861,'SYMPHONY T180',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'T180','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-08 23:20:29',NULL),(862,'Rfl Burner',9,'single',30,NULL,38,133,NULL,'inclusive',0,0,1,1,'rflburner','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:21:42',NULL),(863,'Walton 16\" jali fan',9,'single',30,NULL,36,88,NULL,'inclusive',0,0,1,1,'waltonjali16','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-25 14:57:40',NULL),(864,'WGS GSLH1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'GSLH1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:46:29',NULL),(865,'WIR D01A',9,'single',30,NULL,36,50,NULL,'inclusive',0,0,1,1,'D01A','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:12:36',NULL),(866,'SYMPHONY L250i',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'L250i','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:45:07',NULL),(867,'Rfl Auto Single Chula 104srb',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'104SRB','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 19:57:40',NULL),(868,'Rfl Auto Single Chula 17GN',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'17GN','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-14 16:47:19',NULL),(869,'Rfl Auto Single Chula BLUBELL',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'BLUBELL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-08-04 17:18:31',NULL),(870,'Rfl Auto Single Chula SILKY',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'SILKY','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 16:36:07',NULL),(871,'Rfl Auto Single Chula JASSI',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'JASSY','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-17 16:32:18',NULL),(872,'Rfl Auto Single Chula FIONA',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'FIONA','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-20 17:05:37',NULL),(873,'Rfl Auto DOUBLE Chula 204SS',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'204SS','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:54:13',NULL),(874,'Rfl Auto DOUBLE Chula QUEEN',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'QUEEN','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 16:22:24',NULL),(875,'Rfl Auto DOUBLE Chula GRACESS',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'GRACE','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 17:08:42',NULL),(876,'Rfl Auto DOUBLE Chula 215SS',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'215SS','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:06','2021-06-24 15:06:14',NULL),(877,'Rfl Auto DOUBLE Chula JOSSI',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'JOSSI','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:18:43',NULL),(878,'Rfl Auto DOUBLE Chula BLUBELL',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'BLUBELLDOUBLE','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:53:03',NULL),(879,'Rfl Auto SINGLE Chula OLIVIA',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'OLIVIASI','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:46:45',NULL),(880,'Star Auto Singel chula 1042',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'star1042','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 20:55:36',NULL),(881,'MB Hotel Chula big',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'mbhotelchuyla','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:45:30',NULL),(882,'Walton Switch',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'Waltonswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:40:53',NULL),(883,'Walton Socket',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'waltonsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:00:35',NULL),(884,'Walton Indicutter',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'Waltonindicutter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:39:37',NULL),(885,'Walton Fiuz',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'waltonfiuz','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:23:19',NULL),(886,'Walton 1Hol bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w1hol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:26:34',NULL),(887,'Walton 2Hol bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w2hol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 15:57:58',NULL),(888,'Walton 3Hol bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w3hol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:49:46',NULL),(889,'Walton 4Hol bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w4hol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:50:19',NULL),(890,'Walton 5Hol bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w5hol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:07:26',NULL),(891,'Walton 6/8Hol bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w6/8hol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:10:06',NULL),(892,'Walton 6/8 plen bot',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w6/8plen','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:29:31',NULL),(893,'Walton 1Gang Tola',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w1gang','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-08 23:20:59',NULL),(894,'Walton 2pin Plag',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w2pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:24:00',NULL),(895,'Walton Jhulonto Holder',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'wjhulonto','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:39:45',NULL),(896,'Walton Led Bulb 3w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w3w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:21:23',NULL),(897,'Walton Led Bulb 5w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w5w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:15:53',NULL),(898,'Walton Led Bulb 7w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w7w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:50:20',NULL),(899,'Walton Led Bulb 12w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w12w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 20:55:36',NULL),(900,'Walton Led Bulb 15w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w15w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:51:47',NULL),(901,'Walton Led Bulb 18w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w18w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:12:39',NULL),(902,'Walton Led Bulb 20w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w20w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:36:53',NULL),(903,'Walton Led Bulb dim light',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'wdim','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:32:48',NULL),(904,'Walton Led Emergency Bulb 10w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'emargenccyw10w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 17:06:05',NULL),(905,'Walton Led Bulb 9w',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w9w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:57:46',NULL),(906,'Walton 14/16 DB Box',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'14/16dbbox','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:51:15',NULL),(907,'Walton t5 2feet t8',9,'single',30,NULL,36,72,NULL,'inclusive',0,0,1,1,'wt5t8','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:09:05',NULL),(908,'Walton Fan Reguletor',9,'single',30,NULL,36,65,NULL,'inclusive',0,0,1,1,'waltonfanregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:06:32',NULL),(909,'Walton Celing Rose',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'waltoncelingrose','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:20:59',NULL),(910,'Walton 4/6 DB Box',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w4/6dbbox','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:53:19',NULL),(911,'Walton Kostip',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'wkostip','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:46:59',NULL),(912,'Walton Power DB Box',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'powerdbbox','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 20:55:59',NULL),(913,'IPS 200WATT',9,'single',30,NULL,39,209,NULL,'inclusive',0,0,1,1,'31060','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:46:16',NULL),(914,'MEP FAN REGULATOR DIMAR',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'MEPDIMAR','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:41:28',NULL),(915,'MEP 3PIN SOCKET',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'MEP3PINSOCKET','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:10:35',NULL),(916,'KIAM BLENDER bl1300',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl1300','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:40:06',NULL),(917,'Table Light 7627',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7627','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:30:40',NULL),(918,'Table Light 7632',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'7632','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:27:31',NULL),(919,'AC Combain Socket 15am',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'accombain','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:25:21',NULL),(920,'MD4-TS43-DL220(43\")-SMART',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'dl220marcel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:50:31',NULL),(921,'MD4-TS43-KS220(43\")-SMART',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'KS220MARCEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:16:12',NULL),(923,'MRC CSS180',9,'single',30,NULL,35,96,NULL,'inclusive',0,0,1,1,'CSS180M','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:10:35',NULL),(924,'MBL 15PC40',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'M15PC40','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:49:01',NULL),(925,'MBL 15PX35',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'M15PX35','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:14:09',NULL),(926,'Kendei Charger fan 3936R',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'3936r','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:26:24',NULL),(927,'Kendei Charger fan 3936N',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'3936N','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:40:14',NULL),(928,'Walton 16gb Memory',9,'single',30,NULL,36,85,NULL,'inclusive',0,0,1,1,'w16gb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:21:47',NULL),(929,'Walton 32gb Memory',9,'single',30,NULL,36,85,NULL,'inclusive',0,0,1,1,'w32gb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:40:47',NULL),(930,'WALTON PEN DRIVE 32GB WU3032P031',9,'single',30,NULL,36,85,NULL,'inclusive',0,0,1,1,'32GBPEN','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:51:09',NULL),(931,'Walton Router WWR001N2',9,'single',30,NULL,36,84,NULL,'inclusive',0,0,1,1,'routerw','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:05:14',NULL),(932,'Walton Keyboard WKC001WN',9,'single',30,NULL,36,83,NULL,'inclusive',0,0,1,1,'c001wn','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:48:37',NULL),(933,'Walton Keyboard WKS010WN',9,'single',30,NULL,36,83,NULL,'inclusive',0,0,1,1,'s010wn','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-08-04 14:22:24',NULL),(934,'Walton Mouse WMS005WN',9,'single',30,NULL,36,82,NULL,'inclusive',0,0,1,1,'ms005wn','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:41:57',NULL),(935,'Walton Mouse WMS024WN',9,'single',30,NULL,36,82,NULL,'inclusive',0,0,1,1,'ms024wn','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:33:21',NULL),(936,'Walton Mouse WMS017WB',9,'single',30,NULL,36,82,NULL,'inclusive',0,0,1,1,'ms017wb','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 17:07:04',NULL),(937,'MEGA DIGITAL PALLA 60KG',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'60KGPALLA','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:58:34',NULL),(938,'SYMPHONY  B24',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'B24','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:02:23',NULL),(939,'SYMPHONY  B68',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'b68','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:10:12',NULL),(940,'SYMPHONY D92',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'d92','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:12:09',NULL),(941,'MARCEL M24D20 24\" LED',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'M24D20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:22:26',NULL),(942,'Topper auto Single chula A102',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'A102','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:53:31',NULL),(943,'Topper auto DOUBLE chula A24',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'A24','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:03:10',NULL),(944,'MRC CSS280',9,'single',30,NULL,35,96,NULL,'inclusive',0,0,1,1,'MRCCSS280','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 20:57:10',NULL),(945,'MARCEL DOUBLE CHULA MGS GSC2',9,'single',30,NULL,35,107,NULL,'inclusive',0,0,1,1,'MGSGSC2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:31:48',NULL),(946,'Nikko Auto Double Chula 416',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'nk416','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:30:10',NULL),(947,'Euro Gas Auto Single Chula  Glass',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'eurogasglasschula','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:16:02',NULL),(948,'Rfl Auto DOUBLE Chula Feona',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'feonafiona','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:41:07',NULL),(949,'Rfl Auto DOUBLE Chula Silky',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'silkydouble','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:31:14',NULL),(950,'Rfl Auto Single Chula Angel',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'ange','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:34:49',NULL),(951,'Rfl Auto Single Chula Queen',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'queensingle','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:12:40',NULL),(952,'MARCEL LED ME DH32V VOICE',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'MEDH32V','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:51:12',NULL),(953,'Calculator GT77',9,'single',30,NULL,39,178,NULL,'inclusive',0,0,1,1,'gt77','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:14:29',NULL),(954,'Calculator GT22',9,'single',30,NULL,39,178,NULL,'inclusive',0,0,1,1,'gt22','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:12:53',NULL),(955,'CC Cemara 56 Dot IRPF29069',9,'single',30,NULL,39,198,NULL,'inclusive',0,0,1,1,'29069','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:16:33',NULL),(956,'CC Cemara Adapter 12v 2am high',9,'single',30,NULL,39,198,NULL,'inclusive',0,0,1,1,'12v2am','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:45:28',NULL),(957,'CC Cemara Adapter 12v 2am Low',9,'single',30,NULL,39,198,NULL,'inclusive',0,0,1,1,'12v2am low','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:45:53',NULL),(958,'CC Cemara Ballon',9,'single',30,NULL,39,198,NULL,'inclusive',0,0,1,1,'Ballon','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:47:01',NULL),(959,'CC Cemara Audio Microphone',9,'single',30,NULL,39,198,NULL,'inclusive',0,0,1,1,'audiomicrophonecc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:46:15',NULL),(960,'CC Cemara AV Jack',9,'single',30,NULL,39,198,NULL,'inclusive',0,0,1,1,'acjackcc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:46:42',NULL),(961,'Euro Star Auto Single Chula charry',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'charry','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:41:15',NULL),(962,'Euro Star Auto Single Chula Four Flower',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'fourflower','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:51:58',NULL),(963,'Euro Star Auto Single Chula Alpona',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'alpona','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 20:56:30',NULL),(964,'Euro Star Auto Single Chula Red Model',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'redmodel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:49:39',NULL),(965,'JCL Auto Single Chula 52/13',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'jcl5213','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:14:09',NULL),(966,'Star Auto Single Chula 3D',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'star3d','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:42:28',NULL),(967,'JFI Pressur Gas Reguletor',9,'single',30,NULL,38,128,NULL,'inclusive',0,0,1,1,'jfipressurgasregu','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:34:03',NULL),(968,'Nokia 110',9,'single',30,NULL,37,213,NULL,'inclusive',0,0,1,1,'n110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 14:58:54',NULL),(969,'WGS SSH3',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'ssh3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:59:35',NULL),(970,'Walton 3/3 Boat',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w3/3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:05:57',NULL),(971,'Walton 6 Hol Boat',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w6holboat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:12:01',NULL),(972,'Walton 2pin Plag high',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w2pinh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:08:11',NULL),(973,'GFC 24\" Original',9,'single',30,NULL,39,167,NULL,'inclusive',0,0,1,1,'gfc24original','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:23:04',NULL),(974,'Akash DTSH',9,'single',30,NULL,39,197,NULL,'inclusive',0,0,1,1,'akashdtsnew','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:44:20',NULL),(975,'Walton Pedelstand Fan PBC 24B',9,'single',30,NULL,36,74,NULL,'inclusive',0,0,1,1,'PBC24B','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:03:42',NULL),(976,'Walton Charger fan 12A',9,'single',30,NULL,36,64,NULL,'inclusive',0,0,1,1,'w12a','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:17:35',NULL),(977,'Walton Charger fan 14A',9,'single',30,NULL,36,64,NULL,'inclusive',0,0,1,1,'w14a','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:32:42',NULL),(978,'Mep Gyser Swtich',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'mepgysers','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:34:27',NULL),(979,'Super Star Tv Socket',9,'single',30,NULL,39,157,NULL,'inclusive',0,0,1,1,'sptvsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:16:53',NULL),(980,'RFL GYSER 45 LTR GLAMER',9,'single',30,NULL,39,191,NULL,'inclusive',0,0,1,1,'45LTRGLAMMMER','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:41:55',NULL),(981,'RFL GYSER 35 LTR GLAMER',9,'single',30,NULL,39,191,NULL,'inclusive',0,0,1,1,'35LTRGLAMMER','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:31:59',NULL),(982,'RFL GYSER 45LTR GLOSSY',9,'single',30,NULL,39,191,NULL,'inclusive',0,0,1,1,'45LTRGLOSSY','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:29:31',NULL),(983,'RFL GYSER 30LTR GLOSSY',9,'single',30,NULL,39,191,NULL,'inclusive',0,0,1,1,'30LTRGLOSSY','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:13:51',NULL),(984,'CLICK 36\" CEILING FAN',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'CLICK36FAN','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 22:15:38',NULL),(985,'SYMPHONY D74',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'D74','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 14:41:42',NULL),(986,'SYMPHONY BL96',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'BL96','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:51:28',NULL),(987,'Shapla Auto Single Chula',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'shaplasinglechula','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:33:23',NULL),(989,'Chular Pipe',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'gaspipe','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 22:01:27',NULL),(990,'AirMate 24\" Jali Fan',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'24alli','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:42:45',NULL),(991,'Mega Weilght Scal 200kg G2',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'megag2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:49:20',NULL),(992,'Rfl Auto DOUBLE Chula Jolly',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'jollyrfldouble','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:41:38',NULL),(993,'BRB 23/76 Lota TAR',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'brb23/76','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:04:56',NULL),(994,'WK FYCK12',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'FYCK12','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-08-04 15:09:56',NULL),(996,'WRH PTC003',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'PTC003','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:52:38',NULL),(997,'SYMPHONY L135',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'L135','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 20:57:14',NULL),(998,'SYMPHONY T92',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'T92','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:50:51',NULL),(999,'Rod hitter 800w',9,'single',30,NULL,39,180,NULL,'inclusive',0,0,1,1,'rodhitter800w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:14:22',NULL),(1000,'Rfl Auto Single Chula Princes',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'rflprinces','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:43:35',NULL),(1001,'Orgin Electric Kettle OK ODW5A',9,'single',30,NULL,39,147,NULL,'inclusive',0,0,1,1,'orginkettle15a','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:34:59',NULL),(1002,'BRB  40/76 ac 2x2 2.0 Cover',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'brb40/76ac','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:59:52',NULL),(1003,'BRB  40/76 ac Lota',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'40/76lota','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:00:19',NULL),(1004,'WRH PTC203T',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'PTC203T','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:02:51',NULL),(1005,'WK LSS250',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'LSS250','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:49:45',NULL),(1006,'WGS SSB3',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'WGSSSB3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:26:41',NULL),(1007,'WGS 3GSLH1',9,'single',30,NULL,38,124,NULL,'inclusive',0,0,1,1,'3GSLH1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:24:24',NULL),(1008,'MFB B5X GDXXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B5XGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:02:53',NULL),(1011,'SYMPHONY  D82',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'D82','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:06:29',NULL),(1012,'Royal 2000w panir hitter',9,'single',30,NULL,39,180,NULL,'inclusive',0,0,1,1,'2000whe','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 20:58:03',NULL),(1013,'App 6Pin Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'app6pin','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:47:07',NULL),(1015,'Walon Induction ks20',9,'single',30,NULL,36,60,NULL,'inclusive',0,0,1,1,'ks20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:35:00',NULL),(1016,'Walton Room Heater PTC301W',9,'single',30,NULL,36,54,NULL,'inclusive',0,0,1,1,'301w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:17:59',NULL),(1017,'WK GDW17C',9,'single',30,NULL,36,49,NULL,'inclusive',0,0,1,1,'WK17C','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:42:29',NULL),(1018,'panir Hitter 1500w 1524',9,'single',30,NULL,39,180,NULL,'inclusive',0,0,1,1,'1524','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:34:52',NULL),(1020,'MK - GLDW170',9,'single',30,NULL,35,98,NULL,'inclusive',0,0,1,1,'MKGLDW1701.7','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:35:45',NULL),(1021,'MK-HGL18 1.8',9,'single',30,NULL,35,98,NULL,'inclusive',0,0,1,1,'HGL181.8','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:20:32',NULL),(1022,'MMWO-M30AS3 OVEN',9,'single',30,NULL,35,101,NULL,'inclusive',0,0,1,1,'MMWOM30AS3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:57:17',NULL),(1023,'MFC C4H GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C4HGDDD','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 14:42:28',NULL),(1024,'MFB B2F GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B2FGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:51:48',NULL),(1025,'MFB B2F GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B2FGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:34:42',NULL),(1026,'MFE C1B CRXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C1BCRXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:51:51',NULL),(1027,'MFE C1B GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C1BGDX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:16:09',NULL),(1028,'MFA 2A3 GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'MFA2A3GDELXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:49:53',NULL),(1029,'MFA 2A3 GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'MFA2A3GDX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:42:36',NULL),(1030,'WFC 3F5 GDNEX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3F5GDNX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:57:32',NULL),(1031,'WFB 2F0 GLASS',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2F0GD','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:42:00',NULL),(1032,'WFA 3X9 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3X9GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:53:07',NULL),(1033,'WFE 3B0 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3B0GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 20:57:36',NULL),(1034,'WFE 3A2 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3A2GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:53:55',NULL),(1035,'WFC 3A7 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3A7GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:14:49',NULL),(1036,'WFE 3A2 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3a2gd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:44:11',NULL),(1037,'WFC 3X7 GDELL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3X7GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:36:15',NULL),(1039,'WFB 2B6 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2b6gd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 14:59:37',NULL),(1040,'WFB 2E4 GDELXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2E4GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:01:23',NULL),(1041,'WFE 2H2 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2h2gd','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:03:38',NULL),(1042,'WFB 2X1 GD',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2X1GD','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:50:19',NULL),(1043,'WFE 2N5 ELNX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2N5ELXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:27:26',NULL),(1044,'WFE 2N5 CRXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2N5CRXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:25:42',NULL),(1045,'WCF 2T5 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2T5GDELX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:53:45',NULL),(1046,'WFB 1H5 ELXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1H5ELXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:41:01',NULL),(1047,'WFA 2D4 RXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2D4RXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 20:58:46',NULL),(1048,'WFC 1F5 RXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1F5RXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:35:00',NULL),(1049,'WFA 2A3 ELXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'WFA2A3ELX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:36:07',NULL),(1050,'WD1 TS43 FV 100 43\"',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'FV100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:19:22',NULL),(1051,'W24D20',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'24D20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:42:43',NULL),(1052,'W32Q20',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'W32Q20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:16:28',NULL),(1053,'W24D19',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'W24D19','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:30:57',NULL),(1054,'W32E110',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'W32E110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:21:06',NULL),(1055,'M32E110',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'ME110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:52:37',NULL),(1056,'M32Q20',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'M32Q20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 14:44:14',NULL),(1057,'MD1-DH32 BX220',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'MBX220','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:52:13',NULL),(1058,'MD1-DT24 RL110-S(24\") (BLACK)',9,'single',30,NULL,35,40,NULL,'inclusive',0,0,1,1,'M24RL110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:51:48',NULL),(1059,'Omera 12Kg Vora Gas',9,'single',30,NULL,38,119,NULL,'inclusive',0,0,1,1,'omera12kgvora++++','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:52:21',NULL),(1060,'Beximco 12Kg Vora Gas Silinder',9,'single',30,NULL,38,119,NULL,'inclusive',0,0,1,1,'bexmico12kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:58:25',NULL),(1061,'Bashundhara 12Kg Vora Gas',9,'single',30,NULL,38,118,NULL,'inclusive',0,0,1,1,'bashundhara12kgvora----','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:55:05',NULL),(1062,'12Kg Toal Gas Silinder',9,'single',30,NULL,38,122,NULL,'inclusive',0,0,1,1,'12kgtotalgassilinder.....','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:01:25',NULL),(1063,'Bashundhara 30Kg Vora GAss',9,'single',30,NULL,38,120,NULL,'inclusive',0,0,1,1,'bashundhara30kgvora','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:55:35',NULL),(1064,'30/35/45kg total Silinder',9,'single',30,NULL,38,123,NULL,'inclusive',0,0,1,1,'30/35/45kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:09:30',NULL),(1065,'Omera 35Kg Gas Vora',9,'single',30,NULL,38,121,NULL,'inclusive',0,0,1,1,'35kgvora','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:53:40',NULL),(1066,'Gol Kalo Jhik',9,'single',30,NULL,38,134,NULL,'inclusive',0,0,1,1,'golkalojhik','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:47:49',NULL),(1067,'Miyako Jhik',9,'single',30,NULL,38,134,NULL,'inclusive',0,0,1,1,'miyakojhik','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:08:23',NULL),(1068,'Steel Ss Jhik',9,'single',30,NULL,38,134,NULL,'inclusive',0,0,1,1,'ssjhik','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:15:07',NULL),(1069,'Glass chular jhik',9,'single',30,NULL,38,134,NULL,'inclusive',0,0,1,1,'glassjhik','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:45:34',NULL),(1070,'Rfl Full Tupi',9,'single',30,NULL,38,132,NULL,'inclusive',0,0,1,1,'rflfull','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:37:00',NULL),(1071,'Choto Tupi',9,'single',30,NULL,38,132,NULL,'inclusive',0,0,1,1,'CHOTOTUPI202020','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:49:18',NULL),(1072,'RFL Dhalai Boro Tupi',9,'single',30,NULL,38,132,NULL,'inclusive',0,0,1,1,'rfldhalaiboro','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:02:29',NULL),(1073,'RFL Dhalai Midium Tupi',9,'single',30,NULL,38,132,NULL,'inclusive',0,0,1,1,'rflmidiumtupi','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:46:31',NULL),(1074,'Miyako Dhalai Tupi',9,'single',30,NULL,38,132,NULL,'inclusive',0,0,1,1,'miyakodhaliatupi','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:21:41',NULL),(1075,'Miyako Pitol Boro Tupi',9,'single',30,NULL,38,132,NULL,'inclusive',0,0,1,1,'miyakopitolboro','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:28:04',NULL),(1076,'BRB 2.0',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB2.00','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:03:40',NULL),(1077,'BRB 1.5',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB1.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:01:31',NULL),(1078,'BRB 1.3',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB1.3','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:01:06',NULL),(1079,'BRB 1.0',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB1.0','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:00:41',NULL),(1080,'BRB 14/76 COVER WHITE',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB16/76COVER','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:02:34',NULL),(1081,'BRB 14/76 LOTA TAR',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'14/76LOTA','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:03:14',NULL),(1082,'Walton Panir Filter 28ltr',9,'single',30,NULL,36,56,NULL,'inclusive',0,0,1,1,'w28ltr','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:20:48',NULL),(1083,'SYMPHONY D47',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'sydd47','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:48:32',NULL),(1084,'SYMPHONY L260',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'syml260','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:16:55',NULL),(1085,'SYMPHONY l95',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'syml95','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:36:45',NULL),(1087,'Walton Washing Machine WWM Q70',9,'single',30,NULL,36,66,NULL,'inclusive',0,0,1,1,'wq70','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:58:29',NULL),(1088,'WFB 2B6 GDELXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2B6GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:53:09',NULL),(1090,'BRB 2.5',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB2.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:04:34',NULL),(1091,'Mb Hotel Chula',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'mbhotelchulaaaa','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:52:31',NULL),(1092,'WGS GSC1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'WGSGSC1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:42:18',NULL),(1093,'WGS GSC2',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'WGSGSC2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:54:03',NULL),(1094,'WGS GSHC1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'WGSGSHC1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:19:12',NULL),(1095,'WRC CGA18D',9,'single',30,NULL,36,47,NULL,'inclusive',0,0,1,1,'WRCCGA18D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:50:38',NULL),(1096,'WALTON MALTI PLAG WES2P4E5M',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'waltonmaltiplag5m','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:43:00',NULL),(1097,'WALTON MALTI PLAG 5M 2500w',9,'single',30,NULL,36,214,NULL,'inclusive',0,0,1,1,'waltonmaltipalg5m2500w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:30:20',NULL),(1098,'Walton Microwave Oven M23AKV',9,'single',30,NULL,36,52,NULL,'inclusive',0,0,1,1,'wm23akv','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:43:59',NULL),(1099,'Purit Stand',9,'single',30,NULL,39,200,NULL,'inclusive',0,0,1,1,'puritstand','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:54:13',NULL),(1100,'Super Star 1Gang Switch Glammor',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp1gangswitchglammor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:06:05',NULL),(1101,'Super Star Galmmor Fan Dimar',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'spfandimar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:09:10',NULL),(1102,'Super Star Galmmor 2Gang Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp2gangswitchglammor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:24:52',NULL),(1103,'Super Star Galmmor 2Pin Socket',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp2pinsocketgalmmor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:46:04',NULL),(1104,'Super Star Galmmor 3Pin Socket',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'sp3pinscoketglammor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 15:55:36',NULL),(1105,'Sp 4gan tola',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'sp4gangtola','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:00:17',NULL),(1106,'Kebol tai',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'keboltai','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:03:17',NULL),(1107,'SYMPHONY D54+',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'d54+','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:06:11',NULL),(1108,'WFE 3E8 GDXx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3e8gdxx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:22:03',NULL),(1110,'W32F110',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'WF110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:09:14',NULL),(1111,'WD1 32SV110',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'WSV110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:27:09',NULL),(1112,'BRB 7.0',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB7.0','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:07:45',NULL),(1113,'WFB 2E4 GDXXxx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2e4gdxxx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:48:45',NULL),(1114,'WFA 2D4 GDELx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2D4GDELx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 20:59:16',NULL),(1115,'WFA 2D4 GDX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2D4GDXXXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:35:51',NULL),(1116,'JAMKIL KIT 3000 ltr',9,'single',30,NULL,39,194,NULL,'inclusive',0,0,1,1,'3000ltr','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:37:36',NULL),(1118,'BRB Celling Fan 48\"',9,'single',30,NULL,39,160,NULL,'inclusive',0,0,1,1,'brb48\"d','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:08:11',NULL),(1119,'WFC 3D8 GDXXx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3D8GDxx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:49:00',NULL),(1120,'WFA 2A3 GDELx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2A3GDELXXx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:17:35',NULL),(1121,'WFD 1B6 GDELx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1B6GDELx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:53:05',NULL),(1122,'WFB 2B3 GDSHx',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2B3GDSHh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 17:02:22',NULL),(1123,'Speed King 56\" fan',9,'single',30,NULL,39,159,NULL,'inclusive',0,0,1,1,'speedking56','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:53:36',NULL),(1124,'Mep 36\" fan',9,'single',30,NULL,39,161,NULL,'inclusive',0,0,1,1,'mep36al','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 15:10:22',NULL),(1125,'MRF 35KG SCAL',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'MRF35KGSCAL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:52:45',NULL),(1126,'OPPO 35KG SCAL',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'OPPO35KGSCAL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:42:54',NULL),(1127,'JAMUNA 40KG SCALE',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'JAMUNA40KGSCAL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:54:29',NULL),(1130,'Walton Led Bulb 20w p-20',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w20wp20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:50:57',NULL),(1131,'MCF A4E RXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A4ERXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:43:28',NULL),(1132,'MFB A8E GDSH',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A8EGDSH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:30:54',NULL),(1133,'MFB B1H GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B1HGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:44:31',NULL),(1134,'MFD 1B6 GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'MFD1B6GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:54:26',NULL),(1135,'MFD 1B6 RXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'MFD1B6RXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:06:37',NULL),(1136,'MFD A6C RXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A6CRXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:56:57',NULL),(1137,'MFE B8B GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B8BGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:25:11',NULL),(1138,'WFD JET RXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'jetrxx','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:46:29',NULL),(1139,'Walton  Voltage Protector Jv15',9,'single',30,NULL,36,43,NULL,'inclusive',0,0,1,1,'jv15','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:37:39',NULL),(1140,'WDH32 HN220',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'HN220','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:00:31',NULL),(1141,'WDH32 32V Voice Control',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'voicecontrol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:04:20',NULL),(1142,'SYMPHONY l270',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'l270','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:06:21',NULL),(1143,'Miyako Auto Single Chula Glass',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'miyakosinglechulaglass','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-08-04 17:20:10',NULL),(1144,'Miyako Hotel Chula',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'miyakohotelchulaaa','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:28:17',NULL),(1145,'Tundul Hotel chula Dhalai Bati Burner',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'batiburnderhotelchula','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:29:38',NULL),(1146,'15 Burner Tundul Hotel chula',9,'single',30,NULL,38,210,NULL,'inclusive',0,0,1,1,'15burndertundul','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:03:41',NULL),(1147,'SS Lighter Chular',9,'single',30,NULL,38,139,NULL,'inclusive',0,0,1,1,'sslighter','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:42:10',NULL),(1148,'Glas Burner',9,'single',30,NULL,38,133,NULL,'inclusive',0,0,1,1,'glassburner','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:01:23',NULL),(1149,'MBL 13EX25',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'MBL13EX25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:36:41',NULL),(1150,'MBL 13CC25',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'MBL13CC25','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:38:30',NULL),(1151,'MWM TTM70',9,'single',30,NULL,35,112,NULL,'inclusive',0,0,1,1,'MWMTTM70','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:23:26',NULL),(1152,'MWM TT60',9,'single',30,NULL,35,112,NULL,'inclusive',0,0,1,1,'MWMTTP60','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:49:13',NULL),(1153,'MRC CGA28D',9,'single',30,NULL,35,96,NULL,'inclusive',0,0,1,1,'MRCCGA28D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:18:38',NULL),(1154,'MRC CSS18D',9,'single',30,NULL,35,96,NULL,'inclusive',0,0,1,1,'MRCCSS18D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 17:02:11',NULL),(1155,'MRC CSS28D',9,'single',30,NULL,35,96,NULL,'inclusive',0,0,1,1,'MRCCSS28D','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:21:47',NULL),(1156,'WGS SGC2',9,'single',30,NULL,36,61,NULL,'inclusive',0,0,1,1,'WGSSGC2','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:53:56',NULL),(1157,'MMB-K02 MARCEL MOSAR BATT',9,'single',30,NULL,35,116,NULL,'inclusive',0,0,1,1,'MMBK02','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 15:10:45',NULL),(1158,'MWP SH24L',9,'single',30,NULL,35,102,NULL,'inclusive',0,0,1,1,'MWPSH24L','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:53:24',NULL),(1159,'MWP SH28L',9,'single',30,NULL,35,102,NULL,'inclusive',0,0,1,1,'MWPSH28L','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:43:24',NULL),(1160,'MCF B0E GDELX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B0EGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:55:07',NULL),(1161,'MFE C6E NXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C6ENXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:20:12',NULL),(1162,'MFB B2F GDSH',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B2FGDSH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:56:25',NULL),(1163,'MFE C0G GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C0GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:43:52',NULL),(1164,'Table Light',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'tablelightdslfjlk','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:01:04',NULL),(1165,'WFB 2E0 GDSHH',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2E0GDSH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:45:06',NULL),(1166,'WFC 3D8 GD ELX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3D8GDELX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:43:42',NULL),(1167,'WFB 2E4 GDSHH',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2E4GDSH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:59:16',NULL),(1168,'WFA 2A3 RLXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'WFA2A3RX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:09:59',NULL),(1169,'Miyako Blender BL1100w',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'bl1100w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:26:42',NULL),(1170,'Hindustan Blender Bl850W',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'hindustanbl850w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:47:01',NULL),(1171,'Jaipan Blender 750W',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'jaipanbl750w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 15:56:43',NULL),(1172,'Jaipan Blender 850w new',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'jaipan850wnew','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:01:11',NULL),(1173,'Jaipan Blender 850w',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'jaipan850w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:13:44',NULL),(1174,'Miyako Doi Mekar',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'doimaker','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:06:41',NULL),(1175,'Miyako Hand Mixer HM112',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'miyakohandmixer','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:22:45',NULL),(1176,'MFE B9E GDX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B9EGDX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:28:39',NULL),(1177,'MFE C0N GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C0NGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:12:37',NULL),(1178,'MFE C1B GDEL',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C1BGDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:54:49',NULL),(1179,'WFC 3F5 GDELXXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3F5GDELXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:42:56',NULL),(1180,'WE4 396AFH 39\"',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'WE4396AFH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:19:40',NULL),(1181,'WD1 DH32 BX220',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'BX220W','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:37:52',NULL),(1182,'WWM AFM60',9,'single',30,NULL,36,66,NULL,'inclusive',0,0,1,1,'AFM60','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:39:20',NULL),(1183,'Mep 24\" Fan Al',9,'single',30,NULL,39,162,NULL,'inclusive',0,0,1,1,'mep24al','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:23:42',NULL),(1184,'WDH32 EFV220 VOICE CONTROL',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'VOICEWALTON','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:50:09',NULL),(1185,'Walton Charger fan W170EM',9,'single',30,NULL,36,64,NULL,'inclusive',0,0,1,1,'W170EMS','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:01:34',NULL),(1186,'Walton Charger fan W170A-AS',9,'single',30,NULL,36,64,NULL,'inclusive',0,0,1,1,'W170AS','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:37:13',NULL),(1187,'Kiam 28Cm Cassarol Frypan',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam28cmcassorol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:22:15',NULL),(1188,'Kiam Rice Cooker 1.8 8802',9,'single',30,NULL,39,145,NULL,'inclusive',0,0,1,1,'kiam1.88802','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 17:04:43',NULL),(1189,'Walton Air Cooler W18R',9,'single',30,NULL,36,89,NULL,'inclusive',0,0,1,1,'w18r','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:21:59',NULL),(1190,'WEF0801 ADJUST FAN',9,'single',30,NULL,36,90,NULL,'inclusive',0,0,1,1,'WEF0801','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 15:54:03',NULL),(1191,'WEF 1001 ADJUST FAN',9,'single',30,NULL,36,90,NULL,'inclusive',0,0,1,1,'WEF1001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:43:52',NULL),(1192,'Walton Led Bulb 15w PRIME',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'W15WPRIM','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:05:25',NULL),(1193,'Walton Led Bulb 20w PRIME',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'W20WPRIME','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:20:44',NULL),(1194,'WFA 2A3 GDEHX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'WFA2A3GDEHXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:56:37',NULL),(1195,'WFE 2N5 GDXXXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2N5GDXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:44:17',NULL),(1196,'WCF 5601 EMS',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'WCF5601EMWHITE','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-17 16:01:59',NULL),(1197,'WCF 5601 RMC',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'WCF5601RMC','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:54:32',NULL),(1198,'WCF 5604 WR PINK',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'WCF5604WRPINK','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:55:16',NULL),(1199,'Pressour Cooker Sish',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'sish','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 20:02:05',NULL),(1200,'Pressour Cooker Rubber',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'rabbar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:00:29',NULL),(1201,'Kiam Frypan 26CM korai',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam26cmkoraill','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:29:30',NULL),(1202,'Kiam Frypan 28CM korai',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam28cmkoriapan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 16:53:58',NULL),(1203,'Kiam 26Cm Cassarol Frypan',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam26cmcassarol','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 15:57:16',NULL),(1204,'Kiam 24CM frypan with galss lid',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'24cmwithglass','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:01:21',NULL),(1205,'Kiam 26Cm With Galss lid',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam26cmwtihglasa','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:14:30',NULL),(1206,'Kiam Pressur Cooker 4.5 Classic',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'4.5classic','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 17:06:50',NULL),(1207,'Kiam Pressur Cooker 5.5 Classic',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'5.5classic','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 22:51:05',NULL),(1208,'Kiam Rice Cooker 2.8 8804',9,'single',30,NULL,39,145,NULL,'inclusive',0,0,1,1,'kiam2.88804rice','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:09:51',NULL),(1209,'Kiam Blender BL1100',9,'single',30,NULL,39,146,NULL,'inclusive',0,0,1,1,'kiambl1100','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 15:13:09',NULL),(1210,'Walton Deep frz  2E5 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2E5GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 14:55:18',NULL),(1211,'Walton Deep frz  3J0 DDGE',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3J0DDGE','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-25 15:43:30',NULL),(1212,'WFB 2B3 GDEL',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'2B3GDELX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:20:20',NULL),(1213,'Walton led Panel light 24watt',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'ledpanellight 24w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:40:00',NULL),(1214,'WALTON ACDC LED 12W',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'waltonacdcled12w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 15:48:29',NULL),(1215,'Click Wallfan',9,'single',30,NULL,39,170,NULL,'inclusive',0,0,1,1,'clickwallfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 22:29:10',NULL),(1216,'Kiam Hotpot 4 Bati',9,'single',30,NULL,39,155,NULL,'inclusive',0,0,1,1,'kiamhotpot4bati','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 19:50:56',NULL),(1217,'Omera 5Kg Vora gas',9,'single',30,NULL,38,119,NULL,'inclusive',0,0,1,1,'omera5kg','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 16:33:40',NULL),(1218,'Click Charger Fan 12\"',9,'single',30,NULL,39,169,NULL,'inclusive',0,0,1,1,'clickchargerfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 22:16:36',NULL),(1219,'Luchy Table Fan 16\"',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'luchytablefan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-20 17:03:30',NULL),(1220,'AirPower 16\" Table fan',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'airpowertablefan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 20:43:28',NULL),(1221,'Star Auto Singel chula 1042',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'STAR1043','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 16:51:00',NULL),(1222,'Star Auto Singel chula 1046',9,'single',30,NULL,38,125,NULL,'inclusive',0,0,1,1,'STAR1046','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-24 21:10:24',NULL),(1223,'Malti  Plag 005',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maltiplag005','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-14 21:29:59',NULL),(1224,'Fan Capasitor 3.5',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'capasitor3.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-08 23:21:19',NULL),(1225,'Capasitor 2.5',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'capasitor2.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:15:17',NULL),(1226,'Capasitor 1.5',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'capasitor1.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:07','2021-06-05 21:14:56',NULL),(1227,'Capasitor 2.5 low',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'capasitor2.5low','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 21:15:39',NULL),(1228,'Capasitor 3.5 low',9,'single',30,NULL,39,172,NULL,'inclusive',0,0,1,1,'capasitor3.5low','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 21:16:11',NULL),(1229,'Touch Light 8670 sdgd',9,'single',30,NULL,39,175,NULL,'inclusive',0,0,1,1,'sdgd8670','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 15:50:40',NULL),(1230,'Table Light 7629',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'tablelight7629','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 21:05:00',NULL),(1231,'Table Light 7932',9,'single',30,NULL,39,174,NULL,'inclusive',0,0,1,1,'tablelight7932','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:47:30',NULL),(1232,'Malti Plag 604',9,'single',30,NULL,39,177,NULL,'inclusive',0,0,1,1,'maltiplag604','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 22:12:54',NULL),(1233,'Gfc 20\" Stand Fan ac',9,'single',30,NULL,39,167,NULL,'inclusive',0,0,1,1,'gfc20standfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:37:08',NULL),(1234,'Aircool 18\" full stand fan ac',9,'single',30,NULL,39,163,NULL,'inclusive',0,0,1,1,'18standfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:41:54',NULL),(1235,'Aircool 20\" full stand fan ac',9,'single',30,NULL,39,167,NULL,'inclusive',0,0,1,1,'20standfan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:42:15',NULL),(1236,'18\" Kendi Table fan ac',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'keneditablefan18','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:05:44',NULL),(1237,'Super Star 1Gang tola steel',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'sp1gangtola','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:01:57',NULL),(1238,'2Gang Tola Steel',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'2gangtolasteel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:08:29',NULL),(1239,'3 Gang Tola Steel',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'3gangtolasteel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:08:48',NULL),(1242,'WFB 1H5 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'WFB1H5GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:21:15',NULL),(1244,'Noha Dc Stand Fan',9,'single',30,NULL,39,168,NULL,'inclusive',0,0,1,1,'nohadcstand','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 15:47:56',NULL),(1245,'Rfl Digital Palla 30kg ss',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'rfl30kgss','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:47:13',NULL),(1246,'Rfl Digital Palla 40kg ss',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'rfl40kgss','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 20:56:19',NULL),(1247,'Expart Digital Palla 30kg',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'EXPART30KG','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:46:28',NULL),(1248,'Expart Digital Palla 40kg',9,'single',30,NULL,39,151,NULL,'inclusive',0,0,1,1,'EXPART40KG','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:41:38',NULL),(1249,'SYMPHONY B67',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'SYMB67','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:15:11',NULL),(1250,'SYMPHONY D41',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'D41','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 19:40:25',NULL),(1251,'SYMPHONY L45',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'SYML45','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:30:51',NULL),(1252,'SYMPHONY L46',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'SYML46','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:27:58',NULL),(1253,'SYMPHONY L140',9,'single',30,NULL,37,212,NULL,'inclusive',0,0,1,1,'SYML140','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:38:10',NULL),(1254,'MFC C6E GDXXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C6EGDXXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:50:43',NULL),(1255,'Walton 4V Bettery',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'walton4v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:16:28',NULL),(1256,'Walton 6v bettery',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'walton6v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:07:41',NULL),(1257,'Walton 12v Bettery',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'walton12v','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 22:25:13',NULL),(1258,'Light Jack',9,'single',30,NULL,39,157,NULL,'inclusive',0,0,1,1,'lightjack','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:49:35',NULL),(1259,'Walton 6v bettery high',9,'single',30,NULL,39,176,NULL,'inclusive',0,0,1,1,'walton6vhigh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:14:27',NULL),(1260,'Super Star Panel 160    w',9,'single',30,NULL,39,184,NULL,'inclusive',0,0,1,1,'solar panel 160    w','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:25:02',NULL),(1261,'Volvo 130 amh',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'130amh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:40:33',NULL),(1262,'Euro Star 120 amh bettery',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'120amheurostr','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 21:21:59',NULL),(1263,'Solar Bettery Tar Set',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'solartarset','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:17:46',NULL),(1264,'Solar Panel Stackcar',9,'single',30,NULL,39,187,NULL,'inclusive',0,0,1,1,'stackcar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:42:53',NULL),(1265,'8/10 Plen Boad',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'8/10plen','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:21:11',NULL),(1266,'32Amh Kataut',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'32amhkataut','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:13:00',NULL),(1267,'prodip Main Switch 30amh',9,'single',30,NULL,39,183,NULL,'inclusive',0,0,1,1,'mainswitch30amh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 22:13:46',NULL),(1268,'160W SOLAR PANEL',9,'single',30,NULL,39,184,NULL,'inclusive',0,0,1,1,'160WSOLARPANEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:04:36',NULL),(1269,'MEP 2PIN sOCKET SIRAMIC',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'2PINSOCKET','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:33:33',NULL),(1270,'Walton 20am Sarkit brekar',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w20amhsarkit','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 17:07:36',NULL),(1271,'Walton 16amh Sarkit Brekar',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w16amsarkit','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:58:55',NULL),(1272,'Walton 6amh Sarkit Brekar',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'w6amsarikit','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:02:37',NULL),(1273,'Walton celing Rose D',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'waltoncelingrosed','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:10:31',NULL),(1275,'Walton 5pin socket',9,'single',30,NULL,36,46,NULL,'inclusive',0,0,1,1,'w5pinsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-25 14:49:10',NULL),(1276,'Walton Buttom Holder E27',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'wbuttmoholdere27','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 15:48:33',NULL),(1277,'Walton 3pin Socket Trust gold',9,'single',30,NULL,36,46,NULL,'inclusive',0,0,1,1,'w3pintrust','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-25 15:03:22',NULL),(1278,'Walton 6w Panel Light blue',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w6wpanel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:13:04',NULL),(1279,'Walton 6w Panel Light white',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w6wpanelwhite','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:38:49',NULL),(1280,'Walton 18w Led Panle Light',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w18wpanel','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 15:30:38',NULL),(1281,'Walton Single Db Box',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'wsingledbbox','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:16:21',NULL),(1282,'Walton Double Db Box',9,'single',30,NULL,36,86,NULL,'inclusive',0,0,1,1,'wdoublebox','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 19:41:24',NULL),(1283,'WD32RS',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'WD32RS','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:31:34',NULL),(1284,'WD4 EF32 SV200',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'WE4EF32SV220','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:29:06',NULL),(1285,'WE32G20 VOICE CONTROL',9,'single',30,NULL,36,42,NULL,'inclusive',0,0,1,1,'WE32G20','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:56:30',NULL),(1286,'WBL VK01 NEW',9,'single',30,NULL,36,48,NULL,'inclusive',0,0,1,1,'WBLVK01NEW','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:51:26',NULL),(1287,'MCW CSL 2401 CASSAROLE',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWCSL2401','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 14:41:22',NULL),(1288,'MCW CSL 2601 CASSAROLE',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWCSL2601','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:07:49',NULL),(1289,'MCW CSL 2801 CASSAROLE',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWCSL2801','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 21:11:11',NULL),(1290,'MCW FS2001',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWFS2001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:04:29',NULL),(1291,'MCW FSL2401',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWFSL2401','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:15:26',NULL),(1292,'MCW FSL2601',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWFSL2601','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:10:00',NULL),(1293,'MCW FSL2801',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWFSL2801','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:40:59',NULL),(1294,'MCW WSL2601',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWWSL2601','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 21:22:34',NULL),(1295,'MCW WSL2801',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWWSL2801','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:18:06',NULL),(1296,'MBL VK01 NEW',9,'single',30,NULL,35,97,NULL,'inclusive',0,0,1,1,'MVK01NEW','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 15:52:11',NULL),(1297,'MGS GSC90',9,'single',30,NULL,35,106,NULL,'inclusive',0,0,1,1,'MGSGSC90','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 21:05:31',NULL),(1298,'MRC SGA280',9,'single',30,NULL,35,96,NULL,'inclusive',0,0,1,1,'MRCSGA280','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:49:03',NULL),(1299,'MARCEL LED TV REMOT ORIGINAL',9,'single',30,NULL,39,156,NULL,'inclusive',0,0,1,1,'MARCELORIGINAL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-25 15:48:20',NULL),(1300,'MCW FSL2001',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWFSL2001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:42:44',NULL),(1301,'MCW WSL2401',9,'single',30,NULL,35,117,NULL,'inclusive',0,0,1,1,'MCWWSL2401','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:34:16',NULL),(1302,'Purite Water Purifier RO + MF',9,'single',30,NULL,39,152,NULL,'inclusive',0,0,1,1,'ro+mf','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 14:58:11',NULL),(1303,'WFE 3X9 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3X9GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:59:08',NULL),(1304,'Zinzn Table Fan',9,'single',30,NULL,39,165,NULL,'inclusive',0,0,1,1,'zinzntable fan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:10:56',NULL),(1305,'WFB 1H5 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1H5GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 22:21:09',NULL),(1306,'WFA 2A3 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'WFA2A3GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:08:22',NULL),(1307,'MFB B2C GDSH',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B2CGDSH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:23:24',NULL),(1308,'MFB B5D GDXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B5DGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 15:49:39',NULL),(1309,'WFE 3B0 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3B0GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-25 15:03:54',NULL),(1310,'WFE 3C3 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3C3GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 20:57:29',NULL),(1311,'MMB-K01 MARCEL MOSAR BATT NEW',9,'single',30,NULL,35,116,NULL,'inclusive',0,0,1,1,'MMBK01MARCEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:33:23',NULL),(1312,'Walton Tornedo Fan 9\"',9,'single',30,NULL,36,81,NULL,'inclusive',0,0,1,1,'watontornedofan','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 15:34:40',NULL),(1315,'Volbo 100Amh BEttery',9,'single',30,NULL,39,185,NULL,'inclusive',0,0,1,1,'volvo100amh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:32:14',NULL),(1316,'WFE 2N5 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2N5GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:29:50',NULL),(1317,'MCF B0E RLXX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'B0ERLXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:57:10',NULL),(1318,'MFB A8E GDX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'A8EGDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:51:38',NULL),(1319,'MFC C6E GDEH XX',9,'single',30,NULL,35,91,NULL,'inclusive',0,0,1,1,'C6EGDEH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 14:41:59',NULL),(1320,'WFB 1H5 GSH',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1H5GDSH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:08:11',NULL),(1321,'Tornedo WTF10S5',9,'single',30,NULL,36,81,NULL,'inclusive',0,0,1,1,'WTF10S5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 21:33:48',NULL),(1322,'WNI 5F3 GDELXX DOUBLE DOOR',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'5F3GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:50:58',NULL),(1323,'WFE 3E8 GDEL',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3E8GDEL','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:15:48',NULL),(1324,'WFB 2E0 GDXXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2E0GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-25 14:49:31',NULL),(1325,'WCF 5604 WR INDIGO',9,'single',30,NULL,36,63,NULL,'inclusive',0,0,1,1,'WCF5604WRINDIGO','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:42:00',NULL),(1326,'BRB 4.5',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'BRB4.5','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 21:06:41',NULL),(1327,'Aluminum Ruti Tawa',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'Rutitawa','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:46:45',NULL),(1328,'Kiam Pressur Cooker 3.5 Queen',9,'single',30,NULL,39,153,NULL,'inclusive',0,0,1,1,'3.5queen','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:43:01',NULL),(1329,'WFE 3F5 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'3F5GDXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 21:05:43',NULL),(1330,'WCF 1D5 RX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1D5RXX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:50:14',NULL),(1331,'Sp Galammor  3Gang Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'3gangglamor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 22:14:32',NULL),(1332,'Sp Galammor  4Gang Switch',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'4ganggalamor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:43:46',NULL),(1333,'Sp Galammor  Fan Dimar',9,'single',30,NULL,39,171,NULL,'inclusive',0,0,1,1,'galmordimar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:35:37',NULL),(1334,'Sp 6Pin Socket Galmor',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'6pingalmor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:49:07',NULL),(1335,'SP glamor 3pin Round Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'3pinroundsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:59:57',NULL),(1336,'SP DP Switch galamor',9,'single',30,NULL,39,190,NULL,'inclusive',0,0,1,1,'dpswitchgalamor','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:03:22',NULL),(1337,'Sp 10amp Sarkit Brekar',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'10ampsarkitbrekar','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 22:49:59',NULL),(1338,'5/5 Abonat boat',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'5/5abonat','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:15:48',NULL),(1339,'Security Box',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'seceurity box','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:24:40',NULL),(1340,'4/4 Mk Cover',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'4/4mkcover','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:13:34',NULL),(1342,'Washer',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'washer','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 21:18:21',NULL),(1343,'WVS SUPRIME-2100JV',9,'single',30,NULL,36,45,NULL,'inclusive',0,0,1,1,'WVS2100JV','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:34:20',NULL),(1344,'WRL-L10',9,'single',30,NULL,36,68,NULL,'inclusive',0,0,1,1,'WLRL10','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 15:35:21',NULL),(1345,'WSI KRYSTALINE-12A 1TON DEFENDER',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'WSI12ADEFENDER','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:18:13',NULL),(1346,'WFD 1F3 GDEH',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'1F3GDEH','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 16:02:05',NULL),(1347,'Walton Led Bulb 15w psa',9,'single',30,NULL,36,53,NULL,'inclusive',0,0,1,1,'w15wpsa','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 16:35:12',NULL),(1348,'Kiam 7 Pice Gift Box',9,'single',30,NULL,39,154,NULL,'inclusive',0,0,1,1,'kiam7picsgift','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-14 16:30:04',NULL),(1349,'WTF TABLE FAN CREAM WHITE',9,'single',30,NULL,36,81,NULL,'inclusive',0,0,1,1,'CREAMWHITE','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-20 16:57:59',NULL),(1350,'WFB 2A8 GDXX',9,'single',30,NULL,36,41,NULL,'inclusive',0,0,1,1,'2A8GDX','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:52:10',NULL),(1353,'WGS GSLS1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'GSLS1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 17:08:21',NULL),(1354,'WGS DS1',9,'single',30,NULL,36,62,NULL,'inclusive',0,0,1,1,'WGSDS1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 21:41:28',NULL),(1355,'WSI INVERNA SUPER SAVER 12A',9,'single',30,NULL,36,92,NULL,'inclusive',0,0,1,1,'WSIINVERNA12A','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-17 16:51:13',NULL),(1356,'Mep 3Pin Plag high',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'mep3pinh','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-24 15:16:18',NULL),(1357,'Mep Ac Socket',9,'single',30,NULL,39,144,NULL,'inclusive',0,0,1,1,'mepacsocket','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-25 14:50:07',NULL),(1360,'7/9 Dp  Switch mep',9,'single',30,NULL,39,183,NULL,'inclusive',0,0,1,1,'7/9dpswitch','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 20:20:49',NULL),(1364,'1\" Van',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'1ven','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 19:58:41',NULL),(1365,'1\" Sarkuler Box',9,'single',30,NULL,39,192,NULL,'inclusive',0,0,1,1,'1box','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 19:57:43',NULL),(1366,'BRB 10RM Tar',9,'single',30,NULL,39,193,NULL,'inclusive',0,0,1,1,'brb10rm','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'',NULL,36,NULL,'2021-05-28 02:08:08','2021-06-05 21:02:03',NULL),(1369,'Walton Mobile Olivo L51',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'olivol51','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:23:35','2021-06-25 20:24:05',NULL),(1370,'Walton Mobile Olivo L53',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'olivol53','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:26:01','2021-06-25 20:26:01',NULL),(1371,'Walton Mobile Olivo P15',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'olivop15','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:27:05','2021-06-25 20:27:05',NULL),(1372,'Walton Mobile Olivo P16',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'olivo p16','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:28:09','2021-06-25 20:28:09',NULL),(1373,'Walton Mobile Olivo MM24',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'1373','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:30:10','2021-06-25 20:30:10',NULL),(1374,'Walton Mobile Olivo ML21',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'OLIVOML21','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:30:52','2021-06-25 20:30:52',NULL),(1375,'Walton Mobile Olivo  ML19',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'OLIVOML19','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:31:55','2021-06-25 20:31:55',NULL),(1376,'Walton Mobile Olivo  MM19J',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'MM19J','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:32:28','2021-06-25 20:32:28',NULL),(1377,'Walton Mobile Olivo  L52',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'OLIVOL52','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-25 20:33:46','2021-06-25 20:33:46',NULL),(1378,'MARCEL LED M32F110',9,'single',30,NULL,35,40,NULL,'exclusive',0,0,1,1,'1378','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-06-27 16:51:24','2021-06-27 16:51:24',NULL),(1379,'WD1 TS43 DL220 43\"',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,1,'dl220w','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 14:53:57','2021-08-03 14:53:57',NULL),(1380,'WFD 1B6 GDEH',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'1B6GDEH','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 14:59:10','2021-08-03 14:59:10',NULL),(1381,'WFE 2H2 GDENX INV',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'2H2GDENXINV','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:00:57','2021-08-03 15:00:57',NULL),(1382,'WFE 2N5 CRXX INVERTER',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'2N5CRXINV','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:01:55','2021-08-03 15:01:55',NULL),(1383,'WFE 3A2 GDENXX',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'3A2GDENX','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:03:22','2021-08-03 15:03:22',NULL),(1384,'WFE 3A2 GDENXX',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'3A2GDENX','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:03:41','2021-08-03 15:03:41',NULL),(1385,'WFE 3F5 GDEL',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'3F5GDEL','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:05:07','2021-08-03 15:05:07',NULL),(1386,'WFD 1F3 RXXX',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'1F3RXX','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:09:11','2021-08-03 15:09:11',NULL),(1387,'WNI 5F3 GDEL DD DOUBLE DOOR',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'5F3GDELDD','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:10:58','2021-08-03 15:10:58',NULL),(1388,'WFE 3C3 GDEN-XX',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'3C3GDENX','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:15:19','2021-08-03 15:15:19',NULL),(1389,'WFB 2B6 GDSH',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,1,'1389','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 15:18:22','2021-08-03 15:18:22',NULL),(1390,'WSN RIVERINE 12A 1 TON',9,'single',30,NULL,36,92,NULL,'exclusive',0,0,1,1,'1390','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 17:31:59','2021-08-03 17:31:59',NULL),(1391,'WEF 1201 ADJUST FAN',9,'single',30,NULL,36,90,NULL,'exclusive',0,0,1,1,'1391','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 17:36:09','2021-08-03 17:36:09',NULL),(1392,'WGS GSC10 SINGLE STOVE',9,'single',30,NULL,36,61,NULL,'exclusive',0,0,1,1,'1392','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 17:42:29','2021-08-03 17:42:29',NULL),(1393,'WRC CSS28D',9,'single',30,NULL,36,47,NULL,'exclusive',0,0,1,1,'1393','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 20:37:13','2021-08-03 20:37:13',NULL),(1394,'WRC SGA 280',9,'single',30,NULL,36,47,NULL,'exclusive',0,0,1,1,'1394','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 20:42:16','2021-08-03 20:42:16',NULL),(1395,'WMC GCA712',9,'single',30,NULL,36,47,NULL,'exclusive',0,0,1,1,'1395','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 20:43:43','2021-08-03 20:43:43',NULL),(1396,'WMC GCS712',9,'single',30,NULL,36,47,NULL,'exclusive',0,0,1,1,'1396','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 20:44:16','2021-08-03 20:44:16',NULL),(1397,'WRC SGAE28',9,'single',30,NULL,36,47,NULL,'exclusive',0,0,1,1,'1397','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 20:46:53','2021-08-03 20:46:53',NULL),(1398,'WRC CGA22D',9,'single',30,NULL,36,47,NULL,'exclusive',0,0,1,1,'1398','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 20:49:59','2021-08-03 20:49:59',NULL),(1399,'WALTON LED TUBE T5BAT 10W',9,'single',30,NULL,36,72,NULL,'exclusive',0,0,1,1,'1399','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-03 21:16:01','2021-08-03 21:16:01',NULL),(1400,'Walton Mobile Olivo L1',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'1400','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 13:55:57','2021-08-04 13:55:57',NULL),(1401,'Walton Mobile Olivo L2',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,1,'1401','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 13:56:46','2021-08-04 13:56:46',NULL),(1402,'WRH PTC006',9,'single',30,NULL,36,54,NULL,'exclusive',0,0,1,1,'1402','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 14:03:28','2021-08-04 14:03:28',NULL),(1403,'WBL 15GM75',9,'single',30,NULL,36,48,NULL,'exclusive',0,0,1,1,'1403','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 14:11:16','2021-08-04 14:14:57',NULL),(1404,'WGS GDC10 DOUBLE STOVE',9,'single',30,NULL,36,62,NULL,'exclusive',0,0,1,1,'1404','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 14:16:37','2021-08-04 14:16:37',NULL),(1405,'WRL L98',9,'single',30,NULL,36,71,NULL,'exclusive',0,0,1,1,'1405','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 14:44:03','2021-08-04 14:44:03',NULL),(1406,'WIR SC01',9,'single',30,NULL,36,50,NULL,'exclusive',0,0,1,1,'1406','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 15:19:44','2021-08-04 15:19:44',NULL),(1407,'WIR SC01',9,'single',30,NULL,36,50,NULL,'exclusive',0,0,1,1,'1407','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 15:19:47','2021-08-04 15:19:47',NULL),(1408,'WIR SC02',9,'single',30,NULL,36,50,NULL,'exclusive',0,0,1,1,'1408','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 15:20:42','2021-08-04 15:20:42',NULL),(1409,'WIR S02',9,'single',30,NULL,36,50,NULL,'exclusive',0,0,1,1,'1409','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 15:26:28','2021-08-04 15:26:28',NULL),(1410,'Rfl Auto Single Chula JOSSI',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1410','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 16:08:01','2021-08-04 16:08:01',NULL),(1411,'Rfl Auto Single Chula ROSE',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1411','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 16:16:34','2021-08-04 16:16:34',NULL),(1412,'Super Star Auto Single chula st21',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1412','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 16:41:43','2021-08-04 16:41:43',NULL),(1413,'Sharip Auto Single Chula',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1413','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 16:44:52','2021-08-04 16:44:52',NULL),(1414,'Star Auto SingLE chula TMS04',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1414','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 16:56:02','2021-08-04 16:56:02',NULL),(1415,'OMERA AUTO SINGLE CHULA',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1415','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 17:00:41','2021-08-04 17:00:41',NULL),(1416,'NOVENA GELAXY AUTO SINGLE CHULA',9,'single',30,NULL,38,125,NULL,'exclusive',0,0,1,1,'1416','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 17:02:43','2021-08-04 17:02:43',NULL),(1417,'Rfl Auto DOUBLE Chula ROSE',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1417','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 19:39:44','2021-08-04 19:39:44',NULL),(1418,'Rfl Auto Double Chula 206trb',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1418','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 19:41:53','2021-08-04 19:41:53',NULL),(1419,'Rfl Auto Double Elegent',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1419','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 19:44:18','2021-08-04 19:44:18',NULL),(1420,'Nikko Auto Double Chula 430',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1420','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 19:47:05','2021-08-04 19:47:05',NULL),(1421,'Nikko Auto Double Chula 322',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'nk322','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 20:00:16','2021-08-04 20:00:16',NULL),(1422,'Super star auto doubel chula st366',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1422','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 21:44:34','2021-08-04 21:44:34',NULL),(1423,'Nikko Auto Double Chula 311',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1423','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 21:48:40','2021-08-04 21:48:40',NULL),(1424,'Star Auto Double Chula',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1424','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 21:53:08','2021-08-04 21:53:08',NULL),(1425,'Rfl Auto Double Chula Olivia',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1425','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 21:57:32','2021-08-04 21:57:32',NULL),(1426,'Nikko Auto Double Chula 340',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1426','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 21:59:07','2021-08-04 21:59:07',NULL),(1427,'Nikko Auto Double Chula 421',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'nk421','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 21:59:58','2021-08-04 21:59:58',NULL),(1428,'Nikko Auto Double Chula 334',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,1,'1428','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:04:20','2021-08-04 22:04:20',NULL),(1429,'Blue Magic Gas Reguletor',9,'single',30,NULL,38,127,NULL,'exclusive',0,0,1,1,'1429','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:16:29','2021-08-04 22:16:29',NULL),(1430,'Vintage 20 MM Gas Reguletor',9,'single',30,NULL,38,127,NULL,'exclusive',0,0,1,1,'1430','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:18:13','2021-08-04 22:18:13',NULL),(1431,'Rfl Pressur Gas Reguletor',9,'single',30,NULL,38,128,NULL,'exclusive',0,0,1,1,'1431','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:23:01','2021-08-04 22:23:01',NULL),(1432,'Rfl Full Tupi Kalo',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1432','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:26:44','2021-08-04 22:26:44',NULL),(1433,'Rfl Full Tupi Pitol',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1433','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:27:23','2021-08-04 22:27:23',NULL),(1434,'Rfl Full Tupi Pitol',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1434','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:28:17','2021-08-04 22:28:17',NULL),(1435,'Rfl Full Tupi Dhalai',9,'single',30,NULL,38,NULL,NULL,'exclusive',0,0,1,1,'1435','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:30:27','2021-08-04 22:30:27',NULL),(1436,'Choto Tupi Pitol 65',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1436','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:34:01','2021-08-04 22:34:01',NULL),(1437,'Rfl Tupi 90mm',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1437','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:36:20','2021-08-04 22:36:20',NULL),(1438,'Miyako Dhalai Tupi Midium',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1438','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:40:31','2021-08-04 22:40:31',NULL),(1439,'Normal Tupi',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,1,'1439','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:43:48','2021-08-04 22:43:48',NULL),(1440,'Nob Cover',9,'single',30,NULL,38,136,NULL,'exclusive',0,0,1,1,'1440','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 22:45:36','2021-08-04 22:45:36',NULL),(1441,'chular clam long',9,'single',30,NULL,38,139,NULL,'exclusive',0,0,1,1,'1441','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 23:36:14','2021-08-04 23:36:14',NULL),(1442,'chular clam midium',9,'single',30,NULL,38,139,NULL,'exclusive',0,0,1,1,'1442','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-04 23:36:49','2021-08-04 23:36:49',NULL),(1443,'RFL  Patla Burner Big',9,'single',30,NULL,38,133,NULL,'exclusive',0,0,1,1,'1443','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 13:34:26','2021-08-05 13:34:26',NULL),(1444,'RFL Midium Burner',9,'single',30,NULL,38,133,NULL,'exclusive',0,0,1,1,'1444','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 13:36:07','2021-08-05 13:36:07',NULL),(1445,'Miyako Burner',9,'single',30,NULL,38,133,NULL,'exclusive',0,0,1,1,'1445','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 14:44:11','2021-08-05 14:44:11',NULL),(1446,'MFB B5X GDSH',9,'single',30,NULL,35,91,NULL,'exclusive',0,0,1,1,'1446','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:16:40','2021-08-05 16:16:40',NULL),(1447,'MFD A6C GDEL',9,'single',30,NULL,35,91,NULL,'exclusive',0,0,1,1,'1447','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:18:58','2021-08-05 16:18:58',NULL),(1448,'Marcel Led Light 20W',9,'single',30,NULL,35,114,NULL,'exclusive',0,0,1,1,'1448','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:36:28','2021-08-05 16:36:28',NULL),(1449,'MD24R',9,'single',30,NULL,35,40,NULL,'exclusive',0,0,1,1,'1449','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:48:27','2021-08-05 16:48:27',NULL),(1450,'M24R21',9,'single',30,NULL,35,40,NULL,'exclusive',0,0,1,1,'1450','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:48:53','2021-08-05 16:48:53',NULL),(1451,'MD24R20',9,'single',30,NULL,35,40,NULL,'exclusive',0,0,1,1,'1451','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:52:27','2021-08-05 16:52:27',NULL),(1452,'MD24D29',9,'single',30,NULL,35,40,NULL,'exclusive',0,0,1,1,'1452','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 16:54:50','2021-08-05 16:54:50',NULL),(1453,'MMWO M23ARW',9,'single',30,NULL,35,101,NULL,'exclusive',0,0,1,1,'1453','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 17:04:25','2021-08-05 17:04:25',NULL),(1455,'MFA B4D GDEL 3PCS EXT',9,'single',30,NULL,35,91,NULL,'exclusive',0,0,1,1,'1455','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 20:49:47','2021-08-05 20:49:47',NULL),(1456,'Active Smart Charger NSP',9,'single',30,NULL,37,203,NULL,'exclusive',0,0,1,1,'1456','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 20:57:05','2021-08-05 20:57:05',NULL),(1457,'ACTIVE CLIP CHARGER',9,'single',30,NULL,37,203,NULL,'exclusive',0,0,1,1,'1457','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 20:59:53','2021-08-05 20:59:53',NULL),(1458,'MEGA DIGITAL PALLA 20KG',9,'single',30,NULL,39,151,NULL,'exclusive',0,0,1,1,'1458','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 21:44:19','2021-08-05 21:44:19',NULL),(1459,'BEAUTY 56\' FAN',9,'single',30,NULL,39,159,NULL,'exclusive',0,0,1,1,'1459','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 21:59:24','2021-08-05 22:09:43',NULL),(1460,'SAKURA 56\" FAN',9,'single',30,NULL,39,159,NULL,'exclusive',0,0,1,1,'1460','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:04:09','2021-08-05 22:04:09',NULL),(1461,'DHAKA SERVICE 56\"',9,'single',30,NULL,39,159,NULL,'exclusive',0,0,1,1,'1461','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:05:42','2021-08-05 22:05:42',NULL),(1462,'Kiam Rice Cooker 1.8 8702',9,'single',30,NULL,39,145,NULL,'exclusive',0,0,1,1,'1462','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:18:51','2021-08-05 22:18:51',NULL),(1463,'Kiam Rice Cooker 1.8 8802',9,'single',30,NULL,39,145,NULL,'exclusive',0,0,1,1,'1463','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:19:22','2021-08-05 22:19:22',NULL),(1464,'Kiam Rice Cooker 2.8 8704',9,'single',30,NULL,39,145,NULL,'exclusive',0,0,1,1,'1464','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:20:06','2021-08-05 22:20:06',NULL),(1465,'Kiam Rice Cooker 1.8 8802',9,'single',30,NULL,39,145,NULL,'exclusive',0,0,1,1,'1465','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:26:24','2021-08-05 22:26:24',NULL),(1466,'Kiam Rice Cooker 2.8 DJ204',9,'single',30,NULL,39,145,NULL,'exclusive',0,0,1,1,'1466','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 22:28:45','2021-08-05 22:28:45',NULL),(1467,'Novena 650w Blender',9,'single',30,NULL,39,146,NULL,'exclusive',0,0,1,1,'1467','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-05 23:11:53','2021-08-05 23:11:53',NULL),(1468,'Kiam 24CM Cassorol with galss lid',9,'single',30,NULL,39,154,NULL,'exclusive',0,0,1,1,'1468','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 14:48:43','2021-08-06 14:48:43',NULL),(1469,'Kenedi 12\" Charger Fan',9,'single',30,NULL,39,169,NULL,'exclusive',0,0,1,1,'1469','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 14:55:05','2021-08-06 14:55:05',NULL),(1470,'Noha Stand Charger Fan 2938',9,'single',30,NULL,39,169,NULL,'exclusive',0,0,1,1,'1470','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 14:56:32','2021-08-06 14:56:32',NULL),(1471,'Spot Light',9,'single',30,NULL,39,149,NULL,'exclusive',0,0,1,1,'1471','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:00:38','2021-08-06 15:00:38',NULL),(1472,'Flood Light 10w',9,'single',30,NULL,39,149,NULL,'exclusive',0,0,1,0,'1472','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:01:02','2021-08-06 15:01:02',NULL),(1473,'Sp Led ACDC 10w',9,'single',30,NULL,39,149,NULL,'exclusive',0,0,1,1,'1473','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:05:54','2021-08-06 15:05:54',NULL),(1474,'SP Led 20w',9,'single',30,NULL,39,149,NULL,'exclusive',0,0,1,1,'led20w','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:08:08','2021-08-06 15:08:08',NULL),(1475,'Super Star 26w',9,'single',30,NULL,39,149,NULL,'exclusive',0,0,1,1,'1475','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:09:45','2021-08-06 15:09:45',NULL),(1476,'Samsung 1250 Va Stablazar',9,'single',30,NULL,39,143,NULL,'exclusive',0,0,1,1,'1476','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:44:05','2021-08-06 15:44:05',NULL),(1477,'Khaitan 18\" Table Fan half stand',9,'single',30,NULL,39,165,NULL,'exclusive',0,0,1,1,'1477','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:51:55','2021-08-06 15:51:55',NULL),(1478,'Air Denesty TAble fan',9,'single',30,NULL,39,165,NULL,'exclusive',0,0,1,1,'1478','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:54:39','2021-08-06 15:54:39',NULL),(1479,'Khaitan Table FAn',9,'single',30,NULL,39,165,NULL,'exclusive',0,0,1,0,'1479','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:55:54','2021-08-06 15:55:54',NULL),(1480,'Super Star 12\" dc table fan',9,'single',30,NULL,39,166,NULL,'exclusive',0,0,1,0,'1480','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 15:59:50','2021-08-06 15:59:50',NULL),(1481,'Joyakli Table Light',9,'single',30,NULL,39,174,NULL,'exclusive',0,0,1,0,'1481','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:04:01','2021-08-06 16:04:01',NULL),(1482,'Joy Kali 7925 big',9,'single',30,NULL,39,174,NULL,'exclusive',0,0,1,0,'1482','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:05:08','2021-08-06 16:05:08',NULL),(1483,'Table Light 7634',9,'single',30,NULL,39,174,NULL,'exclusive',0,0,1,1,'1483','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:06:30','2021-08-06 16:06:30',NULL),(1484,'Table Light  KS840',9,'single',30,NULL,39,174,NULL,'exclusive',0,0,1,0,'1484','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:09:35','2021-08-06 16:09:35',NULL),(1485,'Sp 1Gang Switch Lotus',9,'single',30,NULL,39,190,NULL,'exclusive',0,0,1,0,'1485','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:14:39','2021-08-06 16:14:39',NULL),(1486,'Super Star 1Gang Switch Rose',9,'single',30,NULL,39,190,NULL,'exclusive',0,0,1,0,'1486','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:20:04','2021-08-06 16:20:04',NULL),(1487,'Touch Light 8605',9,'single',30,NULL,39,175,NULL,'exclusive',0,0,1,0,'1487','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:26:15','2021-08-06 16:26:15',NULL),(1488,'Touch Light',9,'single',30,NULL,39,175,NULL,'exclusive',0,0,1,0,'1488','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:29:09','2021-08-06 16:29:09',NULL),(1489,'Touch 8695',9,'single',30,NULL,39,175,NULL,'exclusive',0,0,1,0,'1489','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:30:12','2021-08-06 16:30:12',NULL),(1490,'Touch Light AB 8629',9,'single',30,NULL,39,175,NULL,'exclusive',0,0,1,0,'1490','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:31:48','2021-08-06 16:31:48',NULL),(1491,'Malti Plag ML205',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1491','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:34:43','2021-08-06 16:34:43',NULL),(1492,'Maxline Malti plag',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,1,'1492','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:35:50','2021-08-06 16:35:50',NULL),(1493,'Malti Plag Max l 2034',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,1,'1493','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:37:43','2021-08-06 16:37:43',NULL),(1494,'Max L Malti Plag ML605',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1494','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:39:21','2021-08-06 16:39:21',NULL),(1495,'Malti Plag FN Power',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1495','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:40:28','2021-08-06 16:40:28',NULL),(1496,'Malti Plag 2013',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1496','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:43:34','2021-08-06 16:43:34',NULL),(1497,'Malti Plag 024',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1497','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:44:27','2021-08-06 16:44:27',NULL),(1498,'Malti Plag 025',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,1,'1498','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:45:33','2021-08-06 16:45:33',NULL),(1499,'Malti Plag 2040',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1499','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:46:41','2021-08-06 16:46:41',NULL),(1500,'Malti Plag 0034',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1500','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:47:52','2021-08-06 16:47:52',NULL),(1501,'Malti plag 0084',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1501','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:49:26','2021-08-06 16:49:26',NULL),(1502,'Malti Plag 0455',9,'single',30,NULL,39,177,NULL,'exclusive',0,0,1,0,'1502','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 16:50:56','2021-08-06 16:50:56',NULL),(1503,'Ortek Combain Switch',9,'single',30,NULL,39,144,NULL,'exclusive',0,0,1,1,'1503','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 19:49:30','2021-08-06 19:49:30',NULL),(1504,'Cona Combain Switch',9,'single',30,NULL,39,144,NULL,'exclusive',0,0,1,0,'1504','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 19:50:37','2021-08-06 19:50:37',NULL),(1505,'Opal Ac Socket',9,'single',30,NULL,39,144,NULL,'exclusive',0,0,1,1,'1505','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 19:51:07','2021-08-06 19:51:07',NULL),(1506,'Normal Dc Charge Controlar',9,'single',30,NULL,39,186,NULL,'exclusive',0,0,1,1,'1506','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 20:16:09','2021-08-06 20:16:09',NULL),(1507,'Sub Mitter',9,'single',30,NULL,39,196,NULL,'exclusive',0,0,1,1,'1507','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 20:17:20','2021-08-06 20:17:20',NULL),(1508,'Panir filter Siramic',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1508','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 20:19:14','2021-08-06 20:19:14',NULL),(1509,'MEP Siramic Socket',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1509','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 20:48:01','2021-08-06 20:48:01',NULL),(1510,'Mep Piano Fiuz',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1510','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 21:50:24','2021-08-06 21:50:24',NULL),(1511,'Mep Piano Socket',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1511','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 21:51:46','2021-08-06 21:51:46',NULL),(1512,'Lion Travel Adapter',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1512','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 21:53:22','2021-08-06 21:53:22',NULL),(1513,'Mep Adapter Holder',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1513','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 21:56:31','2021-08-06 21:56:31',NULL),(1514,'Mep Malti Socket',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1514','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 21:58:19','2021-08-06 21:58:19',NULL),(1515,'63AM Sarkit Brekar',9,'single',30,NULL,39,183,NULL,'exclusive',0,0,1,1,'1515','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 21:59:52','2021-08-06 21:59:52',NULL),(1516,'Pech PIn Jhulonto Holder',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1516','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:01:55','2021-08-06 22:01:55',NULL),(1517,'KItkat Fiuz',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1517','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:04:44','2021-08-06 22:04:44',NULL),(1518,'One Plus Hexogen Holder',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1518','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:06:25','2021-08-06 22:06:25',NULL),(1519,'Cona Switch',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1519','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:09:48','2021-08-06 22:09:48',NULL),(1520,'Cona Socket',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1520','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:13:15','2021-08-06 22:13:15',NULL),(1521,'Cona Fiuz',9,'single',30,NULL,39,NULL,NULL,'exclusive',0,0,1,1,'1521','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:13:43','2021-08-06 22:13:43',NULL),(1522,'Cona Celing Rose',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1522','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:14:30','2021-08-06 22:14:30',NULL),(1523,'8Hol Boat',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1523','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:18:42','2021-08-06 22:18:42',NULL),(1524,'Mep 3Hol Boat',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1524','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-06 22:20:29','2021-08-06 22:20:29',NULL),(1525,'BRB Internet Fiber Cable Cat6',9,'single',30,NULL,39,193,NULL,'exclusive',0,0,1,0,'1525','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-07 14:05:52','2021-08-07 14:05:52',NULL),(1526,'MSI-DIAMOND-24C',9,'single',30,NULL,35,104,NULL,'exclusive',0,0,1,0,'1526','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-07 14:47:38','2021-08-07 14:47:38',NULL),(1527,'MSI-RIVERINE-18C SMART 1.5TON',9,'single',30,NULL,35,104,NULL,'exclusive',0,0,1,0,'1527','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-07 14:49:53','2021-08-07 14:49:53',NULL),(1528,'1 Gang Steel Tola',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1528','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:23:05','2021-08-14 14:23:05',NULL),(1529,'6/8 Steel Boat',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,1,'1529','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:24:37','2021-08-14 14:24:37',NULL),(1530,'WFB 2A8 GDEL',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1530','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:30:23','2021-08-14 14:30:23',NULL),(1531,'WSI REVERINE 18C',9,'single',30,NULL,36,92,NULL,'exclusive',0,0,1,0,'1531','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:31:40','2021-08-14 14:31:40',NULL),(1532,'M24D29',9,'single',30,NULL,35,40,NULL,'exclusive',0,0,1,0,'1532','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:45:16','2021-08-14 14:45:16',NULL),(1533,'MBL 15SMG6',9,'single',30,NULL,35,97,NULL,'exclusive',0,0,1,0,'1533','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:46:28','2021-08-14 14:46:28',NULL),(1534,'Marcel Washing Machine MWM AFE80H',9,'single',30,NULL,35,112,NULL,'exclusive',0,0,1,0,'1534','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:49:21','2021-08-14 14:49:21',NULL),(1535,'Marcel Washing Machine MWM Q60',9,'single',30,NULL,35,112,NULL,'exclusive',0,0,1,0,'1535','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:51:00','2021-08-14 14:51:00',NULL),(1536,'Marcel Washing Machine MWM TSM80',9,'single',30,NULL,35,112,NULL,'exclusive',0,0,1,0,'1536','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:52:08','2021-08-14 14:52:08',NULL),(1537,'Marcel Washing Machine MWM TWP85S',9,'single',30,NULL,35,112,NULL,'exclusive',0,0,1,0,'1537','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:53:19','2021-08-14 14:53:19',NULL),(1538,'MARCEL MICROWAVE OVEN MMWO-M20ESK',9,'single',30,NULL,35,101,NULL,'exclusive',0,0,1,0,'1538','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:57:44','2021-08-14 14:57:44',NULL),(1539,'MARCEL MICROWAVE OVEN MMWO-M25ESK',9,'single',30,NULL,35,101,NULL,'exclusive',0,0,1,0,'1539','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 14:58:14','2021-08-14 14:58:14',NULL),(1540,'Walton Jali fan 18a',9,'single',30,NULL,36,88,NULL,'exclusive',0,0,1,0,'1540','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-14 15:46:07','2021-08-14 15:46:07',NULL),(1541,'WFE 3E8 GDENX',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1541','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-17 22:55:45','2021-08-17 22:55:45',NULL),(1542,'Kiam 5 Pice Gift Box',9,'single',30,NULL,39,154,NULL,'exclusive',0,0,1,0,'1542','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-18 13:15:34','2021-08-18 13:15:34',NULL),(1543,'Kiam Blender D3',9,'single',30,NULL,39,146,NULL,'exclusive',0,0,1,0,'1543','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-18 13:16:07','2021-08-18 13:16:07',NULL),(1544,'KIam Electrick Kettle M109',9,'single',30,NULL,39,147,NULL,'exclusive',0,0,1,0,'1544','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-18 13:16:35','2021-08-18 13:16:35',NULL),(1545,'KIam Electrick Kettle M46 1.8',9,'single',30,NULL,39,147,NULL,'exclusive',0,0,1,0,'1545','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-18 13:16:58','2021-08-18 13:16:58',NULL),(1546,'Miyako jhik low',9,'single',30,NULL,38,134,NULL,'exclusive',0,0,1,0,'1546','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-20 15:41:48','2021-08-20 15:41:48',NULL),(1547,'19\" Chiana Led tv',9,'single',30,NULL,39,141,NULL,'exclusive',0,0,1,0,'1547','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-20 15:46:31','2021-08-20 15:46:31',NULL),(1548,'WFE 3B0 GDEL INVERTER',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1548','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-25 16:09:43','2021-08-25 16:09:43',NULL),(1549,'WFD 1F3 GDEL',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1549','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-25 16:10:40','2021-08-25 16:10:40',NULL),(1550,'WFE 2N5 GDENX INV',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1550','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-28 14:51:44','2021-08-28 14:51:44',NULL),(1551,'Calculetor CT933N',9,'single',30,NULL,39,178,NULL,'exclusive',0,0,1,0,'1551','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-29 15:20:28','2021-08-29 15:20:28',NULL),(1552,'Calculetor GT69',9,'single',30,NULL,39,178,NULL,'exclusive',0,0,1,0,'1552','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-29 15:20:49','2021-08-29 15:20:49',NULL),(1553,'Calculetor SDC3822',9,'single',30,NULL,39,178,NULL,'exclusive',0,0,1,0,'1553','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-29 15:21:11','2021-08-29 15:21:11',NULL),(1554,'Touch Light 7085',9,'single',30,NULL,39,175,NULL,'exclusive',0,0,1,0,'1554','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-31 20:47:50','2021-08-31 20:47:50',NULL),(1555,'Touch Light 7083',9,'single',30,NULL,39,175,NULL,'exclusive',0,0,1,0,'1555','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-08-31 20:48:20','2021-08-31 20:48:20',NULL),(1556,'WMWO M28EGN',9,'single',30,NULL,36,52,NULL,'exclusive',0,0,1,0,'1556','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-01 18:50:48','2021-09-01 18:50:48',NULL),(1557,'WMWO-M30AHY',9,'single',30,NULL,36,52,NULL,'exclusive',0,0,1,0,'1557','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-01 18:51:10','2021-09-01 18:51:10',NULL),(1558,'WBL15G35',9,'single',30,NULL,36,48,NULL,'exclusive',0,0,1,0,'1558','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-09 14:25:50','2021-09-09 14:25:50',NULL),(1559,'RFL GYSER 30LTR GLOSSY',9,'single',30,NULL,NULL,NULL,NULL,'exclusive',0,0,1,0,'1559','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-09 14:37:14','2021-09-09 14:37:14',NULL),(1560,'RFL GYSER 45LTR GLOSSY',9,'single',30,NULL,39,191,NULL,'exclusive',0,0,1,0,'1560','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-09 14:37:43','2021-09-09 14:37:43',NULL),(1561,'RFL GYSER 67LTR GLOSSY NEW',9,'single',30,NULL,39,191,NULL,'exclusive',0,0,1,0,'1561','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-09 14:38:10','2021-09-09 14:38:10',NULL),(1562,'MEGA DIGITAL PALLA 300KG',9,'single',30,NULL,39,151,NULL,'exclusive',0,0,1,0,'1562','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-10 14:10:23','2021-09-10 14:10:23',NULL),(1563,'Mitar Boat gry',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1563','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-10 14:11:45','2021-09-10 14:11:45',NULL),(1564,'WGS GDC11 DOUBLE STOVE',9,'single',30,NULL,36,62,NULL,'exclusive',0,0,1,0,'1564','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-12 14:45:47','2021-09-12 14:45:47',NULL),(1565,'WFE 3F5 GDXX INVERTER',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1565','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-14 14:50:33','2021-09-14 14:50:33',NULL),(1566,'WEF32V 32\" SMART LED TV',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1566','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-14 14:52:52','2021-09-14 14:52:52',NULL),(1567,'Pressour Cooker Safety Bulb',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1567','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-14 15:35:27','2021-09-14 15:35:27',NULL),(1568,'company comsion',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1568','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-15 14:25:49','2021-09-15 14:25:49',NULL),(1569,'Super Led Dim Light',9,'single',30,NULL,39,182,NULL,'exclusive',0,0,1,0,'1569','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-17 14:12:46','2021-09-17 14:12:46',NULL),(1570,'WFE 3B0 GDEN-XX INVERTER',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1570','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-18 13:54:26','2021-09-18 13:54:26',NULL),(1571,'MEGA DIGITAL PALLA 15KG',9,'single',30,NULL,39,151,NULL,'exclusive',0,0,1,0,'1571','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-21 15:26:23','2021-09-21 15:26:23',NULL),(1572,'Led Tv Remot Cover',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1572','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-21 15:44:29','2021-09-21 15:44:29',NULL),(1573,'WFE 2N5 GDXX INV',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1573','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-22 14:12:30','2021-09-22 14:12:30',NULL),(1574,'Kartun Kostip',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1574','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-22 14:12:55','2021-09-22 14:12:55',NULL),(1575,'Blender Rubber Bush',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1575','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-22 14:23:42','2021-09-22 14:23:42',NULL),(1576,'WBL 15GM55',9,'single',30,NULL,36,48,NULL,'exclusive',0,0,1,0,'1576','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-27 21:52:13','2021-09-27 21:52:13',NULL),(1577,'WBL 15SMG6',9,'single',30,NULL,36,48,NULL,'exclusive',0,0,1,0,'1577','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-27 21:53:09','2021-09-27 21:53:09',NULL),(1578,'WGS GSC20 SINGLE STOVE',9,'single',30,NULL,36,61,NULL,'exclusive',0,0,1,0,'1578','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-27 21:54:07','2021-09-27 21:54:07',NULL),(1579,'W24D29',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1579','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-27 21:55:24','2021-09-27 21:55:24',NULL),(1580,'Excel Smart 2200E',9,'single',30,NULL,36,211,NULL,'exclusive',0,0,1,0,'1580','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-28 17:16:55','2021-09-28 17:16:55',NULL),(1581,'WFB 2X1 GDEL',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1581','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-09-30 21:09:35','2021-09-30 21:09:35',NULL),(1582,'SYMPHONY  B69',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1582','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:02:58','2021-10-06 14:02:58',NULL),(1583,'SYMPHONY  BL99',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1583','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:03:22','2021-10-06 14:03:22',NULL),(1584,'SYMPHONY D48',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1584','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:03:46','2021-10-06 14:03:46',NULL),(1585,'SYMPHONY D76',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1585','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:04:37','2021-10-06 14:04:37',NULL),(1586,'SYMPHONY D78',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1586','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:04:57','2021-10-06 14:04:57',NULL),(1587,'SYMPHONY L43',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1587','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:05:18','2021-10-12 17:34:41',NULL),(1588,'SYMPHONY S45',9,'single',30,NULL,37,212,NULL,'exclusive',0,0,1,0,'1588','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 14:14:20','2021-10-06 14:14:20',NULL),(1589,'MWM TWG90P',9,'single',30,NULL,35,112,NULL,'exclusive',0,0,1,0,'1589','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 20:24:00','2021-10-06 20:24:00',NULL),(1590,'MGS GDB20',9,'single',30,NULL,35,107,NULL,'exclusive',0,0,1,0,'1590','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 20:27:41','2021-10-06 20:27:41',NULL),(1591,'MGS GDC90',9,'single',30,NULL,35,107,NULL,'exclusive',0,0,1,0,'1591','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-06 20:28:14','2021-10-06 20:28:14',NULL),(1592,'Sony 17\" Chaina Led tv',9,'single',30,NULL,39,141,NULL,'exclusive',0,0,1,0,'1592','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-08 16:31:29','2021-10-08 16:31:29',NULL),(1593,'Miyako Choto Tupi',9,'single',30,NULL,38,132,NULL,'exclusive',0,0,1,0,'1593','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-10 13:39:32','2021-10-10 13:39:32',NULL),(1594,'Mep 10/8 Hol Boat',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1594','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-10 13:39:51','2021-10-10 13:39:51',NULL),(1595,'2/1 Pipe',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1595','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-10 13:53:48','2021-10-10 13:53:48',NULL),(1596,'2/1 te albo socket',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1596','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-10 13:54:17','2021-10-10 13:54:17',NULL),(1597,'WFB 1G7 GDSH',9,'single',30,NULL,36,41,NULL,'exclusive',0,0,1,0,'1597','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-12 13:37:05','2021-10-12 13:37:05',NULL),(1598,'WSN BEVELYN 1.5 TON',9,'single',30,NULL,36,92,NULL,'exclusive',0,0,1,0,'1598','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-12 13:41:30','2021-10-12 13:41:30',NULL),(1599,'WSN DIAMOND 1.5 TON',9,'single',30,NULL,36,92,NULL,'exclusive',0,0,1,0,'1599','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-12 13:41:59','2021-10-12 13:41:59',NULL),(1600,'WSN RIVERINE 18A 1.5 TON',9,'single',30,NULL,36,92,NULL,'exclusive',0,0,1,0,'1600','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-12 13:47:00','2021-10-12 13:47:00',NULL),(1601,'Super Star Charge Controlar Prmium',9,'single',30,NULL,39,186,NULL,'exclusive',0,0,1,0,'1601','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-13 14:42:41','2021-10-13 14:42:41',NULL),(1602,'Walton Speaker Chorus',9,'single',30,NULL,36,219,NULL,'exclusive',0,0,1,0,'1602','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-13 15:32:09','2021-10-13 15:32:09',NULL),(1603,'Walton ac Socket',9,'single',30,NULL,36,46,NULL,'exclusive',0,0,1,0,'1603','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 14:04:41','2021-10-14 14:04:41',NULL),(1604,'Royal Bol',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1604','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 14:05:04','2021-10-14 14:05:04',NULL),(1605,'Walton Keyboard WKS007WB',9,'single',30,NULL,36,83,NULL,'exclusive',0,0,1,0,'1605','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:37:18','2021-10-14 22:37:18',NULL),(1606,'WALTON MEMORY WSD0320A (32GB)',9,'single',30,NULL,36,85,NULL,'exclusive',0,0,1,0,'1606','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:37:54','2021-10-14 22:37:54',NULL),(1607,'WALTON MOUSE WMS025WN',9,'single',30,NULL,36,82,NULL,'exclusive',0,0,1,0,'1607','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:38:39','2021-10-14 22:38:39',NULL),(1608,'WALTON PEN DRIVE WU3032P040 (32GB)',9,'single',30,NULL,36,85,NULL,'exclusive',0,0,1,0,'1608','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:39:26','2021-10-14 22:39:26',NULL),(1609,'WALTON PEN DRIVE WU3032P050 (32GB)',9,'single',30,NULL,36,85,NULL,'exclusive',0,0,1,0,'1609','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:39:54','2021-10-14 22:39:54',NULL),(1610,'WALTON PEN DRIVE WU3064P040 (64GB)',9,'single',30,NULL,36,85,NULL,'exclusive',0,0,1,0,'1610','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:40:41','2021-10-14 22:40:41',NULL),(1611,'WALTON MOUSE WMS016RL',9,'single',30,NULL,36,82,NULL,'exclusive',0,0,1,0,'1611','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-14 22:41:10','2021-10-14 22:41:10',NULL),(1612,'WK-PGL20',9,'single',30,NULL,36,49,NULL,'exclusive',0,0,1,0,'1612','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-15 16:14:27','2021-10-15 16:14:27',NULL),(1613,'WALTON HAIR CLIPER HP01',9,'single',30,NULL,36,220,NULL,'exclusive',0,0,1,0,'1613','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-15 16:18:37','2021-10-15 16:18:37',NULL),(1614,'Walton Trimmer HP03',9,'single',30,NULL,36,220,NULL,'exclusive',0,0,1,0,'1614','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-15 22:43:37','2021-10-15 22:43:37',NULL),(1615,'WD24HLR',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1615','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-15 22:44:37','2021-10-15 22:44:37',NULL),(1616,'WD24HLR21',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1616','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-15 22:45:16','2021-10-15 22:45:16',NULL),(1617,'WD24R',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1617','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-15 23:01:30','2021-10-15 23:01:30',NULL),(1618,'Angel jack',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1618','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-17 14:15:18','2021-10-17 14:15:18',NULL),(1619,'Lad Pipe',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1619','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-17 14:15:45','2021-10-17 14:15:45',NULL),(1620,'W32D120G',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1620','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-18 17:17:36','2021-10-18 17:17:36',NULL),(1621,'W43D210G GOOGLE FHD',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1621','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-18 17:18:43','2021-10-18 17:18:43',NULL),(1622,'WD43RS LED TV',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1622','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-18 17:19:37','2021-10-18 17:19:37',NULL),(1623,'WE4-MX43-SB100',9,'single',30,NULL,36,42,NULL,'exclusive',0,0,1,0,'1623','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-18 17:20:31','2021-10-18 17:20:31',NULL),(1624,'Super Ariston Gyser 30Ltr',9,'single',30,NULL,39,191,NULL,'exclusive',0,0,1,0,'1624','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-20 19:12:26','2021-10-20 19:12:26',NULL),(1625,'Ac Angel',9,'single',30,NULL,39,192,NULL,'exclusive',0,0,1,0,'1625','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-20 19:13:07','2021-10-20 19:13:07',NULL),(1626,'Walton Tube light DTDL36 W',9,'single',30,NULL,36,72,NULL,'exclusive',0,0,1,0,'1626','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-21 14:28:04','2021-10-21 14:28:04',NULL),(1627,'MFB B2C GDXX',9,'single',30,NULL,35,91,NULL,'exclusive',0,0,1,0,'1627','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-21 14:31:50','2021-10-21 14:31:50',NULL),(1628,'MFD A6C GDEH',9,'single',30,NULL,35,91,NULL,'exclusive',0,0,1,0,'1628','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-21 14:32:30','2021-10-21 14:32:30',NULL),(1629,'MFE B9E GDENX INV',9,'single',30,NULL,35,91,NULL,'exclusive',0,0,1,0,'1629','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-21 14:33:07','2021-10-21 14:33:07',NULL),(1630,'MSI OCEANUS (VOICE CONTROL)18F',9,'single',30,NULL,35,104,NULL,'exclusive',0,0,1,0,'1630','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-21 14:35:14','2021-10-21 14:35:14',NULL),(1631,'MSI OCEANUS (VOICE CONTROL)24C',9,'single',30,NULL,35,104,NULL,'exclusive',0,0,1,0,'1631','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-21 14:35:36','2021-10-21 14:35:36',NULL),(1632,'Kiam Pressur Cooker 12.5 Classic',9,'single',30,NULL,39,153,NULL,'exclusive',0,0,1,0,'1632','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-22 14:46:01','2021-10-22 14:46:02',NULL),(1633,'Purite Clasic 23ltr Panir filter',9,'single',30,NULL,39,152,NULL,'exclusive',0,0,1,0,'1633','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-22 15:10:28','2021-10-22 15:10:28',NULL),(1634,'WK LJSS170',9,'single',30,NULL,36,49,NULL,'exclusive',0,0,1,0,'1634','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 15:41:54','2021-10-23 15:41:54',NULL),(1635,'WK LJSS150',9,'single',30,NULL,36,49,NULL,'exclusive',0,0,1,0,'1635','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 15:42:30','2021-10-23 15:42:30',NULL),(1636,'Walton Digital Scal 100KG',9,'single',30,NULL,36,55,NULL,'exclusive',0,0,1,0,'1636','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 15:42:53','2021-10-23 15:42:53',NULL),(1637,'Walton Digital Scal 60KG',9,'single',30,NULL,36,55,NULL,'exclusive',0,0,1,0,'1637','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 15:43:11','2021-10-23 15:43:11',NULL),(1638,'WWH WH35LTR GYSER',9,'single',30,NULL,36,87,NULL,'exclusive',0,0,1,0,'1638','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 19:30:26','2021-10-23 19:30:26',NULL),(1639,'WIR HD02',9,'single',30,NULL,36,50,NULL,'exclusive',0,0,1,0,'1639','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 19:30:49','2021-10-23 19:30:49',NULL),(1640,'WWM AFE80H',9,'single',30,NULL,36,66,NULL,'exclusive',0,0,1,0,'1640','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 19:48:27','2021-10-23 19:48:27',NULL),(1641,'WWM AFM90',9,'single',30,NULL,36,66,NULL,'exclusive',0,0,1,0,'1641','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 19:48:50','2021-10-23 19:48:50',NULL),(1642,'WVS 100SDR80V',9,'single',30,NULL,36,44,NULL,'exclusive',0,0,1,0,'1642','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-23 19:55:38','2021-10-23 19:55:38',NULL),(1643,'Miyako Auto Double Chula Lal',9,'single',30,NULL,38,124,NULL,'exclusive',0,0,1,0,'1643','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-24 13:43:29','2021-10-24 13:43:29',NULL),(1644,'Walton Mobile Olivo ML20',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,0,'1644','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-24 15:20:48','2021-10-24 15:20:48',NULL),(1645,'Walton Mobile Olivo L50',9,'single',30,NULL,36,78,NULL,'exclusive',0,0,1,0,'1645','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-24 15:23:43','2021-10-24 15:23:43',NULL),(1646,'Rfl Pressur Gas Reguletor',9,'single',30,NULL,38,128,NULL,'exclusive',0,0,1,0,'1646','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-10-25 19:42:10','2021-10-25 19:42:10',NULL),(1648,'FOB',9,'single',34,NULL,NULL,NULL,NULL,'inclusive',0,0,1,100,'1648','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-11-20 16:08:09','2021-11-20 16:08:09',NULL),(1649,'FOB',9,'single',33,NULL,37,NULL,NULL,'exclusive',0,0,1,50,'1649','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-11-20 20:53:48','2021-11-20 20:53:48',NULL),(1650,'ADA',9,'single',33,NULL,NULL,NULL,NULL,'exclusive',0,0,1,200,'1650','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-11-20 21:42:24','2021-11-20 21:42:24',NULL),(1651,'abcd',9,'single',30,NULL,NULL,NULL,NULL,'exclusive',0,0,1,3,'abcd','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-11-23 16:25:19','2021-11-23 16:25:19',NULL),(1652,'abcde',9,'single',30,NULL,NULL,NULL,NULL,'exclusive',0,0,1,3,'abcde','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-11-23 16:25:48','2021-11-23 16:25:48',NULL),(1653,'Burka',9,'single',30,1,221,NULL,NULL,'exclusive',0,0,0,0,'1653','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-12-04 16:29:39','2021-12-04 16:29:39',NULL),(1654,'Dubai',9,'single',34,NULL,NULL,NULL,NULL,'exclusive',0,0,0,0,'dubai','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-12-11 10:06:51','2021-12-11 10:06:51',NULL),(1655,'Dubai Visa',9,'single',30,NULL,222,NULL,NULL,'exclusive',0,0,0,0,'1655','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-12-14 09:08:46','2021-12-14 09:08:46',NULL),(1656,'saudi',9,'single',30,NULL,222,NULL,NULL,'exclusive',0,0,0,0,'1656','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-12-14 09:17:05','2021-12-14 09:17:05',NULL),(1657,'Dubai',9,'single',30,NULL,223,NULL,NULL,'exclusive',0,0,0,0,'1657','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2021-12-14 09:29:48','2021-12-14 09:29:48',NULL),(1658,'Almond',9,'single',36,NULL,224,NULL,NULL,'inclusive',0,0,1,5,'1658','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-01-11 08:22:03','2022-01-11 08:22:03',NULL),(1659,'T-shirts',9,'single',30,NULL,35,NULL,NULL,'exclusive',0,0,1,50,'1659','C128',12.00,'months',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-01-13 15:44:46','2022-01-13 15:44:46',NULL),(1660,'A Data Pendrive 16GB',9,'single',30,NULL,216,NULL,NULL,'exclusive',0,0,1,10,'DATA','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-01-14 08:00:39','2022-01-14 08:00:39',NULL),(1661,'T-SHIRT',9,'variable',30,NULL,225,NULL,NULL,'exclusive',0,0,1,10,'1661','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-01-14 14:18:17','2022-01-14 14:18:17',NULL),(1662,'CHAITY TOPS',9,'single',30,2,227,NULL,NULL,'exclusive',0,0,1,5,'1662','C39',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-01-15 17:57:55','2022-01-15 17:57:55',NULL),(1666,'Men\'s Panjabi',9,'variable',30,NULL,228,NULL,NULL,'exclusive',0,0,1,0,'10144','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-12 05:23:32','2022-02-12 05:23:32',NULL),(1667,'Men\'s Panjabi',9,'variable',30,NULL,228,NULL,NULL,'exclusive',0,0,1,0,'101159','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-12 05:43:39','2022-02-12 05:43:39',NULL),(1668,'Panjabi',9,'variable',30,NULL,228,NULL,NULL,'exclusive',0,0,1,0,'10159','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-12 05:46:22','2022-02-12 05:46:22',NULL),(1669,'ROHU(W) রুই',9,'single',35,2,39,NULL,NULL,'exclusive',0,0,1,200,'1669','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-20 01:38:59','2022-02-20 01:38:59',NULL),(1670,'Rohu(Cl) রুই',9,'single',35,2,39,NULL,NULL,'exclusive',0,0,1,200,'1670','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-20 01:52:29','2022-02-20 01:52:29',NULL),(1671,'Service',9,'single',35,NULL,NULL,NULL,NULL,'exclusive',0,0,0,0,'service21','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-20 08:23:06','2022-02-20 08:23:06',NULL),(1673,'abu',9,'variable',30,NULL,NULL,NULL,NULL,'inclusive',0,0,0,0,'','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-02-20 10:37:27','2022-02-20 10:37:27',NULL),(1674,'PLUG RX 100',9,'single',30,3,229,NULL,NULL,'exclusive',0,0,1,10,'1674','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-21 00:10:02','2022-02-21 00:10:02',NULL),(1675,'TYER YAMAHA',9,'single',30,4,231,NULL,NULL,'exclusive',0,0,1,3,'1675','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-21 00:11:26','2022-02-21 00:11:26',NULL),(1676,'BREAKSHOO',9,'single',30,4,232,NULL,NULL,'exclusive',0,0,1,5,'1676','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-21 00:19:15','2022-02-21 00:19:15',NULL),(1677,'Bata',9,'variable',30,6,NULL,NULL,NULL,'inclusive',0,0,1,2,'14300','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-02-22 05:04:58','2022-02-22 05:04:58',NULL),(1678,'Tshirt',9,'single',30,NULL,NULL,NULL,NULL,'inclusive',0,0,1,2,'45600','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-02-22 05:04:58','2022-02-22 05:04:58',NULL),(1679,'Main Board',1,'single',22,NULL,NULL,NULL,NULL,'exclusive',0,0,1,0,'123398765','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,'2022-02-22 06:35:30','2022-02-22 06:36:44',NULL),(1680,'Miniket25',9,'single',37,7,NULL,NULL,NULL,'exclusive',0,0,1,20,'badsaminiket25','C128',12.00,'months',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-23 05:39:23','2022-02-23 05:39:23',NULL),(1681,'Pusti Atas',9,'single',37,8,240,NULL,NULL,'exclusive',0,0,1,20,'1681','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-24 04:06:20','2022-02-24 04:06:20',NULL),(1682,'Minikit',9,'single',36,7,233,NULL,NULL,'exclusive',0,0,1,20,'1682','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-24 04:08:08','2022-02-24 04:08:08',NULL),(1683,'Zirashail',9,'single',36,8,233,NULL,NULL,'exclusive',0,0,1,20,'1683','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-24 04:22:29','2022-02-24 04:22:29',NULL),(1684,'Badsa Nazir',9,'single',37,7,235,NULL,NULL,'exclusive',0,0,1,20,'1684','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-24 04:24:36','2022-02-24 04:24:36',NULL),(1685,'Sugondi Katari Vog',9,'single',37,7,NULL,NULL,NULL,'exclusive',0,0,1,20,'1685','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-24 04:25:29','2022-02-24 04:25:29',NULL),(1686,'Basmati',9,'single',37,9,238,NULL,NULL,'exclusive',0,0,1,20,'1686','C128',12.00,'months',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-02-24 04:50:40','2022-02-24 04:50:40',NULL),(1687,'pakija print',9,'single',30,10,236,NULL,NULL,'exclusive',0,0,1,2,'pakija1','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-03-31 03:10:24','2022-03-31 03:10:24',NULL),(1688,'test 1',9,'single',34,3,221,NULL,NULL,'exclusive',0,0,1,1,'1688','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1649745141_download.jpg',NULL,36,NULL,'2022-04-12 04:32:21','2022-04-12 04:32:21',NULL),(1689,'test 2',9,'single',34,3,39,NULL,NULL,'exclusive',0,0,1,1,'1689','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1649745489_download.jpg',NULL,36,NULL,'2022-04-12 04:38:09','2022-04-12 04:38:09',NULL),(1690,'Led bulb',9,'single',30,11,222,NULL,NULL,'exclusive',0,0,1,1,'1690','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1649746345_download.jpg',NULL,36,NULL,'2022-04-12 04:52:25','2022-04-12 04:52:25',NULL),(1691,'fress water',9,'single',34,12,241,NULL,NULL,'exclusive',0,0,1,1,'1691','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1649840298_18.jpg',NULL,36,NULL,'2022-04-13 06:58:18','2022-04-13 06:58:18',NULL),(1692,'Product 1',9,'single',35,3,222,NULL,NULL,'exclusive',0,0,1,1,'1692','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1650438661_20.jpg',NULL,36,NULL,'2022-04-20 05:11:01','2022-04-20 05:11:01',NULL),(1693,'Mens Jeans Pants',9,'single',30,NULL,225,NULL,NULL,'exclusive',0,0,1,10,'1693','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-05-31 12:45:19','2022-05-31 12:45:19',NULL),(1694,'ST. Ives Scrub',9,'single',30,NULL,NULL,NULL,NULL,'exclusive',0,0,1,2,'8710908812576','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-06-06 02:08:25','2022-06-06 02:08:25',NULL),(1695,'গেন্জি চায়না',9,'single',30,13,243,NULL,NULL,'exclusive',0,0,0,0,'1695','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-06-06 14:22:18','2022-06-06 14:22:18',NULL),(1696,'test23',9,'variable',35,6,NULL,NULL,NULL,'exclusive',0,0,1,1,'1696','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-06-19 05:38:12','2022-06-19 05:38:12',NULL),(1697,'hero',9,'single',38,9,222,NULL,NULL,'exclusive',0,0,1,10,'1697','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-06-28 10:40:15','2022-06-28 10:40:15',NULL),(1698,'Twain Game',9,'single',30,17,245,246,NULL,'inclusive',0,0,0,0,'HER-03','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-08-30 10:24:38','2022-08-30 10:24:38',NULL),(1699,'Twain Game1',9,'single',30,17,245,246,NULL,'inclusive',0,0,0,0,'HER-02','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-08-30 10:26:10','2022-08-30 10:26:10',NULL),(1700,'Twain Game1',9,'single',30,17,245,246,NULL,'inclusive',0,0,0,0,'HER-01','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-08-30 10:27:42','2022-08-30 10:27:42',NULL),(1701,'Twain Game1',9,'single',30,18,247,NULL,NULL,'inclusive',0,0,0,0,'','C128',NULL,NULL,0,'','','','','','',NULL,36,NULL,'2022-08-30 10:29:13','2022-08-30 10:29:13',NULL),(1702,'test1',9,'variable',35,NULL,NULL,NULL,NULL,'exclusive',0,0,1,1,'1001','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-10-01 05:37:08','2022-10-01 05:37:08',NULL),(1703,'test',9,'single',35,NULL,NULL,NULL,NULL,'exclusive',0,0,1,5,'1703','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2022-11-21 16:52:59','2022-11-21 16:52:59',NULL),(1704,'bakkar oil',9,'single',35,NULL,NULL,NULL,NULL,'exclusive',0,0,1,1,'1704','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-01-16 05:00:24','2023-01-16 05:00:24',NULL),(1705,'product 3',9,'single',30,19,248,NULL,NULL,'inclusive',0,0,1,2,'1705','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-13 06:15:59','2023-03-13 06:15:59',NULL),(1706,'product 4',9,'single',30,19,248,NULL,NULL,'exclusive',0,0,1,2,'1706','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-13 06:26:36','2023-03-13 06:26:36',NULL),(1707,'New Sales',9,'single',30,2,222,NULL,NULL,'inclusive',0,0,1,5,'1707','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1678716018_IMG_4418.jpg',NULL,36,NULL,'2023-03-13 12:00:18','2023-03-13 12:00:18',NULL),(1708,'test product',9,'single',34,2,227,NULL,NULL,'exclusive',0,0,1,1,'1708','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-14 03:43:11','2023-03-14 03:43:11',NULL),(1709,'COLOR',9,'single',34,3,222,NULL,NULL,'inclusive',0,0,1,1,'1709','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-14 04:07:40','2023-03-14 04:07:40',NULL),(1710,'COLOR',9,'single',30,3,221,NULL,NULL,'exclusive',0,0,1,1,'8907525020112','C39',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-14 05:12:05','2023-03-14 05:12:05',NULL),(1711,'test',9,'single',30,2,221,NULL,NULL,'exclusive',0,0,1,2,'1711','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-14 13:07:05','2023-03-14 13:07:05',NULL),(1712,'ots',9,'single',34,20,249,NULL,NULL,'inclusive',0,0,1,2,'1712','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'1678907114_river.jpg',NULL,36,NULL,'2023-03-15 17:05:14','2023-03-15 17:05:15',NULL),(1713,'ots',9,'single',38,20,249,NULL,NULL,'inclusive',0,0,1,2,'171','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-15 17:36:38','2023-03-15 17:36:38',NULL),(1714,'no 1',9,'single',35,21,NULL,NULL,NULL,'inclusive',0,0,1,1,'1714','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-16 04:02:18','2023-03-16 04:02:18',NULL),(1715,'milk vita',9,'single',30,2,222,NULL,NULL,'inclusive',0,0,1,5,'1715','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-16 05:31:28','2023-03-16 05:31:28',NULL),(1716,'mango juice',9,'single',36,22,249,NULL,NULL,'inclusive',0,0,1,5,'1716','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-23 03:14:25','2023-03-23 03:14:25',NULL),(1717,'cow',9,'single',30,22,249,NULL,NULL,'exclusive',0,0,1,1,'1717','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-23 04:12:21','2023-03-23 04:12:21',NULL),(1718,'jam furites',9,'single',36,23,252,NULL,NULL,'inclusive',0,0,1,5,'1718','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-23 14:38:18','2023-03-23 14:38:18',NULL),(1719,'amla',9,'single',30,24,253,NULL,NULL,'inclusive',0,0,1,2,'1719','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-29 03:10:35','2023-03-29 03:10:35',NULL),(1720,'Ajua',9,'single',36,25,222,NULL,NULL,'inclusive',0,0,1,2,'1720','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-03-30 03:24:04','2023-03-30 03:24:04',NULL),(1721,'test 1',9,'single',30,13,227,NULL,NULL,'exclusive',0,0,1,1,'1721','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-06-01 09:04:18','2023-06-01 09:04:18',NULL),(1722,'holad ball',9,'single',30,13,227,NULL,NULL,'exclusive',0,0,1,1,'1722','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-06-01 09:10:35','2023-06-01 09:10:35',NULL),(1723,'kon bus',9,'single',30,13,227,NULL,NULL,'exclusive',0,0,1,1,'1723','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-06-01 09:28:05','2023-06-01 09:28:05',NULL),(1724,'tea cup',9,'single',40,25,252,NULL,NULL,'exclusive',0,0,1,100,'1724','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-06-22 03:57:05','2023-06-22 03:57:05',NULL),(1725,'Bata',9,'single',30,2,227,NULL,NULL,'exclusive',0,0,1,1,'1725','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-07-18 06:22:24','2023-07-18 06:22:24',NULL),(1726,'new recipe',9,'single',30,3,222,NULL,NULL,'inclusive',0,0,1,7,'1726','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36,NULL,'2023-07-19 03:27:05','2023-07-19 03:27:05',NULL);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(20,4) NOT NULL,
  `pp_without_discount` decimal(20,2) NOT NULL DEFAULT 0.00 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(20,2) DEFAULT NULL,
  `line_discount_type` enum('fixed','percentage') NOT NULL,
  `line_discount_amount` float NOT NULL DEFAULT 0,
  `purchase_price_inc_tax` decimal(20,2) NOT NULL DEFAULT 0.00,
  `item_tax` decimal(20,2) DEFAULT NULL,
  `tax_id` int(10) unsigned DEFAULT NULL,
  `quantity_sold` decimal(20,4) DEFAULT 0.0000,
  `quantity_adjusted` decimal(20,4) DEFAULT 0.0000,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(256) DEFAULT NULL,
  `mrp_price` double NOT NULL,
  `reseller_price` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1346 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES (1,448,1312,1312,11.0000,861.25,0.00,861.25,'fixed',0,861.25,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:43:21','2021-10-07 16:14:50'),(2,448,1349,1349,1.0000,1820.00,0.00,1820.00,'fixed',0,1820.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:43:21','2021-09-01 16:00:20'),(3,449,1283,1283,6.0000,21080.00,0.00,21080.00,'fixed',0,21080.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-10-08 16:08:36'),(4,449,1110,1110,1.0000,12725.00,0.00,12725.00,'fixed',0,12725.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-08-03 14:57:10'),(5,449,1284,1284,5.0000,21585.00,0.00,21585.00,'fixed',0,21585.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-09-29 14:41:34'),(6,449,1053,1053,1.0000,10245.00,0.00,10245.00,'fixed',0,10245.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-09-01 19:24:54'),(7,449,1051,1051,2.0000,9913.60,0.00,9913.60,'fixed',0,9913.60,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-09-21 15:58:54'),(8,449,1052,1052,1.0000,15885.00,0.00,15885.00,'fixed',0,15885.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-08-29 22:26:56'),(9,449,1379,1381,1.0000,33350.00,0.00,33350.00,'fixed',0,33350.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 14:57:10','2021-10-16 21:43:54'),(10,450,1380,1382,1.0000,17200.00,0.00,17200.00,'fixed',0,17200.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-08 20:51:11'),(11,450,1381,1383,1.0000,27580.00,0.00,27580.00,'fixed',0,27580.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(12,450,1382,1384,1.0000,25070.00,0.00,25070.00,'fixed',0,25070.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-01 16:08:21'),(13,450,1383,1385,1.0000,27620.00,0.00,27620.00,'fixed',0,27620.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-30 00:32:15'),(14,450,1119,1119,2.0000,29840.00,0.00,29840.00,'fixed',0,29840.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(15,450,1179,1179,1.0000,33415.00,0.00,33415.00,'fixed',0,33415.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(16,450,1033,1033,1.0000,27865.00,0.00,27865.00,'fixed',0,27865.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-18 14:42:15'),(17,450,1031,1031,1.0000,29590.00,0.00,29590.00,'fixed',0,29590.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-14 21:49:15'),(18,450,1195,1195,1.0000,24885.00,0.00,24885.00,'fixed',0,24885.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-01 17:17:29'),(19,450,1165,1165,1.0000,24060.00,0.00,24060.00,'fixed',0,24060.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(20,450,1115,1115,1.0000,22580.00,0.00,22580.00,'fixed',0,22580.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(21,450,1386,1388,1.0000,17650.00,0.00,17650.00,'fixed',0,17650.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-14 15:01:59'),(22,450,1306,1306,1.0000,20745.00,0.00,20745.00,'fixed',0,20745.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-29 22:59:45'),(23,450,1387,1389,1.0000,58510.00,0.00,58510.00,'fixed',0,58510.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-08 20:56:47'),(24,450,1046,1046,1.0000,21300.00,0.00,21300.00,'fixed',0,21300.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-08 19:51:43'),(25,450,1305,1305,1.0000,23185.00,0.00,23185.00,'fixed',0,23185.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-04 14:53:55'),(26,450,1320,1320,1.0000,23305.00,0.00,23305.00,'fixed',0,23305.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-10-07 16:28:32'),(27,450,1032,1032,1.0000,28281.00,0.00,28281.00,'fixed',0,28281.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-10-03 13:15:16'),(28,450,1388,1390,2.0000,28410.00,0.00,28410.00,'fixed',0,28410.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-04 14:53:55'),(29,450,1323,1323,1.0000,31210.00,0.00,31210.00,'fixed',0,31210.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(30,450,1167,1167,1.0000,26390.00,0.00,26390.00,'fixed',0,26390.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-01 16:55:02'),(31,450,1389,1391,1.0000,26715.00,0.00,26715.00,'fixed',0,26715.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-19 16:11:29'),(32,450,1088,1088,1.0000,26390.00,0.00,26390.00,'fixed',0,26390.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-10-16 21:50:32'),(33,450,1039,1039,1.0000,25395.00,0.00,25395.00,'fixed',0,25395.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-09-01 20:49:44'),(34,450,1210,1210,1.0000,24400.00,0.00,24400.00,'fixed',0,24400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(35,450,1045,1045,1.0000,21750.00,0.00,21750.00,'fixed',0,21750.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 15:39:03','2021-08-03 15:39:03'),(36,451,22,22,5.0000,2850.00,0.00,2850.00,'fixed',0,2850.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:27:22','2021-08-03 17:27:22'),(37,451,1343,1343,6.0000,2890.00,0.00,2890.00,'fixed',0,2890.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:27:22','2021-09-04 14:53:55'),(38,452,88,88,2.0000,19850.00,0.00,19850.00,'fixed',0,19850.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:29:37','2022-02-24 03:21:35'),(39,452,89,89,2.0000,24150.00,0.00,24150.00,'fixed',0,24150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:29:37','2021-08-03 17:29:37'),(40,452,87,87,2.0000,14250.00,0.00,14250.00,'fixed',0,14250.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:29:37','2021-08-03 17:29:37'),(41,453,1390,1392,1.0000,30660.00,0.00,30660.00,'fixed',0,30660.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:33:19','2021-09-01 16:23:30'),(42,453,819,819,1.0000,53340.00,0.00,53340.00,'fixed',0,53340.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:33:19','2021-08-29 23:01:00'),(43,454,1191,1191,1.0000,696.00,0.00,696.00,'fixed',0,696.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:38:51','2021-08-03 17:38:51'),(44,454,1190,1190,1.0000,609.00,0.00,609.00,'fixed',0,609.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:38:51','2021-08-03 17:38:51'),(45,454,1391,1393,4.0000,740.00,0.00,740.00,'fixed',0,740.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:38:51','2021-08-03 17:38:51'),(46,455,1006,1006,4.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:43:25','2021-10-16 21:29:05'),(47,455,849,849,6.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:43:25','2021-10-04 14:38:49'),(48,455,134,134,3.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:43:25','2021-09-08 20:59:01'),(49,455,1392,1394,8.0000,1700.00,0.00,1700.00,'fixed',0,1700.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 17:43:25','2021-10-16 21:31:22'),(50,456,850,850,3.0000,1959.56,0.00,1959.56,'fixed',0,1959.56,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-03 20:51:45'),(51,456,44,44,1.0000,2138.00,0.00,2138.00,'fixed',0,2138.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-03 20:51:45'),(52,456,1393,1395,2.0000,2605.00,0.00,2605.00,'fixed',0,2605.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-03 20:51:45'),(53,456,1394,1396,1.0000,2075.00,0.00,2075.00,'fixed',0,2075.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-09-01 16:08:21'),(54,456,1395,1397,3.0000,2160.00,0.00,2160.00,'fixed',0,2160.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-03 20:51:45'),(55,456,1396,1398,1.0000,2340.00,0.00,2340.00,'fixed',0,2340.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-03 20:51:45'),(56,456,811,811,2.0000,2256.25,0.00,2256.25,'fixed',0,2256.25,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-03 20:51:45'),(57,456,1397,1399,1.0000,2075.00,0.00,2075.00,'fixed',0,2075.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-09-30 15:56:57'),(58,456,43,43,1.0000,1661.00,0.00,1661.00,'fixed',0,1661.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-09-01 16:01:11'),(59,456,812,812,1.0000,2060.00,0.00,2060.00,'fixed',0,2060.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-10-16 21:34:41'),(60,456,1398,1400,1.0000,2320.00,0.00,2320.00,'fixed',0,2320.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-31 21:43:16'),(61,456,797,797,1.0000,1893.33,0.00,1893.33,'fixed',0,1893.33,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 20:51:45','2021-08-31 21:11:43'),(62,457,902,902,11.0000,280.38,0.00,280.38,'fixed',0,280.38,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-10-18 21:17:59'),(63,457,901,901,11.0000,215.07,0.00,215.07,'fixed',0,215.07,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-09-08 21:24:17'),(64,457,905,905,16.0000,167.20,0.00,167.20,'fixed',0,167.20,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-09-12 14:25:45'),(65,457,898,898,5.0000,159.51,0.00,159.51,'fixed',0,159.51,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-09-01 19:53:22'),(66,457,897,897,8.0000,113.25,0.00,113.25,'fixed',0,113.25,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-09-01 16:22:15'),(67,457,896,896,2.0000,99.54,0.00,99.54,'fixed',0,99.54,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-08-29 20:43:58'),(68,457,1214,1214,13.0000,423.00,0.00,423.00,'fixed',0,423.00,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-08-31 20:32:25'),(69,457,904,904,4.0000,391.17,0.00,391.17,'fixed',0,391.17,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-08-30 00:30:10'),(70,457,899,899,12.0000,181.08,0.00,181.08,'fixed',0,181.08,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:07:08','2021-09-08 21:00:03'),(71,458,1399,1401,1.0000,277.00,0.00,277.00,'fixed',0,277.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:20:37','2021-08-03 21:20:37'),(72,458,907,907,6.0000,399.00,0.00,399.00,'fixed',0,399.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-03 21:20:37','2021-09-28 16:38:55'),(73,459,1371,1373,2.0000,1035.00,0.00,1035.00,'fixed',0,1035.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-04 15:00:54'),(74,459,1374,1376,2.0000,885.00,0.00,885.00,'fixed',0,885.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-10-22 14:52:00'),(75,459,1375,1377,2.0000,875.00,0.00,875.00,'fixed',0,875.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-01 20:49:44'),(76,459,829,829,1.0000,1148.00,0.00,1148.00,'fixed',0,1148.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-08-04 13:58:58'),(77,459,1372,1374,2.0000,1025.00,0.00,1025.00,'fixed',0,1025.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-08 19:50:40'),(78,459,1369,1371,3.0000,814.00,0.00,814.00,'fixed',0,814.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-29 13:12:33'),(79,459,1373,1375,2.0000,955.00,0.00,955.00,'fixed',0,955.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-20 16:05:15'),(80,459,1370,1372,2.0000,823.00,0.00,823.00,'fixed',0,823.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-10-04 14:40:06'),(81,459,1376,1378,3.0000,987.00,0.00,987.00,'fixed',0,987.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-28 15:28:25'),(82,459,1401,1403,3.0000,752.00,0.00,752.00,'fixed',0,752.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-10-10 13:31:59'),(83,459,1400,1402,3.0000,752.00,0.00,752.00,'fixed',0,752.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-08 20:49:58'),(84,459,1377,1379,2.0000,825.00,0.00,825.00,'fixed',0,825.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 13:58:58','2021-09-28 16:13:45'),(85,460,911,911,46.0000,12.32,0.00,12.32,'fixed',0,12.32,0.00,NULL,46.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:00:56','2021-10-16 21:43:18'),(86,461,96,96,1.0000,1238.90,0.00,1238.90,'fixed',0,1238.90,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:04:19','2021-08-04 14:04:19'),(87,461,95,95,2.0000,1632.67,0.00,1632.67,'fixed',0,1632.67,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:04:19','2021-08-04 14:04:19'),(88,461,92,92,2.0000,2500.80,0.00,2500.80,'fixed',0,2500.80,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:04:19','2021-08-04 14:04:19'),(89,461,996,996,1.0000,2075.00,0.00,2075.00,'fixed',0,2075.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:04:19','2021-08-04 14:04:19'),(90,461,1402,1404,1.0000,2056.00,0.00,2056.00,'fixed',0,2056.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:04:19','2021-08-04 14:04:19'),(91,462,1189,1189,2.0000,11900.00,0.00,11900.00,'fixed',0,11900.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:06:06','2021-09-01 16:23:30'),(92,462,1182,1182,1.0000,23700.00,0.00,23700.00,'fixed',0,23700.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:06:06','2021-08-04 14:06:06'),(93,463,1185,1185,9.0000,3210.00,0.00,3210.00,'fixed',0,3210.00,0.00,NULL,9.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:08:26','2021-09-08 20:49:58'),(94,463,1186,1186,1.0000,3500.00,0.00,3500.00,'fixed',0,3500.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:08:26','2021-10-11 14:11:29'),(95,463,977,977,2.0000,2740.00,0.00,2740.00,'fixed',0,2740.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:08:26','2021-08-29 15:49:53'),(96,463,976,976,4.0000,2566.00,0.00,2566.00,'fixed',0,2566.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:08:26','2021-09-29 13:24:59'),(97,464,775,775,4.0000,3586.00,0.00,3586.00,'fixed',0,3586.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:13:57','2021-09-01 16:05:50'),(98,464,60,60,1.0000,1180.00,0.00,1180.00,'fixed',0,1180.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:13:57','2021-08-31 21:19:11'),(99,464,1403,1405,1.0000,3910.00,0.00,3910.00,'fixed',0,3910.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:13:57','2021-09-01 20:49:44'),(100,464,51,51,2.0000,1995.00,0.00,1995.00,'fixed',0,1995.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:13:57','2021-10-09 20:47:52'),(101,464,824,824,3.0000,1800.50,0.00,1800.50,'fixed',0,1800.50,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:13:57','2021-08-04 14:13:57'),(102,464,825,825,2.0000,1850.00,0.00,1850.00,'fixed',0,1850.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:13:57','2021-08-29 15:49:53'),(103,465,1404,1406,1.0000,2770.00,0.00,2770.00,'fixed',0,2770.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:17:23','2021-08-29 15:49:53'),(104,466,931,931,6.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:21:48','2021-10-09 19:56:42'),(105,466,932,932,2.0000,240.00,0.00,240.00,'fixed',0,240.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:21:48','2021-09-01 18:53:50'),(106,466,933,933,2.0000,200.00,0.00,200.00,'fixed',0,200.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:21:48','2021-09-01 18:53:50'),(107,466,935,935,1.0000,240.00,0.00,240.00,'fixed',0,240.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:21:48','2021-09-14 14:19:26'),(108,466,936,936,1.0000,212.00,0.00,212.00,'fixed',0,212.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:21:48','2021-08-04 14:21:48'),(109,466,934,934,1.0000,144.00,0.00,144.00,'fixed',0,144.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 14:21:48','2021-09-08 20:37:26'),(110,467,1405,1407,2.0000,772.00,0.00,772.00,'fixed',0,772.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:05:51','2021-08-04 15:05:51'),(111,467,908,908,16.0000,104.00,0.00,104.00,'fixed',0,104.00,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:05:51','2021-10-07 16:27:35'),(112,468,1017,1017,1.0000,1630.00,0.00,1630.00,'fixed',0,1630.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:08:32','2021-08-31 21:04:57'),(113,468,994,994,1.0000,1727.00,0.00,1727.00,'fixed',0,1727.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:08:32','2021-08-04 15:08:32'),(114,469,1406,1408,2.0000,1465.00,0.00,1465.00,'fixed',0,1465.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:29:13','2021-08-04 15:29:13'),(115,469,1408,1410,2.0000,1157.00,0.00,1157.00,'fixed',0,1157.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:29:13','2021-09-28 17:00:22'),(116,469,1409,1411,1.0000,993.00,0.00,993.00,'fixed',0,993.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:29:13','2021-09-28 15:28:25'),(117,469,104,104,1.0000,1213.00,0.00,1213.00,'fixed',0,1213.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:29:13','2021-08-31 20:34:32'),(118,470,1096,1096,12.0000,475.00,0.00,475.00,'fixed',0,475.00,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:30:41','2021-09-19 16:10:00'),(119,471,891,891,4.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-10-10 14:03:24'),(120,471,892,892,27.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-10-12 14:17:18'),(121,471,889,889,33.0000,22.50,0.00,22.50,'fixed',0,22.50,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-10-14 13:34:06'),(122,471,888,888,15.0000,19.00,0.00,19.00,'fixed',0,19.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-08-04 15:39:09'),(123,471,887,887,22.0000,15.75,0.00,15.75,'fixed',0,15.75,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-09-17 15:20:02'),(124,471,886,886,28.0000,13.50,0.00,13.50,'fixed',0,13.50,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-10-10 13:26:39'),(125,471,971,971,11.0000,28.50,0.00,28.50,'fixed',0,28.50,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-08-04 15:39:09'),(126,471,890,890,10.0000,26.25,0.00,26.25,'fixed',0,26.25,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:39:09','2021-08-29 22:15:50'),(127,472,882,882,47.0000,19.54,0.00,19.54,'fixed',0,19.54,0.00,NULL,47.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-09-01 18:26:50'),(128,472,883,883,57.0000,21.60,0.00,21.60,'fixed',0,21.60,0.00,NULL,57.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-10-08 16:08:36'),(129,472,885,885,16.0000,25.47,0.00,25.47,'fixed',0,25.47,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-09-12 14:33:32'),(130,472,894,894,11.0000,15.00,0.00,15.00,'fixed',0,15.00,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-09-12 14:33:32'),(131,472,972,972,11.0000,27.47,0.00,27.47,'fixed',0,27.47,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-09-01 14:28:56'),(132,472,1271,1271,9.0000,115.01,0.00,115.01,'fixed',0,115.01,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-10-07 16:27:35'),(133,472,895,895,12.0000,28.06,0.00,28.06,'fixed',0,28.06,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-10-04 14:38:49'),(134,472,472,472,37.0000,28.75,0.00,28.75,'fixed',0,28.75,0.00,NULL,37.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-09-01 19:24:54'),(135,472,1281,1281,9.0000,27.26,0.00,27.26,'fixed',0,27.26,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-10-07 16:27:35'),(136,472,1282,1282,1.0000,30.08,0.00,30.08,'fixed',0,30.08,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:50:49','2021-10-10 14:03:24'),(137,473,912,912,1.0000,2750.00,0.00,2750.00,'fixed',0,2750.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:54:02','2021-08-04 15:54:02'),(138,473,910,910,1.0000,280.00,0.00,280.00,'fixed',0,280.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:54:02','2021-08-04 15:54:02'),(139,473,906,906,1.0000,480.00,0.00,480.00,'fixed',0,480.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:54:02','2021-08-04 15:54:02'),(140,474,75,75,4.0000,2052.00,0.00,2052.00,'fixed',0,2052.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:57:53','2021-09-21 15:58:18'),(141,474,71,71,1.0000,2423.40,0.00,2423.40,'fixed',0,2423.40,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:57:53','2021-08-29 20:47:59'),(142,474,1325,1325,1.0000,2295.00,0.00,2295.00,'fixed',0,2295.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:57:53','2021-09-01 17:04:46'),(143,474,1197,1197,2.0000,2035.00,0.00,2035.00,'fixed',0,2035.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 15:57:53','2021-09-01 18:41:41'),(144,475,1410,1412,3.0000,1729.00,0.00,1729.00,'fixed',0,1729.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-04 17:13:20'),(145,475,867,867,4.0000,1774.00,0.00,1774.00,'fixed',0,1774.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-16 21:29:05'),(146,475,458,458,10.0000,1292.93,0.00,1292.93,'fixed',0,1292.93,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-01 18:22:21'),(147,475,872,872,3.0000,1729.00,0.00,1729.00,'fixed',0,1729.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-17 15:12:12'),(148,475,1000,1000,3.0000,1501.50,0.00,1501.50,'fixed',0,1501.50,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-04 17:13:20'),(149,475,1411,1413,2.0000,1683.00,0.00,1683.00,'fixed',0,1683.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-04 17:13:20'),(150,475,869,869,4.0000,1820.00,0.00,1820.00,'fixed',0,1820.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-29 16:08:16'),(151,475,836,836,4.0000,1600.00,0.00,1600.00,'fixed',0,1600.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-02 14:26:17'),(152,475,633,633,10.0000,1575.00,0.00,1575.00,'fixed',0,1575.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-13 15:53:33'),(153,475,786,786,10.0000,1775.00,0.00,1775.00,'fixed',0,1775.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-21 14:38:53'),(154,475,457,457,9.0000,1575.00,0.00,1575.00,'fixed',0,1575.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-18 21:17:59'),(155,475,714,714,19.0000,1285.00,0.00,1285.00,'fixed',0,1285.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-18 21:17:59'),(156,475,951,951,1.0000,1104.00,0.00,1104.00,'fixed',0,1104.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-28 16:13:45'),(157,475,879,879,2.0000,1725.96,0.00,1725.96,'fixed',0,1725.96,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-12 14:34:00'),(158,475,462,462,19.0000,1260.00,0.00,1260.00,'fixed',0,1260.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-09 20:28:04'),(159,475,1412,1414,4.0000,1375.00,0.00,1375.00,'fixed',0,1375.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-18 21:18:59'),(160,475,787,787,11.0000,1575.00,0.00,1575.00,'fixed',0,1575.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-22 14:52:00'),(161,475,689,689,6.0000,1313.74,0.00,1313.74,'fixed',0,1313.74,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-24 13:56:24'),(162,475,1413,1415,3.0000,1450.00,0.00,1450.00,'fixed',0,1450.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-01 15:03:25'),(163,475,868,868,2.0000,1820.00,0.00,1820.00,'fixed',0,1820.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-04 17:13:20'),(164,475,1414,1416,2.0000,1030.00,0.00,1030.00,'fixed',0,1030.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-01 17:20:09'),(165,475,460,460,5.0000,1730.00,0.00,1730.00,'fixed',0,1730.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-01 18:18:23'),(166,475,1415,1417,4.0000,900.00,0.00,900.00,'fixed',0,900.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-09-08 13:58:46'),(167,475,961,961,2.0000,1470.00,0.00,1470.00,'fixed',0,1470.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-31 20:43:11'),(168,475,1416,1418,1.0000,1350.00,0.00,1350.00,'fixed',0,1350.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-06 14:34:12'),(169,475,965,965,4.0000,1530.00,0.00,1530.00,'fixed',0,1530.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2022-11-21 17:02:25'),(170,475,870,870,3.0000,1665.00,0.00,1665.00,'fixed',0,1665.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-10-07 16:14:50'),(171,475,950,950,2.0000,955.79,0.00,955.79,'fixed',0,955.79,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-29 23:21:32'),(172,475,1143,1143,1.0000,1933.33,0.00,1933.33,'fixed',0,1933.33,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 17:13:20','2021-08-04 17:13:20'),(173,476,949,949,2.0000,3094.00,0.00,3094.00,'fixed',0,3094.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-08 20:59:01'),(174,476,948,948,2.0000,3276.00,0.00,3276.00,'fixed',0,3276.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-10-13 15:42:52'),(175,476,877,877,2.0000,3276.00,0.00,3276.00,'fixed',0,3276.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-04 22:05:43'),(176,476,1417,1419,1.0000,3060.00,0.00,3060.00,'fixed',0,3060.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-04 22:05:43'),(177,476,1418,1420,2.0000,3915.00,0.00,3915.00,'fixed',0,3915.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-01 20:49:44'),(178,476,875,875,2.0000,2313.21,0.00,2313.21,'fixed',0,2313.21,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-10-23 20:04:07'),(179,476,1419,1421,1.0000,3330.00,0.00,3330.00,'fixed',0,3330.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-20 16:07:25'),(180,476,833,833,4.0000,4300.00,0.00,4300.00,'fixed',0,4300.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-29 14:30:45'),(181,476,1420,1422,2.0000,3525.00,0.00,3525.00,'fixed',0,3525.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-10-20 19:23:36'),(182,476,1421,1423,2.0000,2655.00,0.00,2655.00,'fixed',0,2655.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-28 17:11:09'),(183,476,1422,1424,1.0000,2325.00,0.00,2325.00,'fixed',0,2325.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-10-07 16:27:35'),(184,476,1423,1425,2.0000,2725.00,0.00,2725.00,'fixed',0,2725.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-10 14:20:21'),(185,476,992,992,4.0000,1774.50,0.00,1774.50,'fixed',0,1774.50,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-21 15:58:18'),(186,476,456,456,3.0000,2675.00,0.00,2675.00,'fixed',0,2675.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-14 15:08:01'),(187,476,1422,1424,1.0000,2325.00,0.00,2325.00,'fixed',0,2325.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-04 22:05:43'),(188,476,875,875,1.0000,2313.21,0.00,2313.21,'fixed',0,2313.21,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-04 22:05:43'),(189,476,1424,1426,1.0000,1730.00,0.00,1730.00,'fixed',0,1730.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-31 20:43:11'),(190,476,1425,1427,1.0000,3240.00,0.00,3240.00,'fixed',0,3240.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-04 14:41:52'),(191,476,1426,1428,1.0000,3525.00,0.00,3525.00,'fixed',0,3525.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-29 14:27:24'),(192,476,1427,1429,1.0000,4025.00,0.00,4025.00,'fixed',0,4025.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-28 21:48:23'),(193,476,1428,1430,1.0000,3125.00,0.00,3125.00,'fixed',0,3125.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-09-01 14:28:56'),(194,476,834,834,1.0000,4500.00,0.00,4500.00,'fixed',0,4500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:05:43','2021-08-04 22:05:43'),(195,477,267,267,11.0000,55.00,0.00,55.00,'fixed',0,55.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:11:16','2021-09-28 16:53:10'),(196,477,265,265,7.0000,13.09,0.00,13.09,'fixed',0,13.09,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:11:16','2021-09-08 13:58:46'),(203,479,1432,1434,26.0000,35.00,0.00,35.00,'fixed',0,35.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-08-29 23:12:22'),(204,479,1433,1435,13.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-08-04 22:44:27'),(205,479,1070,1070,74.0000,25.00,0.00,25.00,'fixed',0,25.00,0.00,NULL,54.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-10-24 13:55:25'),(206,479,1071,1071,61.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,24.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-10-09 19:56:42'),(207,479,1436,1438,17.0000,65.00,0.00,65.00,'fixed',0,65.00,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-09-01 18:58:18'),(208,479,1437,1439,30.0000,145.00,0.00,145.00,'fixed',0,145.00,0.00,NULL,20.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-10-21 14:38:53'),(209,479,1073,1073,20.0000,75.20,0.00,75.20,'fixed',0,75.20,0.00,NULL,19.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-10-07 16:27:35'),(210,479,1074,1074,28.0000,111.35,0.00,111.35,'fixed',0,111.35,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-09-29 13:17:16'),(211,479,1075,1075,5.0000,125.00,0.00,125.00,'fixed',0,125.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-08-29 23:12:22'),(212,479,1438,1440,19.0000,120.00,0.00,120.00,'fixed',0,120.00,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-10-24 13:55:25'),(213,479,1439,1441,9.0000,30.00,0.00,30.00,'fixed',0,30.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:44:27','2021-08-04 22:44:27'),(214,480,451,451,3203.0000,2.23,0.00,2.23,'fixed',0,2.23,0.00,NULL,508.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:47:17','2021-10-25 19:38:29'),(215,480,263,263,29.0000,4.00,0.00,4.00,'fixed',0,4.00,0.00,NULL,15.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:47:17','2021-10-17 14:01:47'),(216,480,1440,1442,130.0000,4.00,0.00,4.00,'fixed',0,4.00,0.00,NULL,41.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 22:47:17','2021-10-03 16:41:24'),(217,481,881,881,2.0000,1950.00,0.00,1950.00,'fixed',0,1950.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:13:52','2021-09-01 19:31:22'),(218,481,1146,1146,3.0000,320.00,0.00,320.00,'fixed',0,320.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:13:52','2022-12-19 10:56:55'),(219,481,1091,1091,1.0000,1740.00,0.00,1740.00,'fixed',0,1740.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:13:52','2021-09-04 14:57:58'),(220,481,465,465,1.0000,570.00,0.00,570.00,'fixed',0,570.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:13:52','2021-08-04 23:13:52'),(221,482,749,749,2.0000,530.00,0.00,530.00,'fixed',0,530.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:14:54','2021-08-04 23:14:54'),(222,483,1061,1061,16.0000,1000.00,0.00,1000.00,'fixed',0,1000.00,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2021-08-29 20:57:47'),(223,483,1063,1063,1.0000,2180.00,0.00,2180.00,'fixed',0,2180.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2021-08-28 19:29:36'),(224,483,1059,1059,17.0000,990.00,0.00,990.00,'fixed',0,990.00,0.00,NULL,17.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2021-08-29 22:34:53'),(225,483,1060,1060,21.0000,1000.00,0.00,1000.00,'fixed',0,1000.00,0.00,NULL,21.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2021-09-01 20:54:14'),(226,483,1217,1217,1.0000,500.00,0.00,500.00,'fixed',0,500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2021-08-04 23:25:10'),(227,483,1065,1065,2.0000,2800.00,0.00,2800.00,'fixed',0,2800.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2021-09-01 17:20:09'),(228,483,1062,1062,107.0000,964.00,0.00,964.00,'fixed',0,964.00,0.00,NULL,63.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:25:10','2023-06-16 09:07:25'),(229,484,1064,1064,2.0000,1737.00,0.00,1737.00,'fixed',0,1737.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-04 23:29:14','2022-06-19 06:08:59'),(230,485,554,554,16.0000,12.00,0.00,12.00,'fixed',0,12.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-10-22 14:52:00'),(231,485,556,556,1.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-08-05 13:31:14'),(232,485,706,706,11.0000,30.00,0.00,30.00,'fixed',0,30.00,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-09-01 18:58:18'),(233,485,647,647,395.0000,4.45,0.00,4.45,'fixed',0,4.45,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-09-28 16:34:07'),(234,485,259,259,10.0000,110.00,0.00,110.00,'fixed',0,110.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-10-13 15:54:46'),(235,485,260,260,10.0000,130.00,0.00,130.00,'fixed',0,130.00,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-09-01 18:58:18'),(236,485,802,802,6.0000,150.00,0.00,150.00,'fixed',0,150.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-10-16 21:43:18'),(237,485,803,803,59.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,58.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-10-25 19:38:29'),(238,485,1441,1443,8.0000,80.00,0.00,80.00,'fixed',0,80.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2021-08-31 21:29:46'),(239,485,1442,1444,30.0000,60.00,0.00,60.00,'fixed',0,60.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 13:31:14','2022-06-06 02:00:19'),(240,486,862,862,1.0000,300.00,0.00,300.00,'fixed',0,300.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:45:47','2021-09-01 16:53:02'),(241,486,855,855,9.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:45:47','2021-10-16 21:43:18'),(242,486,1443,1445,8.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:45:47','2021-10-17 14:01:47'),(243,486,1444,1446,26.0000,160.00,0.00,160.00,'fixed',0,160.00,0.00,NULL,22.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:45:47','2021-10-07 16:29:01'),(244,486,1445,1447,15.0000,190.00,0.00,190.00,'fixed',0,190.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:45:47','2021-10-07 16:27:35'),(245,487,1068,1068,16.0000,130.00,0.00,130.00,'fixed',0,130.00,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:48:25','2021-10-07 16:14:50'),(246,487,1066,1066,18.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:48:25','2021-10-03 16:41:24'),(247,487,1067,1067,29.0000,160.00,0.00,160.00,'fixed',0,160.00,0.00,NULL,19.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:48:25','2021-10-03 16:41:24'),(248,487,1069,1069,13.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:48:25','2021-10-20 19:07:20'),(249,488,553,553,1.0000,30.00,0.00,30.00,'fixed',0,30.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:51:54','2021-08-28 19:40:03'),(250,488,261,261,670.0000,5.38,0.00,5.38,'fixed',0,5.38,0.00,NULL,670.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:51:54','2021-10-25 19:40:57'),(251,488,801,801,8.0000,35.00,0.00,35.00,'fixed',0,35.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 14:51:54','2021-10-09 19:56:42'),(252,489,253,253,23.0000,160.00,0.00,160.00,'fixed',0,160.00,0.00,NULL,22.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:18:07','2021-10-21 14:38:53'),(253,489,847,847,116.0000,145.00,0.00,145.00,'fixed',0,145.00,0.00,NULL,96.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:18:07','2021-10-21 14:38:53'),(254,489,1429,1431,5.0000,250.00,0.00,250.00,'fixed',0,250.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:18:07','2021-09-28 16:15:17'),(255,489,1430,1432,4.0000,150.00,0.00,150.00,'fixed',0,150.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:18:07','2021-09-04 14:41:52'),(256,489,645,645,3.0000,160.00,0.00,160.00,'fixed',0,160.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:18:07','2021-09-08 20:35:46'),(257,489,1431,1433,5.0000,350.00,0.00,350.00,'fixed',0,350.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:18:07','2021-10-25 19:43:28'),(258,490,170,170,18.0000,2100.00,0.00,2100.00,'fixed',0,2100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:50:43','2021-08-05 15:50:43'),(259,490,538,538,73.0000,2100.00,0.00,2100.00,'fixed',0,2100.00,0.00,NULL,26.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:50:43','2023-01-01 03:32:30'),(260,490,171,171,33.0000,2100.00,0.00,2100.00,'fixed',0,2100.00,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:50:43','2023-01-09 04:40:42'),(261,490,169,169,1.0000,2100.00,0.00,2100.00,'fixed',0,2100.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:50:43','2021-08-31 21:43:16'),(262,491,1292,1292,4.0000,978.00,0.00,978.00,'fixed',0,978.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-10-03 16:37:37'),(263,491,1289,1289,3.0000,1426.00,0.00,1426.00,'fixed',0,1426.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-08-05 15:59:27'),(264,491,1301,1301,3.0000,1018.00,0.00,1018.00,'fixed',0,1018.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-08-29 22:15:50'),(265,491,1295,1295,1.0000,1206.00,0.00,1206.00,'fixed',0,1206.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-08-05 15:59:27'),(266,491,1293,1293,5.0000,1141.00,0.00,1141.00,'fixed',0,1141.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-10-16 21:29:05'),(267,491,1294,1294,2.0000,1157.00,0.00,1157.00,'fixed',0,1157.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-09-01 15:06:20'),(268,491,1287,1287,2.0000,1157.30,0.00,1157.30,'fixed',0,1157.30,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-08-05 15:59:27'),(269,491,1291,1291,3.0000,937.00,0.00,937.00,'fixed',0,937.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-09-12 14:12:08'),(270,491,1300,1300,1.0000,692.50,0.00,692.50,'fixed',0,692.50,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-08-31 21:21:35'),(271,491,1288,1288,1.0000,1279.00,0.00,1279.00,'fixed',0,1279.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 15:59:27','2021-08-05 15:59:27'),(272,492,759,759,5.0000,30386.00,0.00,30386.00,'fixed',0,30386.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-28 19:29:36'),(273,492,1023,1023,3.0000,29654.00,0.00,29654.00,'fixed',0,29654.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-29 16:08:16'),(274,492,540,540,6.0000,33236.00,0.00,33236.00,'fixed',0,33236.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(275,492,1319,1319,2.0000,33311.00,0.00,33311.00,'fixed',0,33311.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(276,492,1254,1254,2.0000,31404.00,0.00,31404.00,'fixed',0,31404.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-16 21:46:37'),(277,492,536,536,2.0000,32079.00,0.00,32079.00,'fixed',0,32079.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(278,492,722,722,8.0000,31029.00,0.00,31029.00,'fixed',0,31029.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(279,492,1178,1178,1.0000,27197.00,0.00,27197.00,'fixed',0,27197.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(280,492,1027,1027,7.0000,26364.00,0.00,26364.00,'fixed',0,26364.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-05 16:48:59'),(281,492,721,721,1.0000,27697.00,0.00,27697.00,'fixed',0,27697.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(282,492,727,727,2.0000,27655.00,0.00,27655.00,'fixed',0,27655.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-01 19:44:07'),(283,492,1176,1176,5.0000,24781.00,0.00,24781.00,'fixed',0,24781.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(284,492,1133,1133,3.0000,22740.00,0.00,22740.00,'fixed',0,22740.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(285,492,842,842,5.0000,23740.00,0.00,23740.00,'fixed',0,23740.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(286,492,1024,1024,9.0000,26239.00,0.00,26239.00,'fixed',0,26239.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-16 21:33:56'),(287,492,1162,1162,5.0000,26572.00,0.00,26572.00,'fixed',0,26572.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(288,492,1025,1025,9.0000,25239.00,0.00,25239.00,'fixed',0,25239.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-12 14:20:36'),(289,492,1308,1308,3.0000,24698.00,0.00,24698.00,'fixed',0,24698.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-28 15:31:00'),(290,492,767,767,19.0000,25739.00,0.00,25739.00,'fixed',0,25739.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-03 16:42:59'),(291,492,1008,1008,6.0000,23240.00,0.00,23240.00,'fixed',0,23240.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(292,492,843,843,6.0000,23740.00,0.00,23740.00,'fixed',0,23740.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-14 13:34:47'),(293,492,1446,1448,1.0000,24073.00,0.00,24073.00,'fixed',0,24073.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(294,492,720,720,1.0000,22824.00,0.00,22824.00,'fixed',0,22824.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(295,492,1132,1132,7.0000,23157.00,0.00,23157.00,'fixed',0,23157.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-14 14:27:53'),(296,492,1447,1449,27.0000,18652.00,0.00,18652.00,'fixed',0,18652.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-01 16:05:50'),(297,492,1136,1136,2.0000,17576.00,0.00,17576.00,'fixed',0,17576.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-31 21:19:52'),(298,492,726,726,5.0000,28113.00,0.00,28113.00,'fixed',0,28113.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(299,492,1177,1177,13.0000,27072.00,0.00,27072.00,'fixed',0,27072.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-31 21:20:10'),(300,492,766,766,16.0000,22824.00,0.00,22824.00,'fixed',0,22824.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-03 16:36:36'),(301,492,533,533,7.0000,22450.00,0.00,22450.00,'fixed',0,22450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-28 16:34:56'),(302,492,840,840,3.0000,17076.00,0.00,17076.00,'fixed',0,17076.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-11 15:06:11'),(303,492,1134,1134,1.0000,16243.00,0.00,16243.00,'fixed',0,16243.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(304,492,1307,1307,1.0000,22407.00,0.00,22407.00,'fixed',0,22407.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-31 20:33:26'),(305,492,2,2,6.0000,19150.00,0.00,19150.00,'fixed',0,19150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-10 21:35:13'),(306,492,1028,1028,9.0000,21074.00,0.00,21074.00,'fixed',0,21074.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-13 22:02:49'),(307,492,1029,1029,9.0000,20658.00,0.00,20658.00,'fixed',0,20658.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-10-10 21:46:26'),(308,492,728,728,1.0000,19567.00,0.00,19567.00,'fixed',0,19567.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(309,492,1131,1131,2.0000,16368.00,0.00,16368.00,'fixed',0,16368.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(310,492,1317,1317,2.0000,19492.00,0.00,19492.00,'fixed',0,19492.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(311,492,846,846,6.0000,26989.00,0.00,26989.00,'fixed',0,26989.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-05 14:21:23'),(312,492,1163,1163,4.0000,26239.00,0.00,26239.00,'fixed',0,26239.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(313,492,729,729,2.0000,23573.00,0.00,23573.00,'fixed',0,23573.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-09-21 15:58:54'),(314,492,1137,1137,1.0000,24240.00,0.00,24240.00,'fixed',0,24240.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:30:13','2021-08-05 16:30:13'),(316,494,160,160,4.0000,1927.00,0.00,1927.00,'fixed',0,1927.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:37:21','2021-08-05 16:37:21'),(317,494,1311,1311,4.0000,390.00,0.00,390.00,'fixed',0,390.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:37:21','2021-10-09 20:29:49'),(318,494,1448,1450,2.0000,220.00,0.00,220.00,'fixed',0,220.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:37:21','2021-08-05 16:37:21'),(319,495,155,155,3.0000,1028.00,0.00,1028.00,'fixed',0,1028.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:39:17','2021-10-20 19:19:57'),(320,495,723,723,6.0000,605.70,0.00,605.70,'fixed',0,605.70,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:39:17','2021-10-06 14:33:25'),(321,495,156,156,5.0000,993.44,0.00,993.44,'fixed',0,993.44,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:39:17','2021-10-04 14:38:49'),(322,496,1055,1055,6.0000,19046.00,0.00,19046.00,'fixed',0,19046.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-08-05 16:58:32'),(323,496,1378,1380,8.0000,13895.00,0.00,13895.00,'fixed',0,13895.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-08-05 16:58:32'),(324,496,1056,1056,4.0000,14687.00,0.00,14687.00,'fixed',0,14687.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-09-17 14:29:38'),(325,496,1057,1057,7.0000,19442.00,0.00,19442.00,'fixed',0,19442.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-10-16 21:34:41'),(326,496,769,769,5.0000,14515.00,0.00,14515.00,'fixed',0,14515.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-09-28 17:20:48'),(327,496,851,851,5.0000,14515.00,0.00,14515.00,'fixed',0,14515.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-09-21 16:00:48'),(328,496,1449,1451,5.0000,12650.00,0.00,12650.00,'fixed',0,12650.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-09-19 16:11:29'),(329,496,1450,1452,6.0000,12650.00,0.00,12650.00,'fixed',0,12650.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-10-03 16:37:37'),(330,496,1451,1453,4.0000,12612.00,0.00,12612.00,'fixed',0,12612.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-08-05 16:58:32'),(331,496,1452,1454,7.0000,11842.00,0.00,11842.00,'fixed',0,11842.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-08-05 16:58:32'),(332,496,852,852,1.0000,14818.00,0.00,14818.00,'fixed',0,14818.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-08-29 16:08:16'),(333,496,725,725,1.0000,29630.00,0.00,29630.00,'fixed',0,29630.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-10-16 21:32:51'),(334,496,792,792,1.0000,10242.00,0.00,10242.00,'fixed',0,10242.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-09-28 16:13:45'),(335,496,1058,1058,4.0000,10952.00,0.00,10952.00,'fixed',0,10952.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-10-12 14:18:38'),(336,496,941,941,1.0000,9254.00,0.00,9254.00,'fixed',0,9254.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 16:58:32','2021-08-05 16:58:32'),(337,497,1022,1022,1.0000,14917.30,0.00,14917.30,'fixed',0,14917.30,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:05:11','2021-08-05 17:05:11'),(338,497,1453,1455,1.0000,6680.00,0.00,6680.00,'fixed',0,6680.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:05:11','2021-08-05 17:05:11'),(339,498,1297,1297,42.0000,1630.00,0.00,1630.00,'fixed',0,1630.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:08:16','2021-09-08 20:35:46'),(340,498,1158,1158,2.0000,2138.00,0.00,2138.00,'fixed',0,2138.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:08:16','2021-08-05 17:08:16'),(341,498,1159,1159,3.0000,2303.00,0.00,2303.00,'fixed',0,2303.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:08:16','2021-08-05 17:08:16'),(342,499,1298,1298,3.0000,2097.00,0.00,2097.00,'fixed',0,2097.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:21:23','2021-08-31 21:25:39'),(343,499,944,944,4.0000,2478.00,0.00,2478.00,'fixed',0,2478.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:21:23','2021-10-06 14:33:25'),(344,499,1154,1154,1.0000,2097.00,0.00,2097.00,'fixed',0,2097.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:21:23','2021-08-05 17:21:23'),(345,499,1153,1153,2.0000,2198.00,0.00,2198.00,'fixed',0,2198.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:21:23','2021-08-05 17:21:23'),(346,500,1021,1021,17.0000,1048.00,0.00,1048.00,'fixed',0,1048.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:23:20','2021-09-28 16:13:45'),(347,500,1020,1020,2.0000,1180.00,0.00,1180.00,'fixed',0,1180.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:23:20','2021-08-29 22:15:50'),(348,501,1296,1296,22.0000,3575.00,0.00,3575.00,'fixed',0,3575.00,0.00,NULL,14.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:27:55','2022-12-27 04:39:23'),(349,501,925,925,2.0000,1625.00,0.00,1625.00,'fixed',0,1625.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:27:55','2021-09-01 15:03:25'),(350,501,154,154,4.0000,1503.00,0.00,1503.00,'fixed',0,1503.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:27:55','2021-08-05 17:27:55'),(351,501,924,924,3.0000,1828.00,0.00,1828.00,'fixed',0,1828.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:27:55','2021-09-01 18:41:41'),(352,501,153,153,2.0000,1706.00,0.00,1706.00,'fixed',0,1706.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 17:27:55','2021-08-05 17:27:55'),(353,502,997,997,1.0000,1280.00,0.00,1280.00,'fixed',0,1280.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-01 15:13:42'),(354,502,1085,1085,2.0000,1180.00,0.00,1180.00,'fixed',0,1180.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-14 15:14:51'),(355,502,985,985,3.0000,1130.00,0.00,1130.00,'fixed',0,1130.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-10-02 14:26:17'),(356,502,1250,1250,2.0000,1210.00,0.00,1210.00,'fixed',0,1210.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-01 15:30:23'),(357,502,1083,1083,1.0000,1150.00,0.00,1150.00,'fixed',0,1150.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-28 17:00:22'),(358,502,940,940,3.0000,1030.00,0.00,1030.00,'fixed',0,1030.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-28 16:13:45'),(359,502,1011,1011,2.0000,1095.00,0.00,1095.00,'fixed',0,1095.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-28 17:00:22'),(360,502,1251,1251,3.0000,1090.00,0.00,1090.00,'fixed',0,1090.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-19 15:54:39'),(361,502,1249,1249,2.0000,940.00,0.00,940.00,'fixed',0,940.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-22 16:07:15'),(362,502,938,938,1.0000,920.00,0.00,920.00,'fixed',0,920.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-01 14:39:24'),(363,502,813,813,1.0000,1210.00,0.00,1210.00,'fixed',0,1210.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-10 14:17:26'),(364,502,939,939,1.0000,940.00,0.00,940.00,'fixed',0,940.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:42:14','2021-09-01 15:13:42'),(366,504,1455,1457,3.0000,22920.00,0.00,22920.00,'fixed',0,22920.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:53:14','2021-08-05 20:53:14'),(367,505,570,570,4.0000,1650.00,0.00,1650.00,'fixed',0,1650.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:54:39','2021-10-10 13:26:39'),(368,505,643,643,5.0000,1760.00,0.00,1760.00,'fixed',0,1760.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 20:54:39','2021-09-10 14:17:26'),(369,506,235,235,6.0000,170.00,0.00,170.00,'fixed',0,170.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-10-02 14:26:17'),(370,506,1456,1458,9.0000,200.00,0.00,200.00,'fixed',0,200.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-10-17 14:01:47'),(371,506,233,233,4.0000,70.00,0.00,70.00,'fixed',0,70.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-10-07 16:14:50'),(372,506,234,234,4.0000,75.00,0.00,75.00,'fixed',0,75.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-09-01 16:00:20'),(373,506,627,627,1.0000,280.00,0.00,280.00,'fixed',0,280.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-08-05 21:01:14'),(374,506,1457,1459,2.0000,70.00,0.00,70.00,'fixed',0,70.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-08-05 21:01:14'),(375,506,239,239,4.0000,115.00,0.00,115.00,'fixed',0,115.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-09-20 16:05:15'),(376,506,240,240,2.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:01:14','2021-09-21 15:49:24'),(377,507,1116,1116,3.0000,1050.00,0.00,1050.00,'fixed',0,1050.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:36:00','2021-09-10 14:17:26'),(378,507,634,634,9.0000,635.93,0.00,635.93,'fixed',0,635.93,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:36:00','2021-10-11 14:11:29'),(379,507,814,814,57.0000,145.00,0.00,145.00,'fixed',0,145.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:36:00','2021-10-08 16:28:39'),(380,507,320,320,6.0000,3093.85,0.00,3093.85,'fixed',0,3093.85,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:36:00','2021-10-18 21:12:09'),(381,507,1302,1302,1.0000,13000.00,0.00,13000.00,'fixed',0,13000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:36:00','2021-08-05 21:36:00'),(382,507,321,321,1.0000,670.00,0.00,670.00,'fixed',0,670.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:36:00','2021-08-05 21:36:00'),(383,508,613,613,9.0000,2140.00,0.00,2140.00,'fixed',0,2140.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-10-24 13:55:25'),(384,508,614,614,13.0000,1990.00,0.00,1990.00,'fixed',0,1990.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-10-08 16:05:48'),(385,508,1247,1247,3.0000,2232.00,0.00,2232.00,'fixed',0,2232.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-05 21:47:22'),(386,508,1458,1460,2.0000,1600.00,0.00,1600.00,'fixed',0,1600.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-09-01 17:17:28'),(387,508,1245,1245,2.0000,2604.00,0.00,2604.00,'fixed',0,2604.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-05 21:47:22'),(388,508,1246,1246,2.0000,2793.00,0.00,2793.00,'fixed',0,2793.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-05 21:47:22'),(389,508,1125,1125,1.0000,1650.00,0.00,1650.00,'fixed',0,1650.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-05 21:47:22'),(390,508,937,937,2.0000,2750.00,0.00,2750.00,'fixed',0,2750.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-30 00:30:10'),(391,508,700,700,2.0000,3980.00,0.00,3980.00,'fixed',0,3980.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-05 21:47:22'),(392,508,1248,1248,3.0000,2278.00,0.00,2278.00,'fixed',0,2278.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 21:47:22','2021-08-05 21:47:22'),(393,509,831,831,18.0000,2349.00,0.00,2349.00,'fixed',0,2349.00,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-10-03 16:42:20'),(394,509,340,340,15.0000,1655.00,0.00,1655.00,'fixed',0,1655.00,0.00,NULL,15.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-09-11 16:04:54'),(395,509,334,334,10.0000,1505.00,0.00,1505.00,'fixed',0,1505.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-09-28 17:12:54'),(396,509,325,325,23.0000,1405.00,0.00,1405.00,'fixed',0,1405.00,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-10-16 21:31:22'),(397,509,1123,1123,6.0000,1535.00,0.00,1535.00,'fixed',0,1535.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-10-16 21:43:18'),(398,509,832,832,22.0000,2150.00,0.00,2150.00,'fixed',0,2150.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-10-07 16:14:50'),(399,509,807,807,1.0000,1100.00,0.00,1100.00,'fixed',0,1100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(400,509,625,625,1.0000,2158.45,0.00,2158.45,'fixed',0,2158.45,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-09-08 20:44:01'),(401,509,326,326,1.0000,1550.00,0.00,1550.00,'fixed',0,1550.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(402,509,1459,1461,1.0000,1400.00,0.00,1400.00,'fixed',0,1400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(403,509,336,336,2.0000,1833.75,0.00,1833.75,'fixed',0,1833.75,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(404,509,331,331,1.0000,1350.00,0.00,1350.00,'fixed',0,1350.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(405,509,339,339,2.0000,1650.00,0.00,1650.00,'fixed',0,1650.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(406,509,1460,1462,1.0000,1225.00,0.00,1225.00,'fixed',0,1225.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(407,509,338,338,1.0000,1276.25,0.00,1276.25,'fixed',0,1276.25,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(408,509,1461,1463,7.0000,1400.00,0.00,1400.00,'fixed',0,1400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:06:44','2021-08-05 22:06:44'),(409,510,653,653,63.0000,250.00,0.00,250.00,'fixed',0,250.00,0.00,NULL,26.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-10-20 19:23:36'),(410,510,1299,1299,75.0000,250.00,0.00,250.00,'fixed',0,250.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-09-04 15:00:54'),(411,510,318,318,20.0000,140.00,0.00,140.00,'fixed',0,140.00,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-10-24 13:55:25'),(412,510,315,315,8.0000,70.00,0.00,70.00,'fixed',0,70.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-10-14 13:34:06'),(413,510,314,314,11.0000,85.00,0.00,85.00,'fixed',0,85.00,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-09-21 15:49:24'),(414,510,317,317,21.0000,60.00,0.00,60.00,'fixed',0,60.00,0.00,NULL,21.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2022-02-21 05:00:42'),(415,510,312,312,2.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-08-05 22:16:40'),(416,510,311,311,2.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-12-28 05:52:25'),(417,510,313,313,2.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-10-20 19:23:36'),(418,510,310,310,3.0000,100.00,0.00,100.00,'fixed',0,100.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 22:16:40','2021-10-03 13:13:56'),(423,512,277,277,1.0000,1300.00,0.00,1300.00,'fixed',0,1300.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:09:23','2021-09-29 13:24:59'),(424,512,1464,1466,1.0000,1950.00,0.00,1950.00,'fixed',0,1950.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:09:23','2021-08-05 23:09:23'),(425,512,1462,1464,1.0000,1750.00,0.00,1750.00,'fixed',0,1750.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:09:23','2021-09-22 16:07:15'),(426,512,1188,1188,1.0000,1800.00,0.00,1800.00,'fixed',0,1800.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:09:23','2021-09-18 14:31:55'),(427,512,1466,1468,1.0000,2000.00,0.00,2000.00,'fixed',0,2000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:09:23','2021-08-05 23:09:23'),(428,512,1208,1208,1.0000,2000.00,0.00,2000.00,'fixed',0,2000.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:09:23','2021-09-01 15:30:23'),(429,513,605,605,1.0000,2075.00,0.00,2075.00,'fixed',0,2075.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(430,513,1467,1469,1.0000,3050.00,0.00,3050.00,'fixed',0,3050.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(431,513,1172,1172,1.0000,3250.00,0.00,3250.00,'fixed',0,3250.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(432,513,1174,1174,1.0000,2050.00,0.00,2050.00,'fixed',0,2050.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(433,513,284,284,1.0000,1450.00,0.00,1450.00,'fixed',0,1450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-09-01 14:28:56'),(434,513,281,281,1.0000,1535.00,0.00,1535.00,'fixed',0,1535.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(435,513,602,602,1.0000,1465.00,0.00,1465.00,'fixed',0,1465.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(436,513,1171,1171,1.0000,3150.00,0.00,3150.00,'fixed',0,3150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(437,513,1173,1173,1.0000,3155.00,0.00,3155.00,'fixed',0,3155.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-09-01 14:28:56'),(438,513,603,603,1.0000,1905.00,0.00,1905.00,'fixed',0,1905.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(439,513,1209,1209,1.0000,2820.00,0.00,2820.00,'fixed',0,2820.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-28 21:40:53'),(440,513,606,606,1.0000,2070.00,0.00,2070.00,'fixed',0,2070.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(441,513,1169,1169,1.0000,4100.00,0.00,4100.00,'fixed',0,4100.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-09-01 18:41:41'),(442,513,1175,1175,1.0000,1600.00,0.00,1600.00,'fixed',0,1600.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:25:38','2021-08-05 23:25:38'),(443,514,974,974,2.0000,3500.00,0.00,3500.00,'fixed',0,3500.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:26:46','2021-08-29 20:49:43'),(444,515,1118,1118,9.0000,2218.00,0.00,2218.00,'fixed',0,2218.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:30:56','2021-10-14 13:37:30'),(445,515,345,345,8.0000,1620.00,0.00,1620.00,'fixed',0,1620.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:30:56','2021-09-30 15:56:57'),(446,515,626,626,2.0000,1951.00,0.00,1951.00,'fixed',0,1951.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:30:56','2021-10-16 21:57:02'),(447,516,500,500,33.0000,1555.00,0.00,1555.00,'fixed',0,1555.00,0.00,NULL,22.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-10-10 13:31:59'),(448,516,356,356,20.0000,1405.00,0.00,1405.00,'fixed',0,1405.00,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-10-03 13:13:56'),(449,516,350,350,6.0000,1305.00,0.00,1305.00,'fixed',0,1305.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-09-17 15:20:02'),(450,516,984,984,16.0000,1688.00,0.00,1688.00,'fixed',0,1688.00,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-10-16 21:57:02'),(451,516,1124,1124,1.0000,1700.00,0.00,1700.00,'fixed',0,1700.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-10-11 14:11:29'),(452,516,357,357,1.0000,1050.00,0.00,1050.00,'fixed',0,1050.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-08-05 23:40:57'),(453,516,782,782,1.0000,1150.00,0.00,1150.00,'fixed',0,1150.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-09-05 14:20:45'),(454,516,353,353,1.0000,1185.00,0.00,1185.00,'fixed',0,1185.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-08-05 23:40:57'),(455,516,351,351,1.0000,1185.00,0.00,1185.00,'fixed',0,1185.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-08-05 23:40:57'),(456,516,354,354,1.0000,1125.00,0.00,1125.00,'fixed',0,1125.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-05 23:40:57','2021-08-05 23:40:57'),(457,517,578,578,48.0000,980.00,0.00,980.00,'fixed',0,980.00,0.00,NULL,21.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:17:33','2021-10-18 21:17:59'),(458,517,363,363,15.0000,670.00,0.00,670.00,'fixed',0,670.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:17:33','2021-08-28 23:54:30'),(459,517,693,693,51.0000,920.00,0.00,920.00,'fixed',0,920.00,0.00,NULL,17.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:17:33','2021-10-18 21:17:59'),(460,517,360,360,4.0000,820.20,0.00,820.20,'fixed',0,820.20,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:17:33','2021-12-28 05:48:52'),(461,517,361,361,2.0000,670.00,0.00,670.00,'fixed',0,670.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:17:33','2021-10-04 14:40:06'),(462,518,365,365,11.0000,800.00,0.00,800.00,'fixed',0,800.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:22:17','2021-09-09 15:11:33'),(463,519,981,981,1.0000,7500.00,0.00,7500.00,'fixed',0,7500.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:27:44','2021-08-28 21:40:53'),(464,519,983,983,1.0000,3960.00,0.00,3960.00,'fixed',0,3960.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:27:44','2021-08-06 00:27:44'),(465,520,447,447,1.0000,2160.00,0.00,2160.00,'fixed',0,2160.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:30:21','2021-08-06 00:30:21'),(466,520,1268,1268,1.0000,7680.00,0.00,7680.00,'fixed',0,7680.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:30:21','2022-12-19 10:56:55'),(467,520,446,446,1.0000,1050.00,0.00,1050.00,'fixed',0,1050.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:30:21','2021-08-06 00:30:21'),(468,521,447,447,1.0000,2160.00,0.00,2160.00,'fixed',0,2160.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 00:44:38','2021-08-06 00:44:38'),(469,522,649,649,4.0000,882.00,0.00,882.00,'fixed',0,882.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:42:33','2021-09-01 16:55:02'),(470,522,1207,1207,10.0000,1092.00,0.00,1092.00,'fixed',0,1092.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:42:33','2021-10-05 16:50:14'),(471,522,323,323,6.0000,1159.00,0.00,1159.00,'fixed',0,1159.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:42:33','2021-10-12 14:17:18'),(472,522,650,650,2.0000,1147.00,0.00,1147.00,'fixed',0,1147.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:42:33','2021-09-01 18:18:23'),(473,522,495,495,2.0000,1512.00,0.00,1512.00,'fixed',0,1512.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:42:33','2021-08-31 21:51:08'),(474,522,1216,1216,3.0000,490.00,0.00,490.00,'fixed',0,490.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:42:33','2021-10-21 14:38:53'),(475,523,1327,1327,1.0000,250.00,0.00,250.00,'fixed',0,250.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-09-01 16:00:20'),(476,523,324,324,1.0000,580.00,0.00,580.00,'fixed',0,580.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-09-28 17:20:48'),(477,523,1205,1205,2.0000,903.00,0.00,903.00,'fixed',0,903.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-09-01 16:51:26'),(478,523,372,372,2.0000,966.00,0.00,966.00,'fixed',0,966.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-09-29 14:22:39'),(479,523,1204,1204,2.0000,806.40,0.00,806.40,'fixed',0,806.40,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-08-30 00:30:10'),(480,523,1468,1470,2.0000,880.00,0.00,880.00,'fixed',0,880.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-08-06 14:52:11'),(481,523,375,375,1.0000,920.00,0.00,920.00,'fixed',0,920.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-09-04 14:41:52'),(482,523,817,817,1.0000,650.00,0.00,650.00,'fixed',0,650.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:52:11','2021-08-06 14:52:11'),(483,524,294,294,2.0000,575.00,0.00,575.00,'fixed',0,575.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:58:56','2021-09-18 14:39:10'),(484,524,1469,1471,1.0000,1800.00,0.00,1800.00,'fixed',0,1800.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:58:56','2021-08-06 14:58:56'),(485,524,1470,1472,1.0000,4300.00,0.00,4300.00,'fixed',0,4300.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:58:56','2021-08-29 16:08:16'),(486,524,1218,1218,1.0000,2600.00,0.00,2600.00,'fixed',0,2600.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:58:56','2021-10-06 14:33:25'),(487,524,369,369,6.0000,2000.00,0.00,2000.00,'fixed',0,2000.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 14:58:56','2021-08-29 20:43:58'),(488,525,1471,1473,1.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-08-06 15:11:37'),(489,525,1472,1474,1.0000,350.00,0.00,350.00,'fixed',0,350.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-08-06 15:11:37'),(490,525,549,549,2.0000,276.53,0.00,276.53,'fixed',0,276.53,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-21 14:39:36'),(491,525,550,550,40.0000,231.45,0.00,231.45,'fixed',0,231.45,0.00,NULL,40.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-25 19:38:29'),(492,525,551,551,4.0000,209.80,0.00,209.80,'fixed',0,209.80,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-16 21:29:05'),(493,525,636,636,15.0000,156.33,0.00,156.33,'fixed',0,156.33,0.00,NULL,9.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-25 19:39:20'),(494,525,635,635,6.0000,171.51,0.00,171.51,'fixed',0,171.51,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-13 15:42:52'),(495,525,637,637,7.0000,130.86,0.00,130.86,'fixed',0,130.86,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-09-01 15:13:42'),(496,525,638,638,12.0000,115.11,0.00,115.11,'fixed',0,115.11,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-16 21:29:05'),(497,525,548,548,8.0000,367.49,0.00,367.49,'fixed',0,367.49,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-16 21:29:05'),(498,525,1473,1475,23.0000,496.00,0.00,496.00,'fixed',0,496.00,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-18 21:09:30'),(499,525,298,298,43.0000,200.00,0.00,200.00,'fixed',0,200.00,0.00,NULL,29.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-10-18 21:09:30'),(500,525,299,299,1.0000,165.00,0.00,165.00,'fixed',0,165.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-08-06 15:11:37'),(501,525,301,301,4.0000,345.00,0.00,345.00,'fixed',0,345.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-08-06 15:11:37'),(502,525,1475,1477,2.0000,255.00,0.00,255.00,'fixed',0,255.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-08-06 15:11:37'),(503,525,300,300,1.0000,743.36,0.00,743.36,'fixed',0,743.36,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:11:37','2021-08-06 15:11:37'),(511,527,543,543,44.0000,36.18,0.00,36.18,'fixed',0,36.18,0.00,NULL,9.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2022-06-19 06:08:59'),(512,527,544,544,50.0000,19.53,0.00,19.53,'fixed',0,19.53,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2022-08-07 04:57:40'),(513,527,545,545,39.0000,18.43,0.00,18.43,'fixed',0,18.43,0.00,NULL,22.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2021-10-23 20:04:07'),(514,527,546,546,2.0000,17.00,0.00,17.00,'fixed',0,17.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2021-08-06 15:15:19'),(515,527,404,404,15.0000,23.50,0.00,23.50,'fixed',0,23.50,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2021-09-04 14:41:52'),(516,527,591,591,4.0000,350.00,0.00,350.00,'fixed',0,350.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2021-09-17 15:09:22'),(517,527,377,377,3.0000,40.00,0.00,40.00,'fixed',0,40.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:15:19','2021-08-31 20:55:50'),(518,528,309,309,34.0000,4.00,0.00,4.00,'fixed',0,4.00,0.00,NULL,29.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:20:55','2021-10-18 21:12:09'),(519,528,1258,1258,12.0000,10.00,0.00,10.00,'fixed',0,10.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:20:55','2021-09-28 15:46:27'),(520,528,673,673,2.0000,130.00,0.00,130.00,'fixed',0,130.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:20:55','2021-08-31 21:19:11'),(521,528,414,414,350.0000,0.46,0.00,0.46,'fixed',0,0.46,0.00,NULL,350.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:20:55','2021-10-10 14:03:24'),(522,529,275,275,9.0000,2200.00,0.00,2200.00,'fixed',0,2200.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:45:48','2021-08-06 15:45:48'),(523,529,1476,1478,2.0000,1.00,0.00,1.00,'fixed',0,1.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:45:48','2021-08-06 15:45:48'),(524,530,502,502,13.0000,1825.00,0.00,1825.00,'fixed',0,1825.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:47:59','2021-10-17 14:01:47'),(525,530,1244,1244,7.0000,1986.67,0.00,1986.67,'fixed',0,1986.67,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:47:59','2021-08-06 15:47:59'),(526,531,370,370,9.0000,4450.00,0.00,4450.00,'fixed',0,4450.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:50:04','2021-10-02 14:26:17'),(527,531,973,973,9.0000,5950.00,0.00,5950.00,'fixed',0,5950.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:50:04','2021-10-09 19:56:42'),(528,532,623,623,10.0000,690.00,0.00,690.00,'fixed',0,690.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-09-28 15:46:27'),(529,532,1220,1220,1.0000,1380.00,0.00,1380.00,'fixed',0,1380.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-08-06 15:56:22'),(530,532,1477,1479,1.0000,1560.00,0.00,1560.00,'fixed',0,1560.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-08-06 15:56:22'),(531,532,1219,1219,2.0000,1280.00,0.00,1280.00,'fixed',0,1280.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-08-06 15:56:22'),(532,532,366,366,4.0000,1280.00,0.00,1280.00,'fixed',0,1280.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-10-08 16:03:31'),(533,532,1236,1236,1.0000,1450.00,0.00,1450.00,'fixed',0,1450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2022-06-19 06:08:59'),(534,532,1478,1480,1.0000,1400.00,0.00,1400.00,'fixed',0,1400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-08-06 15:56:22'),(535,532,1479,1481,1.0000,1500.00,0.00,1500.00,'fixed',0,1500.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:56:22','2021-08-29 22:25:48'),(536,533,1215,1215,1.0000,1720.00,0.00,1720.00,'fixed',0,1720.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:57:37','2021-09-10 14:34:44'),(537,533,503,503,1.0000,1500.00,0.00,1500.00,'fixed',0,1500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 15:57:37','2021-08-06 15:57:37'),(538,534,656,656,8.0000,950.00,0.00,950.00,'fixed',0,950.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:00:48','2021-08-06 16:00:48'),(539,534,367,367,2.0000,1200.00,0.00,1200.00,'fixed',0,1200.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:00:48','2021-08-06 16:00:48'),(540,534,1480,1482,2.0000,1100.00,0.00,1100.00,'fixed',0,1100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:00:48','2021-08-06 16:00:48'),(541,535,597,597,3.0000,475.00,0.00,475.00,'fixed',0,475.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:02:13','2021-09-10 14:21:59'),(542,536,838,838,4.0000,680.00,0.00,680.00,'fixed',0,680.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-09-05 14:20:45'),(543,536,383,383,9.0000,290.00,0.00,290.00,'fixed',0,290.00,0.00,NULL,9.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-10-14 13:34:06'),(544,536,1481,1483,5.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-09-28 15:46:27'),(545,536,1482,1484,7.0000,230.00,0.00,230.00,'fixed',0,230.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-10-03 16:35:16'),(546,536,917,917,1.0000,550.00,0.00,550.00,'fixed',0,550.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-08-29 22:55:16'),(547,536,1483,1485,1.0000,355.00,0.00,355.00,'fixed',0,355.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-08-06 16:11:50'),(548,536,1482,1484,1.0000,220.00,0.00,220.00,'fixed',0,220.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-10-18 21:09:30'),(549,536,1230,1230,1.0000,775.00,0.00,775.00,'fixed',0,775.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-09-01 17:08:47'),(550,536,1484,1486,1.0000,540.00,0.00,540.00,'fixed',0,540.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-08-29 22:55:16'),(551,536,384,384,8.0000,200.00,0.00,200.00,'fixed',0,200.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:11:50','2021-09-01 19:10:42'),(552,537,1485,1487,5.0000,65.00,0.00,65.00,'fixed',0,65.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-31 20:55:50'),(553,537,586,586,3.0000,167.05,0.00,167.05,'fixed',0,167.05,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-09-12 14:13:37'),(554,537,587,587,1.0000,201.21,0.00,201.21,'fixed',0,201.21,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-06 16:22:32'),(555,537,751,751,8.0000,99.77,0.00,99.77,'fixed',0,99.77,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-06 16:22:32'),(556,537,752,752,10.0000,174.75,0.00,174.75,'fixed',0,174.75,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-06 16:22:32'),(557,537,753,753,7.0000,210.00,0.00,210.00,'fixed',0,210.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-09-10 14:19:14'),(558,537,686,686,3.0000,166.00,0.00,166.00,'fixed',0,166.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-28 23:45:05'),(559,537,1486,1488,2.0000,70.00,0.00,70.00,'fixed',0,70.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-09-28 16:29:36'),(560,537,585,585,5.0000,116.00,0.00,116.00,'fixed',0,116.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-09-28 16:38:55'),(561,537,586,586,2.0000,167.05,0.00,167.05,'fixed',0,167.05,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-28 23:45:05'),(562,537,587,587,3.0000,201.21,0.00,201.21,'fixed',0,201.21,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-10-14 13:37:30'),(563,537,1485,1487,8.0000,1.00,0.00,1.00,'fixed',0,1.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:22:32','2021-08-06 16:22:32'),(564,538,1229,1229,58.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,41.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:32:52','2021-10-22 15:12:06'),(565,538,1487,1489,2.0000,310.00,0.00,310.00,'fixed',0,310.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:32:52','2021-08-29 22:15:50'),(566,538,1488,1490,4.0000,120.00,0.00,120.00,'fixed',0,120.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:32:52','2021-08-31 20:32:25'),(567,538,1489,1491,4.0000,215.00,0.00,215.00,'fixed',0,215.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:32:52','2021-09-28 15:46:27'),(568,538,1490,1492,4.0000,130.00,0.00,130.00,'fixed',0,130.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:32:52','2021-09-01 20:49:44'),(569,539,1491,1493,2.0000,400.00,0.00,400.00,'fixed',0,400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(570,539,1492,1494,2.0000,165.00,0.00,165.00,'fixed',0,165.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(571,539,390,390,3.0000,320.00,0.00,320.00,'fixed',0,320.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-14 15:05:28'),(572,539,396,396,5.0000,145.00,0.00,145.00,'fixed',0,145.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-04 15:00:54'),(573,539,671,671,6.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-14 15:05:28'),(574,539,1493,1495,2.0000,210.00,0.00,210.00,'fixed',0,210.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(575,539,395,395,6.0000,120.00,0.00,120.00,'fixed',0,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(576,539,670,670,3.0000,165.00,0.00,165.00,'fixed',0,165.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(577,539,1494,1496,6.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-28 16:29:36'),(578,539,1495,1497,5.0000,80.00,0.00,80.00,'fixed',0,80.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-09 15:11:33'),(579,539,1232,1232,3.0000,190.00,0.00,190.00,'fixed',0,190.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(580,539,667,667,4.0000,230.00,0.00,230.00,'fixed',0,230.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-01 19:13:08'),(581,539,666,666,4.0000,150.00,0.00,150.00,'fixed',0,150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(582,539,393,393,2.0000,230.78,0.00,230.78,'fixed',0,230.78,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(583,539,668,668,1.0000,210.00,0.00,210.00,'fixed',0,210.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(584,539,1496,1498,1.0000,220.00,0.00,220.00,'fixed',0,220.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(585,539,1497,1499,3.0000,350.00,0.00,350.00,'fixed',0,350.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(586,539,1498,1500,3.0000,390.00,0.00,390.00,'fixed',0,390.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-10-02 14:26:17'),(587,539,1499,1501,2.0000,230.00,0.00,230.00,'fixed',0,230.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(588,539,1500,1502,4.0000,240.00,0.00,240.00,'fixed',0,240.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-21 15:56:20'),(589,539,396,396,4.0000,145.00,0.00,145.00,'fixed',0,145.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-20 16:05:15'),(590,539,1501,1503,1.0000,150.00,0.00,150.00,'fixed',0,150.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-29 14:22:39'),(591,539,1502,1504,3.0000,260.00,0.00,260.00,'fixed',0,260.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-09-01 16:22:15'),(592,539,668,668,1.0000,210.00,0.00,210.00,'fixed',0,210.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 16:52:08','2021-08-06 16:52:08'),(593,540,1256,1256,2.0000,380.00,0.00,380.00,'fixed',0,380.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:33:41','2021-08-31 21:19:11'),(594,540,1255,1255,1.0000,285.00,0.00,285.00,'fixed',0,285.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:33:41','2021-09-28 16:29:36'),(595,541,409,409,8.0000,266.92,0.00,266.92,'fixed',0,266.92,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:36:32','2021-09-14 15:06:33'),(596,541,408,408,1.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:36:32','2021-08-06 19:36:32'),(597,541,607,607,7.0000,475.00,0.00,475.00,'fixed',0,475.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:36:32','2021-08-06 19:36:32'),(601,543,914,914,3.0000,286.50,0.00,286.50,'fixed',0,286.50,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:41:07','2021-09-01 15:13:42'),(602,543,576,576,49.0000,105.00,0.00,105.00,'fixed',0,105.00,0.00,NULL,21.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:41:07','2021-10-18 21:17:59'),(603,543,504,504,2.0000,55.00,0.00,55.00,'fixed',0,55.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:41:07','2021-08-06 19:41:07'),(604,543,590,590,1.0000,400.00,0.00,400.00,'fixed',0,400.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:41:07','2021-08-28 23:45:05'),(605,544,958,958,6.0000,80.00,0.00,80.00,'fixed',0,80.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:44:44','2021-08-06 19:44:44'),(606,544,956,956,5.0000,120.00,0.00,120.00,'fixed',0,120.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:44:44','2021-10-28 18:33:26'),(607,544,960,960,1.0000,25.00,0.00,25.00,'fixed',0,25.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:44:44','2021-08-06 19:44:44'),(608,544,959,959,1.0000,500.00,0.00,500.00,'fixed',0,500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 19:44:44','2021-08-06 19:44:44'),(612,546,1503,1505,1.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:05:01','2021-08-06 20:05:01'),(613,546,1504,1506,2.0000,300.00,0.00,300.00,'fixed',0,300.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:05:01','2021-08-06 20:05:01'),(614,546,1505,1507,9.0000,255.00,0.00,255.00,'fixed',0,255.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:05:01','2021-09-01 17:04:46'),(615,546,648,648,2.0000,135.00,0.00,135.00,'fixed',0,135.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:05:01','2021-08-06 20:05:01'),(616,546,1013,1013,3.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:05:01','2021-08-31 20:55:50'),(617,547,559,559,2.0000,120.00,0.00,120.00,'fixed',0,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:10:22','2021-08-06 20:10:22'),(618,547,608,608,6.0000,170.00,0.00,170.00,'fixed',0,170.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:10:22','2021-08-06 20:10:22'),(619,547,1228,1228,7.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:10:22','2021-10-22 14:52:00'),(620,547,1224,1224,16.0000,70.00,0.00,70.00,'fixed',0,70.00,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:10:22','2021-09-28 15:46:27'),(621,547,1227,1227,7.0000,16.00,0.00,16.00,'fixed',0,16.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:10:22','2021-09-01 17:04:46'),(622,547,1225,1225,6.0000,65.00,0.00,65.00,'fixed',0,65.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:10:22','2021-09-20 16:05:15'),(629,549,1506,1508,2.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:22:32','2021-08-06 20:22:32'),(630,549,449,449,1.0000,495.00,0.00,495.00,'fixed',0,495.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:22:32','2021-08-29 22:15:50'),(631,549,507,507,1.0000,770.00,0.00,770.00,'fixed',0,770.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:22:32','2021-09-04 14:53:55'),(632,550,611,611,4.0000,50.00,0.00,50.00,'fixed',0,50.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:23:39','2021-09-29 13:12:33'),(633,550,1507,1509,1.0000,1170.00,0.00,1170.00,'fixed',0,1170.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:23:39','2021-08-06 20:23:39'),(634,550,1508,1510,1.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:23:39','2021-08-06 20:23:39'),(639,552,401,401,10.0000,85.00,0.00,85.00,'fixed',0,85.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:30:59','2021-08-06 20:30:59'),(640,552,399,399,15.0000,160.00,0.00,160.00,'fixed',0,160.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:30:59','2021-10-14 13:34:06'),(641,552,400,400,12.0000,165.00,0.00,165.00,'fixed',0,165.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:30:59','2021-10-22 14:52:00'),(642,552,999,999,8.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:30:59','2021-08-06 20:30:59'),(643,552,596,596,2.0000,160.44,0.00,160.44,'fixed',0,160.44,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:30:59','2021-08-06 20:30:59'),(644,553,1076,1076,1308.0000,25.20,0.00,25.20,'fixed',0,25.20,0.00,NULL,438.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-10-14 13:40:38'),(645,553,1077,1077,2725.0000,18.50,0.00,18.50,'fixed',0,18.50,0.00,NULL,469.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-10-22 15:13:52'),(646,553,1078,1078,981.0000,16.00,0.00,16.00,'fixed',0,16.00,0.00,NULL,240.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-10-10 14:03:24'),(647,553,1079,1079,872.0000,13.00,0.00,13.00,'fixed',0,13.00,0.00,NULL,89.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-09-28 16:29:36'),(648,553,1081,1081,1199.0000,11.40,0.00,11.40,'fixed',0,11.40,0.00,NULL,348.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-12-05 14:04:55'),(649,553,1080,1080,327.0000,16.46,0.00,16.46,'fixed',0,16.46,0.00,NULL,165.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-10-16 21:32:51'),(650,553,993,993,218.0000,17.30,0.00,17.30,'fixed',0,17.30,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-08-06 20:38:32'),(651,553,1090,1090,327.0000,27.17,0.00,27.17,'fixed',0,27.17,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-09-29 13:12:33'),(652,553,1003,1003,218.0000,27.13,0.00,27.13,'fixed',0,27.13,0.00,NULL,180.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:38:32','2021-09-18 14:42:15'),(653,554,1076,1076,335.0000,25.20,0.00,25.20,'fixed',0,25.20,0.00,NULL,119.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-10-08 16:03:31'),(654,554,1077,1077,80.0000,18.50,0.00,18.50,'fixed',0,18.50,0.00,NULL,60.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-08-28 23:45:05'),(655,554,1078,1078,20.0000,16.00,0.00,16.00,'fixed',0,16.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-08-06 20:43:53'),(656,554,1079,1079,80.0000,13.00,0.00,13.00,'fixed',0,13.00,0.00,NULL,80.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-08-28 23:45:05'),(657,554,1081,1081,100.0000,11.40,0.00,11.40,'fixed',0,11.40,0.00,NULL,20.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-09-01 14:28:56'),(658,554,1080,1080,30.0000,16.46,0.00,16.46,'fixed',0,16.46,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-08-06 20:43:53'),(659,554,519,519,70.0000,29.32,0.00,29.32,'fixed',0,29.32,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-09-19 15:54:39'),(660,554,1090,1090,90.0000,27.17,0.00,27.17,'fixed',0,27.17,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-08-06 20:43:53'),(661,554,1002,1002,70.0000,50.69,0.00,50.69,'fixed',0,50.69,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:43:53','2021-08-06 20:43:53'),(662,555,412,412,8.0000,275.00,0.00,275.00,'fixed',0,275.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:45:14','2021-09-01 20:13:05'),(663,556,416,416,2.0000,18.16,0.00,18.16,'fixed',0,18.16,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-08-06 20:50:35'),(664,556,426,426,9.0000,19.55,0.00,19.55,'fixed',0,19.55,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-08-06 20:50:35'),(665,556,421,421,10.0000,24.36,0.00,24.36,'fixed',0,24.36,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-08-06 20:50:35'),(666,556,407,407,23.0000,21.36,0.00,21.36,'fixed',0,21.36,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-10-10 14:03:24'),(667,556,429,429,59.0000,17.82,0.00,17.82,'fixed',0,17.82,0.00,NULL,16.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-10-18 21:12:09'),(668,556,1509,1511,7.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-08-06 20:50:35'),(669,556,574,574,10.0000,32.20,0.00,32.20,'fixed',0,32.20,0.00,NULL,9.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 20:50:35','2021-10-20 19:07:20'),(670,557,577,577,13.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(671,557,1510,1512,10.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(672,557,1511,1513,21.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-10-16 21:43:18'),(673,557,427,427,7.0000,25.35,0.00,25.35,'fixed',0,25.35,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-08 19:50:40'),(674,557,573,573,7.0000,19.03,0.00,19.03,'fixed',0,19.03,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-01 20:49:44'),(675,557,1512,1514,9.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,7.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-10-03 16:35:16'),(676,557,515,515,2.0000,13.90,0.00,13.90,'fixed',0,13.90,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-01 18:18:23'),(677,557,1513,1515,11.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-10-09 19:31:37'),(678,557,1356,1356,14.0000,29.66,0.00,29.66,'fixed',0,29.66,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(679,557,1514,1516,13.0000,25.00,0.00,25.00,'fixed',0,25.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(680,557,1337,1337,8.0000,120.00,0.00,120.00,'fixed',0,120.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(681,557,1515,1517,3.0000,1800.00,0.00,1800.00,'fixed',0,1800.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(682,557,583,583,17.0000,75.20,0.00,75.20,'fixed',0,75.20,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-10-03 13:13:56'),(683,557,629,629,5.0000,60.00,0.00,60.00,'fixed',0,60.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-28 23:18:28'),(684,557,1516,1518,1.0000,10.00,0.00,10.00,'fixed',0,10.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-01 15:13:42'),(685,557,1517,1519,2.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(686,557,1518,1520,4.0000,70.00,0.00,70.00,'fixed',0,70.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-18 14:42:15'),(687,557,430,430,1.0000,24.90,0.00,24.90,'fixed',0,24.90,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-29 15:42:14'),(688,557,893,893,13.0000,13.06,0.00,13.06,'fixed',0,13.06,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-01 18:28:33'),(689,557,425,425,42.0000,20.75,0.00,20.75,'fixed',0,20.75,0.00,NULL,21.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-10-12 14:17:18'),(690,557,420,420,54.0000,24.07,0.00,24.07,'fixed',0,24.07,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-09-30 15:56:57'),(691,557,407,407,6.0000,21.36,0.00,21.36,'fixed',0,21.36,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(692,557,1519,1521,25.0000,17.00,0.00,17.00,'fixed',0,17.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(693,557,419,419,54.0000,23.00,0.00,23.00,'fixed',0,23.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(694,557,423,423,12.0000,37.00,0.00,37.00,'fixed',0,37.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(695,557,1522,1524,18.0000,22.00,0.00,22.00,'fixed',0,22.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:16:57','2021-08-06 22:16:57'),(696,558,516,516,7.0000,49.57,0.00,49.57,'fixed',0,49.57,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2022-11-21 17:23:30'),(697,558,433,433,42.0000,55.99,0.00,55.99,'fixed',0,55.99,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-09-04 14:41:52'),(698,558,1523,1525,2.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-08-06 22:21:43'),(699,558,436,436,1.0000,20.81,0.00,20.81,'fixed',0,20.81,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-09-01 18:26:50'),(700,558,1524,1526,8.0000,17.00,0.00,17.00,'fixed',0,17.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-08-06 22:21:43'),(701,558,434,434,4.0000,13.00,0.00,13.00,'fixed',0,13.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-08-28 22:18:43'),(702,558,437,437,7.0000,9.43,0.00,9.43,'fixed',0,9.43,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-10-16 21:43:18'),(703,558,575,575,41.0000,8.04,0.00,8.04,'fixed',0,8.04,0.00,NULL,41.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:21:43','2021-10-10 14:03:24'),(704,559,483,483,1.0000,33900.00,0.00,33900.00,'fixed',0,33900.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(705,559,489,489,1.0000,39150.00,0.00,39150.00,'fixed',0,39150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(706,559,474,474,7.0000,33843.00,0.00,33843.00,'fixed',0,33843.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2023-03-28 16:45:14'),(707,559,482,482,1.0000,32900.00,0.00,32900.00,'fixed',0,32900.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(708,559,476,476,1.0000,30000.00,0.00,30000.00,'fixed',0,30000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(709,559,487,487,4.0000,30000.00,0.00,30000.00,'fixed',0,30000.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2023-03-26 07:44:18'),(710,559,480,480,1.0000,28600.00,0.00,28600.00,'fixed',0,28600.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(711,559,481,481,1.0000,28600.00,0.00,28600.00,'fixed',0,28600.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(712,559,488,488,2.0000,27000.00,0.00,27000.00,'fixed',0,27000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(713,559,479,479,1.0000,26600.00,0.00,26600.00,'fixed',0,26600.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(714,559,473,473,1.0000,26200.00,0.00,26200.00,'fixed',0,26200.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(715,559,478,478,1.0000,26100.00,0.00,26100.00,'fixed',0,26100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(716,559,486,486,2.0000,25000.00,0.00,25000.00,'fixed',0,25000.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(717,559,485,485,1.0000,24500.00,0.00,24500.00,'fixed',0,24500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(718,559,490,490,1.0000,23500.00,0.00,23500.00,'fixed',0,23500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(719,559,477,477,1.0000,22100.00,0.00,22100.00,'fixed',0,22100.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(720,559,484,484,1.0000,19500.00,0.00,19500.00,'fixed',0,19500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(721,559,475,475,1.0000,32050.00,0.00,32050.00,'fixed',0,32050.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:28:29','2021-08-06 22:28:29'),(722,560,491,491,2.0000,12480.00,0.00,12480.00,'fixed',0,12480.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:30:17','2022-03-30 15:41:52'),(723,560,271,271,1.0000,10350.00,0.00,10350.00,'fixed',0,10350.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:30:17','2021-08-06 22:30:17'),(724,560,272,272,1.0000,7750.00,0.00,7750.00,'fixed',0,7750.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:30:17','2021-08-06 22:30:17'),(725,560,273,273,1.0000,7200.00,0.00,7200.00,'fixed',0,7200.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:30:17','2021-08-06 22:30:17'),(726,561,498,498,37.0000,316.00,0.00,316.00,'fixed',0,316.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:33:18','2023-03-28 16:45:55'),(727,562,860,860,1.0000,1375.00,0.00,1375.00,'fixed',0,1375.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-06 22:34:51','2021-08-06 22:34:51'),(728,563,723,723,1.0000,605.00,0.00,605.00,'fixed',0,605.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(729,563,775,775,1.0000,3586.00,0.00,3586.00,'fixed',0,3586.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(730,563,1021,1021,1.0000,1048.00,0.00,1048.00,'fixed',0,1048.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(731,563,264,264,2.0000,150.00,0.00,150.00,'fixed',0,150.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-31 20:55:50'),(732,563,451,451,27.0000,2.23,0.00,2.23,'fixed',0,2.23,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(733,563,263,263,18.0000,4.00,0.00,4.00,'fixed',0,4.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(734,563,240,240,2.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-10-02 14:26:17'),(735,563,317,317,5.0000,60.00,0.00,60.00,'fixed',0,60.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2023-01-09 06:43:54'),(736,563,318,318,4.0000,140.00,0.00,140.00,'fixed',0,140.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(737,563,377,377,1.0000,40.00,0.00,40.00,'fixed',0,40.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(738,563,309,309,15.0000,4.00,0.00,4.00,'fixed',0,4.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(739,563,576,576,1.0000,105.00,0.00,105.00,'fixed',0,105.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(740,563,611,611,1.0000,50.00,0.00,50.00,'fixed',0,50.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:03:53','2021-08-07 14:03:53'),(741,564,1525,1527,327.0000,44.76,0.00,44.76,'fixed',0,44.76,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:19:27','2021-08-07 14:19:27'),(742,565,1526,1528,1.0000,63400.00,0.00,63400.00,'fixed',0,63400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:51:40','2021-08-07 14:51:40'),(743,565,1527,1529,2.0000,55022.00,0.00,55022.00,'fixed',0,55022.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:51:40','2021-08-07 14:51:40'),(744,565,794,794,2.0000,62653.00,0.00,62653.00,'fixed',0,62653.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:51:40','2021-08-07 14:51:40'),(745,565,795,795,2.0000,31420.30,0.00,31420.30,'fixed',0,31420.30,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-07 14:51:40','2021-08-07 14:51:40'),(746,566,1237,1237,12.0000,28.00,0.00,28.00,'fixed',0,28.00,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(747,566,1529,1531,1.0000,55.00,0.00,55.00,'fixed',0,55.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(748,566,1365,1365,12.0000,9.00,0.00,9.00,'fixed',0,9.00,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(749,566,1364,1364,12.0000,9.00,0.00,9.00,'fixed',0,9.00,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(750,566,738,738,8.0000,54.00,0.00,54.00,'fixed',0,54.00,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(751,566,1265,1265,1.0000,48.00,0.00,48.00,'fixed',0,48.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(752,566,631,631,1.0000,18.00,0.00,18.00,'fixed',0,18.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-08-28 23:18:28'),(753,566,590,590,2.0000,409.50,0.00,409.50,'fixed',0,409.50,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:28:32','2021-09-01 19:10:41'),(754,567,1530,1532,1.0000,23880.00,0.00,23880.00,'fixed',0,23880.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:32:43','2021-08-14 14:32:43'),(755,567,1531,1533,1.0000,53750.00,0.00,53750.00,'fixed',0,53750.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:32:43','2021-08-29 23:01:00'),(756,567,1285,1285,1.0000,22570.00,0.00,22570.00,'fixed',0,22570.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:32:43','2021-08-28 21:48:23'),(757,567,1354,1354,2.0000,1790.00,0.00,1790.00,'fixed',0,1790.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:32:43','2021-08-31 20:45:22'),(758,568,75,75,5.0000,2052.00,0.00,2052.00,'fixed',0,2052.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:34:56','2021-10-22 14:52:32'),(759,568,1052,1052,1.0000,18805.00,0.00,18805.00,'fixed',0,18805.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:34:56','2021-09-01 15:06:20'),(760,569,904,904,12.0000,388.22,0.00,388.22,'fixed',0,388.22,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:37:54','2021-10-18 21:09:30'),(761,569,1214,1214,12.0000,423.00,0.00,423.00,'fixed',0,423.00,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:37:54','2021-09-12 14:25:45'),(762,570,882,882,60.0000,19.04,0.00,19.04,'fixed',0,19.04,0.00,NULL,60.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:43:01','2021-10-10 14:03:24'),(763,570,883,883,24.0000,21.15,0.00,21.15,'fixed',0,21.15,0.00,NULL,9.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:43:01','2022-02-20 08:24:24'),(764,570,885,885,24.0000,24.75,0.00,24.75,'fixed',0,24.75,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:43:01','2022-02-17 07:24:30'),(765,570,909,909,12.0000,23.27,0.00,23.27,'fixed',0,23.27,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:43:01','2021-10-16 21:43:18'),(766,570,23,23,20.0000,211.50,0.00,211.50,'fixed',0,211.50,0.00,NULL,20.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:43:01','2021-09-08 21:25:36'),(767,571,1532,1534,3.0000,11674.34,0.00,11674.34,'fixed',0,11674.34,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:45:53','2021-08-14 14:45:53'),(768,572,1533,1535,10.0000,3534.30,0.00,3534.30,'fixed',0,3534.30,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:48:42','2021-10-25 19:38:29'),(769,572,1296,1296,10.0000,3575.00,0.00,3575.00,'fixed',0,3575.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:48:42','2021-08-14 14:48:42'),(770,573,1534,1536,2.0000,31593.00,0.00,31593.00,'fixed',0,31593.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:54:10','2021-09-17 14:29:05'),(771,573,1536,1538,1.0000,20390.00,0.00,20390.00,'fixed',0,20390.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:54:10','2021-09-01 18:54:34'),(772,573,1535,1537,1.0000,22122.00,0.00,22122.00,'fixed',0,22122.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:54:10','2021-08-29 23:01:53'),(773,573,1537,1539,1.0000,11366.00,0.00,11366.00,'fixed',0,11366.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 14:54:10','2021-08-14 14:54:10'),(774,574,1538,1540,1.0000,5757.50,0.00,5757.50,'fixed',0,5757.50,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 15:44:39','2021-08-14 15:44:39'),(775,574,1539,1541,1.0000,7312.00,0.00,7312.00,'fixed',0,7312.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 15:44:39','2021-08-14 15:44:39'),(776,575,863,863,24.0000,669.88,0.00,669.88,'fixed',0,669.88,0.00,NULL,24.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 15:47:59','2021-10-04 14:40:06'),(777,575,1540,1542,32.0000,722.09,0.00,722.09,'fixed',0,722.09,0.00,NULL,25.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 15:47:59','2021-10-11 14:11:29'),(778,575,1185,1185,7.0000,3210.00,0.00,3210.00,'fixed',0,3210.00,0.00,NULL,4.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 15:47:59','2021-10-18 21:12:09'),(779,576,768,768,4.0000,11850.00,0.00,11850.00,'fixed',0,11850.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 15:50:16','2021-09-01 16:22:15'),(780,582,243,243,4000.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,4000.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 21:54:16','2021-09-30 15:56:57'),(781,582,244,244,2000.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,657.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-14 21:54:16','2021-10-18 21:17:59'),(782,586,937,937,3.0000,2750.00,0.00,2750.00,'fixed',0,2750.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-16 13:50:58','2021-10-12 14:17:18'),(783,587,1306,1306,1.0000,20805.00,0.00,20805.00,'fixed',0,20805.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-17 22:42:39','2021-08-31 20:32:25'),(784,587,1354,1354,2.0000,1790.00,0.00,1790.00,'fixed',0,1790.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-17 22:42:39','2021-10-05 16:52:28'),(785,588,1306,1306,1.0000,20805.00,0.00,20805.00,'fixed',0,20805.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-17 22:56:06','2021-09-01 15:06:20'),(786,588,1383,1385,1.0000,27630.00,0.00,27630.00,'fixed',0,27630.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-17 22:56:06','2021-09-01 15:06:20'),(787,588,1541,1543,1.0000,31290.00,0.00,31290.00,'fixed',0,31290.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-17 22:56:06','2021-08-29 20:49:43'),(788,589,1348,1348,1.0000,2550.00,0.00,2550.00,'fixed',0,2550.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-18 13:19:44','2021-10-08 16:08:36'),(789,589,1542,1544,1.0000,2150.00,0.00,2150.00,'fixed',0,2150.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-18 13:19:44','2021-08-18 13:19:44'),(790,589,1543,1545,2.0000,2600.00,0.00,2600.00,'fixed',0,2600.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-18 13:19:44','2021-09-01 15:13:42'),(791,589,1544,1546,2.0000,650.00,0.00,650.00,'fixed',0,650.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-18 13:19:44','2021-09-08 20:35:46'),(792,589,1545,1547,2.0000,650.00,0.00,650.00,'fixed',0,650.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-18 13:19:44','2021-09-28 15:28:25'),(793,590,706,706,30.0000,12.00,0.00,12.00,'fixed',0,12.00,0.00,NULL,25.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-10-24 13:55:25'),(794,590,260,260,30.0000,110.00,0.00,110.00,'fixed',0,110.00,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-10-21 14:40:01'),(795,590,855,855,2.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-08-20 15:45:23'),(796,590,1067,1067,16.0000,155.00,0.00,155.00,'fixed',0,155.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-08-20 15:45:23'),(797,590,555,555,100.0000,28.00,0.00,28.00,'fixed',0,28.00,0.00,NULL,17.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-10-06 14:33:25'),(798,590,1066,1066,40.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-10-24 13:55:25'),(799,590,1546,1548,20.0000,110.00,0.00,110.00,'fixed',0,110.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-10-24 13:55:25'),(800,590,1072,1072,20.0000,65.00,0.00,65.00,'fixed',0,65.00,0.00,NULL,20.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-10-12 14:17:18'),(801,590,1073,1073,20.0000,60.00,0.00,60.00,'fixed',0,60.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-08-20 15:45:23'),(802,590,803,803,50.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-08-20 15:45:23'),(803,590,1546,1548,20.0000,110.00,0.00,110.00,'fixed',0,110.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:45:23','2021-08-20 15:45:23'),(804,591,1547,1549,1.0000,5450.00,0.00,5450.00,'fixed',0,5450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:47:54','2021-09-01 15:06:20'),(805,592,1306,1306,1.0000,20945.00,0.00,20945.00,'fixed',0,20945.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-20 15:48:43','2021-09-01 16:56:50'),(806,593,75,75,1.0000,2052.00,0.00,2052.00,'fixed',0,2052.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-21 13:26:56','2021-08-21 13:26:56'),(807,593,70,70,1.0000,2295.00,0.00,2295.00,'fixed',0,2295.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-21 13:26:56','2021-09-01 17:04:46'),(808,593,541,541,1.0000,780.00,0.00,780.00,'fixed',0,780.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-21 13:26:56','2021-08-31 21:45:17'),(809,593,969,969,1.0000,750.00,0.00,750.00,'fixed',0,750.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-21 13:26:56','2021-09-08 20:59:01'),(810,594,234,234,20.0000,90.00,0.00,90.00,'fixed',0,90.00,0.00,NULL,17.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-23 16:28:33','2021-10-12 14:17:18'),(811,594,235,235,5.0000,190.00,0.00,190.00,'fixed',0,190.00,0.00,NULL,3.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-23 16:28:33','2021-10-16 21:43:18'),(812,595,897,897,12.0000,112.92,0.00,112.92,'fixed',0,112.92,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-23 16:31:18','2021-09-08 21:24:17'),(813,595,898,898,12.0000,156.92,0.00,156.92,'fixed',0,156.92,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-23 16:31:18','2021-09-12 14:12:08'),(814,602,1167,1167,1.0000,26340.00,0.00,26340.00,'fixed',0,26340.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:12:41','2021-09-28 16:34:07'),(815,602,1549,1551,1.0000,18680.00,0.00,18680.00,'fixed',0,18680.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:12:41','2021-09-01 16:56:06'),(816,602,1120,1120,1.0000,21240.00,0.00,21240.00,'fixed',0,21240.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:12:41','2021-09-15 14:30:25'),(817,602,777,777,10.0000,1710.00,0.00,1710.00,'fixed',0,1710.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:12:41','2021-09-01 19:10:41'),(818,603,1382,1384,1.0000,25070.00,0.00,25070.00,'fixed',0,25070.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:13:53','2021-08-25 16:13:53'),(819,603,1548,1550,1.0000,28720.00,0.00,28720.00,'fixed',0,28720.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:13:53','2021-09-01 16:22:15'),(820,603,1349,1349,1.0000,1705.00,0.00,1705.00,'fixed',0,1705.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-25 16:13:53','2021-09-01 17:08:47'),(821,604,1550,1552,1.0000,28400.00,0.00,28400.00,'fixed',0,28400.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-28 14:52:26','2021-09-22 16:12:55'),(822,604,1549,1551,1.0000,18650.00,0.00,18650.00,'fixed',0,18650.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-28 14:52:26','2021-09-01 18:28:33'),(823,604,893,893,1.0000,15.00,0.00,15.00,'fixed',0,15.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-28 14:52:26','2021-09-01 19:24:54'),(824,619,410,410,50.0000,22.21,0.00,22.21,'fixed',0,22.21,0.00,NULL,24.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-28 22:07:31','2021-09-17 15:09:22'),(825,621,413,413,5000.0000,0.79,0.00,0.79,'fixed',0,0.79,0.00,NULL,230.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-28 23:01:46','2021-10-16 21:43:18'),(826,625,522,522,70.0000,40.00,0.00,40.00,'fixed',0,40.00,0.00,NULL,24.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-28 23:26:43','2021-09-14 15:06:33'),(827,628,1551,1553,3.0000,220.00,0.00,220.00,'fixed',0,220.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 15:22:33','2021-08-29 15:22:33'),(828,628,1553,1555,3.0000,260.00,0.00,260.00,'fixed',0,260.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 15:22:33','2021-10-06 14:35:08'),(829,628,1552,1554,3.0000,305.00,0.00,305.00,'fixed',0,305.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 15:22:33','2021-10-09 20:34:09'),(830,636,1061,1061,15.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,15.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 15:54:36','2021-09-01 14:28:56'),(831,636,550,550,2.0000,340.00,0.00,340.00,'fixed',0,340.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 15:54:36','2021-10-25 19:38:29'),(832,636,897,897,2.0000,155.00,0.00,155.00,'fixed',0,155.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 15:54:36','2021-09-08 21:24:17'),(833,653,1059,1059,18.0000,1030.00,0.00,1030.00,'fixed',0,1030.00,0.00,NULL,18.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-29 22:44:53','2021-08-31 21:51:08'),(834,665,409,409,1.0000,250.00,0.00,250.00,'fixed',0,250.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-30 00:37:00','2021-10-10 14:03:24'),(835,665,914,914,1.0000,400.00,0.00,400.00,'fixed',0,400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-30 00:37:00','2021-08-30 00:37:00'),(836,665,1064,1064,1.0000,1400.00,0.00,1400.00,'fixed',0,1400.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-30 00:37:00','2021-08-30 00:37:00'),(837,666,1139,1139,1.0000,865.00,0.00,865.00,'fixed',0,865.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-31 13:25:23','2021-09-01 17:08:47'),(838,666,1349,1349,1.0000,1820.00,0.00,1820.00,'fixed',0,1820.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-31 13:25:23','2021-09-02 16:10:46'),(839,675,1554,1556,6.0000,80.00,0.00,80.00,'fixed',0,80.00,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-31 20:49:18','2021-09-18 14:31:55'),(840,675,1555,1557,12.0000,75.00,0.00,75.00,'fixed',0,75.00,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-31 20:49:18','2021-09-29 14:22:39'),(841,697,1061,1061,15.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,15.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-08-31 21:32:01','2021-09-01 16:28:22'),(842,703,1113,1113,1.0000,25002.00,0.00,25002.00,'fixed',0,25002.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 14:05:42','2021-10-10 13:26:53'),(843,703,1541,1543,1.0000,31568.00,0.00,31568.00,'fixed',0,31568.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 14:05:42','2021-10-05 16:49:34'),(844,703,104,104,1.0000,1225.00,0.00,1225.00,'fixed',0,1225.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 14:05:42','2021-09-11 15:02:11'),(845,704,673,673,2.0000,130.00,0.00,130.00,'fixed',0,130.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 14:07:55','2021-09-01 14:28:56'),(846,708,1059,1059,20.0000,1030.00,0.00,1030.00,'fixed',0,1030.00,0.00,NULL,20.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 14:34:19','2021-09-01 19:13:08'),(847,711,1200,1200,5.0000,20.00,0.00,20.00,'fixed',0,20.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 15:02:57','2021-09-12 14:12:08'),(848,716,1383,1385,1.0000,27625.00,0.00,27625.00,'fixed',0,27625.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 15:23:56','2021-09-01 15:30:23'),(849,717,1383,1385,1.0000,27600.00,0.00,27600.00,'fixed',0,27600.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 15:24:38','2021-09-29 13:17:16'),(850,723,1547,1549,1.0000,5450.00,0.00,5450.00,'fixed',0,5450.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 15:45:54','2021-09-01 19:53:23'),(851,745,1063,1063,1.0000,2400.00,0.00,2400.00,'fixed',0,2400.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 16:46:00','2021-09-01 16:46:48'),(852,754,1005,1005,1.0000,1510.00,0.00,1510.00,'fixed',0,1510.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 17:07:16','2021-09-01 17:08:47'),(853,755,1061,1061,15.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,15.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 17:08:07','2021-09-04 14:46:29'),(854,775,974,974,5.0000,3600.00,0.00,3600.00,'fixed',0,3600.00,0.00,NULL,5.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 18:44:49','2021-09-28 15:28:25'),(855,777,1556,1558,1.0000,10995.00,0.00,10995.00,'fixed',0,10995.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 18:52:36','2021-09-01 18:52:36'),(856,777,1557,1559,1.0000,11870.00,0.00,11870.00,'fixed',0,11870.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 18:52:36','2021-09-01 18:53:50'),(857,781,1060,1060,10.0000,1030.00,0.00,1030.00,'fixed',0,1030.00,0.00,NULL,10.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 19:01:19','2021-09-08 21:02:09'),(858,784,472,472,24.0000,28.75,0.00,28.75,'fixed',0,28.75,0.00,NULL,24.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 19:15:34','2021-09-08 19:50:40'),(859,798,1059,1059,1.0000,1030.00,0.00,1030.00,'fixed',0,1030.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-01 21:07:08','2021-09-04 14:55:26'),(860,801,855,855,8.0000,98.18,0.00,98.18,'fixed',0,98.18,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-02 15:31:07','2021-09-02 15:31:07'),(861,801,1443,1445,8.0000,180.00,0.00,180.00,'fixed',0,180.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-02 15:31:07','2021-10-17 14:01:47'),(862,803,791,791,1.0000,6109.38,0.00,6109.38,'fixed',0,6109.38,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-02 15:50:33','2021-09-02 15:50:33'),(863,803,1536,1538,1.0000,20390.00,0.00,20390.00,'fixed',0,20390.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-02 15:50:33','2021-09-02 15:50:33'),(864,804,23,23,12.0000,211.50,0.00,211.50,'fixed',0,211.50,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-02 15:55:41','2021-10-16 21:32:51'),(865,806,650,650,2.0000,1134.00,0.00,1134.00,'fixed',0,1134.00,0.00,NULL,2.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:34:44','2021-10-07 16:27:35'),(866,806,1328,1328,1.0000,924.00,0.00,924.00,'fixed',0,924.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:34:44','2021-09-04 14:34:44'),(867,807,1052,1052,1.0000,18820.00,0.00,18820.00,'fixed',0,18820.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:35:36','2021-09-04 14:41:52'),(868,807,1181,1181,1.0000,18820.00,0.00,18820.00,'fixed',0,18820.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:35:36','2021-09-29 14:30:45'),(869,807,1354,1354,2.0000,1790.00,0.00,1790.00,'fixed',0,1790.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:35:36','2021-10-05 16:52:28'),(870,809,1061,1061,26.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,26.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:45:03','2021-09-14 15:17:04'),(871,809,1059,1059,23.0000,1035.00,0.00,1035.00,'fixed',0,1035.00,0.00,NULL,23.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:45:03','2021-09-17 15:20:02'),(872,809,1065,1065,1.0000,2950.00,0.00,2950.00,'fixed',0,2950.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:45:03','2021-09-05 14:19:05'),(873,809,243,243,205.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,205.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:45:03','2021-09-30 15:56:57'),(874,810,243,243,1028.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,1028.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-04 14:45:49','2021-10-06 14:36:29'),(875,827,243,243,514.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,514.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-06 18:49:39','2021-10-12 14:28:07'),(876,828,454,454,1.0000,3300.00,0.00,3300.00,'fixed',0,3300.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 13:55:16','2021-09-08 13:58:46'),(877,847,897,897,12.0000,112.80,0.00,112.80,'fixed',0,112.80,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-09-14 14:19:26'),(878,847,898,898,12.0000,156.98,0.00,156.98,'fixed',0,156.98,0.00,NULL,8.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-10-11 14:11:29'),(879,847,905,905,12.0000,125.02,0.00,125.02,'fixed',0,125.02,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-10-21 14:38:53'),(880,847,899,899,12.0000,179.54,0.00,179.54,'fixed',0,179.54,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-09-28 16:13:45'),(881,847,901,901,12.0000,211.50,0.00,211.50,'fixed',0,211.50,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-09-22 16:07:15'),(882,847,1193,1193,6.0000,275.42,0.00,275.42,'fixed',0,275.42,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-09-18 14:31:55'),(883,847,903,903,24.0000,34.78,0.00,34.78,'fixed',0,34.78,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-09-12 14:33:32'),(884,847,1214,1214,12.0000,404.20,0.00,404.20,'fixed',0,404.20,0.00,NULL,6.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:15:41','2021-10-10 13:26:39'),(885,848,882,882,60.0000,19.04,0.00,19.04,'fixed',0,19.04,0.00,NULL,12.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:19:38','2021-10-14 13:34:06'),(886,848,472,472,48.0000,30.16,0.00,30.16,'fixed',0,30.16,0.00,NULL,20.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:19:38','2022-02-20 08:29:58'),(887,848,894,894,24.0000,14.10,0.00,14.10,'fixed',0,14.10,0.00,NULL,11.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:19:38','2022-02-24 03:21:35'),(888,848,972,972,24.0000,26.79,0.00,26.79,'fixed',0,26.79,0.00,NULL,19.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:19:38','2021-10-25 19:38:29'),(889,848,893,893,60.0000,12.69,0.00,12.69,'fixed',0,12.69,0.00,NULL,28.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:19:38','2021-10-22 14:52:00'),(890,848,891,891,12.0000,45.00,0.00,45.00,'fixed',0,45.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:19:38','2021-10-10 14:03:24'),(891,852,243,243,514.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,514.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:29:34','2021-10-20 19:07:20'),(892,853,1060,1060,25.0000,1040.00,0.00,1040.00,'fixed',0,1040.00,0.00,NULL,25.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:31:35','2021-10-20 19:07:20'),(893,854,1061,1061,13.0000,1038.46,0.00,1038.46,'fixed',0,1038.46,0.00,NULL,13.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:34:03','2021-09-20 16:10:17'),(894,854,1063,1063,1.0000,2500.00,0.00,2500.00,'fixed',0,2500.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:34:03','2021-09-08 21:34:03'),(895,855,243,243,515.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,515.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:36:47','2021-10-20 19:07:20'),(896,856,244,244,105.0000,0.97,0.00,0.97,'fixed',0,0.97,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-08 21:39:05','2021-09-08 21:39:05'),(897,857,1388,1390,1.0000,28420.00,0.00,28420.00,'fixed',0,28420.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:24:52','2021-09-09 14:24:52'),(898,857,1046,1046,1.0000,21200.00,0.00,21200.00,'fixed',0,21200.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:24:52','2021-09-28 16:34:07'),(899,857,1380,1382,1.0000,17190.00,0.00,17190.00,'fixed',0,17190.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:24:52','2021-09-09 14:24:52'),(900,858,824,824,2.0000,1870.00,0.00,1870.00,'fixed',0,1870.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:29:16','2021-09-09 14:29:16'),(901,858,1558,1560,1.0000,1745.00,0.00,1745.00,'fixed',0,1745.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:29:16','2021-09-09 14:29:16'),(902,858,54,54,2.0000,1705.00,0.00,1705.00,'fixed',0,1705.00,0.00,NULL,0.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:29:16','2021-09-09 14:29:16'),(903,858,58,58,2.0000,1340.00,0.00,1340.00,'fixed',0,1340.00,0.00,NULL,1.0000,0.0000,0.0000,NULL,NULL,NULL,0,0,'2021-09-09 14:29:16','2021-10-03 13:13:56'),(904,858,151,151,1.0000,1505.00,0.00,1505.00,'