
<?php $__env->startSection('title', __('Income Expenditure Account')); ?>

<?php $__env->startSection('content'); ?>

<section class="content-header">
    <h1>Income Expenditure Account</h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
        <div class="box-header">
            <h3>Income Expenditure Account</h3>
            <a class="btn btn-info btn-sm no-print" onclick="window.print();">Print</a>
        </div>
        <div class="box-body">

            <div class="row">
                
                <div class="col-md-8 col-md-offset-2">
                    <div class="table-responsive">
                    	<table class="table table-bordered table-striped text-center">
                			<tr>
                				<th>Total Sell</th>
                                <td><?php echo e($total_sell); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>(-) Due </th>
                			    <td><?php echo e($total_sell - $total_paid); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>Total Balance </th>
                			    <td><?php echo e($total_paid); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>(+) Due paid</th>
                			    <td><?php echo e($total_due_paid); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>= </th>
                			    <td><?php echo e($total_paid + $total_due_paid); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>(-) Cash Transfer</th>
                			    <td><?php echo e($total_transfer); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>= </th>
                			    <td><?php echo e($total_paid + $total_due_paid - $total_transfer); ?></td>
                			</tr>
                			
                			
                			<tr>
                			    <th>(+) Cash Received</th>
                			    <td><?php echo e($total_receive); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>= </th>
                			    <td><?php echo e($total_paid + $total_due_paid + $total_receive - $total_transfer); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>(+) Cash In Hand</th>
                			    <td><?php echo e($cash_in_hand); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>= </th>
                			    <td><?php echo e($total_paid + $total_due_paid + $total_receive + $cash_in_hand - $total_transfer); ?></td>
                			</tr>
                			
                			<tr>
                			    <th>(-) Expense</th>
                			    <td><?php echo e($expense); ?></td>
                			</tr>
                			
                			<tr>
                			    <th> Closing Balance </th>
                			    <td><?php echo e($total_paid + $total_due_paid + $total_receive + $cash_in_hand - $total_transfer - $expense); ?></td>
                			</tr>
                			
                			
                			
                			
                			
                    	</table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $('#datepicker, #datepicker1').datepicker({  format: 'yyyy-mm-dd' });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>