
<?php $__env->startSection('title', __('Installment Payable')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Customer
        <small>Installment Payable</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
        <div class="box-body">
            <?php if(auth()->user()->can('supplier.view') || auth()->user()->can('customer.view')): ?>
                <div class="table-responsive">
            	<table class="table table-bordered table-striped">
            		<thead>
            			<tr>
                            <th><?php echo e(app('translator')->getFromJson('user.name')); ?></th>
                            <th><?php echo e(app('translator')->getFromJson('business.address')); ?></th>
                            <th><?php echo e(app('translator')->getFromJson('contact.contact')); ?></th>
                            <th>Total Payable Amount</th>
                            <th><?php echo e(app('translator')->getFromJson('messages.action')); ?></th>
            			</tr>
            		</thead>
            		
            		<tbody>
            		    <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            		        <tr>
            		            <td><?php echo e($item->name); ?></td>
            		            <td><?php echo e($item->city.' '.$item->state,' '.$item->country.' '.$item->landmark); ?></td>
            		            <td><?php echo e($item->mobile); ?></td>
            		            <td><?php echo e($item->total_amount); ?></td>
            		            <td>
            		                <a class="btn btn-sm btn-primary" href="<?php echo e(action('ContactController@show',[$item->id])); ?>">View</a>
            		                
            		                <?php if($item->total_sms >0): ?>
            		                <a class="btn btn-sm btn-info" href="<?php echo e(action('ContactController@customerSendSms',[$item->id])); ?>"><i class="fa fa-envelope"></i> Send SMS</a>
            		                <?php endif; ?>
            		            </td>
            		        </tr>
            		    
            		    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            		</tbody>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <th colspan="3">Total</th>
                            <th><?php echo e(number_format($contacts->sum('total_amount'), 2)); ?></th>
                        </tr>
                    </tfoot>
            	</table>
                </div>
            <?php endif; ?>
        </div>
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>