
<?php $__env->startSection('title', __('Bank')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Bank
        <small>Manage Your Bank Transaction</small>
    </h1>
</section>

<!-- Main content -->

<section class="content">
	<div class="box">
    <div class="box-body">
            <span id="view_contact_page"></span>
            <div class="row">
                <div class="col-sm-3">
                    <div class="well well-sm">
                        <strong>Name: <?php echo e($id); ?></strong><br>
                        <strong>Total Received: <?php echo e($receive_bank_balance[0]->total_receive_balance); ?> </strong><br>
                        <strong>Total Transfered: <?php echo e($transfer_bank_balance[0]->total_transfer_balance); ?></strong><br>
                        <strong>Available Balance: <?php echo e($total_bank_balance); ?></strong><br>
                  
                    </div>
                </div>
                </div>
                </div>
                
        <div class="box-header">
        	<h3 class="box-title">Personal Transfer Transaction</h3>
            <br>
          
           
        </div>
        <div class="box-body">
            <?php if(auth()->user()->can('tbpersonal.view') ): ?>
                <div class="table-responsive">
            	<table class="table table-bordered table-striped">
            		<thead>
            			<tr>   
                            <th>Transaction Date</th>
                            <th>Receiver</th>
                            <th>Phone</th>
                            <th>Reason</th>
                            <th>Sender</th>
                            <th>Amount</th>
            			</tr>
            		</thead>
                    <tbody>
                    <?php if($transfer_personal): ?>
                    <?php $__currentLoopData = $transfer_personal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transfer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($transfer->at); ?></td>
                            <td><?php echo e($transfer->receiver); ?></td>
                            <td><?php echo e($transfer->phone); ?></td>
                            <td><?php echo e($transfer->reason); ?></td>
                            <td><?php echo e($transfer->sender); ?></td>
                            <td><?php echo e($transfer->amount); ?></td>  
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  
                    <?php else: ?>
                    <tr>
                    <td colspan="6" ><strong>No Data Found</strong></td>
                    </tr>
                        <?php endif; ?>
                        </tbody>
                        <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="5" ><strong><?php echo e(app('translator')->getFromJson('sale.total')); ?>:</strong></td>
                            <td>৳ <?php echo e($transfer_bank_balance[0]->total_transfer_balance); ?></td>
                        </tr>
                        </tr>
                    </tfoot>
            	</table>
                </div>
            <?php endif; ?>
        </div>
        <div class="box-header">
        	<h3 class="box-title">Personal Receive Transaction</h3>
            <br>
          
           
        </div>
        <div class="box-body">
            <?php if(auth()->user()->can('tbpersonal.view') ): ?>
                <div class="table-responsive">
            	<table class="table table-bordered table-striped" >
            		<thead>
            			<tr>
                            
                        <th>Transaction Date</th>
                            <th>Received From</th>
                            <th>Phone</th>
                            <th>Reason</th>
                            <th>Received By</th>
                            <th>Amount</th>
            			</tr>
            		</thead>
                    <tbody>
                    <?php if($receive_personal): ?>
                    <?php $__currentLoopData = $receive_personal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receiver): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($receiver->at); ?></td>
                            <td><?php echo e($receiver->receiver); ?></td>
                            <td><?php echo e($receiver->phone); ?></td>
                            <td><?php echo e($receiver->reason); ?></td>
                            <td><?php echo e($receiver->sender); ?></td>
                            <td><?php echo e($receiver->amount); ?></td>  
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   
                    <?php else: ?>
                    <tr>
                    <td colspan="6" ><strong>No Data Found</strong></td>
                    </tr>
                        <?php endif; ?>
                        </tbody>
                        
                        <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <td colspan="5" ><strong><?php echo e(app('translator')->getFromJson('sale.total')); ?>:</strong></td>
                            <td>৳ <?php echo e($receive_bank_balance[0]->total_receive_balance); ?></td>
                        </tr>
                        </tr>
                    </tfoot>
            	</table>
                </div>
            <?php endif; ?>
        </div>
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>