
<?php $__env->startSection('title', __('Net Balance')); ?>

<?php $__env->startSection('content'); ?>
<section class="content-header">
    <h1>Net Balance</h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
	    <div class="box-header no-print">
            <a class="btn btn-primary btn-sm" onclick="exportF(this)">Excel Download</a>
            <a class="btn btn-info btn-sm" onclick="window.print();">Print</a>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-md-8 col-md-offset-2">
                    <div class="table-responsive">
                    	<table class="table table-bordered table-striped" id="table">
                    		<thead>
                    			<tr>
                    				<th>Titale</th>
                                    <th>Amount</th>
                    			</tr>
                    		</thead>
                                
                                <?php
                                    $stock_amount=$categories->sum('total_purchase_price');
                                ?>
                                
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($cat->name); ?></td>
                                    <td><?php echo e(number_format($cat->total_purchase_price,2)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <tr class="bg-gray font-17">
                                    <th>Total Stock Amount</th>
                                    <th><?php echo e(number_format($stock_amount,2)); ?></th>
                                </tr>
                                
                                <tr>
                                    <th>Customer Due</th>
                                    <td><?php echo e(number_format($customer_due,2)); ?></td>
                                </tr>
                                
                                <tr>
                                    <th>Cash In Hand</th>
                                    <td><?php echo e(number_format($cash_in_hand,2)); ?></td>
                                </tr>
                                
                                
                                <tr class="bg-gray font-17">
                                    <th>Total Amount And Product Stock</th>
                                    <th><?php echo e(number_format($stock_amount +$customer_due + $cash_in_hand,2)); ?></th>
                                </tr>
                                
                                <tr>
                                    <th>Total Supplier Due</th>
                                    <td><?php echo e(number_format($supplier_due,2)); ?></td>
                                </tr>
                                
                                <tr>
                                    <th style="font-size: 18px;"><b>The amount of current reserves</b></th>
                                    <th  style="font-size: 18px;"><?php echo e(number_format($stock_amount +$customer_due + $cash_in_hand -$supplier_due,2)); ?></th>
                                </tr>
                                
                                
                                <tr class="bg-gray font-17">
                                    <th>Monthly Expense Details</th>
                                    
                                    <th></th>
                                </tr>
                                
                                <?php $__currentLoopData = $expense_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($item->name); ?></td>
                                    <td><?php echo e($item->final_total); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                
                                <tr class="bg-gray font-17">
                                    <th>Total Expense</th>
                                    
                                    <td><?php echo e(number_format($expense_amount,2)); ?></td>
                                </tr>
                                
                                <tr>
                                    <th></th>
                                    <th></th>
                                </tr>
                                
                                <tr>
                                    <th>Total Sell Current Month</th>
                                    <th><?php echo e(number_format($sell_details_this_month['total_sell'], 2)); ?></th>
                                </tr>
                                
                                <tr>
                                    <th>Total Due Sell Month</th>
                                    <th><?php echo e(number_format($sell_details_this_month['invoice_due'], 2)); ?></th>
                                </tr>
                                
                                
                                <tr>
                                    <th>Total Due Paid in This Month</th>
                                    <th><?php echo e(number_format($sell_details_this_month['total_due_paid'], 2)); ?></th>
                                </tr>
                                
                                
                                
                    	</table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

   <script>
       function exportF(elem) {
          var table = document.getElementById("table");
          var html = table.outerHTML;
          var url = 'data:application/vnd.ms-excel,' + escape(html); // Set your html table into url 
          elem.setAttribute("href", url);
          elem.setAttribute("download", "export.xls"); // Choose the file name
          return false;
        }
    $('#datepicker, #datepicker1').datepicker({  format: 'yyyy-mm-dd' });
   </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>