<?php $request = app('Illuminate\Http\Request'); ?>

<!-- Left side column. contains the logo and sidebar -->
  <aside class="main-sidebar">

    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
      <!-- Sidebar Menu -->
      <ul class="sidebar-menu">

        <!-- Call superadmin module if defined -->
        <?php if(Module::has('Superadmin')): ?>
          <?php echo $__env->make('superadmin::layouts.partials.sidebar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php endif; ?>
        
        <!-- <li class="header">HEADER</li> -->
        <li class="<?php echo e($request->segment(1) == 'home' ? 'active' : ''); ?>">
          <a href="<?php echo e(action('HomeController@index')); ?>">
            <i class="fa fa-dashboard"></i> <span>
            <?php echo e(app('translator')->getFromJson('home.home')); ?></span>
          </a>
        </li>
        <?php if(auth()->user()->can('user.view') || auth()->user()->can('user.create') || auth()->user()->can('roles.view')): ?>
        <li class="treeview <?php echo e(in_array($request->segment(1), ['roles', 'users', 'sales-commission-agents']) ? 'active active-sub' : ''); ?>">
            <a href="#">
                <i class="fa fa-users"></i>
                <span class="title"><?php echo e(app('translator')->getFromJson('user.user_management')); ?></span>
                <span class="pull-right-container">
                    <i class="fa fa-angle-left pull-right"></i>
                </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check( 'user.view' )): ?>
                <li class="<?php echo e($request->segment(1) == 'users' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('ManageUserController@index')); ?>">
                      <i class="fa fa-user"></i>
                      <span class="title">
                          <?php echo e(app('translator')->getFromJson('user.users')); ?>
                      </span>
                  </a>
                </li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'roles' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('RoleController@index')); ?>">
                      <i class="fa fa-briefcase"></i>
                      <span class="title">
                        <?php echo e(app('translator')->getFromJson('user.roles')); ?>
                      </span>
                  </a>
                </li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'sales-commission-agents' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('SalesCommissionAgentController@index')); ?>">
                      <i class="fa fa-handshake-o"></i>
                      <span class="title">
                        <?php echo e(app('translator')->getFromJson('lang_v1.sales_commission_agents')); ?>
                      </span>
                  </a>
                </li>
              <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>
        <!-- HRM Management Menu-->
        <?php if(auth()->user()->can('hrm_employyes.view') || auth()->user()->can('hrm_employyes.create') || auth()->user()->can('hrm_transaction.view') || auth()->user()->can('hrm_transaction.create') || auth()->user()->can('hrm_attendence.view') || auth()->user()->can('hrm_attendence.create')): ?>
        <?php if(in_array('hr_management', $enabled_modules)): ?>
        <li class="treeview <?php echo e(in_array($request->segment(1), ['hrm_transaction', 'hrm_employyes', 'hrm_attendence']) ? 'active active-sub' : ''); ?>">
            <a href="#">
                <i class="fa fa-users"></i>
                <span class="title">HR Management</span>
                <span class="pull-right-container">
                    <i class="fa fa-angle-left pull-right"></i>
                </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check( 'hrm_employyes.view' )): ?>
                <li class="<?php echo e($request->segment(1) == 'hrm_employyes' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('HrmController@index')); ?>">
                      <i class="fa fa-user"></i>
                      <span class="title">
                          Employees
                      </span>
                  </a>
                </li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hrm_transaction.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'hrm_transaction' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('HrmTransactionController@index')); ?>">
                      <i class="fa fa-briefcase"></i>
                      <span class="title">
                       Transactions
                      </span>
                  </a>
                </li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('hrm_attendence.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'hrm_attendence' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('HrmAttendenceController@index')); ?>">
                      <i class="fa fa-handshake-o"></i>
                      <span class="title">
                        Attendence
                      </span>
                  </a>
                </li>
              <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>
        <?php endif; ?>
        <!-- End HRM Management Menu -->

        <?php if(auth()->user()->can('supplier.view') || auth()->user()->can('customer.view') ): ?>
          <li class="treeview <?php echo e(in_array($request->segment(1), ['contacts', 'customer-group']) ? 'active active-sub' : ''); ?>" id="tour_step4">
            <a href="#" id="tour_step4_menu"><i class="fa fa-address-book"></i> <span><?php echo e(app('translator')->getFromJson('contact.contacts')); ?></span>
              <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('supplier.view')): ?>
                <li class="<?php echo e($request->input('type') == 'supplier' ? 'active' : ''); ?>"><a href="<?php echo e(action('ContactController@index', ['type' => 'supplier'])); ?>"><i class="fa fa-star"></i> <?php echo e(app('translator')->getFromJson('report.supplier')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('customer.view')): ?>
                <li class="<?php echo e($request->input('type') == 'customer' ? 'active' : ''); ?>"><a href="<?php echo e(action('ContactController@index', ['type' => 'customer'])); ?>"><i class="fa fa-star"></i> <?php echo e(app('translator')->getFromJson('report.customer')); ?></a></li>

                <li class="<?php echo e($request->segment(2) == 'customer-installment' ? 'active' : ''); ?>"><a href="<?php echo e(action('ContactController@customerInstallment')); ?>"><i class="fa fa-users"></i> Customer Payable</a></li>
                
                <li class="<?php echo e($request->segment(1) == 'customer-group' ? 'active' : ''); ?>"><a href="<?php echo e(action('CustomerGroupController@index')); ?>"><i class="fa fa-users"></i> <?php echo e(app('translator')->getFromJson('lang_v1.customer_groups')); ?></a></li>
                
                <li class="<?php echo e($request->segment(1) == 'custom-sendsms' ? 'active' : ''); ?>"><a href="<?php echo e(action('ContactController@customSendSms')); ?>"><i class="fa fa-envelope"></i> Customer Send Sms</a></li>
              <?php endif; ?>

              <?php if(auth()->user()->can('supplier.create') || auth()->user()->can('customer.create') ): ?>
                <li class="<?php echo e($request->segment(1) == 'contacts' && $request->segment(2) == 'import' ? 'active' : ''); ?>"><a href="<?php echo e(action('ContactController@getImportContacts')); ?>"><i class="fa fa-download"></i> <?php echo e(app('translator')->getFromJson('lang_v1.import_contacts')); ?></a></li>
              <?php endif; ?>

            </ul>
          </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('product.view') || 
        auth()->user()->can('product.create') || 
        auth()->user()->can('brand.view') ||
        auth()->user()->can('unit.view') ||
        auth()->user()->can('category.view') ||
        auth()->user()->can('brand.create') ||
        auth()->user()->can('unit.create') ||
        auth()->user()->can('category.create') ): ?>
          <li class="treeview <?php echo e(in_array($request->segment(1), ['variation-templates', 'products', 'labels', 'import-products', 'import-opening-stock', 'selling-price-group', 'brands', 'units', 'categories']) ? 'active active-sub' : ''); ?>" id="tour_step5">
            <a href="#" id="tour_step5_menu"><i class="fa fa-cubes"></i> <span><?php echo e(app('translator')->getFromJson('sale.products')); ?></span>
              <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'products' && $request->segment(2) == '' ? 'active' : ''); ?>"><a href="<?php echo e(action('ProductController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('lang_v1.list_products')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'products' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('ProductController@create')); ?>"><i class="fa fa-plus-circle"></i><?php echo e(app('translator')->getFromJson('product.add_product')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'labels' && $request->segment(2) == 'show' ? 'active' : ''); ?>"><a href="<?php echo e(action('LabelsController@show')); ?>"><i class="fa fa-barcode"></i><?php echo e(app('translator')->getFromJson('barcode.print_labels')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'variation-templates' ? 'active' : ''); ?>"><a href="<?php echo e(action('VariationTemplateController@index')); ?>"><i class="fa fa-circle-o"></i><span><?php echo e(app('translator')->getFromJson('product.variations')); ?></span></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'import-products' ? 'active' : ''); ?>"><a href="<?php echo e(action('ImportProductsController@index')); ?>"><i class="fa fa-download"></i><span><?php echo e(app('translator')->getFromJson('product.import_products')); ?></span></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.opening_stock')): ?>
                <li class="<?php echo e($request->segment(1) == 'import-opening-stock' ? 'active' : ''); ?>"><a href="<?php echo e(action('ImportOpeningStockController@index')); ?>"><i class="fa fa-download"></i><span><?php echo e(app('translator')->getFromJson('lang_v1.import_opening_stock')); ?></span></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'selling-price-group' ? 'active' : ''); ?>"><a href="<?php echo e(action('SellingPriceGroupController@index')); ?>"><i class="fa fa-circle-o"></i><span><?php echo e(app('translator')->getFromJson('lang_v1.selling_price_group')); ?></span></a></li>
              <?php endif; ?>
              
              <?php if(auth()->user()->can('unit.view') || auth()->user()->can('unit.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'units' ? 'active' : ''); ?>">
                  <a href="<?php echo e(action('UnitController@index')); ?>"><i class="fa fa-balance-scale"></i> <span><?php echo e(app('translator')->getFromJson('unit.units')); ?></span></a>
                </li>
              <?php endif; ?>

              <?php if(auth()->user()->can('category.view') || auth()->user()->can('category.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'categories' ? 'active' : ''); ?>">
                  <a href="<?php echo e(action('CategoryController@index')); ?>"><i class="fa fa-tags"></i> <span><?php echo e(app('translator')->getFromJson('category.categories')); ?> </span></a>
                </li>
              <?php endif; ?>

              <?php if(auth()->user()->can('brand.view') || auth()->user()->can('brand.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'brands' ? 'active' : ''); ?>">
                  <a href="<?php echo e(action('BrandController@index')); ?>"><i class="fa fa-diamond"></i> <span><?php echo e(app('translator')->getFromJson('brand.brands')); ?></span></a>
                </li>
              <?php endif; ?>
            </ul>
          </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('purchase.view') || auth()->user()->can('purchase.create') || auth()->user()->can('purchase.update') ): ?>
        <li class="treeview <?php echo e(in_array($request->segment(1), ['purchases', 'purchase-return']) ? 'active active-sub' : ''); ?>" id="tour_step6">
          <a href="#" id="tour_step6_menu"><i class="fa fa-arrow-circle-down"></i> <span><?php echo e(app('translator')->getFromJson('purchase.purchases')); ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.view')): ?>
              <li class="<?php echo e($request->segment(1) == 'purchases' && $request->segment(2) == null ? 'active' : ''); ?>"><a href="<?php echo e(action('PurchaseController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('purchase.list_purchase')); ?></a></li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'purchases' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('PurchaseController@create')); ?>"><i class="fa fa-plus-circle"></i> <?php echo e(app('translator')->getFromJson('purchase.add_purchase')); ?></a></li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.update')): ?>
              <li class="<?php echo e($request->segment(1) == 'purchase-return' ? 'active' : ''); ?>"><a href="<?php echo e(action('PurchaseReturnController@index')); ?>"><i class="fa fa-undo"></i> <?php echo e(app('translator')->getFromJson('lang_v1.list_purchase_return')); ?></a></li>
            <?php endif; ?>
          </ul>
        </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('sell.view') || auth()->user()->can('sell.create') || auth()->user()->can('direct_sell.access') ): ?>
          <li class="treeview <?php echo e(in_array( $request->segment(1), ['sells', 'pos', 'sell-return']) ? 'active active-sub' : ''); ?>" id="tour_step7">
            <a href="#" id="tour_step7_menu"><i class="fa fa-arrow-circle-up"></i> <span><?php echo e(app('translator')->getFromJson('sale.sale')); ?></span>
              <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('direct_sell.access')): ?>
                <li class="<?php echo e($request->segment(1) == 'sells' && $request->segment(2) == null ? 'active' : ''); ?>" ><a href="<?php echo e(action('SellController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('lang_v1.all_sales')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('direct_sell.access')): ?>
                <li class="<?php echo e($request->segment(1) == 'sells' && $request->segment(2) == 'discount-sell' ? 'active' : ''); ?>" ><a href="<?php echo e(action('SellController@getDiscountSell')); ?>"><i class="fa fa-list"></i>Discount Sell</a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('direct_sell.access')): ?>
                <li class="<?php echo e($request->segment(1) == 'sells' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('SellController@create')); ?>"><i class="fa fa-plus-circle"></i><?php echo e(app('translator')->getFromJson('sale.add_sale')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sell.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'pos' && $request->segment(2) == null ? 'active' : ''); ?>" ><a href="<?php echo e(action('SellPosController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('sale.list_pos')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sell.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'pos' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('SellPosController@create')); ?>"><i class="fa fa-plus-circle"></i><?php echo e(app('translator')->getFromJson('sale.pos_sale')); ?></a></li>
                <li class="<?php echo e($request->segment(1) == 'sells' && $request->segment(2) == 'drafts' ? 'active' : ''); ?>" ><a href="<?php echo e(action('SellController@getDrafts')); ?>"><i class="fa fa-pencil-square" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('lang_v1.list_drafts')); ?></a></li>

                <li class="<?php echo e($request->segment(1) == 'sells' && $request->segment(2) == 'quotations' ? 'active' : ''); ?>" ><a href="<?php echo e(action('SellController@getQuotations')); ?>"><i class="fa fa-pencil-square" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('lang_v1.list_quotations')); ?></a></li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sell.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'sell-return' && $request->segment(2) == null ? 'active' : ''); ?>" ><a href="<?php echo e(action('SellReturnController@index')); ?>"><i class="fa fa-undo"></i><?php echo e(app('translator')->getFromJson('lang_v1.list_sell_return')); ?></a></li>
              <?php endif; ?>
            </ul>
          </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('purchase.view') || auth()->user()->can('purchase.create') ): ?>
        <li style="display:none;" class="treeview <?php echo e($request->segment(1) == 'stock-transfers' ? 'active active-sub' : ''); ?>">
          <a href="#"><i class="fa fa-truck" aria-hidden="true"></i> <span><?php echo e(app('translator')->getFromJson('lang_v1.stock_transfers')); ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.view')): ?>
              <li class="<?php echo e($request->segment(1) == 'stock-transfers' && $request->segment(2) == null ? 'active' : ''); ?>"><a href="<?php echo e(action('StockTransferController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('lang_v1.list_stock_transfers')); ?></a></li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'stock-transfers' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('StockTransferController@create')); ?>"><i class="fa fa-plus-circle"></i><?php echo e(app('translator')->getFromJson('lang_v1.add_stock_transfer')); ?></a></li>
            <?php endif; ?>
          </ul>
        </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('purchase.view') || auth()->user()->can('purchase.create') ): ?>
        <li class="treeview <?php echo e($request->segment(1) == 'stock-adjustments' ? 'active active-sub' : ''); ?>">
          <a href="#"><i class="fa fa-database" aria-hidden="true"></i> <span><?php echo e(app('translator')->getFromJson('stock_adjustment.stock_adjustment')); ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.view')): ?>
              <li class="<?php echo e($request->segment(1) == 'stock-adjustments' && $request->segment(2) == null ? 'active' : ''); ?>"><a href="<?php echo e(action('StockAdjustmentController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('stock_adjustment.list')); ?></a></li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'stock-adjustments' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('StockAdjustmentController@create')); ?>"><i class="fa fa-plus-circle"></i><?php echo e(app('translator')->getFromJson('stock_adjustment.add')); ?></a></li>
            <?php endif; ?>
            
             <!--22.07.2020-->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.create')): ?>
              <li style="display:none;" class="<?php echo e($request->segment(1) == 'physical-stock' ? 'active' : ''); ?>"><a href="<?php echo e(action('StockAdjustmentController@PhysicalStock')); ?>"><i class="fa fa-list"></i>Multiple Physical List</a></li>
              <li style="display:none;" class="<?php echo e($request->segment(1) == 'multiple-product-physical-stock' ? 'active' : ''); ?>"><a href="<?php echo e(action('StockAdjustmentController@multiProductPhysicalStock')); ?>"><i class="fa fa-plus-circle"></i>Multiple Physical Stock</a></li>
            <?php endif; ?>
            
          </ul>
        </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('purchase.view') || auth()->user()->can('purchase.create') ): ?>
        <li style="display:none;" class="treeview <?php echo e($request->segment(1) == 'stock-return' ? 'active active-sub' : ''); ?>">
          <a href="#"><i class="fa fa-database" aria-hidden="true"></i> <span>Purchase Return</span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.view')): ?>
              <li class="<?php echo e($request->segment(1) == 'stock-return' && $request->segment(2) == null ? 'active' : ''); ?>"><a href="<?php echo e(action('StockReturnController@index')); ?>"><i class="fa fa-list"></i>Purchase Return List</a></li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'stock-return' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('StockReturnController@create')); ?>"><i class="fa fa-plus-circle"></i>Purchase Return Add</a></li>
            <?php endif; ?>
          </ul>
        </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('expense.access')): ?>
        <li class="treeview <?php echo e(in_array( $request->segment(1), ['expense-categories', 'expenses']) ? 'active active-sub' : ''); ?>">
          <a href="#"><i class="fa fa-minus-circle"></i> <span><?php echo e(app('translator')->getFromJson('expense.expenses')); ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu">
            <li class="<?php echo e($request->segment(1) == 'expenses' && empty($request->segment(2)) ? 'active' : ''); ?>"><a href="<?php echo e(action('ExpenseController@index')); ?>"><i class="fa fa-list"></i><?php echo e(app('translator')->getFromJson('lang_v1.list_expenses')); ?></a></li>
            <li class="<?php echo e($request->segment(1) == 'expenses' && $request->segment(2) == 'create' ? 'active' : ''); ?>"><a href="<?php echo e(action('ExpenseController@create')); ?>"><i class="fa fa-plus-circle"></i><?php echo e(app('translator')->getFromJson('messages.add')); ?> <?php echo e(app('translator')->getFromJson('expense.expenses')); ?></a></li>
            <li class="<?php echo e($request->segment(1) == 'expense-categories' ? 'active' : ''); ?>"><a href="<?php echo e(action('ExpenseCategoryController@index')); ?>"><i class="fa fa-circle-o"></i><?php echo e(app('translator')->getFromJson('expense.expense_categories')); ?></a></li>
          </ul>
        </li>
        <?php endif; ?>

        <?php if(auth()->user()->can('purchase_n_sell_report.view') 
          || auth()->user()->can('contacts_report.view') 
          || auth()->user()->can('supplier_report.view') 
          || auth()->user()->can('stock_report.view') 
          || auth()->user()->can('tax_report.view') 
          || auth()->user()->can('trending_product_report.view') 
          || auth()->user()->can('sales_representative.view') 
          || auth()->user()->can('register_report.view')
          || auth()->user()->can('expense_report.view')
          ): ?>

          <li class="treeview <?php echo e(in_array( $request->segment(1), ['reports']) ? 'active active-sub' : ''); ?>" id="tour_step8">
            <a href="#" id="tour_step8_menu"><i class="fa fa-bar-chart-o"></i> <span><?php echo e(app('translator')->getFromJson('report.reports')); ?></span>
              <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('profit_loss_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'profit-loss' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getProfitLoss')); ?>"><i class="fa fa-money"></i><?php echo e(app('translator')->getFromJson('report.profit_loss')); ?></a></li>
                <li class="<?php echo e($request->segment(2) == 'net-balance' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@netBalance')); ?>"><i class="fa fa-money"></i>Final Report</a></li>
              <?php endif; ?>
              
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'supplier-sell-product' ? 'active' : ''); ?>" >
                  <a href="<?php echo e(action('ReportController@supplierSellProduct')); ?>">
                    <i class="fa fa-bomb"></i>Supplier WISE SALES POSITION
                  </a>
                </li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'supplier-all-stock' ? 'active' : ''); ?>" >
                  <a href="<?php echo e(action('ReportController@supplierAllStock')); ?>">
                    <i class="fa fa-bomb"></i>Supplier Stock Summery
                  </a>
                </li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'supplier-sell-summery' ? 'active' : ''); ?>" >
                  <a href="<?php echo e(action('ReportController@supplierSellSumery')); ?>">
                    <i class="fa fa-bomb"></i>Supplier Wise Sell Summery
                  </a>
                </li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'supplier-product-stock' ? 'active' : ''); ?>" >
                  <a href="<?php echo e(action('ReportController@supplierProductStock')); ?>">
                    <i class="fa fa-bomb"></i>Supplier Wise DETAILS STOCK POSITION
                  </a>
                </li>
              <?php endif; ?>

               <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'supplier-stock-receive' ? 'active' : ''); ?>" >
                  <a href="<?php echo e(action('ReportController@supplierStockReceive')); ?>">
                    <i class="fa fa-bomb"></i>Supplier Wise Stock Receipts
                  </a>
                </li>
              <?php endif; ?>
              

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'purchase-sell' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getPurchaseSell')); ?>"><i class="fa fa-exchange"></i><?php echo e(app('translator')->getFromJson('report.purchase_sell_report')); ?></a></li>
              <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'user-balance-hand' ? 'active' : ''); ?>" ><a href="<?php echo e(action('CashRegisterController@userBalanceHand')); ?>"><i class="fa fa-exchange"></i>Income Expenditure Account Report</a></li>
                
                <li class="<?php echo e($request->segment(2) == 'purchase-daily-sell' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getPurchaseSellOnly')); ?>"><i class="fa fa-exchange"></i>Daily Sale Report</a></li>
                
                <li class="<?php echo e($request->segment(2) == 'yearly-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@yearlyReport')); ?>"><i class="fa fa-exchange"></i>Yearly Report</a></li>
                <li class="<?php echo e($request->segment(2) == 'monthly-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@monthlyReport')); ?>"><i class="fa fa-exchange"></i>Monthly Report</a></li>
                <li class="<?php echo e($request->segment(2) == 'daily-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@dailyReport')); ?>"><i class="fa fa-exchange"></i>Daily Report</a></li>
                
                <li class="<?php echo e($request->segment(2) == 'category-wise-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@categoryWiseReport')); ?>"><i class="fa fa-exchange"></i>Category Wise Report</a></li>
                
                
                <li class="<?php echo e($request->segment(2) == 'sub-category-wise-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@subCategoryWiseReport')); ?>"><i class="fa fa-exchange"></i>Sub Category Wise Report</a></li>
                <li class="<?php echo e($request->segment(2) == 'yearly-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@yearlyReport')); ?>"><i class="fa fa-exchange"></i>Yearly Report</a></li>
              <?php endif; ?>
              
              
             <!----moinul--->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'sale-update-tracking' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@sellUpdateTracking')); ?>"><i class="fa fa-exchange"></i>Sell Update Tracking Report</a></li>
            <?php endif; ?>
            
            <!----moinul--->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'sale-delete-tracking' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@sellDeleteTracking')); ?>"><i class="fa fa-exchange"></i>Sell Delete Tracking Report</a></li>
            <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tax_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'tax-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getTaxReport')); ?>"><i class="fa fa-tumblr" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('report.tax_report')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contacts_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'customer-supplier' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getCustomerSuppliers')); ?>"><i class="fa fa-address-book"></i><?php echo e(app('translator')->getFromJson('report.contacts')); ?></a></li>
                <li class="<?php echo e($request->segment(2) == 'customer-group' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getCustomerGroup')); ?>"><i class="fa fa-users"></i><?php echo e(app('translator')->getFromJson('lang_v1.customer_groups_report')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('supplier_report.view')): ?>
               <li class="<?php echo e($request->segment(2) == 'report-supplier' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getSuppliers')); ?>"><i class="fa fa-address-book"></i><?php echo e(app('translator')->getFromJson('report.contacts2')); ?></a></li>
                 <?php endif; ?>
              
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'stock-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getStockReport')); ?>"><i class="fa fa-hourglass-half" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('report.stock_report')); ?></a></li>
              <?php endif; ?>
              
              <!----moinul--->
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                <li style="display:none;" class="<?php echo e($request->segment(2) == 'physical-stock-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getPhysicalStockReport')); ?>"><i class="fa fa-hourglass-half" aria-hidden="true"></i>Physical <?php echo e(app('translator')->getFromJson('report.stock_report')); ?></a></li>
                <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'stock-alert-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getStockAlertReport')); ?>"><i class="fa fa-hourglass-half" aria-hidden="true"></i>Stock Alert Report</a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                <?php if(session('business.enable_product_expiry') == 1): ?>
                <li class="<?php echo e($request->segment(2) == 'stock-expiry' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getStockExpiryReport')); ?>"><i class="fa fa-calendar-times-o"></i><?php echo e(app('translator')->getFromJson('report.stock_expiry_report')); ?></a></li>
                <?php endif; ?>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'lot-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getLotReport')); ?>"><i class="fa fa-hourglass-half" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('lang_v1.lot_report')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('trending_product_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'trending-products' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getTrendingProducts')); ?>"><i class="fa fa-line-chart" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('report.trending_products')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'stock-adjustment-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getStockAdjustmentReport')); ?>"><i class="fa fa-sliders"></i><?php echo e(app('translator')->getFromJson('report.stock_adjustment_report')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'product-purchase-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getproductPurchaseReport')); ?>"><i class="fa fa-arrow-circle-down"></i><?php echo e(app('translator')->getFromJson('lang_v1.product_purchase_report')); ?></a></li>

                <li class="<?php echo e($request->segment(2) == 'product-sell-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getproductSellReport')); ?>"><i class="fa fa-arrow-circle-up"></i><?php echo e(app('translator')->getFromJson('lang_v1.product_sell_report')); ?></a></li>

                <li class="<?php echo e($request->segment(2) == 'purchase-payment-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@purchasePaymentReport')); ?>"><i class="fa fa-money"></i><?php echo e(app('translator')->getFromJson('lang_v1.purchase_payment_report')); ?></a></li>

                <li class="<?php echo e($request->segment(2) == 'sell-payment-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@sellPaymentReport')); ?>"><i class="fa fa-money"></i><?php echo e(app('translator')->getFromJson('lang_v1.sell_payment_report')); ?></a></li>
                <li class="<?php echo e($request->segment(2) == 'product-download' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@productDownload')); ?>"><i class="fa fa-money"></i>Product Download</a></li>
                <li class="<?php echo e($request->segment(2) == 'product-review' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@productReview')); ?>"><i class="fa fa-money"></i>Product Review</a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('expense_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'expense-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getExpenseReport')); ?>"><i class="fa fa-search-minus" aria-hidden="true"></i></i><?php echo e(app('translator')->getFromJson('report.expense_report')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('register_report.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'register-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getRegisterReport')); ?>"><i class="fa fa-briefcase"></i><?php echo e(app('translator')->getFromJson('report.register_report')); ?></a></li>
              <?php endif; ?>

              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales_representative.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'sales-representative-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getSalesRepresentativeReport')); ?>"><i class="fa fa-user" aria-hidden="true"></i><?php echo e(app('translator')->getFromJson('report.sales_representative')); ?></a></li>
              <?php endif; ?>

              <?php if(in_array('tables', $enabled_modules)): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('purchase_n_sell_report.view')): ?>
                  <li class="<?php echo e($request->segment(2) == 'table-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getTableReport')); ?>"><i class="fa fa-table"></i><?php echo e(app('translator')->getFromJson('restaurant.table_report')); ?></a></li>
                <?php endif; ?>
              <?php endif; ?>
              <?php if(in_array('service_staff', $enabled_modules)): ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sales_representative.view')): ?>
                <li class="<?php echo e($request->segment(2) == 'service-staff-report' ? 'active' : ''); ?>" ><a href="<?php echo e(action('ReportController@getServiceStaffReport')); ?>"><i class="fa fa-user-secret"></i><?php echo e(app('translator')->getFromJson('restaurant.service_staff_report')); ?></a></li>
                <?php endif; ?>
              <?php endif; ?>

            </ul>
          </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('ibuser.view') || auth()->user()->can('ibtransaction.create') || auth()->user()->can('ibcategory.create')): ?>

            <li class="treeview <?php echo e(in_array($request->segment(1), ['internal_banking', 'banking_category']) ? 'active active-sub' : ''); ?>" id="tour_step4">
              <a href="#" id="tour_step4_menu"><i class="fa fa-address-book"></i> <span> Bank User</span>
                <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
              </a>
              <ul class="treeview-menu">
              <?php if(auth()->user()->can('ibuser.view') || auth()->user()->can('ibuser.create')): ?>
                <li class="<?php echo e($request->segment(1) == 'users' ? 'active' : ''); ?>"><a href="<?php echo e(action('BankingController@index')); ?>"><i class="fa fa-star"></i> <?php echo e(app('translator')->getFromJson('user.userName')); ?></a></li>
              <?php endif; ?>
              </ul>
            </li>
        <?php endif; ?>

          <?php if(auth()->user()->can('tbbank.view') || auth()->user()->can('tbpersonal.view')): ?>
            <?php if(in_array('transfer_balance', $enabled_modules)): ?>
              <li class="treeview <?php echo e(in_array($request->segment(1), ['transfer_balance', 'personal']) ? 'active active-sub' : ''); ?>" id="tour_step4">
                <a href="#" id="tour_step4_menu"><i class="fa fa-address-book"></i> <span>Transfer Balance</span>
                  <span class="pull-right-container">
                    <i class="fa fa-angle-left pull-right"></i>
                  </span>
                </a>
                <ul class="treeview-menu">
                  <?php if(auth()->user()->can('tbbank.view') || auth()->user()->can('tbbank.create')): ?>
                    <li class="<?php echo e($request->segment(1) == 'bank' ? 'active' : ''); ?>"><a href="<?php echo e(action('TransferBalanceBankController@index')); ?>"><i class="fa fa-star"></i>Bank</a></li>
                  <?php endif; ?>
                  <?php if(auth()->user()->can('tbpersonal.view') || auth()->user()->can('tbpersonal.create')): ?>
                    <li class="<?php echo e($request->segment(1) == 'personal' ? 'active' : ''); ?>"><a href="<?php echo e(action('TransferBalancePersonalController@index')); ?>"><i class="fa fa-star"></i>Personal</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>
          <?php endif; ?>

          <?php if(auth()->user()->can('rbbank.view') || auth()->user()->can('rbpersonal.view')): ?>
            <?php if(in_array('receive_balance', $enabled_modules)): ?>
              <li class="treeview <?php echo e(in_array($request->segment(1), ['receive_balance', 'personal']) ? 'active active-sub' : ''); ?>" id="tour_step4">
                <a href="#" id="tour_step4_menu"><i class="fa fa-address-book"></i> <span>Receive Balance</span>
                  <span class="pull-right-container">
                    <i class="fa fa-angle-left pull-right"></i>
                  </span>
                </a>
                <ul class="treeview-menu">
                  <?php if(auth()->user()->can('rbbank.view') || auth()->user()->can('rbbank.create')): ?>
                    <li class="<?php echo e($request->segment(1) == 'bank' ? 'active' : ''); ?>"><a href="<?php echo e(action('ReceiveBalanceBankController@index')); ?>"><i class="fa fa-star"></i>Bank</a></li>
                  <?php endif; ?>
                  <?php if(auth()->user()->can('rbpersonal.view') || auth()->user()->can('rbpersonal.create')): ?>
                    <li class="<?php echo e($request->segment(1) == 'personal' ? 'active' : ''); ?>"><a href="<?php echo e(action('ReceiveBalancePersonalController@index')); ?>"><i class="fa fa-star"></i>Personal</a></li>
                  <?php endif; ?>
                </ul>
              </li>
            <?php endif; ?>
          <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('backup')): ?>
          <li class="treeview <?php echo e(in_array( $request->segment(1), ['backup']) ? 'active active-sub' : ''); ?>">
              <a href="<?php echo e(action('BackUpController@index')); ?>"><i class="fa fa-dropbox"></i> <span><?php echo e(app('translator')->getFromJson('lang_v1.backup')); ?></span>
              </a>
          </li>
        <?php endif; ?>
        <?php if(auth()->user()->can('ikritem.view') || auth()->user()->can('ikdcategory.create') || auth()->user()->can('ikdlist.create')): ?>
         <?php if(in_array('internal_kitchen', $enabled_modules)): ?>
          <li class="treeview <?php echo e(in_array($request->segment(1), ['internal_kitchen', 'dish_list']) ? 'active active-sub' : ''); ?>" id="tour_step4">
            <a href="#" id="tour_step4_menu"><i class="fa fa-fire"></i> <span>Internal Kitchen</span>
              <span class="pull-right-container">
                <i class="fa fa-angle-left pull-right"></i>
              </span>
            </a>
            <ul class="treeview-menu">
            <?php if(auth()->user()->can('ikritem.view') || auth()->user()->can('ikritem.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'raw_items' ? 'active' : ''); ?>"><a href="<?php echo e(action('Restaurant\InternalKitchenController@index')); ?>"><i class="fa fa-star"></i> Raw Items</a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('ikdcategory.view') || auth()->user()->can('ikdcategory.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'dish_category' ? 'active' : ''); ?>"><a href="<?php echo e(action('Restaurant\DishCategoryController@index')); ?>"><i class="fa fa-star"></i> Dish Category</a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('ikdlist.view') || auth()->user()->can('ikdlist.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'dish_list' ? 'active' : ''); ?>"><a href="<?php echo e(action('Restaurant\DishListController@index')); ?>"><i class="fa fa-star"></i>Dish List</a></li>
            <?php endif; ?>
            </ul>
          </li>
       <?php endif; ?>
       <?php endif; ?>
       
         <!-- Waranty Management Menu-->
         <?php if(auth()->user()->can('warranty_customer.view') || auth()->user()->can('warranty_customer.create') || auth()->user()->can('warranty_supplier.view') || auth()->user()->can('warranty_supplier.create')): ?>
        <?php if(in_array('warranty', $enabled_modules)): ?>
        <li class="treeview <?php echo e(in_array($request->segment(1), ['warranty_customer', 'warranty_supplier']) ? 'active active-sub' : ''); ?>">
            <a href="#">
                <i class="fa fa-users"></i>
                <span class="title">Warranty Management</span>
                <span class="pull-right-container">
                    <i class="fa fa-angle-left pull-right"></i>
                </span>
            </a>
            <ul class="treeview-menu">
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check( 'warranty_customer.view' )): ?>
                <li class="<?php echo e($request->segment(1) == 'warranty_customer' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('CustomerWarrantyController@index')); ?>">
                      <i class="fa fa-user"></i>
                      <span class="title">
                          Customer Warranty
                      </span>
                  </a>
                </li>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('warranty_supplier.view')): ?>
                <li class="<?php echo e($request->segment(1) == 'warranty_supplier' ? 'active active-sub' : ''); ?>">
                  <a href="<?php echo e(action('SupplierWarrantyController@index')); ?>">
                      <i class="fa fa-briefcase"></i>
                      <span class="title">
                       Supplier Warranty
                      </span>
                  </a>
                </li>
              <?php endif; ?>
            </ul>
        </li>
        <?php endif; ?>
        <?php endif; ?>
        <!-- End Waranty Management Menu -->
        <!-- Call restaurant module if defined -->
        <?php if(in_array('tables', $enabled_modules) && in_array('service_staff', $enabled_modules) ): ?>
          <?php if(auth()->user()->can('crud_all_bookings') || auth()->user()->can('crud_own_bookings') ): ?>
          <li class="treeview <?php echo e($request->segment(1) == 'bookings'? 'active active-sub' : ''); ?>">
              <a href="<?php echo e(action('Restaurant\BookingController@index')); ?>"><i class="fa fa-calendar-check-o"></i> <span><?php echo e(app('translator')->getFromJson('restaurant.bookings')); ?></span></a>
          </li>
          <?php endif; ?>
        <?php endif; ?>

        <?php if(in_array('kitchen', $enabled_modules)): ?>
          <li class="treeview <?php echo e($request->segment(1) == 'modules' && $request->segment(2) == 'kitchen' ? 'active active-sub' : ''); ?>">
              <a href="<?php echo e(action('Restaurant\KitchenController@index')); ?>"><i class="fa fa-fire"></i> <span><?php echo e(app('translator')->getFromJson('restaurant.kitchen')); ?></span></a>
          </li>
        <?php endif; ?>
        
        <?php if(in_array('service_staff', $enabled_modules)): ?>
          <li class="treeview <?php echo e($request->segment(1) == 'modules' && $request->segment(2) == 'orders' ? 'active active-sub' : ''); ?>">
              <a href="<?php echo e(action('Restaurant\OrderController@index')); ?>"><i class="fa fa-list-alt"></i> <span><?php echo e(app('translator')->getFromJson('restaurant.orders')); ?></span></a>
          </li>
        <?php endif; ?>

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('send_notifications')): ?>
          <li class="treeview <?php echo e($request->segment(1) == 'notification-templates' ? 'active active-sub' : ''); ?>">
              <a href="<?php echo e(action('NotificationTemplateController@index')); ?>"><i class="fa fa-envelope"></i> <span><?php echo e(app('translator')->getFromJson('lang_v1.notification_templates')); ?></span>
              </a>
          </li>
        <?php endif; ?>
        
        <?php if(auth()->user()->can('business_settings.access') || auth()->user()->can('barcode_settings.access') ||auth()->user()->can('invoice_settings.access') ||auth()->user()->can('tax_rate.view') ||auth()->user()->can('tax_rate.create')): ?>
        <li class="treeview <?php if( in_array($request->segment(1), ['business', 'tax-rates', 'barcodes', 'invoice-schemes', 'business-location', 'invoice-layouts', 'printers', 'subscription']) || in_array($request->segment(2), ['tables', 'modifiers']) ): ?> <?php echo e('active active-sub'); ?> <?php endif; ?>">
          <a href="#" id="tour_step2_menu"><i class="fa fa-cog"></i> <span><?php echo e(app('translator')->getFromJson('business.settings')); ?></span>
            <span class="pull-right-container">
              <i class="fa fa-angle-left pull-right"></i>
            </span>
          </a>
          <ul class="treeview-menu" id="tour_step3">
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('business_settings.access')): ?>
              <li class="<?php echo e($request->segment(1) == 'business' ? 'active' : ''); ?>">
                <a href="<?php echo e(action('BusinessController@getBusinessSettings')); ?>" id="tour_step2"><i class="fa fa-cogs"></i> <?php echo e(app('translator')->getFromJson('business.business_settings')); ?></a>
              </li>
              <li class="<?php echo e($request->segment(1) == 'business-location' ? 'active' : ''); ?>" >
                <a href="<?php echo e(action('BusinessLocationController@index')); ?>"><i class="fa fa-map-marker"></i> <?php echo e(app('translator')->getFromJson('business.business_locations')); ?></a>
              </li>
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('invoice_settings.access')): ?>
              <li class="<?php if( in_array($request->segment(1), ['invoice-schemes', 'invoice-layouts']) ): ?> <?php echo e('active'); ?> <?php endif; ?>">
                <a href="<?php echo e(action('InvoiceSchemeController@index')); ?>"><i class="fa fa-file"></i> <span><?php echo e(app('translator')->getFromJson('invoice.invoice_settings')); ?></span></a>
              </li>
            <?php endif; ?>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('barcode_settings.access')): ?>
            <li class="<?php echo e($request->segment(1) == 'barcodes' ? 'active' : ''); ?>">
              <a href="<?php echo e(action('BarcodeController@index')); ?>"><i class="fa fa-barcode"></i> <span><?php echo e(app('translator')->getFromJson('barcode.barcode_settings')); ?></span></a>
            </li>
            <?php endif; ?>

            <li class="<?php echo e($request->segment(1) == 'printers' ? 'active' : ''); ?>">
              <a href="<?php echo e(action('PrinterController@index')); ?>"><i class="fa fa-share-alt"></i> <span><?php echo e(app('translator')->getFromJson('printer.receipt_printers')); ?></span></a>
            </li>

            <?php if(auth()->user()->can('tax_rate.view') || auth()->user()->can('tax_rate.create')): ?>
              <li class="<?php echo e($request->segment(1) == 'tax-rates' ? 'active' : ''); ?>">
                <a href="<?php echo e(action('TaxRateController@index')); ?>"><i class="fa fa-bolt"></i> <span><?php echo e(app('translator')->getFromJson('tax_rate.tax_rates')); ?></span></a>
              </li>
            <?php endif; ?>
            <?php if(in_array('tables', $enabled_modules)): ?>
               <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('business_settings.access')): ?>
                <li class="<?php echo e($request->segment(1) == 'modules' && $request->segment(2) == 'tables' ? 'active' : ''); ?>">
                  <a href="<?php echo e(action('Restaurant\TableController@index')); ?>"><i class="fa fa-table"></i> <?php echo e(app('translator')->getFromJson('restaurant.tables')); ?></a>
                </li>
              <?php endif; ?>
            <?php endif; ?>
            <?php if(in_array('modifiers', $enabled_modules)): ?>
              <?php if(auth()->user()->can('product.view') || auth()->user()->can('product.create') ): ?>
                <li class="<?php echo e($request->segment(1) == 'modules' && $request->segment(2) == 'modifiers' ? 'active' : ''); ?>">
                  <a href="<?php echo e(action('Restaurant\ModifierSetsController@index')); ?>"><i class="fa fa-delicious"></i> <?php echo e(app('translator')->getFromJson('restaurant.modifiers')); ?></a>
                </li>
              <?php endif; ?>
            <?php endif; ?>
            <?php if(Module::has('Superadmin')): ?>
              <?php echo $__env->make('superadmin::layouts.partials.subscription', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <?php endif; ?>
           
          </ul>
        </li>
        <?php endif; ?>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account.access')): ?>
          <?php if(Module::has('Account') && in_array('account', $enabled_modules)): ?>
            <?php echo $__env->make('account::layouts.partials.sidebar', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
          <?php endif; ?>
        <?php endif; ?>

      </ul>
    </section>
  </aside>