<div class="box">
    <div class="box-header">
        <h3 class="box-title">
            <i class="fa fa-money margin-r-5"></i>
            Payment Invoice List
        </h3>
    </div>
    <div class="box-body">
        <div class="row">
            <div class="col-sm-12">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>@lang('messages.date')</th>
                            <th>Ref No</th>
                            <th>@lang('sale.total_amount')</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($invoices as $item)
                            <tr>
                                <td>{{date('d.m.Y',strtotime($item->paid_on))}}</td>
                                <td>{{$item->payment_ref_no}}</td>
                                <td>{{$item->amount}}</td>
                                <td>
                                    <a href="#" class="btn btn-info btn-xs print-invoice" data-href="{{ action('TransactionPaymentController@allInvoicePrint',[$item->id])}}""><i class="fa fa-print"></i></a>
                                    <a class="btn btn-danger btn-xs" href="{{ action('TransactionPaymentController@allInvoicedelete',[$item->id])}}"><i class="fa fa-trash"></i></a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <p>{!! urldecode(str_replace("/?","?",$invoices->appends(Request::all())->render())) !!}</p>
    </div>
</div>