@extends('layouts.app')
@section('title', __('Send Sms'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Customer
        <small>Customer Send Sms</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
        <div class="box-body">
            <div class="col-sm-12">
                
                <div class="col-sm-4" style="border:1px solid #ccc">
                    <h3>Send Individual Customer Sms</h3>
                    <form action="{{ action('ContactController@SmsAStore')}}" method="post">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label>Customer :</label>
                            <select class="form-control select2" name="contact_id" style="width:100%">
                                <option value="" hidden>Select A customer</option>
                                @foreach($items as $item)
                                <option value="{{ $item->id}}">{{ $item->name}}</option>
                                @endforeach
                            </select>
                            
                            @if($errors->has('contact_id'))
                                <div class="error">{{ $errors->first('contact_id') }}</div>
                            @endif
                        </div>
                        
                        <div class="form-group">
                            <label>Message :</label>
                            <textarea class="form-control" name="message" placeholder="Message" rows="4"></textarea>
                            @if($errors->has('message'))
                                <div class="error">{{ $errors->first('message') }}</div>
                            @endif
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-sm btn-primary">SUBMIT</button>
                        </div>
                    </form>
                </div>
                
                <div class="col-sm-4"></div>
                <div class="col-sm-4" style="border:1px solid #ccc">
                    
                     <h3>Send All  Customer Sms</h3>
                    <form action="{{ action('ContactController@allCustomerSendSMS')}}" method="post">
                        {{ csrf_field() }}
                        <div class="form-group">
                            <label>Message :</label>
                            <textarea class="form-control" name="all_message" placeholder="Message" rows="6"></textarea>
                            @if($errors->has('all_message'))
                                <div class="error">{{ $errors->first('all_message') }}</div>
                            @endif
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-sm btn-primary">SUBMIT</button>
                        </div>
                    </form>
                </div>
                
                
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

@endsection
