<?php
namespace App\Http\Controllers;
use App\ExpenseCategory;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\TransferBalanceBank;
use App\ReceiveBalanceBank;
use App\TransferBalancePersonal;
use App\ReceiveBalancePersonal;
use DB;
use App\CashRegister;
use App\CashRegisterTransaction;
use App\Transaction;
use App\BankUsers;

use Helper;
class TransferBalanceBankController extends Controller{

    public function index(Request $request){
        
        if (!auth()->user()->can('tbbank.view')  && !auth()->user()->can('tbbank.create')) {
            abort(403, 'Unauthorized action.');
        }

        $business_id = request()->session()->get('user.business_id');
        $user_id = request()->session()->get('user.id');
        $total_balance=Helper::getUserTotalBalance($user_id,$business_id);

        if (request()->ajax()) {
        $business_id = $request->session()->get('user.business_id');
        $expense_category = DB::table('transfer_balance_bank as tbb')
                            ->leftjoin('users', 'tbb.sender', '=', 'users.id')
                            ->leftjoin('bank_users', 'tbb.bank_user_id', '=', 'bank_users.id')
                            ->where('tbb.business_id', $business_id)
                            ->whereNull('tbb.deleted_at');
                            
                            if(auth()->user()->username=='superadmin'){
                                $expense_category=$expense_category;
                            }else{
                               $expense_category->where('tbb.sender', $user_id); 
                            }
                            
                            if (!empty(request('start_date')) && !empty(request('end_date'))) {
                                $start = request('start_date');
                                $end =  request('end_date');
                                $expense_category->whereDate('tbb.created_at', '>=', $start)
                                            ->whereDate('tbb.created_at', '<=', $end);
                            }
            
    
                            $expense_category->select(['tbb.created_at','bank_users.name as bankName', 'bank_users.branch','users.first_name','bank_users.account_no','tbb.amount','tbb.purpose', 'tbb.id']);
                                
            return Datatables::of($expense_category)
                ->editColumn('bankName', function ($row) {
                    $bankName = $row->bankName;
                    return '<a href="'.action('TransferBalanceBankController@transactionByBank', [$row->bankName,$row->branch,$row->account_no]) . '" target="_blank">'.$bankName .'</a>';
                })->addColumn(
                'action',
                '@can("tbbank.update")
                <button data-href="{{action(\'TransferBalanceBankController@edit\', [$id])}}" class="btn btn-xs btn-primary btn-modal" data-container=".transfer_balance_bank_modal"><i class="glyphicon glyphicon-edit"></i> @lang("messages.edit")</button>
                &nbsp;
                @endcan
                @can("tbbank.delete")
                <button data-href="{{action(\'TransferBalanceBankController@destroy\', [$id])}}" class="btn btn-xs btn-danger delete_transfer_balance_bank"><i class="glyphicon glyphicon-trash"></i> @lang("messages.delete")</button>
                @endcan'
                )->removeColumn('id')
                ->rawColumns([7])
                ->escapeColumns(null)
                ->make(false);
        }
        return view('transfer_balance.bank',compact('total_balance'));
    }

    public function create(Request $request){
        if (!auth()->user()->can('tbbank.create')) {
            abort(403, 'Unauthorized action.');
        }

        $business_id = request()->session()->get('user.business_id');
        $banks=BankUsers::all();
        $user_id = request()->session()->get('user.id');
        $total_balance=Helper::getUserTotalBalance($user_id,$business_id);

        return view('transfer_balance.createBank',compact('total_balance','banks'));
    }

    public function store(Request $request){
        if (!auth()->user()->can('tbbank.create')) {
            abort(403, 'Unauthorized action.');
        }
        $business_id = request()->session()->get('user.business_id');

        $user_id = request()->session()->get('user.id');
        $total_balance=Helper::getUserTotalBalance($user_id,$business_id);

        $cash_register_id=DB::table('cash_registers')
                                    ->where(['business_id'=>$business_id,'user_id'=>$user_id,'status'=>'open'])
                                    ->select('id','status')
                                    ->orderby('id','DESC')
                                    ->first();
        
            try {
                $input = $request->only(['bank_user_id','amount','sender','receiver','purpose']);
                $input['business_id'] = $business_id;
                $input['cash_register_id'] = $cash_register_id->id;
                $inputs = $request->get('amount');
                if($total_balance >= $inputs){
                    TransferBalanceBank::create($input);
                    $output = ['success' => true,
                        'msg' => __("Balance transfered to bank Successfully")
                    ];
                }else{
                    $output = ['success' => false,
                        'msg' => __("You Do not have enough Balance!")
                    ];
                }
            }catch (\Exception $e) {
                \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
                $output = ['success' => false,
                    'msg' => $e->getMessage()
                ];
            }
            return $output;
    }

    public function destroy(Request $request, $id){
        if (!auth()->user()->can('tbbank.delete')) {
            abort(403, 'Unauthorized action.');
        }
        
        if (request()->ajax()) {
            try {
                $business_id = request()->session()->get('user.business_id');
                $expense_category = TransferBalanceBank::findOrFail($id);
                $expense_category->delete();
                $output = ['success' => true,
                            'msg' => __("Deleted Successfully")
                ];
            } catch (\Exception $e) {
                \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
            
                $output = ['success' => false,
                            'msg' => __("messages.something_went_wrong")
                        ];
            }
            return $output;
        }
    }

    public function transactionByBank(Request $request, $id,$id2,$id3){
        if (!auth()->user()->can('tbbank.view')) {
            abort(403, 'Unauthorized action.');
        }
        $receive_bank_balance = ReceiveBalanceBank::select(DB::raw("SUM(amount) as total_receive_balance"))->where('bank_name', $id)->where('branch', $id2)->where('account_no', $id3)->get();
        $transfer_bank_balance = TransferBalanceBank::select(DB::raw("SUM(amount) as total_transfer_balance"))->where('bank_name', $id)->where('branch', $id2)->where('account_no', $id3)->get();
        $total_bank_balance=( $transfer_bank_balance[0]->total_transfer_balance- $receive_bank_balance[0]->total_receive_balance);
        $business_id = $request->session()->get('user.business_id');
        $transferBank = TransferBalanceBank::where('transfer_balance_bank.bank_name',$id)->where('branch', $id2)->where('account_no', $id3)->where('transfer_balance_bank.business_id', $business_id)->leftjoin('users', 'transfer_balance_bank.sender', '=', 'users.id')->select(['transfer_balance_bank.created_at as at','transfer_balance_bank.bank_name as bank', 'transfer_balance_bank.branch as branch','users.first_name as sender','transfer_balance_bank.account_no as account_no','transfer_balance_bank.amount as amount', 'transfer_balance_bank.id as id'])->get();
        $receiverBank= ReceiveBalanceBank::where('receive_balance_bank.bank_name',$id)->where('branch', $id2)->where('account_no', $id3)->where('receive_balance_bank.business_id', $business_id)->leftjoin('users', 'receive_balance_bank.receiver', '=', 'users.id')->select(['receive_balance_bank.created_at as at','receive_balance_bank.bank_name as bank', 'receive_balance_bank.branch as branch','users.first_name as receiver','receive_balance_bank.account_no as account_no','receive_balance_bank.amount as amount', 'receive_balance_bank.id as id'])->get();
        return view('transfer_balance.transactionByBank',compact('transferBank','receiverBank','total_bank_balance','id','receive_bank_balance','transfer_bank_balance'));
    }
   
    public function edit($id){
        if (!auth()->user()->can('tbbank.edit')) {
            abort(403, 'Unauthorized action.');
        }
        if (request()->ajax()) {
            $banks=BankUsers::all();
            $business_id = request()->session()->get('user.business_id');
            $tb_bank = TransferBalanceBank::where('business_id', $business_id)->find($id);
            return view('transfer_balance.editBank')
                ->with(compact('tb_bank','banks'));
        }
    }

    public function update(Request $request, $id){
        if (!auth()->user()->can('tbbank.update')) {
            abort(403, 'Unauthorized action.');
        }
        $business_id = request()->session()->get('user.business_id');

        $user_id = request()->session()->get('user.id');
        $total_balance=Helper::getUserTotalBalance($user_id,$business_id);


                if (request()->ajax()) {
                    try {
                        $input = $request->only(['bank_name', 'branch','account_no','amount']);
                        $business_id = $request->session()->get('user.business_id');
                        $raw_items = TransferBalanceBank::where('business_id', $business_id)->findOrFail($id);
                        $prev_amount =  $raw_items->amount;
                        if($total_balance >= $input['amount']){
                            $raw_items->bank_name = $input['bank_name'];
                            $raw_items->branch = $input['branch'];
                            $raw_items->account_no = $input['account_no'];
                            $raw_items->amount = $input['amount'];
                            $raw_items->save();
                            $output = ['success' => true,
                                    'msg' => __("Balance Transfered Successfully")
                                    ];
                        }else{
                            $output = ['success' => false,
                            'msg' => __("You Don't Have Enough Balance!")
                        ];
                        }
                    } catch (\Exception $e) {
                        \Log::emergency("File:" . $e->getFile(). "Line:" . $e->getLine(). "Message:" . $e->getMessage());
                        $output = ['success' => false,
                                    'msg' => __("messages.something_went_wrong")
                                ];
                    }
                    return $output;
            }
    }
}