<?php
namespace App\Helper;
use DB;

use App\CashRegister;
use App\Transaction;
class Helper{
    
   


    public static function getUserTotalBalance($user_id,$business_id){

        $business_id = request()->session()->get('user.business_id');
        $cash_register_id=DB::table('cash_registers')->where('business_id',$business_id)->select('id','status')->orderby('id','DESC')->first();
        if($cash_register_id->status=="close"){
            $total_balance=0;
        }else{
            $register_details = $query = \App\CashRegister::join(
            'cash_register_transactions as ct',
            'ct.cash_register_id',
            '=',
            'cash_registers.id'
        )->join(
            'users as u',
            'u.id',
            '=',
            'cash_registers.user_id'
        )->Leftjoin(
            'transactions as T',
            'T.id',
            '=',
            'ct.transaction_id'
        );

        $query->where('cash_registers.id', $cash_register_id->id);
        
                              
        $register_details = $query->select(
            'cash_registers.created_at as open_time',
            'cash_registers.user_id',
            DB::raw("SUM(IF(transaction_type='initial', amount, 0)) as cash_in_hand"),
            DB::raw("SUM(IF(transaction_type='sell', amount, IF(transaction_type='refund', -1 * amount, 0))) as total_sale"),
            DB::raw("SUM(IF(is_due='1', IF(transaction_type='sell', amount, 0), 0)) as total_due_paid"),
            DB::raw("SUM(IF(pay_method='cash', IF(transaction_type='sell', amount, 0), 0)) as total_cash"),
            DB::raw("SUM(IF(pay_method='cheque', IF(transaction_type='sell', amount, 0), 0)) as total_cheque"),
            DB::raw("SUM(IF(pay_method='card', IF(transaction_type='sell', amount, 0), 0)) as total_card"),
            DB::raw("SUM(IF(pay_method='bank_transfer', IF(transaction_type='sell', amount, 0), 0)) as total_bank_transfer"),
            DB::raw("SUM(IF(pay_method='other', IF(transaction_type='sell', amount, 0), 0)) as total_other"),
            DB::raw("SUM(IF(pay_method='custom_pay_1', IF(transaction_type='sell', amount, 0), 0)) as total_custom_pay_1"),
            DB::raw("SUM(IF(pay_method='custom_pay_2', IF(transaction_type='sell', amount, 0), 0)) as total_custom_pay_2"),
            DB::raw("SUM(IF(pay_method='custom_pay_3', IF(transaction_type='sell', amount, 0), 0)) as total_custom_pay_3"),
            
            DB::raw("SUM(IF(transaction_type='sell', amount, 0)) as total_refund"),
            DB::raw("SUM(IF(transaction_type='refund', amount, 0)) as total_refund"),
            
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='cash', amount, 0), 0)) as total_cash_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='cheque', amount, 0), 0)) as total_cheque_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='card', amount, 0), 0)) as total_card_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='bank_transfer', amount, 0), 0)) as total_bank_transfer_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='other', amount, 0), 0)) as total_other_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='custom_pay_1', amount, 0), 0)) as total_custom_pay_1_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='custom_pay_2', amount, 0), 0)) as total_custom_pay_2_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='custom_pay_3', amount, 0), 0)) as total_custom_pay_3_refund"),
            DB::raw("SUM(IF(pay_method='cheque', 1, 0)) as total_cheques"),
            DB::raw("SUM(IF(pay_method='card', 1, 0)) as total_card_slips"),
            DB::raw("CONCAT(COALESCE(surname, ''), ' ', COALESCE(first_name, ''), ' ', COALESCE(last_name, '')) as user_name"),
            'email'
        )->first();
            $total_bank_receive=DB::table('receive_balance_bank')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
            $total_personal_receive=DB::table('receive_balance_personal')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
            $total_bank_transfer=DB::table('transfer_balance_bank')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
            $total_personal_transfer=DB::table('transfer_balance_personal')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
            $total_internal_transfer=DB::table('bank_transactions')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->where('type','Transfered')->select(DB::raw("SUM(balance) as total"))->first();
            $total_internal_receive=DB::table('bank_transactions')->where('deleted_at',null)->where('cash_register_id',$cash_register_id->id)->where('type','Received')->select(DB::raw("SUM(balance) as total"))->first();
            $total_balance_receive= $total_bank_receive->total + $total_personal_receive->total;
            $total_balance_transfer= $total_bank_transfer->total +  $total_personal_transfer->total;
            $total_balance=$register_details->cash_in_hand + $register_details->total_cash - $register_details->total_cash_refund + $total_balance_receive - $total_balance_transfer - $total_internal_transfer->total + $total_internal_receive->total;
        }
        
        return $total_balance;
        

    }



    public static function getUserWiseBalance($user_id,$business_id){

    $cash_register_id=DB::table('cash_registers')
                            ->where(['business_id'=>$business_id,'user_id'=>$user_id])
                            ->select('id','status')
                            ->orderby('id','DESC')
                            ->first();


        if (empty($cash_register_id) or ($cash_register_id->status=='close')){ 
            $data=[
                'total_bank_receive'=>0,
                'total_personal_receive'=>0,
                'total_personal_transfer'=>0,
                'total_bank_transfer'=>0,
                'total_sell_profit'=>0,
                'total_balance'=>0,

            ];
        }else{
            $register_details =$query = CashRegister::join(
            'cash_register_transactions as ct',
            'ct.cash_register_id',
            '=',
            'cash_registers.id'
        )->join(
            'users as u',
            'u.id',
            '=',
            'cash_registers.user_id'
        )->Leftjoin(
            'transactions as T',
            'T.id',
            '=',
            'ct.transaction_id'
        );
   
        $query->where('cash_registers.id', $cash_register_id->id);
                              
        $register_details = $query->select(
            'cash_registers.created_at as open_time',
            'cash_registers.user_id',
            DB::raw("SUM(IF(transaction_type='initial', amount, 0)) as cash_in_hand"),
            DB::raw("SUM(IF(transaction_type='sell', amount, IF(transaction_type='refund', -1 * amount, 0))) as total_sale"),
            DB::raw("SUM(IF(is_due='1', IF(transaction_type='sell', amount, 0), 0)) as total_due_paid"),
            DB::raw("SUM(IF(pay_method='cash', IF(transaction_type='sell', amount, 0), 0)) as total_cash"),
            DB::raw("SUM(IF(pay_method='cheque', IF(transaction_type='sell', amount, 0), 0)) as total_cheque"),
            DB::raw("SUM(IF(pay_method='card', IF(transaction_type='sell', amount, 0), 0)) as total_card"),
            DB::raw("SUM(IF(pay_method='bank_transfer', IF(transaction_type='sell', amount, 0), 0)) as total_bank_transfer"),
            DB::raw("SUM(IF(pay_method='other', IF(transaction_type='sell', amount, 0), 0)) as total_other"),
            DB::raw("SUM(IF(pay_method='custom_pay_1', IF(transaction_type='sell', amount, 0), 0)) as total_custom_pay_1"),
            DB::raw("SUM(IF(pay_method='custom_pay_2', IF(transaction_type='sell', amount, 0), 0)) as total_custom_pay_2"),
            DB::raw("SUM(IF(pay_method='custom_pay_3', IF(transaction_type='sell', amount, 0), 0)) as total_custom_pay_3"),
            DB::raw("SUM(IF(transaction_type='refund', amount, 0)) as total_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='cash', amount, 0), 0)) as total_cash_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='cheque', amount, 0), 0)) as total_cheque_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='card', amount, 0), 0)) as total_card_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='bank_transfer', amount, 0), 0)) as total_bank_transfer_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='other', amount, 0), 0)) as total_other_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='custom_pay_1', amount, 0), 0)) as total_custom_pay_1_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='custom_pay_2', amount, 0), 0)) as total_custom_pay_2_refund"),
            DB::raw("SUM(IF(transaction_type='refund', IF(pay_method='custom_pay_3', amount, 0), 0)) as total_custom_pay_3_refund"),
            DB::raw("SUM(IF(pay_method='cheque', 1, 0)) as total_cheques"),
            DB::raw("SUM(IF(pay_method='card', 1, 0)) as total_card_slips"),
            DB::raw("CONCAT(COALESCE(surname, ''), ' ', COALESCE(first_name, ''), ' ', COALESCE(last_name, '')) as user_name"),
            'email'
        )->first();


        $open_time = $register_details['open_time'];
        $close_time = \Carbon::now()->toDateTimeString();


        $sell_return=Transaction::where('transactions.created_by', $user_id)
                ->whereBetween('created_at', [$open_time, $close_time])
                ->where('transactions.type', 'sell_return')
                ->where('transactions.status', 'final')
                ->sum('final_total');



        $total_bank_receive=DB::table('receive_balance_bank')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
        $total_personal_receive=DB::table('receive_balance_personal')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
        $total_bank_transfer=DB::table('transfer_balance_bank')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
        $total_personal_transfer=DB::table('transfer_balance_personal')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->select(DB::raw("SUM(amount) as total"))->first();
        $total_internal_transfer=DB::table('bank_transactions')->where('cash_register_id',$cash_register_id->id)->where('deleted_at',null)->where('type','Transfered')->select(DB::raw("SUM(balance) as total"))->first();
        $total_internal_receive=DB::table('bank_transactions')->where('deleted_at',null)->where('cash_register_id',$cash_register_id->id)->where('type','Received')->select(DB::raw("SUM(balance) as total"))->first();


        $total_balance_receive= $total_bank_receive->total + $total_personal_receive->total;
        $total_balance_transfer= $total_bank_transfer->total +  $total_personal_transfer->total;

        $total_balance=$register_details->cash_in_hand + $register_details->total_cash - $register_details->total_cash_refund + $total_balance_receive - $total_balance_transfer - $total_internal_transfer->total + $total_internal_receive->total - $sell_return;

        $total_sell_profit=$register_details->cash_in_hand + $register_details->total_cash - $register_details->total_cash_refund  - $total_internal_transfer->total + $total_internal_receive->total - $sell_return;

        $data=[
            'total_bank_receive'=>$total_bank_receive->total ??0,
            'total_personal_receive'=>$total_personal_receive->total ??0,
            'total_personal_transfer'=>$total_personal_transfer ->total??0,
            'total_bank_transfer'=>$total_bank_transfer->total ??0,
            'total_sell_profit'=>$total_sell_profit ??0,
            'total_balance'=>$total_sell_profit ??0,

        ];


        }
        return $data;

    }
    
    
     public function getRegisterDetails($register_id = null){
        
        return $register_details;
    }
    



}