
<?php $__env->startSection('title', __('report.stock_report')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Physical Stock List</h1>
    
<?php if(Session::has('success')): ?>
<div class="alert alert-success"><?php echo e(Session::get('success')); ?>

<button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
</button>
</div>
<?php endif; ?>
</section>

<!-- Main content -->
<section class="content">
    <form>
    <div class="row">
        <div class="col-md-3">
            <input type="text" value="<?php echo e(request()->name ?request()->name:''); ?>" class="form-control" name="name" placeholder="search Here..">
        </div>
    </div>
    </form><br/>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="table" border="1">
                        <thead>
                            <tr>
                                <th>SKU</th>
                                <th>Date</th>
                                <th><?php echo e(app('translator')->getFromJson('business.product')); ?></th>
                                <th>Current Stock <br/><small>(balancing time)</small></th>
                                <th>Balance</th>
                                <th>Physical Stock</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>     
                            <tr>
                                <td><?php echo e(date('d-m-Y', strtotime($item->created_at))); ?></td>
                                <td><?php echo e($item->sku); ?></td>
                                <td><?php echo e($item->name); ?></td>
                                <td><?php echo e($item->current_stock); ?></td>
                                <td><?php echo e($item->physical_qty- $item->current_stock); ?></td>
                                <td><?php echo e($item->physical_qty); ?></td>
                                <td>
                                    <a class="btn btn-success btn-sm btn-modal" data-href="<?php echo e(action('StockAdjustmentController@PhysicalStockEdit',$item->id)); ?>" data-container=".container">Edit</a>
                                    <a class="btn btn-danger btn-sm" href="<?php echo e(action('StockAdjustmentController@PhysicalStockDelete',$item->id)); ?>">Delete</a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <tr class="bg-gray font-17  footer-total">
                                <td colspan="1"><strong><?php echo e(app('translator')->getFromJson('sale.total')); ?>:</strong></td>
                                <th><?php echo e($products->count()); ?></th>
                                <td ><?php echo e($products->sum('current_stock')); ?></td>
                                <td ></td>
                                <td ><?php echo e($products->sum('physical_qty')); ?></td>
                            </tr>
                        </tfoot>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

<div class="modal fade container" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true"></div>
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
<script>
    var amount=0;
     $(document).on('keyup','#physical_qty',function(){
         amount=$(this).val();
         var due=$('#current_stock').val();
         update_amount=(amount - due);
         $('#balance').val(update_amount);


     });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>