

<?php $__env->startSection('title',  'HRM Employee' ); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Add Employee</h1>
</section>

<!-- Main content -->
<section class="content">
<div class="box">
    <div class="box-body">
    <div class="row">
    <?php echo Form::open(['url' => action('HrmController@store'), 'method' => 'post', 'id' => 'user_add_form' ,'files' => true]); ?>

      <div class="col-md-2">
        <div class="form-group">
        <?php echo Form::label('image', __('Employee Image') . ':'); ?>

            <?php echo Form::file('image', ['id' => 'upload_image', 'accept' => 'image/*']);; ?>

            <small><p class="help-block"><?php echo e(app('translator')->getFromJson('purchase.max_file_size', ['size' => (config('constants.document_size_limit') / 1000000)])); ?> <br> <?php echo e(app('translator')->getFromJson('lang_v1.aspect_ratio_should_be_1_1')); ?></p></small>
        </div>
      </div>
      <div class="clearfix"></div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('name', __( 'Name' ) . ':*'); ?>

            <?php echo Form::text('name', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'name' ) ]);; ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('father_name', __( 'Father Name' ) . ':'); ?>

            <?php echo Form::text('father_name', null, ['class' => 'form-control', 'placeholder' => __( 'Father Name' ) ]);; ?>

          
        </div>
      </div>
      <div class="clearfix"></div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('dob', __( 'Date Of Birth' ) . ':*'); ?>

            <?php echo Form::date('dob', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'Date Of Birth' ) ]);; ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('gender', __('Gender' ) . ':'); ?>

            <?php echo Form::select('gender', ['male' => 'Male', 'female' => 'Female'], null, ['class' => 'form-control', 'placeholder' => __( 'Gender' ) ]);; ?>

        </div>
      </div>
      <div class="clearfix"></div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('phone', __( 'Phone' ) . ':*'); ?>

            <?php echo Form::text('phone', null, ['class' => 'form-control' , 'placeholder' => __( 'Phone' ) ]);; ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('address', __( 'Address' ) . ':*'); ?>

            <?php echo Form::text('address', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'Address' ) ]);; ?>

        </div>
      </div>
    
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('p_address', __( 'Permanent Address' ) . ':*'); ?>

            <?php echo Form::text('p_address', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'Permanent Address' ) ]);; ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('employee_id', __( 'Employee ID' ) . ':'); ?>

            <?php echo Form::text('employee_id', null, ['class' => 'form-control', 'placeholder' => __( 'Employee ID' )]);; ?>

        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
          <?php echo Form::label('department', __( 'Department' ) . ':'); ?>

            <?php echo Form::text('department', null, ['class' => 'form-control', 'placeholder' => __( 'Department' )]);; ?>

        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
          <?php echo Form::label('designation', __( 'Designation' ) . ':'); ?>

            <?php echo Form::text('designation', null, ['class' => 'form-control', 'placeholder' => __( 'Designation' )]);; ?>

        </div>
      </div>
      <div class="col-md-4">
        <div class="form-group">
          <?php echo Form::label('salary', __( 'Salary' ) . ':'); ?>

            <?php echo Form::text('salary', null, ['class' => 'form-control', 'placeholder' => __( 'Salary' )]);; ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('doj', __( 'Join Date' ) . ':'); ?>

            <?php echo Form::date('doj', null, ['class' => 'form-control', 'placeholder' => __( 'Join Date' )]);; ?>

        </div>
      </div>
      <div class="col-md-6">
        <div class="form-group">
          <?php echo Form::label('exit_date', __( 'Exit Date' ) . ':'); ?> 
            <?php echo Form::date('exit_date', null, ['class' => 'form-control', 'placeholder' => __( 'Exit Date' )]);; ?>

        </div>
      </div>
      <div class="col-md-6" hidden>
        <div class="form-group">
          <?php echo Form::label('status', __( 'Status' ) . ':'); ?>

            <?php echo Form::text('status', 0, ['class' => 'form-control', 'placeholder' => __( 'Status' )]);; ?>

        </div>
      </div>
     

    </div>
    </div>
    <div class="row">
     <div class="col-md-12">
      <button type="submit" class="btn btn-primary pull-right" id="submit_user_button"><?php echo e(app('translator')->getFromJson( 'messages.save' )); ?></button>
      </div>
    </div>

    <?php echo Form::close(); ?>


  </div><!-- /.modal-content -->
  <?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
<script type="text/javascript">
  $(document).ready(function(){
    $('#selected_contacts').on('ifChecked', function(event){
      $('div.selected_contacts_div').removeClass('hide');
    });
    $('#selected_contacts').on('ifUnchecked', function(event){
      $('div.selected_contacts_div').addClass('hide');
    });
  });

  $('form#user_add_form').validate({
                rules: {
                    first_name: {
                        required: true,
                    },
                    email: {
                        email: true
                    },
                    password: {
                        required: true,
                        minlength: 5
                    },
                    confirm_password: {
                        equalTo: "#password"
                    },
                    username: {
                        required: true,
                        minlength: 5,
                        remote: {
                            url: "/business/register/check-username",
                            type: "post",
                            data: {
                                username: function() {
                                    return $( "#username" ).val();
                                },
                                <?php if(!empty($username_ext)): ?>
                                  username_ext: "<?php echo e($username_ext); ?>"
                                <?php endif; ?>
                            }
                        }
                    }
                },
                messages: {
                    password: {
                        minlength: 'Password should be minimum 5 characters',
                    },
                    confirm_password: {
                        equalTo: 'Should be same as password'
                    },
                    username: {
                        remote: 'Invalid username or User already exist'
                    }
                }
            });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>