
<?php $__env->startSection('title','Update Stock Adjustment'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
<br>
    <h1>Stock Adjustment Update</h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content no-print">
	<?php echo Form::open(['url' => action('StockAdjustmentController@update',['id'=>$stock_adjustment->id]), 'method' => 'PUT', 'id' => 'stock_adjustment_form' ]); ?>

	<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
	<div class="box box-solid">
		<div class="box-body">
			<div class="row">
				<div class="col-sm-3">
					<div class="form-group">
						<?php echo Form::label('location_id', __('purchase.business_location').':*'); ?>

						<?php echo Form::select('location_id', $business_locations, $stock_adjustment->location_id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']);; ?>

					</div>
				</div>
				<div class="col-sm-3">
					<div class="form-group">
						<?php echo Form::label('ref_no', __('purchase.ref_no').':'); ?>

						<?php echo Form::text('ref_no', $stock_adjustment->ref_no, ['class' => 'form-control']);; ?>

					</div>
				</div>
				<div class="col-sm-3">
					<div class="form-group">
						<?php echo Form::label('transaction_date', __('messages.date') . ':*'); ?>

						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-calendar"></i>
							</span>
							<?php echo Form::text('transaction_date',$stock_adjustment->transaction_date, ['class' => 'form-control', 'readonly', 'required']);; ?>

						</div>
					</div>
				</div>
				<div class="col-sm-3">
					<div class="form-group">
						<?php echo Form::label('adjustment_type', __('stock_adjustment.adjustment_type') . ':*'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto" 
                    data-content="' . __('tooltip.adjustment_type') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
						<?php echo Form::select('adjustment_type', [ 'normal' =>  __('stock_adjustment.normal'), 'abnormal' =>  __('stock_adjustment.abnormal')], $stock_adjustment->adjustment_type, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']);; ?>

					</div>
				</div>
			</div>
		</div>
	</div> <!--box end-->
	<div class="box box-solid">
		<div class="box-header">
        	<h3 class="box-title"><?php echo e(__('stock_adjustment.search_products')); ?></h3>
       	</div>
		<div class="box-body">
			<div class="row">
				<div class="col-sm-8 col-sm-offset-2">
					<div class="form-group">
						<div class="input-group">
							<span class="input-group-addon">
								<i class="fa fa-search"></i>
							</span>
							<?php echo Form::text('search_product', null, ['class' => 'form-control', 'id' => 'search_product_for_srock_adjustment', 'placeholder' => __('stock_adjustment.search_product')]);; ?>

						</div>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-12">
					<input type="hidden" id="product_row_index" value="<?php echo e($stock_adjustment->stock_adjustment_lines->count()); ?>">
					<input type="hidden" id="total_amount" name="final_total" value="<?php echo e($stock_adjustment->final_total); ?>">
					<div class="table-responsive">
					<table class="table table-bordered table-striped table-condensed" 
					id="stock_adjustment_product_table">
						<thead>
							<tr>
								<th class="col-sm-4 text-center">	
									<?php echo e(app('translator')->getFromJson('sale.product')); ?>
								</th>
								<th class="col-sm-2 text-center">
									<?php echo e(app('translator')->getFromJson('sale.qty')); ?>
								</th>
								<th class="col-sm-2 text-center">
									<?php echo e(app('translator')->getFromJson('sale.unit_price')); ?>
								</th>
								<th class="col-sm-1 text-center">
									<?php echo e(app('translator')->getFromJson('sale.subtotal')); ?>
								</th>

								<th class="col-sm-1 text-center">
									<i class="fa fa-trash" aria-hidden="true"></i>
								</th>
							</tr>
						</thead>
						<tbody>
							<?php $__currentLoopData = $stock_adjustment->stock_adjustment_lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<?php
								$stock=get_stock($line->product_id,$line->variation_id);
							?>
								<tr>
									<td><?php echo e($line->product->name); ?> <?php echo e($line->product->sku); ?></td>
									<td>
											<input type="text" class="form-control product_quantity input_number" value="<?php echo e(number_format($line->quantity, 2, session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>" name="products[<?php echo e($key); ?>][quantity]" max="<?php echo e($stock); ?>" required>
									</td>
									<td>
										<input type="text" name="products[<?php echo e($key); ?>][unit_price]" class="form-control product_unit_price input_number" value="<?php echo e(number_format($line->unit_price, 2, session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>">
									</td>
									<td>
										<input type="text" readonly name="products[<?php echo e($key); ?>][price]" class="form-control product_line_total" value="<?php echo e(number_format($line->unit_price * $line->quantity, 2, session('currency')['decimal_separator'], session('currency')['thousand_separator'])); ?>">
									</td>
									<td class="text-center">
								        <i class="fa fa-trash remove_product_row cursor-pointer" aria-hidden="true"></i>
								    </td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
						<tfoot>
							<tr class="text-center"><td colspan="3"></td><td><div class="pull-right"><b><?php echo e(app('translator')->getFromJson('stock_adjustment.total_amount')); ?>:</b> <span id="total_adjustment"><?php echo e($stock_adjustment->final_total); ?></span></div></td></tr>
						</tfoot>
					</table>
					</div>
				</div>
			</div>
		</div>
	</div> <!--box end-->
	<div class="box box-solid">
		<div class="box-body">
			<div class="row">
				<div class="col-sm-4">
					<div class="form-group">
							<?php echo Form::label('total_amount_recovered', __('stock_adjustment.total_amount_recovered') . ':'); ?> <?php
                if(session('business.enable_tooltip')){
                    echo '<i class="fa fa-info-circle text-info hover-q " aria-hidden="true" 
                    data-container="body" data-toggle="popover" data-placement="auto" 
                    data-content="' . __('tooltip.total_amount_recovered') . '" data-html="true" data-trigger="hover"></i>';
                }
                ?>
							<?php echo Form::text('total_amount_recovered', $stock_adjustment->total_amount_recovered, ['class' => 'form-control input_number', 'placeholder' => __('stock_adjustment.total_amount_recovered')]);; ?>

					</div>
				</div>
				<div class="col-sm-4">
					<div class="form-group">
							<?php echo Form::label('additional_notes', __('stock_adjustment.reason_for_stock_adjustment') . ':'); ?>

							<?php echo Form::textarea('additional_notes', $stock_adjustment->additional_notes, ['class' => 'form-control', 'placeholder' => __('stock_adjustment.reason_for_stock_adjustment'), 'rows' => 3]);; ?>

					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-12">
					<button type="submit" class="btn btn-primary pull-right"><?php echo e(app('translator')->getFromJson('messages.save')); ?></button>
				</div>
			</div>

		</div>
	</div> <!--box end-->
	<?php echo Form::close(); ?>

</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
	<script src="<?php echo e(asset('js/stock_adjustment.js?v=' . $asset_v)); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>