
<?php $__env->startSection('title', __('HRM Transactions')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>HRM Transactions
        <small>Manage Your HRM Transactions</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">

	<div class="box">
        <div class="box-header">
        	<h3 class="box-title">All your transactions</h3>
            <?php if(auth()->user()->can('hrm_transaction.create')): ?>
        	<div class="box-tools">
                <button type="button" class="btn btn-block btn-primary btn-modal" 
                	data-href="<?php echo e(action('HrmTransactionController@create')); ?>" 
                	data-container=".hrm_transactions_modal">
                	<i class="fa fa-plus"></i> <?php echo e(app('translator')->getFromJson( 'messages.add' )); ?></button>
            </div>
            <?php endif; ?>
        </div>
        <div class="box-body">
        <?php if(auth()->user()->can('hrm_transaction.view')): ?>
            <div class="table-responsive">
        	<table class="table table-bordered table-striped" id="hrm_transactions_table">
        		<thead>
        			<tr>
        				<th>Employee ID</th>
                        <th>Type</th>
                        <th>Amount</th>
                        <th>Paid At</th>
                        <th>Actions</th>
        			</tr>
        		</thead>
        	</table>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="modal fade hrm_transactions_modal" tabindex="-1" role="dialog" 
    	aria-labelledby="gridSystemModalLabel">
    </div>

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>