@extends('layouts.app')
@section('title', __('Yearly Report'))

@section('content')
<section class="content-header">
    <h1>Yearly {{ __('report.reports')}}</h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
        <div class="box-body">

                <form>
                <div class="col-md-12 no-print">
                    <div class="col-md-3">
                        <label>From:</label>
                        <input type="text" class="form-control" id="datepicker" name="start_date" placeholder="yyyy-mm-dd" value="{{request()->start_date ? request()->start_date:''}}" autocomplete="off">
                    </div>
                    <div class="col-md-3">
                        <label>To:</label>
                        <input type="text" class="form-control" id="datepicker1" name="end_date" placeholder="yyyy-mm-dd" value="{{request()->end_date ? request()->end_date:''}}" autocomplete="off">
                    </div>
                    <div class="col-md-1">
                        <label for="Product">&nbsp;</label>
                        <input type="submit" value="Search" class="form-control btn btn-sm btn-primary btn-sm">
                    </div>
                    <div class="col-md-2 no-print">
                        <label for="Product">&nbsp;</label> <br/>
                        <a class="btn btn-info btn-sm" onclick="window.print();">Print</a>
                        <a href="{{ action('ReportController@yearlyReport') }}" class="btn btn-md btn-info btn-sm">Refresh</a> 
                    </div>
                </div>
                </form>
    
                <div class="col-md-12">
                <br><div class="table-responsive">
                    	<table class="table table-bordered table-striped">
                    		<thead>
                    			<tr>
                    				<th>Date</th>
                                    <th>Quantity</th>
                    				<th>Bill Amount</th>
                                    <th>Adjustment</th>
                                    <th>Dues</th>
                                    <th>Discount</th>
                                    <th>Cheque</th>
                                    
                                    <th>Due Received</th>
                                    <th>Cash Received</th>
                    			</tr>
                    		</thead>
                            <tbody>
                                @php
                                    $total_due= 0;
                                @endphp

                                @foreach($results as $item)

                                @php
                                    $due= $item->total_sell_amount - $item->total_payment;
                                    $total_due += $due;
                                @endphp
                                <tr>
                                    <td>{{ $item->date}}</td>
                                    <td>{{ $item->total_sell_qty}}</td>
                                    <td>{{ $item->total_sell_amount}}</td>
                                    <td>{{ $item->total_adjustment}}</td>
                                    <td>{{ $due}}</td>
                                    <td>{{ $item->total_discount}}</td>
                                    <td>{{ $item->total_cheque_payment ??0}}</td>
                                    <td>{{ $item->total_due_paid}}</td>
                                    <td>{{ ($item->total_sell_amount - $due) + $item->total_due_paid }}</td>
                                    
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray font-17">
                                    <th>Total</th>
                                    <th>{{ number_format($results->sum('total_sell_qty'),2)}}</th>
                                    <th>{{ number_format($results->sum('total_sell_amount'),2)}}</th>
                                    <th>{{ number_format($results->sum('total_adjustment'),2)}}</th>
                                    <th>{{ number_format($total_due,2)}}</th>
                                    <th>{{ number_format($results->sum('total_discount'),2)}}</th>
                                    <th>{{ number_format($results->sum('total_cheque_payment'),2)}}</th>
                                    <th>{{ number_format($results->sum('total_due_paid'),2)}}</th>
                                    <th>{{ number_format($results->sum('total_due_paid') + $results->sum('total_due_paid'),2)}}</th>
                                    
                                </tr>
                            </tfoot>
                    	</table>
                    	
                    	
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

@endsection

@section('javascript')
    <script>
        $('#datepicker, #datepicker1').datepicker({  format: 'yyyy-mm-dd' });
    </script>
@endsection