@extends('layouts.app')
@section('title', __('Sub Category Wise'))

@section('content')
<section class="content-header">
    <h1>Sub Category Wise {{ __('report.reports')}}</h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
	    <div class="box-header no-print">
            <a class="btn btn-primary btn-sm" onclick="exportF(this)">Excel Download</a>
            <a class="btn btn-info btn-sm" onclick="window.print();">Print</a>
        </div>
        
        <div class="box-body">

            <div class="row no-print">
                <form>
                <div class="col-md-12">
                    <div class="col-md-3">
                        <label>From:</label>
                        <input type="text" class="form-control" id="datepicker" name="start_date" placeholder="yyyy-mm-dd" value="{{request()->start_date ? request()->start_date:''}}" autocomplete="off">
                    </div>
                    <div class="col-md-3">
                        <label>To:</label>
                        <input type="text" class="form-control" id="datepicker1" name="end_date" placeholder="yyyy-mm-dd" value="{{request()->end_date ? request()->end_date:''}}" autocomplete="off">
                    </div>
                    <div class="col-md-3">
                        <label>Sub Category:</label>
                        <input type="text" class="search-query form-control" placeholder="Search" name="q" value="{{ request('q') ?request('q'):'' }}" />
                    </div>
                    <div class="col-md-1">
                        <label for="Product">&nbsp;</label>
                        <input type="submit" value="Search" class="form-control btn btn-sm btn-primary btn-sm">
                    </div>
                    <div class="col-md-2">
                        <label for="Product">&nbsp;</label> <br/>
                        <a href="{{ action('ReportController@subCategoryWiseReport') }}" class="btn btn-md btn-info btn-sm">Refresh</a> 
                    </div>
                </div>
                </form>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                    	<table class="table table-bordered table-striped" id="table">
                    		<thead>
                    			<tr>
                    				<th>Sub Category</th>
                                    <th>Total Purcase Quantity</th>
                                    <th>Total Sell Qty</th>
                    				<th>@lang('report.total_sell')</th>
                                    <th>Profit/ Loss</th>
                                    <th>In Stock</th>
                                    <th>Total Amount</th>
                    			</tr>
                    		</thead>
                            <tbody>
                                @php
                                    $total_profit=0;
                                    $total_stock=0;
                                @endphp
                                @foreach($categories as $cat)

                                @php
                                    $profit=$cat->total_sell_price -$cat->total_purchase_price;
                                    $stock=$cat->total_stock_purchase -$cat->total_sell_stock;
                                    $total_profit +=$profit;
                                    $total_stock +=$stock;
                                @endphp
                                <tr>
                                    <td>{{ $cat->name}}</td>
                                    <td>{{ number_format($cat->total_stock_purchase,2)}}</td>
                                    <td>{{ number_format($cat->total_sell_stock,2)}}</td>
                                    <td>{{ number_format($cat->total_sell_price,2)}}</td>
                                    <td>{{ number_format($profit,2)}}</td>
                                    <td>{{ number_format($stock,2)}}</td>
                                    <td>{{ number_format($cat->total_purchase_price,2)}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray font-17">
                                    <th>Total</th>
                                    <th>{{ number_format($categories->sum('total_stock_purchase'),2)}}</th>
                                    <th>{{ number_format($categories->sum('total_sell_stock'),2)}}</th>
                                    <th>{{ number_format($categories->sum('total_sell_price'),2)}}</th>
                                    <th>{{ number_format($total_profit,2)}}</th>
                                    <th>{{ number_format($total_stock,2)}}</th>
                                    <th>{{ number_format($categories->sum('total_purchase_price'),2)}}</th>
                                </tr>
                            </tfoot>
                    	</table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

@endsection

@section('javascript')

   <script>
       function exportF(elem) {
          var table = document.getElementById("table");
          var html = table.outerHTML;
          var url = 'data:application/vnd.ms-excel,' + escape(html); // Set your html table into url 
          elem.setAttribute("href", url);
          elem.setAttribute("download", "export.xls"); // Choose the file name
          return false;
        }
    $('#datepicker, #datepicker1').datepicker({  format: 'yyyy-mm-dd' });
   </script>
@endsection