<div class="modal-dialog" role="document">
  <div class="modal-content">
    {!! Form::open(['url' => action('ReceiveBalanceBankController@update', [$rb_bank->id]), 'method' => 'PUT', 'id' => 'receive_balance_bank_add_form' ]) !!}
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title">Update Receive Balance From Bank</h4>
    </div>
    <div class="modal-body">
      <div class="form-group">
          <select name="bank_user_id" class="form-control">
            @foreach($banks as $bank)
              <option value="{{ $bank->id}}" {{ $rb_bank->bank_user_id == $bank->id ? 'selected' :''}} >{{$bank->name. ' - '.$bank->branch}}</option>
            @endforeach
          </select>
      </div>


      <div class="form-group">
        {!! Form::label('amount', __( 'expense.amount' ) . ':') !!}
        {!! Form::text('amount', $rb_bank->amount, ['class' => 'form-control', 'placeholder' => __( 'expense.amount' )]); !!}
      </div>

      <div class="form-group">
        {!! Form::label('purpose', __( 'Purpose' ) . ':*') !!}
        {!! Form::text('purpose', $rb_bank->purpose, ['class' => 'form-control', 'required', 'placeholder' => __( 'Purpose' )]); !!}
      </div>
      <div class="form-group">
        <input type="hidden" name="receiver" id="receiver" value={{auth()->user()->id}}>
      </div>
    </div>
    <div class="modal-footer">
      <button type="submit" class="btn btn-primary">@lang( 'messages.save' )</button>
      <button type="button" class="btn btn-default" data-dismiss="modal">@lang( 'messages.close' )</button>
    </div>
    {!! Form::close() !!}
  </div>
</div>