<div class="modal-dialog" role="document">
  <div class="modal-content">
    {!! Form::open(['url' => action('ReceiveBalanceBankController@store'), 'method' => 'post', 'id' => 'receive_balance_bank_add_form' ]) !!}
    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title">Receive Balance From Bank</h4>
    </div>
    <div class="modal-body">
      <div class="form-group">
          <select name="bank_user_id" class="form-control">
            @foreach($banks as $bank)
              <option value="{{ $bank->id}}" >{{$bank->name. ' - '.$bank->branch}}</option>
            @endforeach
          </select>
      </div>


      <div class="form-group">
        {!! Form::label('amount', __( 'expense.amount' ) . ':') !!}
        {!! Form::text('amount', null, ['class' => 'form-control', 'placeholder' => __( 'expense.amount' )]); !!}
      </div>

      <div class="form-group">
        {!! Form::label('purpose', __( 'Purpose' ) . ':*') !!}
        {!! Form::text('purpose', null, ['class' => 'form-control', 'required', 'placeholder' => __( 'Purpose' )]); !!}
      </div>


      <div class="form-group">
        <input type="hidden" name="receiver" id="receiver" value={{auth()->user()->id}}>
      </div>
    </div>
    <div class="modal-footer">
      <button type="submit" class="btn btn-primary">@lang( 'messages.save' )</button>
      <button type="button" class="btn btn-default" data-dismiss="modal">@lang( 'messages.close' )</button>
    </div>
    {!! Form::close() !!}
  </div>
</div>