@extends('layouts.app')
@section('title', __('Installment Payable'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Customer
        <small>Installment Payable</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
	<div class="box">
        <div class="box-body">
            @if(auth()->user()->can('supplier.view') || auth()->user()->can('customer.view'))
                <div class="table-responsive">
            	<table class="table table-bordered table-striped">
            		<thead>
            			<tr>
                            <th>@lang('user.name')</th>
                            <th>@lang('business.address')</th>
                            <th>@lang('contact.contact')</th>
                            <th>Total Payable Amount</th>
                            <th>@lang('messages.action')</th>
            			</tr>
            		</thead>
            		
            		<tbody>
            		    @foreach($contacts as $item)
            		        <tr>
            		            <td>{{ $item->name}}</td>
            		            <td>{{ $item->city.' '.$item->state,' '.$item->country.' '.$item->landmark}}</td>
            		            <td>{{ $item->mobile}}</td>
            		            <td>{{ $item->total_amount}}</td>
            		            <td>
            		                <a class="btn btn-sm btn-primary" href="{{action('ContactController@show',[$item->id])}}">View</a>
            		                
            		                @if($item->total_sms >0)
            		                <a class="btn btn-sm btn-info" href="{{action('ContactController@customerSendSms',[$item->id])}}"><i class="fa fa-envelope"></i> Send SMS</a>
            		                @endif
            		            </td>
            		        </tr>
            		    
            		    @endforeach
            		</tbody>
                    <tfoot>
                        <tr class="bg-gray font-17 text-center footer-total">
                            <th colspan="3">Total</th>
                            <th>{{ number_format($contacts->sum('total_amount'), 2)}}</th>
                        </tr>
                    </tfoot>
            	</table>
                </div>
            @endif
        </div>
    </div>

</section>
<!-- /.content -->

@endsection
